/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.apps.wm.IWmRecommendpicService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.work.shield.ProtectEquipIssueRecordDetailMapper;
import cn.smarthse.modules.health.dao.work.shield.ProtectEquipIssueRecordMapper;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecordDetail;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import cn.smarthse.modules.health.entity.work.shield.vo.ProtectQuery;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ProtectEquipIssueRecordServiceImpl
extends BaseServiceImpl<ProtectEquipIssueRecordMapper, ProtectEquipIssueRecord>
implements IProtectEquipIssueRecordService {
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    IProtectEquipIssueRecordDetailService recordDetailService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    ICheckResultService checkResultService;
    @DubboReference
    IRiskExposeEvaluateService exposeEvaluateService;
    @DubboReference
    IRiskExposeEvaluateDataService exposeEvaluateDataService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0")
    IWmRecommendpicService wmRecommendpicService;
    @Autowired
    IProtectListService protectListService;
    @DubboReference
    IKeyFactoryService keyFactoryService;
    @DubboReference
    IKeyFactoryApprovalHistoryService historyService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IBusinessDataUpdateRefreshService refreshService;
    private static final String protectListKey = "protectList";

    public List<ProtectEquipIssueRecord> getListIssueRecordBySearchModel(ProtectEquipIssueRecord searchModel) {
        return ((ProtectEquipIssueRecordMapper)this.dao).getListIssueRecordBySearchMode(searchModel);
    }

    public PageInfo<ProtectEquipIssueRecord> getPagesIssueRecordBySearchModel(JqGridParam jqGridParam, ProtectEquipIssueRecord searchModel) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ProtectEquipIssueRecord> list = this.getListIssueRecordBySearchModel(searchModel);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Integer deleteByIds(List<Long> ids, Long loginStaffId) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        ArrayList<ProtectEquipIssueRecord> list = new ArrayList<ProtectEquipIssueRecord>();
        for (Long id : ids) {
            ProtectEquipIssueRecord record = new ProtectEquipIssueRecord();
            record.setId(id);
            record.setUpdateDate(new Date());
            record.setUpdateBy(loginStaffId);
            record.setIsValid(Boolean.valueOf(false));
            list.add(record);
        }
        int i = this.batchUpdateOrInsert(list, ProtectEquipIssueRecordMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item), 1000);
        this.recordDetailService.deleteByEquipIssueRecordIds(ids, loginStaffId);
        return i;
    }

    @Transactional(readOnly=false)
    public Integer deleteByIds(List<Long> ids) {
        int i = ((ProtectEquipIssueRecordMapper)this.dao).deleteByIds(ids.toString());
        this.recordDetailService.deleteByEquipIssueRecordIds(ids);
        return i;
    }

    @Transactional(readOnly=false)
    public ProtectEquipIssueRecord cloneRecord(Long id, Long loginStaffId) {
        ProtectEquipIssueRecord oldRecord = (ProtectEquipIssueRecord)this.getById(id);
        if (oldRecord == null) {
            throw new ServiceException("\u672a\u627e\u5230\u8bbe\u5907\u53d1\u653e\u8bb0\u5f55");
        }
        Example e = new Example(ProtectEquipIssueRecordDetail.class);
        e.createCriteria().andEqualTo("equipIssueRecordId", (Object)oldRecord.getId()).andEqualTo("isValid", (Object)true);
        List recordDetailList = this.recordDetailService.getListByExample(e);
        oldRecord.setId(null);
        oldRecord.setReportState(Integer.valueOf(1));
        oldRecord.setIssuedTime(null);
        oldRecord.setIssuedBy(null);
        oldRecord.setCredentialFileId(null);
        if (StringUtils.isNotBlank((CharSequence)oldRecord.getFactorNames())) {
            oldRecord.setFactorNames(oldRecord.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        ProtectEquipIssueRecord newRecord = this.add(oldRecord, loginStaffId, null);
        if (CollectionUtils.isNotEmpty((Collection)recordDetailList)) {
            for (ProtectEquipIssueRecordDetail o : recordDetailList) {
                if (StringUtils.isNotBlank((CharSequence)o.getFactorNames())) {
                    o.setFactorNames(o.getFactorNames().replaceAll("[\t\n\r]", ""));
                }
                o.setId(Long.valueOf(this.idworker.nextId()));
                o.setEquipIssueRecordId(newRecord.getId());
                o.setIsCheckGenerate(Boolean.valueOf(false));
                o.setCheckId(null);
                o.setUpdateBy(loginStaffId);
                o.setUpdateDate(new Date());
            }
            this.recordDetailService.batchUpdateOrInsert(recordDetailList, ProtectEquipIssueRecordDetailMapper.class, (item, mapper) -> mapper.insert(item), 1000);
            newRecord.setRecordDetailList(recordDetailList);
        }
        if (newRecord == null) {
            throw new ServiceException("\u514b\u9686\u6570\u636e\u4e3a\u7a7a");
        }
        return newRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public ProtectEquipIssueRecord saveOrSubmitRecord(ProtectEquipIssueRecord needUpdateData, Integer changeState) {
        ProtectEquipIssueRecord temp;
        Long updateBy = needUpdateData.getUpdateBy();
        ProtectEquipIssueRecord old = (ProtectEquipIssueRecord)this.getById(needUpdateData.getId());
        if (old == null) {
            throw new ServiceException("\u672a\u627e\u5230\u6570\u636e");
        }
        if (changeState == 2 && changeState.equals(old.getReportState())) {
            throw new ServiceException("\u91cd\u590d\u63d0\u4ea4");
        }
        if (old.getReportType() == 1 && (temp = this.getRecordFactorAndEquip(old.getId())) != null) {
            needUpdateData.setFactorIds(temp.getFactorIds());
            if (StringUtils.isNotBlank((CharSequence)temp.getFactorNames())) {
                needUpdateData.setFactorNames(temp.getFactorNames().replaceAll("[\t\n\r]", ""));
            }
            needUpdateData.setEquipIds(temp.getEquipIds());
            if (StringUtils.isNotBlank((CharSequence)temp.getEquipNames())) {
                needUpdateData.setEquipNames(temp.getEquipNames().replaceAll("[\t\n\r]", ""));
            }
        }
        needUpdateData.setReportState(changeState);
        RLock lock = this.redissonClient.getLock("keyFactor:ProtectEquipIssueRecord:" + needUpdateData.getId() + ":hot");
        if (lock.tryLock()) {
            try {
                if (changeState == 1) {
                    int n = ((ProtectEquipIssueRecordMapper)this.dao).updateByPrimaryKeySelective(needUpdateData);
                }
                if (changeState != 2) return needUpdateData;
                Long keyFactoryId = this.submit(old, needUpdateData, updateBy);
                needUpdateData.setKeyFactoryId(keyFactoryId);
                int i = ((ProtectEquipIssueRecordMapper)this.dao).updateByPrimaryKeySelective(needUpdateData);
                this.reformItemBasicService.changeStatusByCidAndGenerationSource(old.getCid(), ReformGenerationSourceEnum.PROTECTION.getValue(), null, updateBy, null);
                return needUpdateData;
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        } else {
            this.logger.error("\u672a\u83b7\u5f97\u9501\u8d44\u6e90keyFactor:ProtectEquipIssueRecord id:{}", (Object)needUpdateData.getId());
            return null;
        }
    }

    public Long submit(ProtectEquipIssueRecord old, ProtectEquipIssueRecord needUpdateData, Long updateBy) {
        Long keyFactoryId;
        KeyFactoryApprovalHistory history = new KeyFactoryApprovalHistory();
        history.setCid(old.getCid());
        history.setOperatorCompanyName(needUpdateData.getCompanyName());
        history.setOperator(needUpdateData.getUpdateByStr());
        history.setBusinessId(old.getId());
        history.setUpdateBy(updateBy);
        history.setCreateBy(updateBy);
        history.setType(KeyFactoryTypeEnum.PROTECTIVE.getCode());
        history.setStatus(HistoryStatusEnum.SUBMIT.getCode());
        this.historyService.addRecord(Collections.singletonList(history));
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(old.getCid());
        Company company = new Company();
        BeanUtils.copyProperties((Object)companyBaseInfoModel, (Object)company);
        company.setId(companyBaseInfoModel.getCid());
        if (old.getReportType() == 1) {
            keyFactoryId = this.keyFactoryService.submitNotNeedAudit(company, updateBy, old.getId(), KeyFactoryTypeEnum.PROTECTIVE);
            needUpdateData.setReportState(Integer.valueOf(5));
            history.setStatus(HistoryStatusEnum.PASS.getCode());
            this.historyService.addRecord(Collections.singletonList(history));
            if (needUpdateData.getIssuedTime() != null) {
                old.setIssuedTime(needUpdateData.getIssuedTime());
            }
        } else {
            keyFactoryId = this.keyFactoryService.submitKeyFactory(company, updateBy, old.getId(), KeyFactoryTypeEnum.PROTECTIVE);
        }
        return keyFactoryId;
    }

    public ProtectEquipIssueRecord getRecordFactorAndEquip(Long id) {
        if (id == null) {
            return null;
        }
        ProtectEquipIssueRecord record = new ProtectEquipIssueRecord();
        List recordDetailList = this.recordDetailService.getRecordDetailListByRecordId(id);
        if (CollectionUtils.isNotEmpty((Collection)recordDetailList)) {
            String s;
            Map harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
            Map equipIdAndName = (Map)this.redisClient.get(protectListKey, "getList", 86400L, () -> this.protectListService.getList(new ProtectQuery()).stream().distinct().collect(Collectors.toMap(ProtectList::getId, ProtectList::getProName, (v1, v2) -> v2)), (TypeReference)new TypeReference<Map<Long, String>>(){});
            StringBuilder factorStrIds = new StringBuilder();
            StringBuilder equipStrIds = new StringBuilder();
            for (ProtectEquipIssueRecordDetail detail : recordDetailList) {
                if (detail != null && StringUtils.isNotBlank((CharSequence)detail.getFactorIds())) {
                    if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                        factorStrIds.append(",").append(detail.getFactorIds());
                    } else {
                        factorStrIds.append(detail.getFactorIds());
                    }
                }
                if (detail == null || !StringUtils.isNotBlank((CharSequence)detail.getEquipIds())) continue;
                if (StringUtils.isNotBlank((CharSequence)equipStrIds.toString())) {
                    equipStrIds.append(",").append(detail.getEquipIds());
                    continue;
                }
                equipStrIds.append(detail.getEquipIds());
            }
            if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                List factorIds = Arrays.stream(factorStrIds.toString().split(",")).distinct().collect(Collectors.toList());
                record.setFactorIds(String.join((CharSequence)",", factorIds));
                boolean refresh = true;
                StringBuilder factorStrNames = new StringBuilder();
                for (Object item : factorIds) {
                    s = (String)harmIdAndName.get(item);
                    if (StringUtils.isBlank((CharSequence)s) && refresh) {
                        this.redisClient.delPrefix("HarmFactorServiceImpl");
                        harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
                        s = (String)harmIdAndName.get(item);
                        refresh = false;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    if (StringUtils.isNotBlank((CharSequence)factorStrNames.toString())) {
                        factorStrNames.append(",").append(s.replaceAll("[\t\n\r]", ""));
                        continue;
                    }
                    factorStrNames.append(s.replaceAll("[\t\n\r]", ""));
                }
                record.setFactorNames(factorStrNames.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)equipStrIds.toString())) {
                List equipIds = Arrays.stream(equipStrIds.toString().split(",")).distinct().collect(Collectors.toList());
                record.setEquipIds(String.join((CharSequence)",", equipIds));
                StringBuilder equipStrNames = new StringBuilder();
                List equipIdsInt = equipIds.parallelStream().map(Long::valueOf).collect(Collectors.toList());
                for (Object item : equipIdsInt) {
                    s = (String)equipIdAndName.get(item);
                    if (StringUtils.isBlank((CharSequence)s)) {
                        this.redisClient.del(new String[]{"protectList:getList"});
                        equipIdAndName = (Map)this.redisClient.get(protectListKey, "getList", 86400L, () -> this.protectListService.getList(new ProtectQuery()).stream().distinct().collect(Collectors.toMap(ProtectList::getId, ProtectList::getProName, (v1, v2) -> v2)));
                        s = (String)equipIdAndName.get(item);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    if (StringUtils.isNotBlank((CharSequence)equipStrNames.toString())) {
                        equipStrNames.append(",").append(s.replaceAll("[\t\n\r]", ""));
                        continue;
                    }
                    equipStrNames.append(s.replaceAll("[\t\n\r]", ""));
                }
                record.setEquipNames(equipStrNames.toString());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)record.getFactorIds()) || StringUtils.isNotBlank((CharSequence)record.getEquipIds())) {
            return record;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public Integer changeRecordReportType(Long id, Integer reportType, Long loginStaffId) {
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.getById(id);
        if (record == null || reportType == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        if (record.getReportType().equals(reportType)) {
            throw new ServiceException("\u91cd\u590d\u64cd\u4f5c");
        }
        ProtectEquipIssueRecord recordNew = new ProtectEquipIssueRecord();
        recordNew.setId(record.getId());
        recordNew.setCid(record.getCid());
        recordNew.setReportType(reportType);
        recordNew.setReportState(Integer.valueOf(1));
        recordNew.setUpdateBy(loginStaffId);
        recordNew.setUpdateDate(new Date());
        int i = ((ProtectEquipIssueRecordMapper)this.dao).updateByPrimaryKeySelective(recordNew);
        return i;
    }

    public List<Integer> getAllRecordYearBySearch(Long cid) {
        return ((ProtectEquipIssueRecordMapper)this.dao).getAllRecordYearBySearch(cid);
    }

    @Transactional
    public ProtectEquipIssueRecord addRecordByCheck(ProtectEquipIssueRecord param) {
        if (param == null || param.getCid() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        ProtectEquipIssueRecord issueRecord = this.add(param);
        return this.generateRecordDetailByCheck(issueRecord);
    }

    public ProtectEquipIssueRecord generateRecordDetailByCheck(ProtectEquipIssueRecord issueRecord) {
        List dataList;
        List lastEv = this.exposeEvaluateService.getLastEv(new EvQueryParam().setCid(issueRecord.getCid()));
        if (CollectionUtils.isNotEmpty((Collection)lastEv) && ((RiskExposeEvaluate)lastEv.get(0)).getId() != null && CollectionUtils.isNotEmpty((Collection)(dataList = this.exposeEvaluateDataService.getRiskDataByShopAndNameGroup(((RiskExposeEvaluate)lastEv.get(0)).getId())))) {
            RiskExposeEvaluateData data;
            ArrayList<ProtectEquipIssueRecordDetail> recordDetailList = new ArrayList<ProtectEquipIssueRecordDetail>();
            StringBuilder factorStrIds = new StringBuilder();
            Iterator iterator = dataList.iterator();
            while (iterator.hasNext() && (data = (RiskExposeEvaluateData)iterator.next()) != null) {
                ProtectEquipIssueRecordDetail recordDetail = new ProtectEquipIssueRecordDetail();
                recordDetail.setEquipIssueRecordId(issueRecord.getId());
                if (StringUtils.isNotBlank((CharSequence)data.getWorkshop())) {
                    recordDetail.setWorkshop(data.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
                }
                if (StringUtils.isNotBlank((CharSequence)data.getWorkName())) {
                    recordDetail.setWorkName(data.getWorkName().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
                }
                recordDetail.setFactorIds(data.getFactorId());
                recordDetail.setFactorNames(data.getFactorName().replaceAll(" ", "_"));
                if (StringUtils.isNotBlank((CharSequence)data.getFactorName())) {
                    recordDetail.setFactorNames(data.getFactorName().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
                }
                recordDetail.setIsCheckGenerate(Boolean.valueOf(true));
                recordDetail.setCheckId(((RiskExposeEvaluate)lastEv.get(0)).getId());
                recordDetail.setCreateBy(issueRecord.getCreateBy());
                recordDetail.setUpdateBy(issueRecord.getCreateBy());
                recordDetail.setUpdateDate(new Date());
                recordDetail.setCreateDate(new Date());
                recordDetail.setIsValid(Boolean.valueOf(true));
                recordDetailList.add(recordDetail);
                if (!StringUtils.isNotBlank((CharSequence)data.getFactorId())) continue;
                if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                    factorStrIds.append(",").append(data.getFactorId());
                    continue;
                }
                factorStrIds.append(data.getFactorId());
            }
            this.recordDetailService.batchUpdateOrInsert(recordDetailList, ProtectEquipIssueRecordDetailMapper.class, (item, mapper) -> mapper.insert(item), 1000);
            ProtectEquipIssueRecord temp = new ProtectEquipIssueRecord();
            temp.setId(issueRecord.getId());
            List collect = Arrays.stream(factorStrIds.toString().split(",")).distinct().collect(Collectors.toList());
            temp.setFactorIds(String.join((CharSequence)",", collect));
            Map harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
            boolean refresh = true;
            StringBuilder factorStrNames = new StringBuilder();
            for (String item2 : collect) {
                String s = (String)harmIdAndName.get(item2);
                if (StringUtils.isBlank((CharSequence)s) && refresh) {
                    this.redisClient.delPrefix("HarmFactorServiceImpl");
                    harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
                    s = (String)harmIdAndName.get(item2);
                    refresh = false;
                }
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                if (StringUtils.isNotBlank((CharSequence)factorStrNames.toString())) {
                    factorStrNames.append(",").append(s);
                    continue;
                }
                factorStrNames.append(s);
            }
            temp.setFactorNames(factorStrNames.toString());
            ((ProtectEquipIssueRecordMapper)this.dao).updateByPrimaryKeySelective(temp);
            issueRecord.setFactorIds(String.join((CharSequence)",", collect));
        }
        return issueRecord;
    }

    @Transactional(rollbackFor={Exception.class})
    public int approval(KeyFactory keyFactory, Byte status) {
        status = Objects.equals(status, ApprovalStatusEnum.PASSED.getValue()) ? Byte.valueOf((byte)4) : Byte.valueOf((byte)3);
        if (keyFactory != null && keyFactory.getBusinessId() != null && KeyFactoryTypeEnum.PROTECTIVE.getCode().equals(keyFactory.getType())) {
            ProtectEquipIssueRecord issueRecord = new ProtectEquipIssueRecord();
            issueRecord.setReportState(Integer.valueOf(status.byteValue()));
            issueRecord.setUpdateBy(keyFactory.getUpdateBy());
            issueRecord.setUpdateDate(new Date());
            Example example = new Example(ProtectEquipIssueRecord.class);
            example.createCriteria().andEqualTo("id", (Object)keyFactory.getBusinessId()).andNotEqualTo("reportState", (Object)status);
            int i = ((ProtectEquipIssueRecordMapper)this.dao).updateByExampleSelective(issueRecord, example);
            if (status.equals((byte)4)) {
                this.refreshService.addBusinessDataUpdateMsg(keyFactory.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            }
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(keyFactory.getCid(), ReformGenerationSourceEnum.PROTECTION.getValue(), null, keyFactory.getUpdateBy(), keyFactory.getBusinessId());
            return i;
        }
        return 0;
    }

    public List<ProtectEquipIssueRecord> getFullData(ProtectEquipIssueRecord searchModel) {
        return ((ProtectEquipIssueRecordMapper)this.dao).getFullData(searchModel);
    }

    public Integer getLastTwoYearsCompletedNum(Long cid) {
        if (cid == null) {
            return null;
        }
        return ((ProtectEquipIssueRecordMapper)this.dao).getLastTwoYearsCompletedNum(cid);
    }

    public String verifyData(ProtectEquipIssueRecord searchModel) {
        if (searchModel == null) {
            return "\u6ca1\u6709\u53c2\u6570\u6570\u636e";
        }
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.getById(searchModel.getId());
        if (record == null) {
            return "\u6ca1\u6709\u8be5\u6570\u636e";
        }
        if (record.getReportType().equals(1)) {
            boolean b;
            List detailList = this.recordDetailService.getRecordDetailListByRecordId(searchModel.getId());
            if (CollectionUtils.isEmpty((Collection)detailList)) {
                return "\u5b8c\u6574\u586b\u62a5\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u6761\u6570\u636e";
            }
            if (CollectionUtils.isNotEmpty((Collection)detailList) && (b = detailList.parallelStream().anyMatch(item -> StringUtils.isBlank((CharSequence)item.getEquipIds())))) {
                return "\u9632\u62a4\u7528\u54c1\u79cd\u7c7b\u5fc5\u586b\u9879\u672a\u586b\u5199";
            }
        }
        return "\u6210\u529f";
    }

    @Transactional
    public Long setTermination(ProtectEquipIssueRecord record, Long loginStaffId, Company currentCompany) {
        if (record == null || record.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        ProtectEquipIssueRecord oldRecord = (ProtectEquipIssueRecord)this.getById(record.getId());
        if (oldRecord == null) {
            throw new ServiceException("\u6ca1\u6709\u8be5\u6570\u636e");
        }
        if (!oldRecord.getReportState().equals(3)) {
            throw new ServiceException("\u975e\u9000\u56de\u72b6\u6001\u4e0b\uff0c\u4e0d\u53ef\u4ee5\u7ec8\u6b62");
        }
        oldRecord.setReportState(Integer.valueOf(6));
        this.updateByPrimaryKey(oldRecord, loginStaffId);
        KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(record.getId());
        keyFactory.setStatus(KeyFactoryStatusEnum.CLOSED.getCode());
        this.keyFactoryService.updateByPrimaryKey((Object)keyFactory, loginStaffId);
        KeyFactoryApprovalHistory history = new KeyFactoryApprovalHistory();
        history.setCid(oldRecord.getCid());
        history.setOperatorCompanyName(currentCompany.getName());
        history.setOperator(currentCompany.getName());
        history.setBusinessId(oldRecord.getId());
        history.setUpdateBy(loginStaffId);
        history.setCreateBy(loginStaffId);
        history.setType(KeyFactoryTypeEnum.PROTECTIVE.getCode());
        history.setStatus(HistoryStatusEnum.CLOSED.getCode());
        this.historyService.addRecord(Collections.singletonList(history));
        return keyFactory.getId();
    }

    public List<ProtectEquipIssueRecord> getProtectNum(List<Long> cidList, List<Integer> reportStatelist, Map<String, Object> param) {
        int year = DateUtils.getYear((Date)new Date()) - 1;
        Example example = new Example(ProtectEquipIssueRecord.class);
        example.createCriteria().andIn("cid", cidList).andEqualTo("isValid", (Object)true).andIn("reportState", reportStatelist).andCondition("year(issued_time) >= " + year);
        example.selectProperties(new String[]{"id", "cid"});
        return this.getListByExample(example);
    }
}

