/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.shield;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.shield.ProtectEquipIssueRecordDetailMapper;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecordDetail;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.vo.archive.Doc4042WorkRoleHarmFactorShieldEquipVO;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ProtectEquipIssueRecordDetailServiceImpl
extends BaseServiceImpl<ProtectEquipIssueRecordDetailMapper, ProtectEquipIssueRecordDetail>
implements IProtectEquipIssueRecordDetailService {
    @Autowired
    IProtectEquipIssueRecordService equipIssueRecordService;

    @Transactional(readOnly=false)
    public ProtectEquipIssueRecordDetail addOrUpdate(ProtectEquipIssueRecordDetail recordDetail, Long loginStaffId) {
        ProtectEquipIssueRecordDetail detail;
        if (recordDetail.getId() == null) {
            recordDetail.setIsCheckGenerate(Boolean.valueOf(false));
            recordDetail.setCheckId(null);
            if (StringUtils.isNotBlank((CharSequence)recordDetail.getWorkshop())) {
                recordDetail.setWorkshop(recordDetail.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)recordDetail.getWorkName())) {
                recordDetail.setWorkName(recordDetail.getWorkName().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            detail = this.add(recordDetail, loginStaffId, null);
        } else {
            recordDetail.setUpdateDate(new Date());
            recordDetail.setUpdateBy(loginStaffId);
            if (StringUtils.isNotBlank((CharSequence)recordDetail.getWorkshop())) {
                recordDetail.setWorkshop(recordDetail.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)recordDetail.getWorkName())) {
                recordDetail.setWorkName(recordDetail.getWorkName().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            ((ProtectEquipIssueRecordDetailMapper)this.dao).updateByPrimaryKeySelective(recordDetail);
            detail = recordDetail;
        }
        return detail;
    }

    public List<ProtectEquipIssueRecordDetail> getRecordDetailListByRecordId(Long id) {
        Example example = new Example(ProtectEquipIssueRecordDetail.class);
        example.createCriteria().andEqualTo("equipIssueRecordId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    public List<ProtectEquipIssueRecordDetail> getRecordDetailListBySearchModel(ProtectEquipIssueRecordDetail searchModel) {
        List<ProtectEquipIssueRecordDetail> list = ((ProtectEquipIssueRecordDetailMapper)this.dao).getRecordDetailListBySearchModel(searchModel);
        for (ProtectEquipIssueRecordDetail detail : list) {
            if (detail != null && StringUtils.isNotBlank((CharSequence)detail.getWorkshop())) {
                detail.setWorkshop(detail.getWorkshop().trim().replaceAll(" ", "_"));
            }
            if (detail == null || !StringUtils.isNotBlank((CharSequence)detail.getWorkName())) continue;
            detail.setWorkName(detail.getWorkName().trim().replaceAll(" ", "_"));
        }
        return list;
    }

    public PageInfo<ProtectEquipIssueRecordDetail> getPageRecordDetailListBySearchModel(JqGridParam jqGridParam, ProtectEquipIssueRecordDetail searchModel) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ProtectEquipIssueRecordDetail> list = this.getRecordDetailListBySearchModel(searchModel);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Integer deleteByEquipIssueRecordIds(List<Long> equipIssueRecordIds, Long loginStaffId) {
        ProtectEquipIssueRecordDetail record = new ProtectEquipIssueRecordDetail();
        record.setUpdateDate(new Date());
        record.setUpdateBy(loginStaffId);
        record.setIsValid(Boolean.valueOf(false));
        Example e = new Example(ProtectEquipIssueRecordDetail.class);
        e.createCriteria().andIn("equipIssueRecordId", equipIssueRecordIds);
        int i = ((ProtectEquipIssueRecordDetailMapper)this.dao).updateByExampleSelective(record, e);
        return i;
    }

    @Transactional(readOnly=false)
    public Integer deleteByEquipIssueRecordIds(List<Long> equipIssueRecordIds) {
        Example e = new Example(ProtectEquipIssueRecordDetail.class);
        e.createCriteria().andIn("equipIssueRecordId", equipIssueRecordIds);
        return ((ProtectEquipIssueRecordDetailMapper)this.dao).deleteByExample(e);
    }

    public List<ProtectEquipIssueRecord> getDataTypeForArchive(ProtectEquipIssueRecord param) {
        return ((ProtectEquipIssueRecordDetailMapper)this.dao).getDataTypeForArchive(param);
    }

    public List<Doc4042WorkRoleHarmFactorShieldEquipVO> getDataListForArchive(Long equipIssueRecordId) {
        return ((ProtectEquipIssueRecordDetailMapper)this.dao).getDataListForArchive(equipIssueRecordId);
    }
}

