/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.servicedemand;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.servicedemand.ServiceDemandHarmMapper;
import cn.smarthse.modules.health.entity.work.servicedemand.ServiceDemandHarm;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ServiceDemandHarmServiceImpl
extends BaseServiceImpl<ServiceDemandHarmMapper, ServiceDemandHarm>
implements IServiceDemandHarmService {
    @Transactional(readOnly=false)
    public void addBatch(List<ServiceDemandHarm> collect) {
        ((ServiceDemandHarmMapper)this.dao).insertList(collect);
    }

    @Transactional(readOnly=false)
    public void addBatch(String harmIds, Long serviceDemanId, Long loginStaffId) {
        ((ServiceDemandHarmMapper)this.dao).insertList(Arrays.stream(harmIds.split(",")).map(s -> {
            ServiceDemandHarm sdh = new ServiceDemandHarm();
            sdh.setServiceDemandId(serviceDemanId);
            sdh.setHarmId(Long.valueOf(s));
            sdh.setIsValid(Boolean.valueOf(true));
            sdh.setCreateBy(loginStaffId);
            sdh.setUpdateBy(loginStaffId);
            sdh.setCreateDate(new Date());
            sdh.setUpdateDate(new Date());
            return sdh;
        }).collect(Collectors.toList()));
    }

    public String getHarmIdsByServiceDemanId(Long serviceDemanId) {
        Example e = new Example(ServiceDemandHarm.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("serviceDemandId", (Object)serviceDemanId);
        return this.getListByExample(e).stream().map(s -> "" + s.getHarmId()).collect(Collectors.joining(","));
    }

    @Transactional(readOnly=false)
    public void deleteByServiceDemandId(Long serviceDemanId) {
        Example e = new Example(ServiceDemandHarm.class);
        e.createCriteria().andEqualTo("serviceDemandId", (Object)serviceDemanId);
        ServiceDemandHarm sdh = new ServiceDemandHarm();
        sdh.setIsValid(Boolean.valueOf(false));
        ((ServiceDemandHarmMapper)this.dao).updateByExample(sdh, e);
    }
}

