/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.servicedemand;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.servicedemand.HealthCheckServiceDemandMapper;
import cn.smarthse.modules.health.entity.work.servicedemand.HealthCheckServiceDemand;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HealthCheckServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.ServiceDemandStatVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.ThirdServiceDemandVo;
import cn.smarthse.modules.health.enums.servicedemand.CheckTypeEnum;
import cn.smarthse.modules.health.enums.servicedemand.ServiceDemandTypeEnum;
import cn.smarthse.modules.health.service.work.servicedemand.IEducationTrainServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IEvaluateWorkServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHarmInspectServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHealthCheckServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HealthCheckServiceDemandServiceImpl
extends BaseServiceImpl<HealthCheckServiceDemandMapper, HealthCheckServiceDemand>
implements IHealthCheckServiceDemandService {
    @Autowired
    private IServiceDemandHarmService serviceDemandHarmService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @Autowired
    private IEducationTrainServiceDemandService educationTrainServiceDemandService;
    @Autowired
    private IEvaluateWorkServiceDemandService evaluateWorkServiceDemandService;
    @Autowired
    private IHarmInspectServiceDemandService harmInspectServiceDemandService;

    public ServiceDemandStatVo getServiceDemandStatVoByYear(Long cid, Integer year) {
        ServiceDemandStatVo vo = new ServiceDemandStatVo();
        vo.setDraftCount(this.getServiceDemandStatVoByStateAndYear((byte)1, cid, year));
        vo.setPublishCount(this.getServiceDemandStatVoByStateAndYear((byte)2, cid, year));
        vo.setOffShelvesCount(this.getServiceDemandStatVoByStateAndYear((byte)3, cid, year));
        return vo;
    }

    @Transactional(readOnly=false)
    public void addHealthCheckServiceDemand(HealthCheckServiceDemandVo vo, Long loginStaffId) {
        HealthCheckServiceDemand hcd;
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        if ((hcd = (HealthCheckServiceDemand)this.add(vo, loginStaffId, vo.getCid())) != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), hcd.getId(), loginStaffId);
        }
    }

    public PageInfo<HealthCheckServiceDemandVo> listCheckData(JqGridParam param, Integer year, Byte state) {
        Example e = new Example(HealthCheckServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.getListByExample(e);
        return new PageInfo(list.stream().map(s -> {
            AreaModel am;
            HealthCheckServiceDemandVo vo = new HealthCheckServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            if (vo.getCheckBeginDate() != null && vo.getCheckEndDate() != null) {
                vo.setCheckTime(DateUtils.formatCheckTime((Date)vo.getCheckBeginDate(), (Date)vo.getCheckEndDate(), (String)"\u81f3"));
            }
            if (StringUtils.isNotEmpty((String)vo.getCheckType())) {
                vo.setCheckTypeName(Arrays.stream(vo.getCheckType().split(",")).map(ss -> CheckTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(ss)).getName()).collect(Collectors.joining(",")));
            }
            vo.setLocationName("");
            if (vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
                vo.setLocationName(vo.getLocationName() + am.getFullname());
            }
            if (StringUtils.isNotEmpty((String)vo.getLocationDetail())) {
                vo.setLocationName(vo.getLocationName() + vo.getLocationDetail());
            }
            return vo;
        }).collect(Collectors.toList()));
    }

    public HealthCheckServiceDemandVo getVoById(Long id) {
        HealthCheckServiceDemand etsd = (HealthCheckServiceDemand)this.getById(id);
        HealthCheckServiceDemandVo vo = new HealthCheckServiceDemandVo();
        BeanUtils.copyProperties((Object)etsd, (Object)vo);
        String harmIds = this.serviceDemandHarmService.getHarmIdsByServiceDemanId(id);
        if (StringUtils.isNotEmpty((String)harmIds)) {
            vo.setHarms(this.harmFactorService.getHarmByIds(harmIds));
            if (vo.getHarms() != null && vo.getHarms().size() > 0) {
                vo.setHarmNames(vo.getHarms().stream().map(s -> s.getNameCh()).collect(Collectors.joining(",")));
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getCheckType())) {
            vo.setCheckTypeName(Arrays.stream(vo.getCheckType().split(",")).map(ss -> CheckTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(ss)).getName()).collect(Collectors.joining(",")));
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void editHealthCheckServiceDemand(HealthCheckServiceDemandVo vo, Long loginStaffId) {
        if (vo.getId() == null) {
            return;
        }
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        this.update(vo, loginStaffId);
        this.serviceDemandHarmService.deleteByServiceDemandId(vo.getId());
        if (vo != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), vo.getId(), loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void deleteServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        HealthCheckServiceDemand d = new HealthCheckServiceDemand();
        d.setId(id);
        this.delete(d, loginUserId);
        this.serviceDemandHarmService.deleteByServiceDemandId(id);
    }

    @Transactional(readOnly=false)
    public void offShelvesServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        HealthCheckServiceDemand d = new HealthCheckServiceDemand();
        d.setId(id);
        d.setState(Byte.valueOf((byte)3));
        d.setOffShelvesDate(new Date());
        this.update(d, loginUserId);
    }

    public List<HealthCheckServiceDemandVo> getNoExpireList() {
        Example e = new Example(HealthCheckServiceDemand.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("checkBeginDate", (Object)Date.from(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant())).andEqualTo("state", (Object)2);
        e.or().andEqualTo("isValid", (Object)true).andEqualTo("specialDemand", (Object)1).andEqualTo("state", (Object)2);
        List list = this.getListByExample(e);
        return list.stream().map(s -> {
            HealthCheckServiceDemandVo vo = new HealthCheckServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThirdServiceDemandVo> getListByCid(Long loginStaffCompanyId) {
        List<Object> list = new ArrayList();
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList tasks = Lists.newArrayList();
        tasks.add(() -> this.getNoExpireList().stream().filter(s -> true).map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.check);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        tasks.add(() -> this.harmInspectServiceDemandService.getNoExpireList().stream().filter(s -> true).map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.inspect);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        tasks.add(() -> this.educationTrainServiceDemandService.getNoExpireList().stream().filter(s -> true).map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.education);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        tasks.add(() -> this.evaluateWorkServiceDemandService.getNoExpireList().stream().filter(s -> true).map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.evaluate);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        try {
            List futureList = executorService.invokeAll(tasks, 3000L, TimeUnit.MILLISECONDS);
            for (Future future : futureList) {
                list.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
        }
        list = list.stream().sorted(Comparator.comparing(ThirdServiceDemandVo::getPublishingDate).reversed()).collect(Collectors.toList());
        list.forEach(s -> {
            AreaModel am = this.sysAreaProvideService.getAreaById(s.getLocationAreaId());
            if (am != null) {
                s.setLocationName(am.getProvinceName() + "/" + am.getCityName());
            }
        });
        return list;
    }

    private Integer getServiceDemandStatVoByStateAndYear(Byte state, Long cid, Integer year) {
        Example e = new Example(HealthCheckServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        return this.getCountByExample(e);
    }
}

