/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.servicedemand;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.servicedemand.HarmInspectServiceDemandMapper;
import cn.smarthse.modules.health.entity.work.servicedemand.HarmInspectServiceDemand;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HarmInspectServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.ServiceDemandStatVo;
import cn.smarthse.modules.health.service.work.servicedemand.IHarmInspectServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HarmInspectServiceDemandServiceImpl
extends BaseServiceImpl<HarmInspectServiceDemandMapper, HarmInspectServiceDemand>
implements IHarmInspectServiceDemandService {
    @Autowired
    private IServiceDemandHarmService serviceDemandHarmService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;

    @Transactional(readOnly=false)
    public ServiceDemandStatVo getServiceDemandStatVoByYear(Long cid, Integer year) {
        ServiceDemandStatVo vo = new ServiceDemandStatVo();
        vo.setDraftCount(this.getServiceDemandStatVoByStateAndYear((byte)1, cid, year));
        vo.setPublishCount(this.getServiceDemandStatVoByStateAndYear((byte)2, cid, year));
        vo.setOffShelvesCount(this.getServiceDemandStatVoByStateAndYear((byte)3, cid, year));
        return vo;
    }

    @Transactional(readOnly=false)
    public void addHarmInspectServiceDemand(HarmInspectServiceDemandVo vo, Long loginStaffId) {
        HarmInspectServiceDemand hcd;
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        if ((hcd = (HarmInspectServiceDemand)this.add(vo, loginStaffId, vo.getCid())) != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), hcd.getId(), loginStaffId);
        }
    }

    public PageInfo<HarmInspectServiceDemandVo> listInspectData(JqGridParam param, Integer year, Byte state) {
        Example e = new Example(HarmInspectServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.getListByExample(e);
        return new PageInfo(list.stream().map(s -> {
            AreaModel am;
            HarmInspectServiceDemandVo vo = new HarmInspectServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            if (vo.getInspectBeginDate() != null && vo.getInspectEndDate() != null) {
                vo.setInspectTime(DateUtils.formatCheckTime((Date)vo.getInspectBeginDate(), (Date)vo.getInspectEndDate(), (String)"\u81f3"));
            }
            vo.setLocationName("");
            if (vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
                vo.setLocationName(vo.getLocationName() + am.getFullname());
            }
            if (StringUtils.isNotEmpty((String)vo.getLocationDetail())) {
                vo.setLocationName(vo.getLocationName() + vo.getLocationDetail());
            }
            return vo;
        }).collect(Collectors.toList()));
    }

    public HarmInspectServiceDemandVo getVoById(Long id) {
        HarmInspectServiceDemand etsd = (HarmInspectServiceDemand)this.getById(id);
        HarmInspectServiceDemandVo vo = new HarmInspectServiceDemandVo();
        BeanUtils.copyProperties((Object)etsd, (Object)vo);
        String harmIds = this.serviceDemandHarmService.getHarmIdsByServiceDemanId(id);
        if (StringUtils.isNotEmpty((String)harmIds)) {
            vo.setHarms(this.harmFactorService.getHarmByIds(harmIds));
            if (vo.getHarms() != null && vo.getHarms().size() > 0) {
                vo.setHarmNames(vo.getHarms().stream().map(s -> s.getNameCh()).collect(Collectors.joining(",")));
            }
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void editHarmInspectServiceDemand(HarmInspectServiceDemandVo vo, Long loginStaffId) {
        if (vo.getId() == null) {
            return;
        }
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        this.update(vo, loginStaffId);
        this.serviceDemandHarmService.deleteByServiceDemandId(vo.getId());
        if (vo != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), vo.getId(), loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void deleteServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        HarmInspectServiceDemand d = new HarmInspectServiceDemand();
        d.setId(id);
        this.delete(d, loginUserId);
        this.serviceDemandHarmService.deleteByServiceDemandId(id);
    }

    @Transactional(readOnly=false)
    public void offShelvesServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        HarmInspectServiceDemand d = new HarmInspectServiceDemand();
        d.setId(id);
        d.setState(Byte.valueOf((byte)3));
        d.setOffShelvesDate(new Date());
        this.update(d, loginUserId);
    }

    public List<HarmInspectServiceDemandVo> getNoExpireList() {
        Example e = new Example(HarmInspectServiceDemand.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("inspectBeginDate", (Object)Date.from(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant())).andEqualTo("state", (Object)2);
        e.or().andEqualTo("isValid", (Object)true).andEqualTo("specialDemand", (Object)1).andEqualTo("state", (Object)2);
        List list = this.getListByExample(e);
        return list.stream().map(s -> {
            HarmInspectServiceDemandVo vo = new HarmInspectServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    private Integer getServiceDemandStatVoByStateAndYear(Byte state, Long cid, Integer year) {
        Example e = new Example(HarmInspectServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        return this.getCountByExample(e);
    }
}

