/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.servicedemand;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.work.servicedemand.EvaluateWorkServiceDemandMapper;
import cn.smarthse.modules.health.entity.work.servicedemand.EvaluateWorkServiceDemand;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EvaluateWorkServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.ServiceDemandStatVo;
import cn.smarthse.modules.health.enums.servicedemand.EvaluateTypeEnum;
import cn.smarthse.modules.health.service.work.servicedemand.IEvaluateWorkServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EvaluateWorkServiceDemandServiceImpl
extends BaseServiceImpl<EvaluateWorkServiceDemandMapper, EvaluateWorkServiceDemand>
implements IEvaluateWorkServiceDemandService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private IServiceDemandHarmService serviceDemandHarmService;

    public ServiceDemandStatVo getServiceDemandStatVoByYear(Long cid, Integer year) {
        ServiceDemandStatVo vo = new ServiceDemandStatVo();
        vo.setDraftCount(this.getServiceDemandStatVoByStateAndYear((byte)1, cid, year));
        vo.setPublishCount(this.getServiceDemandStatVoByStateAndYear((byte)2, cid, year));
        vo.setOffShelvesCount(this.getServiceDemandStatVoByStateAndYear((byte)3, cid, year));
        return vo;
    }

    @Transactional(readOnly=false)
    public void addEvaluateWorkServiceDemand(EvaluateWorkServiceDemandVo vo, Long loginStaffId) {
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        EvaluateWorkServiceDemand hcd = (EvaluateWorkServiceDemand)this.add(vo, loginStaffId, vo.getCid());
    }

    public PageInfo<EvaluateWorkServiceDemandVo> listEvaluateData(JqGridParam param, Integer year, Byte state) {
        Example e = new Example(EvaluateWorkServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.getListByExample(e);
        return new PageInfo(list.stream().map(s -> {
            AreaModel am;
            EvaluateWorkServiceDemandVo vo = new EvaluateWorkServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            if (vo.getEvaluateBeginDate() != null && vo.getEvaluateEndDate() != null) {
                vo.setEvaluateTime(DateUtils.formatCheckTime((Date)vo.getEvaluateBeginDate(), (Date)vo.getEvaluateEndDate(), (String)"\u81f3"));
            }
            if (StringUtils.isNotEmpty((String)vo.getEvaluateType())) {
                vo.setEvaluateTypeName(EvaluateTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(vo.getEvaluateType())).getName());
            }
            vo.setLocationName("");
            if (vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
                vo.setLocationName(vo.getLocationName() + am.getFullname());
            }
            if (StringUtils.isNotEmpty((String)vo.getLocationDetail())) {
                vo.setLocationName(vo.getLocationName() + vo.getLocationDetail());
            }
            return vo;
        }).collect(Collectors.toList()));
    }

    public EvaluateWorkServiceDemandVo getVoById(Long id) {
        EvaluateWorkServiceDemand etsd = (EvaluateWorkServiceDemand)this.getById(id);
        EvaluateWorkServiceDemandVo vo = new EvaluateWorkServiceDemandVo();
        BeanUtils.copyProperties((Object)etsd, (Object)vo);
        if (StringUtils.isNotEmpty((String)vo.getEvaluateType())) {
            vo.setEvaluateTypeName(EvaluateTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(vo.getEvaluateType())).getName());
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void editEvaluateWorkServiceDemand(EvaluateWorkServiceDemandVo vo, Long loginStaffId) {
        if (vo.getId() == null) {
            return;
        }
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        this.update(vo, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        EvaluateWorkServiceDemand d = new EvaluateWorkServiceDemand();
        d.setId(id);
        this.delete(d, loginUserId);
    }

    @Transactional(readOnly=false)
    public void offShelvesServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        EvaluateWorkServiceDemand d = new EvaluateWorkServiceDemand();
        d.setId(id);
        d.setState(Byte.valueOf((byte)3));
        d.setOffShelvesDate(new Date());
        this.update(d, loginUserId);
    }

    public List<EvaluateWorkServiceDemandVo> getNoExpireList() {
        Example e = new Example(EvaluateWorkServiceDemand.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("evaluateBeginDate", (Object)Date.from(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant())).andEqualTo("state", (Object)2);
        e.or().andEqualTo("isValid", (Object)true).andEqualTo("specialDemand", (Object)1).andEqualTo("state", (Object)2);
        List list = this.getListByExample(e);
        return list.stream().map(s -> {
            EvaluateWorkServiceDemandVo vo = new EvaluateWorkServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    private Integer getServiceDemandStatVoByStateAndYear(Byte state, Long cid, Integer year) {
        Example e = new Example(EvaluateWorkServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        return this.getCountByExample(e);
    }
}

