/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.servicedemand;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.servicedemand.EducationTrainServiceDemandMapper;
import cn.smarthse.modules.health.entity.work.servicedemand.EducationTrainServiceDemand;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EducationTrainServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.ServiceDemandStatVo;
import cn.smarthse.modules.health.enums.servicedemand.TrainTypeEnum;
import cn.smarthse.modules.health.service.work.servicedemand.IEducationTrainServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EducationTrainServiceDemandServiceImpl
extends BaseServiceImpl<EducationTrainServiceDemandMapper, EducationTrainServiceDemand>
implements IEducationTrainServiceDemandService {
    @Autowired
    private IServiceDemandHarmService serviceDemandHarmService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;

    public List<Integer> getServiceDemandMaxAndMinYear() {
        String yearsStr = ((EducationTrainServiceDemandMapper)this.dao).getServiceDemandMaxAndMinYear();
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (yearsStr.contains("and")) {
            String[] strs = yearsStr.split("and");
            Integer i = Integer.valueOf(strs[1]);
            while (i <= Integer.valueOf(strs[0])) {
                list.add(i);
                Integer n = i;
                i = i + 1;
            }
        } else {
            list.add(Integer.valueOf(yearsStr));
        }
        return list;
    }

    public ServiceDemandStatVo getServiceDemandStatVoByYear(Long cid, Integer year) {
        ServiceDemandStatVo vo = new ServiceDemandStatVo();
        vo.setDraftCount(this.getServiceDemandStatVoByStateAndYear((byte)1, cid, year));
        vo.setPublishCount(this.getServiceDemandStatVoByStateAndYear((byte)2, cid, year));
        vo.setOffShelvesCount(this.getServiceDemandStatVoByStateAndYear((byte)3, cid, year));
        return vo;
    }

    @Transactional(readOnly=false)
    public void addEducationTrainServiceDemand(EducationTrainServiceDemandVo vo, Long loginStaffId) {
        EducationTrainServiceDemand hcd;
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        if ((hcd = (EducationTrainServiceDemand)this.add(vo, loginStaffId, vo.getCid())) != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), hcd.getId(), loginStaffId);
        }
    }

    public PageInfo<EducationTrainServiceDemandVo> listEducationData(JqGridParam param, Integer year, Byte state) {
        Example e = new Example(EducationTrainServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.getListByExample(e);
        return new PageInfo(list.stream().map(s -> {
            AreaModel am;
            EducationTrainServiceDemandVo vo = new EducationTrainServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            if (vo.getTrainBeginDate() != null && vo.getTrainEndDate() != null) {
                vo.setTrainTime(DateUtils.formatCheckTime((Date)vo.getTrainBeginDate(), (Date)vo.getTrainEndDate(), (String)"\u81f3"));
            }
            if (StringUtils.isNotEmpty((String)vo.getTrainType())) {
                vo.setTrainTypeName(TrainTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(vo.getTrainType())).getName());
            }
            vo.setLocationName("");
            if (vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
                vo.setLocationName(vo.getLocationName() + am.getFullname());
            }
            if (StringUtils.isNotEmpty((String)vo.getLocationDetail())) {
                vo.setLocationName(vo.getLocationName() + vo.getLocationDetail());
            }
            return vo;
        }).collect(Collectors.toList()));
    }

    public EducationTrainServiceDemandVo getVoById(Long id) {
        EducationTrainServiceDemand etsd = (EducationTrainServiceDemand)this.getById(id);
        EducationTrainServiceDemandVo vo = new EducationTrainServiceDemandVo();
        BeanUtils.copyProperties((Object)etsd, (Object)vo);
        String harmIds = this.serviceDemandHarmService.getHarmIdsByServiceDemanId(id);
        if (StringUtils.isNotEmpty((String)harmIds)) {
            vo.setHarms(this.harmFactorService.getHarmByIds(harmIds));
            if (vo.getHarms() != null && vo.getHarms().size() > 0) {
                vo.setHarmNames(vo.getHarms().stream().map(s -> s.getNameCh()).collect(Collectors.joining(",")));
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getTrainType())) {
            vo.setTrainTypeName(Arrays.stream(vo.getTrainType().split(",")).map(ss -> TrainTypeEnum.getThisEnumByCode((Integer)Integer.valueOf(ss)).getName()).collect(Collectors.joining(",")));
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void editEducationTrainServiceDemand(EducationTrainServiceDemandVo vo, Long loginStaffId) {
        if (vo.getId() == null) {
            return;
        }
        if (vo.getState() != null) {
            if (vo.getState() == 2) {
                vo.setPublishingDate(new Date());
            } else if (vo.getState() == 3) {
                vo.setOffShelvesDate(new Date());
            }
        }
        this.update(vo, loginStaffId);
        this.serviceDemandHarmService.deleteByServiceDemandId(vo.getId());
        if (vo != null && StringUtils.isNotEmpty((String)vo.getHarmIds())) {
            this.serviceDemandHarmService.addBatch(vo.getHarmIds(), vo.getId(), loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void deleteServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        EducationTrainServiceDemand d = new EducationTrainServiceDemand();
        d.setId(id);
        this.delete(d, loginUserId);
        this.serviceDemandHarmService.deleteByServiceDemandId(id);
    }

    @Transactional(readOnly=false)
    public void offShelvesServiceDemandById(Long id, Long loginUserId) {
        if (id == null) {
            return;
        }
        EducationTrainServiceDemand d = new EducationTrainServiceDemand();
        d.setId(id);
        d.setState(Byte.valueOf((byte)3));
        d.setOffShelvesDate(new Date());
        this.update(d, loginUserId);
    }

    private Integer getServiceDemandStatVoByStateAndYear(Byte state, Long cid, Integer year) {
        Example e = new Example(EducationTrainServiceDemand.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)DateUtils.getYearFirstDay((int)year), (Object)DateUtils.getYearLastDay((int)year)).andEqualTo("state", (Object)state);
        return this.getCountByExample(e);
    }

    public List<EducationTrainServiceDemandVo> getNoExpireList() {
        Example e = new Example(EducationTrainServiceDemand.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("trainBeginDate", (Object)Date.from(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant())).andEqualTo("state", (Object)2);
        e.or().andEqualTo("isValid", (Object)true).andEqualTo("specialDemand", (Object)1).andEqualTo("state", (Object)2);
        List list = this.getListByExample(e);
        return list.stream().map(s -> {
            EducationTrainServiceDemandVo vo = new EducationTrainServiceDemandVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }
}

