/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.scene;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.utils.JqgridSearchUtil;
import cn.smarthse.common.util.HttpUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.dao.work.scene.SceneInspectionTableMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseListView;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTable;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableFeatures;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustom;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustomCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemDevice;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemReform;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemWarningSigns;
import cn.smarthse.modules.health.enums.scene.InspectionTableNativeCodeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseListViewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableCurrentService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableFeaturesService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemCustomCurrentService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemCustomService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemDeviceService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemReformService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemWarningSignsService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SceneInspectionTableServiceImpl
extends BaseServiceImpl<SceneInspectionTableMapper, SceneInspectionTable>
implements ISceneInspectionTableService {
    @Autowired
    SceneInspectionTableMapper sceneInspectionTableMapper;
    @Autowired
    private ISceneInspectionTableFeaturesService featureService;
    @Autowired
    private ISceneInspectionTableItemCustomService customItemService;
    @Autowired
    private ISceneInspectionTableItemCustomCurrentService currentItemService;
    @Autowired
    private ISceneInspectionTableCurrentService currentService;
    @Autowired
    private IDeviceListViewService deviceListViewService;
    @Autowired
    private IReformItemBasicService reformItemService;
    @Autowired
    private IWmBaseListViewService wmBaseListViewService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private ISceneInspectionTableItemDeviceService tableItemDeviceService;
    @Autowired
    private ISceneInspectionTableItemWarningSignsService tableItemWarningSignService;
    @Autowired
    private ISceneInspectionTableItemReformService tableItemReformService;
    @Autowired
    private ICompanyAreaService areaService;

    public List<SceneInspectionTableFeatures> getInspectionTableFeaturesAll(Long cid) {
        return this.featureService.getAll(cid);
    }

    public List<SceneInspectionTableFeatures> getInspectionTableFeaturesSystemBring() {
        return this.featureService.getSystemBring();
    }

    @Transactional
    public SceneInspectionTableFeatures saveCustomerFeature(SceneInspectionTableFeatures feature, Long loginStaffId, Long cid) {
        if (feature == null || StringUtils.isEmpty((CharSequence)feature.getName())) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        return this.featureService.saveCustomerFeature(feature, loginStaffId, cid);
    }

    public PageInfo<SceneInspectionTable> getInspectionTablePageInfo(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SceneInspectionTable> inspectionTableList = this.getInspectionTalbeList(cid, param);
        PageInfo pageInfo = new PageInfo(inspectionTableList);
        return pageInfo;
    }

    private List<SceneInspectionTable> getInspectionTalbeList(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(SceneInspectionTable.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        Example.Criteria criteria1 = example.or().andIsNull("cid").andEqualTo("isValid", (Object)true);
        JqgridSearchUtil.addAndCriteriaAll(criteria1, param);
        JqgridSearchUtil.addAndCriteriaAll(criteria, param);
        List inspectionTableList = ((SceneInspectionTableMapper)this.dao).selectByExample(example);
        return inspectionTableList;
    }

    private List<SceneInspectionTable> getInspectionTalbeListComplete(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(SceneInspectionTable.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)StatusEnum.complete.getValue()).andEqualTo("isValid", (Object)true);
        example.or().andIsNull("cid").andEqualTo("isValid", (Object)true);
        JqgridSearchUtil.addAndCriteriaAll(criteria, param);
        List inspectionTableList = ((SceneInspectionTableMapper)this.dao).selectByExample(example);
        return inspectionTableList;
    }

    private void setRedundancyInfo(SceneInspectionTable entity, Long loginStaffId, Long cid) {
        if (loginStaffId != null) {
            entity.setWriter(loginStaffId);
            entity.setWriterName(this.staffInfoService.getStaffNameByStaffId(loginStaffId));
        }
        if (entity.getTableType() != null) {
            entity.setTableTypeName(InspectionTableTypeEnum.getNameByValue((Byte)entity.getTableType()));
        }
        if (StringUtils.isNotEmpty((String)entity.getFeature())) {
            entity.setFeatureName(this.featureService.getFeatureNameByIds(entity.getFeature(), cid));
        }
        if (entity.getStatus() != null) {
            entity.setStatusName(StatusEnum.getNameByValue((Byte)entity.getStatus()));
        }
    }

    @Transactional(readOnly=false)
    public SceneInspectionTable saveSceneInspectionTableInfo(SceneInspectionTable entity, String deleteItemIds, Long loginStaffId, Long cid) {
        if (entity == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        entity.setTableNativeCode(InspectionTableNativeCodeEnum.custom.getValue());
        List itemCustomList = entity.getItemCustomList();
        if (entity.getId() == null) {
            if (StatusEnum.complete.getValue().equals(entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"add");
            }
            this.setRedundancyInfo(entity, loginStaffId, cid);
            entity = this.add(entity, loginStaffId, cid);
        } else {
            if (StatusEnum.complete.getValue().equals(entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"edit");
            }
            this.setRedundancyInfo(entity, null, cid);
            this.update(entity, loginStaffId);
        }
        this.customItemService.deleteItems(deleteItemIds, loginStaffId);
        entity.setItemCustomList(this.customItemService.saveItemList(itemCustomList, entity.getId(), loginStaffId, cid));
        return entity;
    }

    public SceneInspectionTable getTableItemCustom(Long tableId, Long cid) {
        if (tableId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SceneInspectionTable table = this.getTableAndItemById(tableId, cid);
        if (table == null) {
            return null;
        }
        return table;
    }

    public List<SceneInspectionTableItemCustom> getTableItemByUrlPath(String fileUrlPath, Long loginStaffId, Long cid) {
        if (!HttpUtil.isUrlCurrent((String)fileUrlPath)) {
            throw new HealthException(ErrorEnum.OSS_URL_ERROR);
        }
        ArrayList<Integer> cellValidNumList = new ArrayList<Integer>();
        cellValidNumList.add(0);
        ArrayList<Integer> colValidNumList = new ArrayList<Integer>();
        colValidNumList.add(1);
        Map contentMap = null;
        try {
            contentMap = ExcelUtil.getInstance().getContentFromUrl(fileUrlPath, cellValidNumList, colValidNumList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (contentMap == null) {
            return Collections.emptyList();
        }
        Iterator iterator = contentMap.entrySet().iterator();
        ArrayList<SceneInspectionTableItemCustom> itemList = new ArrayList<SceneInspectionTableItemCustom>();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next().getValue();
            for (ArrayList l : list) {
                SceneInspectionTableItemCustom item = new SceneInspectionTableItemCustom();
                item.setContentItem((String)l.get(0));
                item.setAccordingAs((String)l.get(1));
                item.setCid(cid);
                itemList.add(item);
            }
        }
        return itemList;
    }

    @Transactional(readOnly=false)
    public void addTableItems(List<SceneInspectionTableItemCustom> list, Long loginStaffId, Long cid) {
        if (list == null || list.isEmpty() || loginStaffId == null || cid == null) {
            return;
        }
        Long tableId = list.get(0).getTableId();
        if (tableId == null) {
            return;
        }
        SceneInspectionTableItemCustom item = this.customItemService.getMaxSortItem(tableId);
        Integer sort = 1;
        if (item != null && item.getSort() != null) {
            sort = item.getSort() + 1;
        }
        for (SceneInspectionTableItemCustom entity : list) {
            entity.setSort(sort);
            Integer n = sort;
            sort = sort + 1;
            this.customItemService.add((Object)entity, loginStaffId, cid);
        }
    }

    public boolean hasTables(Long cid) {
        if (cid == null) {
            return false;
        }
        SceneInspectionTable record = new SceneInspectionTable();
        record.setCid(cid);
        record.setIsValid(Boolean.valueOf(true));
        record.setStatus(StatusEnum.complete.getValue());
        int count = ((SceneInspectionTableMapper)this.dao).selectCount(record);
        return count > 0;
    }

    public PageInfo<SceneInspectionTable> getInspectionTableCompletePageInfo(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SceneInspectionTable> inspectionTableList = this.getInspectionTalbeListComplete(cid, param);
        PageInfo pageInfo = new PageInfo(inspectionTableList);
        return pageInfo;
    }

    public PageInfo<SceneInspectionTableItemCustomCurrent> getCurrentItemList(Long tableId, Boolean isHideNoHiddenDenger, int pageNum, int pageSize) {
        Page page = new Page();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        PageInfo pageInfo = this.currentItemService.getItemList(tableId, isHideNoHiddenDenger, page);
        return pageInfo;
    }

    public SceneInspectionTable getTableAndItemById(Long tableId, Long cid) {
        SceneInspectionTable table;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (tableId == null) {
                            return null;
                        }
                        table = (SceneInspectionTable)super.getById(tableId);
                        if (table == null) {
                            return null;
                        }
                        if (!InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) break block5;
                        List itemList = this.customItemService.getTableItemCustom(table.getId());
                        table.setItemCustomList(itemList);
                        break block6;
                    }
                    if (!InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) break block7;
                    List deviceList = this.deviceListViewService.getDeviceInfoList(cid);
                    for (DeviceListView device : deviceList) {
                        SceneInspectionTableItemDevice record = new SceneInspectionTableItemDevice();
                        record.setDeviceModel(device.getDeviceModel());
                        record.setDeviceName(device.getDeviceName());
                        record.setDeviceNo(device.getDeviceNo());
                        record.setDeviceNumber(Integer.valueOf(1));
                        Object areaFullName = this.areaService.getAreaFullName(device.getInstallAreaId());
                        areaFullName = StringUtils.isNotBlank((CharSequence)areaFullName) ? (String)areaFullName + "\uff1e" : "";
                        record.setDevicePlace((String)areaFullName + device.getInstallPosition());
                        record.setTableId(table.getId());
                        table.getItemDeviceList().add(record);
                    }
                    break block6;
                }
                if (InspectionTableNativeCodeEnum.emergencyMaterial.getValue().equals(table.getTableNativeCode())) break block6;
                if (!InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) break block8;
                List reformItemList = this.reformItemService.getReformItemUnFinishedListForInspectionTable(cid);
                for (ReformItemBasic reform : reformItemList) {
                    SceneInspectionTableItemReform record = this.tableItemReformService.getSceneInspectionTableItemReformByReformItemBasic(reform);
                    record.setTableId(table.getId());
                    table.getItemReformList().add(record);
                }
                break block6;
            }
            if (!InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) break block6;
            List wmBaseList = this.wmBaseListViewService.getWmbaseListByCid(cid);
            for (WmBaseListView wmBase : wmBaseList) {
                SceneInspectionTableItemWarningSigns record = new SceneInspectionTableItemWarningSigns();
                record.setAreaId(wmBase.getAreaId());
                record.setAreaName(wmBase.getAreaName());
                record.setInformProject(wmBase.getNameChs());
                record.setSpecificLocation(wmBase.getPositionAddr());
                record.setWarningSignsType(wmBase.getSignName());
                record.setTableId(table.getId());
                table.getItemWarningSingsList().add(record);
            }
        }
        return table;
    }

    @Transactional(readOnly=false)
    public SceneInspectionTableCurrent cloneTableToCurrent(Long tableId, Long loginStaffId, Long cid) {
        SceneInspectionTableCurrent entity;
        block7: {
            SceneInspectionTable table;
            block9: {
                block8: {
                    block6: {
                        if (tableId == null || loginStaffId == null || cid == null) {
                            return null;
                        }
                        table = this.getTableAndItemById(tableId, cid);
                        if (table == null) {
                            return null;
                        }
                        entity = new SceneInspectionTableCurrent();
                        entity.setTableName(table.getTableName());
                        entity.setFeature(table.getFeature());
                        entity.setNativeTableId(table.getId());
                        entity.setStatus(table.getStatus());
                        entity.setTableNativeCode(table.getTableNativeCode());
                        entity.setTableType(table.getTableType());
                        entity.setVersion(table.getVersion());
                        this.currentService.add((Object)entity, loginStaffId, cid);
                        if (!InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) break block6;
                        for (SceneInspectionTableItemCustom item : table.getItemCustomList()) {
                            SceneInspectionTableItemCustomCurrent record = new SceneInspectionTableItemCustomCurrent();
                            record.setAccordingAs(item.getAccordingAs());
                            record.setContentItem(item.getContentItem());
                            record.setSort(item.getSort());
                            record.setTableId(entity.getId());
                            this.currentItemService.add((Object)record, loginStaffId, cid);
                        }
                        break block7;
                    }
                    if (!InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) break block8;
                    for (SceneInspectionTableItemDevice device : table.getItemDeviceList()) {
                        device.setTableId(entity.getId());
                        this.tableItemDeviceService.add((Object)device, loginStaffId, cid);
                    }
                    break block7;
                }
                if (InspectionTableNativeCodeEnum.emergencyMaterial.getValue().equals(table.getTableNativeCode())) break block7;
                if (!InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) break block9;
                for (SceneInspectionTableItemReform reform : table.getItemReformList()) {
                    reform.setTableId(entity.getId());
                    this.tableItemReformService.add((Object)reform, loginStaffId, cid);
                }
                break block7;
            }
            if (!InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) break block7;
            for (SceneInspectionTableItemWarningSigns wmBase : table.getItemWarningSingsList()) {
                wmBase.setTableId(entity.getId());
                this.tableItemWarningSignService.add((Object)wmBase, loginStaffId, cid);
            }
        }
        return entity;
    }

    public PageInfo<SceneInspectionTableItemCustom> getTemplateItemList(Long tableId, int pageNum, int pageSize, Long cid) {
        if (tableId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.getTableItemCustom(tableId, cid).getItemCustomList();
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public SceneInspectionTableCurrent getCurrentTableById(Long tableId) {
        if (tableId == null) {
            return null;
        }
        return (SceneInspectionTableCurrent)this.currentService.getById(tableId);
    }

    public SceneInspectionTableCurrent getCurrentTableAndItemsById(Long tableId, Boolean isHideNoHiddenDenger, int pageNum, int pageSize) {
        SceneInspectionTableCurrent table = this.getCurrentTableById(tableId);
        if (table == null) {
            return null;
        }
        Page page = new Page();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        if (InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) {
            table.setItemCustomList(this.currentItemService.getItemList(tableId, isHideNoHiddenDenger, page));
        } else if (InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) {
            table.setItemDeviceList(this.tableItemDeviceService.getItemList(tableId, isHideNoHiddenDenger, page));
        } else if (InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) {
            table.setItemWarningSingsList(this.tableItemWarningSignService.getItemList(tableId, isHideNoHiddenDenger, page));
        } else if (InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) {
            table.setItemReformList(this.tableItemReformService.getItemList(tableId, isHideNoHiddenDenger, page));
            for (SceneInspectionTableItemReform item : table.getItemReformList().getList()) {
                item.setReformItem((ReformItemBasic)this.reformItemService.getById(item.getReformItemId()));
            }
        }
        return table;
    }

    @Transactional(readOnly=false)
    public SceneInspectionTableItemCustomCurrent saveCurrentTableItem(SceneInspectionTableItemCustomCurrent entity, Long loginStaffId, Long cid) {
        if (entity == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        ValidateUtil.valid((Object)entity, (String)"add");
        if (entity.getId() == null) {
            entity = (SceneInspectionTableItemCustomCurrent)this.currentItemService.add((Object)entity, loginStaffId, cid);
        } else {
            this.currentItemService.update((Object)entity, loginStaffId);
        }
        return entity;
    }

    @Transactional(readOnly=false)
    public void delCurrentTableItem(Long itemId, Long loginStaffId) {
        if (itemId == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SceneInspectionTableItemCustomCurrent entity = new SceneInspectionTableItemCustomCurrent();
        entity.setId(itemId);
        this.currentItemService.delete((Object)entity, loginStaffId);
    }

    public Map<String, Object> getExportDataById(Long tableId, Long cid) {
        SceneInspectionTable table = this.getTableAndItemById(tableId, cid);
        if (table == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableName", table.getTableName());
        map.put("tableType", InspectionTableTypeEnum.getNameByValue((Byte)table.getTableType()));
        map.put("createBy", this.staffInfoService.getStaffNameByStaffId(table.getCreateBy()));
        map.put("feature", this.featureService.getFeatureNameByIds(table.getFeature(), cid));
        map.put("version", table.getVersion());
        if (InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) {
            map.put("itemList", table.getItemCustomList());
        } else if (InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) {
            map.put("itemList", table.getItemDeviceList());
        } else if (!InspectionTableNativeCodeEnum.emergencyMaterial.getValue().equals(table.getTableNativeCode())) {
            if (InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) {
                map.put("itemList", table.getItemReformList());
            } else if (InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) {
                map.put("itemList", table.getItemWarningSingsList());
            }
        }
        return map;
    }
}

