/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.scene;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.scene.SceneInspectionTableItemReformMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemReform;
import cn.smarthse.modules.health.enums.scene.InspectionResultEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemReformService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SceneInspectionTableItemReformServiceImpl
extends BaseServiceImpl<SceneInspectionTableItemReformMapper, SceneInspectionTableItemReform>
implements ISceneInspectionTableItemReformService {
    @Autowired
    SceneInspectionTableItemReformMapper sceneInspectionTableItemReformMapper;
    @Autowired
    private ICompanyAreaService areaService;

    public PageInfo<SceneInspectionTableItemReform> getItemList(Long tableId, Boolean isHideNoHiddenDenger, Page page) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List<SceneInspectionTableItemReform> list = this.getItemList(tableId, isHideNoHiddenDenger);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public List<SceneInspectionTableItemReform> getItemList(Long tableId, Boolean isHideNoHiddenDenger) {
        SceneInspectionTableItemReform record = new SceneInspectionTableItemReform();
        record.setIsValid(Boolean.valueOf(true));
        record.setTableId(tableId);
        record.setSearch(true);
        if (isHideNoHiddenDenger != null && isHideNoHiddenDenger.booleanValue()) {
            record.setResult(InspectionResultEnum.hasHiddenDanger.getValue());
        }
        List list = ((SceneInspectionTableItemReformMapper)this.dao).select(record);
        return list;
    }

    public List<SceneInspectionTableItemReform> getItemListByReformId(Long reformId) {
        if (reformId == null) {
            return Collections.emptyList();
        }
        SceneInspectionTableItemReform entity = new SceneInspectionTableItemReform();
        entity.setIsValid(Boolean.valueOf(true));
        entity.setReformItemId(reformId);
        entity.setSearch(true);
        return ((SceneInspectionTableItemReformMapper)this.dao).select(entity);
    }

    public SceneInspectionTableItemReform getSceneInspectionTableItemReformByReformItemBasic(ReformItemBasic reform) {
        SceneInspectionTableItemReform record = new SceneInspectionTableItemReform();
        record.setReformItemId(reform.getId());
        record.setReformItem(reform);
        record.setDescription(reform.getDescription());
        if (StringUtils.isNotEmpty((String)reform.getReformItemPositionName())) {
            record.setReformItemPositionName(reform.getReformItemPositionName());
        } else if (reform.getReformItemPosition() != null) {
            record.setReformItemPositionName(this.areaService.getAreaNamesByAreaIds("" + reform.getReformItemPosition()));
        }
        record.setReformItemSn(reform.getReformItemSn());
        if (reform.getAcceptance() != null) {
            record.setReformDirectorName(reform.getAcceptance().getReformDirectorName());
        }
        return record;
    }
}

