/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.scene;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.dao.work.scene.SceneInspectionTableItemCustomMapper;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustom;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemCustomService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SceneInspectionTableItemCustomServiceImpl
extends BaseServiceImpl<SceneInspectionTableItemCustomMapper, SceneInspectionTableItemCustom>
implements ISceneInspectionTableItemCustomService {
    @Autowired
    SceneInspectionTableItemCustomMapper sceneInspectionTableItemCustomMapper;

    @Transactional(readOnly=false)
    public List<SceneInspectionTableItemCustom> saveItemList(List<SceneInspectionTableItemCustom> itemList, Long tableId, Long loginStaffId, Long cid) {
        if (itemList == null || itemList.isEmpty() || tableId == null) {
            return Collections.emptyList();
        }
        for (SceneInspectionTableItemCustom itemCustom : itemList) {
            if (itemCustom.isEmpty()) continue;
            itemCustom.setTableId(tableId);
            ValidateUtil.valid((Object)itemCustom, (String)"add");
            if (itemCustom.getId() == null) {
                super.add(itemCustom, loginStaffId, cid);
                continue;
            }
            super.update(itemCustom, loginStaffId);
        }
        return itemList;
    }

    @Transactional(readOnly=false)
    public void deleteItemsByIds(String ids, Long loginStaffId) {
        if (StringUtils.isEmpty((CharSequence)ids) || loginStaffId == null) {
            return;
        }
        String[] idArray = ids.split(",");
        if (idArray == null || idArray.length == 0) {
            return;
        }
        boolean hasId = false;
        Example example = new Example(SceneInspectionTableItemCustom.class);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idArray) {
            if (!StringUtils.isNumber((String)id)) continue;
            Long idLong = Long.valueOf(id);
            example.or().andEqualTo("id", (Object)idLong);
            hasId = true;
            idList.add(idLong);
        }
        if (hasId) {
            SceneInspectionTableItemCustom entity = new SceneInspectionTableItemCustom();
            entity.setIsValid(Boolean.valueOf(false));
            super.setUpdateInfo(entity, loginStaffId);
            ((SceneInspectionTableItemCustomMapper)this.dao).updateByExampleSelective(entity, example);
            for (Long id : idList) {
                super.delFromMemoryCache(id);
            }
        }
    }

    public List<SceneInspectionTableItemCustom> getTableItemCustom(Long tableId) {
        if (tableId == null) {
            return Collections.emptyList();
        }
        SceneInspectionTableItemCustom record = new SceneInspectionTableItemCustom();
        record.setIsValid(Boolean.valueOf(true));
        record.setTableId(tableId);
        return ((SceneInspectionTableItemCustomMapper)this.dao).select(record);
    }

    @Transactional(readOnly=false)
    public void deleteItems(String ids, Long loginStaffId) {
        String[] idArray;
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return;
        }
        for (String id : idArray = ids.split(",")) {
            if (!StringUtils.isNumber((String)id)) continue;
            SceneInspectionTableItemCustom entity = new SceneInspectionTableItemCustom();
            entity.setId(Long.valueOf(id));
            super.delete(entity, loginStaffId);
        }
    }

    public SceneInspectionTableItemCustom getMaxSortItem(Long tableId) {
        if (tableId == null) {
            return null;
        }
        Example example = new Example(SceneInspectionTableItemCustom.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("tableId", (Object)tableId);
        example.setOrderByClause("sort desc");
        PageHelper.startPage((int)1, (int)1);
        List list = ((SceneInspectionTableItemCustomMapper)this.dao).selectByExample(example);
        return list != null && list.size() > 0 ? (SceneInspectionTableItemCustom)list.get(0) : null;
    }
}

