/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.scene;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.scene.SceneInspectionTableFeaturesMapper;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableFeatures;
import cn.smarthse.modules.health.enums.scene.InspectionTableFeatureGroupEnum;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableFeaturesService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class SceneInspectionTableFeaturesServiceImpl
extends BaseServiceImpl<SceneInspectionTableFeaturesMapper, SceneInspectionTableFeatures>
implements ISceneInspectionTableFeaturesService {
    public List<SceneInspectionTableFeatures> getAll(Long cid) {
        Example example = new Example(SceneInspectionTableFeatures.class);
        example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.or().andIsNull("cid").andEqualTo("isValid", (Object)true);
        return ((SceneInspectionTableFeaturesMapper)this.dao).selectByExample(example);
    }

    public List<SceneInspectionTableFeatures> getSystemBring() {
        Example example = new Example(SceneInspectionTableFeatures.class);
        example.or().andIsNull("cid").andEqualTo("isValid", (Object)true);
        return ((SceneInspectionTableFeaturesMapper)this.dao).selectByExample(example);
    }

    public String getFeatureNameByIds(String featureIds, Long cid) {
        String[] fIds;
        if (StringUtils.isEmpty((CharSequence)featureIds) || cid == null) {
            return "";
        }
        List<SceneInspectionTableFeatures> features = this.getAll(cid);
        if (features == null || features.isEmpty()) {
            return "";
        }
        StringBuffer str = new StringBuffer("");
        for (String id : fIds = featureIds.split(",")) {
            if (!StringUtils.isNumber((String)id)) continue;
            for (SceneInspectionTableFeatures feature : features) {
                if (StringUtils.isEmpty((CharSequence)feature.getName()) || !Long.valueOf(id).equals(feature.getId())) continue;
                str.append(feature.getName());
                str.append(",");
            }
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.lastIndexOf(","));
        }
        return str.toString();
    }

    private SceneInspectionTableFeatures getCustomerFeatureByName(String name, Long cid) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        SceneInspectionTableFeatures record = new SceneInspectionTableFeatures();
        record.setName(name);
        record.setIsSystemBring(Boolean.valueOf(false));
        record.setGroupId(InspectionTableFeatureGroupEnum.typeSub.getValue());
        record.setParentId(Constants.SPECIAL_INSPECTION_FEATURE);
        record.setCid(cid);
        record.setIsValid(Boolean.valueOf(true));
        List list = ((SceneInspectionTableFeaturesMapper)this.dao).select(record);
        return list != null && list.size() > 0 ? (SceneInspectionTableFeatures)list.get(0) : null;
    }

    @Transactional
    public SceneInspectionTableFeatures saveCustomerFeature(SceneInspectionTableFeatures feature, Long loginStaffId, Long cid) {
        SceneInspectionTableFeatures old = this.getCustomerFeatureByName(feature.getName(), cid);
        if (old != null) {
            return old;
        }
        feature.setIsSystemBring(Boolean.valueOf(false));
        feature.setGroupId(InspectionTableFeatureGroupEnum.typeSub.getValue());
        feature.setParentId(Constants.SPECIAL_INSPECTION_FEATURE);
        super.add(feature, loginStaffId, cid);
        return feature;
    }
}

