/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.scene;

import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.framework.utils.JqgridSearchUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.dao.work.scene.SceneInspectionMapper;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.scene.SceneInspection;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustomCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemDevice;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemReform;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemWarningSigns;
import cn.smarthse.modules.health.enums.scene.InspectionObjectEnum;
import cn.smarthse.modules.health.enums.scene.InspectionResultEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableNativeCodeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTypeEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionSuperiorsService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableCurrentService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemCustomCurrentService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemDeviceService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemReformService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableItemWarningSignsService;
import cn.smarthse.modules.health.vo.summary.InspectionAndReformMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.InspectionTypeCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.SceneInspectionMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.work.sceneInspection.SceneInspectionTodolistVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SceneInspectionServiceImpl
extends BaseServiceImpl<SceneInspectionMapper, SceneInspection>
implements ISceneInspectionService {
    @Autowired
    SceneInspectionMapper sceneInspectionMapper;
    @Autowired
    ISceneInspectionTableItemCustomCurrentService itemCustomCurrentService;
    @Autowired
    ISceneInspectionTableItemDeviceService itemDeviceService;
    @Autowired
    ISceneInspectionTableItemReformService itemReformService;
    @Autowired
    ISceneInspectionTableItemWarningSignsService itemWarningSignsService;
    @Autowired
    IStaffInfoService staffService;
    @Autowired
    ICompanyAreaService areaService;
    @Autowired
    ISceneInspectionTableCurrentService currentTableService;
    @Autowired
    IReformItemBasicService reformService;
    @Autowired
    ISceneInspectionSuperiorsService superiorsService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    IMessageService messageService;
    @Autowired
    IReformItemBasicService reformBaseService;

    public List<SceneInspection> getUnfinishedList(Long cid, Integer year) {
        Example example = new Example(SceneInspection.class);
        for (Object type : InspectionObjectEnum.inspectionType2.getValue()) {
            InspectionTypeEnum typeEnum = (InspectionTypeEnum)type;
            Example.Criteria criteria = example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("inspectionType", (Object)typeEnum.getValue()).andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
            if (year == null) continue;
            Date startDate = DateUtils.StringToDate((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endDate = DateUtils.StringToDate((String)(year + 1 + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            criteria.andBetween("inspectionActualTime", (Object)startDate, (Object)endDate);
        }
        Example.Criteria criteria = example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIsNull("inspectionType").andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
        if (year != null) {
            Date startDate = DateUtils.StringToDate((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endDate = DateUtils.StringToDate((String)(year + 1 + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            criteria.andBetween("inspectionActualTime", (Object)startDate, (Object)endDate);
        }
        example.setOrderByClause("create_date desc");
        return ((SceneInspectionMapper)this.dao).selectByExample(example);
    }

    public List<SceneInspection> getUnfinishedSuperiorsList(Long cid) {
        Example example = new Example(SceneInspection.class);
        for (Object type : InspectionObjectEnum.inspectionTypeSuper.getValue()) {
            InspectionTypeEnum typeEnum = (InspectionTypeEnum)type;
            example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("inspectionType", (Object)typeEnum.getValue()).andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
        }
        example.setOrderByClause("create_date desc");
        DataScopeHelper.startDataScope("inspection", "scene_inspection");
        return ((SceneInspectionMapper)this.dao).selectByExample(example);
    }

    public List<SceneInspection> getFinishedList(Long cid, JqGridParam param, Integer year) {
        Example example = new Example(SceneInspection.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.finished.getValue());
        if (year != null) {
            Date startDate = DateUtils.StringToDate((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endDate = DateUtils.StringToDate((String)(year + 1 + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            criteria.andBetween("inspectionActualTime", (Object)startDate, (Object)endDate);
        }
        JqgridSearchUtil.addAndCriteriaAll(criteria, param);
        example.setOrderByClause("create_date desc");
        DataScopeHelper.startDataScope("inspection", "scene_inspection");
        return ((SceneInspectionMapper)this.dao).selectByExample(example);
    }

    private int getFinishedCount(Long cid) {
        Example example = new Example(SceneInspection.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.finished.getValue());
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    private int getUnfinishedCountNormal(Long cid) {
        Example example = new Example(SceneInspection.class);
        for (Object type : InspectionObjectEnum.inspectionType2.getValue()) {
            InspectionTypeEnum typeEnum = (InspectionTypeEnum)type;
            example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("inspectionType", (Object)typeEnum.getValue()).andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
        }
        example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIsNull("inspectionType").andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    private int getUnfinishedCountSuperiors(Long cid) {
        Example example = new Example(SceneInspection.class);
        for (Object type : InspectionObjectEnum.inspectionTypeSuper.getValue()) {
            InspectionTypeEnum typeEnum = (InspectionTypeEnum)type;
            example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("inspectionType", (Object)typeEnum.getValue()).andNotEqualTo("status", (Object)StatusEnum.finished.getValue());
        }
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    public SceneInspectionTodolistVO getTodolistVo(Long cid) {
        int todolistCount = 0;
        SceneInspectionTodolistVO vo = new SceneInspectionTodolistVO();
        vo.setFinishedCount(this.getFinishedCount(cid));
        vo.setUnfinishedCount(this.getUnfinishedCountNormal(cid));
        vo.setUnfinishedSuperiorsInspectCount(this.getUnfinishedCountSuperiors(cid));
        if (vo.getFinishedCount() + vo.getUnfinishedCount() + vo.getUnfinishedSuperiorsInspectCount() == 0) {
            vo.setHasAdd(true);
        }
        if (todolistCount > 0) {
            vo.setTodolistCount("" + todolistCount);
        }
        return vo;
    }

    public int getFinishedCount(Long cid, Integer year) {
        if (year == null || cid == null) {
            return 0;
        }
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + 1, 0, 0, 0, 0, 0);
        Example example = new Example(SceneInspection.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)StatusEnum.finished.getValue()).andLessThanOrEqualTo("inspectionActualTime", (Object)end.getTime()).andGreaterThanOrEqualTo("inspectionActualTime", (Object)start.getTime());
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    public int getGoingCount(Long cid, Integer year) {
        if (year == null || cid == null) {
            return 0;
        }
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + 1, 0, 0, 0, 0, 0);
        Example example = new Example(SceneInspection.class);
        example.or().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andNotEqualTo("status", (Object)StatusEnum.finished.getValue()).andLessThanOrEqualTo("inspectionActualTime", (Object)end.getTime()).andGreaterThanOrEqualTo("inspectionActualTime", (Object)start.getTime());
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    private void setInspectionRedundance(SceneInspection entity) {
        String type;
        if (entity == null) {
            return;
        }
        if (entity.getInspectionDirector() != null) {
            entity.setInspectionDirectorName(this.staffService.getStaffNameByStaffId(entity.getInspectionDirector()));
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getInspectionCollaborator())) {
            entity.setInspectionCollaboratorName(this.staffService.getStaffNamesByStaffIds(entity.getInspectionCollaborator()));
        }
        if (StringUtils.isNotEmpty((String)entity.getInspectionRanges())) {
            entity.setInspectionRangesName(this.areaService.getAreaNamesByAreaIds(entity.getInspectionRanges()));
        }
        StringBuffer tpyeNames = new StringBuffer("");
        if (entity.getInspectionType() != null && StringUtils.isNotEmpty((String)(type = InspectionTypeEnum.getNameByValue((Byte)entity.getInspectionType())))) {
            tpyeNames.append(type);
            tpyeNames.append(",");
        }
        if (StringUtils.isNotEmpty((String)entity.getInspectionType1())) {
            String[] types;
            for (String t : types = entity.getInspectionType1().split(",")) {
                String tName;
                if (!StringUtils.isNumber((String)t) || !StringUtils.isNotEmpty((String)(tName = InspectionTableTypeEnum.getNameByValue((Byte)Byte.valueOf(t))))) continue;
                tpyeNames.append(tName);
                tpyeNames.append(",");
            }
        }
        if (tpyeNames.length() > 1) {
            tpyeNames.deleteCharAt(tpyeNames.lastIndexOf(","));
        }
        entity.setInspectionTypeName(tpyeNames.toString());
        if (entity.getStatus() != null) {
            entity.setStatusName(StatusEnum.getNameByValue((Byte)entity.getStatus()));
        }
        if (StringUtils.isNotEmpty((String)entity.getInspectionTable())) {
            entity.setInspectionTableName(this.currentTableService.getTableNamesByIds(entity.getInspectionTable()));
        }
    }

    @Transactional(readOnly=false)
    public SceneInspection saveInspection(SceneInspection entity, Long loginStaffId, Long cid) {
        if (entity == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        this.setInspectionRedundance(entity);
        if (entity.getId() == null) {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"add");
            }
            entity = super.add(entity, loginStaffId, cid);
        } else {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"edit");
            }
            super.update(entity, loginStaffId);
        }
        if (entity.getItemCustomList() != null && entity.getItemCustomList().size() > 0) {
            this.updateInspectionResultCustom(entity.getItemCustomList(), loginStaffId, cid);
        }
        if (entity.getItemDeviceList() != null && entity.getItemDeviceList().size() > 0) {
            this.updateInspectionResultDevice(entity.getItemDeviceList(), loginStaffId);
        }
        if (entity.getItemReformList() != null && entity.getItemReformList().size() > 0) {
            this.updateInspectionResultReform(entity.getItemReformList(), loginStaffId);
        }
        if (entity.getItemWarningSingsList() != null && entity.getItemWarningSingsList().size() > 0) {
            this.updateInspectionResultWarningSigns(entity.getItemWarningSingsList(), loginStaffId);
        }
        if (StatusEnum.finished.getValue().equals(entity.getStatus())) {
            this.reformService.businessCompleteToUpdateReform(entity.getId(), loginStaffId);
            List tableList = this.currentTableService.getListByIds(entity.getInspectionTable());
            Long tableId = null;
            for (SceneInspectionTableCurrent currentTable : tableList) {
                if (!InspectionTableNativeCodeEnum.reformItem.getValue().equals(currentTable.getTableNativeCode())) continue;
                tableId = currentTable.getId();
                break;
            }
            if (tableId != null) {
                List itemList = this.itemReformService.getItemList(tableId, Boolean.valueOf(false));
                StringBuffer idBuffer = new StringBuffer();
                for (SceneInspectionTableItemReform reform : itemList) {
                    if (!InspectionResultEnum.noHiddenDenger.getValue().equals(reform.getResult())) continue;
                    idBuffer.append(",");
                    idBuffer.append(reform.getReformItemId());
                }
                StringBuffer bussinessName = new StringBuffer("");
                ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
                String splitChar = "\u3001";
                List reformBasicList = this.reformBaseService.getListByIds(idBuffer.toString());
                if (reformBasicList != null && !reformBasicList.isEmpty()) {
                    for (ReformItemBasic reformBasic : reformBasicList) {
                        if (reformBasic.getCreateBy() == null) continue;
                        bussinessName.append("<a target='_blank' href='{contextPath}/work/reform/editUnfinished?reformId=" + reformBasic.getId() + "'>" + reformBasic.getName() + "</a>" + splitChar);
                        MessageReceiver receiver = new MessageReceiver();
                        receiver.setReveiver(reformBasic.getCreateBy());
                        receivers.add(receiver);
                    }
                }
                if (bussinessName.length() > 0) {
                    bussinessName.deleteCharAt(bussinessName.lastIndexOf(splitChar));
                }
                if (receivers.size() > 0 && bussinessName.length() > 0) {
                    Message message = new Message();
                    message.setBussinesId(entity.getId());
                    message.setBussinesName(bussinessName.toString() + "\u5df2\u5b8c\u6210\u6574\u6539\u8bf7\u53ca\u65f6\u5f55\u5165\u6574\u6539\u9a8c\u6536\u60c5\u51b5");
                    message.setBussinessContent(message.getBussinesName());
                    message.setBussinesNo(entity.getInspectionNo());
                    message.setBussinesType(MessageBusinessTypeEnum.remind.getValue());
                    message.setBussinesFromType(MessageBusinessFromEnum.scene.getValue());
                    message.setBussinesFrom(MessageBusinessFromEnum.scene.getName());
                    message.setSendTime(new Date());
                    message.setReceivers(receivers);
                    this.messageService.pushMessage(message, loginStaffId, cid);
                }
            }
        }
        return entity;
    }

    private void updateInspectionResultWarningSigns(List<SceneInspectionTableItemWarningSigns> itemList, Long loginStaffId) {
        if (itemList == null || itemList.size() < 1 || loginStaffId == null) {
            return;
        }
        for (SceneInspectionTableItemWarningSigns entity : itemList) {
            if (entity.getId() == null) continue;
            this.itemWarningSignsService.update((Object)entity, loginStaffId);
        }
    }

    private void updateInspectionResultReform(List<SceneInspectionTableItemReform> itemList, Long loginStaffId) {
        if (itemList == null || itemList.size() < 1 || loginStaffId == null) {
            return;
        }
        for (SceneInspectionTableItemReform entity : itemList) {
            if (entity.getId() == null) continue;
            this.itemReformService.update((Object)entity, loginStaffId);
        }
    }

    private void updateInspectionResultDevice(List<SceneInspectionTableItemDevice> itemList, Long loginStaffId) {
        if (itemList == null || itemList.size() < 1 || loginStaffId == null) {
            return;
        }
        for (SceneInspectionTableItemDevice entity : itemList) {
            if (entity.getId() == null) continue;
            this.itemDeviceService.update((Object)entity, loginStaffId);
        }
    }

    private void updateInspectionResultCustom(List<SceneInspectionTableItemCustomCurrent> itemList, Long loginStaffId, Long cid) {
        if (itemList == null || itemList.size() < 1 || loginStaffId == null || cid == null) {
            return;
        }
        for (SceneInspectionTableItemCustomCurrent entity : itemList) {
            if (entity.getId() == null) continue;
            this.itemCustomCurrentService.update((Object)entity, loginStaffId);
        }
    }

    public PageInfo<SceneInspection> getPageUnfinishedInspection(Long cid, JqGridParam param, Integer year) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SceneInspection> inspectionList = this.getUnfinishedList(cid, year);
        for (SceneInspection inspection : inspectionList) {
            inspection.setInspectionDirectorName(this.staffService.getStaffNameIncludeDelStatusByStaffId(inspection.getInspectionDirector()));
        }
        PageInfo pageInfo = new PageInfo(inspectionList);
        return pageInfo;
    }

    public PageInfo<SceneInspection> getPageUnfinishedInspectionSuperiors(Long cid, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SceneInspection> inspectionList = this.getUnfinishedSuperiorsList(cid);
        for (SceneInspection inspection : inspectionList) {
            String inspectionTypes = inspection.getInspectionTypeName();
            if (StringUtils.isEmpty((CharSequence)inspectionTypes)) continue;
            String[] types = inspectionTypes.split(",");
            StringBuffer typeStr = new StringBuffer();
            block1: for (String t : types) {
                for (InspectionTableTypeEnum tEnum : InspectionTableTypeEnum.values()) {
                    if (!tEnum.getName().equals(t)) continue;
                    typeStr.append(t);
                    typeStr.append(",");
                    continue block1;
                }
            }
            if (typeStr.length() > 0) {
                typeStr.deleteCharAt(typeStr.lastIndexOf(","));
            }
            inspection.setInspectionTypeName(typeStr.toString());
            inspection.setInspectionDirectorName(this.staffService.getStaffNameIncludeDelStatusByStaffId(inspection.getInspectionDirector()));
        }
        PageInfo pageInfo = new PageInfo(inspectionList);
        return pageInfo;
    }

    public List<SceneInspection> getListCompanyInspection(Long cid, int year) {
        if (cid == null) {
            return Collections.emptyList();
        }
        Calendar startC = Calendar.getInstance();
        startC.set(year, 0, 0, 0, 0);
        Date start = startC.getTime();
        Calendar startE = Calendar.getInstance();
        startE.set(year + 1, 0, 0, 0, 0);
        Date end = startE.getTime();
        Example example = new Example(SceneInspection.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.finished.getValue()).andGreaterThanOrEqualTo("inspectionActualTime", (Object)start).andLessThan("inspectionActualTime", (Object)end).andLike("inspectionType1", "%" + InspectionTableTypeEnum.occupationalHelath.getValue() + "%");
        for (Object obj : InspectionObjectEnum.inspectionTypeSuper.getValue()) {
            InspectionTypeEnum type = (InspectionTypeEnum)obj;
            criteria.andNotEqualTo("inspectionType", (Object)type.getValue());
        }
        List list = ((SceneInspectionMapper)this.dao).selectByExample(example);
        for (SceneInspection inspection : list) {
            inspection.setReformList(this.reformService.getReformListBySourceId(inspection.getId()));
        }
        return list;
    }

    public List<SceneInspection> getSupperInspectionInfo(Long cid, int year) {
        if (cid == null) {
            return Collections.emptyList();
        }
        Calendar startC = Calendar.getInstance();
        startC.set(year, 0, 0, 0, 0);
        Date start = startC.getTime();
        Calendar startE = Calendar.getInstance();
        startE.set(year + 1, 0, 0, 0, 0);
        Date end = startE.getTime();
        Example example = new Example(SceneInspection.class);
        for (Object obj : InspectionObjectEnum.inspectionTypeSuper.getValue()) {
            InspectionTypeEnum type = (InspectionTypeEnum)obj;
            example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.finished.getValue()).andGreaterThanOrEqualTo("inspectionActualTime", (Object)start).andLessThan("inspectionActualTime", (Object)end).andEqualTo("inspectionType", (Object)type.getValue()).andLike("inspectionType1", "%" + InspectionTableTypeEnum.occupationalHelath.getValue() + "%");
        }
        List list = ((SceneInspectionMapper)this.dao).selectByExample(example);
        for (SceneInspection inspection : list) {
            inspection.setReformList(this.reformService.getReformListBySourceId(inspection.getId()));
        }
        return list;
    }

    @Transactional(readOnly=false)
    public SceneInspection saveInspectionSuperiors(SceneInspection entity, Long loginStaffId, Long cid) {
        if (entity == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        this.setInspectionRedundance(entity);
        if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
            ValidateUtil.valid((Object)entity, (String)"superiors");
        }
        if (entity.getId() == null) {
            entity = super.add(entity, loginStaffId, cid);
        } else {
            super.update(entity, loginStaffId);
        }
        if (StatusEnum.finished.getValue().equals(entity.getStatus())) {
            this.reformService.businessCompleteToUpdateReform(entity.getId(), loginStaffId);
        }
        return entity;
    }

    public PageInfo<SceneInspection> getPagefinishedInspection(Long cid, JqGridParam param, Integer year) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SceneInspection> inspectionList = this.getFinishedList(cid, param, year);
        PageInfo pageInfo = new PageInfo(inspectionList);
        return pageInfo;
    }

    @Transactional
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        if (detail == null) {
            return null;
        }
        SceneInspection entity = new SceneInspection();
        entity.setWorkName(detail.getBusinessName());
        entity.setInspectionNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.SHIELDFETCH.getCode()));
        entity.setInspectionActualTime(detail.getBusinessPlantime());
        entity.setInspectionDirector(detail.getManagerId());
        entity.setInspectionType(InspectionTypeEnum.getTypeByString((String)detail.getWorkSubtype()));
        entity.setStatus(StatusEnum.draff.getValue());
        this.saveInspection(entity, detail.getCreatorBy(), detail.getCid());
        return entity.getId();
    }

    private void setInspectionTypeCriteria(Example example, InspectionTableTypeEnum type, Calendar start, Calendar end, Long cid) {
        Example.Criteria criteria = example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("inspectionActualTime", (Object)start.getTime()).andLessThanOrEqualTo("inspectionActualTime", (Object)end.getTime()).andEqualTo("status", (Object)StatusEnum.finished.getValue());
        criteria.andLike("inspectionType1", "%" + type.getValue() + "%");
    }

    public List<SceneInspection> getInspectionListByYear(Integer year, Long cid, List<InspectionTableTypeEnum> typeList) {
        if (year == null || cid == null || typeList == null || typeList.isEmpty()) {
            return Collections.emptyList();
        }
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + 1, 0, 0, 0, 0, 0);
        Example example = new Example(SceneInspection.class);
        boolean hasType1 = false;
        if (typeList != null) {
            for (InspectionTableTypeEnum type : typeList) {
                if (InspectionTableTypeEnum.occupationalHelath.getValue().equals(type.getValue())) {
                    this.setInspectionTypeCriteria(example, type, start, end, cid);
                    hasType1 = true;
                    continue;
                }
                if (!InspectionTableTypeEnum.security.getValue().equals(type.getValue())) continue;
                this.setInspectionTypeCriteria(example, type, start, end, cid);
                hasType1 = true;
            }
        }
        if (!hasType1) {
            Collections.emptyList();
        }
        return ((SceneInspectionMapper)this.dao).selectByExample(example);
    }

    public InspectionAndReformMonthCountSummaryVo getMonthSummaryByYear(String yearStr, Long cid, List<InspectionTableTypeEnum> typeList) {
        InspectionAndReformMonthCountSummaryVo vo = new InspectionAndReformMonthCountSummaryVo();
        if (!StringUtils.isInteger((String)yearStr)) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<SceneInspection> list = this.getInspectionListByYear(year, cid, typeList);
        SceneInspectionMonthCountSummaryVo monthSummary = new SceneInspectionMonthCountSummaryVo();
        vo.setInspection(monthSummary);
        if (list == null || list.isEmpty()) {
            return vo;
        }
        ReformMonthCountSummaryVo reformVo = new ReformMonthCountSummaryVo();
        vo.setReform(reformVo);
        Calendar calendar = Calendar.getInstance();
        for (SceneInspection inspection : list) {
            if (inspection.getInspectionActualTime() == null) continue;
            calendar.setTime(inspection.getInspectionActualTime());
            int month = calendar.get(2);
            switch (month) {
                case 0: {
                    monthSummary.setJanSceneCount(monthSummary.getJanSceneCount() + 1);
                    reformVo.setJanReformCount(reformVo.getJanReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 1: {
                    monthSummary.setFebSceneCount(monthSummary.getFebSceneCount() + 1);
                    reformVo.setFebReformCount(reformVo.getFebReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 2: {
                    monthSummary.setMarSceneCount(monthSummary.getMarSceneCount() + 1);
                    reformVo.setMarReformCount(reformVo.getMarReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 3: {
                    monthSummary.setAprSceneCount(monthSummary.getAprSceneCount() + 1);
                    reformVo.setAprReformCount(reformVo.getAprReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 4: {
                    monthSummary.setMaySceneCount(monthSummary.getMaySceneCount() + 1);
                    reformVo.setMayReformCount(reformVo.getMayReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 5: {
                    monthSummary.setJuneSceneCount(monthSummary.getJuneSceneCount() + 1);
                    reformVo.setJuneReformCount(reformVo.getJuneReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 6: {
                    monthSummary.setJulySceneCount(monthSummary.getJulySceneCount() + 1);
                    reformVo.setJulyReformCount(reformVo.getJulyReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 7: {
                    monthSummary.setAugSceneCount(monthSummary.getAugSceneCount() + 1);
                    reformVo.setAugReformCount(reformVo.getAugReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 8: {
                    monthSummary.setSeptSceneCount(monthSummary.getSeptSceneCount() + 1);
                    reformVo.setSeptReformCount(reformVo.getSeptReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 9: {
                    monthSummary.setOctSceneCount(monthSummary.getOctSceneCount() + 1);
                    reformVo.setOctReformCount(reformVo.getOctReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 10: {
                    monthSummary.setNovSceneCount(monthSummary.getNovSceneCount() + 1);
                    reformVo.setNovReformCount(reformVo.getNovReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
                case 11: {
                    monthSummary.setDecSceneCount(monthSummary.getDecSceneCount() + 1);
                    reformVo.setDecReformCount(reformVo.getDecReformCount() + this.reformService.getCountBySourceId(inspection.getId()));
                    break;
                }
            }
        }
        return vo;
    }

    public InspectionTypeCountSummaryVo getInspectionTypeCountSummaryByYear(String yearStr, Long cid, List<InspectionTableTypeEnum> typeList) {
        InspectionTypeCountSummaryVo vo = new InspectionTypeCountSummaryVo();
        if (!StringUtils.isInteger((String)yearStr)) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<SceneInspection> list = this.getInspectionListByYear(year, cid, typeList);
        for (SceneInspection inspection : list) {
            if (InspectionTypeEnum.comprehensive.getValue().equals(inspection.getInspectionType())) {
                vo.setComprehensive(vo.getComprehensive() + 1);
                continue;
            }
            if (InspectionTypeEnum.professional.getValue().equals(inspection.getInspectionType())) {
                vo.setProfessional(vo.getProfessional() + 1);
                continue;
            }
            if (InspectionTypeEnum.superiorsInspect.getValue().equals(inspection.getInspectionType())) {
                vo.setSuperiorsInspect(vo.getSuperiorsInspect() + 1);
                continue;
            }
            if (InspectionTypeEnum.dailyInspection.getValue().equals(inspection.getInspectionType())) {
                vo.setDailyInspection(vo.getDailyInspection() + 1);
                continue;
            }
            if (InspectionTypeEnum.accidentAnalogy.getValue().equals(inspection.getInspectionType())) {
                vo.setAccidentAnalogy(vo.getAccidentAnalogy() + 1);
                continue;
            }
            if (InspectionTypeEnum.majorHazard.getValue().equals(inspection.getInspectionType())) {
                vo.setMajorHazard(vo.getMajorHazard() + 1);
                continue;
            }
            if (InspectionTypeEnum.holidayAround.getValue().equals(inspection.getInspectionType())) {
                vo.setHolidayAround(vo.getHolidayAround() + 1);
                continue;
            }
            if (InspectionTypeEnum.seasonality.getValue().equals(inspection.getInspectionType())) {
                vo.setSeasonality(vo.getSeasonality() + 1);
                continue;
            }
            if (InspectionTypeEnum.agency.getValue().equals(inspection.getInspectionType())) {
                vo.setAgency(vo.getAgency() + 1);
                continue;
            }
            if (!InspectionTypeEnum.other.getValue().equals(inspection.getInspectionType())) continue;
            vo.setOther(vo.getOther() + 1);
        }
        return vo;
    }

    @Transactional
    public void toVoid(Long id, Long loginStaffId) {
        if (id == null || loginStaffId == null) {
            throw new HealthException("\u4f5c\u5e9f\u53c2\u6570\u4e22\u5931");
        }
        SceneInspection entity = new SceneInspection();
        entity.setId(id);
        entity.setStatus(StatusEnum.toVoid.getValue());
        super.update(entity, loginStaffId);
    }

    public SceneInspection getSceneInspectionByTableId(Long tableId) {
        if (tableId == null) {
            return null;
        }
        Example example = new Example(SceneInspection.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andLike("inspectionTable", "%" + tableId + "%");
        List list = ((SceneInspectionMapper)this.dao).selectByExample(example);
        String tableIdStr = tableId + ",";
        for (SceneInspection inspection : list) {
            if (StringUtils.isBlank((CharSequence)inspection.getInspectionTable())) continue;
            if (inspection.getInspectionTable().startsWith(tableIdStr)) {
                inspection.setInspectionDirectorName(this.staffService.getStaffNameIncludeDelStatusByStaffId(inspection.getInspectionDirector()));
                return inspection;
            }
            if (inspection.getInspectionTable().indexOf("," + tableIdStr) <= -1) continue;
            inspection.setInspectionDirectorName(this.staffService.getStaffNameIncludeDelStatusByStaffId(inspection.getInspectionDirector()));
            return inspection;
        }
        return null;
    }

    public int getSuperSceneInspectionNum(Long cid, Integer year) {
        Example example = new Example(SceneInspection.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("inspectionType", (Object)InspectionTypeEnum.superiorsInspect.getValue()).andLike("inspectionType1", "%" + InspectionTableTypeEnum.occupationalHelath.getValue() + "%").andEqualTo("status", (Object)StatusEnum.finished.getValue());
        if (year != null) {
            Calendar start = Calendar.getInstance();
            start.set(year, 0, 0, 0, 0, 0);
            Calendar end = Calendar.getInstance();
            end.set(year + 1, 0, 0, 0, 0, 0);
            criteria.andGreaterThanOrEqualTo("inspectionActualTime", (Object)start.getTime()).andLessThan("inspectionActualTime", (Object)end.getTime());
        }
        return ((SceneInspectionMapper)this.dao).selectCountByExample(example);
    }

    @Transactional
    public void updateInspectionContentReform(Long reformBasicId, Byte reformStatus) {
        ReformItemBasic reform;
        boolean isFinished = false;
        if (StatusEnum.finished.getValue().equals(reformStatus)) {
            isFinished = true;
        }
        if ((reform = (ReformItemBasic)this.reformBaseService.getById(reformBasicId)) == null) {
            return;
        }
        if (reform.getReformItemSourceId() != null && !StatusEnum.complete.getValue().equals(reform.getStatus())) {
            return;
        }
        Long cid = reform.getCid();
        SceneInspectionTableItemReform record = this.itemReformService.getSceneInspectionTableItemReformByReformItemBasic(reform);
        List itemList = this.itemReformService.getItemListByReformId(reformBasicId);
        Example example = new Example(SceneInspection.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andNotEqualTo("status", (Object)StatusEnum.finished.getValue()).andIsNotNull("inspectionTable");
        List inspectionList = ((SceneInspectionMapper)this.dao).selectByExample(example);
        if (inspectionList == null || inspectionList.isEmpty()) {
            return;
        }
        if (itemList == null || itemList.isEmpty() && !isFinished) {
            for (SceneInspection inspection : inspectionList) {
                String[] tableIds;
                if (StringUtils.isBlank((CharSequence)inspection.getInspectionTable()) || (tableIds = inspection.getInspectionTable().split(",")) == null || tableIds.length == 0) continue;
                for (String tableId : tableIds) {
                    if (!StringUtils.isLong((String)tableId)) continue;
                    SceneInspectionTableCurrent table = (SceneInspectionTableCurrent)this.currentTableService.getById(Long.valueOf(tableId));
                    if (!InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) continue;
                    record.setTableId(table.getId());
                    record.setId(null);
                    this.itemReformService.add((Object)record, null, cid);
                }
            }
        } else {
            for (SceneInspectionTableItemReform item : itemList) {
                for (SceneInspection inspection : inspectionList) {
                    if (StringUtils.isBlank((CharSequence)inspection.getInspectionTable()) || inspection.getInspectionTable().indexOf("" + item.getTableId()) <= -1) continue;
                    if (isFinished) {
                        this.itemReformService.delete((Object)item, null);
                        continue;
                    }
                    record.setTableId(item.getTableId());
                    record.setId(item.getId());
                    this.itemReformService.update((Object)record, null);
                }
            }
        }
    }

    @Override
    public SceneInspection getById(Long id) {
        SceneInspection inspection = (SceneInspection)super.getById(id);
        if (inspection != null) {
            inspection.setInspectionDirectorName(this.staffService.getStaffNameIncludeDelStatusByStaffId(inspection.getInspectionDirector()));
        }
        return inspection;
    }
}

