/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.dao.work.reform.TmReformRateTableHistoryMapper;
import cn.smarthse.modules.health.entity.work.reform.TmReformRateTableHistory;
import cn.smarthse.modules.health.pojo.ReformRateStatisticVo;
import cn.smarthse.modules.health.pojo.RiskSolveRateSearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.ITmReformRateTableHistoryService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=false)
public class TmReformRateTableHistoryServiceImpl
extends BaseServiceImpl<TmReformRateTableHistoryMapper, TmReformRateTableHistory>
implements ITmReformRateTableHistoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TmReformRateTableHistoryServiceImpl.class);
    @Resource
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;

    public JqGridData<TmReformRateTableHistory> getRecordsPageData(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TmReformRateTableHistory> list = ((TmReformRateTableHistoryMapper)this.dao).getRecordsPageData(param);
        return new JqGridData(new PageInfo(list), param);
    }

    public JqGridData<TmReformRateTableHistory> getPageData(RiskSolveRateSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TmReformRateTableHistory> list = ((TmReformRateTableHistoryMapper)this.dao).getPageData(param);
        return new JqGridData(new PageInfo(list), (JqGridParam)param);
    }

    public TmReformRateTableHistory getData(RiskSolveRateSearchParam param) {
        return ((TmReformRateTableHistoryMapper)this.dao).getData(param);
    }

    public void historyDataBackup(RiskSolveRateSearchParam param) {
        log.debug("\u5de1\u67e5\u6574\u6539\u7387\u4e00\u89c8\u8868\u5386\u53f2\u6570\u636e\u7edf\u8ba1\u5165\u5e93\u5f00\u59cb\uff1a\u65f6\u95f4-{}", (Object)System.currentTimeMillis());
        List<AreaModel> allZJAreas = ((TmReformRateTableHistoryMapper)this.dao).getAreaListByProvinceIdAndLevel(330000000000L, null);
        List areaModels = allZJAreas.stream().filter(areaModel -> areaModel.getLevel() <= 3).collect(Collectors.toList());
        List areaModels1 = allZJAreas.stream().filter(areaModel -> areaModel.getLevel() == 1).collect(Collectors.toList());
        ArrayList<Boolean> cityLevels = new ArrayList<Boolean>();
        cityLevels.add(null);
        cityLevels.add(true);
        cityLevels.add(false);
        cityLevels.forEach(cityLevel -> {
            this.historyDataBackup1(areaModels, (Boolean)cityLevel);
            this.historyDataBackup2(areaModels1, (Boolean)cityLevel);
        });
    }

    void historyDataBackup1(List<AreaModel> areaModels, Boolean cityLevel) {
        ArrayList<ReformRateStatisticVo> statisticVos = new ArrayList<ReformRateStatisticVo>();
        if (CollectionUtils.isEmpty(areaModels)) {
            return;
        }
        areaModels.forEach(area -> {
            RiskSolveRateSearchParam param = new RiskSolveRateSearchParam();
            param.setAreaId(area.getId());
            param.setAreaLevel(Integer.valueOf(area.getLevel().intValue()));
            param.setYears("2023");
            param.setCityLevel(cityLevel);
            if (param.getAreaLevel() <= 1) {
                param.setCityLevel(null);
            }
            if (param.getAreaLevel() > 2 && param.getCityLevel() != null) {
                param.setCityLevel(Boolean.valueOf(param.getCityLevel() == false));
            }
            ReformRateStatisticVo statisticVo = this.reformItemBasicService.reformRateTotalDataBackup(param);
            String selfCommitRate = this.companyGradeV3Service.collectGradeCaseSelfInfoByAreaIdBackup(area, Integer.valueOf(DateUtil.thisYear()), param.getCityLevel());
            statisticVo.setSelfCommitRate(selfCommitRate);
            statisticVo.setCityLevel(cityLevel);
            statisticVos.add(statisticVo);
        });
        this.addHistoryData(statisticVos);
    }

    void historyDataBackup2(List<AreaModel> areaModels, Boolean cityLevel) {
        AreaModel areaModel = areaModels.get(0);
        RiskSolveRateSearchParam param = new RiskSolveRateSearchParam();
        param.setCityLevel(cityLevel);
        param.setAreaId(Long.valueOf(330000000000L));
        param.setAreaLevel(Integer.valueOf(1));
        List totalList = this.reformItemBasicService.reformRateStatisticListDataBackup(param);
        if (!CollectionUtils.isEmpty((Collection)totalList)) {
            totalList.forEach(vo -> vo.setCityLevel(cityLevel));
            List selfCommitRateList = this.companyGradeV3Service.collectStreetGradeCaseSelfInfoBackup(areaModel, Integer.valueOf(2023), param.getCityLevel(), null);
            if (!CollectionUtils.isEmpty((Collection)selfCommitRateList)) {
                totalList.forEach(item -> selfCommitRateList.stream().filter(f -> f.getAreaId() != null && f.getAreaId().equals(item.getAreaId())).findFirst().ifPresent(selfCommitRate -> item.setSelfCommitRate(selfCommitRate.getValue())));
            }
        }
        this.addHistoryData(totalList);
    }

    void addHistoryData(List<ReformRateStatisticVo> rawData) {
        String batchNo = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        int datasYear = 2023;
        ArrayList result = new ArrayList();
        rawData.forEach(item -> {
            TmReformRateTableHistory history = new TmReformRateTableHistory();
            history.setBatchNo(batchNo);
            history.setDatasYear(Integer.valueOf(datasYear));
            history.setThisLevel(Integer.valueOf(item.getCityLevel() == null ? 2 : (item.getCityLevel() != false ? 1 : 0)));
            history.setAreaId(item.getAreaId());
            history.setAreaId1(item.getAreaId1());
            history.setAreaId2(item.getAreaId2());
            history.setAreaId3(item.getAreaId3());
            history.setAreaId4(item.getAreaId4());
            history.setAreaName(item.getAreaName());
            history.setAreaLevel(Integer.valueOf(Integer.parseInt(item.getAreaLevel())));
            history.setNeedPatrolCompNum(Integer.valueOf(item.getNeedPatrolBusinessCNum()));
            history.setPatrolledCompNum(Integer.valueOf(item.getPatrolledCNum()));
            history.setPatrolResolveRate(item.getCurrentHasReformedRate());
            history.setSelfCommitRate(item.getSelfCommitRate());
            history.setPatrolCoverRate(item.getPatrolCoverRate());
            history.setCreateDate(new Date());
            history.setUpdateDate(new Date());
            history.setIsValid(Boolean.valueOf(true));
            result.add(history);
        });
        ((TmReformRateTableHistoryMapper)this.dao).insertList(result);
    }
}

