/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.reform.RiskSourceMapper;
import cn.smarthse.modules.health.entity.work.reform.RiskSource;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IRiskSourceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=false)
public class RiskSourceServiceImpl
extends BaseServiceImpl<RiskSourceMapper, RiskSource>
implements IRiskSourceService {
    @Autowired
    private IReformItemBasicService reformItemBasicService;

    @Transactional(readOnly=false)
    public void riskSourceTask(String cids) {
        List<String> cidList = null;
        if (StringUtils.isNotEmpty((String)cids)) {
            cidList = Arrays.asList(cids.split(","));
        }
        List reformItemList = this.reformItemBasicService.getAllReformItemByCid(cidList);
        List<Long> needToGenDataCids = reformItemList.stream().map(RiskSource::getCid).collect(Collectors.toList());
        List<RiskSource> addList = this.batchInsert(needToGenDataCids, (byte)1);
        int pageSize = 500;
        int page = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List<RiskSource> subList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(subList)) continue;
            ((RiskSourceMapper)this.dao).batchInsert(subList);
        }
    }

    @Transactional(readOnly=false)
    public List<RiskSource> batchInsert(List<Long> needToGenDataCids, Byte dataSource) {
        if (CollectionUtils.isEmpty(needToGenDataCids)) {
            return new ArrayList<RiskSource>();
        }
        ArrayList<RiskSource> addList = new ArrayList<RiskSource>();
        ReformGenerationSourceEnum[] values = ReformGenerationSourceEnum.values();
        for (Long cid : needToGenDataCids) {
            if (cid == null) continue;
            for (ReformGenerationSourceEnum value : values) {
                RiskSource source = new RiskSource();
                source.setId(Long.valueOf(this.idworker.nextId()));
                source.setCid(cid);
                source.setGenerationSource(value.getValue());
                source.setSchTaskUpdateDate(new Date());
                source.setDataSource(dataSource);
                source.setCreateDate(new Date());
                source.setUpdateDate(new Date());
                source.setIsValid(Boolean.valueOf(true));
                addList.add(source);
            }
        }
        return addList;
    }

    @Transactional(readOnly=false)
    public void addRiskSource(Long cid, Byte generationSource, String reformItemSource) {
        if (cid == null || generationSource == null || reformItemSource == null) {
            return;
        }
        Example example = new Example(RiskSource.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("generationSource", (Object)generationSource).andEqualTo("isValid", (Object)true);
        RiskSource riskSource = (RiskSource)this.getOneByExample(example);
        if (riskSource == null) {
            ArrayList<Long> cidList = new ArrayList<Long>();
            cidList.add(cid);
            List<RiskSource> list = this.batchInsert(cidList, (byte)2);
            for (RiskSource source : list) {
                if (source == null || !Objects.equals(generationSource, source.getGenerationSource())) continue;
                if (StringUtils.isEmpty((CharSequence)source.getReformItemSources())) {
                    source.setReformItemSources(reformItemSource + ",");
                    continue;
                }
                source.setReformItemSources(source.getReformItemSources() + reformItemSource + ",");
            }
            ((RiskSourceMapper)this.dao).batchInsert(list);
        } else {
            if (StringUtils.isEmpty((CharSequence)riskSource.getReformItemSources())) {
                riskSource.setReformItemSources(reformItemSource + ",");
            } else {
                riskSource.setReformItemSources(riskSource.getReformItemSources() + reformItemSource + ",");
            }
            this.updateByPrimaryKey(riskSource, 0L);
        }
    }

    @Transactional(readOnly=false)
    public void addRiskSourceList(List<RiskSource> riskSourceList) {
        if (CollectionUtils.isEmpty(riskSourceList)) {
            return;
        }
        Long cid = riskSourceList.get(0).getCid();
        Map<Byte, RiskSource> map = riskSourceList.stream().collect(Collectors.toMap(RiskSource::getGenerationSource, v -> v));
        Example example = new Example(RiskSource.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(example);
        if (CollectionUtils.isEmpty(listByExample)) {
            ArrayList<Long> cidList = new ArrayList<Long>();
            cidList.add(cid);
            List<RiskSource> list = this.batchInsert(cidList, (byte)2);
            for (RiskSource source : list) {
                RiskSource riskSource;
                if (source == null || (riskSource = map.get(source.getGenerationSource())) == null) continue;
                if (StringUtils.isEmpty((CharSequence)source.getReformItemSources())) {
                    source.setReformItemSources(riskSource.getReformItemSources() + ",");
                    continue;
                }
                source.setReformItemSources(source.getReformItemSources() + riskSource.getReformItemSources() + ",");
            }
            ((RiskSourceMapper)this.dao).batchInsert(list);
        } else {
            for (RiskSource riskSource : listByExample) {
                RiskSource source = map.get(riskSource.getGenerationSource());
                if (source == null) continue;
                if (StringUtils.isEmpty((CharSequence)riskSource.getReformItemSources())) {
                    riskSource.setReformItemSources(source.getReformItemSources() + ",");
                    continue;
                }
                riskSource.setReformItemSources(riskSource.getReformItemSources() + source.getReformItemSources() + ",");
            }
            this.batchUpdateOrInsert(listByExample, RiskSourceMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        }
    }
}

