/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.reform.RiskResolutionSourceMapper;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionSource;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.model.riskResolution.RiskSourceModel;
import cn.smarthse.modules.health.service.work.reform.IRiskResolutionSourceService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=false)
public class RiskResolutionSourceServiceImpl
extends BaseServiceImpl<RiskResolutionSourceMapper, RiskResolutionSource>
implements IRiskResolutionSourceService {
    public void saveIfNotExist(RiskResolutionSource riskResolutionSource) {
        ((RiskResolutionSourceMapper)this.dao).saveIfNotExist(riskResolutionSource);
    }

    public void saveBatchIfNotExist(List<RiskResolutionSource> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ((RiskResolutionSourceMapper)this.dao).saveBatchIfNotExist(list);
    }

    public List<RiskSourceModel> getSourceByRiskBasicId(Long riskBasicId) {
        Example example = new Example(RiskResolutionSource.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("riskBasicId", (Object)riskBasicId);
        List list = this.getListByExample(example);
        return list.stream().map(r -> {
            RiskSourceModel model = new RiskSourceModel();
            model.setId(r.getId());
            model.setRiskBasicId(riskBasicId);
            model.setName(ReformSourceLiteEnum.getSourceNameByValue((Byte)r.getReformItemSource()));
            return model;
        }).collect(Collectors.toList());
    }
}

