/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.work.reform.RiskResolutionBasicMapper;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionAccept;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionBasic;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionSource;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.reform.ReformAcceptanceRecordStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.work.reform.IRiskResolutionAcceptService;
import cn.smarthse.modules.health.service.work.reform.IRiskResolutionBasicService;
import cn.smarthse.modules.health.service.work.reform.IRiskResolutionSourceService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class RiskResolutionBasicServiceImpl
extends BaseServiceImpl<RiskResolutionBasicMapper, RiskResolutionBasic>
implements IRiskResolutionBasicService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final IRiskResolutionSourceService riskResolutionSourceService;
    private final IRiskResolutionAcceptService riskResolutionAcceptService;
    private final ApplicationContext ac;
    @Autowired
    protected IdWorker idWorker;

    @Transactional(readOnly=false)
    public void generateSingleRisk(Long cid, Long orgId, Long areaId, ReformGenerationSourceEnum type, Long businessId, String riskName, String reformMeasures, Long finder, String findName, Date findTime, ReformSourceLiteEnum source) {
        RiskResolutionBasic basic = this.getByCidAndGenerationSource(cid, findTime, type);
        if (Objects.isNull(basic)) {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(areaId);
            basic = RiskResolutionBasic.builder().id(Long.valueOf(this.idWorker.nextId())).provinceId(areaModel.getProvinceId()).cityId(areaModel.getCityId()).areaId(areaModel.getAreaId()).streetId(areaModel.getStreetId()).status(ReformStatusEnum.DZG.getValue()).cid(cid).thirdOrgId(orgId).name(riskName).description(riskName).finder(finder).finderName(findName).findTime(findTime).findYear(Integer.valueOf(DateUtils.getYear((Date)findTime))).generationSource(type.getValue()).build();
            basic = this.add(basic);
        }
        RiskResolutionSource riskResolutionSource = new RiskResolutionSource();
        riskResolutionSource.setId(Long.valueOf(this.idWorker.nextId()));
        riskResolutionSource.setRiskBasicId(basic.getId());
        riskResolutionSource.setReformItemSource(source.getValue());
        riskResolutionSource.setReformItemSourceId(businessId);
        this.riskResolutionSourceService.saveIfNotExist(riskResolutionSource);
        RiskResolutionAccept accept = new RiskResolutionAccept();
        accept.setId(Long.valueOf(this.idWorker.nextId()));
        accept.setRiskBasicId(basic.getId());
        accept.setReformMeasure(reformMeasures);
        if (basic.getStatus().equals(ReformStatusEnum.WC.getValue())) {
            accept.setStatus(ReformAcceptanceRecordStatusEnum.WC.getValue());
        } else {
            accept.setStatus(ReformAcceptanceRecordStatusEnum.CG.getValue());
        }
        if (Objects.equals(source.getValue(), ReformSourceLiteEnum.FWGJ.getValue())) {
            basic.setThirdOrgId(orgId);
            basic.setStatus(StatusEnum.approving.getValue());
        }
        this.settingAcceptInfo(orgId, type, riskName, basic, accept);
        this.riskResolutionAcceptService.add((Object)accept);
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.REFORM));
    }

    private void settingAcceptInfo(Long orgId, ReformGenerationSourceEnum type, String findName, RiskResolutionBasic basic, RiskResolutionAccept accept) {
        switch (type) {
            case OTHER: {
                break;
            }
            case ZRZC: 
            case JJZ: 
            case YSZYB: 
            case FC: 
            case ZYB: 
            case TJ: 
            case DECLARE: 
            case THREE_TIME: 
            case DETECTION: 
            case PROTECTION: 
            case WARNING_SIGNS: 
            case TRAIN: 
            case ARCHIVES: 
            case NOZYFZR: 
            case NOGLRY: {
                accept.setReformDirectorName(findName);
                break;
            }
            case SFTG: {
                basic.setFinder(orgId);
                break;
            }
            case JCCB: 
            case ZXJC: 
            case ZXJK: {
                break;
            }
        }
    }

    public RiskResolutionBasic getByCidAndGenerationSource(Long cid, Date findTime, ReformGenerationSourceEnum sourceEnum) {
        if (cid == null || sourceEnum == null) {
            return null;
        }
        Example example = new Example(RiskResolutionBasic.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("findTime", (Object)findTime).andEqualTo("generationSource", (Object)sourceEnum.getValue()).andEqualTo("isValid", (Object)true);
        return (RiskResolutionBasic)this.getOneByExample(example);
    }

    public Boolean existRisk(Long cid, Date findTime, ReformGenerationSourceEnum sourceEnum) {
        RiskResolutionBasic dbData = this.getByCidAndGenerationSource(cid, findTime, sourceEnum);
        return Objects.nonNull(dbData);
    }

    @Generated
    public RiskResolutionBasicServiceImpl(IRiskResolutionSourceService riskResolutionSourceService, IRiskResolutionAcceptService riskResolutionAcceptService, ApplicationContext ac) {
        this.riskResolutionSourceService = riskResolutionSourceService;
        this.riskResolutionAcceptService = riskResolutionAcceptService;
        this.ac = ac;
    }
}

