/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.dao.work.reform.ReformItemSourceMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformItemSource;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemSourceService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ReformItemSourceServiceImpl
extends BaseServiceImpl<ReformItemSourceMapper, ReformItemSource>
implements IReformItemSourceService {
    @Autowired
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @Autowired
    RedisClient redisClient;

    public List<ReformItemSource> getSourceListByBasicId(List<Long> basicIdList) {
        if (basicIdList == null || basicIdList.isEmpty()) {
            return Collections.emptyList();
        }
        return ((ReformItemSourceMapper)this.dao).getSourceListByBasicId(basicIdList);
    }

    @Transactional(readOnly=false)
    public Integer insertList2(List<ReformItemSource> sourceList) {
        return ((ReformItemSourceMapper)this.dao).insertList2(sourceList);
    }

    public List<ReformItemSource> getReformItemSourceListView(List<Long> basicIdList) {
        List<ReformItemSource> list = this.getSourceListByBasicId(basicIdList);
        List<String> cardIds = list.stream().filter(item -> item != null && item.getCid() != null && Arrays.asList(4, 5).contains(item.getGenerationSource().intValue()) && StringUtils.isNotBlank((CharSequence)item.getTjBusinessId())).map(ReformItemSource::getTjBusinessId).sorted(Comparator.reverseOrder()).toList();
        Map map = new HashMap();
        if (CollectionUtils.isNotEmpty(cardIds)) {
            Long cid = list.get(0).getCid();
            map = (Map)this.redisClient.get("phcPhysicalCheckV3221Service", "getCompanyNameDif:" + cardIds.hashCode() + ":" + cid, 3600L, () -> this.phcPhysicalStaffCheckInfoService.getCompanyNameDif(cardIds, cid));
        }
        for (ReformItemSource item2 : list) {
            if (item2 == null) continue;
            Date findTime = item2.getFindTime();
            Byte status = item2.getStatus();
            Date acceptanceDate = item2.getAcceptanceDate();
            if (findTime != null) {
                try {
                    Date begin = DateUtils.parseDate((String)"2024-01-01", (String[])new String[]{"yyyy-MM-dd"});
                    Date end = DateUtils.parseDate((String)"2024-03-01", (String[])new String[]{"yyyy-MM-dd"});
                    if (DateUtils.getYear((Date)findTime) == 2024 && status != null && (status == 3 || status == 4) && acceptanceDate != null && DateUtils.compareDate((Date)acceptanceDate, (Date)begin) >= 0L && DateUtils.compareDate((Date)acceptanceDate, (Date)end) <= 0L) {
                        item2.setFindTimeStr("\u65e0\u9700\u63a8\u9001");
                    } else if (Objects.equals(7, item2.getCompanyRadioactivityType()) && !Objects.equals((byte)11, item2.getGenerationSource())) {
                        item2.setFindTimeStr("-");
                    } else {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        item2.setFindTimeStr(format.format(findTime));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item2.getFinderName()) && item2.getFinderName().equals("\u7cfb\u7edf")) {
                item2.setSysFinder(true);
                item2.setSysFinderName("\u7cfb\u7edf");
            }
            if (item2.getCreateDate() != null) {
                item2.setRemindDate(DateUtil.getFromDate2((Date)item2.getFindTime()).minusMonths(1L));
            }
            if (StringUtils.isBlank((CharSequence)item2.getFinderName())) {
                item2.setFinderName("\u7cfb\u7edf");
            }
            if (!Arrays.asList(4, 5).contains(item2.getGenerationSource().intValue())) continue;
            item2.setOutpackName((String)map.get(item2.getTjBusinessId()));
        }
        return list;
    }
}

