/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.framework.utils.JqgridSearchUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.SysConvertTool;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.common.model.TrainCompanyStaffModel;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalCheckV3221Mapper;
import cn.smarthse.modules.health.dao.work.reform.CompanyRiskCompletionMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemAcceptanceRecordMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasicHarmFactor;
import cn.smarthse.modules.health.entity.work.reform.ReformItemMessageReceiver;
import cn.smarthse.modules.health.entity.work.reform.ReformProgramme;
import cn.smarthse.modules.health.entity.work.reform.RiskSource;
import cn.smarthse.modules.health.entity.work.reform.param.ReformRecordAcceptanceParam;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.AppReformItemListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.MobileReformItemListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemFinishedSeniorSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemThirdSearchVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformLastOrgInfo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformTableListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformWarningStatistics;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskInfoDataVo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskListItemDataVo;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.enums.archive.ArchiveViewStateEnum;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffDetailDataSourceEnum;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.reform.AcceptanceResultEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemHarmFactorStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemLevelEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformResolveStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProgressEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideProcessModel;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.pojo.ReformItemDetailVo;
import cn.smarthse.modules.health.pojo.ReformRateStatisticVo;
import cn.smarthse.modules.health.pojo.RiskSolveRateSearchParam;
import cn.smarthse.modules.health.pojo.RiskSolveRateStatisticVo;
import cn.smarthse.modules.health.pojo.SimpleCompanyInfoVo;
import cn.smarthse.modules.health.pojo.ThreeTimesInfo;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskProspectService;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformItemMessageReceiverService;
import cn.smarthse.modules.health.service.work.reform.IReformProgrammeService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeHelpCompanyVo;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.util.ReformItemUtil;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.riskResolve.RegionHistoryPunishInfo;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskNumInfoVo;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskStatisticsVo;
import cn.smarthse.modules.health.vo.riskResolve.RiskCalculator;
import cn.smarthse.modules.health.vo.riskResolve.RiskResolveResInfoVo;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.ReformLevelCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformMonthSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformOrgCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformSourceCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformTrendByYearSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformTypeCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.SceneInspectionSummaryVo;
import cn.smarthse.modules.health.vo.work.keyFactory.HealthManagementArchiveVo;
import cn.smarthse.modules.health.vo.work.keyFactory.KeyFactoryStateVo;
import cn.smarthse.modules.health.vo.work.keyFactory.ThreeTimeDetailVo;
import cn.smarthse.modules.health.vo.work.reform.ReformItemTodolistVO;
import cn.smarthse.modules.health.vo.work.reform.RiskLevelVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjListVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjSearch;
import cn.smarthse.modules.health.vo.work.reform.RiskReformSearchVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformVo;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=false)
public class ReformItemBasicServiceImpl
extends BaseServiceImpl<ReformItemBasicMapper, ReformItemBasic>
implements IReformItemBasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReformItemBasicServiceImpl.class);
    @Autowired
    ReformItemBasicMapper reformItemBasicMapper;
    @Autowired
    private IStaffInfoService staffService;
    @Autowired
    private IReformItemBasicNewService itemBasicNewService;
    @Autowired
    IReformItemBasicCommandService commandService;
    @Autowired
    @Lazy
    private ITsProjectSimpleService threeTimeService;
    @Autowired
    private IReformItemAcceptanceRecordService acceptanceRecordService;
    @Autowired
    private ICompanyAreaService areaService;
    @Autowired
    private ISysCoreWorkModuleCorrelationService moduleCorrelationService;
    @Autowired
    private ISceneInspectionService inspectionServcie;
    @Autowired
    private IHcCheckPlanService harmFactorService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private ICompanyOrganizationService organizationService;
    @Autowired
    private IReformItemMessageReceiverService reformMessage;
    @Autowired
    IMessageService messageService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    IBusinessNoService businessNoService;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;
    @Autowired
    private IReformProgrammeService reformProgrammeService;
    @Autowired
    private ITrusteeshipInfoDetailService trusteeshipInfoDetailService;
    @Autowired
    private ITrusteeshipInfoService trusteeshipInfoService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Value(value="${isActualize}")
    private String isActualize;
    @Autowired
    ApplicationContext ac;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private LiteArchiveMapper liteArchiveMapper;
    @Resource
    private CompanyRiskCompletionMapper riskCompleteMapper;
    @Autowired
    private ILiteArchiveFileItemService fileItemService;
    @Autowired
    private PhcPhysicalCheckV3221Mapper physicalCheckV3221Mapper;
    @DubboReference(version="1.0.0")
    private ICompanyRiskProspectService companyRiskProspectService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @Autowired
    private RedisClient redisClient;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String COMPLETE = "\u65e0\u98ce\u9669";
    private static final String IN_COMPLETE = "\u6709\u98ce\u9669";
    private static final String NO_RISK = "\u65e0\u98ce\u9669";
    private static final String IS_RISK = "\u6709\u98ce\u9669";
    private static final String HOME_INDEX_CACHE_KEY = "HomeIndexControllerV3223:getHelpCompanyInfo";
    private static final String HELP_COMPANY_HISTORY_CACHE_KEY = "HomeIndexControllerV3223:getHelpCompanyInfo:history";
    private static final String RISK_MITIGATION_CACHE_KEY = "RiskMitigationController";
    private static final String AREA_RISK_HISTORY_CACHE_KEY = "RiskMitigationController:areaRiskNumCountListData:history";
    private static final int CACHE_TIME = 7200;
    protected static final List<RiskLevelVo> DEFAULT_WARNING_STATE_LIST = Arrays.asList(new RiskLevelVo("firstAlert", "\u9996\u6b21\u9884\u8b66", Long.valueOf(0L)), new RiskLevelVo("yellowAlert", "\u9ec4\u8272\u9884\u8b66", Long.valueOf(0L)), new RiskLevelVo("redAlert", "\u7ea2\u8272\u9884\u8b66", Long.valueOf(0L)), new RiskLevelVo("executeLaw", "\u542f\u52a8\u6267\u6cd5", Long.valueOf(0L)));
    protected static final List<KeyFactoryStateVo> DEFAULT_KEY_FACTOR_STATE_LIST = Arrays.asList(new KeyFactoryStateVo("declare", "\u7533\u62a5", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("detection", "\u68c0\u6d4b", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("physicalExamination", "\u4f53\u68c0", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("training", "\u8d1f\u8d23\u4eba\u57f9\u8bad", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("trisimultaneity", "\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("protection", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("warningMark", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", "\u65e0\u98ce\u9669"), new KeyFactoryStateVo("archive", "\u804c\u4e1a\u536b\u751f\u6863\u6848", "\u65e0\u98ce\u9669"));
    protected static final List<RiskTypeVo> DEFAULT_RISK_TYPE_STATE_LIST = Arrays.asList(new RiskTypeVo("declare_riskType", "\u7533\u62a5", "\u65e0\u98ce\u9669"), new RiskTypeVo("detection_riskType", "\u68c0\u6d4b", "\u65e0\u98ce\u9669"), new RiskTypeVo("physicalExamination_riskType", "\u4f53\u68c0", "\u65e0\u98ce\u9669"), new RiskTypeVo("training_riskType", "\u8d1f\u8d23\u4eba\u57f9\u8bad", "\u65e0\u98ce\u9669"), new RiskTypeVo("threeTime_riskType", "\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", "\u65e0\u98ce\u9669"), new RiskTypeVo("protective_riskType", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", "\u65e0\u98ce\u9669"), new RiskTypeVo("warningMark_riskType", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", "\u65e0\u98ce\u9669"), new RiskTypeVo("suspected_occ_disease", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u7591\u4f3c\u804c\u4e1a\u75c5", "\u65e0\u98ce\u9669"), new RiskTypeVo("occ_contraindications", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u804c\u4e1a\u7981\u5fcc\u8bc1", "\u65e0\u98ce\u9669"), new RiskTypeVo("jccbzg_riskType", "\u76d1\u6d4b\u7ed3\u679c\u8d85\u6807\u6574\u6539", "\u65e0\u98ce\u9669"), new RiskTypeVo("jccb_riskType", "\u68c0\u6d4b\u7ed3\u679c\u8d85\u6807", "\u65e0\u98ce\u9669"), new RiskTypeVo("healthArchive_riskType", "\u804c\u4e1a\u536b\u751f\u6863\u6848", "\u65e0\u98ce\u9669"), new RiskTypeVo("grjl_riskType", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b", "\u65e0\u98ce\u9669"), new RiskTypeVo("grjlcb_riskType", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u7ed3\u679c\u5f02\u5e38", "\u65e0\u98ce\u9669"));

    private void setRedundancyInfo(ReformItemBasic entity) {
        if (entity.getFinder() != null) {
            entity.setFinderName(this.staffService.getStaffNameByStaffId(entity.getFinder()));
        }
        if (entity.getBusinessStatus() == null) {
            entity.setBusinessStatus(StatusEnum.none.getValue());
        }
        if (cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)entity.getReformItemFiles())) {
            entity.setReformItemFiles(",");
        }
        if (entity.getReformItemPosition() != null) {
            entity.setReformItemPositionName(this.areaService.getAreaNamesByAreaIds("" + entity.getReformItemPosition()));
        }
        if (entity.getCid() != null) {
            this.setCompanyAreaDetail(entity);
        }
    }

    @Transactional(readOnly=false)
    public ReformItemBasic saveReformItemBasic(ReformItemBasic entity, Long cid, Long loginStaffId) {
        if (entity == null) {
            return null;
        }
        this.setRedundancyInfo(entity);
        ReformItemBasic oldEnity = (ReformItemBasic)super.getById(entity.getId());
        if (oldEnity != null && StatusEnum.finished.getValue().equals(oldEnity.getBusinessStatus())) {
            entity.setStatus(null);
            entity.setBusinessStatus(null);
            super.update(entity, loginStaffId);
            return entity;
        }
        if (!entity.isMessageEmpty()) {
            entity.setEditor(((MessageReceiver)entity.getMessage().getReceivers().get(0)).getReveiver());
        } else {
            entity.setEditor(Long.valueOf(1L));
        }
        if (entity.getId() == null) {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                if (entity.getReformItemSource() != null && ReformSourceEnum.supervise.getValue().equals(entity.getReformItemSource())) {
                    entity.setFinder(Long.valueOf(1L));
                    if (cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)entity.getFinderName())) {
                        throw new HealthException("\u9690\u60a3\u53d1\u73b0\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                ValidateUtil.valid((Object)entity, (String)"add");
            }
            super.add(entity, loginStaffId, cid);
        } else {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                if (entity.getReformItemSource() != null && ReformSourceEnum.supervise.getValue().equals(entity.getReformItemSource())) {
                    entity.setFinder(Long.valueOf(1L));
                    if (cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)entity.getFinderName())) {
                        throw new HealthException("\u9690\u60a3\u53d1\u73b0\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                ValidateUtil.valid((Object)entity, (String)"edit");
            }
            super.update(entity, loginStaffId);
        }
        if (entity.getAcceptance() != null && !entity.getAcceptance().isEmpty()) {
            entity.getAcceptance().setReformItemId(entity.getId());
            this.acceptanceRecordService.saveAcceptanceInfo(entity.getAcceptance(), loginStaffId, cid);
        } else if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
            ReformItemAcceptanceRecord subAcceptanceRecord = new ReformItemAcceptanceRecord();
            subAcceptanceRecord.setReformItemId(entity.getId());
            this.acceptanceRecordService.saveAcceptanceInfo(subAcceptanceRecord, loginStaffId, cid);
        }
        this.inspectionServcie.updateInspectionContentReform(entity.getId(), entity.getStatus());
        if (entity.getReformItemSourceId() != null) {
            List receivers = this.reformMessage.getReceiverListByBusinessId(entity.getId());
            for (ReformItemMessageReceiver r : receivers) {
                this.reformMessage.delete((Object)r);
            }
            if (!entity.isMessageEmpty()) {
                ArrayList<Long> staffIdList = new ArrayList<Long>();
                for (MessageReceiver re : entity.getMessage().getReceivers()) {
                    ReformItemMessageReceiver receiver = new ReformItemMessageReceiver();
                    receiver.setBusinessId(entity.getId());
                    receiver.setCid(cid);
                    receiver.setReveiver(re.getReveiver());
                    if (ReformSourceEnum.harmFactorInspection.getValue().equals(entity.getReformItemSource())) {
                        receiver.setStatus(StatusEnum.sended.getValue());
                        if (re.getReveiver() != null) {
                            staffIdList.add(re.getReveiver());
                        }
                    } else {
                        receiver.setStatus(StatusEnum.draff.getValue());
                    }
                    this.reformMessage.add((Object)receiver, loginStaffId, cid);
                }
                if (ReformSourceEnum.harmFactorInspection.getValue().equals(entity.getReformItemSource()) && StatusEnum.complete.getValue().equals(entity.getStatus())) {
                    this.sendReformItemBasicMessage(entity, loginStaffId, cid, staffIdList);
                }
            }
        }
        return entity;
    }

    @Transactional(readOnly=false)
    public ReformItemBasic saveGenerationReform(ReformItemBasic entity, Long loginStaffId) {
        return this.itemBasicNewService.saveOrSubmitReform(entity, loginStaffId);
    }

    private void addAcceptance(ReformItemBasic entity, Long loginStaffId) {
        ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
        acce.setRequireFinishTime(entity.getAcceptance().getRequireFinishTime());
        acce.setReformItemId(entity.getId());
        acce.setCid(entity.getCid());
        this.acceptanceRecordService.add((Object)acce, entity.getUpdateBy(), entity.getCid());
    }

    private void addOrUpdateProgramme(ReformItemBasic entity, Long loginStaffId) {
        if (entity.getProgrammeList() != null) {
            this.reformProgrammeService.deleteByReformId(entity.getAcceptance().getId());
            List list = entity.getProgrammeList();
            for (ReformProgramme pro : list) {
                if (pro.getType() == null) continue;
                pro.setReformId(entity.getAcceptance().getId());
                this.reformProgrammeService.add((Object)pro, loginStaffId, entity.getCid());
            }
        }
    }

    private List<ReformItemBasic> getReformItemList(Long cid, JqGridParam param, BusinessTypeEnum businessType) {
        if (cid == null) {
            return null;
        }
        Example example = this.getUnfinishedExample(cid, businessType, param);
        example.setOrderByClause("create_date desc");
        DataScopeHelper.startDataScope("reformItem", "reform_item_basic");
        List list = ((ReformItemBasicMapper)this.dao).selectByExample(example);
        return list;
    }

    public ReformItemAcceptanceRecord getAcceptanceRecordById(Long id) {
        if (id == null) {
            return null;
        }
        ReformItemAcceptanceRecord entity = (ReformItemAcceptanceRecord)this.acceptanceRecordService.getById(id);
        if (entity != null) {
            entity.setReformItemBasic(this.getById(entity.getReformItemId()));
        }
        return entity;
    }

    @Override
    public ReformItemBasic getById(Long id) {
        if (id == null) {
            return null;
        }
        ReformItemBasic entity = (ReformItemBasic)super.getById(id);
        this.setAceptanceInfo(entity);
        return entity;
    }

    private void setAceptanceInfo(ReformItemBasic entity) {
        if (entity != null && entity.getId() != null) {
            List recordList = this.acceptanceRecordService.getListByReformItemId(entity.getId());
            if (CollectionUtils.isEmpty((Collection)recordList)) {
                return;
            }
            entity.setAceptanceList(recordList);
            entity.setAcceptance((ReformItemAcceptanceRecord)entity.getAceptanceList().get(entity.getAceptanceList().size() - 1));
        }
    }

    @Transactional
    public ReformItemAcceptanceRecord saveAcceptanceRecordOnly(ReformItemAcceptanceRecord entity, Long loginStaffId, Long cid, String statusType) {
        ReformItemAcceptanceRecord recordOld = (ReformItemAcceptanceRecord)this.acceptanceRecordService.getById(entity.getId());
        ReformItemAcceptanceRecord record = this.acceptanceRecordService.saveAcceptanceInfo(entity, loginStaffId, cid);
        if (!StatusEnum.finished.name().equals(statusType) && AcceptanceResultEnum.unComplete.getValue().equals(entity.getAcceptanceResult())) {
            ReformItemAcceptanceRecord subAcceptanceRecord = new ReformItemAcceptanceRecord();
            subAcceptanceRecord.setReformItemId(entity.getReformItemId());
            subAcceptanceRecord = this.acceptanceRecordService.saveAcceptanceInfo(subAcceptanceRecord, loginStaffId, cid);
            return subAcceptanceRecord;
        }
        return record;
    }

    @Transactional(readOnly=false)
    public ReformItemAcceptanceRecord saveReformItemAcceptanceRecord(ReformItemAcceptanceRecord entity, Long loginStaffId, Long cid, String status) {
        boolean isFinished = false;
        if (entity.getId() == null) {
            if (StatusEnum.complete.getValue().equals(entity.getStatus()) && AcceptanceResultEnum.complete.getValue().equals(entity.getAcceptanceResult())) {
                isFinished = true;
            }
        } else if (StatusEnum.complete.getValue().equals(entity.getStatus()) && AcceptanceResultEnum.complete.getValue().equals(entity.getAcceptanceResult())) {
            isFinished = true;
        }
        this.acceptanceRecordService.saveAcceptanceInfo(entity, loginStaffId, cid);
        this.inspectionServcie.updateInspectionContentReform(entity.getReformItemId(), isFinished ? StatusEnum.finished.getValue() : null);
        String messStr = "";
        if (isFinished || StatusEnum.finished.name().equals(status)) {
            this.finishReformItem(entity.getReformItemId(), loginStaffId, cid);
            isFinished = true;
            return entity;
        }
        if (StatusEnum.complete.getValue().equals(entity.getStatus())) {
            if (AcceptanceResultEnum.unComplete.getValue().equals(entity.getAcceptanceResult())) {
                ReformItemAcceptanceRecord subAcceptanceRecord = new ReformItemAcceptanceRecord();
                if (!entity.isMessageEmpty()) {
                    subAcceptanceRecord.setReformDirector(((MessageReceiver)entity.getMessage().getReceivers().get(0)).getReveiver());
                    messStr = "\u5f85\u6574\u6539";
                }
                subAcceptanceRecord.setReformItemId(entity.getReformItemId());
                this.acceptanceRecordService.saveAcceptanceInfo(subAcceptanceRecord, loginStaffId, cid);
                this.sendReformItemAcceptanceRecordMessage(entity, messStr, loginStaffId, cid);
                return subAcceptanceRecord;
            }
        } else if (StatusEnum.reformAboutComplete.getValue().equals(entity.getStatus())) {
            if (!entity.isMessageEmpty()) {
                messStr = "\u5f85\u9a8c\u6536";
            }
            this.sendReformItemAcceptanceRecordMessage(entity, messStr, loginStaffId, cid);
            return entity;
        }
        return entity;
    }

    private void sendReformItemBasicMessage(ReformItemBasic entity, Long loginStaffId, Long cid, List<Long> receivers) {
        Message message = new Message();
        message.setReceivers(new ArrayList());
        for (Long r : receivers) {
            MessageReceiver rr = new MessageReceiver();
            rr.setReveiver(r);
            message.getReceivers().add(rr);
        }
        message.setTypeName(MessageBusinessTypeEnum.work.getName());
        message.setBussinesType(MessageBusinessTypeEnum.work.getValue());
        message.setBussinesId(entity.getId());
        message.setBussinesNo(entity.getReformItemSn());
        message.setBussinesName(entity.getName() + "\uff08\u5f85\u6574\u6539\uff09");
        message.setBussinessContent(message.getBussinesName());
        message.setBussinesFrom(this.staffService.getStaffNameIncludeDelStatusAndDepByStaffId(loginStaffId));
        message.setSendTime(new Date());
        message.setBussinesFromType(MessageBusinessFromEnum.reform.getValue());
        this.messageService.pushMessage(message, loginStaffId, cid);
    }

    private void sendReformItemAcceptanceRecordMessage(ReformItemAcceptanceRecord entity, String messStr, Long loginStaffId, Long cid) {
        if (!entity.isMessageEmpty()) {
            ReformItemBasic basic = (ReformItemBasic)super.getById(entity.getReformItemId());
            entity.getMessage().setTypeName(MessageBusinessTypeEnum.work.getName());
            entity.getMessage().setBussinesType(MessageBusinessTypeEnum.work.getValue());
            entity.getMessage().setBussinesId(basic.getId());
            entity.getMessage().setBussinesNo(basic.getReformItemSn());
            entity.getMessage().setBussinesName(basic.getName() + "\uff08" + messStr + "\uff09");
            entity.getMessage().setBussinessContent(entity.getMessage().getBussinesName());
            entity.getMessage().setBussinesFrom(this.staffService.getStaffNameIncludeDelStatusAndDepByStaffId(loginStaffId));
            entity.getMessage().setSendTime(new Date());
            entity.getMessage().setBussinesFromType(MessageBusinessFromEnum.reform.getValue());
            this.messageService.multiPushMessage(entity.getMessage(), loginStaffId, cid);
            basic.setEditor(((MessageReceiver)entity.getMessage().getReceivers().get(0)).getReveiver());
            super.update(basic, loginStaffId);
        }
    }

    private void finishReformItem(Long reformId, Long loginStaffId, Long cid) {
        ReformItemBasic oldEntity = (ReformItemBasic)super.getById(reformId);
        if (oldEntity != null && ReformSourceEnum.harmFactorInspection.getValue().equals(oldEntity.getReformItemSource())) {
            this.moduleCorrelationService.reformComplete(reformId, loginStaffId, cid);
        }
        ReformItemBasic entity = new ReformItemBasic();
        entity.setId(reformId);
        entity.setBusinessStatus(StatusEnum.finished.getValue());
        super.update(entity, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteAcceptanceRecord(Long id, Long staffId) {
        if (id == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        List records = this.acceptanceRecordService.getListByReformItemId(id);
        if (records != null) {
            for (ReformItemAcceptanceRecord record : records) {
                this.acceptanceRecordService.delete((Object)record);
            }
        }
    }

    @Override
    @Transactional
    public void delete(ReformItemBasic entity, Long loginStaffId) {
        super.delete(entity, loginStaffId);
        this.harmFactorService.recoveryNoAccordsByReformId(entity.getId());
        this.inspectionServcie.updateInspectionContentReform(entity.getId(), StatusEnum.finished.getValue());
    }

    private PageInfo<ReformItemListVo> getReformItemPage(Long cid, JqGridParam param, BusinessTypeEnum businessType) {
        if (cid == null) {
            return null;
        }
        if (JqgridSearchUtil.isSeniorSearch(param)) {
            return this.getReformItemFinishedPageSenior(cid, param);
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ReformItemBasic> basicList = this.getReformItemList(cid, param, businessType);
        return this.getVOPageInfo(basicList);
    }

    private List<ReformItemListVo> getReformItemForHarmFactorList(List<ReformItemBasic> basicList) {
        ArrayList<ReformItemListVo> voList = new ArrayList<ReformItemListVo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ReformItemBasic basic : basicList) {
            ReformItemListVo vo = new ReformItemListVo();
            List acceptanceList = this.acceptanceRecordService.getListByReformItemId(basic.getId());
            if (acceptanceList != null && !acceptanceList.isEmpty()) {
                int size = acceptanceList.size();
                vo.setReformDirector(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getReformDirectorName());
                boolean hasReformSolution = false;
                if (!StringUtils.isBlank((String)((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getReformSolution()) && !((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getReformSolution().equals(",")) {
                    hasReformSolution = true;
                    vo.setSolutionFiles(this.fileService.getListByIds(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getReformSolution()));
                }
                if (hasReformSolution || cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getReformMeasure())) {
                    vo.setReformSolution("\u6709");
                } else {
                    vo.setReformSolution("\u65e0");
                }
                if (((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getRequireFinishTime() != null) {
                    vo.setRequireFinishTime(sdf.format(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getRequireFinishTime()));
                }
                if (((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getUpdateDate() != null) {
                    vo.setUpdateTime(sdf.format(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getUpdateDate()));
                }
                vo.setAcceptanceDirector(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getAcceptanceDirectorName());
                if (((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getActualFinishTime() != null) {
                    vo.setActualFinishTime(sdf.format(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getActualFinishTime()));
                }
                if (((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getAcceptanceDate() != null) {
                    vo.setAcceptanceTime(sdf.format(((ReformItemAcceptanceRecord)acceptanceList.get(size - 1)).getAcceptanceDate()));
                }
            }
            for (ReformItemLevelEnum reformItemLevelEnum : ReformItemLevelEnum.values()) {
                if (!reformItemLevelEnum.getValue().equals(basic.getReformItemLevel())) continue;
                vo.setReformItemLevel(reformItemLevelEnum.getName());
                break;
            }
            vo.setStatus(basic.getStatus());
            vo.setReformItemId(basic.getId());
            vo.setReformItemName(basic.getName());
            vo.setDescription(basic.getDescription());
            vo.setIsAutoGeneration(basic.getIsAutoGeneration());
            vo.setGenerationSource(basic.getGenerationSource());
            vo.setBusinessStatus(basic.getBusinessStatus());
            if (vo.getBusinessStatus() != null) {
                if (vo.getBusinessStatus().intValue() == StatusEnum.finished.getValue().intValue()) {
                    vo.setIsReformFinished("\u662f");
                } else {
                    vo.setIsReformFinished("\u5426");
                }
            }
            vo.setReformItemSn(basic.getReformItemSn());
            if (basic.getReformItemSource() != null) {
                if ("true".equals(this.isActualize)) {
                    vo.setReformItemSource(ReformSourceEnum.getSourceNameByValue((Byte)basic.getReformItemSource()));
                } else {
                    vo.setReformItemSource(ReformSourceLiteEnum.getSourceNameByValue((Byte)basic.getReformItemSource()));
                }
            }
            for (ReformItemLevelEnum reformItemLevelEnum : ReformItemTypeEnum.values()) {
                if (!reformItemLevelEnum.getValue().equals(basic.getReformItemType())) continue;
                vo.setReformItemType(reformItemLevelEnum.getName());
                break;
            }
            if (basic.getFindTime() != null) {
                vo.setFindTime(sdf.format(basic.getFindTime()));
            }
            vo.setEditor(basic.getEditor());
            voList.add(vo);
        }
        return voList;
    }

    private List<RiskListItemDataVo> getReformItemForRiskListItemList(List<ReformItemBasic> basicList) {
        ArrayList<RiskListItemDataVo> voList = new ArrayList<RiskListItemDataVo>();
        List<Byte> generationList = this.getGenerationSourceValue();
        generationList.add(ReformGenerationSourceEnum.JCCB.getValue());
        generationList.add(ReformGenerationSourceEnum.JJZ.getValue());
        generationList.add(ReformGenerationSourceEnum.YSZYB.getValue());
        generationList.add(ReformGenerationSourceEnum.JCCBZG.getValue());
        generationList.add(ReformGenerationSourceEnum.GRJL.getValue());
        generationList.add(ReformGenerationSourceEnum.GRJLCB.getValue());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ReformItemBasic basic : basicList) {
            if (basic == null) continue;
            RiskListItemDataVo vo = new RiskListItemDataVo();
            BeanUtils.copyProperties((Object)basic, (Object)vo);
            vo.setStatus(basic.getStatus());
            vo.setId(basic.getId());
            vo.setCid(basic.getCid());
            vo.setName(basic.getName());
            vo.setGenerationSource(basic.getGenerationSource());
            vo.setSource(basic.getReformItemSource());
            vo.setWarningState(basic.getWarningState());
            vo.setReformDirectorName(basic.getReformDirectorName());
            vo.setAcceptanceDirectorName(basic.getAcceptanceDirectorName());
            vo.setActualFinishTime(basic.getActualFinishTime());
            vo.setAcceptanceDate(basic.getAcceptanceDate());
            vo.setTjBusinessId(basic.getTjBusinessId());
            if (!generationList.contains(basic.getGenerationSource())) {
                basic.setGenerationSourceStr("\u5176\u4ed6");
            }
            if (basic.getFindTime() != null) {
                vo.setFindTimeStr(sdf.format(basic.getFindTime()));
                if (basic.getStatus() != null && (basic.getStatus().intValue() == 0 || basic.getStatus().intValue() == 1 || basic.getStatus().intValue() == 5) && DateUtils.addMonths((Date)basic.getFindTime(), (int)2).before(new Date())) {
                    vo.setOverdueStatus(Boolean.valueOf(true));
                }
                if (basic.getStatus() != null && basic.getStatus().intValue() == 2 && DateUtils.addMonths((Date)basic.getUpdateDate(), (int)1).before(new Date())) {
                    vo.setOverdueStatus(Boolean.valueOf(true));
                }
            }
            vo.setFindTimeStr(ReformItemBasicServiceImpl.getFindTimeStr(basic.getFindTime(), basic.getStatus(), basic.getAcceptanceDate(), basic.getGenerationSource(), basic.getCompanyRadioactivityType()));
            voList.add(vo);
        }
        return voList;
    }

    public PageInfo<ReformItemListVo> getReformItemPageForHarmFactor(Long cid, Integer pageNum, Integer pageSize) {
        JqGridParam param = new JqGridParam();
        if (pageNum != null && pageSize != null) {
            param.setPage(pageNum.intValue());
            param.setRows(pageSize.intValue());
        } else {
            param.setPage(1);
            param.setRows(Integer.MAX_VALUE);
        }
        return this.getReformItemPage(cid, param, BusinessTypeEnum.hccheckplan);
    }

    public List<ReformItemBasic> getReformItemFinishedListSenior(Long cid, JqGridParam param) {
        if (param == null) {
            param = new JqGridParam();
        }
        ReformItemFinishedSeniorSearch search = new ReformItemFinishedSeniorSearch();
        search.setCid(cid);
        search.setGenerationType(param.getState());
        for (ParamSeachFieldVO vo : param.getPostDatas()) {
            if ("acceptanceDirector".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue()) || !cn.smarthse.common.util.StringUtils.isNumber((String)vo.getSearchValue())) continue;
                search.setAcceptanceDirector(Long.valueOf(vo.getSearchValue()));
                continue;
            }
            if ("reformDirector".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue()) || !cn.smarthse.common.util.StringUtils.isNumber((String)vo.getSearchValue())) continue;
                search.setReformDirector(Long.valueOf(vo.getSearchValue()));
                continue;
            }
            if ("reformItemLevel".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue()) || !cn.smarthse.common.util.StringUtils.isNumber((String)vo.getSearchValue())) continue;
                search.setReformItemLevel(Byte.valueOf(vo.getSearchValue()));
                continue;
            }
            if ("reformItemName".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue())) continue;
                search.setReformItemName(vo.getSearchValue());
                continue;
            }
            if ("reformItemSource".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue()) || !cn.smarthse.common.util.StringUtils.isNumber((String)vo.getSearchValue())) continue;
                search.setReformItemSource(Byte.valueOf(vo.getSearchValue()));
                continue;
            }
            if ("harmFactorStatus".equals(vo.getSearchField())) {
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)vo.getSearchValue()) || !cn.smarthse.common.util.StringUtils.isNumber((String)vo.getSearchValue())) continue;
                search.setHarmFactorStatus(Byte.valueOf(vo.getSearchValue()));
                continue;
            }
            if ("requireFinishTimeStart".equals(vo.getSearchField())) {
                if (vo.getSearchValueDate() == null) continue;
                search.setRequireFinishTimeStart(vo.getSearchValueDate());
                continue;
            }
            if (!"requireFinishTimeEnd".equals(vo.getSearchField()) || vo.getSearchValueDate() == null) continue;
            search.setRequireFinishTimeEnd(vo.getSearchValueDate());
        }
        DataScopeHelper.startDataScope("reformItem", "reform_item_basic");
        if ("true".equals(this.isActualize)) {
            return this.reformItemBasicMapper.searchSeniroForAct(search);
        }
        return this.reformItemBasicMapper.searchSeniroForFinished(search);
    }

    private void setAcceptanceForReformBasicList(List<ReformItemBasic> reformList) {
        for (ReformItemBasic basic : reformList) {
            this.setAceptanceInfo(basic);
        }
    }

    public List<ReformItemBasic> getReformItemFinishedListForInspectionTable(Long cid) {
        List<ReformItemBasic> reformList = this.getReformItemFinishedListSenior(cid, null);
        this.setAcceptanceForReformBasicList(reformList);
        return reformList;
    }

    public List<ReformItemBasic> getReformItemUnFinishedListForInspectionTable(Long cid) {
        ReformItemFinishedSeniorSearch search = new ReformItemFinishedSeniorSearch();
        search.setCid(cid);
        List<ReformItemBasic> reformList = ((ReformItemBasicMapper)this.dao).searchSeniroForUnFinished(search);
        for (ReformItemBasic basic : reformList) {
            List acceptanceList = this.acceptanceRecordService.getListByReformItemId(basic.getId());
            if (acceptanceList == null || acceptanceList.isEmpty()) continue;
            int size = acceptanceList.size();
            basic.setAcceptance((ReformItemAcceptanceRecord)acceptanceList.get(size - 1));
        }
        return reformList;
    }

    public List<ReformItemListVo> getReformItemFinishedListSeniorForVo(Long cid, JqGridParam param) {
        List<ReformItemBasic> reformItemList = this.getReformItemFinishedListSenior(cid, param);
        return this.getReformItemForHarmFactorList(reformItemList);
    }

    public PageInfo<ReformItemListVo> getReformItemFinishedPageSenior(Long cid, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ReformItemBasic> reformItemList = this.getReformItemFinishedListSenior(cid, param);
        return this.getVOPageInfo(reformItemList);
    }

    @Transactional(readOnly=false)
    public ReformItemBasicHarmFactor saveReformItemBasicFromHarmFactor(ReformItemBasicHarmFactor entity, Long cid, Long loginStaffId) {
        if (entity == null) {
            return null;
        }
        if (StatusEnum.complete.getValue().equals(entity.getStatus())) {
            entity.setIsShowInReformModular(Boolean.valueOf(true));
        } else {
            entity.setIsShowInReformModular(Boolean.valueOf(false));
        }
        entity.setReformItemSourceId(Long.valueOf(ReformSourceEnum.harmFactorInspection.getValue().byteValue()));
        ReformItemAcceptanceRecord acceptance = new ReformItemAcceptanceRecord();
        acceptance.setId(entity.getAcceptanceRecordId());
        acceptance.setReformDirector(entity.getReformDirector());
        acceptance.setReformCollaborator(entity.getReformCollaborator());
        acceptance.setRequireFinishTime(entity.getRequireFinishTime());
        acceptance.setReformSolution(entity.getReformSolution());
        acceptance.setReformMeasure(entity.getReformMeasure());
        acceptance.setStatus(StatusEnum.draff.getValue());
        List acceptanceList = this.acceptanceRecordService.getListByReformItemId(entity.getId());
        if (acceptanceList != null && acceptanceList.size() > 0) {
            acceptance.setId(((ReformItemAcceptanceRecord)acceptanceList.get(0)).getId());
        }
        entity.setAcceptance(acceptance);
        ReformItemBasic record = this.saveReformItemBasic((ReformItemBasic)entity, cid, loginStaffId);
        entity.setId(record.getId());
        entity.setAcceptanceRecordId(acceptance.getId());
        return entity;
    }

    public ReformItemBasicHarmFactor getReformItemBasicForHarmFactorByReformId(Long reformId) {
        if (reformId == null) {
            return null;
        }
        ReformItemBasic entity = this.getById(reformId);
        if (entity == null) {
            return null;
        }
        ReformItemBasicHarmFactor record = this.getReformItemBasicHarmFactor(entity);
        return record;
    }

    private ReformItemBasicHarmFactor getReformItemBasicHarmFactor(ReformItemBasic basic) {
        ReformItemBasicHarmFactor entity = new ReformItemBasicHarmFactor();
        entity.setAcceptance(basic.getAcceptance());
        entity.setAceptanceList(basic.getAceptanceList());
        entity.setBusinessStatus(basic.getBusinessStatus());
        entity.setCid(basic.getCid());
        entity.setCreateBy(basic.getCreateBy());
        entity.setCreateDate(basic.getCreateDate());
        entity.setDescription(basic.getDescription());
        entity.setFinder(basic.getFinder());
        entity.setFinderName(basic.getFinderName());
        entity.setFindTime(basic.getFindTime());
        entity.setFinishInfo(basic.getFinishInfo());
        entity.setHarmFactorStatus(basic.getHarmFactorStatus());
        entity.setId(basic.getId());
        entity.setIsShowInReformModular(basic.getIsShowInReformModular());
        entity.setIsValid(basic.getIsValid());
        entity.setIsValidateBySource(basic.getIsValidateBySource());
        entity.setLastUpdate(basic.getLastUpdate());
        entity.setName(basic.getName());
        entity.setPid(basic.getPid());
        entity.setReformItemFiles(basic.getReformItemFiles());
        entity.setReformItemLevel(basic.getReformItemLevel());
        entity.setReformItemPosition(basic.getReformItemPosition());
        entity.setReformItemSn(basic.getReformItemSn());
        entity.setReformItemSource(basic.getReformItemSource());
        entity.setReformItemSourceId(basic.getReformItemSourceId());
        entity.setReformItemType(basic.getReformItemType());
        entity.setStatus(basic.getStatus());
        entity.setUpdateBy(basic.getUpdateBy());
        entity.setUpdateDate(basic.getUpdateDate());
        entity.setReformNotification(basic.getReformNotification());
        if (basic.getAcceptance() != null) {
            entity.setAcceptanceRecordId(basic.getAcceptance().getId());
            entity.setReformDirector(basic.getAcceptance().getReformDirector());
            entity.setReformCollaborator(basic.getAcceptance().getReformCollaborator());
            entity.setRequireFinishTime(basic.getAcceptance().getRequireFinishTime());
            entity.setReformSolution(basic.getAcceptance().getReformSolution());
            entity.setReformMeasure(basic.getAcceptance().getReformMeasure());
        }
        return entity;
    }

    public int getReformItemFinishedForHarmFactor(Long cid) {
        if (cid == null) {
            return 0;
        }
        ReformItemBasic record = new ReformItemBasic();
        record.setCid(cid);
        record.setReformItemSource(ReformSourceEnum.harmFactorInspection.getValue());
        record.setIsValid(Boolean.valueOf(true));
        record.setBusinessStatus(StatusEnum.finished.getValue());
        record.setHarmFactorStatus(ReformItemHarmFactorStatusEnum.normal.getValue());
        return ((ReformItemBasicMapper)this.dao).selectCount(record);
    }

    private int getUnfinishedCount(Long cid) {
        if ("true".equals(this.isActualize)) {
            JqGridParam param = new JqGridParam();
            Example example = this.getUnfinishedExample(cid, BusinessTypeEnum.reform, param);
            return ((ReformItemBasicMapper)this.dao).selectCountByExample(example);
        }
        return ((ReformItemBasicMapper)this.dao).getUnfinishedCount(cid);
    }

    private int getFinishedCount(Long cid) {
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("businessStatus", (Object)StatusEnum.finished.getValue()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return ((ReformItemBasicMapper)this.dao).selectCountByExample(example);
    }

    public ReformItemTodolistVO getTodoListVo(Long cid) {
        ReformItemTodolistVO vo = new ReformItemTodolistVO();
        int todolistCount = 0;
        vo.setUnfinishedCount(this.getUnfinishedCount(cid));
        if (vo.getUnfinishedCount() > 0) {
            ++todolistCount;
        }
        ReformItemFinishedSeniorSearch search = new ReformItemFinishedSeniorSearch();
        search.setCid(cid);
        search.setStatus(Byte.valueOf((byte)0));
        List<ReformItemBasic> reformItemList = this.reformItemBasicMapper.searchSeniroForUnFinished(search);
        if (reformItemList != null && reformItemList.size() > 0) {
            todolistCount += reformItemList.size();
            vo.setReformList(reformItemList);
        }
        if (todolistCount > 0) {
            vo.setTodolistCount("" + todolistCount);
        }
        return vo;
    }

    private Example getUnfinishedExample(Long cid, BusinessTypeEnum businessType, JqGridParam param) {
        Example example = new Example(ReformItemBasic.class);
        if (businessType != null) {
            if (BusinessTypeEnum.reform.getName().equals(businessType.getName())) {
                ParamSeachFieldVO finished = new ParamSeachFieldVO();
                finished.setSearchField("businessStatus");
                finished.setSearchValue("" + StatusEnum.finished.getValue());
                finished.setSearchOper(JqGridParam.operType.notEq.name());
                param.getPostDatas().add(finished);
                ParamSeachFieldVO isShowInReform = new ParamSeachFieldVO();
                isShowInReform.setSearchField("isShowInReformModular");
                isShowInReform.setSearchValueBoolean(Boolean.valueOf(true));
                isShowInReform.setSearchOper(JqGridParam.operType.eq.name());
                param.getPostDatas().add(isShowInReform);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIsNull("reformItemSourceId");
                JqgridSearchUtil.addAndCriteriaAll(criteria, param);
                Example.Criteria criteria3 = example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.complete.getValue()).andIsNotNull("reformItemSourceId");
                JqgridSearchUtil.addAndCriteriaAll(criteria3, param);
            } else if (BusinessTypeEnum.hccheckplan.getName().equals(businessType.getName())) {
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.draff.getValue()).andEqualTo("reformItemSource", (Object)ReformSourceEnum.harmFactorInspection.getValue()).andEqualTo("isShowInReformModular", (Object)false).andEqualTo("reformItemSourceId", (Object)ReformSourceEnum.harmFactorInspection.getValue());
                JqgridSearchUtil.addAndCriteriaAll(criteria, param);
            }
        }
        return example;
    }

    public void businessCompleteToUpdateReform(Long businessId, Long loginStaffId) {
        ReformItemBasic entity = new ReformItemBasic();
        entity.setIsValid(Boolean.valueOf(true));
        entity.setReformItemSourceId(businessId);
        List list = ((ReformItemBasicMapper)this.dao).select(entity);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ReformItemBasic record : list) {
            record.setStatus(StatusEnum.complete.getValue());
            List receivers = this.reformMessage.getReceiverListByBusinessId(record.getId());
            ArrayList<Long> staffIds = new ArrayList<Long>();
            for (ReformItemMessageReceiver re : receivers) {
                if (StatusEnum.draff.getValue().equals(re.getStatus())) {
                    staffIds.add(re.getReveiver());
                }
                re.setStatus(StatusEnum.sended.getValue());
                this.reformMessage.updateByPrimaryKey((Object)re, loginStaffId);
            }
            if (staffIds.size() > 0) {
                this.sendReformItemBasicMessage(record, loginStaffId, record.getCid(), staffIds);
            }
            super.update(record, loginStaffId);
        }
    }

    public PageInfo<ReformItemListVo> getUnfinishedReformItemPageByParam(JqGridParam param, ReformItemFinishedSeniorSearch search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        search.setCid(param.getCid());
        if ("true".equals(this.isActualize)) {
            List<ReformItemBasic> reformItemList = this.getUnfinishedList(param.getCid(), param, BusinessTypeEnum.reform);
            return this.getVOPageInfo(reformItemList);
        }
        List<ReformItemBasic> reformItemList = this.reformItemBasicMapper.searchSeniroForUnFinished(search);
        return this.getVOPageInfo(reformItemList);
    }

    private List<ReformItemBasic> getUnfinishedList(Long cid, JqGridParam param, BusinessTypeEnum businessType) {
        if (param == null) {
            param = new JqGridParam();
        }
        return this.getReformItemList(cid, param, businessType);
    }

    public PageInfo<ReformItemListVo> getFinishedReformItemPageByParam(JqGridParam param, ReformItemFinishedSeniorSearch search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        search.setCid(param.getCid());
        List<ReformItemBasic> reformItemList = this.reformItemBasicMapper.searchForFinished(search);
        return this.getVOPageInfo(reformItemList);
    }

    public PageInfo<ReformItemListVo> getReformItemPageByParamForThirdOrg(JqGridParam param, ReformItemThirdSearchVo search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        search.setCid(param.getCid());
        List<ReformItemListVo> reformItemList = this.reformItemBasicMapper.getReformItemPageByParamForThirdOrg(search);
        for (ReformItemListVo vo : reformItemList) {
            TrusteeshipInfoDetail tru;
            if (vo.getSourceId() == null || (tru = (TrusteeshipInfoDetail)this.trusteeshipInfoDetailService.getById(vo.getSourceId())) == null) continue;
            vo.setSourceId(tru.getTrusteeshipInfoId());
            TrusteeshipInfo info = (TrusteeshipInfo)this.trusteeshipInfoService.getById(tru.getTrusteeshipInfoId());
            vo.setSourceName(info.getYear().toString() + "\u5e74\u7b2c" + info.getQuarter().toString() + "\u5b63\u5ea6\u7b2c\u4e09\u65b9\u6258\u7ba1\u6838\u67e5");
        }
        return new PageInfo(reformItemList);
    }

    public JqGridData<RiskReformGjListVo> getGjReformListDataForThirdOrg(RiskReformGjSearch param) {
        AreaModel area;
        if (param.getAreaId() != null && (area = this.sysAreaProvideService.getAreaById(param.getAreaId())) != null) {
            param.setAreaLevel(area.getLevel());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskReformGjListVo> list = ((ReformItemBasicMapper)this.dao).getGjReformListDataForThirdOrg(param);
        for (RiskReformGjListVo item : list) {
            if (item == null) continue;
            item.setFindTimeStr(ReformItemBasicServiceImpl.getFindTimeStr(item.getFindTime(), item.getStatus(), item.getAcceptanceDate(), null, null));
        }
        return new JqGridData((Page)list, (JqGridParam)param);
    }

    private int getFinishedCount(Long cid, Integer year) {
        if (year == null || cid == null) {
            return 0;
        }
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + 1, 0, 0, 0, 0, 0);
        List<ReformItemBasic> list = this.getReformItemFinishedListForInspectionTable(cid);
        int count = 0;
        for (ReformItemBasic reform : list) {
            if (reform.getAcceptance() == null || reform.getAcceptance().getActualFinishTime() == null || reform.getAcceptance().getActualFinishTime().getTime() > end.getTimeInMillis() || reform.getAcceptance().getActualFinishTime().getTime() < start.getTimeInMillis()) continue;
            ++count;
        }
        return count;
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        SceneInspectionSummaryVo vo = new SceneInspectionSummaryVo();
        if (year == null || !cn.smarthse.common.util.StringUtils.isNumber((String)year) || cid == null) {
            return vo;
        }
        Integer yearNumber = Integer.valueOf(year);
        vo.setReformItemFinishedCount(this.getFinishedCount(cid, yearNumber));
        vo.setInspectionFinishedCount(this.inspectionServcie.getFinishedCount(cid, yearNumber));
        vo.setInspectionGoingCount(this.inspectionServcie.getGoingCount(cid, yearNumber));
        return vo;
    }

    public List<ReformItemBasic> getReformListBySourceId(Long sourceId) {
        if (sourceId == null) {
            return Collections.emptyList();
        }
        ReformItemBasic record = new ReformItemBasic();
        record.setReformItemSourceId(sourceId);
        record.setIsValid(Boolean.valueOf(true));
        List list = ((ReformItemBasicMapper)this.dao).select(record);
        for (ReformItemBasic entity : list) {
            entity.setAceptanceList(this.acceptanceRecordService.getListByReformItemId(entity.getId()));
            if (entity.getAcceptance() == null || entity.getAceptanceList().size() <= 0) continue;
            int len = entity.getAceptanceList().size();
            entity.setAcceptance((ReformItemAcceptanceRecord)entity.getAceptanceList().get(len - 1));
        }
        return list;
    }

    private PageInfo<ReformItemListVo> getVOPageInfo(List<ReformItemBasic> reformItemList) {
        PageInfo pageInfoItemBasic = new PageInfo(reformItemList);
        List<ReformItemListVo> voList = this.getReformItemForHarmFactorList(reformItemList);
        PageInfo pageInfo = new PageInfo(voList);
        pageInfo.setTotal(pageInfoItemBasic.getTotal());
        pageInfo.setPages(pageInfoItemBasic.getPages());
        pageInfo.setPageNum(pageInfoItemBasic.getPageNum());
        pageInfo.setPageSize(pageInfoItemBasic.getPageSize());
        return pageInfo;
    }

    public PageInfo<ReformItemListVo> getReformItemPageBySourceId(Long cid, JqGridParam param, Long sourceId) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ReformItemBasic> reformItemList = this.getReformListBySourceId(sourceId);
        return this.getVOPageInfo(reformItemList);
    }

    @Transactional(readOnly=false)
    public void reformItemRetest(Long reformId, Long loginStaffId) {
        if (reformId == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        this.setReformItemStatusForHarmFactor(ReformItemHarmFactorStatusEnum.retest, reformId, loginStaffId);
    }

    private void setReformItemStatusForHarmFactor(ReformItemHarmFactorStatusEnum status, Long reformId, Long loginStaffId) {
        ReformItemBasic entity = new ReformItemBasic();
        entity.setId(reformId);
        entity.setHarmFactorStatus(status.getValue());
        super.update(entity, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void reformItemRetestIgnore(Long reformId, Long loginStaffId) {
        if (reformId == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        this.setReformItemStatusForHarmFactor(ReformItemHarmFactorStatusEnum.ignore, reformId, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void reformItemRetestRecovery(Long reformId, Long loginStaffId) {
        if (reformId == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        this.setReformItemStatusForHarmFactor(ReformItemHarmFactorStatusEnum.normal, reformId, loginStaffId);
    }

    public int getReformCountHarmFactorDraff(Long cid) {
        if (cid == null) {
            return 0;
        }
        JqGridParam param = new JqGridParam();
        Example example = this.getUnfinishedExample(cid, BusinessTypeEnum.hccheckplan, param);
        return ((ReformItemBasicMapper)this.dao).selectCountByExample(example);
    }

    @Transactional
    public void deleteByIdAndBusinessType(Long id, Long loginStaffId, BusinessTypeEnum businessType) {
        if (id == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (businessType != null && BusinessTypeEnum.reform.getName().equals(businessType.getName())) {
            ReformItemBasic reform = (ReformItemBasic)super.getById(id);
            if (reform == null) {
                return;
            }
            if (reform.getReformItemSourceId() != null) {
                reform.setIsShowInReformModular(Boolean.valueOf(false));
                super.update(reform, loginStaffId);
            } else {
                super.delete(reform, loginStaffId);
            }
        } else {
            ReformItemBasic entity = new ReformItemBasic();
            entity.setId(id);
            super.delete(entity, loginStaffId);
        }
    }

    public int getCountBySourceId(Long sourceId) {
        ReformItemBasic reform = new ReformItemBasic();
        reform.setReformItemSourceId(sourceId);
        reform.setIsValid(Boolean.valueOf(true));
        return ((ReformItemBasicMapper)this.dao).selectCount(reform);
    }

    public int getCountBySource(Long source) {
        return 0;
    }

    public ReformMonthCountSummaryVo getMonthCountByYear(int year, Long cid) {
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + 1, 0, 0, 0, 0, 0);
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("findTime", (Object)start.getTime()).andLessThanOrEqualTo("findTime", (Object)end.getTime());
        List list = ((ReformItemBasicMapper)this.dao).selectByExample(example);
        Calendar calendar = Calendar.getInstance();
        ReformMonthCountSummaryVo reformVo = new ReformMonthCountSummaryVo();
        for (ReformItemBasic reform : list) {
            calendar.setTime(reform.getFindTime());
            int month = calendar.get(2);
            switch (month) {
                case 0: {
                    reformVo.setJanReformCount(reformVo.getJanReformCount() + 1);
                    break;
                }
                case 1: {
                    reformVo.setFebReformCount(reformVo.getFebReformCount() + 1);
                    break;
                }
                case 2: {
                    reformVo.setMarReformCount(reformVo.getMarReformCount() + 1);
                    break;
                }
                case 3: {
                    reformVo.setAprReformCount(reformVo.getAprReformCount() + 1);
                    break;
                }
                case 4: {
                    reformVo.setMayReformCount(reformVo.getMayReformCount() + 1);
                    break;
                }
                case 5: {
                    reformVo.setJuneReformCount(reformVo.getJuneReformCount() + 1);
                    break;
                }
                case 6: {
                    reformVo.setJulyReformCount(reformVo.getJulyReformCount() + 1);
                    break;
                }
                case 7: {
                    reformVo.setAugReformCount(reformVo.getAugReformCount() + 1);
                    break;
                }
                case 8: {
                    reformVo.setSeptReformCount(reformVo.getSeptReformCount() + 1);
                    break;
                }
                case 9: {
                    reformVo.setOctReformCount(reformVo.getOctReformCount() + 1);
                    break;
                }
                case 10: {
                    reformVo.setNovReformCount(reformVo.getNovReformCount() + 1);
                    break;
                }
                case 11: {
                    reformVo.setDecReformCount(reformVo.getDecReformCount() + 1);
                    break;
                }
            }
        }
        return reformVo;
    }

    private List<ReformItemBasic> getReformListBasicFinishedByYear(Integer year, int yearNum, Long cid) {
        if (year == null || cid == null || yearNum < 1) {
            return Collections.emptyList();
        }
        Example example = new Example(ReformItemBasic.class);
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + yearNum, 0, 0, 0, 0, 0);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)StatusEnum.complete.getValue()).andGreaterThanOrEqualTo("findTime", (Object)start.getTime()).andLessThanOrEqualTo("findTime", (Object)end.getTime());
        return ((ReformItemBasicMapper)this.dao).selectByExample(example);
    }

    public ReformLevelCountSummaryVo getReformLevelCountSummaryByYear(String yearStr, Long cid) {
        ReformLevelCountSummaryVo vo = new ReformLevelCountSummaryVo();
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStr) || cid == null) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, 1, cid);
        for (ReformItemBasic reform : reformList) {
            if (ReformItemLevelEnum.generalScene.getValue().equals(reform.getReformItemLevel())) {
                vo.setGeneralScene(vo.getGeneralScene() + 1);
                continue;
            }
            if (ReformItemLevelEnum.generalTimeLimit.getValue().equals(reform.getReformItemLevel())) {
                vo.setGeneralTimeLimit(vo.getGeneralTimeLimit() + 1);
                continue;
            }
            if (!ReformItemLevelEnum.majorStop.getValue().equals(reform.getReformItemLevel())) continue;
            vo.setMajorStop(vo.getMajorStop() + 1);
        }
        return vo;
    }

    public ReformTypeCountSummaryVo getReformTypeCountSummaryByYear(String yearStr, Long cid) {
        ReformTypeCountSummaryVo vo = new ReformTypeCountSummaryVo();
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStr) || cid == null) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, 1, cid);
        for (ReformItemBasic reform : reformList) {
            if (ReformItemTypeEnum.manage.getValue().equals(reform.getReformItemType())) {
                vo.setManage(vo.getManage() + 1);
                continue;
            }
            if (ReformItemTypeEnum.deviceAndMateriel.getValue().equals(reform.getReformItemType())) {
                vo.setDeviceAndMateriel(vo.getDeviceAndMateriel() + 1);
                continue;
            }
            if (ReformItemTypeEnum.employees.getValue().equals(reform.getReformItemType())) {
                vo.setEmployees(vo.getEmployees() + 1);
                continue;
            }
            if (!ReformItemTypeEnum.workPlace.getValue().equals(reform.getReformItemType())) continue;
            vo.setWorkPlace(vo.getWorkPlace() + 1);
        }
        return vo;
    }

    public ReformSourceCountSummaryVo getReformSourceCountSummaryByYear(String yearStr, Long cid) {
        ReformSourceCountSummaryVo vo = new ReformSourceCountSummaryVo();
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStr) || cid == null) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, 1, cid);
        for (ReformItemBasic reform : reformList) {
            if (ReformSourceEnum.sceneInspection.getValue().equals(reform.getReformItemSource())) {
                vo.setSceneInspection(vo.getSceneInspection() + 1);
                continue;
            }
            if (ReformSourceEnum.supervise.getValue().equals(reform.getReformItemSource())) {
                vo.setSupervise(vo.getSupervise() + 1);
                continue;
            }
            if (ReformSourceEnum.harmFactorInspection.getValue().equals(reform.getReformItemSource())) {
                vo.setHarmFactorInspection(vo.getHarmFactorInspection() + 1);
                continue;
            }
            if (!ReformSourceEnum.evaluationManage.getValue().equals(reform.getReformItemSource())) continue;
            vo.setEvaluationManage(vo.getEvaluationManage() + 1);
        }
        return vo;
    }

    public ReformMonthSummaryVo getReformMonthSummaryByYear(String yearStr, Long cid) {
        ReformMonthSummaryVo vo = new ReformMonthSummaryVo();
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStr) || cid == null) {
            return vo;
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, 1, cid);
        Calendar calendar = Calendar.getInstance();
        ReformMonthCountSummaryVo all = vo.getAll();
        ReformMonthCountSummaryVo finished = vo.getFinished();
        for (ReformItemBasic reform : reformList) {
            calendar.setTime(reform.getFindTime());
            int month = calendar.get(2);
            boolean isBusinessFinished = false;
            if (StatusEnum.finished.getValue().equals(reform.getBusinessStatus())) {
                isBusinessFinished = true;
            }
            switch (month) {
                case 0: {
                    all.setJanReformCount(all.getJanReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setJanReformCount(finished.getJanReformCount() + 1);
                    break;
                }
                case 1: {
                    all.setFebReformCount(all.getFebReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setFebReformCount(finished.getFebReformCount() + 1);
                    break;
                }
                case 2: {
                    all.setMarReformCount(all.getMarReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setMarReformCount(finished.getMarReformCount() + 1);
                    break;
                }
                case 3: {
                    all.setAprReformCount(all.getAprReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setAprReformCount(finished.getAprReformCount() + 1);
                    break;
                }
                case 4: {
                    all.setMayReformCount(all.getMayReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setMayReformCount(finished.getMayReformCount() + 1);
                    break;
                }
                case 5: {
                    all.setJuneReformCount(all.getJuneReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setJuneReformCount(finished.getJuneReformCount() + 1);
                    break;
                }
                case 6: {
                    all.setJulyReformCount(all.getJulyReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setJulyReformCount(finished.getJulyReformCount() + 1);
                    break;
                }
                case 7: {
                    all.setAugReformCount(all.getAugReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setAugReformCount(finished.getAugReformCount() + 1);
                    break;
                }
                case 8: {
                    all.setSeptReformCount(all.getSeptReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setSeptReformCount(finished.getSeptReformCount() + 1);
                    break;
                }
                case 9: {
                    all.setOctReformCount(all.getOctReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setOctReformCount(finished.getOctReformCount() + 1);
                    break;
                }
                case 10: {
                    all.setNovReformCount(all.getNovReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setNovReformCount(finished.getNovReformCount() + 1);
                    break;
                }
                case 11: {
                    all.setDecReformCount(all.getDecReformCount() + 1);
                    if (!isBusinessFinished) break;
                    finished.setDecReformCount(finished.getDecReformCount() + 1);
                    break;
                }
            }
        }
        return vo;
    }

    public List<ReformOrgCountSummaryVo> getReformOrgCountSummaryByYear(String yearStr, Long cid, String orgIds) {
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStr) || cid == null) {
            return Collections.emptyList();
        }
        List orgIdList = cn.smarthse.common.util.StringUtils.parseToLongList((String)orgIds);
        if (orgIdList == null || orgIdList.isEmpty()) {
            // empty if block
        }
        ArrayList<ReformOrgCountSummaryVo> list = new ArrayList<ReformOrgCountSummaryVo>();
        List organs = orgIdList == null || orgIdList.isEmpty() ? this.organizationService.getListByCid(cid) : this.organizationService.getListByIds(orgIds);
        for (CompanyOrganization o : organs) {
            ReformOrgCountSummaryVo vo = new ReformOrgCountSummaryVo();
            vo.setOrgId(o.getId());
            vo.setOrgName(o.getOrganizationName());
            list.add(vo);
        }
        Integer year = Integer.valueOf(yearStr.trim());
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, 1, cid);
        block1: for (ReformItemBasic reform : reformList) {
            this.setAceptanceInfo(reform);
            if (reform.getAceptanceList() == null || reform.getAceptanceList().isEmpty()) continue;
            for (int i = reform.getAceptanceList().size() - 1; i >= 0; --i) {
                StaffBasicWork staffBasicWork;
                if (((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getReformDirector() == null || (staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getReformDirector())) == null) continue;
                boolean hasVo = false;
                for (ReformOrgCountSummaryVo vo : list) {
                    if (!vo.getOrgId().equals(staffBasicWork.getOrgId())) continue;
                    hasVo = true;
                    vo.setAll(vo.getAll() + 1);
                    if (!StatusEnum.finished.getValue().equals(reform.getBusinessStatus())) break;
                    vo.setFinished(vo.getFinished() + 1);
                    break;
                }
                if (hasVo) continue block1;
            }
        }
        return list;
    }

    public List<ReformTrendByYearSummaryVo> getReformTrendSummaryByYear(String yearStartStr, String yearEndStr, Long cid) {
        if (!cn.smarthse.common.util.StringUtils.isInteger((String)yearStartStr) || !cn.smarthse.common.util.StringUtils.isInteger((String)yearEndStr) || cid == null) {
            return Collections.emptyList();
        }
        Integer year = Integer.valueOf(yearStartStr.trim());
        Integer yearEnd = Integer.valueOf(yearEndStr.trim());
        int yearNum = yearEnd - year + 1;
        List<ReformItemBasic> reformList = this.getReformListBasicFinishedByYear(year, yearNum, cid);
        Calendar calendar = Calendar.getInstance();
        ArrayList<ReformTrendByYearSummaryVo> list = new ArrayList<ReformTrendByYearSummaryVo>();
        for (ReformItemBasic reform : reformList) {
            calendar.setTime(reform.getFindTime());
            boolean hasYear = false;
            int thisYear = calendar.get(1);
            for (ReformTrendByYearSummaryVo vo : list) {
                if (thisYear != vo.getYear()) continue;
                hasYear = true;
                if (ReformItemLevelEnum.generalScene.getValue().equals(reform.getReformItemLevel())) {
                    vo.setGeneralScene(vo.getGeneralScene() + 1);
                    vo.setAll(vo.getAll() + 1);
                    break;
                }
                if (ReformItemLevelEnum.generalTimeLimit.getValue().equals(reform.getReformItemLevel())) {
                    vo.setGeneralTimeLimit(vo.getGeneralTimeLimit() + 1);
                    vo.setAll(vo.getAll() + 1);
                    break;
                }
                if (!ReformItemLevelEnum.majorStop.getValue().equals(reform.getReformItemLevel())) break;
                vo.setMajorStop(vo.getMajorStop() + 1);
                vo.setAll(vo.getAll() + 1);
                break;
            }
            if (hasYear) continue;
            ReformTrendByYearSummaryVo vo = new ReformTrendByYearSummaryVo();
            vo.setYear(thisYear);
            if (ReformItemLevelEnum.generalScene.getValue().equals(reform.getReformItemLevel())) {
                vo.setGeneralScene(vo.getGeneralScene() + 1);
                vo.setAll(vo.getAll() + 1);
            } else if (ReformItemLevelEnum.generalTimeLimit.getValue().equals(reform.getReformItemLevel())) {
                vo.setGeneralTimeLimit(vo.getGeneralTimeLimit() + 1);
                vo.setAll(vo.getAll() + 1);
            } else if (ReformItemLevelEnum.majorStop.getValue().equals(reform.getReformItemLevel())) {
                vo.setMajorStop(vo.getMajorStop() + 1);
                vo.setAll(vo.getAll() + 1);
            }
            list.add(vo);
        }
        return list;
    }

    public boolean isCompleteForSource(Long sourceId, boolean isAllowedEmpty) {
        boolean isComplete = true;
        try {
            List<ReformItemBasic> reformBasicList = this.getReformListBySourceId(sourceId);
            if (!isAllowedEmpty && (reformBasicList == null || reformBasicList.isEmpty())) {
                return false;
            }
            for (ReformItemBasic reform : reformBasicList) {
                ReformItemUtil.validate((ReformItemBasic)reform);
            }
        }
        catch (Exception e) {
            isComplete = false;
        }
        return isComplete;
    }

    public Integer countByIdAndStatus(List<Long> reformIds, StatusEnum finished) {
        return ((ReformItemBasicMapper)this.dao).countByIdAndStatus(reformIds, finished.getValue());
    }

    private void setCompanyAreaDetail(ReformItemBasic basic) {
        if (basic.getCid() == null) {
            return;
        }
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(basic.getCid());
        AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaDetailId());
        if (area == null) {
            return;
        }
        basic.setAreaId(area.getId());
        if (area.getProvinceId() != null) {
            basic.setAreaId1(area.getProvinceId());
        }
        if (area.getCityId() != null) {
            basic.setAreaId2(area.getCityId());
        }
        if (area.getAreaId() != null) {
            basic.setAreaId3(area.getAreaId());
        }
        if (area.getStreetId() != null) {
            basic.setAreaId4(area.getStreetId());
        }
    }

    public Map<Long, Byte> getResult(List<Long> sourceIds) {
        if (sourceIds == null || sourceIds.isEmpty()) {
            return new HashMap<Long, Byte>();
        }
        List<ReformItemBasic> list = ((ReformItemBasicMapper)this.dao).getResult(sourceIds);
        HashMap<Long, Byte> map = new HashMap<Long, Byte>();
        for (ReformItemBasic basic : list) {
            map.put(basic.getReformItemSourceId(), basic.getStatus());
        }
        return map;
    }

    public Integer getUnFinishedNum(Long cid, Byte type) {
        if (cid == null) {
            return 0;
        }
        return ((ReformItemBasicMapper)this.dao).getUnFinishedNum(cid, type);
    }

    public Integer getFinishedNum(Long cid, Byte type) {
        if (cid == null) {
            return 0;
        }
        return ((ReformItemBasicMapper)this.dao).getFinishedNum(cid, type);
    }

    public Map<Integer, Integer> getFinishedNumByGenerationSource(Long cid) {
        if (cid == null) {
            return null;
        }
        List<ReformItemBasic> finish = ((ReformItemBasicMapper)this.dao).getFinishedNumByGenerationSource(cid);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (ReformItemBasic reform : finish) {
            map.put(reform.getGenerationSource().intValue(), Integer.parseInt(reform.getDescription()));
        }
        return map;
    }

    public Map<Integer, Integer> getUnFinishedNumByGenerationSource(Long cid) {
        if (cid == null) {
            return null;
        }
        List<ReformItemBasic> finish = ((ReformItemBasicMapper)this.dao).getUnFinishedNumByGenerationSource(cid);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (ReformItemBasic reform : finish) {
            map.put(reform.getGenerationSource().intValue(), Integer.parseInt(reform.getDescription()));
        }
        return map;
    }

    public Integer getReformTimeOutNum(Long cid) {
        List<ReformItemBasic> list = ((ReformItemBasicMapper)this.dao).getReformTimeOutList(cid);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public PageInfo<AppReformItemListVo> getReformItemPageInfoForApp(PageParamModel param) {
        if (param == null || param.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPageInfo().getPageNum(), (int)param.getPageInfo().getPageSize());
        List<AppReformItemListVo> list = ((ReformItemBasicMapper)this.dao).getReformItemPageInfoForApp(param);
        if (list != null && list.size() > 0) {
            for (AppReformItemListVo re : list) {
                if (re.getSource() != null) {
                    re.setSourceName(ReformSourceLiteEnum.getSourceNameByValue((Byte)re.getSource()));
                }
                if (re.getStatus() == null) continue;
                re.setStatusName(ReformStatusEnum.getNameByValue((Byte)re.getStatus()));
                if (re.getStatus().intValue() == 0) continue;
                re.setFindTime(re.getUpdateTime());
            }
        }
        return new PageInfo(list);
    }

    public ReformItemBasic addReformInfoNotInPlace(Long reformId) {
        ReformItemAcceptanceRecord record;
        ReformItemBasic basic = this.getById(reformId);
        if (basic != null && basic.getAcceptance() != null && basic.getStatus() != null && basic.getStatus().intValue() == 3 && basic.getGenerationSource() != null && basic.getGenerationSource().intValue() == 1 && (record = basic.getAcceptance()).getAcceptanceResult() != null && record.getAcceptanceResult().intValue() == 2) {
            ReformItemBasic reform = new ReformItemBasic();
            String businessNo = this.businessNoService.getBusinessNo(basic.getCid(), BusinessNoTypeEnum.HIDDEN_DANGER_REFORM.getCode());
            reform.setReformItemSn(businessNo);
            reform.setFindTime(basic.getFindTime());
            reform.setCid(basic.getCid());
            this.setCompanyAreaDetail(basic);
            reform.setStatus(StatusEnum.draff.getValue());
            reform.setBusinessStatus(StatusEnum.none.getValue());
            reform.setReformItemSourceId(basic.getReformItemSourceId());
            reform.setGenerationSource(basic.getGenerationSource());
            reform.setReformItemType(ReformItemTypeEnum.employees.getValue());
            reform.setIsAutoGeneration(Boolean.valueOf(true));
            reform.setName(basic.getName());
            reform.setReformItemSource(basic.getReformItemSource());
            basic = this.add(basic, basic.getUpdateBy(), basic.getCid());
            ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
            acce.setReformItemId(reform.getId());
            acce.setCid(basic.getCid());
            this.acceptanceRecordService.add((Object)acce, basic.getUpdateBy(), basic.getCid());
        }
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(basic.getCid(), HomeDataEventEnum.REFORM));
        return null;
    }

    @Transactional(readOnly=false)
    public void thirdOrgAcceptance(ReformItemBasic reform, Long userId, String userName, String orgName) {
        ReformItemAcceptanceRecord acce = reform.getAcceptance();
        acce.setStatus(Byte.valueOf((byte)1));
        if (reform.getStatus() == 3) {
            acce.setAcceptanceResult(Byte.valueOf((byte)1));
            this.workOperateLogService.pass(reform.getId(), WorkOperateLogEnum.reform.getTypeVal(), userId, userName, orgName);
        } else {
            reform.setStatus(Byte.valueOf((byte)5));
            acce.setAcceptanceResult(Byte.valueOf((byte)0));
            this.addAcceptance(reform, reform.getUpdateBy());
            this.workOperateLogService.back(reform.getId(), WorkOperateLogEnum.reform.getTypeVal(), reform.getAcceptance().getAcceptanceResultExplain(), userId, userName, orgName);
        }
        super.update(reform, userId);
        acce.setReformMeasure(null);
        acce.setRequireFinishTime(null);
        this.acceptanceRecordService.update((Object)acce, userId);
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(reform.getCid(), HomeDataEventEnum.REFORM));
    }

    public Integer getReformOverdueNum(Long orgId) {
        return ((ReformItemBasicMapper)this.dao).getReformOverdueNum(orgId);
    }

    public Integer getTobeAcceptanceNum(Long orgId) {
        return ((ReformItemBasicMapper)this.dao).getTobeAcceptanceNum(orgId);
    }

    public List<MobileReformItemListVo> getReformOverdueList(Long orgId, String name) {
        return ((ReformItemBasicMapper)this.dao).getReformOverdueList(orgId, name);
    }

    public PageInfo<MobileReformItemListVo> getReformOverduePage(PageParamModel param, Long orgId, String name) {
        if (param == null || orgId == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPageInfo().getPageNum(), (int)param.getPageInfo().getPageSize());
        List<MobileReformItemListVo> list = this.getReformOverdueList(orgId, name);
        return new PageInfo(list);
    }

    public List<MobileReformItemListVo> getTobeAcceptanceList(Long orgId, String name) {
        return ((ReformItemBasicMapper)this.dao).getTobeAcceptanceList(orgId, name);
    }

    public PageInfo<MobileReformItemListVo> getTobeAcceptancePage(PageParamModel param, Long orgId, String name) {
        if (param == null || orgId == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPageInfo().getPageNum(), (int)param.getPageInfo().getPageSize());
        List<MobileReformItemListVo> list = this.getTobeAcceptanceList(orgId, name);
        return new PageInfo(list);
    }

    public PageInfo<MobileReformItemListVo> getTrustInfoReformList(PageParamModel gparam, TrusteeshipInfoParam param) {
        if (gparam == null) {
            return null;
        }
        PageHelper.startPage((int)gparam.getPageInfo().getPageNum(), (int)gparam.getPageInfo().getPageSize());
        List<MobileReformItemListVo> list = ((ReformItemBasicMapper)this.dao).getTrustInfoReformList(param);
        return new PageInfo(list);
    }

    public List<MobileReformItemListVo> getReformListByTrusteeshipId(Long trusteeshipId) {
        return ((ReformItemBasicMapper)this.dao).getReformListByTrusteeshipId(trusteeshipId);
    }

    public Date getMinAcceptanceTime(Long cid) {
        return ((ReformItemBasicMapper)this.dao).getMinAcceptanceTime(cid);
    }

    @Transactional(readOnly=false)
    public void deleteReformInfoBySourceId(Long sourceId) {
        if (sourceId != null) {
            Example example = new Example(ReformItemBasic.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("reformItemSourceId", (Object)sourceId);
            List list = ((ReformItemBasicMapper)this.dao).selectByExample(example);
            if (list != null) {
                for (ReformItemBasic reform : list) {
                    this.acceptanceRecordService.deleteByReformId(reform.getId());
                    this.delete(reform);
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void subReformByTrusteeshipId(Long trusteeshipId) {
        if (trusteeshipId != null) {
            ((ReformItemBasicMapper)this.dao).subReformByTrusteeshipId(trusteeshipId);
        }
    }

    public Integer getFindReformNumByOrg(Long orgId, Integer year, Integer quarter) {
        return ((ReformItemBasicMapper)this.dao).getFindReformNumByOrg(orgId, year, quarter);
    }

    public Integer getAcceptanceReformNumByOrg(Long orgId, Integer year, Integer quarter) {
        return ((ReformItemBasicMapper)this.dao).getAcceptanceReformNumByOrg(orgId, year, quarter);
    }

    @Transactional(readOnly=false)
    public void removeReformBySourceId(Long sourceId) {
        List<ReformItemBasic> reformList = this.getReformListBySourceId(sourceId);
        for (ReformItemBasic reform : reformList) {
            reform.setIsValid(Global.FALSE);
        }
        this.batchUpdateOrInsert(reformList, ReformItemBasicMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        this.logger.info("\u5df2\u5220\u9664id\u4e3a{}\u7684\u81ea\u67e5\u6574\u6539\u9879", (Object)sourceId);
    }

    public ReformItemDetailVo getReformItemDetailVoById(Long id) {
        ReformItemBasic reformItemBasic = this.getById(id);
        if (reformItemBasic == null) {
            return null;
        }
        List aceptanceList = reformItemBasic.getAceptanceList();
        if (aceptanceList != null) {
            for (ReformItemAcceptanceRecord record : aceptanceList) {
                if (record.getReformFinishedFiles() != null) {
                    List files = this.fileService.getListByIds(record.getReformFinishedFiles());
                    record.setReformFinishedFilesList(files);
                }
                if (record.getAcceptanceFiles() == null) continue;
                String fileIds = record.getAcceptanceFiles();
                List files = this.fileService.getListByIds(fileIds);
                record.setAcceptanceFilesList(files);
            }
        }
        ReformItemDetailVo result = new ReformItemDetailVo();
        result.setReformItemBasic(reformItemBasic);
        if (reformItemBasic.getCid() != null) {
            SimpleCompanyInfoVo companyInfoVo = this.getSimpleCompanyInfoVoById(reformItemBasic.getCid());
            result.setCompanyInfo(companyInfoVo);
        }
        return result;
    }

    public List<ReformTableListVo> getTabList(Long reformId) {
        ReformItemBasic reform = this.getById(reformId);
        List aceptanceList = reform.getAceptanceList();
        return aceptanceList.stream().map(item -> {
            ReformTableListVo vo = new ReformTableListVo();
            vo.setLabel("\u6574\u6539\u53ca\u9a8c\u6536\u8bb0\u5f55" + String.valueOf(aceptanceList.indexOf(item) == 0 ? "" : Integer.valueOf(aceptanceList.indexOf(item))));
            vo.setValue(item.getId());
            return vo;
        }).collect(Collectors.toList());
    }

    public SimpleCompanyInfoVo getSimpleCompanyInfoVoById(Long cid) {
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        SimpleCompanyInfoVo companyInfoVo = new SimpleCompanyInfoVo();
        if (company != null) {
            companyInfoVo.setCid(cid);
            companyInfoVo.setCompanyName(company.getName());
            companyInfoVo.setCompanyAddress(company.getRegisterAddress());
            companyInfoVo.setMainLeaderName(DesensitizationUtils.desensitized((CharSequence)company.getMainLeaderName(), (DesensitizationType)DesensitizationType.NAME));
            companyInfoVo.setMainLeaderTel(DesensitizationUtils.desensitized((CharSequence)company.getMainLeaderTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
            companyInfoVo.setOccManagerName(DesensitizationUtils.desensitized((CharSequence)company.getOccManagerName(), (DesensitizationType)DesensitizationType.NAME));
            companyInfoVo.setOccManagerTel(DesensitizationUtils.desensitized((CharSequence)company.getOccManagerTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        }
        return companyInfoVo;
    }

    public PageInfo<RiskListItemDataVo> getTownShipRiskListData(JqGridParam param, RiskListSearch search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ReformItemBasic> reformItemList = this.reformItemBasicMapper.getTownShipRiskListData(search);
        return this.getRiskListItemVoPageInfo(reformItemList);
    }

    public PageInfo<RiskListItemDataVo> getRiskListDataPage(JqGridParam param, RiskListSearch search, Boolean count, Integer searchType) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)count);
        List<ReformItemBasic> reformItemUnfinishedList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, searchType);
        if (CollectionUtils.isEmpty(reformItemUnfinishedList)) {
            return new PageInfo();
        }
        PageInfo pageInfoBasic = new PageInfo(reformItemUnfinishedList);
        PageInfo pageInfoDataVo = new PageInfo();
        BeanUtil.copyProperties((Object)pageInfoBasic, (Object)pageInfoDataVo, (String[])new String[0]);
        List<RiskListItemDataVo> voList = this.getReformItemForRiskListItemList(pageInfoBasic.getList());
        pageInfoDataVo.setList(voList);
        return pageInfoDataVo;
    }

    public List<RiskListItemDataVo> getRiskListData(RiskListSearch search, Integer searchType) {
        List<ReformItemBasic> reformItemUnfinishedList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, searchType);
        return this.getReformItemForRiskListItemList(reformItemUnfinishedList);
    }

    public ReformItemBasic getRiskListDataToArchive(JqGridParam param, RiskListSearch search, Boolean count) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)count);
        List<ReformItemBasic> reformItemUnfinishedList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, null);
        return CollUtil.isNotEmpty(reformItemUnfinishedList) && reformItemUnfinishedList.size() > 0 ? reformItemUnfinishedList.get(0) : null;
    }

    private PageInfo<RiskListItemDataVo> getRiskListItemVoPageInfo(List<ReformItemBasic> reformItemList) {
        PageInfo pageInfoItemBasic = new PageInfo(reformItemList);
        List<RiskListItemDataVo> voList = this.getReformItemForRiskListItemList(reformItemList);
        PageInfo pageInfo = new PageInfo(voList);
        pageInfo.setTotal(pageInfoItemBasic.getTotal());
        pageInfo.setPages(pageInfoItemBasic.getPages());
        pageInfo.setPageNum(pageInfoItemBasic.getPageNum());
        pageInfo.setPageSize(pageInfoItemBasic.getPageSize());
        return pageInfo;
    }

    public PageInfo<RiskSolveRateStatisticVo> riskSolveRateListData(RiskSolveRateSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskSolveRateStatisticVo> resultList = this.reformItemBasicMapper.riskSolveRateListData(param);
        return new PageInfo(resultList);
    }

    public RiskSolveRateStatisticVo riskSolveRateTotalData(RiskSolveRateSearchParam param) {
        RiskSolveRateStatisticVo result = new RiskSolveRateStatisticVo();
        List<RiskSolveRateStatisticVo> resultList = this.reformItemBasicMapper.riskSolveRateListData(param);
        if (CollectionUtils.isNotEmpty(resultList)) {
            result = resultList.get(0);
        }
        return result;
    }

    public List<ReformRateStatisticVo> reformRateStatisticListData(RiskSolveRateSearchParam param) {
        return this.reformItemBasicMapper.reformRateStatisticListData(param);
    }

    public List<ReformRateStatisticVo> reformRateStatisticListDataBackup(RiskSolveRateSearchParam param) {
        return this.reformItemBasicMapper.reformRateStatisticListDataBackup(param);
    }

    public ReformRateStatisticVo reformRateTotalData(RiskSolveRateSearchParam param) {
        ReformRateStatisticVo result = new ReformRateStatisticVo();
        List<ReformRateStatisticVo> resultList = this.reformItemBasicMapper.reformRateStatisticListTotalData(param);
        if (CollectionUtils.isNotEmpty(resultList)) {
            result = resultList.get(0);
        }
        return result;
    }

    public ReformRateStatisticVo reformRateTotalDataBackup(RiskSolveRateSearchParam param) {
        ReformRateStatisticVo result = new ReformRateStatisticVo();
        List<ReformRateStatisticVo> resultList = this.reformItemBasicMapper.reformRateStatisticListTotalDataBackup(param);
        if (CollectionUtils.isNotEmpty(resultList)) {
            result = resultList.get(0);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void reformRecordAcceptance(ReformRecordAcceptanceParam param) {
        ReformItemBasic reformItemBasic = this.getById(param.getReformItemId());
        if (reformItemBasic == null) {
            return;
        }
        ReformItemAcceptanceRecord acceptance = reformItemBasic.getAcceptance();
        acceptance.setAcceptanceDirectorName(param.getAcceptanceDirectorName());
        acceptance.setAcceptanceResultExplain(param.getAcceptanceResultExplain());
        acceptance.setAcceptanceFiles(param.getAcceptanceFiles());
        if (param.getAcceptanceResult().byteValue() == AcceptanceResultEnum.unComplete.getValue().intValue()) {
            reformItemBasic.setStatus(ReformStatusEnum.TH.getValue());
        } else {
            reformItemBasic.setStatus(ReformStatusEnum.WC.getValue());
        }
        this.itemBasicNewService.saveOrSubmitReform(reformItemBasic, param.getUserId());
    }

    public PageInfo<RiskReformVo> getRiskReformListData(JqGridParam jParam, RiskReformSearchVo searchVo) {
        List<Long> overTimeId = ((ReformItemBasicMapper)this.dao).getRiskReformOverTimeId(searchVo);
        if (CollectionUtils.isEmpty(overTimeId)) {
            overTimeId.add(-1L);
        }
        searchVo.setOverTimeIdList(overTimeId);
        HashSet<Long> overTimeIdSet = new HashSet<Long>(overTimeId);
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<RiskReformVo> list = ((ReformItemBasicMapper)this.dao).getRiskReformListData(searchVo);
        for (RiskReformVo riskReformVo : list) {
            AreaModel areaById;
            riskReformVo.setOverdueStatus(Byte.valueOf((byte)0));
            if (overTimeIdSet.contains(riskReformVo.getId())) {
                riskReformVo.setOverdueStatus(Byte.valueOf((byte)1));
            }
            if ((areaById = this.sysAreaProvideService.getAreaById(riskReformVo.getAreaId())) == null) continue;
            riskReformVo.setRegisterAddress(areaById.getFullname());
        }
        return new PageInfo(list);
    }

    public PageInfo<RiskReformVo> getPageRiskReform(JqGridParam jParam, RiskReformSearchVo searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows(), (boolean)false);
        List<RiskReformVo> list = this.getListRiskReform(searchVo);
        return new PageInfo(list);
    }

    public List<RiskReformVo> getListRiskReform(RiskReformSearchVo searchVo) {
        List<RiskReformVo> listRiskReform = ((ReformItemBasicMapper)this.dao).getListRiskReform(searchVo);
        if (CollectionUtils.isEmpty(listRiskReform)) {
            return Collections.emptyList();
        }
        Map riskReformVoMap = listRiskReform.parallelStream().collect(Collectors.toMap(RiskReformVo::getId, Function.identity(), (v1, v2) -> v2));
        Set<Long> itemIds = riskReformVoMap.keySet();
        Map<Long, List<ReformItemAcceptanceRecord>> map = this.acceptanceRecordService.getListByReformItemIds(itemIds).stream().collect(Collectors.groupingBy(ReformItemAcceptanceRecord::getReformItemId));
        for (Long itemId : map.keySet()) {
            RiskReformVo reform;
            List<Object> acceptanceRecordList = map.get(itemId);
            if (CollectionUtils.isEmpty(acceptanceRecordList) || (reform = (RiskReformVo)riskReformVoMap.get(itemId)) == null) continue;
            if (reform.getFindTime() != null) {
                reform.setFindTimeStr(DateUtils.formatDate((Date)reform.getFindTime()));
            }
            if (((ReformItemAcceptanceRecord)(acceptanceRecordList = acceptanceRecordList.stream().sorted(Comparator.comparing(ReformItemAcceptanceRecord::getCreateDate).reversed()).collect(Collectors.toList())).get(0)).getActualFinishTime() != null) {
                reform.setActualFinishTime(((ReformItemAcceptanceRecord)acceptanceRecordList.get(0)).getActualFinishTime());
                reform.setActualFinishTimeStr(DateUtils.formatDate((Date)((ReformItemAcceptanceRecord)acceptanceRecordList.get(0)).getActualFinishTime()));
            }
            if (((ReformItemAcceptanceRecord)acceptanceRecordList.get(0)).getAcceptanceDate() == null) continue;
            reform.setAcceptanceDate(((ReformItemAcceptanceRecord)acceptanceRecordList.get(0)).getAcceptanceDate());
            reform.setAcceptanceDateStr(DateUtils.formatDate((Date)((ReformItemAcceptanceRecord)acceptanceRecordList.get(0)).getAcceptanceDate()));
        }
        return listRiskReform;
    }

    public Integer getCountRiskReform(RiskReformSearchVo searchVo) {
        return ((ReformItemBasicMapper)this.dao).getCountRiskReform(searchVo);
    }

    public List<Integer> getFindYearBySearchVo(RiskReformSearchVo searchVo) {
        AreaModel area;
        if (searchVo.getAreaId() != null && !searchVo.getAreaId().equals(0L) && (area = this.sysAreaProvideService.getAreaById(searchVo.getAreaId())) != null) {
            searchVo.setAreaLevel(area.getLevel());
        }
        return ((ReformItemBasicMapper)this.dao).getFindYearBySearchVo(searchVo);
    }

    public Boolean hasNotReformItem(Long cid, Byte source) {
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("source", (Object)source).andNotIn("status", Arrays.asList(2, 3)).andEqualTo("isValid", (Object)true);
        List list = ((ReformItemBasicMapper)this.dao).selectByExample(example);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public RiskInfoDataVo getRiskInfo(RiskListSearch search) {
        if (search.getId() == null) {
            return new RiskInfoDataVo();
        }
        return ((ReformItemBasicMapper)this.dao).getRiskInfo(search);
    }

    public void autoAcceptance(String cids) throws Exception {
        this.itemBasicNewService.autoAcceptance(cids);
    }

    @Transactional(readOnly=false)
    public List<ReformItemBasic> acceptDivide(List<Long> cidList, Byte generationSource, Integer year, Integer type) {
        List<Integer> generationSources = ReformGenerationSourceEnum.TRAIN.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOZYFZR.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOGLRY.getValue().equals(generationSource) ? Arrays.asList(ReformGenerationSourceEnum.TRAIN.getValue().intValue(), ReformGenerationSourceEnum.NOZYFZR.getValue().intValue(), ReformGenerationSourceEnum.NOGLRY.getValue().intValue()) : Collections.singletonList(generationSource.intValue());
        List<Object> notAcceptReformList = ((ReformItemBasicMapper)this.dao).getNotAcceptanceList(cidList, generationSources, year);
        if (CollectionUtils.isEmpty(notAcceptReformList)) {
            return Collections.emptyList();
        }
        List<Long> notAcceptCidList = (notAcceptReformList = notAcceptReformList.parallelStream().filter(Objects::nonNull).peek(item -> {
            List acceptanceList = item.getAceptanceList();
            if (CollectionUtils.isNotEmpty((Collection)acceptanceList)) {
                Map collect = acceptanceList.parallelStream().filter(temp -> temp != null && temp.getCreateDate() != null && temp.getCid() != null).collect(Collectors.toMap(ReformItemAcceptanceRecord::getCid, Function.identity(), (k1, k2) -> k1.getCreateDate().after(k2.getCreateDate()) ? k1 : k2));
                item.setAcceptance((ReformItemAcceptanceRecord)collect.get(item.getCid()));
            }
        }).collect(Collectors.toList())).parallelStream().filter(Objects::nonNull).map(ReformItemBasic::getCid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notAcceptCidList)) {
            return new ArrayList<ReformItemBasic>();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String effectiveDateStr = "2024-06-01 00:00:00";
        if (year == 2023) {
            effectiveDateStr = "2023-10-01 00:00:00";
        }
        HashMap<Long, String> msgType = new HashMap<Long, String>();
        List<Object> needAcceptReformList = new ArrayList<ReformItemBasic>();
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case DECLARE: {
                List<Long> isSuperviseList = ((ReformItemBasicMapper)this.dao).getIsSuperviseCom(notAcceptCidList);
                Map<Long, WandaDeclare> wandaDeclareMap = ((ReformItemBasicMapper)this.dao).getDeclareMapByCid(notAcceptCidList);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    WandaDeclare wandaDeclare = (WandaDeclare)wandaDeclareMap.get(cid);
                    if (isSuperviseList.contains(cid)) {
                        String msg = format.format(new Date()) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (wandaDeclare != null && item.getFindTime().getTime() < wandaDeclare.getDeclareTime().getTime()) {
                        String msg = format.format(wandaDeclare.getDeclareTime()) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case TJ: {
                Map<Long, PhcPhysicalCheckV3221> physicalCheckMap = ((ReformItemBasicMapper)this.dao).getPhysicalCompletedMap(notAcceptCidList, effectiveDateStr);
                Set<Long> physicalCompletedByReformList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(10), year);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    PhcPhysicalCheckV3221 phcPhysicalCheckV3221 = (PhcPhysicalCheckV3221)physicalCheckMap.get(cid);
                    if (phcPhysicalCheckV3221 != null) {
                        String msg = format.format(phcPhysicalCheckV3221.getCheckTime()) + "\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (physicalCompletedByReformList.contains(item.getCid())) {
                        String msg = "\u5df2\u7ecf\u5b58\u5728\u901a\u8fc7\u4f50\u8bc1\u6750\u6599\u5316\u89e3\u7684\u98ce\u9669";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case DETECTION: {
                Map<Long, CheckPlan> checkPlanMap = ((ReformItemBasicMapper)this.dao).getCheckCompletedMap(notAcceptCidList, effectiveDateStr);
                Set<Long> checkReformCompletedMap = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(14), year);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CheckPlan check = (CheckPlan)checkPlanMap.get(cid);
                    if (check != null) {
                        String msg = check.getCheckDateBegin().getYear() + "\u5e74" + check.getCheckDateBegin().getMonthValue() + "\u6708" + check.getCheckDateBegin().getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (checkReformCompletedMap.contains(item.getCid())) {
                        String msg = "\u5df2\u7ecf\u5b58\u5728\u901a\u8fc7\u4f50\u8bc1\u6750\u6599\u5316\u89e3\u7684\u98ce\u9669";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case TRAIN: 
            case NOZYFZR: 
            case NOGLRY: {
                Map<Long, CertificateStaffDetail> trainZCompletedMap = ((ReformItemBasicMapper)this.dao).getTrainCompletedMap(notAcceptCidList, 12, effectiveDateStr);
                Map<Long, CertificateStaffDetail> trainMCompletedMap = ((ReformItemBasicMapper)this.dao).getTrainCompletedMap(notAcceptCidList, 13, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CertificateStaffDetail zTrain = (CertificateStaffDetail)trainZCompletedMap.get(cid);
                    CertificateStaffDetail mTrain = (CertificateStaffDetail)trainMCompletedMap.get(cid);
                    if (ReformGenerationSourceEnum.TRAIN.getValue().equals(item.getGenerationSource()) && (zTrain != null || mTrain != null)) {
                        Object msg = "";
                        if (zTrain != null) {
                            msg = format.format(zTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad,";
                        }
                        if (mTrain != null) {
                            msg = (String)msg + format.format(mTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        }
                        msgType.put(cid, (String)msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOZYFZR.getValue().equals(item.getGenerationSource()) && zTrain != null) {
                        String msg = format.format(zTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOGLRY.getValue().equals(item.getGenerationSource()) && mTrain != null) {
                        String msg = format.format(mTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case THREE_TIME: {
                Set<Long> threeTimeNoCompletedSet = ((ReformItemBasicMapper)this.dao).getThreeSimultaneousNoCompleted(notAcceptCidList, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (CollectionUtils.isEmpty((Collection)threeTimeNoCompletedSet) || !threeTimeNoCompletedSet.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case PROTECTION: {
                Set<Long> protectEquipCompletedList = ((ReformItemBasicMapper)this.dao).getProtectEquipCompleted(notAcceptCidList, year);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (CollectionUtils.isNotEmpty((Collection)protectEquipCompletedList) && protectEquipCompletedList.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case WARNING_SIGNS: {
                Set<Long> warnSignManageCompleted = ((ReformItemBasicMapper)this.dao).getWarnSignManageCompleted(notAcceptCidList, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (CollectionUtils.isNotEmpty((Collection)warnSignManageCompleted) && warnSignManageCompleted.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case ARCHIVES: {
                Set healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(notAcceptCidList, year).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (CollectionUtils.isNotEmpty((Collection)healthManageFilesCompletedList) && healthManageFilesCompletedList.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
        }
        this.makeAndUpdateReform(needAcceptReformList, msgType);
        return needAcceptReformList;
    }

    public List<ReformItemBasic> makeAndUpdateReform(List<ReformItemBasic> needAcceptReformList, Map<Long, String> msgType) {
        if (CollectionUtils.isEmpty(needAcceptReformList)) {
            return Collections.emptyList();
        }
        ArrayList<ReformItemBasic> list = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>();
        for (ReformItemBasic item2 : needAcceptReformList) {
            String msg = msgType.get(item2.getCid());
            item2.setStatus(Byte.valueOf((byte)3));
            item2.setUpdateDate(new Date());
            ReformItemAcceptanceRecord acceptance = item2.getAcceptance();
            acceptance.setReformMeasure((String)(item2.getAcceptance().getReformMeasure() != null ? item2.getAcceptance().getReformMeasure() + "\n" : "") + msg);
            acceptance.setActualFinishTime(new Date());
            acceptance.setAcceptanceDate(new Date());
            acceptance.setAcceptanceResult(Byte.valueOf((byte)1));
            acceptance.setAcceptanceResultExplain("\u5df2\u9a8c\u6536");
            acceptance.setStatus(Byte.valueOf((byte)3));
            acceptance.setUpdateDate(new Date());
            list.add(item2);
            accList.add(acceptance);
        }
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                this.batchUpdateOrInsert(list, ReformItemBasicMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (CollectionUtils.isNotEmpty(accList)) {
                this.acceptanceRecordService.batchUpdateOrInsert(accList, ReformItemAcceptanceRecordMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5931\u8d25\uff1a\u4f01\u4e1aID\u4e3a\uff1a" + needAcceptReformList.toString());
            return list;
        }
    }

    public List<ReformItemBasic> makeAndUpdateReform2(List<ReformItemBasic> notAcceptReformList, Byte status, Long loginStaffId, Byte generationSource) {
        if (CollectionUtils.isEmpty(notAcceptReformList)) {
            return Collections.emptyList();
        }
        if (status == -1) {
            return null;
        }
        Date updateDate = new Date();
        ArrayList<ReformItemBasic> basicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>();
        for (ReformItemBasic basic : notAcceptReformList) {
            if (basic.getStatus().equals(status)) continue;
            basic.setStatus(status);
            basic.setUpdateDate(updateDate);
            basic.setUpdateBy(loginStaffId);
            basicList.add(basic);
            ReformItemAcceptanceRecord acceptance = basic.getAcceptance();
            if (!Objects.equals(ReformStatusEnum.WC.getValue(), status)) continue;
            acceptance.setActualFinishTime(updateDate);
            acceptance.setAcceptanceDate(updateDate);
            acceptance.setAcceptanceResult(Byte.valueOf((byte)1));
            acceptance.setAcceptanceResultExplain("\u5df2\u9a8c\u6536");
            accList.add(acceptance);
        }
        try {
            if (CollectionUtils.isNotEmpty(basicList)) {
                this.batchUpdateOrInsert(basicList, ReformItemBasicMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (CollectionUtils.isNotEmpty(accList)) {
                this.acceptanceRecordService.batchUpdateOrInsert(accList, ReformItemAcceptanceRecordMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5931\u8d25\uff1a\u4f01\u4e1aID\u4e3a\uff1a" + ((Object)basicList).toString());
        }
        return null;
    }

    public List<RiskSource> getAllReformItemByCid(List<String> cidList) {
        return ((ReformItemBasicMapper)this.dao).getAllReformItemByCid(cidList);
    }

    public List<Long> getThreeTimeReformByCid(List<Long> cidList) {
        List<Object> archiveList = this.liteArchiveMapper.getTsLiteArchiveList(null, null, cidList);
        if (CollectionUtils.isEmpty(archiveList)) {
            return Collections.emptyList();
        }
        List archiveIdList = archiveList.stream().map(LiteArchive::getId).collect(Collectors.toList());
        Map detailGroup = this.fileItemService.queryTsArchiveDetailGroup(archiveIdList, Boolean.FALSE);
        Map thirdListByCid = (archiveList = archiveList.stream().map(liteArchive -> {
            boolean noneCollect;
            TsLiteArchiveVo vo = new TsLiteArchiveVo();
            BeanUtils.copyProperties((Object)liteArchive, (Object)vo);
            List detailList = (List)detailGroup.get(liteArchive.getId());
            boolean bl = noneCollect = CollUtil.isEmpty((Collection)detailList) || detailList.stream().noneMatch(LiteArchiveFileDetailVo::getNeedCollect);
            if (noneCollect) {
                vo.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
                vo.setHasRequired(Boolean.FALSE);
            } else if (TsProjectSimpleStatusEnum.AUDITED.getCode().equals(liteArchive.getTsStatus()) || TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(liteArchive.getTsStatus())) {
                this.setArchiveInfo((TsLiteArchiveVo)liteArchive, vo);
            } else if (TsProjectSimpleStatusEnum.CLOSED.getCode().equals(liteArchive.getTsStatus())) {
                vo.setProgressRate(TsProgressEnum.TS_TERMINATE.getValue());
                vo.setHasRequired(Boolean.FALSE);
            } else if (TsProjectSimpleStatusEnum.DRAFT.getCode().equals(liteArchive.getTsStatus()) || TsProjectSimpleStatusEnum.AUDIT.getCode().equals(liteArchive.getTsStatus()) || TsProjectSimpleStatusEnum.BACK.getCode().equals(liteArchive.getTsStatus())) {
                vo.setProgressRate(TsProgressEnum.TS_NO_PERFECT.getValue());
                vo.setHasRequired(Boolean.TRUE);
            } else {
                vo.setProgressRate(TsProgressEnum.TS_ADD_INFO.getValue());
                vo.setHasRequired(Boolean.FALSE);
            }
            TsProjectSimple tsProjectSimple = new TsProjectSimple();
            tsProjectSimple.setId(liteArchive.getTsId());
            tsProjectSimple.setStatus(liteArchive.getTsStatus());
            vo.setTsProjectSimple(tsProjectSimple);
            return vo;
        }).collect(Collectors.toList())).stream().filter(r -> r.getCid() != null).collect(Collectors.groupingBy(LiteArchive::getCid, Collectors.toList()));
        if (thirdListByCid.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> needReformCidList = new ArrayList<Long>();
        ArrayList archiveIdTotalList = new ArrayList();
        for (Map.Entry thirdList : thirdListByCid.entrySet()) {
            boolean allComplete;
            boolean allNotNeed;
            List requiredList;
            List entryList = thirdList.getValue();
            ArchiveViewStateEnum tsViewState = CollectionUtils.isNotEmpty(entryList) ? (CollectionUtils.isEmpty(requiredList = entryList.stream().filter(ta -> Objects.equals(ta.getHasRequired(), true)).collect(Collectors.toList())) ? ((allNotNeed = entryList.stream().allMatch(t -> TsProgressEnum.TS_NO_NEED.getValue().equals(t.getProgressRate()))) ? ArchiveViewStateEnum.MISSING_ITEM : ArchiveViewStateEnum.IS_COMPLETE) : ((allComplete = requiredList.stream().allMatch(ta -> ta.getComplete() != null && ta.getComplete() != false)) ? ArchiveViewStateEnum.IS_COMPLETE : ArchiveViewStateEnum.NO_COMPLETE)) : ArchiveViewStateEnum.MISSING_ITEM;
            if (tsViewState != ArchiveViewStateEnum.NO_COMPLETE) continue;
            needReformCidList.add(thirdList.getKey());
        }
        return needReformCidList;
    }

    private void setArchiveInfo(TsLiteArchiveVo liteArchive, TsLiteArchiveVo vo) {
        if (Objects.nonNull(liteArchive.getMissingItem())) {
            vo.setProgressRate(TsProgressEnum.TS_NO_NEED.getValue());
            vo.setHasRequired(Boolean.valueOf(false));
        } else if (Objects.isNull(liteArchive.getProjectFinishTime())) {
            vo.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
            vo.setHasRequired(Boolean.valueOf(false));
        } else {
            List fileDetailVos = this.fileItemService.queryDetailList(liteArchive.getId());
            fileDetailVos.forEach(item -> {
                item.setNeedCollect(Boolean.valueOf(false));
                if (item.getFileNameId().equals(104L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(liteArchive.getEvalState())) {
                    vo.setHasRequired(Boolean.valueOf(true));
                    item.setNeedCollect(Boolean.valueOf(true));
                }
                if (item.getFileNameId().equals(106L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(liteArchive.getDesignState())) {
                    vo.setHasRequired(Boolean.valueOf(true));
                    item.setNeedCollect(Boolean.valueOf(true));
                }
                if (item.getFileNameId().equals(109L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(liteArchive.getControlState())) {
                    vo.setHasRequired(Boolean.valueOf(true));
                    item.setNeedCollect(Boolean.valueOf(true));
                }
            });
            long count = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false).count();
            List noFinishFileDetail = fileDetailVos.stream().filter(f -> {
                boolean b = f.getNeedCollect() != null && f.getNeedCollect() != false && cn.smarthse.util.common.StringUtils.isBlank((CharSequence)f.getFileIds());
                return b;
            }).collect(Collectors.toList());
            if (noFinishFileDetail.size() > 0) {
                vo.setProgressRate(TsProgressEnum.TS_NO_PERFECT.getValue() + "  " + (count - (long)noFinishFileDetail.size()) + "/" + count);
                vo.setComplete(Boolean.valueOf(false));
            } else {
                vo.setProgressRate(TsProgressEnum.TS_IS_PERFECT.getValue());
                vo.setComplete(Boolean.valueOf(true));
            }
        }
    }

    public ReformItemBasic getMultipleDataSourceBySearch(RiskListSearch search) {
        if (search.getCid() == null) {
            return new ReformItemBasic();
        }
        return ((ReformItemBasicMapper)this.dao).getMultipleDataSourceBySearch(search);
    }

    public List<ReformItemBasic> getReformItemSourceList(ReformItemBasic reform, Integer type) {
        if (reform == null || reform.getCid() == null || reform.getGenerationSource() == null) {
            return Collections.emptyList();
        }
        List<Byte> generationSourceValueList = this.getGenerationSourceValue();
        List<Byte> tjGenerationSourceValueList = this.getTjGenerationSourceValue();
        List<Object> list = new ArrayList<ReformItemBasic>();
        if (generationSourceValueList.contains(reform.getGenerationSource())) {
            List<Object> allList = ((ReformItemBasicMapper)this.dao).getReformItemSourceList(reform);
            allList = allList.parallelStream().filter(Objects::nonNull).peek(item -> {
                if (CollectionUtils.isNotEmpty((Collection)item.getAceptanceList())) {
                    Map collect = item.getAceptanceList().parallelStream().filter(temp -> temp != null && temp.getCreateDate() != null && temp.getCid() != null).collect(Collectors.toMap(ReformItemAcceptanceRecord::getCid, Function.identity(), (k1, k2) -> k1.getCreateDate().after(k2.getCreateDate()) ? k1 : k2));
                    item.setAcceptance((ReformItemAcceptanceRecord)collect.get(item.getCid()));
                }
            }).collect(Collectors.toList());
            if (type == 0) {
                list = allList;
            } else if (type == 1) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() != 7).collect(Collectors.toList());
                ReformItemBasic townshipReform = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7).max((o1, o2) -> o1.getFindTime().compareTo(o2.getFindTime())).orElse(null);
                if (townshipReform != null) {
                    list.add(townshipReform);
                }
            } else if (type == 2) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7 && Objects.equals(item.getId(), reform.getId())).collect(Collectors.toList());
            }
            Date date = list.stream().map(ReformItemBasic::getFindTime).min(Comparator.comparing(x -> x)).orElse(null);
            if (date != null) {
                for (ReformItemBasic reformItemBasic : list) {
                    reformItemBasic.setFindTime(date);
                }
            }
        } else if (tjGenerationSourceValueList.contains(reform.getGenerationSource())) {
            list.add(reform);
        } else {
            reform.setGenerationSourceStr("\u5176\u4ed6");
            list.add(reform);
        }
        return list;
    }

    public List<ReformItemBasic> getReformItemSourceListView(ReformItemBasic reform, Integer type) {
        List<ReformItemBasic> list = this.getReformItemSourceList(reform, type);
        for (ReformItemBasic item : list) {
            if (item == null) continue;
            item.setFinderName(DesensitizationUtils.desensitized((CharSequence)item.getFinderName(), (DesensitizationType)DesensitizationType.NAME));
            item.setFindTimeStr(ReformItemBasicServiceImpl.getFindTimeStr(item.getFindTime(), item.getStatus(), item.getAcceptanceDate(), item.getGenerationSource(), item.getCompanyRadioactivityType()));
        }
        return list;
    }

    public List<ReformItemBasic> getReformItemSourceList2(ReformItemBasic reform, Integer type, List<ReformItemBasic> allTypeList) {
        if (reform == null || reform.getCid() == null || reform.getGenerationSource() == null) {
            return Collections.emptyList();
        }
        List<Byte> generationSourceValueList = this.getGenerationSourceValue();
        List<Byte> tjGenerationSourceValueList = this.getTjGenerationSourceValue();
        List<Object> list = new ArrayList<ReformItemBasic>();
        if (generationSourceValueList.contains(reform.getGenerationSource())) {
            List allList = allTypeList.parallelStream().filter(Objects::nonNull).filter(item -> {
                if (item.getCid().equals(reform.getCid()) && item.getGenerationSource() != null && reform.getGenerationSource() != null && item.getGenerationSource().equals(reform.getGenerationSource())) {
                    return reform.getBatchNum() == null || reform.getBatchNum() != null && reform.getBatchNum().equals(item.getBatchNum());
                }
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(allList)) {
                allList = new ArrayList();
            } else {
                allTypeList.removeAll(allList);
            }
            if (type == 0) {
                list = allList;
            } else if (type == 1) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() != 7).collect(Collectors.toList());
                ReformItemBasic townshipReform = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7).max((o1, o2) -> o1.getFindTime().compareTo(o2.getFindTime())).orElse(null);
                if (townshipReform != null) {
                    list.add(townshipReform);
                }
            } else if (type == 2) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7 && Objects.equals(item.getId(), reform.getId())).collect(Collectors.toList());
            }
            Date date = list.stream().map(ReformItemBasic::getFindTime).min(Comparator.comparing(x -> x)).orElse(null);
            if (date != null) {
                for (ReformItemBasic reformItemBasic : list) {
                    reformItemBasic.setFindTime(date);
                }
            }
        } else if (tjGenerationSourceValueList.contains(reform.getGenerationSource())) {
            list.add(reform);
        } else {
            reform.setGenerationSourceStr("\u5176\u4ed6");
            list.add(reform);
        }
        return list;
    }

    public int countNumByYear(Long cid, int year) {
        Example example = new Example(ReformItemBasic.class);
        Date start = DateUtils.getYearFirstDay((int)year);
        Date end = DateUtils.getYearLastDay((int)year);
        Example.Criteria criteria = example.createCriteria();
        criteria.andNotEqualTo("reformItemSource", (Object)ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue()).andEqualTo("isValid", (Object)true).andBetween("createDate", (Object)start, (Object)end).andIn("generationSource", Arrays.asList(ReformGenerationSourceEnum.TJ.getValue(), ReformGenerationSourceEnum.DECLARE.getValue(), ReformGenerationSourceEnum.THREE_TIME.getValue(), ReformGenerationSourceEnum.DETECTION.getValue(), ReformGenerationSourceEnum.PROTECTION.getValue(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.ARCHIVES.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue()));
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        return this.getCountByExample(example);
    }

    public PageInfo<ReformItemBasic> getCidAndStatusListPage(int pageNum, int pageSize, int year) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<ReformItemBasic> getCidAndStatusList = ((ReformItemBasicMapper)this.dao).getCidAndStatusList(null, year);
        return new PageInfo(getCidAndStatusList);
    }

    public List<ReformItemBasic> getCidAndStatusList(Long cid, int year) {
        return ((ReformItemBasicMapper)this.dao).getCidAndStatusList(cid, year);
    }

    public PageInfo<RiskResolveResInfoVo> getReformRiskResolveResList(RiskResolveResSearch searchVo) {
        String riskTypeStr = searchVo.getRiskTypeStr();
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)riskTypeStr)) {
            List collect = Arrays.stream(riskTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
            ArrayList<Integer> riskTypeChildList = new ArrayList<Integer>();
            if (riskTypeStr.contains("211")) {
                riskTypeChildList.add(1);
                collect.add(21);
            }
            if (riskTypeStr.contains("212")) {
                riskTypeChildList.add(2);
                collect.add(21);
            }
            searchVo.setRiskChildTypeStrList(riskTypeChildList);
            searchVo.setRiskTypeStrList(collect);
        }
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)searchVo.getScales())) {
            searchVo.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchVo.getScales(), (String)","));
        }
        this.setIsCurrent(searchVo);
        PageHelper.startPage((int)searchVo.getPageNum(), (int)searchVo.getPageSize(), (boolean)false);
        List<RiskResolveResInfoVo> riskInfoList = ((ReformItemBasicMapper)this.dao).getRiskResolveList(searchVo);
        for (RiskResolveResInfoVo item : riskInfoList) {
            if (item == null) continue;
            item.setFindTimeStr(ReformItemBasicServiceImpl.getFindTimeStr(item.getFindTime(), item.getStatus(), item.getAcceptanceDate(), item.getGenerationSource(), item.getCompanyRadioactivityType()));
        }
        if (CollectionUtils.isEmpty(riskInfoList)) {
            return new PageInfo();
        }
        return new PageInfo(riskInfoList);
    }

    private static String getFindTimeStr(Date findTime, Byte status, Date acceptanceDate, Byte generationSource, Integer companyRadioactivityType) {
        if (findTime != null) {
            try {
                Date begin = DateUtils.parseDate((String)"2024-01-01", (String[])new String[]{"yyyy-MM-dd"});
                Date end = DateUtils.parseDate((String)"2024-03-01", (String[])new String[]{"yyyy-MM-dd"});
                if (DateUtils.getYear((Date)findTime) == 2024 && status != null && (status == 3 || status == 4) && acceptanceDate != null && DateUtils.compareDate((Date)acceptanceDate, (Date)begin) >= 0L && DateUtils.compareDate((Date)acceptanceDate, (Date)end) <= 0L) {
                    return "\u65e0\u9700\u63a8\u9001";
                }
                if (Objects.equals(7, companyRadioactivityType) && !Objects.equals((byte)11, generationSource) && findTime.before(DateUtils.parseDate((Object)"2025-09-01"))) {
                    return "-";
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return format.format(findTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public List<RiskResolveResInfoVo> exportListData(RiskResolveResSearch searchParam) {
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)searchParam.getRiskTypeStr())) {
            List collect = Arrays.stream(searchParam.getRiskTypeStr().split(",")).map(Integer::valueOf).collect(Collectors.toList());
            searchParam.setRiskTypeStrList(collect);
        }
        this.setIsCurrent(searchParam);
        return ((ReformItemBasicMapper)this.dao).getRiskResolveList(searchParam);
    }

    public PageInfo<RegionRiskStatisticsVo> areaRiskNumCountListDataOptimize(RiskResolveResSearch searchParam) {
        List<RegionRiskNumInfoVo> riskTotalList;
        boolean history;
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Integer page = searchParam.getPage();
        Integer rows = searchParam.getLimit();
        if (!Objects.equals(isFcImportanceCompany, 1)) {
            searchParam.setIsFcImportanceCompany(null);
        }
        if (!Objects.equals(year, 2024) && !Objects.equals(year, 202501)) {
            history = Boolean.FALSE;
            riskTotalList = this.getRegionRiskInfoAllList(searchParam);
        } else {
            history = Boolean.TRUE;
            riskTotalList = this.getRegionRiskInfoHistoryList(searchParam);
        }
        if (CollUtil.isEmpty(riskTotalList)) {
            return new PageInfo(Collections.emptyList());
        }
        Page resultPage = new Page(page.intValue(), rows.intValue());
        long totalNum = riskTotalList.stream().map(RegionRiskNumInfoVo::getResolveComNum).reduce(0L, Long::sum);
        long singleResolvePxNum = riskTotalList.stream().map(RegionRiskNumInfoVo::getSingleResolvePxNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long singleResolveTjNum = riskTotalList.stream().map(RegionRiskNumInfoVo::getSingleResolveTjNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve2Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve2Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve3Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve3Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve4Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve4Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve5Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve5Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve6Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve6Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve7Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve7Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        long multipleResolve8Num = riskTotalList.stream().map(RegionRiskNumInfoVo::getMultipleResolve8Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
        BigDecimal data1 = riskTotalList.stream().map(RegionRiskNumInfoVo::getLessImpunityDecreaseCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal data2 = riskTotalList.stream().map(RegionRiskNumInfoVo::getMostImpunityDecreaseCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal data3 = riskTotalList.stream().map(RegionRiskNumInfoVo::getLessRiskSolveDecreaseCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal data4 = riskTotalList.stream().map(RegionRiskNumInfoVo::getMostRiskSolveDecreaseCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal data5 = riskTotalList.stream().map(RegionRiskNumInfoVo::getLessDecreasePunishmentCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal data6 = riskTotalList.stream().map(RegionRiskNumInfoVo::getMostDecreasePunishmentCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        RegionRiskStatisticsVo result = new RegionRiskStatisticsVo().setTotalResolveComNum(Long.valueOf(totalNum)).setLessImpunityDecreaseCostSum(data1).setMostImpunityDecreaseCostSum(data2).setLessRiskSolveDecreaseCostSum(data3.divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP)).setMostRiskSolveDecreaseCostSum(data4.divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP)).setLessDecreasePunishmentCostSum(data5).setMostDecreasePunishmentCostSum(data6).setLessFreePunishAmountSum(Convert.toBigDecimal((Object)totalNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP)).setMostFreePunishAmountSum(Convert.toBigDecimal((Object)totalNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        if (history && Objects.equals(year, 2024)) {
            result.setTotalFreePunishAmount(Convert.toBigDecimal((Object)totalNum).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        } else {
            result.setTotalFreePunishAmount(Convert.toBigDecimal((Object)singleResolvePxNum).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_1).add(Convert.toBigDecimal((Object)singleResolveTjNum).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve2Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve3Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_3)).add(Convert.toBigDecimal((Object)multipleResolve4Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_4)).add(Convert.toBigDecimal((Object)multipleResolve5Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_5)).add(Convert.toBigDecimal((Object)multipleResolve6Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_6)).add(Convert.toBigDecimal((Object)multipleResolve7Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_7)).add(Convert.toBigDecimal((Object)multipleResolve8Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_8)).setScale(4, RoundingMode.HALF_UP));
        }
        if (year == null && LocalDate.now().getMonthValue() <= 6) {
            result.setFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)result.getTotalFreePunishAmount()));
        } else {
            Pair<Long, String> p = this.calcFreePunishAmount2(searchParam);
            result.setCurrYearTotalResolveNum((Long)p.getKey());
            result.setFreePunishAmount((String)p.getValue());
        }
        int total = riskTotalList.size();
        int start = (page - 1) * rows;
        int end = Math.min(start + rows, total);
        List<RegionRiskNumInfoVo> riskPageList = ReformItemBasicServiceImpl.deepCopy(new ArrayList<RegionRiskNumInfoVo>(riskTotalList.subList(start, end)));
        if (history && Objects.equals(year, 2024)) {
            riskPageList.forEach(r -> ReformItemBasicServiceImpl.setMultipleFieldValueByResolveComNum_Old(r, Optional.ofNullable(r.getResolveComNum()).orElse(0L)));
        } else {
            riskPageList.forEach(r -> ReformItemBasicServiceImpl.setMultipleFieldValueByResolveComNum(r, Optional.ofNullable(r.getResolveComNum()).orElse(0L), Optional.ofNullable(r.getSingleResolvePxNum()).orElse(0L), Optional.ofNullable(r.getSingleResolveTjNum()).orElse(0L), Optional.ofNullable(r.getMultipleResolve2Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve3Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve4Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve5Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve6Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve7Num()).orElse(0L), Optional.ofNullable(r.getMultipleResolve8Num()).orElse(0L)));
        }
        result.setRegionRiskNumInfoVoList(riskPageList);
        resultPage.setTotal((long)total);
        resultPage.addAll((Collection)CollUtil.toList((Object[])new RegionRiskStatisticsVo[]{result}));
        return new PageInfo((List)resultPage);
    }

    public PageInfo<Map<Long, List<TrainCompanyStaffModel>>> getRegionTrainCompanyStaffPage(JqGridParam page, TrainCompanyStaffModel param) {
        this.preSetRegionInfo(param);
        List<TrainCompanyStaffModel> initDataList = this.getTrainInitDataList(param);
        List<TrainCompanyStaffModel> dataList = this.getTrainDataList(param);
        dataList = ReformItemBasicServiceImpl.fillReplaceTrainInitDataList(initDataList, dataList);
        ReformItemBasicServiceImpl.summaryTrainDataList(dataList);
        dataList = ReformItemBasicServiceImpl.sortTrainDataList(dataList);
        this.postSetRegionName(dataList);
        Map<Long, List<TrainCompanyStaffModel>> dataMap = ReformItemBasicServiceImpl.convertTrainDataListToMap(dataList);
        Page<Map<Long, List<TrainCompanyStaffModel>>> dataPage = ReformItemBasicServiceImpl.paginateTrainDataMap(dataMap, page.getPage(), page.getRows());
        return new PageInfo(dataPage);
    }

    private void preSetRegionInfo(TrainCompanyStaffModel param) {
        if (param == null || param.getRegionId() == null) {
            return;
        }
        AreaModel region = this.sysAreaProvideService.getAreaById(param.getRegionId());
        if (region == null || region.getId() == null) {
            return;
        }
        param.setRegionLevel(region.getLevel());
        param.setRegionName(region.getName());
    }

    private List<TrainCompanyStaffModel> getTrainInitDataList(TrainCompanyStaffModel param) {
        List subRegionList = this.sysAreaProvideService.getChildByParentId(param.getRegionId(), "");
        List subRegionIdList = subRegionList.stream().map(AreaModel::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollUtil.isEmpty(subRegionIdList)) {
            return Collections.emptyList();
        }
        CertificateStaffDetailDataSourceEnum[] dataSources = new CertificateStaffDetailDataSourceEnum[]{CertificateStaffDetailDataSourceEnum.COMPANY, CertificateStaffDetailDataSourceEnum.ONLINE, CertificateStaffDetailDataSourceEnum.OTHER, CertificateStaffDetailDataSourceEnum.WANDA};
        Byte[] businessStates = new Byte[]{(byte)1, (byte)0};
        return subRegionIdList.stream().flatMap(regionId -> Arrays.stream(dataSources).flatMap(type -> Arrays.stream(businessStates).map(businessState -> new TrainCompanyStaffModel().setRegionId(regionId).setType(type.getValue()).setBusinessState(businessState).setTrainCompanyNums(Integer.valueOf(0)).setCertStaffNums(Integer.valueOf(0))))).collect(Collectors.toList());
    }

    private List<TrainCompanyStaffModel> getTrainDataList(TrainCompanyStaffModel param) {
        CopyOnWriteArrayList<TrainCompanyStaffModel> resultList = new CopyOnWriteArrayList<TrainCompanyStaffModel>();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        CountDownLatch latch = new CountDownLatch(4);
        Runnable[] tasks = new Runnable[]{() -> {
            try {
                TrainCompanyStaffModel queryParam = new TrainCompanyStaffModel();
                BeanUtils.copyProperties((Object)param, (Object)queryParam);
                queryParam.setType(CertificateStaffDetailDataSourceEnum.COMPANY.getValue());
                resultList.addAll(((ReformItemBasicMapper)this.dao).getTrainCompanyStaffList_145(queryParam));
            }
            finally {
                latch.countDown();
            }
        }, () -> {
            try {
                TrainCompanyStaffModel queryParam = new TrainCompanyStaffModel();
                BeanUtils.copyProperties((Object)param, (Object)queryParam);
                queryParam.setType(CertificateStaffDetailDataSourceEnum.OTHER.getValue());
                resultList.addAll(((ReformItemBasicMapper)this.dao).getTrainCompanyStaffList_145(queryParam));
            }
            finally {
                latch.countDown();
            }
        }, () -> {
            try {
                TrainCompanyStaffModel queryParam = new TrainCompanyStaffModel();
                BeanUtils.copyProperties((Object)param, (Object)queryParam);
                queryParam.setType(CertificateStaffDetailDataSourceEnum.WANDA.getValue());
                resultList.addAll(((ReformItemBasicMapper)this.dao).getTrainCompanyStaffList_145(queryParam));
            }
            finally {
                latch.countDown();
            }
        }, () -> {
            try {
                resultList.addAll(((ReformItemBasicMapper)this.dao).getTrainCompanyStaffList_3(param));
            }
            finally {
                latch.countDown();
            }
        }};
        Arrays.stream(tasks).forEach(executor::execute);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServiceException("\u57f9\u8bad\u6570\u636e\u67e5\u8be2\u88ab\u4e2d\u65ad", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
        return resultList;
    }

    public static List<TrainCompanyStaffModel> fillReplaceTrainInitDataList(List<TrainCompanyStaffModel> initDataList, List<TrainCompanyStaffModel> dataList) {
        if (CollUtil.isEmpty(initDataList)) {
            return dataList;
        }
        ArrayList<TrainCompanyStaffModel> resultList = new ArrayList<TrainCompanyStaffModel>(initDataList.size());
        for (TrainCompanyStaffModel initData : initDataList) {
            TrainCompanyStaffModel matchedItem = ReformItemBasicServiceImpl.findMatchedData(initData.getRegionId(), initData.getType(), initData.getBusinessState(), dataList);
            resultList.add(matchedItem != null ? matchedItem : initData);
        }
        return resultList;
    }

    private static TrainCompanyStaffModel findMatchedData(Long regionId, Integer type, Byte businessState, List<TrainCompanyStaffModel> dataList) {
        for (TrainCompanyStaffModel data : dataList) {
            if (!Objects.equals(data.getRegionId(), regionId) || !Objects.equals(data.getType(), type) || !Objects.equals(data.getBusinessState(), businessState)) continue;
            return data;
        }
        return null;
    }

    public static void summaryTrainDataList(List<TrainCompanyStaffModel> dataList) {
        Map<String, List<TrainCompanyStaffModel>> groupData = dataList.stream().collect(Collectors.groupingBy(t -> t.getRegionId() + "_" + t.getBusinessState()));
        groupData.forEach((key, group) -> {
            int sumTrainCompanyNums = group.stream().mapToInt(TrainCompanyStaffModel::getTrainCompanyNums).sum();
            int sumCertStaffNums = group.stream().mapToInt(TrainCompanyStaffModel::getCertStaffNums).sum();
            TrainCompanyStaffModel sum = new TrainCompanyStaffModel().setType(Integer.valueOf(0)).setTrainCompanyNums(Integer.valueOf(sumTrainCompanyNums)).setCertStaffNums(Integer.valueOf(sumCertStaffNums));
            if (CollUtil.isNotEmpty((Collection)group)) {
                TrainCompanyStaffModel group0 = (TrainCompanyStaffModel)group.get(0);
                sum.setRegionId(group0.getRegionId()).setBusinessState(group0.getBusinessState());
            }
            dataList.add(sum);
        });
    }

    private static List<TrainCompanyStaffModel> sortTrainDataList(List<TrainCompanyStaffModel> dataList) {
        if (dataList == null) {
            return Collections.emptyList();
        }
        return dataList.stream().filter(d -> d.getRegionId() != null).sorted(Comparator.comparing(TrainCompanyStaffModel::getRegionId).thenComparing(TrainCompanyStaffModel::getType).thenComparing(TrainCompanyStaffModel::getBusinessState, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    private void postSetRegionName(List<TrainCompanyStaffModel> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        String regionIds = dataList.stream().map(TrainCompanyStaffModel::getRegionId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        if (StringUtils.isBlank((String)regionIds)) {
            return;
        }
        List regionList = this.sysAreaProvideService.getAreaListByIds(regionIds);
        if (CollUtil.isEmpty((Collection)regionList)) {
            return;
        }
        Map<Long, String> regionNameMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, this::getSimpleRegionName));
        Map<Long, String> fullRegionNameMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, this::getFullRegionName));
        dataList.forEach(d -> {
            Long regionId = d.getRegionId();
            d.setRegionName((String)regionNameMap.get(regionId));
            d.setFullRegionName((String)fullRegionNameMap.get(regionId));
        });
    }

    private String getSimpleRegionName(AreaModel region) {
        if (region == null) {
            return "";
        }
        switch (region.getLevel()) {
            case 0: {
                return "\u56fd\u5bb6";
            }
            case 1: {
                return region.getProvinceName();
            }
            case 2: {
                return region.getCityName();
            }
            case 3: {
                return region.getAreaName();
            }
            case 4: {
                return region.getStreetName();
            }
        }
        return "";
    }

    private String getFullRegionName(AreaModel region) {
        if (region == null) {
            return "";
        }
        switch (region.getLevel()) {
            case 0: {
                return "\u56fd\u5bb6";
            }
            case 1: {
                return region.getProvinceName();
            }
            case 2: {
                return region.getProvinceName() + "/" + region.getCityName();
            }
            case 3: {
                return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
            }
            case 4: {
                return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName() + "/" + region.getStreetName();
            }
        }
        return "";
    }

    public static Map<Long, List<TrainCompanyStaffModel>> convertTrainDataListToMap(List<TrainCompanyStaffModel> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyMap();
        }
        return dataList.stream().filter(t -> t.getRegionId() != null).collect(Collectors.groupingBy(TrainCompanyStaffModel::getRegionId, TreeMap::new, Collectors.toList()));
    }

    public static Page<Map<Long, List<TrainCompanyStaffModel>>> paginateTrainDataMap(Map<Long, List<TrainCompanyStaffModel>> dataMap, int pageNum, int pageSize) {
        Page dataPage = new Page(pageNum, pageSize);
        ArrayList<Long> regionIdList = new ArrayList<Long>(dataMap.keySet());
        regionIdList.sort(Long::compareTo);
        int totalSize = regionIdList.size();
        dataPage.setTotal((long)totalSize);
        int start = (pageNum - 1) * pageSize;
        if (start >= totalSize) {
            return dataPage;
        }
        int end = Math.min(start + pageSize, totalSize);
        LinkedHashMap pageData = new LinkedHashMap();
        regionIdList.subList(start, end).forEach(regionId -> pageData.put(regionId, (List)dataMap.get(regionId)));
        dataPage.add(pageData);
        return dataPage;
    }

    public List<RegionRiskNumInfoVo> exportAreaRiskNumCountListData(RiskResolveResSearch searchParam) {
        Integer year = searchParam.getYear();
        List<RegionRiskNumInfoVo> riskTotalList = !Objects.equals(year, 2024) && !Objects.equals(year, 202501) ? this.getRegionRiskInfoAllList(searchParam) : this.getRegionRiskInfoHistoryList(searchParam);
        if (CollUtil.isEmpty(riskTotalList)) {
            return Collections.emptyList();
        }
        this.setEnvSortBy(riskTotalList, searchParam.getEnvSortBy());
        return riskTotalList;
    }

    private List<RegionRiskNumInfoVo> getRegionRiskInfoAllList(RiskResolveResSearch searchParam) {
        List<RegionRiskNumInfoVo> riskTotalList;
        boolean noDataSearch;
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        boolean bl = noDataSearch = year != null && year <= 202401 && Objects.equals(isFcImportanceCompany, 1);
        if (noDataSearch) {
            return Collections.emptyList();
        }
        this.handleQueryDateRange(searchParam);
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setReformStatus(ReformStatusEnum.WC.getValue()).setSearchType(Integer.valueOf(0)).setIsRegionRiskStatistics(Boolean.TRUE).setEnableRiskDateFilter(Boolean.TRUE);
        if (Objects.equals(regionLevel, (byte)3) || Objects.equals(regionLevel, (byte)4)) {
            searchParam.setIsCurrent(Boolean.TRUE);
        }
        if (CollUtil.isEmpty(riskTotalList = ((ReformItemBasicMapper)this.dao).areaRiskNumCountListDataOptimize(searchParam))) {
            return Collections.emptyList();
        }
        List regionIdList = riskTotalList.stream().map(RegionRiskNumInfoVo::getRegionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        searchParam.setRegionIdList(regionIdList);
        List<RegionRiskNumInfoVo> resolveComNumList = this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam);
        Map<Long, Long> resolveComNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getResolveComNum));
        Map<Long, Long> singleResolvePxNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getSingleResolvePxNum));
        Map<Long, Long> singleResolveTjNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getSingleResolveTjNum));
        Map<Long, Long> multipleResolve2NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve2Num));
        Map<Long, Long> multipleResolve3NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve3Num));
        Map<Long, Long> multipleResolve4NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve4Num));
        Map<Long, Long> multipleResolve5NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve5Num));
        Map<Long, Long> multipleResolve6NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve6Num));
        Map<Long, Long> multipleResolve7NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve7Num));
        Map<Long, Long> multipleResolve8NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve8Num));
        riskTotalList.forEach(r -> ReformItemBasicServiceImpl.setMultipleFieldValueByResolveComNum(r, resolveComNumMap.getOrDefault(r.getRegionId(), 0L), singleResolvePxNumMap.getOrDefault(r.getRegionId(), 0L), singleResolveTjNumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve2NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve3NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve4NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve5NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve6NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve7NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve8NumMap.getOrDefault(r.getRegionId(), 0L)));
        return riskTotalList;
    }

    private List<RegionRiskNumInfoVo> getRegionRiskInfoHistoryList(RiskResolveResSearch searchParam) {
        List<Object> riskTotalList;
        boolean needQuery;
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Integer page = searchParam.getPage();
        Integer rows = searchParam.getLimit();
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        String historyCacheKey = String.format("%s:%s", AREA_RISK_HISTORY_CACHE_KEY, this.generateCacheKey(year, regionId, isFcImportanceCompany == null ? 0 : isFcImportanceCompany, isExistRadioactivity, page, rows, startDate == null ? null : DateUtil.format((Date)startDate, (String)"yyyyMMdd"), endDate == null ? null : DateUtil.format((Date)endDate, (String)"yyyyMMdd")));
        if (this.redisClient.hasKey(historyCacheKey)) {
            return (List)this.redisClient.get(historyCacheKey);
        }
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setReformStatus(ReformStatusEnum.WC.getValue()).setSearchType(Integer.valueOf(0)).setIsRegionRiskStatistics(Boolean.TRUE).setEnableRiskDateFilter(Boolean.TRUE);
        if (Objects.equals(regionLevel, (byte)3) || Objects.equals(regionLevel, (byte)4)) {
            searchParam.setIsCurrent(Boolean.TRUE);
        }
        if (year == 2024) {
            if (Objects.equals(isFcImportanceCompany, 1)) {
                needQuery = this.calcDateIntersection(searchParam.setYear(Integer.valueOf(202402)));
                riskTotalList = needQuery ? ((ReformItemBasicMapper)this.dao).areaRiskNumCountListDataOptimize(searchParam) : Collections.emptyList();
                searchParam.setStartDate(startDate);
                searchParam.setEndDate(endDate);
            } else {
                needQuery = this.calcDateIntersection(searchParam.setYear(Integer.valueOf(202401)));
                List<RegionRiskNumInfoVo> riskList01 = needQuery ? ((ReformItemBasicMapper)this.dao).areaRiskNumCountListDataOptimize(searchParam) : Collections.emptyList();
                searchParam.setStartDate(startDate);
                searchParam.setEndDate(endDate);
                needQuery = this.calcDateIntersection(searchParam.setYear(Integer.valueOf(202402)));
                List<RegionRiskNumInfoVo> riskList02 = needQuery ? ((ReformItemBasicMapper)this.dao).areaRiskNumCountListDataOptimize(searchParam) : Collections.emptyList();
                searchParam.setStartDate(startDate);
                searchParam.setEndDate(endDate);
                riskTotalList = this.mergeRiskTotalLists(riskList01, riskList02);
            }
        } else {
            needQuery = this.calcDateIntersection(searchParam.setYear(year));
            riskTotalList = needQuery ? ((ReformItemBasicMapper)this.dao).areaRiskNumCountListDataOptimize(searchParam) : Collections.emptyList();
            searchParam.setStartDate(startDate);
            searchParam.setEndDate(endDate);
        }
        if (CollUtil.isEmpty(riskTotalList)) {
            this.redisClient.set(historyCacheKey, riskTotalList);
            return Collections.emptyList();
        }
        List regionIdList = riskTotalList.stream().map(RegionRiskNumInfoVo::getRegionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        searchParam.setRegionIdList(regionIdList);
        if (year == 2024) {
            needQuery = this.calcDateIntersection(searchParam.setYear(Integer.valueOf(202401)));
            List<RegionRiskNumInfoVo> resolveList01 = needQuery ? this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam) : Collections.emptyList();
            searchParam.setStartDate(startDate);
            searchParam.setEndDate(endDate);
            needQuery = this.calcDateIntersection(searchParam.setYear(Integer.valueOf(202402)));
            List<RegionRiskNumInfoVo> resolveList02 = needQuery ? this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam) : Collections.emptyList();
            searchParam.setStartDate(startDate);
            searchParam.setEndDate(endDate);
            resolveComNumList = this.mergeResolveComNumLists(resolveList01, resolveList02);
            Map<Long, Long> resolveComNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getResolveComNum));
            riskTotalList.forEach(r -> ReformItemBasicServiceImpl.setMultipleFieldValueByResolveComNum_Old(r, resolveComNumMap.getOrDefault(r.getRegionId(), 0L)));
        } else {
            needQuery = this.calcDateIntersection(searchParam.setYear(year));
            resolveComNumList = needQuery ? this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam) : Collections.emptyList();
            searchParam.setStartDate(startDate);
            searchParam.setEndDate(endDate);
            Map<Long, Long> resolveComNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getResolveComNum));
            Map<Long, Long> singleResolvePxNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getSingleResolvePxNum));
            Map<Long, Long> singleResolveTjNumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getSingleResolveTjNum));
            Map<Long, Long> multipleResolve2NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve2Num));
            Map<Long, Long> multipleResolve3NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve3Num));
            Map<Long, Long> multipleResolve4NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve4Num));
            Map<Long, Long> multipleResolve5NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve5Num));
            Map<Long, Long> multipleResolve6NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve6Num));
            Map<Long, Long> multipleResolve7NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve7Num));
            Map<Long, Long> multipleResolve8NumMap = resolveComNumList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, RegionRiskNumInfoVo::getMultipleResolve8Num));
            riskTotalList.forEach(r -> ReformItemBasicServiceImpl.setMultipleFieldValueByResolveComNum(r, resolveComNumMap.getOrDefault(r.getRegionId(), 0L), singleResolvePxNumMap.getOrDefault(r.getRegionId(), 0L), singleResolveTjNumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve2NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve3NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve4NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve5NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve6NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve7NumMap.getOrDefault(r.getRegionId(), 0L), multipleResolve8NumMap.getOrDefault(r.getRegionId(), 0L)));
        }
        searchParam.setYear(year);
        searchParam.setStartDate(startDate);
        searchParam.setEndDate(endDate);
        this.redisClient.set(historyCacheKey, riskTotalList);
        return riskTotalList;
    }

    private boolean calcDateIntersection(RiskResolveResSearch searchParam) {
        Date d1 = searchParam.getStartDate();
        Date d2 = searchParam.getEndDate();
        boolean defaultQuery = d1 == null || d2 == null;
        this.handleQueryDateRange(searchParam);
        if (defaultQuery) {
            return Boolean.TRUE;
        }
        Date d3 = searchParam.getStartDate();
        Date d4 = searchParam.getEndDate();
        if (d2.before(d3) || d4.before(d1)) {
            return Boolean.FALSE;
        }
        searchParam.setStartDate(d1.after(d3) ? d1 : d3);
        searchParam.setEndDate(d2.before(d4) ? d2 : d4);
        return Boolean.TRUE;
    }

    private static void setMultipleFieldValueByResolveComNum_Old(RegionRiskNumInfoVo r, Long resolveComNum) {
        r.setResolveComNum(resolveComNum);
        int[] s = new int[]{r.getDeclare(), r.getTj(), r.getDetection(), r.getTrain(), r.getThreeTime(), r.getProtection(), r.getWarningSigns(), r.getArchives()};
        BigDecimal mostPenalize = Convert.toBigDecimal((Object)(Arrays.stream(s).sum() * 10));
        BigDecimal lessRisk = Convert.toBigDecimal((Object)((double)(s[4] * 10 + s[1] * 5 + s[6] * 5 + s[2] * 5 + s[5] * 5 + s[0] * 5) + (double)s[3] * 0.5));
        BigDecimal mostRisk = Convert.toBigDecimal((Object)(s[4] * 50 + s[1] * 10 + s[6] * 20 + s[2] * 20 + s[5] * 20 + s[0] * 10 + s[7] * 10 + s[3] * 2));
        r.setLessImpunityDecreaseCost(BigDecimal.ZERO);
        r.setMostImpunityDecreaseCost(mostPenalize);
        r.setLessRiskSolveDecreaseCost(lessRisk);
        r.setMostRiskSolveDecreaseCost(mostRisk);
        r.setLessDecreasePunishmentCost(lessRisk.divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP));
        r.setMostDecreasePunishmentCost(mostRisk.add(mostPenalize).divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP));
        r.setLessFreePunishAmount(Convert.toBigDecimal((Object)resolveComNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setMostFreePunishAmount(Convert.toBigDecimal((Object)resolveComNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setFreePunishAmount(Convert.toBigDecimal((Object)resolveComNum).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
    }

    private static void setMultipleFieldValueByResolveComNum(RegionRiskNumInfoVo r, Long resolveComNum, Long singleResolvePxNum, Long singleResolveTjNum, Long multipleResolve2Num, Long multipleResolve3Num, Long multipleResolve4Num, Long multipleResolve5Num, Long multipleResolve6Num, Long multipleResolve7Num, Long multipleResolve8Num) {
        r.setResolveComNum(resolveComNum);
        r.setSingleResolvePxNum(singleResolvePxNum);
        r.setSingleResolveTjNum(singleResolveTjNum);
        r.setMultipleResolve2Num(multipleResolve2Num);
        r.setMultipleResolve3Num(multipleResolve3Num);
        r.setMultipleResolve4Num(multipleResolve4Num);
        r.setMultipleResolve5Num(multipleResolve5Num);
        r.setMultipleResolve6Num(multipleResolve6Num);
        r.setMultipleResolve7Num(multipleResolve7Num);
        r.setMultipleResolve8Num(multipleResolve8Num);
        int[] s = new int[]{r.getDeclare(), r.getTj(), r.getDetection(), r.getTrain(), r.getThreeTime(), r.getProtection(), r.getWarningSigns(), r.getArchives()};
        BigDecimal mostPenalize = Convert.toBigDecimal((Object)(Arrays.stream(s).sum() * 10));
        BigDecimal lessRisk = Convert.toBigDecimal((Object)((double)(s[4] * 10 + s[1] * 5 + s[6] * 5 + s[2] * 5 + s[5] * 5 + s[0] * 5) + (double)s[3] * 0.5));
        BigDecimal mostRisk = Convert.toBigDecimal((Object)(s[4] * 50 + s[1] * 10 + s[6] * 20 + s[2] * 20 + s[5] * 20 + s[0] * 10 + s[7] * 10 + s[3] * 2));
        r.setLessImpunityDecreaseCost(BigDecimal.ZERO);
        r.setMostImpunityDecreaseCost(mostPenalize);
        r.setLessRiskSolveDecreaseCost(lessRisk);
        r.setMostRiskSolveDecreaseCost(mostRisk);
        r.setLessDecreasePunishmentCost(lessRisk.divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP));
        r.setMostDecreasePunishmentCost(mostRisk.add(mostPenalize).divide(RiskCalculator.TEN_THOUSAND, 2, RoundingMode.HALF_UP));
        r.setLessFreePunishAmount(Convert.toBigDecimal((Object)resolveComNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setMostFreePunishAmount(Convert.toBigDecimal((Object)resolveComNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        BigDecimal freePunishAmount = Convert.toBigDecimal((Object)singleResolvePxNum).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_1).add(Convert.toBigDecimal((Object)singleResolveTjNum).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve2Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve3Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_3)).add(Convert.toBigDecimal((Object)multipleResolve4Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_4)).add(Convert.toBigDecimal((Object)multipleResolve5Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_5)).add(Convert.toBigDecimal((Object)multipleResolve6Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_6)).add(Convert.toBigDecimal((Object)multipleResolve7Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_7)).add(Convert.toBigDecimal((Object)multipleResolve8Num).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_8)).setScale(4, RoundingMode.HALF_UP);
        r.setFreePunishAmount(freePunishAmount);
    }

    public List<RegionRiskNumInfoVo> mergeRiskTotalLists(List<RegionRiskNumInfoVo> riskList01, List<RegionRiskNumInfoVo> riskList02) {
        return Stream.concat(riskList01.stream(), riskList02.stream()).map(RegionRiskNumInfoVo::getRegionId).distinct().map(regionId -> {
            RegionRiskNumInfoVo r1 = riskList01.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r2 = riskList02.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r3 = new RegionRiskNumInfoVo();
            r3.setRegionId(regionId);
            if (r1 == null) {
                assert (r2 != null);
                BeanUtils.copyProperties((Object)r2, (Object)r3);
            } else if (r2 == null) {
                BeanUtils.copyProperties((Object)r1, (Object)r3);
            } else {
                r3.setRegionName(r1.getRegionName());
                r3.setDeclare(Integer.valueOf(r1.getDeclare() + r2.getDeclare()));
                r3.setTj(Integer.valueOf(r1.getTj() + r2.getTj()));
                r3.setDetection(Integer.valueOf(r1.getDetection() + r2.getDetection()));
                r3.setTrain(Integer.valueOf(r1.getTrain() + r2.getTrain()));
                r3.setThreeTime(Integer.valueOf(r1.getThreeTime() + r2.getThreeTime()));
                r3.setProtection(Integer.valueOf(r1.getProtection() + r2.getProtection()));
                r3.setWarningSigns(Integer.valueOf(r1.getWarningSigns() + r2.getWarningSigns()));
                r3.setArchives(Integer.valueOf(r1.getArchives() + r2.getArchives()));
                r3.setDetectExceedStand(Integer.valueOf(r1.getDetectExceedStand() + r2.getDetectExceedStand()));
                r3.setTjYszyb(Integer.valueOf(r1.getTjYszyb() + r2.getTjYszyb()));
                r3.setTjZyjjz(Integer.valueOf(r1.getTjZyjjz() + r2.getTjZyjjz()));
                r3.setDoseMonitor(Integer.valueOf(r1.getDoseMonitor() + r2.getDoseMonitor()));
            }
            return r3;
        }).collect(Collectors.toList());
    }

    public List<RegionRiskNumInfoVo> mergeResolveComNumLists(List<RegionRiskNumInfoVo> riskList01, List<RegionRiskNumInfoVo> riskList02) {
        return Stream.concat(riskList01.stream(), riskList02.stream()).map(RegionRiskNumInfoVo::getRegionId).distinct().map(regionId -> {
            RegionRiskNumInfoVo r1 = riskList01.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r2 = riskList02.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r3 = new RegionRiskNumInfoVo();
            r3.setRegionId(regionId);
            if (r1 == null) {
                assert (r2 != null);
                r3.setRegionName(r2.getRegionName());
                r3.setResolveComNum(r2.getResolveComNum());
                r3.setSingleResolvePxNum(r2.getSingleResolvePxNum());
                r3.setSingleResolveTjNum(r2.getSingleResolveTjNum());
                r3.setMultipleResolve2Num(r2.getMultipleResolve2Num());
                r3.setMultipleResolve3Num(r2.getMultipleResolve3Num());
                r3.setMultipleResolve4Num(r2.getMultipleResolve4Num());
                r3.setMultipleResolve5Num(r2.getMultipleResolve5Num());
                r3.setMultipleResolve6Num(r2.getMultipleResolve6Num());
                r3.setMultipleResolve7Num(r2.getMultipleResolve7Num());
                r3.setMultipleResolve8Num(r2.getMultipleResolve8Num());
            } else if (r2 == null) {
                r3.setRegionName(r1.getRegionName());
                r3.setResolveComNum(r1.getResolveComNum());
                r3.setSingleResolvePxNum(r1.getSingleResolvePxNum());
                r3.setSingleResolveTjNum(r1.getSingleResolveTjNum());
                r3.setMultipleResolve2Num(r1.getMultipleResolve2Num());
                r3.setMultipleResolve3Num(r1.getMultipleResolve3Num());
                r3.setMultipleResolve4Num(r1.getMultipleResolve4Num());
                r3.setMultipleResolve5Num(r1.getMultipleResolve5Num());
                r3.setMultipleResolve6Num(r1.getMultipleResolve6Num());
                r3.setMultipleResolve7Num(r1.getMultipleResolve7Num());
                r3.setMultipleResolve8Num(r1.getMultipleResolve8Num());
            } else {
                r3.setRegionName(r1.getRegionName() + r2.getRegionName());
                r3.setResolveComNum(Long.valueOf(r1.getResolveComNum() + r2.getResolveComNum()));
                r3.setSingleResolvePxNum(Long.valueOf(r1.getSingleResolvePxNum() + r2.getSingleResolvePxNum()));
                r3.setSingleResolveTjNum(Long.valueOf(r1.getSingleResolveTjNum() + r2.getSingleResolveTjNum()));
                r3.setMultipleResolve2Num(Long.valueOf(r1.getMultipleResolve2Num() + r2.getMultipleResolve2Num()));
                r3.setMultipleResolve3Num(Long.valueOf(r1.getMultipleResolve3Num() + r2.getMultipleResolve3Num()));
                r3.setMultipleResolve4Num(Long.valueOf(r1.getMultipleResolve4Num() + r2.getMultipleResolve4Num()));
                r3.setMultipleResolve5Num(Long.valueOf(r1.getMultipleResolve5Num() + r2.getMultipleResolve5Num()));
                r3.setMultipleResolve6Num(Long.valueOf(r1.getMultipleResolve6Num() + r2.getMultipleResolve6Num()));
                r3.setMultipleResolve7Num(Long.valueOf(r1.getMultipleResolve7Num() + r2.getMultipleResolve7Num()));
                r3.setMultipleResolve8Num(Long.valueOf(r1.getMultipleResolve8Num() + r2.getMultipleResolve8Num()));
            }
            return r3;
        }).collect(Collectors.toList());
    }

    public List<RegionHistoryPunishInfo> getHistoryPunishInfo(RegionHistoryPunishInfo param) {
        String yearParams = param.getYearParams();
        Long regionId = param.getAreaId();
        if (StrUtil.isBlank((CharSequence)yearParams)) {
            return Collections.emptyList();
        }
        List yearList = Arrays.stream(yearParams.split(",")).filter(s -> !StrUtil.isBlank((CharSequence)s)).distinct().map(Convert::toInt).collect(Collectors.toList());
        ArrayList<RegionHistoryPunishInfo> historyList = new ArrayList<RegionHistoryPunishInfo>();
        for (Integer year : yearList) {
            RiskResolveResSearch searchParam = new RiskResolveResSearch().setAreaId(regionId).setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setPage(Integer.valueOf(1)).setLimit(Integer.valueOf(10));
            RegionHistoryPunishInfo history = new RegionHistoryPunishInfo().setYear(year);
            if (year == 2024) {
                history.setClosingDate("2024-12-31").setFreePunishAmount("6.00 \u4ebf\u5143");
            }
            if (year == 202501) {
                history.setClosingDate("2025-06-30").setFreePunishAmount("2.37 \u4ebf\u5143");
            }
            historyList.add(history);
        }
        return historyList;
    }

    private String calcFreePunishAmount(RiskResolveResSearch searchParam) {
        int currentYear = LocalDate.now().getYear();
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Boolean isCurrent = searchParam.getIsCurrent();
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId}));
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        String helpCacheKey = String.format("%s:%s", HOME_INDEX_CACHE_KEY, this.generateCacheKey(year == null ? currentYear : year, regionId, regionLevel, isCurrent, isFcImportanceCompany == null ? 0 : isFcImportanceCompany, isExistRadioactivity, startDate == null ? null : DateUtil.format((Date)startDate, (String)"yyyyMMdd"), endDate == null ? null : DateUtil.format((Date)endDate, (String)"yyyyMMdd")));
        if (this.redisClient.hasKey(helpCacheKey)) {
            return ((HomeHelpCompanyVo)this.redisClient.get(helpCacheKey)).getFreePunishAmount();
        }
        Long num = year == null ? this.getCurrentAndPreHalfResolveNum(searchParam, currentYear) : this.getCustomYearResolveNum(searchParam, year);
        return SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
    }

    public Pair<Long, String> calcFreePunishAmount2(RiskResolveResSearch searchParam) {
        int currentYear = LocalDate.now().getYear();
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Boolean isCurrent = searchParam.getIsCurrent();
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId}));
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        String helpCacheKey = String.format("%s:%s", HOME_INDEX_CACHE_KEY, this.generateCacheKey(year == null ? currentYear : year, regionId, regionLevel, isCurrent, isFcImportanceCompany == null ? 0 : isFcImportanceCompany, isExistRadioactivity, startDate == null ? null : DateUtil.format((Date)startDate, (String)"yyyyMMdd"), endDate == null ? null : DateUtil.format((Date)endDate, (String)"yyyyMMdd")));
        if (this.redisClient.hasKey(helpCacheKey)) {
            // empty if block
        }
        if (year == null || year == 202501) {
            searchParam.setYear(Integer.valueOf(202501));
            this.handleQueryDateRange(searchParam);
            List<RegionRiskNumInfoVo> riskTotalList1 = this.getRegionRiskInfoAllList(searchParam);
            long totalNum1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getResolveComNum).reduce(0L, Long::sum);
            long singleResolvePxNum1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getSingleResolvePxNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long singleResolveTjNum1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getSingleResolveTjNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve2Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve2Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve3Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve3Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve4Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve4Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve5Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve5Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve6Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve6Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve7Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve7Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve8Num1 = riskTotalList1.stream().map(RegionRiskNumInfoVo::getMultipleResolve8Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            BigDecimal amount1 = Convert.toBigDecimal((Object)singleResolvePxNum1).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_1).add(Convert.toBigDecimal((Object)singleResolveTjNum1).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve2Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve3Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_3)).add(Convert.toBigDecimal((Object)multipleResolve4Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_4)).add(Convert.toBigDecimal((Object)multipleResolve5Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_5)).add(Convert.toBigDecimal((Object)multipleResolve6Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_6)).add(Convert.toBigDecimal((Object)multipleResolve7Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_7)).add(Convert.toBigDecimal((Object)multipleResolve8Num1).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_8)).setScale(4, RoundingMode.HALF_UP);
            if (Objects.equals(year, 202501)) {
                return new Pair((Object)totalNum1, (Object)SysConvertTool.convertUnit((BigDecimal)amount1.setScale(2, RoundingMode.HALF_UP)));
            }
            searchParam.setYear(null);
            this.handleQueryDateRange(searchParam);
            List<RegionRiskNumInfoVo> riskTotalList2 = this.getRegionRiskInfoAllList(searchParam);
            long totalNum2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getResolveComNum).reduce(0L, Long::sum);
            long singleResolvePxNum2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getSingleResolvePxNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long singleResolveTjNum2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getSingleResolveTjNum).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve2Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve2Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve3Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve3Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve4Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve4Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve5Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve5Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve6Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve6Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve7Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve7Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            long multipleResolve8Num2 = riskTotalList2.stream().map(RegionRiskNumInfoVo::getMultipleResolve8Num).map(Optional::ofNullable).map(o -> o.orElse(0L)).reduce(0L, Long::sum);
            BigDecimal amount2 = Convert.toBigDecimal((Object)singleResolvePxNum2).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_1).add(Convert.toBigDecimal((Object)singleResolveTjNum2).multiply(RiskCalculator.SINGLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve2Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_2)).add(Convert.toBigDecimal((Object)multipleResolve3Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_3)).add(Convert.toBigDecimal((Object)multipleResolve4Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_4)).add(Convert.toBigDecimal((Object)multipleResolve5Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_5)).add(Convert.toBigDecimal((Object)multipleResolve6Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_6)).add(Convert.toBigDecimal((Object)multipleResolve7Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_7)).add(Convert.toBigDecimal((Object)multipleResolve8Num2).multiply(RiskCalculator.MULTIPLE_RISK_COEFFICIENT_8)).setScale(4, RoundingMode.HALF_UP);
            long num = totalNum1 + totalNum2;
            String amount = SysConvertTool.convertUnit((BigDecimal)amount1.add(amount2).setScale(2, RoundingMode.HALF_UP));
            return new Pair((Object)num, (Object)amount);
        }
        long num = this.getCustomYearResolveNum(searchParam, year);
        String amount = SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        return new Pair((Object)num, (Object)amount);
    }

    private Long getCustomYearResolveNum(RiskResolveResSearch searchParam, Integer year) {
        Long num;
        if (year == 2024) {
            Long num01 = this.getRegionResolveComNumByCache(searchParam.setYear(Integer.valueOf(202401)));
            Long num02 = this.getRegionResolveComNumByCache(searchParam.setYear(Integer.valueOf(202402)));
            num = num01 + num02;
        } else {
            num = this.getRegionResolveComNumByCache(searchParam.setYear(year));
        }
        return num;
    }

    public Long getCurrentAndPreHalfResolveNum(RiskResolveResSearch searchParam, int currentYear) {
        Long currNum = this.getRegionResolveComNumByCache(searchParam.setYear(null));
        int historyYear = Convert.toInt((Object)(currentYear + "01"));
        if (historyYear <= 202401 && Objects.equals(searchParam.getIsFcImportanceCompany(), 1)) {
            return currNum;
        }
        searchParam.setIsFcImportanceCompany(historyYear > 202401 && Objects.equals(searchParam.getIsFcImportanceCompany(), 1) ? Integer.valueOf(1) : null);
        return currNum + this.getRegionResolveComNumByCache(searchParam.setYear(Integer.valueOf(historyYear)));
    }

    public static <T extends Serializable> List<T> deepCopy(List<T> list) {
        return (List)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)list))));
    }

    public Long getRegionResolveComNumByCache(RiskResolveResSearch searchParam) {
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Integer page = searchParam.getPage();
        Integer rows = searchParam.getLimit();
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        if (year == null) {
            Long resolveNum = this.getRegionResolveComNum(searchParam);
            return resolveNum == null ? 0L : resolveNum;
        }
        String cacheKey = String.format("%s:%s", HELP_COMPANY_HISTORY_CACHE_KEY, this.generateCacheKey(year, regionId, isFcImportanceCompany == null ? 0 : isFcImportanceCompany, isExistRadioactivity, page, rows, startDate == null ? null : DateUtil.format((Date)startDate, (String)"yyyyMMdd"), endDate == null ? null : DateUtil.format((Date)endDate, (String)"yyyyMMdd")));
        if (this.redisClient.hasKey(cacheKey)) {
            return (Long)this.redisClient.get(cacheKey);
        }
        Long resolveNum = this.getRegionResolveComNum(searchParam);
        this.redisClient.set(cacheKey, (Object)resolveNum, 7200L);
        return resolveNum == null ? 0L : resolveNum;
    }

    public Long getRegionResolveComNum(RiskResolveResSearch searchParam) {
        Long regionId = searchParam.getAreaId();
        List regionIdList = searchParam.getRegionIdList();
        if (CollUtil.isEmpty((Collection)regionIdList)) {
            return 0L;
        }
        Integer year = searchParam.getYear();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        if (year != null && year <= 202401 && Objects.equals(isFcImportanceCompany, 1)) {
            return 0L;
        }
        searchParam.setIsFcImportanceCompany((year == null || year > 202401) && Objects.equals(isFcImportanceCompany, 1) ? Integer.valueOf(1) : null);
        this.handleQueryDateRange(searchParam);
        List<RegionRiskNumInfoVo> resolveComNumList = this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam);
        if (CollUtil.isEmpty(resolveComNumList)) {
            return 0L;
        }
        return resolveComNumList.get(0).getResolveComNum();
    }

    public RegionRiskNumInfoVo getRegionResolveComNums(RiskResolveResSearch searchParam) {
        RegionRiskNumInfoVo regionRisk = new RegionRiskNumInfoVo();
        Long regionId = searchParam.getAreaId();
        List regionIdList = searchParam.getRegionIdList();
        if (CollUtil.isEmpty((Collection)regionIdList)) {
            return null;
        }
        Integer year = searchParam.getYear();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        if (year != null && year <= 202401 && Objects.equals(isFcImportanceCompany, 1)) {
            return null;
        }
        searchParam.setIsFcImportanceCompany((year == null || year > 202401) && Objects.equals(isFcImportanceCompany, 1) ? Integer.valueOf(1) : null);
        this.handleQueryDateRange(searchParam);
        List<RegionRiskNumInfoVo> resolveComNumList = this.riskCompleteMapper.getResolveComNumByRegionIdList(searchParam);
        if (CollUtil.isEmpty(resolveComNumList)) {
            return null;
        }
        return resolveComNumList.get(0);
    }

    public Long getRegionNoPushComNum(RiskResolveResSearch searchParam) {
        if (searchParam == null || CollUtil.isEmpty((Collection)searchParam.getRegionIdList())) {
            return 0L;
        }
        List<RegionRiskNumInfoVo> noPushComNumList = this.riskCompleteMapper.getNoPushComNumByRegionIdList(searchParam);
        if (CollUtil.isEmpty(noPushComNumList)) {
            return 0L;
        }
        return noPushComNumList.get(0).getNoPushComNum();
    }

    private void setIsCurrent(RiskResolveResSearch searchVo) {
        if (searchVo.getCompanyLevel() != null) {
            if (searchVo.getCompanyLevel().equals(1)) {
                searchVo.setIsCurrent(Boolean.valueOf(true));
                if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                    searchVo.setCompanyLevel(Integer.valueOf(searchVo.getAreaLevel().intValue()));
                } else {
                    searchVo.setCompanyLevel(Integer.valueOf(0));
                }
            } else if (searchVo.getCompanyLevel().equals(2)) {
                searchVo.setIsCurrent(Boolean.valueOf(false));
                if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                    searchVo.setCompanyLevel(Integer.valueOf(searchVo.getAreaLevel().intValue()));
                } else {
                    searchVo.setCompanyLevel(Integer.valueOf(0));
                }
            }
        } else {
            searchVo.setIsCurrent(null);
        }
    }

    private RiskResolveResInfoVo getByItemId(Long itemId, List<RiskResolveResInfoVo> riskInfoList) {
        if (CollectionUtils.isEmpty(riskInfoList)) {
            return null;
        }
        return riskInfoList.stream().filter(item -> item.getId().equals(itemId)).findFirst().orElse(null);
    }

    public Integer getReformRiskResolveResListCount(RiskResolveResSearch searchVo) {
        String riskTypeStr = searchVo.getRiskTypeStr();
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)searchVo.getScales())) {
            searchVo.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchVo.getScales(), (String)","));
        }
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)riskTypeStr)) {
            List collect = Arrays.stream(riskTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
            ArrayList<Integer> riskTypeChildList = new ArrayList<Integer>();
            if (riskTypeStr.contains("211")) {
                riskTypeChildList.add(1);
                collect.add(21);
            }
            if (riskTypeStr.contains("212")) {
                riskTypeChildList.add(2);
                collect.add(21);
            }
            searchVo.setRiskChildTypeStrList(riskTypeChildList);
            searchVo.setRiskTypeStrList(collect);
        }
        this.setIsCurrent(searchVo);
        return ((ReformItemBasicMapper)this.dao).getRiskResolveListCount(searchVo);
    }

    public RiskResolveResInfoVo getReformRiskDetailVoById(Long id) {
        List acceptanceList;
        CompanySuperviseModel companyInfoById;
        RiskResolveResInfoVo result = new RiskResolveResInfoVo();
        ReformItemBasic reformItemBasic = this.getById(id);
        if (reformItemBasic == null) {
            return result;
        }
        BeanUtils.copyProperties((Object)reformItemBasic, (Object)result);
        result.setName(reformItemBasic.getName());
        result.setStatus(reformItemBasic.getStatus());
        result.setFindTime(reformItemBasic.getFindTime());
        result.setFinderName(reformItemBasic.getFinderName());
        result.setGenerationSource(reformItemBasic.getGenerationSource());
        result.setReformItemSource(reformItemBasic.getReformItemSource());
        result.setReformItemSourceId(reformItemBasic.getReformItemSourceId());
        result.setDescription(reformItemBasic.getDescription());
        if (reformItemBasic.getCid() != null) {
            CompanyBaseInfoModel companyInfoVo = this.companyProvideByHSEService.getCompanyById(reformItemBasic.getCid());
            result.setCid(companyInfoVo.getId());
            result.setCompanyName(companyInfoVo.getName());
            result.setRegisterAddress(companyInfoVo.getAreaDetailName());
            result.setOccManagerName(companyInfoVo.getOccManagerName());
            result.setOccManagerTel(companyInfoVo.getOccManagerTel());
            result.setMainLeaderName(companyInfoVo.getMainLeaderName());
            result.setMainLeaderTel(companyInfoVo.getMainLeaderTel());
        }
        if ((companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(reformItemBasic.getCid())).getBelongType() != null) {
            result.setCompanyLevel(companyInfoById.getBelongType());
        }
        if (CollectionUtils.isNotEmpty((Collection)(acceptanceList = reformItemBasic.getAceptanceList()))) {
            for (ReformItemAcceptanceRecord record : acceptanceList) {
                List files;
                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)record.getReformFinishedFiles())) {
                    files = this.fileService.getListByIds(record.getReformFinishedFiles());
                    record.setReformFinishedFilesList(files);
                }
                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)record.getAcceptanceFiles())) {
                    files = this.fileService.getListByIds(record.getAcceptanceFiles());
                    record.setAcceptanceFilesList(files);
                }
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)record.getReformProgrammeFiles())) continue;
                files = this.fileService.getListByIds(record.getReformProgrammeFiles());
                record.setReformSolutionFilesList(files);
            }
        }
        result.setReformItemAcceptanceRecordList(acceptanceList);
        if (Objects.equals(reformItemBasic.getGenerationSource(), ReformGenerationSourceEnum.ARCHIVES.getValue())) {
            ZjArchiveCountView view = null;
            try {
                int findYear = DateUtils.getYear((Date)reformItemBasic.getFindTime());
                view = (ZjArchiveCountView)this.liteArchiveService.getArchiveData(reformItemBasic.getCid()).get(findYear);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.setArchiveCountView(view);
        }
        List<Byte> reformStatusList = Arrays.asList((byte)3, (byte)4, (byte)10);
        if (Objects.equals(reformItemBasic.getGenerationSource(), ReformGenerationSourceEnum.THREE_TIME.getValue()) && reformItemBasic.getStatus() != null && !reformStatusList.contains(reformItemBasic.getStatus())) {
            SearchParam param = new SearchParam();
            param.setCid(reformItemBasic.getCid());
            param.setFinish(Boolean.valueOf(false));
            param.setClosed(Boolean.valueOf(false));
            param.setStatusList(Arrays.asList(TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode(), TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode(), TsProjectSimpleStatusEnum.BACK.getCode()));
            List list = this.threeTimeService.list(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List collectDRAFT = list.stream().filter(item -> item != null && item.getStatus() != null && (TsProjectSimpleStatusEnum.DRAFT.getCode().equals(item.getStatus()) || TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode().equals(item.getStatus()))).collect(Collectors.toList());
                result.setThreeTimeCg(Integer.valueOf(collectDRAFT.size()));
                List collectAUDIT = list.stream().filter(item -> item != null && item.getStatus() != null && TsProjectSimpleStatusEnum.AUDIT.getCode().equals(item.getStatus())).collect(Collectors.toList());
                result.setThreeTimeDys(Integer.valueOf(collectAUDIT.size()));
                List collectBACK = list.stream().filter(item -> item != null && item.getStatus() != null && TsProjectSimpleStatusEnum.BACK.getCode().equals(item.getStatus())).collect(Collectors.toList());
                result.setThreeTimeBack(Integer.valueOf(collectBACK.size()));
            }
        }
        if (result.getGenerationSource().equals(ReformGenerationSourceEnum.JCCB.getValue()) && CollectionUtils.isNotEmpty((Collection)result.getReformItemAcceptanceRecordList())) {
            List accIdList = result.getReformItemAcceptanceRecordList().stream().map(ReformItemAcceptanceRecord::getId).collect(Collectors.toList());
            List accOldIdList = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(true)).setAcceptRecordIds(accIdList)).stream().filter(Objects::nonNull).map(ReformCheckMeasure::getAcceptRecordId).distinct().collect(Collectors.toList());
            for (ReformItemAcceptanceRecord record : result.getReformItemAcceptanceRecordList()) {
                record.setCheckMeasureIsOld(Boolean.valueOf(accOldIdList.contains(record.getId())));
            }
        }
        String tipsTime = this.companyRiskProspectService.getTipsTime(reformItemBasic.getCid(), reformItemBasic.getGenerationSource());
        result.setTipsTime(tipsTime);
        String acceptanceDirectorName = result.getAcceptanceDirectorName();
        result.getReformItemAcceptanceRecordList().forEach(s -> {
            if (s.getAcceptanceDirectorName() != null && s.getAcceptanceDirectorName().equals("\u81ea\u52a8\u9a8c\u6536")) {
                s.setAutoAcceptance(true);
                s.setAutoAcceptanceDirectorName("\u81ea\u52a8\u9a8c\u6536");
            }
        });
        return result;
    }

    public ReformWarningStatistics getWarningComNum(RiskListSearch search) {
        return ((ReformItemBasicMapper)this.dao).getWarningComNum(search);
    }

    public List<ReformItemBasic> obtainCompanyRiskInfoByCid(Long cid) {
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        return ((ReformItemBasicMapper)this.dao).getRiskListUnfinishedData(search, null);
    }

    public LayUiResponseResult<ThreeTimesInfo> getThreeTimesInfo(SearchParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        if (param.getIsCurrent() != null || param.getOnlyThisLevel() != null && param.getOnlyThisLevel().booleanValue()) {
            Byte level = param.getLevel();
            byte companyLevel = 0;
            if (1 == level) {
                companyLevel = 1;
            }
            if (2 == level) {
                companyLevel = 2;
            }
            param.setCompanyLevel(Byte.valueOf(companyLevel));
        }
        List<ThreeTimesInfo> list = ((ReformItemBasicMapper)this.dao).getThreeTimesInfo(param);
        PageInfo pageInfo = new PageInfo(list);
        return LayUiResponseResult.success((PageInfo)pageInfo);
    }

    @Transactional(readOnly=false)
    public void changeStatusByCidAndGenerationSource(Long cid, Byte generationSource, Byte status, Long loginStaffId, Long businessId) {
        this.itemBasicNewService.changeStatusByCidAndGenerationSource(cid, generationSource, status, loginStaffId, businessId);
    }

    public void changeStatusDivide(List<ReformItemBasic> notAcceptReformList, Byte generationSource, Long cid, Integer year, Long loginStaffId) {
        if (CollectionUtils.isEmpty(notAcceptReformList)) {
            return;
        }
        String effectiveDateStr = "2024-06-01 00:00:00";
        if (year == 2023) {
            effectiveDateStr = "2023-10-01 00:00:00";
        }
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case TRAIN: 
            case NOZYFZR: {
                boolean match;
                Byte status = this.getTrainReformChangeStatus(cid, 12, effectiveDateStr);
                List<ReformItemBasic> collect1819 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOZYFZR.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform2(collect1819, status, loginStaffId, generationSource);
                if (year != 2023 || !(match = notAcceptReformList.stream().allMatch(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue()))) || status != 3) break;
                String businessName = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                this.generationReformForTrain(ReformGenerationSourceEnum.NOGLRY, null, businessName, null, null, DateUtils.parseDate((Object)"2023-07-01 00:00:00"), cid, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, null);
                break;
            }
            case NOGLRY: {
                boolean match;
                Byte status = this.getTrainReformChangeStatus(cid, 13, effectiveDateStr);
                List<ReformItemBasic> collect1820 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOGLRY.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform2(collect1820, status, loginStaffId, generationSource);
                if (year != 2023 || !(match = notAcceptReformList.stream().allMatch(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue()))) || status != 3) break;
                String businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                this.generationReformForTrain(ReformGenerationSourceEnum.NOZYFZR, null, businessName, null, null, DateUtils.parseDate((Object)"2023-07-01 00:00:00"), cid, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, null);
                break;
            }
            case THREE_TIME: {
                Byte status = this.getThreeTimeReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform2(notAcceptReformList, status, loginStaffId, generationSource);
                break;
            }
            case PROTECTION: {
                Byte status = this.getProtectReformChangeStatus(cid, year);
                this.makeAndUpdateReform2(notAcceptReformList, status, loginStaffId, generationSource);
                break;
            }
            case WARNING_SIGNS: {
                Byte status = this.getWarnSignReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform2(notAcceptReformList, status, loginStaffId, generationSource);
                break;
            }
            case ARCHIVES: {
                List<Long> zjArchiveCountViewByCid = this.getZjArchiveCountViewByCid(Collections.singletonList(cid), year);
                if (!CollectionUtils.isNotEmpty(zjArchiveCountViewByCid)) break;
                this.makeAndUpdateReform2(notAcceptReformList, (byte)3, loginStaffId, generationSource);
                break;
            }
        }
    }

    private Byte getThreeTimeReformChangeStatus(Long cid, String effectiveDateStr) {
        List<TsProjectSimple> projectSimpleList = ((ReformItemBasicMapper)this.dao).getAllThreeTimeDate(Collections.singletonList(cid), effectiveDateStr);
        if (CollectionUtils.isEmpty(projectSimpleList)) {
            return (byte)-1;
        }
        boolean isBack = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.BACK.getCode()));
        if (isBack) {
            return ReformStatusEnum.TH.getValue();
        }
        boolean isAUDIT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.AUDIT.getCode()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        boolean isDRAFT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.DRAFT.getCode()));
        if (isDRAFT) {
            return ReformStatusEnum.CG.getValue();
        }
        return ReformStatusEnum.WC.getValue();
    }

    private Byte getTrainReformChangeStatus(Long cid, Integer type, String effectiveDateStr) {
        List<CertificateStaffDetail> list = ((ReformItemBasicMapper)this.dao).getTrainList(Collections.singletonList(cid), type);
        if (CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> {
            if (item.getStatus() == null || item.getStatus().equals(ApprovalStatusEnum.PASSED.getValue()) || item.getStatus().equals(ApprovalStatusEnum.NONEEDAPPROVAL.getValue())) {
                return item.getValidityDate() != null && item.getValidityDate().getTime() >= DateUtils.parseDate((Object)effectiveDateStr).getTime();
            }
            return false;
        });
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getStatus() != null && item.getStatus().equals(ApprovalStatusEnum.WAITAPPROVAL.getValue()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getProtectReformChangeStatus(Long cid, Integer year) {
        List<ProtectEquipIssueRecord> allProtectEquip = ((ReformItemBasicMapper)this.dao).getAllProtectEquip(Collections.singletonList(cid), year);
        if (CollectionUtils.isEmpty(allProtectEquip)) {
            return (byte)-1;
        }
        boolean isFinish = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)));
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getWarnSignReformChangeStatus(Long cid, String effectiveDateStr) {
        List<WarnSignManage> list = ((ReformItemBasicMapper)this.dao).getAllWarnSign(Collections.singletonList(cid));
        if (CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)) && item.getChangeTime() != null && DateUtils.addYear((Date)item.getChangeTime(), (int)3).getTime() >= DateUtils.parseDate((Object)effectiveDateStr).getTime());
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    public Integer getUnReformNumByCid(Long cid, ReformGenerationSourceEnum sourceEnum) {
        return ((ReformItemBasicMapper)this.dao).getUnReformNumByCid(cid, sourceEnum.getValue());
    }

    public List<ReformItemBasic> getArchiveData(Long cid, ReformGenerationSourceEnum sourceEnum) {
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("generationSource", (Object)sourceEnum.getValue()).andEqualTo("isValid", (Object)true);
        return ((ReformItemBasicMapper)this.dao).selectByExample(example);
    }

    public List<Byte> getGenerationSourceValue() {
        List<Byte> lsit = Arrays.asList(ReformGenerationSourceEnum.TJ.getValue(), ReformGenerationSourceEnum.DECLARE.getValue(), ReformGenerationSourceEnum.THREE_TIME.getValue(), ReformGenerationSourceEnum.DETECTION.getValue(), ReformGenerationSourceEnum.PROTECTION.getValue(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.ARCHIVES.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue());
        return new ArrayList<Byte>(lsit);
    }

    private List<Byte> getTjGenerationSourceValue() {
        List<Byte> list = Arrays.asList(ReformGenerationSourceEnum.YSZYB.getValue(), ReformGenerationSourceEnum.ZYB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.FC.getValue());
        return new ArrayList<Byte>(list);
    }

    public List<KeyFactoryStateVo> getKeyFactorPortraitDataList(Long cid) {
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        List<ReformItemBasic> reformList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, null);
        if (CollUtil.isEmpty(reformList)) {
            return DEFAULT_KEY_FACTOR_STATE_LIST;
        }
        Map<Byte, String> riskMap = this.postConvertReformToRiskMap(reformList, cid);
        ArrayList<KeyFactoryStateVo> keyList = new ArrayList<KeyFactoryStateVo>();
        for (Map.Entry<Byte, String> entry : riskMap.entrySet()) {
            ReformGenerationSourceEnum source = ReformGenerationSourceEnum.getByType((Byte)entry.getKey());
            String status = entry.getValue();
            if (source == null) continue;
            switch (source) {
                case DECLARE: {
                    keyList.add(new KeyFactoryStateVo("declare", "\u7533\u62a5", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case DETECTION: {
                    keyList.add(new KeyFactoryStateVo("detection", "\u68c0\u6d4b", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case TJ: {
                    keyList.add(new KeyFactoryStateVo("physicalExamination", "\u4f53\u68c0", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case TRAIN: {
                    keyList.add(new KeyFactoryStateVo("training", "\u8d1f\u8d23\u4eba\u57f9\u8bad", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case THREE_TIME: {
                    keyList.add(new KeyFactoryStateVo("trisimultaneity", "\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case PROTECTION: {
                    keyList.add(new KeyFactoryStateVo("protection", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case WARNING_SIGNS: {
                    keyList.add(new KeyFactoryStateVo("warningMark", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case ARCHIVES: {
                    keyList.add(new KeyFactoryStateVo("archive", "\u804c\u4e1a\u536b\u751f\u6863\u6848", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
            }
        }
        return keyList;
    }

    public List<KeyFactoryStateVo> getKeyFactorPortraitDataListNew(Long cid) {
        List riskTypeList = this.riskCompletionService.selectRiskTypeListData((List)CollUtil.toList((Object[])new Long[]{cid}), Boolean.FALSE.booleanValue());
        ArrayList<KeyFactoryStateVo> keyList = new ArrayList<KeyFactoryStateVo>();
        for (RiskTypeVo riskType : riskTypeList) {
            ReformGenerationSourceEnum source = riskType.getGenerationSource();
            if (source == null) continue;
            String status = riskType.getRiskTypeStatus();
            switch (source) {
                case DECLARE: {
                    keyList.add(new KeyFactoryStateVo("declare", "\u7533\u62a5", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case DETECTION: {
                    keyList.add(new KeyFactoryStateVo("detection", "\u68c0\u6d4b", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case TJ: {
                    keyList.add(new KeyFactoryStateVo("physicalExamination", "\u4f53\u68c0", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case TRAIN: {
                    keyList.add(new KeyFactoryStateVo("training", "\u8d1f\u8d23\u4eba\u57f9\u8bad", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case THREE_TIME: {
                    keyList.add(new KeyFactoryStateVo("trisimultaneity", "\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case PROTECTION: {
                    keyList.add(new KeyFactoryStateVo("protection", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case WARNING_SIGNS: {
                    keyList.add(new KeyFactoryStateVo("warningMark", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case ARCHIVES: {
                    keyList.add(new KeyFactoryStateVo("archive", "\u804c\u4e1a\u536b\u751f\u6863\u6848", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
                case GRJL: {
                    keyList.add(new KeyFactoryStateVo("grjl", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b", !status.contains("\u672a\u5316\u89e3") ? "\u65e0\u98ce\u9669" : "\u6709\u98ce\u9669"));
                    break;
                }
            }
        }
        return keyList;
    }

    public ThreeTimeDetailVo getThreeTimeProjDetails(Long cid) {
        if (cid == null) {
            return null;
        }
        return this.reformItemBasicMapper.getThreeTimeProjDetails(cid);
    }

    public List<HealthManagementArchiveVo> getHealthManagementArchivesData(Long cid) {
        Map archiveMap = this.liteArchiveService.getArchiveData(cid);
        TreeMap sortedMap = new TreeMap(archiveMap);
        ZjArchiveCountView prevArchive = (ZjArchiveCountView)sortedMap.firstEntry().getValue();
        ZjArchiveCountView currArchive = (ZjArchiveCountView)sortedMap.lastEntry().getValue();
        HealthManagementArchiveVo thirdArchive = new HealthManagementArchiveVo("threeTime_archive", "\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848", prevArchive.getThirdStateStr(), currArchive.getThirdStateStr());
        HealthManagementArchiveVo hseManageArchive = new HealthManagementArchiveVo("healthManagement_archive", "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848", prevArchive.getHseManageStateStr(), currArchive.getHseManageStateStr());
        HealthManagementArchiveVo trainArchive = new HealthManagementArchiveVo("healthTraining_archive", "\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848", prevArchive.getTrainStateStr(), currArchive.getTrainStateStr());
        HealthManagementArchiveVo checkArchive = new HealthManagementArchiveVo("monitorAndDetection_archive", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848", prevArchive.getCheckStateStr(), currArchive.getCheckStateStr());
        HealthManagementArchiveVo physicalArchive = new HealthManagementArchiveVo("guardianshipManagement_archive", "\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848", currArchive.getPhysicalStateStr(), currArchive.getPhysicalStateStr());
        HealthManagementArchiveVo staffArchive = new HealthManagementArchiveVo("personalHealth_archive", "\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848", prevArchive.getStaffStateStr(), currArchive.getStaffStateStr());
        ArrayList<HealthManagementArchiveVo> archiveList = new ArrayList<HealthManagementArchiveVo>();
        archiveList.add(thirdArchive);
        archiveList.add(hseManageArchive);
        archiveList.add(trainArchive);
        archiveList.add(checkArchive);
        archiveList.add(physicalArchive);
        archiveList.add(staffArchive);
        return archiveList;
    }

    public List<RiskLevelVo> getRiskLevelListData(Long cid) {
        int currentYear = LocalDate.now().getYear();
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        search.setPushDate("2025\u5e74");
        List<ReformItemBasic> reformList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, 6);
        return ReformItemBasicServiceImpl.getRiskLevelListNew(reformList);
    }

    @Deprecated
    private List<RiskLevelVo> getRiskLevelListOld(List<ReformItemBasic> reformList, int currentYear) {
        if (CollUtil.isEmpty(reformList = this.postApplyFilterCondition(reformList, currentYear))) {
            return DEFAULT_WARNING_STATE_LIST;
        }
        List<RiskLevelVo> levelList = this.postConvertReformToRiskLevelList(reformList);
        return Stream.of("firstAlert", "yellowAlert", "redAlert", "executeLaw").map(code -> levelList.stream().filter(r -> code.equals(r.getRiskLevelCode())).findFirst().orElseThrow(() -> new IllegalStateException("Missing risk level: " + code))).collect(Collectors.toList());
    }

    private static List<RiskLevelVo> getRiskLevelListNew(List<ReformItemBasic> reformList) {
        if (CollUtil.isEmpty(reformList)) {
            return DEFAULT_WARNING_STATE_LIST;
        }
        Predicate<ReformItemBasic> isValidStatus = r -> !ReformStatusEnum.WC.getValue().equals(r.getStatus()) && !ReformStatusEnum.WXZG.getValue().equals(r.getStatus());
        reformList = reformList.stream().filter(isValidStatus).collect(Collectors.toList());
        long firstAlertCount = 0L;
        long yellowAlertCount = 0L;
        long redAlertCount = 0L;
        long executeLawCount = 0L;
        for (ReformItemBasic reformItemBasic : reformList) {
            if (reformItemBasic.getWarningState() == null) continue;
            switch (reformItemBasic.getWarningState()) {
                case 1: {
                    ++firstAlertCount;
                    break;
                }
                case 2: {
                    ++yellowAlertCount;
                    break;
                }
                case 3: {
                    ++redAlertCount;
                    break;
                }
                case 4: {
                    ++executeLawCount;
                    break;
                }
            }
        }
        return List.of(new RiskLevelVo("firstAlert", "\u9996\u6b21\u9884\u8b66", Long.valueOf(firstAlertCount)), new RiskLevelVo("yellowAlert", "\u9ec4\u8272\u9884\u8b66", Long.valueOf(yellowAlertCount)), new RiskLevelVo("redAlert", "\u7ea2\u8272\u9884\u8b66", Long.valueOf(redAlertCount)), new RiskLevelVo("executeLaw", "\u542f\u52a8\u6267\u6cd5", Long.valueOf(executeLawCount)));
    }

    public List<RiskTypeVo> getRiskTypeListData(Long cid) {
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        List<ReformItemBasic> reformList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, null);
        if (CollUtil.isEmpty(reformList)) {
            return DEFAULT_RISK_TYPE_STATE_LIST;
        }
        Map<Byte, String> riskMap = this.postConvertReformToRiskMap(reformList, cid);
        return Stream.of(new RiskTypeVo("declare_riskType", "\u7533\u62a5", riskMap.get(ReformGenerationSourceEnum.DECLARE.getValue())), new RiskTypeVo("detection_riskType", "\u68c0\u6d4b", riskMap.get(ReformGenerationSourceEnum.DETECTION.getValue())), new RiskTypeVo("physicalExamination_riskType", "\u4f53\u68c0", riskMap.get(ReformGenerationSourceEnum.TJ.getValue())), new RiskTypeVo("training_riskType", "\u8d1f\u8d23\u4eba\u57f9\u8bad", riskMap.get(ReformGenerationSourceEnum.TRAIN.getValue())), new RiskTypeVo("threeTime_riskType", "\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", riskMap.get(ReformGenerationSourceEnum.THREE_TIME.getValue())), new RiskTypeVo("protective_riskType", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", riskMap.get(ReformGenerationSourceEnum.PROTECTION.getValue())), new RiskTypeVo("warningMark_riskType", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", riskMap.get(ReformGenerationSourceEnum.WARNING_SIGNS.getValue())), new RiskTypeVo("suspected_occ_disease", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u7591\u4f3c\u804c\u4e1a\u75c5", riskMap.get(ReformGenerationSourceEnum.YSZYB.getValue())), new RiskTypeVo("occ_contraindications", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u804c\u4e1a\u7981\u5fcc\u8bc1", riskMap.get(ReformGenerationSourceEnum.JJZ.getValue())), new RiskTypeVo("jccbzg_riskType", "\u76d1\u6d4b\u7ed3\u679c\u8d85\u6807\u6574\u6539", riskMap.get(ReformGenerationSourceEnum.JCCBZG.getValue())), new RiskTypeVo("jccb_riskType", "\u68c0\u6d4b\u7ed3\u679c\u8d85\u6807", riskMap.get(ReformGenerationSourceEnum.JCCB.getValue())), new RiskTypeVo("healthArchive_riskType", "\u804c\u4e1a\u536b\u751f\u6863\u6848", riskMap.get(ReformGenerationSourceEnum.ARCHIVES.getValue())), new RiskTypeVo("grjl_riskType", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b", riskMap.get(ReformGenerationSourceEnum.GRJL.getValue()))).collect(Collectors.toList());
    }

    public List<RiskTypeVo> getRiskTypeListDataNew(Long cid) {
        List riskTypeList = this.riskCompletionService.selectRiskTypeListData((List)CollUtil.toList((Object[])new Long[]{cid}), Boolean.FALSE.booleanValue());
        Map<Byte, String> riskMap = riskTypeList.stream().collect(Collectors.toMap(r -> r.getGenerationSource().getValue(), RiskTypeVo::getRiskTypeStatus, (v1, v2) -> v2));
        return Stream.of(new RiskTypeVo("declare_riskType", "\u7533\u62a5", riskMap.get(ReformGenerationSourceEnum.DECLARE.getValue())), new RiskTypeVo("detection_riskType", "\u68c0\u6d4b", riskMap.get(ReformGenerationSourceEnum.DETECTION.getValue())), new RiskTypeVo("physicalExamination_riskType", "\u4f53\u68c0", riskMap.get(ReformGenerationSourceEnum.TJ.getValue())), new RiskTypeVo("training_riskType", "\u8d1f\u8d23\u4eba\u57f9\u8bad", riskMap.get(ReformGenerationSourceEnum.TRAIN.getValue())), new RiskTypeVo("threeTime_riskType", "\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", riskMap.get(ReformGenerationSourceEnum.THREE_TIME.getValue())), new RiskTypeVo("protective_riskType", "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e", riskMap.get(ReformGenerationSourceEnum.PROTECTION.getValue())), new RiskTypeVo("warningMark_riskType", "\u73b0\u573a\u8b66\u793a\u6807\u8bc6\u8bbe\u7f6e", riskMap.get(ReformGenerationSourceEnum.WARNING_SIGNS.getValue())), new RiskTypeVo("suspected_occ_disease", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u7591\u4f3c\u804c\u4e1a\u75c5", riskMap.get(ReformGenerationSourceEnum.YSZYB.getValue())), new RiskTypeVo("occ_contraindications", "\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-\u804c\u4e1a\u7981\u5fcc\u8bc1", riskMap.get(ReformGenerationSourceEnum.JJZ.getValue())), new RiskTypeVo("jccbzg_riskType", "\u76d1\u6d4b\u7ed3\u679c\u8d85\u6807\u6574\u6539", riskMap.get(ReformGenerationSourceEnum.JCCBZG.getValue())), new RiskTypeVo("jccb_riskType", "\u68c0\u6d4b\u7ed3\u679c\u8d85\u6807", riskMap.get(ReformGenerationSourceEnum.JCCB.getValue())), new RiskTypeVo("healthArchive_riskType", "\u804c\u4e1a\u536b\u751f\u6863\u6848", riskMap.get(ReformGenerationSourceEnum.ARCHIVES.getValue())), new RiskTypeVo("grjl_riskType", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b", riskMap.get(ReformGenerationSourceEnum.GRJL.getValue())), new RiskTypeVo("grjlcb_riskType", "\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u7ed3\u679c\u5f02\u5e38", riskMap.get(ReformGenerationSourceEnum.GRJLCB.getValue()))).collect(Collectors.toList());
    }

    public Long obtainNowComRiskNum(Long cid) {
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        List<ReformItemBasic> riskListUnfinishedList = this.reformItemBasicMapper.getRiskListUnfinishedData(search, null);
        return riskListUnfinishedList.stream().filter(r -> !ReformStatusEnum.WC.getValue().equals(r.getStatus()) && !ReformStatusEnum.WXZG.getValue().equals(r.getStatus())).count();
    }

    public void autoGenKeyFactorReform(String cids) {
        this.itemBasicNewService.autoGenKeyFactorReform(cids);
    }

    @Transactional
    public List<ReformItemBasic> commitBatchGenKeyReform(List<Long> cidList, Date findDate) {
        int year = LocalDateTime.now().getYear();
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String effectiveDateStr = "2024-06-01 00:00:00";
        String overDateStr = "2024-03-01 00:00:00";
        ArrayList<ReformItemBasic> basicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemAcceptanceRecord> recordList = new ArrayList<ReformItemAcceptanceRecord>();
        Set<Long> physicalCompletedList = ((ReformItemBasicMapper)this.dao).getPhysicalCompletedList(cidList, effectiveDateStr);
        Set<Long> physicalCompletedByReformList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(10), year);
        physicalCompletedList.addAll(physicalCompletedByReformList);
        Map<Long, PhcPhysicalCheckV3221> physicalOverDuelMap = ((ReformItemBasicMapper)this.dao).getPhysicalOverDueMap(cidList, effectiveDateStr, overDateStr);
        Set<Long> checkCompletedList = ((ReformItemBasicMapper)this.dao).getCheckCompletedList(cidList, effectiveDateStr);
        Set<Long> checkCompletedByReformList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(14), year);
        checkCompletedList.addAll(checkCompletedByReformList);
        Map<Long, CheckPlan> checkOverDuelMap = ((ReformItemBasicMapper)this.dao).getCheckOverDueMap(cidList, effectiveDateStr, overDateStr);
        Set<Long> trainZCompletedList = ((ReformItemBasicMapper)this.dao).getTrainCompletedList(cidList, 12, effectiveDateStr);
        Set<Long> trainZCompletedReformList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(19), year);
        trainZCompletedList.addAll(trainZCompletedReformList);
        Set<Long> trainMCompletedList = ((ReformItemBasicMapper)this.dao).getTrainCompletedList(cidList, 13, effectiveDateStr);
        Set<Long> trainMCompletedReformList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(20), year);
        trainMCompletedList.addAll(trainMCompletedReformList);
        Map<Long, CertificateStaffDetail> train12OverduelMap = ((ReformItemBasicMapper)this.dao).getTrainOverdueList(cidList, 12, effectiveDateStr, overDateStr);
        Map<Long, CertificateStaffDetail> train13OverduelMap = ((ReformItemBasicMapper)this.dao).getTrainOverdueList(cidList, 13, effectiveDateStr, overDateStr);
        Set<Long> threeTimeNoCompletedCidList = ((ReformItemBasicMapper)this.dao).getThreeSimultaneousNoCompleted(cidList, effectiveDateStr);
        Set<Long> protectEquipCompletedList = ((ReformItemBasicMapper)this.dao).getProtectEquipCompleted(cidList, year);
        Set<Long> warnSignManageCompletedList = ((ReformItemBasicMapper)this.dao).getWarnSignManageCompleted(cidList, effectiveDateStr);
        Set healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(cidList, year).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
        List<Object> allTypeList = ((ReformItemBasicMapper)this.dao).getReformItemSourceList2(cidList, year);
        allTypeList = allTypeList.parallelStream().filter(Objects::nonNull).peek(item -> {
            if (CollectionUtils.isNotEmpty((Collection)item.getAceptanceList())) {
                Map collect = item.getAceptanceList().parallelStream().filter(temp -> temp != null && temp.getCreateDate() != null && temp.getCid() != null).collect(Collectors.toMap(ReformItemAcceptanceRecord::getCid, Function.identity(), (k1, k2) -> k1.getCreateDate().after(k2.getCreateDate()) ? k1 : k2));
                item.setAcceptance((ReformItemAcceptanceRecord)collect.get(item.getCid()));
            }
        }).collect(Collectors.toList());
        Object descriptionMore = "";
        for (Long cid : cidList) {
            String businessName;
            if (CollectionUtils.isEmpty(physicalCompletedList) || !physicalCompletedList.contains(cid)) {
                businessName = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                if (!physicalOverDuelMap.isEmpty() && physicalOverDuelMap.containsKey(cid) && physicalOverDuelMap.get(cid) != null && physicalOverDuelMap.get(cid).getCheckTime() != null) {
                    Date date = DateUtils.addYear((Date)physicalOverDuelMap.get(cid).getCheckTime(), (int)1);
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                    businessName = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u6216\u5b58\u5728\u4f53\u68c0\u903e\u671f\u98ce\u9669";
                }
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.TJ, null, businessName, null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, (String)descriptionMore);
            }
            if (CollectionUtils.isEmpty(checkCompletedList) || !checkCompletedList.contains(cid)) {
                CheckPlan checkPlan;
                businessName = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                if (!checkOverDuelMap.isEmpty() && checkOverDuelMap.containsKey(cid) && (checkPlan = checkOverDuelMap.get(cid)) != null && checkPlan.getCheckDateBegin() != null) {
                    Date date = DateUtils.addYear((Date)DateUtil.getDate((LocalDateTime)checkPlan.getCheckDateBegin()), (int)3);
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                    businessName = year + "\u5e74\u5ea6-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.DETECTION, null, businessName, null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, (String)descriptionMore);
            }
            if (CollectionUtils.isEmpty(trainZCompletedList) && CollectionUtils.isEmpty(trainMCompletedList) || !trainZCompletedList.contains(cid) && !trainMCompletedList.contains(cid)) {
                businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                if (!train12OverduelMap.isEmpty() && train12OverduelMap.containsKey(cid) && train12OverduelMap.get(cid) != null && train12OverduelMap.get(cid).getValidityDate() != null) {
                    descriptionMore = "(\u4e3b\u8981\u8d1f\u8d23\u4eba\u903e\u671f\u65f6\u95f4" + format.format(train12OverduelMap.get(cid).getValidityDate()) + ")";
                    businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u8bc1\u4e66\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                if (!train13OverduelMap.isEmpty() && train13OverduelMap.containsKey(cid) && train13OverduelMap.get(cid) != null && train13OverduelMap.get(cid).getValidityDate() != null) {
                    descriptionMore = (String)descriptionMore + "(\u7ba1\u7406\u4eba\u5458\u903e\u671f\u65f6\u95f4" + format.format(train13OverduelMap.get(cid).getValidityDate()) + ")";
                    businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u8bc1\u4e66\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.TRAIN, null, businessName, null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, (String)descriptionMore);
            }
            if (!trainZCompletedList.contains(cid) || CollectionUtils.isEmpty(trainZCompletedList)) {
                businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                if (!train12OverduelMap.isEmpty() && train12OverduelMap.containsKey(cid) && train12OverduelMap.get(cid) != null && train12OverduelMap.get(cid).getValidityDate() != null) {
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(train12OverduelMap.get(cid).getValidityDate()) + ")";
                    businessName = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.NOZYFZR, null, businessName, null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
            }
            if (!trainMCompletedList.contains(cid) || CollectionUtils.isEmpty(trainMCompletedList)) {
                businessName = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                if (!train13OverduelMap.isEmpty() && train13OverduelMap.containsKey(cid) && train13OverduelMap.get(cid) != null && train13OverduelMap.get(cid).getValidityDate() != null) {
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(train13OverduelMap.get(cid).getValidityDate()) + ")";
                    businessName = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.NOGLRY, null, businessName, null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
            }
            if (!CollectionUtils.isEmpty(threeTimeNoCompletedCidList) && threeTimeNoCompletedCidList.contains(cid)) {
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.THREE_TIME, null, year + "\u5e74\u5ea6-\u5b58\u5728\u672a\u5b8c\u6210\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
            }
            if (CollectionUtils.isEmpty(protectEquipCompletedList) || !protectEquipCompletedList.contains(cid)) {
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.PROTECTION, null, year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1", null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
            }
            if (CollectionUtils.isEmpty(warnSignManageCompletedList) || !warnSignManageCompletedList.contains(cid)) {
                this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.WARNING_SIGNS, null, year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6", null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
            }
            if (!CollectionUtils.isEmpty(healthManageFilesCompletedList) && healthManageFilesCompletedList.contains(cid)) continue;
            this.autoGenerationReform2(basicList, recordList, ReformGenerationSourceEnum.ARCHIVES, null, year + "\u5e74\u5ea6-\u672a\u5b8c\u5584\u804c\u4e1a\u536b\u751f\u6863\u6848", null, null, null, findDate, cid, null, null, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT, (byte)2, null, allTypeList, "");
        }
        try {
            if (CollectionUtils.isNotEmpty(basicList)) {
                ((ReformItemBasicMapper)this.dao).insertList2(basicList);
                this.acceptanceRecordService.addRecordList(recordList);
                List<Long> collect = basicList.parallelStream().map(ReformItemBasic::getCid).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    ((ReformItemBasicMapper)this.dao).updateCompanyAreaDetail1(collect);
                    ((ReformItemBasicMapper)this.dao).updateCompanyAreaDetail2(collect);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u751f\u6210\u6574\u6539\u5931\u8d25\uff1a\u4f01\u4e1aID\u4e3a\uff1a" + cidList.toString());
        }
        return basicList;
    }

    @Transactional
    public void autoGenDeclReform(String cids) {
        List<Object> cidList = new ArrayList();
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)cids)) {
            cidList = Arrays.stream(cids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        int year = DateUtils.getYear((Date)new Date());
        Integer integer = this.itemBasicNewService.divideBatchGenKeyReform(cidList, ReformGenerationSourceEnum.DECLARE.getValue(), Integer.valueOf(year), ReformDataSourceEnum.KEYFACTORY.getValue());
        this.logger.error("\u4f01\u4e1a\u7533\u62a5\u98ce\u9669\u751f\u6210\uff0c\u5206\u7c7b\u5bf9\u8c61\u4f46\u662f\u4e0d\u662f\u7533\u62a5\u4f01\u4e1a\u7684\uff0c\u751f\u6210\u98ce\u9669\u7684\u6570\u91cf\uff1a" + integer);
    }

    private List<Long> getZjArchiveCountViewByCid(List<Long> cidList, Integer year) {
        ArrayList<Long> cidListTemp = new ArrayList<Long>(cidList);
        if (CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List<Long> needReformCidList = this.getThreeTimeReformByCid(cidListTemp);
        cidListTemp.removeAll(needReformCidList);
        if (CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List<Integer> archiveTypeList = Arrays.asList(2, 3, 4);
        List<Long> list234 = ((ReformItemBasicMapper)this.dao).get234Completed(cidListTemp, archiveTypeList, year.toString());
        if (CollectionUtils.isEmpty(list234)) {
            return Collections.emptyList();
        }
        List<Long> list5 = ((ReformItemBasicMapper)this.dao).getDoc5Completed(list234);
        Set<Long> physicalReformCompletedList = ((ReformItemBasicMapper)this.dao).getReformCompletedList(list234, Collections.singletonList(10), year);
        if (CollectionUtils.isNotEmpty(physicalReformCompletedList)) {
            list5.addAll(physicalReformCompletedList);
            list5 = list5.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(list5)) {
            return Collections.emptyList();
        }
        return list5;
    }

    public List<ReformItemBasic> getReformItemBasicList(List<Long> cids) {
        return ((ReformItemBasicMapper)this.dao).getCidAndStatusListByCids(cids, DateUtil.getYear());
    }

    public void autoGenerationReform2(List<ReformItemBasic> basicList, List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList, ReformGenerationSourceEnum source, Long businessId, String businessName, String reformMeasures, String location, String findName, Date findTime, Long cid, Long orgId, String fileIds, ReformSourceLiteEnum reformSourceLiteEnum, Byte dataSource, String tjBusinessId, List<ReformItemBasic> allTypeList, String descriptionMore) {
        ReformItemBasic basic = new ReformItemBasic();
        basic.setId(Long.valueOf(this.idworker.nextId()));
        basic.setFindTime(findTime);
        basic.setCid(cid);
        basic.setFinderName(findName);
        basic.setStatus(StatusEnum.draff.getValue());
        basic.setBusinessStatus(StatusEnum.none.getValue());
        basic.setReformItemSourceId(businessId);
        basic.setGenerationSource(source.getValue());
        basic.setIsAutoGeneration(Boolean.valueOf(true));
        basic.setReformItemFiles(fileIds);
        basic.setDataSource(dataSource);
        ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
        if (reformSourceLiteEnum != null) {
            basic.setReformItemSource(reformSourceLiteEnum.getValue());
        }
        acce.setReformMeasure(reformMeasures);
        switch (source) {
            case ZRZC: {
                basic.setName(businessName);
                basic.setAcceptanceObject(Byte.valueOf((byte)1));
                acce.setReformDirectorName(findName);
                break;
            }
            case SFTG: {
                basic.setName(businessName);
                basic.setAcceptanceObject(Byte.valueOf((byte)3));
                basic.setDescription(businessName);
                basic.setReformItemPositionName(location);
                basic.setFinder(orgId);
                break;
            }
            case JCCB: {
                basic.setName(businessName);
                basic.setReformItemType(ReformItemTypeEnum.workPlace.getValue());
                basic.setDescription(descriptionMore);
                basic.setReformItemPositionName(location);
                basic.setAcceptanceObject(Byte.valueOf((byte)2));
                basic.setIsShowInReformModular(Boolean.valueOf(true));
                break;
            }
            case JJZ: 
            case YSZYB: 
            case FC: 
            case ZYB: {
                basic.setReformItemType(ReformItemTypeEnum.employees.getValue());
                basic.setDescription(businessName);
                basic.setName(businessName);
                basic.setAcceptanceObject(Byte.valueOf((byte)2));
                basic.setTjBusinessId(tjBusinessId);
                break;
            }
            case ZXJC: {
                basic.setName(businessName);
                basic.setDescription(businessName);
                basic.setReformItemPositionName("/");
                basic.setAcceptanceObject(Byte.valueOf((byte)2));
                break;
            }
            case ZXJK: {
                basic.setName(businessName);
                basic.setDescription(businessName);
                basic.setReformItemPositionName("/");
                basic.setAcceptanceObject(Byte.valueOf((byte)2));
                break;
            }
            case DECLARE: 
            case TJ: 
            case DETECTION: 
            case TRAIN: 
            case NOZYFZR: 
            case NOGLRY: 
            case THREE_TIME: 
            case PROTECTION: 
            case WARNING_SIGNS: 
            case ARCHIVES: {
                basic.setDescription(businessName + descriptionMore);
                basic.setName(businessName);
                basic.setAcceptanceObject(Byte.valueOf((byte)1));
                break;
            }
        }
        basic.setIsShowInReformModular(Boolean.valueOf(true));
        acce.setStatus(Byte.valueOf((byte)0));
        List<Byte> generationSourceValueList = this.getGenerationSourceValue();
        if (generationSourceValueList.contains(basic.getGenerationSource())) {
            List<ReformItemBasic> reformItemBasicList = this.getReformItemSourceList2(basic, 0, allTypeList);
            if (CollectionUtils.isEmpty(reformItemBasicList)) {
                basic.setBatchNum(Integer.valueOf(1));
                basic.setIsShowInReformModular(Boolean.valueOf(true));
            } else {
                int batchNum = 1;
                Optional<Integer> max = reformItemBasicList.stream().map(ReformItemBasic::getBatchNum).filter(Objects::nonNull).max(Integer::compareTo);
                if (max.isPresent()) {
                    batchNum = max.get();
                }
                if (reformItemBasicList.stream().allMatch(item -> item.getStatus() == 3 || item.getStatus() == 4)) {
                    basic.setBatchNum(Integer.valueOf(batchNum + 1));
                    basic.setIsShowInReformModular(Boolean.valueOf(true));
                } else {
                    List reformItemSourceList = reformItemBasicList.stream().filter(item -> item.getStatus() != 3 && item.getStatus() != 4).map(ReformItemBasic::getReformItemSource).collect(Collectors.toList());
                    List acceptedList = reformItemBasicList.stream().filter(item -> item.getStatus() == 2 || item.getStatus() == 5).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(acceptedList) && acceptedList.get(0) != null && ((ReformItemBasic)acceptedList.get(0)).getAcceptance() != null) {
                        ReformItemBasic basic1 = (ReformItemBasic)acceptedList.get(0);
                        ReformItemAcceptanceRecord acceptance1 = basic1.getAcceptance();
                        basic.setStatus(basic1.getStatus());
                        basic.setFindTime(basic1.getFindTime());
                        acce.setStatus(acceptance1.getStatus());
                        acce.setReformDirectorName(acceptance1.getReformDirectorName());
                        acce.setReformMeasure(acceptance1.getReformMeasure());
                        acce.setRequireFinishTime(acceptance1.getActualFinishTime());
                        acce.setActualFinishTime(acceptance1.getActualFinishTime());
                        acce.setReformFinishedFiles(acceptance1.getReformFinishedFiles());
                    }
                    if (!reformItemSourceList.contains(basic.getReformItemSource())) {
                        basic.setIsShowInReformModular(Boolean.valueOf(false));
                        basic.setBatchNum(Integer.valueOf(batchNum));
                    } else {
                        return;
                    }
                }
            }
        }
        Date date = new Date();
        basic.setCreateDate(date);
        basic.setUpdateDate(date);
        basic.setIsValid(Boolean.valueOf(true));
        basicList.add(basic);
        acce.setId(Long.valueOf(this.idworker.nextId()));
        acce.setReformItemId(basic.getId());
        acce.setCid(cid);
        acce.setCreateDate(date);
        acce.setUpdateDate(date);
        acce.setIsValid(Boolean.valueOf(true));
        reformItemAcceptanceRecordList.add(acce);
    }

    @Transactional(readOnly=false)
    public ReformItemBasic generationReformForTrain(ReformGenerationSourceEnum source, Long businessId, String businessName, String reformMeasures, String findName, Date findTime, Long cid, String fileIds, ReformSourceLiteEnum reformSourceLiteEnum, Integer batchNum) {
        ReformItemBasic basic = new ReformItemBasic();
        String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_REFORM.getCode());
        basic.setReformItemSn(businessNo);
        basic.setFindTime(findTime);
        basic.setCid(cid);
        this.setCompanyAreaDetail(basic);
        basic.setFinderName(findName);
        basic.setStatus(StatusEnum.draff.getValue());
        basic.setBusinessStatus(StatusEnum.none.getValue());
        basic.setReformItemSourceId(businessId);
        basic.setGenerationSource(source.getValue());
        basic.setIsAutoGeneration(Boolean.valueOf(true));
        basic.setReformItemFiles(fileIds);
        basic.setBatchNum(batchNum);
        ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
        if (reformSourceLiteEnum != null) {
            basic.setReformItemSource(reformSourceLiteEnum.getValue());
        }
        acce.setReformMeasure(reformMeasures);
        switch (source) {
            case NOZYFZR: 
            case NOGLRY: {
                basic.setDescription(businessName);
                basic.setName(businessName);
                basic.setAcceptanceObject(Byte.valueOf((byte)1));
                break;
            }
        }
        basic.setIsShowInReformModular(Boolean.valueOf(true));
        acce.setStatus(Byte.valueOf((byte)0));
        List<Byte> generationSourceValueList = this.getGenerationSourceValue();
        if (generationSourceValueList.contains(basic.getGenerationSource())) {
            List<ReformItemBasic> reformItemBasicList = this.getReformItemSourceList(basic, 0);
            if (CollectionUtils.isEmpty(reformItemBasicList)) {
                basic.setIsShowInReformModular(Boolean.valueOf(true));
            } else if (reformItemBasicList.get(0).getStatus() == 3 || reformItemBasicList.get(0).getStatus() == 4) {
                basic.setIsShowInReformModular(Boolean.valueOf(true));
            } else {
                List reformItemSourceList = reformItemBasicList.stream().filter(item -> item.getStatus() != 3 && item.getStatus() != 4).map(ReformItemBasic::getReformItemSource).collect(Collectors.toList());
                List acceptedList = reformItemBasicList.stream().filter(item -> item.getStatus() == 2 || item.getStatus() == 5).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(acceptedList) && acceptedList.get(0) != null && ((ReformItemBasic)acceptedList.get(0)).getAcceptance() != null) {
                    ReformItemBasic basic1 = (ReformItemBasic)acceptedList.get(0);
                    ReformItemAcceptanceRecord acceptance1 = basic1.getAcceptance();
                    basic.setStatus(basic1.getStatus());
                    basic.setFindTime(basic1.getFindTime());
                    acce.setStatus(acceptance1.getStatus());
                    acce.setReformDirectorName(acceptance1.getReformDirectorName());
                    acce.setReformMeasure(acceptance1.getReformMeasure());
                    acce.setRequireFinishTime(acceptance1.getActualFinishTime());
                    acce.setActualFinishTime(acceptance1.getActualFinishTime());
                    acce.setReformFinishedFiles(acceptance1.getReformFinishedFiles());
                }
                if (!reformItemSourceList.contains(basic.getReformItemSource())) {
                    basic.setIsShowInReformModular(Boolean.valueOf(false));
                } else {
                    return null;
                }
            }
        }
        basic = this.add(basic, cid, cid);
        acce.setReformItemId(basic.getId());
        acce.setCid(cid);
        this.acceptanceRecordService.add((Object)acce, cid, cid);
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.REFORM));
        return basic;
    }

    public List<ReformItemBasic> getTrainReformByCid(Long cid) {
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Boolean.TRUE).andNotEqualTo("status", (Object)ReformStatusEnum.WC.getValue()).andIn("generationSource", Arrays.asList(17, 19, 20));
        return this.getListByExample(example);
    }

    public List<ReformItemBasic> getInfoByReformGenerationSource(List<ReformGenerationSourceEnum> ems, Long cid, Integer year) {
        Set<Byte> sets = ems.stream().map(ReformGenerationSourceEnum::getValue).collect(Collectors.toSet());
        return ((ReformItemBasicMapper)this.dao).getInfoByReformGenerationSource(sets, cid, year);
    }

    public List<ReformItemBasic> lastApproveReform(Date updateDate) {
        if (updateDate == null) {
            updateDate = DateUtils.getStartTime((Date)DateUtils.addDay((Date)new Date(), (int)-1));
        }
        return ((ReformItemBasicMapper)this.dao).lastApproveReform(updateDate);
    }

    public Date getWarnOrProtectTime(ReformItemBasic reformItemBasic) {
        return ((ReformItemBasicMapper)this.dao).getWarnOrProtectTime(reformItemBasic);
    }

    @Transactional
    public void threeTimeStatusChange(String cids) {
        List<ReformItemBasic> reformBackIdList;
        List<ReformItemBasic> reformDysIdList;
        List<ReformItemBasic> reformBackNoBackIdList;
        List<ReformItemBasic> reformDysNoDysIdList;
        this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001\u5f00\u59cb");
        List<String> list = new ArrayList<String>();
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)cids)) {
            list = Arrays.stream(cids.split(",")).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(reformDysNoDysIdList = ((ReformItemBasicMapper)this.dao).getThreeTimeBackAndRiskNoBack(list, 4))) {
            this.batchUpdateOrInsert(reformDysNoDysIdList, ReformItemBasicMapper.class, (item, mapper) -> {
                item.setStatus(ReformStatusEnum.CG.getValue());
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001:\u83b7\u53d6\u98ce\u9669\u5f85\u5ba1\u6838,\u4e09\u540c\u65f6\u65e0\u5f85\u5ba1\u6838" + reformDysNoDysIdList.stream().map(ReformItemBasic::getId).collect(Collectors.toList()).toString());
        }
        if (CollectionUtils.isNotEmpty(reformBackNoBackIdList = ((ReformItemBasicMapper)this.dao).getThreeTimeBackAndRiskNoBack(list, 3))) {
            this.batchUpdateOrInsert(reformBackNoBackIdList, ReformItemBasicMapper.class, (item, mapper) -> {
                item.setStatus(ReformStatusEnum.CG.getValue());
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001:\u83b7\u53d6\u98ce\u9669\u9000\u56de,\u4e09\u540c\u65f6\u65e0\u9000\u56de" + reformBackNoBackIdList.stream().map(ReformItemBasic::getId).collect(Collectors.toList()).toString());
        }
        if (CollectionUtils.isNotEmpty(reformDysIdList = ((ReformItemBasicMapper)this.dao).getThreeTimeBackAndRiskNoBack(list, 2))) {
            this.batchUpdateOrInsert(reformDysIdList, ReformItemBasicMapper.class, (item, mapper) -> {
                item.setStatus(ReformStatusEnum.DYS.getValue());
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001:\u83b7\u53d6\u5f85\u5ba1\u6838\u7684\u4e09\u540c\u65f6\u4f46\u662f\u98ce\u9669\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838" + reformDysIdList.stream().map(ReformItemBasic::getId).collect(Collectors.toList()).toString());
        }
        if (CollectionUtils.isNotEmpty(reformBackIdList = ((ReformItemBasicMapper)this.dao).getThreeTimeBackAndRiskNoBack(list, 1))) {
            this.batchUpdateOrInsert(reformBackIdList, ReformItemBasicMapper.class, (item, mapper) -> {
                item.setStatus(ReformStatusEnum.TH.getValue());
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001:\u83b7\u53d6\u5df2\u9000\u56de\u7684\u4e09\u540c\u65f6\u4f46\u662f\u98ce\u9669\u72b6\u6001\u4e0d\u662f\u9000\u56de\u7684" + reformBackIdList.stream().map(ReformItemBasic::getId).collect(Collectors.toList()).toString());
        }
        this.logger.info("\u4e09\u540c\u65f6\u98ce\u9669\u5b9a\u65f6\u4efb\u52a1\u4fee\u6539\u72b6\u6001\u7ed3\u675f");
        this.logger.info("\u4e61\u9547\u534f\u7ba1\u5de1\u67e5\u9875\u9762\u5904\u7406--\u5f00\u59cb");
        List<Byte> generationSourceValue = this.getGenerationSourceValue();
        for (Byte type : generationSourceValue) {
            List<Long> cidList;
            Integer i;
            List<ReformItemBasic> basicList = ((ReformItemBasicMapper)this.dao).getReformXzxgList(type);
            if (CollectionUtils.isEmpty(basicList) || (i = ((ReformItemBasicMapper)this.dao).updateSetIsShowInReformXzxgFalseList(cidList = basicList.parallelStream().map(ReformItemBasic::getCid).collect(Collectors.toList()), type)) <= 0) continue;
            this.logger.info("\u4e61\u9547\u534f\u7ba1\u548c\u753b\u50cf\u90fd\u6709\u7684\u98ce\u9669\uff0c\u5728\u5de1\u67e5\u9875\u9762\u628a\u753b\u50cf\u98ce\u9669\u4fee\u6539\u4e3a\u4e0d\u53ef\u89c1\uff0c\u7c7b\u578b\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)type, (Object)i);
        }
        this.logger.info("\u4e61\u9547\u534f\u7ba1\u5de1\u67e5\u9875\u9762\u5904\u7406--\u7ed3\u675f");
    }

    public List<ReformLastOrgInfo> getLastOrgInfo(List<Long> cids) {
        List<ReformItemAcceptanceRecord> dbList = ((ReformItemBasicMapper)this.dao).getLastOrgInfo(cids);
        Map<Long, List<ReformItemAcceptanceRecord>> cidMap = dbList.stream().collect(Collectors.groupingBy(ReformItemAcceptanceRecord::getCid));
        return cidMap.keySet().stream().map(cid -> {
            List jcList;
            ReformLastOrgInfo info = new ReformLastOrgInfo();
            info.setCid(cid);
            List reformItemBasics = (List)cidMap.get(cid);
            List tjList = reformItemBasics.stream().filter(item -> ReformGenerationSourceEnum.TJ.getValue().equals(item.getGenerationSource())).sorted(Comparator.comparing(ReformItemAcceptanceRecord::getAcceptanceDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(tjList)) {
                info.setLastPhcOrgName(((ReformItemAcceptanceRecord)tjList.get(0)).getThirdOrgName());
                info.setLastPhcAcceptanceDate(((ReformItemAcceptanceRecord)tjList.get(0)).getAcceptanceDate());
            }
            if (CollUtil.isNotEmpty(jcList = reformItemBasics.stream().filter(item -> ReformGenerationSourceEnum.DETECTION.getValue().equals(item.getGenerationSource())).sorted(Comparator.comparing(ReformItemAcceptanceRecord::getAcceptanceDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList()))) {
                info.setLastDetectionOrgName(((ReformItemAcceptanceRecord)jcList.get(0)).getThirdOrgName());
                info.setLastDetectionOrgDate(((ReformItemAcceptanceRecord)jcList.get(0)).getAcceptanceDate());
            }
            return info;
        }).collect(Collectors.toList());
    }

    public Integer getDefuseCheckNotDataNum(Long areaId) {
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(areaId);
        return ((ReformItemBasicMapper)this.dao).getDefuseCheckNotDataNum(areaId, areaModel.getLevel());
    }

    public List<Long> getPushedCids() {
        return ((ReformItemBasicMapper)this.dao).getPushedCids();
    }

    public void handleQueryDateRange(RiskResolveResSearch searchParam) {
        Integer year = searchParam.getYear();
        if (year == null) {
            this.setDateRange(searchParam, "2025-07-01", "2099-12-31");
            return;
        }
        switch (year) {
            case 202401: {
                this.setDateRange(searchParam, "2024-03-01", "2024-07-01");
                break;
            }
            case 202402: {
                this.setDateRange(searchParam, "2024-07-01", "2024-12-31");
                break;
            }
            case 202501: {
                this.setDateRange(searchParam, "2025-01-01", "2025-06-30");
                break;
            }
        }
    }

    private void setDateRange(RiskResolveResSearch searchParam, String startDate, String endDate) {
        try {
            searchParam.setStartDate(DATE_FORMAT.parse(startDate));
            searchParam.setEndDate(DATE_FORMAT.parse(endDate));
        }
        catch (ParseException e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38::", (Throwable)e);
        }
    }

    private void setEnvSortBy(List<RegionRiskNumInfoVo> list, Integer envSortBy) {
        if (envSortBy != null && CollUtil.isNotEmpty(list)) {
            if (envSortBy == 1) {
                list.sort((v1, v2) -> v2.getMostDecreasePunishmentCost().compareTo(v1.getMostDecreasePunishmentCost()));
            }
            if (envSortBy == 2) {
                list.sort((v1, v2) -> v2.getLessDecreasePunishmentCost().compareTo(v1.getLessDecreasePunishmentCost()));
            }
        }
    }

    private List<ReformItemBasic> postApplyFilterCondition(List<ReformItemBasic> reformList, int currentYear) {
        if (CollUtil.isNotEmpty(reformList)) {
            Long cid = reformList.get(0).getCid();
        } else {
            Object cid = null;
        }
        List riskEnumList = Stream.of(ReformGenerationSourceEnum.TJ, ReformGenerationSourceEnum.DECLARE, ReformGenerationSourceEnum.THREE_TIME, ReformGenerationSourceEnum.DETECTION, ReformGenerationSourceEnum.PROTECTION, ReformGenerationSourceEnum.WARNING_SIGNS, ReformGenerationSourceEnum.TRAIN, ReformGenerationSourceEnum.ARCHIVES, ReformGenerationSourceEnum.JCCB, ReformGenerationSourceEnum.JJZ, ReformGenerationSourceEnum.YSZYB).collect(Collectors.toList());
        Predicate<ReformItemBasic> isCurrentYear = r -> r.getFindTime() != null && LocalDateTime.ofInstant(r.getFindTime().toInstant(), ZoneId.systemDefault()).getYear() == currentYear;
        Predicate<ReformItemBasic> isValidStatus = r -> !ReformStatusEnum.WC.getValue().equals(r.getStatus()) && !ReformStatusEnum.WXZG.getValue().equals(r.getStatus());
        Predicate<ReformItemBasic> isValidType = r -> riskEnumList.contains(ReformGenerationSourceEnum.getByType((Byte)r.getGenerationSource()));
        List sourceEnums = reformList.stream().map(r -> ReformGenerationSourceEnum.getByType((Byte)r.getGenerationSource())).collect(Collectors.toList());
        Predicate<ReformItemBasic> trainingFilter = r -> {
            ReformGenerationSourceEnum source = ReformGenerationSourceEnum.getByType((Byte)r.getGenerationSource());
            if (sourceEnums.contains(ReformGenerationSourceEnum.TRAIN)) {
                return source != ReformGenerationSourceEnum.NOZYFZR && source != ReformGenerationSourceEnum.NOGLRY;
            }
            if (sourceEnums.contains(ReformGenerationSourceEnum.NOZYFZR) && !sourceEnums.contains(ReformGenerationSourceEnum.NOGLRY)) {
                return source != ReformGenerationSourceEnum.NOZYFZR;
            }
            if (sourceEnums.contains(ReformGenerationSourceEnum.NOGLRY) && !sourceEnums.contains(ReformGenerationSourceEnum.NOZYFZR)) {
                return source != ReformGenerationSourceEnum.NOGLRY;
            }
            return Boolean.TRUE;
        };
        reformList = reformList.stream().filter(isCurrentYear).filter(isValidStatus).filter(isValidType).filter(trainingFilter).collect(Collectors.toList());
        return reformList;
    }

    private List<RiskLevelVo> postConvertReformToRiskLevelList(List<ReformItemBasic> reformList) {
        List<RiskLevelVo> riskLevelList = reformList.stream().collect(Collectors.groupingBy(ReformItemBasic::getWarningState, Collectors.counting())).entrySet().stream().map(r -> {
            ReformResolveStatusEnum status = ReformResolveStatusEnum.getByType((Byte)((Byte)r.getKey()));
            if (status == null) {
                return null;
            }
            RiskLevelVo level = new RiskLevelVo();
            switch (status) {
                case FIRSTPUSH: {
                    return this.setRiskLevel(level, "firstAlert", "\u9996\u6b21\u9884\u8b66", (Long)r.getValue());
                }
                case YELLOWWARN: {
                    return this.setRiskLevel(level, "yellowAlert", "\u9ec4\u8272\u9884\u8b66", (Long)r.getValue());
                }
                case REDWARN: {
                    return this.setRiskLevel(level, "redAlert", "\u7ea2\u8272\u9884\u8b66", (Long)r.getValue());
                }
                case STARTPUNISH: {
                    return this.setRiskLevel(level, "executeLaw", "\u542f\u52a8\u6267\u6cd5", (Long)r.getValue());
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (riskLevelList.size() < DEFAULT_WARNING_STATE_LIST.size()) {
            riskLevelList.addAll(DEFAULT_WARNING_STATE_LIST.stream().filter(def -> riskLevelList.stream().noneMatch(r -> r.getRiskLevelCode().equals(def.getRiskLevelCode()))).collect(Collectors.toList()));
        }
        return riskLevelList;
    }

    private Map<Byte, String> postConvertReformToRiskMap(List<ReformItemBasic> reformList, Long cid) {
        int currentYear = LocalDate.now().getYear();
        Map<Byte, String> riskMap = Stream.of(ReformGenerationSourceEnum.TJ, ReformGenerationSourceEnum.DECLARE, ReformGenerationSourceEnum.THREE_TIME, ReformGenerationSourceEnum.DETECTION, ReformGenerationSourceEnum.PROTECTION, ReformGenerationSourceEnum.WARNING_SIGNS, ReformGenerationSourceEnum.TRAIN, ReformGenerationSourceEnum.ARCHIVES, ReformGenerationSourceEnum.JCCB, ReformGenerationSourceEnum.JJZ, ReformGenerationSourceEnum.YSZYB, ReformGenerationSourceEnum.JCCBZG, ReformGenerationSourceEnum.GRJL).collect(Collectors.toMap(ReformGenerationSourceEnum::getValue, v -> "\u65e0\u98ce\u9669"));
        reformList = Optional.ofNullable(reformList).map(list -> list.stream().filter(r -> !Objects.equals(r.getDataSource(), ReformDataSourceEnum.XJQY.getValue()) && riskMap.containsKey(r.getGenerationSource()) && r.getFindTime() != null && LocalDateTime.ofInstant(r.getFindTime().toInstant(), ZoneId.systemDefault()).getYear() == currentYear).collect(Collectors.toList())).orElse(Collections.emptyList());
        Map<Boolean, Map<Byte, List<ReformItemBasic>>> statusGroups = reformList.stream().collect(Collectors.partitioningBy(r -> ReformStatusEnum.WC.getValue().equals(r.getStatus()) || ReformStatusEnum.WXZG.getValue().equals(r.getStatus()), Collectors.groupingBy(ReformItemBasic::getGenerationSource)));
        riskMap.forEach((source, riskName) -> {
            ReformGenerationSourceEnum sourceEnum = ReformGenerationSourceEnum.getByType((Byte)source);
            if (sourceEnum != null) {
                List<ReformItemBasic> finishList = ((Map)statusGroups.get(Boolean.TRUE)).getOrDefault(source, Collections.emptyList());
                List<ReformItemBasic> unfinishList = ((Map)statusGroups.get(Boolean.FALSE)).getOrDefault(source, Collections.emptyList());
                this.setRiskDescription(currentYear, riskMap, cid, sourceEnum, finishList, unfinishList);
            }
        });
        return riskMap;
    }

    private void setRiskDescription(int currentYear, Map<Byte, String> riskMap, Long cid, ReformGenerationSourceEnum sourceEnum, List<ReformItemBasic> finishList, List<ReformItemBasic> unfinishList) {
        Byte source = sourceEnum.getValue();
        boolean noData = CollUtil.isEmpty(finishList) && CollUtil.isEmpty(unfinishList);
        boolean hasRisk = CollUtil.isNotEmpty(unfinishList);
        boolean noRisk = CollUtil.isNotEmpty(finishList) && CollUtil.isEmpty(unfinishList);
        switch (sourceEnum) {
            case THREE_TIME: {
                boolean hasNoRiskItems;
                List<TsProjectSimple> tsList = ((ReformItemBasicMapper)this.dao).getTsList(cid);
                if (CollUtil.isEmpty(tsList)) {
                    riskMap.put(source, "\u6682\u65e0\u98ce\u9669");
                    return;
                }
                ArrayList okStatus = CollUtil.toList((Object[])new Byte[]{TsProjectSimpleStatusEnum.AUDITED.getCode(), TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode()});
                ArrayList allStatus = CollUtil.toList((Object[])new Byte[]{TsProjectSimpleStatusEnum.AUDITED.getCode(), TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode(), TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode(), TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()});
                long finishCount = tsList.stream().map(TsProjectSimple::getStatus).filter(okStatus::contains).count();
                long totalCount = tsList.stream().map(TsProjectSimple::getStatus).filter(allStatus::contains).count();
                boolean isAllFinished = finishCount == totalCount;
                boolean bl = hasNoRiskItems = CollUtil.isEmpty(finishList) && CollUtil.isEmpty(unfinishList);
                String status = isAllFinished && hasNoRiskItems ? "\u6682\u65e0\u98ce\u9669" : (isAllFinished ? String.format("\u5df2\u5316\u89e3\uff1a%d/%d", finishCount, totalCount) : String.format("\u672a\u5316\u89e3\uff1a%d/%d", finishCount, totalCount));
                riskMap.put(source, status);
                break;
            }
            case ARCHIVES: {
                Long riskNum;
                Map archiveMap = this.liteArchiveService.getArchiveData(cid);
                TreeMap sortedMap = new TreeMap(archiveMap);
                ZjArchiveCountView prevArchive = (ZjArchiveCountView)sortedMap.firstEntry().getValue();
                ZjArchiveCountView currArchive = (ZjArchiveCountView)sortedMap.lastEntry().getValue();
                ArrayList currentArchiveStatusList = CollUtil.toList((Object[])new String[]{currArchive.getThirdStateStr(), currArchive.getHseManageStateStr(), currArchive.getTrainStateStr(), currArchive.getCheckStateStr(), currArchive.getPhysicalStateStr(), currArchive.getStaffStateStr()});
                Long l = riskNum = noData ? null : Long.valueOf(currentArchiveStatusList.stream().filter(s -> "\u65e0\u6570\u636e".equals(s) || "\u5f85\u5b8c\u5584".equals(s)).count());
                riskMap.put(source, riskNum == null ? "\u6682\u65e0\u98ce\u9669" : (riskNum == 0L ? "\u5df2\u5316\u89e3\uff1a6/6" : String.format("\u672a\u5316\u89e3\uff1a%d/6", 6L - riskNum)));
                break;
            }
            case DECLARE: 
            case TJ: 
            case DETECTION: 
            case TRAIN: 
            case PROTECTION: 
            case WARNING_SIGNS: 
            case GRJL: 
            case JCCB: 
            case JJZ: 
            case YSZYB: 
            case JCCBZG: {
                CheckPlanListParam checkParam;
                List checkList;
                if (sourceEnum == ReformGenerationSourceEnum.JJZ || sourceEnum == ReformGenerationSourceEnum.YSZYB) {
                    ArrayList<PhcPhysicalCheckV3221> resultPhyList = new ArrayList<PhcPhysicalCheckV3221>();
                    PhcPhysicalCheckSearchVo phy = new PhcPhysicalCheckSearchVo();
                    phy.setCid(cid);
                    phy.setYear(Integer.valueOf(currentYear - 1));
                    List<PhcPhysicalCheckV3221> resultPhyList01 = this.physicalCheckV3221Mapper.getListDataBySearchVo(phy);
                    phy.setYear(Integer.valueOf(currentYear));
                    List<PhcPhysicalCheckV3221> resultPhyList02 = this.physicalCheckV3221Mapper.getListDataBySearchVo(phy);
                    resultPhyList.addAll(resultPhyList01);
                    resultPhyList.addAll(resultPhyList02);
                    if (CollUtil.isEmpty(resultPhyList)) {
                        riskMap.put(source, "\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                }
                if (sourceEnum == ReformGenerationSourceEnum.JCCB && CollUtil.isEmpty((Collection)(checkList = this.checkPlanService.getCheckPlanPage(new JqGridParam(Integer.MAX_VALUE, 1), checkParam = new CheckPlanListParam().setCid(cid).setCheckDateBegin(DateUtils.getYearFirstTime((int)(currentYear - 1))).setCheckDateEnd(DateUtils.getYearLastTime((int)currentYear)).setCheckTypes((List)CollUtil.toList((Object[])new Integer[]{2, 3, 4})).setStatus((List)CollUtil.toList((Object[])new Integer[]{2, 3})), Boolean.TRUE).getList()))) {
                    riskMap.put(source, "\u6682\u65e0\u98ce\u9669");
                    break;
                }
                if (noData) {
                    if (sourceEnum == ReformGenerationSourceEnum.JCCBZG) {
                        riskMap.put(source, "\u6682\u65e0\u6709\u6548\u76d1\u6d4b\u6570\u636e");
                        break;
                    }
                    riskMap.put(source, "\u6682\u65e0\u98ce\u9669");
                    break;
                }
                if (hasRisk) {
                    int finishNum = CollUtil.isNotEmpty(finishList) ? finishList.size() : 0;
                    int unfinishNum = CollUtil.isNotEmpty(unfinishList) ? unfinishList.size() : 0;
                    int totalNum = finishNum + unfinishNum;
                    String desc = finishNum == totalNum ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3";
                    riskMap.put(source, desc + "\uff1a" + finishNum + "/" + totalNum);
                    break;
                }
                if (!noRisk) break;
                int finishNum = finishList.size();
                riskMap.put(source, "\u5df2\u5316\u89e3\uff1a" + finishNum + "/" + finishNum);
                break;
            }
        }
    }

    private RiskLevelVo setRiskLevel(RiskLevelVo level, String code, String name, Long num) {
        level.setRiskLevelCode(code);
        level.setRiskLevelName(name);
        level.setRiskLevelNum(num);
        return level;
    }

    public List<ReformItemListVo> countReformCompletedGenerateSource(List<Long> cidList, List<Integer> generationSources) {
        return this.reformItemBasicMapper.countReformCompletedGenerateSource(cidList, generationSources);
    }

    public String generateCacheKey(Object ... objs) {
        if (ArrayUtils.isNotEmpty((Object[])objs)) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : objs) {
                if (obj == null) continue;
                sb.append(obj.toString() + ":");
            }
            return sb.toString();
        }
        return "";
    }

    public List<Long> getRiskCids() {
        return ((ReformItemBasicMapper)this.dao).getRiskCids(LocalDateTime.now().getYear());
    }

    public NewCompanyGuideProcessModel getRiskResolveVisualization(RiskResolveResSearch searchVo) {
        String riskTypeStr = searchVo.getRiskTypeStr();
        if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)riskTypeStr)) {
            List collect = Arrays.stream(riskTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
            ArrayList<Integer> riskTypeChildList = new ArrayList<Integer>();
            if (riskTypeStr.contains("211")) {
                riskTypeChildList.add(1);
                collect.add(21);
            }
            if (riskTypeStr.contains("212")) {
                riskTypeChildList.add(2);
                collect.add(21);
            }
            searchVo.setRiskChildTypeStrList(riskTypeChildList);
            searchVo.setRiskTypeStrList(collect);
        }
        this.setIsCurrent(searchVo);
        NewCompanyGuideProcessModel riskResolveVisualization = ((ReformItemBasicMapper)this.dao).getRiskResolveVisualization(searchVo);
        if (ObjectUtil.isNotNull((Object)riskResolveVisualization)) {
            return riskResolveVisualization;
        }
        return new NewCompanyGuideProcessModel();
    }
}

