/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTableService;
import cn.smarthse.modules.health.company.service.IOptimizeEnvEconomicAccountTableService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.work.reform.CompanyRiskCompletionMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemAcceptanceRecordMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicNewMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemSourceMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.ReformItemSource;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformAcceptRecordViewVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemBasicView;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckConclusionEnum;
import cn.smarthse.modules.health.enums.reform.AcceptanceResultEnum;
import cn.smarthse.modules.health.enums.reform.ReformAcceptanceRecordStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformItemSourceService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.riskResolve.RiskResolveInfoVo;
import cn.smarthse.modules.health.vo.riskResolve.RiskWarnFormVo;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.modules.health.vo.work.reform.CidTimeVo;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.util.common.ListUtils;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ReformItemBasicNewServiceImpl
extends BaseServiceImpl<ReformItemBasicNewMapper, ReformItemBasic>
implements IReformItemBasicNewService {
    @Resource
    private ReformItemBasicMapper reformItemBasicMapper;
    @Resource
    private CompanyRiskCompletionMapper riskCompleteMapper;
    @Autowired
    IReformItemAcceptanceRecordService acceptanceRecordService;
    @Autowired
    IReformItemSourceService itemSourceService;
    @Autowired
    IReformItemBasicCommandService commandService;
    @Autowired
    IReformItemBasicService itemBasicService;
    @DubboReference
    private ICheckResultService checkResultService;
    @Autowired
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference
    private INewCompanyGuideFinishedReportService companyGuideFinishedReportService;
    @DubboReference
    private ISysFileProvideService fileService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference
    private ICompanyBusinessTableService companyBusinessTableService;
    @DubboReference
    private IOptimizeEnvEconomicAccountTableService economicAccountTableService;
    @Autowired
    RedisClient redisClient;
    private static final String effectiveDateStr = "2025-10-01 00:00:00";
    private static final String overDateStr = "2025-07-01 00:00:00";
    private static final Integer currYear = DateUtils.getThisYear();
    private static final Date findTime = DateUtils.parseDate((Object)"2025-07-01 00:00:01");
    private static final String AREA_RISK_HISTORY_CACHE_KEY = "RiskMitigationController:areaRiskNumCountListData:history";
    private static final String HOME_INDEX_CACHE_KEY = "HomeIndexControllerV3223:getHelpCompanyInfo";

    public ReformItemBasic getByIdAndRecordDetail(Long id) {
        ReformItemBasic basic = (ReformItemBasic)this.getById(id);
        if (basic == null) {
            return null;
        }
        List recordList = this.acceptanceRecordService.getListByReformItemId(basic.getId());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)recordList)) {
            return basic;
        }
        basic.setAceptanceList(recordList);
        basic.setAcceptance((ReformItemAcceptanceRecord)recordList.get(recordList.size() - 1));
        return basic;
    }

    @Transactional(readOnly=false)
    public Integer generateReform(List<ReformAddParam> addParamList) {
        List split;
        if (new Date().getTime() >= DateUtils.parseDate((Object)"2025-12-31 18:00:00").getTime()) {
            this.logger.error("1.1\u53f7\u4e4b\u540e\u4e0d\u518d\u751f\u6210\u98ce\u9669:" + String.valueOf(addParamList));
            return 0;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(addParamList)) {
            return 0;
        }
        Date dateNow = new Date();
        ArrayList<ReformItemBasic> basicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemSource> sourceList = new ArrayList<ReformItemSource>();
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>();
        List<Byte> findTimeSpecialList1 = Arrays.asList(ReformSourceLiteEnum.FZZRZC.getValue(), ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue(), ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue());
        List<Byte> findTimeSpecialList2 = Arrays.asList(ReformGenerationSourceEnum.DETECTION_ITEM2.getValue(), ReformGenerationSourceEnum.DETECTION_ITEM3.getValue(), ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.YSZYB.getValue());
        List<Byte> findTimeSpecialList3 = Arrays.asList(ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.YSZYB.getValue());
        Map areaDetailMap = ((ReformItemBasicNewMapper)this.dao).getReformCompanyAreaDetail(addParamList.stream().map(ReformAddParam::getCid).collect(Collectors.toList())).stream().collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (a, b) -> a));
        for (ReformAddParam param : addParamList) {
            if (param == null) continue;
            Long cid = param.getCid();
            if (dateNow.getTime() >= DateUtils.parseDate((Object)effectiveDateStr).getTime() && findTimeSpecialList3.contains(param.getGenerationSource())) continue;
            ReformItemSource source = new ReformItemSource();
            BeanUtils.copyProperties((Object)param, (Object)source);
            source.setId(Long.valueOf(this.idworker.nextId()));
            if (areaDetailMap.get(cid) != null) {
                source.setAreaId(((ReformItemBasic)areaDetailMap.get(cid)).getAreaId());
                source.setAreaId1(((ReformItemBasic)areaDetailMap.get(cid)).getAreaId1());
                source.setAreaId2(((ReformItemBasic)areaDetailMap.get(cid)).getAreaId2());
                source.setAreaId3(((ReformItemBasic)areaDetailMap.get(cid)).getAreaId3());
                source.setAreaId4(((ReformItemBasic)areaDetailMap.get(cid)).getAreaId4());
            }
            if (findTimeSpecialList1.contains(source.getReformItemSource()) || findTimeSpecialList2.contains(source.getGenerationSource())) {
                source.setFindTime(findTime);
            }
            if (Objects.equals(source.getDataSource(), 5)) {
                source.setFindTime(dateNow);
            }
            if (source.getGenerationSource().intValue() == 13) {
                if (StringUtils.isNotBlank((CharSequence)source.getName())) {
                    source.setName(source.getName().replace("\u201d\u4e09\u540c\u65f6\u201c", "\u201c\u4e09\u540c\u65f6\u201d"));
                }
                if (StringUtils.isNotBlank((CharSequence)source.getDescription())) {
                    source.setDescription(source.getDescription().replace("\u201d\u4e09\u540c\u65f6\u201c", "\u201c\u4e09\u540c\u65f6\u201d"));
                }
            }
            if (source.getFindTime() != null) {
                source.setFindTimeYear(Integer.valueOf(DateUtils.getYear((Date)source.getFindTime())));
            }
            if (Objects.equals(source.getGenerationSource(), ReformGenerationSourceEnum.GRJL.getValue())) {
                source.setLawStatus(Byte.valueOf((byte)2));
            }
            source.setReformItemId(source.getId());
            source.setStatus(ReformStatusEnum.DZG.getValue());
            source.setCreateBy(source.getCreateBy());
            source.setCreateDate(dateNow);
            source.setUpdateBy(source.getCreateBy());
            source.setUpdateDate(dateNow);
            source.setIsValid(Boolean.valueOf(true));
            sourceList.add(source);
            ReformItemBasic basic = new ReformItemBasic();
            BeanUtils.copyProperties((Object)source, (Object)basic);
            basicList.add(basic);
            ReformItemAcceptanceRecord acc = new ReformItemAcceptanceRecord();
            acc.setId(Long.valueOf(this.idworker.nextId()));
            acc.setReformMeasure(param.getReformMeasure());
            acc.setReformItemId(basic.getId());
            acc.setStatus(ReformAcceptanceRecordStatusEnum.CG.getValue());
            acc.setCid(cid);
            acc.setCreateBy(source.getCreateBy());
            acc.setCreateDate(dateNow);
            acc.setUpdateBy(source.getCreateBy());
            acc.setUpdateDate(dateNow);
            acc.setIsValid(Boolean.valueOf(true));
            accList.add(acc);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(sourceList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(basicList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(accList)) {
            return 0;
        }
        areaDetailMap.clear();
        List<ReformItemBasic> basicMergeList = basicList.stream().filter(item -> item != null && ReformGenerationSourceEnum.getEightGenerationSourceValue().contains(item.getGenerationSource())).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(basicMergeList)) {
            Set basicMergeIdList = basicMergeList.stream().map(ReformItemBasic::getId).collect(Collectors.toSet());
            List<ReformItemSource> sourceMergeList = sourceList.parallelStream().filter(item -> basicMergeIdList.contains(item.getId())).collect(Collectors.toList());
            List<ReformItemAcceptanceRecord> accMergeList = accList.parallelStream().filter(item -> basicMergeIdList.contains(item.getReformItemId())).collect(Collectors.toList());
            basicList.removeAll(basicMergeList);
            sourceList.removeAll(sourceMergeList);
            accList.removeAll(accMergeList);
            Map<String, Object> map = this.processMerge(basicMergeList, sourceMergeList, accMergeList);
            basicList.addAll((List)map.get("basicListNew"));
            sourceList.addAll((List)map.get("sourceListNew"));
            accList.addAll((List)map.get("accListNew"));
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(basicList)) {
            split = ListUtils.split(basicList, (int)2000);
            for (List reformItemBasicList : split) {
                ((ReformItemBasicNewMapper)this.dao).insertList2(reformItemBasicList);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(sourceList)) {
            split = ListUtils.split(sourceList, (int)2000);
            for (List reformItemSources : split) {
                this.itemSourceService.insertList2(reformItemSources);
            }
            for (List reformItemSources : split) {
                List<Long> collect = reformItemSources.parallelStream().map(ReformItemSource::getReformItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ((ReformItemBasicNewMapper)this.dao).reformItemSourceMultByBasicId(collect);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(accList)) {
            split = ListUtils.split(accList, (int)2000);
            for (List acceptanceRecordList : split) {
                this.acceptanceRecordService.addRecordList(acceptanceRecordList);
            }
        }
        return sourceList.size();
    }

    public Map<String, Object> processMerge(List<ReformItemBasic> basicMergeList, List<ReformItemSource> sourceMergeList, List<ReformItemAcceptanceRecord> accMergeList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(basicMergeList)) {
            return Collections.emptyMap();
        }
        Date dateNow = new Date();
        Map<Object, Object> cidAndBasicMap = new HashMap();
        List<Object> containKeyFactoryIdList = new ArrayList();
        List list = ((ReformItemBasicNewMapper)this.dao).getAllReformItemBasic(basicMergeList.stream().map(ReformItemBasic::getCid).collect(Collectors.toList()), basicMergeList.stream().map(ReformItemBasic::getGenerationSource).distinct().collect(Collectors.toList()), DateUtils.getYear((Date)dateNow)).stream().filter(item -> item != null && item.getStatus() != null && !item.getStatus().equals((byte)10)).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            cidAndBasicMap = list.parallelStream().collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.toMap(ReformItemBasic::getGenerationSource, Function.identity(), (a, b) -> a.getCreateDate().getTime() >= b.getCreateDate().getTime() ? a : b)));
            ArrayList<Long> lastReformIdList = new ArrayList<Long>();
            cidAndBasicMap.forEach((cid, generationReform) -> {
                List collect = generationReform.values().stream().map(ReformItemBasic::getId).collect(Collectors.toList());
                lastReformIdList.addAll(collect);
            });
            containKeyFactoryIdList = ((ReformItemBasicNewMapper)this.dao).getLastReformHaveKeyFactor(lastReformIdList);
        }
        HashMap finalCidAndBasicMap = cidAndBasicMap;
        ArrayList finalContainKeyFactoryIdList = containKeyFactoryIdList;
        ArrayList basicListNew = new ArrayList();
        ArrayList sourceListNew = new ArrayList();
        ArrayList accListNew = new ArrayList();
        Map<Long, Map<Byte, List<ReformItemSource>>> collect = sourceMergeList.parallelStream().collect(Collectors.groupingBy(ReformItemSource::getCid, Collectors.groupingBy(ReformItemSource::getGenerationSource)));
        collect.forEach((cid, generationReformList) -> generationReformList.forEach((generationSource, reformItemSourceList) -> {
            ReformItemSource oneSource = (ReformItemSource)reformItemSourceList.get(0);
            Integer sourceFrom = oneSource.getReformItemSource().intValue();
            ReformItemBasic lastReformItemBasic = null;
            if (finalCidAndBasicMap.get(cid) != null && ((Map)finalCidAndBasicMap.get(cid)).get(generationSource) != null) {
                lastReformItemBasic = (ReformItemBasic)((Map)finalCidAndBasicMap.get(cid)).get(generationSource);
            }
            if (sourceFrom.equals(8)) {
                if (lastReformItemBasic != null && lastReformItemBasic.getStatus().intValue() != 3 && lastReformItemBasic.getStatus().intValue() != 4) {
                    if (!finalContainKeyFactoryIdList.contains(lastReformItemBasic.getId())) {
                        oneSource.setReformItemId(lastReformItemBasic.getId());
                        oneSource.setStatus(lastReformItemBasic.getStatus());
                        oneSource.setActualFinishTime(lastReformItemBasic.getActualFinishTime());
                        oneSource.setReformDirectorName(lastReformItemBasic.getReformDirectorName());
                        oneSource.setAcceptanceDate(lastReformItemBasic.getAcceptanceDate());
                        oneSource.setAcceptanceDirectorName(lastReformItemBasic.getAcceptanceDirectorName());
                        sourceListNew.add(oneSource);
                    }
                } else {
                    sourceListNew.add(oneSource);
                    ReformItemBasic basic = basicMergeList.stream().filter(item -> item.getId().equals(oneSource.getId())).findFirst().get();
                    basicListNew.add(basic);
                    ReformItemAcceptanceRecord acc = accMergeList.stream().filter(item -> item.getReformItemId().equals(oneSource.getId())).findFirst().get();
                    accListNew.add(acc);
                }
            } else if (lastReformItemBasic != null) {
                for (ReformItemSource item2 : reformItemSourceList) {
                    item2.setReformItemId(lastReformItemBasic.getId());
                    item2.setStatus(lastReformItemBasic.getStatus());
                    item2.setActualFinishTime(lastReformItemBasic.getActualFinishTime());
                    item2.setReformDirectorName(lastReformItemBasic.getReformDirectorName());
                    item2.setAcceptanceDate(lastReformItemBasic.getAcceptanceDate());
                    item2.setAcceptanceDirectorName(lastReformItemBasic.getAcceptanceDirectorName());
                }
                sourceListNew.addAll(reformItemSourceList);
            } else {
                for (ReformItemSource item3 : reformItemSourceList) {
                    item3.setReformItemId(oneSource.getId());
                }
                sourceListNew.addAll(reformItemSourceList);
                ReformItemBasic basic = basicMergeList.stream().filter(item -> item.getId().equals(oneSource.getId())).findFirst().get();
                basicListNew.add(basic);
                ReformItemAcceptanceRecord acc = accMergeList.stream().filter(item -> item.getReformItemId().equals(oneSource.getId())).findFirst().get();
                accListNew.add(acc);
            }
        }));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("basicListNew", basicListNew);
        map.put("sourceListNew", sourceListNew);
        map.put("accListNew", accListNew);
        return map;
    }

    @Transactional
    public void autoAddReformByCheck(String cids) {
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u5230\u4f01\u4e1a\u7aef\u7684\u6574\u6539\u5f00\u59cb", (Object[])new Object[0]);
        List cidList = StringUtils.parseToLongList((String)cids, (String)",");
        this.generateNotConvertToReformByCheck(cidList);
        this.updateConvertToReformByCheck(cidList);
        List<Object> passHistoryDysJCCBRefromList = ((ReformItemBasicNewMapper)this.dao).passJCCBRefrom(cidList);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        passHistoryDysJCCBRefromList = passHistoryDysJCCBRefromList.stream().filter(item -> item != null && !pilotAndNewCompanyList.contains(item.getCid())).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(passHistoryDysJCCBRefromList)) {
            this.makeAndUpdateReform(passHistoryDysJCCBRefromList, null, (byte)3, null);
            XxlJobHelper.log((String)("\u81ea\u52a8\u9a8c\u6536\u8d85\u6807\u98ce\u9669\u6570\u91cf\uff1a" + passHistoryDysJCCBRefromList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(passHistoryDysJCCBRefromList.stream().filter(Objects::nonNull).map(ReformItemBasic::getId).limit(10L).toList())), (Object[])new Object[0]);
        }
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u5230\u4f01\u4e1a\u7aef\u7684\u6574\u6539\u7ed3\u675f", (Object[])new Object[0]);
    }

    private void generateNotConvertToReformByCheck(List<Long> cidList) {
        List<Object> checkList = ((ReformItemBasicNewMapper)this.dao).getNotConvertToReformByRiskData(cidList, null);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        checkList = checkList.stream().filter(item -> item != null && !pilotAndNewCompanyList.contains(item.getCid())).collect(Collectors.toList());
        XxlJobHelper.log((String)("\u4ece\u672a\u751f\u6210\u8fc7\u68c0\u6d4b\u8d85\u6807\u98ce\u9669\u7684\u6570\u91cf\uff1a" + checkList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(checkList.stream().filter(Objects::nonNull).map(BaseEntity::getId).limit(10L).toList())), (Object[])new Object[0]);
        ArrayList<ReformAddParam> reformAddParamList = new ArrayList<ReformAddParam>();
        ArrayList<Long> reformItemSourceIdList = new ArrayList<Long>();
        for (CheckPlan checkPlan : checkList) {
            if (checkPlan == null) continue;
            ReformAddParam param = new ReformAddParam();
            param.setCid(checkPlan.getCid());
            param.setFinderName(checkPlan.getThirdOrgName());
            param.setFindTime(DateUtils.localDateTimeToDate((LocalDateTime)checkPlan.getCreateDate()));
            param.setName((String)(StringUtils.isBlank((CharSequence)checkPlan.getProjectName()) ? "\u68c0\u6d4b\u7ed3\u679c\u5b58\u5728\u8d85\u6807" : checkPlan.getProjectName() + "--\u68c0\u6d4b\u7ed3\u679c\u5b58\u5728\u8d85\u6807"));
            param.setReformItemSource(ReformSourceLiteEnum.ZYBWHYSJC.getValue());
            param.setReformItemSourceId(checkPlan.getId());
            param.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
            param.setDescription("\u7528\u4eba\u5355\u4f4d\u672a\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u68c0\u6d4b\u8d85\u6807\u6574\u6539\u5de5\u4f5c");
            reformAddParamList.add(param);
            reformItemSourceIdList.add(checkPlan.getId());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(reformAddParamList)) {
            return;
        }
        this.generateReform(reformAddParamList);
        Map acceptIdMap = ((ReformItemBasicNewMapper)this.dao).getReformItemBasicIdListBySourceId(reformItemSourceIdList).stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemBasic::getReformItemSourceId, Function.identity(), (ol, ne) -> ol));
        List list = ListUtils.split(checkList, (int)500);
        for (List newCheckList : list) {
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)newCheckList)) continue;
            List<Long> riskExposeEvaluateIds = newCheckList.stream().map(CheckPlan::getRiskExposeEvaluateId).collect(Collectors.toList());
            Map<Long, List<RiskExposeEvaluateData>> evaluateDataListMap = ((ReformItemBasicNewMapper)this.dao).getEvaluateDataList(riskExposeEvaluateIds, true).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
            ArrayList<ReformCheckMeasure> addList = new ArrayList<ReformCheckMeasure>();
            for (CheckPlan check : newCheckList) {
                ReformItemBasic basic;
                List<RiskExposeEvaluateData> evaluateDataList;
                if (check == null || com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(evaluateDataList = evaluateDataListMap.get(check.getRiskExposeEvaluateId())) || (basic = (ReformItemBasic)acceptIdMap.get(check.getId())) == null) continue;
                for (RiskExposeEvaluateData evaluateData : evaluateDataList) {
                    ReformCheckMeasure measure = new ReformCheckMeasure();
                    measure.setId(Long.valueOf(this.idworker.nextId()));
                    measure.setCid(check.getCid());
                    measure.setCheckId(check.getId());
                    measure.setChangeTime(check.getUpdateDate());
                    measure.setReformId(basic.getId());
                    measure.setAcceptRecordId(basic.getAccLastId());
                    measure.setFactoryName(evaluateData.getFactorName());
                    String pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint();
                    measure.setPointName(pointName);
                    measure.setSituation(Integer.valueOf(0));
                    measure.setCreateDate(new Date());
                    measure.setUpdateDate(new Date());
                    addList.add(measure);
                }
            }
            this.acceptanceRecordService.insertReformCheckMeasureList(addList);
        }
        XxlJobHelper.log((String)("\u4ece\u672a\u751f\u6210\u8fc7\u68c0\u6d4b\u8d85\u6807\u98ce\u9669\u7684\u6570\u91cf(\u5b9e\u9645\u6570\u91cf)\uff1a" + acceptIdMap.size()), (Object[])new Object[0]);
    }

    private void updateConvertToReformByCheck(List<Long> cidList) {
        List<Object> updateCheckWithRiskList = ((ReformItemBasicNewMapper)this.dao).getUpdateCheckWithRisk(cidList);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        updateCheckWithRiskList = updateCheckWithRiskList.stream().filter(item -> item != null && !pilotAndNewCompanyList.contains(item.getCid())).collect(Collectors.toList());
        XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\uff08\u6307\u63aa\u65bd\u4fee\u6539\u65f6\u95f4\u5728\u68c0\u6d4b\u65f6\u95f4\u4e4b\u540e\uff09\u7684\u8d85\u6807\u98ce\u9669\u6570\u91cf\uff1a" + updateCheckWithRiskList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(updateCheckWithRiskList.stream().filter(Objects::nonNull).map(ReformItemBasic::getId).limit(10L).toList())), (Object[])new Object[0]);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(updateCheckWithRiskList)) {
            return;
        }
        ArrayList<Long> riskIdList = new ArrayList<Long>();
        ArrayList accLastIdList = new ArrayList();
        ArrayList areadlyPassCheckList = new ArrayList();
        updateCheckWithRiskList.stream().filter(basic -> basic != null && basic.getRiskExposeEvaluateId() != null && basic.getAccLastId() != null).forEach(basic -> {
            riskIdList.add(basic.getRiskExposeEvaluateId());
            accLastIdList.add(basic.getAccLastId());
            if (Arrays.asList(3, 4).contains(basic.getStatus().intValue())) {
                areadlyPassCheckList.add(basic.getReformItemSourceId());
            }
        });
        Map<Long, List<RiskExposeEvaluateData>> evaluateDataListMap = ((ReformItemBasicNewMapper)this.dao).getEvaluateDataList(riskIdList, null).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
        Map<Long, List<ReformCheckMeasure>> measureMap = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(false)).setAcceptRecordIds(accLastIdList)).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformCheckMeasure::getAcceptRecordId));
        Map<Long, List<ReformCheckMeasure>> measurePassMap = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(false)).setCheckIds(areadlyPassCheckList)).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformCheckMeasure::getCheckId));
        Date date = new Date();
        ArrayList<Object> addList = new ArrayList<Object>();
        ArrayList<ReformCheckMeasure> updateList = new ArrayList<ReformCheckMeasure>();
        ArrayList<ReformCheckMeasure> updateChangeTimeList = new ArrayList<ReformCheckMeasure>();
        HashSet<ReformAddParam> reformAddParamList = new HashSet<ReformAddParam>();
        ArrayList<ReformCheckMeasure> addNewList = new ArrayList<ReformCheckMeasure>();
        for (ReformItemBasic reformItemBasic : updateCheckWithRiskList) {
            if (reformItemBasic == null) continue;
            List dataList = Optional.ofNullable(evaluateDataListMap.get(reformItemBasic.getRiskExposeEvaluateId())).orElse(new ArrayList());
            List checkMeasureList = Optional.ofNullable(measureMap.get(reformItemBasic.getAccLastId())).orElse(new ArrayList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)dataList) || com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)checkMeasureList)) continue;
            Map stringRiskMap = dataList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getWorkshop() + "@" + item.getWorkName() + "@" + item.getCheckPoint() + item.getFactorName(), Function.identity(), (a, b) -> b));
            Map stringMeasureMap = checkMeasureList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getPointName() + item.getFactoryName(), Function.identity(), (a, b) -> b));
            Map stringMeasureAllMap = ((List)Optional.ofNullable(measurePassMap.get(reformItemBasic.getReformItemSourceId())).orElse(new ArrayList())).stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getPointName() + item.getFactoryName(), Function.identity(), (a, b) -> b));
            if (Arrays.asList(3, 4).contains(reformItemBasic.getStatus().intValue())) {
                boolean isHaveNewReform = false;
                for (RiskExposeEvaluateData evaluateData : dataList) {
                    String pointName;
                    String name;
                    ReformCheckMeasure checkMeasure;
                    if (evaluateData == null || evaluateData.getCheckTouchLevel() != 1 || (checkMeasure = (ReformCheckMeasure)stringMeasureAllMap.get(name = (pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint()) + evaluateData.getFactorName())) != null) continue;
                    isHaveNewReform = true;
                    ReformCheckMeasure measure = new ReformCheckMeasure();
                    measure.setId(Long.valueOf(this.idworker.nextId()));
                    measure.setCid(reformItemBasic.getCid());
                    measure.setCheckId(reformItemBasic.getReformItemSourceId());
                    measure.setChangeTime(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()));
                    measure.setReformId(null);
                    measure.setAcceptRecordId(null);
                    measure.setFactoryName(evaluateData.getFactorName());
                    measure.setPointName(pointName);
                    measure.setSituation(Integer.valueOf(0));
                    measure.setCreateDate(date);
                    measure.setUpdateDate(date);
                    addNewList.add(measure);
                }
                if (isHaveNewReform) {
                    ReformAddParam param = new ReformAddParam();
                    param.setCid(reformItemBasic.getCid());
                    param.setFinderName(reformItemBasic.getFinderName());
                    param.setFindTime(reformItemBasic.getLastUpdate());
                    param.setName(reformItemBasic.getName());
                    param.setReformItemSource(ReformSourceLiteEnum.ZYBWHYSJC.getValue());
                    param.setReformItemSourceId(reformItemBasic.getReformItemSourceId());
                    param.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
                    param.setDescription(reformItemBasic.getDescription());
                    reformAddParamList.add(param);
                    continue;
                }
                for (ReformCheckMeasure measure : checkMeasureList) {
                    if (measure == null || measure.getChangeTime().equals(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()))) continue;
                    ReformCheckMeasure updateMeasure = new ReformCheckMeasure();
                    updateMeasure.setId(measure.getId());
                    updateMeasure.setChangeTime(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()));
                    if (measure.getUpdateDate() != null) {
                        updateMeasure.setUpdateDate(measure.getUpdateDate());
                    } else {
                        updateMeasure.setUpdateDate(date);
                    }
                    updateChangeTimeList.add(updateMeasure);
                }
                continue;
            }
            for (ReformCheckMeasure measure : checkMeasureList) {
                if (measure == null) continue;
                if (!measure.getChangeTime().equals(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()))) {
                    ReformCheckMeasure updateMeasure = new ReformCheckMeasure();
                    updateMeasure.setId(measure.getId());
                    updateMeasure.setChangeTime(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()));
                    updateMeasure.setUpdateDate(date);
                    updateChangeTimeList.add(updateMeasure);
                }
                if (Arrays.asList(2, 3).contains(measure.getSituation())) continue;
                String name = measure.getPointName() + measure.getFactoryName();
                RiskExposeEvaluateData evaluateData = (RiskExposeEvaluateData)stringRiskMap.get(name);
                if (evaluateData == null) {
                    measure.setSituation(Integer.valueOf(3));
                    measure.setUpdateDate(date);
                    measure.setUpdateBy(Long.valueOf(1L));
                    updateList.add(measure);
                    continue;
                }
                if (evaluateData.getCheckTouchLevel() == 1) continue;
                measure.setSituation(Integer.valueOf(2));
                measure.setUpdateDate(date);
                measure.setUpdateBy(Long.valueOf(1L));
                updateList.add(measure);
            }
            for (RiskExposeEvaluateData evaluateData : dataList) {
                String pointName;
                String name;
                ReformCheckMeasure checkMeasure;
                if (evaluateData == null || evaluateData.getCheckTouchLevel() != 1 || (checkMeasure = (ReformCheckMeasure)stringMeasureMap.get(name = (pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint()) + evaluateData.getFactorName())) != null) continue;
                ReformCheckMeasure measure = new ReformCheckMeasure();
                measure.setId(Long.valueOf(this.idworker.nextId()));
                measure.setCid(reformItemBasic.getCid());
                measure.setCheckId(reformItemBasic.getReformItemSourceId());
                measure.setChangeTime(DateUtil.getFromDate((Date)reformItemBasic.getLastUpdate()));
                measure.setReformId(reformItemBasic.getId());
                measure.setAcceptRecordId(reformItemBasic.getAccLastId());
                measure.setFactoryName(evaluateData.getFactorName());
                measure.setPointName(pointName);
                measure.setSituation(Integer.valueOf(0));
                measure.setCreateDate(date);
                measure.setUpdateDate(date);
                addList.add(measure);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(updateList)) {
            this.acceptanceRecordService.updateBatchReformCheckMeasure(updateList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u667a\u80fd\u5904\u7f6e\u5c0f\u9879\u6570\u91cf\uff1a" + updateList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(updateList.stream().filter(item -> item != null && item.getReformId() != null).map(ReformCheckMeasure::getReformId).limit(10L).toList())), (Object[])new Object[0]);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(updateChangeTimeList)) {
            this.acceptanceRecordService.updateBatchReformCheckMeasure(updateChangeTimeList);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(reformAddParamList)) {
            this.generateReform(new ArrayList<ReformAddParam>(reformAddParamList));
            Map acceptIdMap = ((ReformItemBasicNewMapper)this.dao).getReformItemBasicIdListBySourceId(reformAddParamList.stream().filter(Objects::nonNull).map(ReformAddParam::getReformItemSourceId).collect(Collectors.toList())).stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemBasic::getReformItemSourceId, Function.identity(), (ol, ne) -> ol));
            for (ReformCheckMeasure measure : addNewList) {
                if (measure == null) continue;
                ReformItemBasic basic3 = (ReformItemBasic)acceptIdMap.get(measure.getCheckId());
                if (basic3 == null) {
                    XxlJobHelper.log((String)("\u5904\u7406\u9700\u8981\u65b0\u751f\u6210\u4e00\u4efd\u8d85\u6807\u7684\u98ce\u9669\u5f02\u5e38\uff1a\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6574\u6539\u5355" + measure.getId()), (Object[])new Object[0]);
                    throw new RuntimeException("\u5904\u7406\u9700\u8981\u65b0\u751f\u6210\u4e00\u4efd\u8d85\u6807\u7684\u98ce\u9669\u5f02\u5e38\uff1a\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6574\u6539\u5355" + measure.getId());
                }
                measure.setReformId(basic3.getId());
                measure.setAcceptRecordId(basic3.getAccLastId());
            }
            addList.addAll(addNewList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u6709\u5df2\u5ba1\u6838\u989d\u5916\u518d\u751f\u6210\u7684\u6570\u91cf\uff1a" + reformAddParamList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(reformAddParamList.stream().filter(Objects::nonNull).map(ReformAddParam::getReformItemSourceId).limit(10L).toList())), (Object[])new Object[0]);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(addList)) {
            this.acceptanceRecordService.saveBatchReformCheckMeasure(addList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u6709\u65b0\u589e\u5c0f\u9879\u7684\u6570\u91cf\uff1a" + addList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(addList.stream().filter(Objects::nonNull).map(ReformCheckMeasure::getCheckId).distinct().limit(10L).toList())), (Object[])new Object[0]);
        }
    }

    private void backJCCBReform(ReformItemBasic entity, ReformItemAcceptanceRecord acc, ReformItemAcceptanceRecord backNewAcc, Long loginStaffId) {
        List checkMeasureList = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setAcceptRecordId(acc.getId()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)checkMeasureList)) {
            return;
        }
        boolean isOld = checkMeasureList.stream().allMatch(item -> item != null && item.getCheckId() == null);
        if (!isOld) {
            for (ReformCheckMeasure checkMeasure : checkMeasureList) {
                checkMeasure.setId(Long.valueOf(this.idworker.nextId()));
                checkMeasure.setAcceptRecordId(backNewAcc.getId());
                checkMeasure.setUpdateDate(new Date());
                checkMeasure.setCreateDate(new Date());
                checkMeasure.setUpdateBy(loginStaffId);
                checkMeasure.setCreateBy(loginStaffId);
            }
            this.acceptanceRecordService.insertReformCheckMeasureList(checkMeasureList);
            return;
        }
        List<CheckPlan> checkList = ((ReformItemBasicNewMapper)this.dao).getNotConvertToReformByRiskData(null, Collections.singletonList(entity.getReformItemSourceId()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(checkList) || checkList.get(0) == null || checkList.get(0).getRiskExposeEvaluateId() == null) {
            throw new RuntimeException("\u5386\u53f2\u6570\u636e\u9000\u56de\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d85\u6807\u68c0\u6d4b\u6570\u636e");
        }
        CheckPlan check = checkList.get(0);
        List<RiskExposeEvaluateData> list = ((ReformItemBasicNewMapper)this.dao).getEvaluateDataList(Collections.singletonList(check.getRiskExposeEvaluateId()), true);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
            throw new RuntimeException("\u5386\u53f2\u6570\u636e\u9000\u56de\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d85\u6807\u68c0\u6d4b\u6570\u636e");
        }
        ArrayList<ReformCheckMeasure> addList = new ArrayList<ReformCheckMeasure>();
        for (RiskExposeEvaluateData evaluateData : list) {
            ReformCheckMeasure measure = new ReformCheckMeasure();
            measure.setId(Long.valueOf(this.idworker.nextId()));
            measure.setCid(entity.getCid());
            measure.setCheckId(check.getId());
            measure.setChangeTime(check.getUpdateDate());
            measure.setReformId(entity.getId());
            measure.setAcceptRecordId(backNewAcc.getId());
            measure.setFactoryName(evaluateData.getFactorName());
            String pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint();
            measure.setPointName(pointName);
            measure.setSituation(Integer.valueOf(0));
            measure.setCreateDate(new Date());
            measure.setUpdateDate(new Date());
            addList.add(measure);
        }
        this.acceptanceRecordService.insertReformCheckMeasureList(addList);
    }

    @Transactional
    public void autoAddReformByCheckChild(String cids) {
        this.logger.info("\u751f\u6210\u73b0\u72b6\u5b9a\u671f\u6574\u6539\u5f00\u59cb");
        XxlJobHelper.log((String)"\u751f\u6210\u73b0\u72b6\u5b9a\u671f\u6574\u6539\u5f00\u59cb", (Object[])new Object[0]);
        List<String> needAddCidList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)cids)) {
            needAddCidList = Arrays.stream(cids.split(",")).collect(Collectors.toList());
        }
        List<Long> allCidList = ((ReformItemBasicNewMapper)this.dao).getOccTypeFromCompanyGradeV3rec(needAddCidList);
        int num = 0;
        List split = ListUtils.split(allCidList, (int)10000);
        int i = 0;
        while (i < split.size()) {
            List cidList = (List)split.get(i);
            Integer integer3 = this.divideBatchGenKeyReform(cidList, ReformGenerationSourceEnum.DETECTION_ITEM3.getValue(), currYear, ReformDataSourceEnum.WDC.getValue());
            num += integer3.intValue();
            XxlJobHelper.log((String)("\u751f\u6210\u73b0\u72b6\u5b9a\u671f\u6574\u6539\u8fdb\u884c\u4e2d,\u8fdb\u5ea6:" + split.size() + "/" + ++i), (Object[])new Object[0]);
        }
        this.logger.info("\u751f\u6210\u73b0\u72b6\u5b9a\u671f\u6574\u6539\u7ed3\u675f,\u6570\u91cf\u4e3a{}", (Object)num);
        XxlJobHelper.log((String)"\u751f\u6210\u73b0\u72b6\u5b9a\u671f\u6574\u6539\u7ed3\u675f,\u6570\u91cf\u4e3a{}", (Object[])new Object[]{num});
    }

    @Transactional
    public void autoAddReformByPhy(Boolean isNotPush, String cids, String dateStr) {
        List cidList = StringUtils.parseToLongList((String)cids);
        List<String> tjIds = ((ReformItemBasicNewMapper)this.dao).getExistTjId(cidList);
        List<Object> list = ((ReformItemBasicNewMapper)this.dao).getListByConclusions(tjIds, cidList, dateStr);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        list = list.stream().filter(item -> item != null && !pilotAndNewCompanyList.contains(item.getCid())).collect(Collectors.toList());
        List ysZybList = list.stream().filter(item -> item != null && item.getCardId() != null).collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getCardId, item -> item, (item1, item2) -> item1.getCreateDate().after(item2.getCreateDate()) ? item1 : item2)).values().stream().collect(Collectors.toList());
        if (!Objects.equals(list.size(), ysZybList.size())) {
            list.removeAll(ysZybList);
            XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u5b58\u5728\u91cd\u590dcardId:" + String.valueOf(list)), (Object[])new Object[0]);
        }
        XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u98ce\u9669\u6570\u91cf\u4e3a\uff1a" + ysZybList.size()), (Object[])new Object[0]);
        List infoCidList = ysZybList.stream().filter(Objects::nonNull).map(PhcPhysicalStaffCheckInfo::getCid).distinct().collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(infoCidList) && infoCidList.size() < 5000) {
            XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u4f01\u4e1a\u6570\u91cf\u4e3a\uff1a" + String.valueOf(infoCidList)), (Object[])new Object[0]);
        }
        if (isNotPush.booleanValue()) {
            return;
        }
        List orgCodeList = ysZybList.stream().map(PhcPhysicalStaffCheckInfo::getOrgCode).filter(StringUtils::isNumber).distinct().collect(Collectors.toList());
        Map thirdOrganizationMap = this.thirdOrganizationService.getMapByCreditCode(orgCodeList);
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        List addList = ysZybList.stream().map(b -> {
            ReformAddParam addParam = new ReformAddParam();
            addParam.setGenerationSource(PhyPhcCheckConclusionEnum.YSZYB.getCode().toString().equalsIgnoreCase(b.getConclusion()) ? ReformGenerationSourceEnum.YSZYB.getValue() : ReformGenerationSourceEnum.JJZ.getValue());
            addParam.setReformItemSourceId(b.getSourceId());
            addParam.setReformMeasure(null);
            String orgName = b.getOrgCode();
            if (StringUtils.isNumber((String)b.getOrgCode())) {
                ThirdOrganization thirdOrganization = (ThirdOrganization)thirdOrganizationMap.get(b.getOrgCode());
                orgName = thirdOrganization != null ? thirdOrganization.getName() : null;
            }
            addParam.setFinderName(orgName);
            addParam.setName(this.setBusinessName((PhcPhysicalStaffCheckInfo)b, b.getCheckYear(), jobMap, bodyCheckTypeMap));
            addParam.setFindTime(b.getCreateDate());
            addParam.setCid(b.getCid());
            addParam.setReformItemSource(ReformSourceLiteEnum.ZYJKTJ.getValue());
            addParam.setDataSource(Byte.valueOf((byte)1));
            addParam.setTjBusinessId(b.getCardId());
            return addParam;
        }).collect(Collectors.toList());
        ListUtils.split(addList, (int)5000).forEach(this::generateReform);
    }

    private String setBusinessName(PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo, Integer year, Map<String, String> jobMap, Map<String, String> bodyCheckTypeMap) {
        Object businessName = String.valueOf(year);
        String workName = "";
        workName = !"99-9999".equals(phcPhysicalStaffCheckInfo.getJobCode()) ? jobMap.get(phcPhysicalStaffCheckInfo.getJobCode()) : phcPhysicalStaffCheckInfo.getOtherJobName();
        if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop()) && StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop() + "/" + workName;
        } else if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop())) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop();
        } else if (StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + workName;
        }
        String conclusionStr = "";
        if ("3".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u7591\u4f3c\u804c\u4e1a\u75c5";
        } else if ("4".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u804c\u4e1a\u7981\u5fcc\u8bc1";
        }
        businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getName() + "-" + bodyCheckTypeMap.get(phcPhysicalStaffCheckInfo.getBodyCheckType()) + "-" + conclusionStr;
        return businessName;
    }

    @Transactional(readOnly=false)
    public ReformItemBasic saveOrSubmitReform(ReformItemBasic entity, Long loginStaffId) {
        ReformItemBasic basicDb;
        ReformItemAcceptanceRecord acc = entity.getAcceptance();
        Date currTime = new Date();
        if (entity.getStatus() != null && (entity.getStatus().intValue() == 2 || entity.getStatus().intValue() == 4)) {
            acc.setReformMeasure(StringEscapeUtils.unescapeHtml((String)acc.getReformMeasure()));
            acc.setStatus(ReformAcceptanceRecordStatusEnum.DSH.getValue());
            acc.setActualFinishTime(currTime);
            Date date = DateUtils.addMonth((Date)acc.getActualFinishTime(), (int)1);
            entity.setRequireAcceptanceTime(date);
            if (entity.getStatus().intValue() == 4) {
                acc.setStatus(ReformAcceptanceRecordStatusEnum.WXZG.getValue());
            }
        }
        if (entity.getStatus() != null && (entity.getStatus().intValue() == 3 || entity.getStatus().intValue() == 5)) {
            acc.setAcceptanceDate(currTime);
            acc.setStatus(ReformAcceptanceRecordStatusEnum.WC.getValue());
            if (entity.getStatus().intValue() == 3) {
                entity.setStatus(ReformStatusEnum.WC.getValue());
                acc.setAcceptanceResult(AcceptanceResultEnum.complete.getValue());
                this.refreshService.addBusinessDataUpdateMsg(entity.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE02, ComplianceCodeEnum.CODE08});
                if (entity.getId().equals(4558160632038400L)) {
                    ((ReformItemBasicNewMapper)this.dao).updateSpecialBxFxhj();
                }
            }
            if (entity.getStatus().intValue() == 5) {
                entity.setStatus(ReformStatusEnum.TH.getValue());
                acc.setAcceptanceResult(AcceptanceResultEnum.unComplete.getValue());
                ReformItemAcceptanceRecord backNewAcc = new ReformItemAcceptanceRecord();
                backNewAcc.setRequireFinishTime(entity.getAcceptance().getRequireFinishTime());
                backNewAcc.setReformItemId(entity.getId());
                backNewAcc.setCid(entity.getCid());
                this.acceptanceRecordService.add((Object)backNewAcc, entity.getUpdateBy(), entity.getCid());
                backNewAcc.setReformDirectorName(SpringEncryptUtils.decrypt((String)backNewAcc.getReformDirectorName()));
                backNewAcc.setAcceptanceDirectorName(SpringEncryptUtils.decrypt((String)backNewAcc.getAcceptanceDirectorName()));
                backNewAcc.setReformCollaboratorName(SpringEncryptUtils.decrypt((String)backNewAcc.getReformCollaboratorName()));
                backNewAcc.setAcceptanceCollaboratorName(SpringEncryptUtils.decrypt((String)backNewAcc.getAcceptanceCollaboratorName()));
                if (entity.getGenerationSource() != null && entity.getGenerationSource() == 3) {
                    this.backJCCBReform(entity, acc, backNewAcc, loginStaffId);
                }
            }
        }
        this.acceptanceRecordService.update((Object)acc, loginStaffId);
        acc.setReformDirectorName(SpringEncryptUtils.decrypt((String)acc.getReformDirectorName()));
        acc.setAcceptanceDirectorName(SpringEncryptUtils.decrypt((String)acc.getAcceptanceDirectorName()));
        acc.setReformCollaboratorName(SpringEncryptUtils.decrypt((String)acc.getReformCollaboratorName()));
        acc.setAcceptanceCollaboratorName(SpringEncryptUtils.decrypt((String)acc.getAcceptanceCollaboratorName()));
        entity.setActualFinishTime(acc.getActualFinishTime());
        entity.setReformDirectorName(acc.getReformDirectorName());
        entity.setAcceptanceDate(acc.getAcceptanceDate());
        entity.setAcceptanceDirectorName(acc.getAcceptanceDirectorName());
        if (entity.getStatus() != null && entity.getStatus().intValue() == 5) {
            entity.setActualFinishTime(null);
            entity.setReformDirectorName(null);
            entity.setAcceptanceDate(null);
            entity.setAcceptanceDirectorName(null);
        }
        if (Objects.equals(entity.getStatus(), ReformStatusEnum.CG.getValue()) && Objects.equals((basicDb = (ReformItemBasic)this.getById(entity.getId())).getStatus(), ReformStatusEnum.TH.getValue())) {
            entity.setStatus(ReformStatusEnum.TH.getValue());
        }
        this.update(entity, loginStaffId);
        List sourceList = this.itemSourceService.getSourceListByBasicId(Collections.singletonList(entity.getId()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)sourceList)) {
            return entity;
        }
        for (ReformItemSource source : sourceList) {
            if (source == null) continue;
            source.setReformItemFiles(entity.getReformItemFiles());
            source.setRequireAcceptanceTime(entity.getRequireAcceptanceTime());
            source.setStatus(entity.getStatus());
            source.setUpdateBy(loginStaffId);
            source.setUpdateDate(currTime);
            source.setActualFinishTime(entity.getActualFinishTime());
            source.setReformDirectorName(entity.getReformDirectorName());
            source.setAcceptanceDate(entity.getAcceptanceDate());
            source.setAcceptanceDirectorName(entity.getAcceptanceDirectorName());
        }
        this.itemSourceService.batchUpdateOrInsert(sourceList, ReformItemSourceMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        if (entity.getStatus() != null && entity.getStatus().intValue() == 3) {
            this.changeStatusByCidAndGenerationSource(entity.getCid(), ReformGenerationSourceEnum.ARCHIVES.getValue(), null, loginStaffId, null);
            if (entity.getGenerationSource().intValue() == 23) {
                this.autoAddReformByCheckChild(entity.getCid().toString());
            }
        }
        return entity;
    }

    @Transactional
    public void autoAcceptance(String cids) {
        this.logger.info("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        StringBuilder info = new StringBuilder();
        List needAcceptCidList = StringUtils.parseToStringList((String)cids, (String)",");
        List<Long> cidList = ((ReformItemBasicNewMapper)this.dao).getAllCompanyId(needAcceptCidList, false, false);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        List excludePilotAndNewCompanyList = cidList.stream().filter(cid -> cid != null && !pilotAndNewCompanyList.contains(cid)).collect(Collectors.toList());
        ArrayList<Byte> generationSourceValue = new ArrayList<Byte>(ReformGenerationSourceEnum.getEightGenerationSourceValue());
        generationSourceValue.add(ReformGenerationSourceEnum.DETECTION_ITEM2.getValue());
        generationSourceValue.add(ReformGenerationSourceEnum.DETECTION_ITEM3.getValue());
        for (Byte generationSource : generationSourceValue) {
            int num = 0;
            if (generationSource == 22 || generationSource == 23) {
                for (List list : ListUtils.split(cidList, (int)20000)) {
                    reformItemBasicList = this.acceptDivide(list, generationSource, currYear);
                    num += reformItemBasicList.size();
                }
            } else {
                for (List list : ListUtils.split(excludePilotAndNewCompanyList, (int)20000)) {
                    reformItemBasicList = this.acceptDivide(list, generationSource, currYear);
                    num += reformItemBasicList.size();
                }
            }
            info.append(",\u9a8c\u6536\u6574\u6539\u9879").append(generationSource).append("\u6570\u91cf:").append(num);
        }
        this.logger.info("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f{}", (Object)info);
        XxlJobHelper.log((String)info.toString(), (Object[])new Object[0]);
    }

    @Transactional(readOnly=false)
    public List<ReformItemBasic> acceptDivide(List<Long> cidList, Byte generationSource, Integer year) {
        List<ReformItemBasic> notAcceptReformList;
        List<Long> notAcceptCidList;
        List<Integer> generationSources = Collections.singletonList(generationSource.intValue());
        if (ReformGenerationSourceEnum.TRAIN.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOZYFZR.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOGLRY.getValue().equals(generationSource)) {
            generationSources = Arrays.asList(ReformGenerationSourceEnum.TRAIN.getValue().intValue(), ReformGenerationSourceEnum.NOZYFZR.getValue().intValue(), ReformGenerationSourceEnum.NOGLRY.getValue().intValue());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(notAcceptCidList = (notAcceptReformList = ((ReformItemBasicNewMapper)this.dao).getNotAcceptanceList(cidList, generationSources, year)).parallelStream().filter(Objects::nonNull).map(ReformItemBasic::getCid).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        HashMap<Long, String> msgType = new HashMap<Long, String>();
        List<Object> needAcceptReformList = new ArrayList<ReformItemBasic>();
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case DECLARE: {
                List<Long> isSuperviseList = ((ReformItemBasicNewMapper)this.dao).getIsSuperviseCom(notAcceptCidList);
                Map<Long, WandaDeclare> wandaDeclareMap = ((ReformItemBasicNewMapper)this.dao).getDeclareMapByCid(notAcceptCidList);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    WandaDeclare wandaDeclare = (WandaDeclare)wandaDeclareMap.get(cid);
                    if (isSuperviseList.contains(cid)) {
                        String msg = format.format(new Date()) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (wandaDeclare != null) {
                        String msg = format.format(wandaDeclare.getDeclareTime()) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case TJ: {
                Set unCompletedFangShangCidList1 = (Set)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList1", 300L, () -> ((ReformItemBasicNewMapper)this.dao).getUnCompletedFangShangCidList(null, 1, effectiveDateStr));
                Map<Long, PhcPhysicalCheckV3221> physicalCheckMap = ((ReformItemBasicNewMapper)this.dao).getPhysicalCompletedMap(notAcceptCidList, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    PhcPhysicalCheckV3221 phcPhysicalCheckV3221 = (PhcPhysicalCheckV3221)physicalCheckMap.get(cid);
                    if (phcPhysicalCheckV3221 != null) {
                        if (unCompletedFangShangCidList1.contains(cid)) {
                            return false;
                        }
                        String msg = format.format(phcPhysicalCheckV3221.getCheckTime()) + "\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case DETECTION: {
                Set unCompletedFangShangCidList2 = (Set)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList2", 300L, () -> ((ReformItemBasicNewMapper)this.dao).getUnCompletedFangShangCidList(null, 2, effectiveDateStr));
                Map<Long, CheckPlan> checkPlanMap = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedMap(notAcceptCidList, effectiveDateStr, null, "threeYear");
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CheckPlan check = (CheckPlan)checkPlanMap.get(cid);
                    if (check != null) {
                        if (unCompletedFangShangCidList2.contains(cid)) {
                            return false;
                        }
                        String msg = check.getCheckDateBegin().getYear() + "\u5e74" + check.getCheckDateBegin().getMonthValue() + "\u6708" + check.getCheckDateBegin().getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case GRJL: {
                break;
            }
            case TRAIN: 
            case NOZYFZR: 
            case NOGLRY: {
                Map<Long, CertificateStaffDetail> trainZCompletedMap = ((ReformItemBasicNewMapper)this.dao).getTrainCompletedMap(notAcceptCidList, 12, effectiveDateStr);
                Map<Long, CertificateStaffDetail> trainMCompletedMap = ((ReformItemBasicNewMapper)this.dao).getTrainCompletedMap(notAcceptCidList, 13, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CertificateStaffDetail zTrain = (CertificateStaffDetail)trainZCompletedMap.get(cid);
                    CertificateStaffDetail mTrain = (CertificateStaffDetail)trainMCompletedMap.get(cid);
                    if (ReformGenerationSourceEnum.TRAIN.getValue().equals(item.getGenerationSource()) && (zTrain != null || mTrain != null)) {
                        Object msg = "";
                        if (zTrain != null) {
                            msg = format.format(zTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad,";
                        }
                        if (mTrain != null) {
                            msg = (String)msg + format.format(mTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        }
                        msgType.put(cid, (String)msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOZYFZR.getValue().equals(item.getGenerationSource()) && zTrain != null) {
                        String msg = format.format(zTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOGLRY.getValue().equals(item.getGenerationSource()) && mTrain != null) {
                        String msg = format.format(mTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case THREE_TIME: {
                Set<Long> threeTimeNoCompletedSet = ((ReformItemBasicNewMapper)this.dao).getThreeSimultaneousNoCompleted(notAcceptCidList, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)threeTimeNoCompletedSet) || !threeTimeNoCompletedSet.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case PROTECTION: {
                Set<Long> protectEquipCompletedList = ((ReformItemBasicNewMapper)this.dao).getProtectEquipCompleted(notAcceptCidList, year);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)protectEquipCompletedList) && protectEquipCompletedList.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case WARNING_SIGNS: {
                Set<Long> warnSignManageCompleted = ((ReformItemBasicNewMapper)this.dao).getWarnSignManageCompleted(notAcceptCidList, effectiveDateStr);
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)warnSignManageCompleted) && warnSignManageCompleted.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case ARCHIVES: {
                Set healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(notAcceptCidList, year).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)healthManageFilesCompletedList) && healthManageFilesCompletedList.contains(cid)) {
                        String msg = "\u81ea\u52a8\u9a8c\u6536";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case DETECTION_ITEM3: {
                Map<Long, CheckPlan> checkPlan3Map = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedMap(notAcceptCidList, effectiveDateStr, Collections.singletonList(3), "threeYear");
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CheckPlan check = (CheckPlan)checkPlan3Map.get(cid);
                    if (check != null) {
                        String msg = check.getCheckDateBegin().getYear() + "\u5e74" + check.getCheckDateBegin().getMonthValue() + "\u6708" + check.getCheckDateBegin().getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u73b0\u72b6\u8bc4\u4ef7\u68c0\u6d4b";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(needAcceptReformList)) break;
                String cidStr = needAcceptReformList.stream().filter(item -> item != null && item.getCid() != null).map(ReformItemBasic::getCid).map(String::valueOf).collect(Collectors.joining(","));
                this.autoAddReformByCheckChild(cidStr);
                break;
            }
            case DETECTION_ITEM2: {
                Map<Long, CheckPlan> checkPlan2Map = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedMap(notAcceptCidList, effectiveDateStr, Collections.singletonList(2), "one");
                Map<Long, CheckPlan> checkPlan3OneYearMap = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedMap(notAcceptCidList, effectiveDateStr, Collections.singletonList(3), "one");
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    CheckPlan check = (CheckPlan)checkPlan2Map.get(cid);
                    if (check != null) {
                        String msg = check.getCheckDateBegin().getYear() + "\u5e74" + check.getCheckDateBegin().getMonthValue() + "\u6708" + check.getCheckDateBegin().getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u5b9a\u671f\u68c0\u6d4b";
                        msgType.put(cid, msg);
                        return true;
                    }
                    CheckPlan check2 = (CheckPlan)checkPlan3OneYearMap.get(cid);
                    if (check2 != null) {
                        String msg = check2.getCheckDateBegin().getYear() + "\u5e74" + check2.getCheckDateBegin().getMonthValue() + "\u6708" + check2.getCheckDateBegin().getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u73b0\u72b6\u8bc4\u4ef7\u68c0\u6d4b";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
        }
        this.makeAndUpdateReform(needAcceptReformList, msgType, (byte)3, null);
        return needAcceptReformList;
    }

    public List<ReformItemBasic> makeAndUpdateReform(List<ReformItemBasic> needAcceptReformList, Map<Long, String> msgType, Byte status, Long loginStaffId) {
        Date date = new Date();
        if (status == -1) {
            return null;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(needAcceptReformList)) {
            return Collections.emptyList();
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(needAcceptReformList = needAcceptReformList.stream().filter(item -> item != null && !item.getStatus().equals(status)).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        List collect1 = needAcceptReformList.stream().map(ReformItemBasic::getId).collect(Collectors.toList());
        List sourceList = this.itemSourceService.getSourceListByBasicId(collect1);
        List accListByReformItemIds = this.acceptanceRecordService.getListByReformItemIds(new HashSet(collect1));
        Map collect = accListByReformItemIds.stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemAcceptanceRecord::getReformItemId, Function.identity(), (a, b) -> a.getCreateDate().getTime() >= b.getCreateDate().getTime() ? a : b));
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>(collect.values());
        needAcceptReformList.forEach(item -> {
            if (item == null) {
                return;
            }
            ReformItemAcceptanceRecord record = (ReformItemAcceptanceRecord)collect.get(item.getId());
            item.setStatus(status);
            item.setUpdateDate(date);
            if (loginStaffId != null) {
                item.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 0 || status.intValue() == 1 || status.intValue() == 5) {
                item.setActualFinishTime(null);
                item.setAcceptanceDate(null);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 2) {
                item.setActualFinishTime(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDate(null);
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                item.setActualFinishTime(date);
                item.setAcceptanceDate(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                    item.setAcceptanceDirectorName(record.getAcceptanceDirectorName());
                }
            }
        });
        sourceList.forEach(item -> {
            if (item == null) {
                return;
            }
            ReformItemAcceptanceRecord record = (ReformItemAcceptanceRecord)collect.get(item.getReformItemId());
            item.setStatus(status);
            item.setUpdateDate(date);
            if (loginStaffId != null) {
                item.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 0 || status.intValue() == 1 || status.intValue() == 5) {
                item.setActualFinishTime(null);
                item.setAcceptanceDate(null);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 2) {
                item.setActualFinishTime(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDate(null);
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                item.setActualFinishTime(date);
                item.setAcceptanceDate(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                    item.setAcceptanceDirectorName(record.getAcceptanceDirectorName());
                }
            }
        });
        accList.forEach(acceptance -> {
            if (acceptance == null) {
                return;
            }
            acceptance.setUpdateDate(date);
            if (loginStaffId != null) {
                acceptance.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                acceptance.setAcceptanceDirectorName("\u81ea\u52a8\u9a8c\u6536");
                acceptance.setActualFinishTime(date);
                acceptance.setAcceptanceDate(date);
                acceptance.setAcceptanceResult(Byte.valueOf((byte)1));
                acceptance.setAcceptanceResultExplain("\u5df2\u9a8c\u6536");
                acceptance.setStatus(Byte.valueOf((byte)3));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Map)msgType)) {
                    acceptance.setReformMeasure((String)(acceptance.getReformMeasure() != null ? acceptance.getReformMeasure() + "\n" : "") + (String)msgType.get(acceptance.getCid()));
                } else {
                    acceptance.setReformMeasure((String)(acceptance.getReformMeasure() != null ? acceptance.getReformMeasure() + "\n" : ""));
                }
            }
            if (status.intValue() == 2) {
                acceptance.setActualFinishTime(date);
                acceptance.setAcceptanceDirectorName(null);
                acceptance.setAcceptanceDate(null);
                acceptance.setStatus(Byte.valueOf((byte)1));
            }
            if (status.intValue() == 5) {
                acceptance.setActualFinishTime(null);
                acceptance.setAcceptanceDirectorName(null);
                acceptance.setAcceptanceDate(null);
                acceptance.setStatus(Byte.valueOf((byte)0));
            }
        });
        try {
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(needAcceptReformList)) {
                this.batchUpdateOrInsert(needAcceptReformList, ReformItemBasicMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)sourceList)) {
                this.itemSourceService.batchUpdateOrInsert(sourceList, ReformItemSourceMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(accList)) {
                this.acceptanceRecordService.batchUpdateOrInsert(accList, ReformItemAcceptanceRecordMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            return needAcceptReformList;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5931\u8d25\uff1a\u4f01\u4e1aID\u4e3a\uff1a" + needAcceptReformList.toString());
            return needAcceptReformList;
        }
    }

    @Transactional
    public void autoGenKeyFactorReform(String cids) {
        List needAddCidList = StringUtils.parseToStringList((String)cids, (String)",");
        this.autoGenKeyFactorReform(needAddCidList);
        this.autoAddReformByCheckChild(cids);
        this.onlyFileAcceptReformAfterTwoMonth(cids);
    }

    public void autoGenKeyFactorReform(List<String> needAddCidList) {
        this.logger.info("\u751f\u6210\u6574\u6539\u5f00\u59cb");
        XxlJobHelper.log((String)"\u751f\u6210\u6574\u6539\u5f00\u59cb", (Object[])new Object[0]);
        StringBuilder info = new StringBuilder();
        List<Long> cidList = new Date().getTime() < DateUtils.parseDate((Object)effectiveDateStr).getTime() ? ((ReformItemBasicNewMapper)this.dao).getAllCompanyId(needAddCidList, true, false) : ((ReformItemBasicNewMapper)this.dao).getAllCompanyId(needAddCidList, false, true);
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(cidList);
        cidList.removeAll(pilotAndNewCompanyList);
        List<Long> alreadyCidList = ((ReformItemBasicNewMapper)this.dao).getAlreadyGenerationSourceRisk(cidList, currYear);
        List needGenerateCidList = cidList.stream().filter(Objects::nonNull).filter(item -> !alreadyCidList.contains(item)).collect(Collectors.toList());
        for (Byte generationSource : ReformGenerationSourceEnum.getEightGenerationSourceValue()) {
            if (generationSource == 19 || generationSource == 20) continue;
            List<Long> currList = generationSource.equals(ReformGenerationSourceEnum.THREE_TIME.getValue()) || generationSource.equals(ReformGenerationSourceEnum.GRJL.getValue()) ? cidList : needGenerateCidList;
            int num = 0;
            List split = ListUtils.split(currList, (int)10000);
            int i = 0;
            while (i < split.size()) {
                List list = (List)split.get(i);
                Integer integer = this.divideBatchGenKeyReform(list, generationSource, currYear, ReformDataSourceEnum.KEYFACTORY.getValue());
                num += integer.intValue();
                XxlJobHelper.log((String)("\u7c7b\u578b:" + generationSource + ",\u8fdb\u5ea6:" + split.size() + "/" + ++i), (Object[])new Object[0]);
            }
            info.append(",\u751f\u6210\u6574\u6539\u9879").append(generationSource).append("\u6570\u91cf:").append(num);
        }
        this.logger.info("\u751f\u6210\u6574\u6539\u7ed3\u675f{}", (Object)info);
        XxlJobHelper.log((String)"\u751f\u6210\u6574\u6539\u7ed3\u675f{}", (Object[])new Object[]{info});
        List<Long> gamaCids = ((ReformItemBasicNewMapper)this.dao).getGaMaCompanyCid(cidList);
        gamaCids.removeAll(pilotAndNewCompanyList);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(gamaCids)) {
            if (new Date().getTime() < DateUtils.parseDate((Object)"2025-09-01 00:00:00").getTime()) {
                Integer num1 = ((ReformItemBasicNewMapper)this.dao).updateGaMaReform(gamaCids, "reform_item_basic", 1);
                Integer num2 = ((ReformItemBasicNewMapper)this.dao).updateGaMaReform(gamaCids, "reform_item_source", 1);
                XxlJobHelper.log((String)"\u66f4\u65b0\u4f3d\u9a6c\u98ce\u9669\u5b8c\u6210\u6570\u91cf{}", (Object[])new Object[]{num1 + num2});
            } else {
                Integer num3 = ((ReformItemBasicNewMapper)this.dao).updateGaMaReform(gamaCids, "reform_item_basic", 2);
                Integer num4 = ((ReformItemBasicNewMapper)this.dao).updateGaMaReform(gamaCids, "reform_item_source", 2);
                XxlJobHelper.log((String)"\u66f4\u65b0\u4f3d\u9a6c\u98ce\u9669\u5b8c\u6210\u6570\u91cf{}", (Object[])new Object[]{num3 + num4});
            }
        }
    }

    @Transactional
    public Integer divideBatchGenKeyReform(List<Long> cidList, Byte generationSource, Integer year, Byte dataSource) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList) || generationSource == null || year == null) {
            return 0;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        ArrayList<ReformAddParam> addParamList = new ArrayList<ReformAddParam>();
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case DECLARE: {
                Set<Long> declareNoCompletedList = ((ReformItemBasicNewMapper)this.dao).getDeclareNoCompletedList(cidList);
                Set<Long> declareCompletedByReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(12), year, true);
                declareNoCompletedList.removeAll(declareCompletedByReformList);
                declareNoCompletedList.forEach(cid -> {
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.DECLARE.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case TJ: {
                Set<Long> physicalCompletedList = ((ReformItemBasicNewMapper)this.dao).getPhysicalCompletedList(cidList, effectiveDateStr);
                physicalCompletedList.add(99657571579381950L);
                physicalCompletedList.add(4927705139843381788L);
                Set unCompletedFangShangCidList1 = (Set)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList1", 300L, () -> ((ReformItemBasicNewMapper)this.dao).getUnCompletedFangShangCidList(null, 1, effectiveDateStr));
                physicalCompletedList.removeAll(unCompletedFangShangCidList1);
                Set<Long> physicalCompletedByReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(10), year, true);
                physicalCompletedList.addAll(physicalCompletedByReformList);
                Map<Long, PhcPhysicalCheckV3221> physicalOverDuelMap = ((ReformItemBasicNewMapper)this.dao).getPhysicalOverDueMap(cidList, effectiveDateStr, overDateStr);
                cidList.forEach(cid -> {
                    Object descriptionMore = "";
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)physicalCompletedList) || !physicalCompletedList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                        if (!physicalOverDuelMap.isEmpty() && physicalOverDuelMap.containsKey(cid) && physicalOverDuelMap.get(cid) != null && ((PhcPhysicalCheckV3221)physicalOverDuelMap.get(cid)).getCheckTime() != null) {
                            Date date = DateUtils.addYear((Date)((PhcPhysicalCheckV3221)physicalOverDuelMap.get(cid)).getCheckTime(), (int)1);
                            descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u6216\u5b58\u5728\u4f53\u68c0\u903e\u671f\u98ce\u9669";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.TJ.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case DETECTION: {
                Set<Long> checkCompletedList = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedList(cidList, effectiveDateStr, null, "threeYear");
                Set unCompletedFangShangCidList2 = (Set)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList2", 300L, () -> ((ReformItemBasicNewMapper)this.dao).getUnCompletedFangShangCidList(null, 2, effectiveDateStr));
                checkCompletedList.removeAll(unCompletedFangShangCidList2);
                Set<Long> checkCompletedByReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(14), year, true);
                checkCompletedList.addAll(checkCompletedByReformList);
                Map<Long, CheckPlan> checkOverDuelMap = ((ReformItemBasicNewMapper)this.dao).getCheckOverDueMap(cidList, effectiveDateStr, overDateStr, null, "threeYear");
                cidList.forEach(cid -> {
                    Object descriptionMore = "";
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)checkCompletedList) || !checkCompletedList.contains(cid)) {
                        CheckPlan checkPlan;
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                        if (!checkOverDuelMap.isEmpty() && checkOverDuelMap.containsKey(cid) && (checkPlan = (CheckPlan)checkOverDuelMap.get(cid)) != null && checkPlan.getCheckDateBegin() != null) {
                            Date date = DateUtils.addYear((Date)DateUtil.getDate((LocalDateTime)checkPlan.getCheckDateBegin()), (int)3);
                            descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u5b58\u5728\u903e\u671f\u98ce\u9669";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.DETECTION.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case GRJL: {
                Set<Long> personDoseUnCompletedList = ((ReformItemBasicNewMapper)this.dao).getPersonDoseUnCompletedList(cidList);
                Set<Long> reformCompletedList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(11), year, true);
                personDoseUnCompletedList.removeAll(reformCompletedList);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(personDoseUnCompletedList)) break;
                Map<Long, List<ReformItemBasic>> alreadyRiskList = ((ReformItemBasicNewMapper)this.dao).getReformByCidList(personDoseUnCompletedList, year).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getCid));
                cidList.forEach(cid -> {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)personDoseUnCompletedList) && personDoseUnCompletedList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u6309\u8981\u6c42\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u98ce\u9669";
                        if (alreadyRiskList.containsKey(cid)) {
                            int num = ((List)alreadyRiskList.get(cid)).size() + 1;
                            nameOrDescription = nameOrDescription + "-" + num;
                        } else {
                            nameOrDescription = nameOrDescription + "-1";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.GRJL.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case NOZYFZR: {
                break;
            }
            case NOGLRY: {
                break;
            }
            case TRAIN: {
                Set<Long> trainZCompletedList = ((ReformItemBasicNewMapper)this.dao).getTrainCompletedList(cidList, 12, effectiveDateStr);
                Set<Long> trainZCompletedReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(19), year, true);
                trainZCompletedList.addAll(trainZCompletedReformList);
                Set<Long> trainMCompletedList = ((ReformItemBasicNewMapper)this.dao).getTrainCompletedList(cidList, 13, effectiveDateStr);
                Set<Long> trainMCompletedReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(20), year, true);
                trainMCompletedList.addAll(trainMCompletedReformList);
                Map<Long, CertificateStaffDetail> train12OverduelMap = ((ReformItemBasicNewMapper)this.dao).getTrainOverdueMap(cidList, 12, effectiveDateStr, overDateStr);
                Map<Long, CertificateStaffDetail> train13OverduelMap = ((ReformItemBasicNewMapper)this.dao).getTrainOverdueMap(cidList, 13, effectiveDateStr, overDateStr);
                cidList.forEach(cid -> {
                    String nameOrDescription;
                    Object descriptionMore = "";
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)trainZCompletedList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)trainMCompletedList) || !trainZCompletedList.contains(cid) && !trainMCompletedList.contains(cid)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        if (!train12OverduelMap.isEmpty() && train12OverduelMap.containsKey(cid) && train12OverduelMap.get(cid) != null && ((CertificateStaffDetail)train12OverduelMap.get(cid)).getValidityDate() != null) {
                            descriptionMore = "(\u4e3b\u8981\u8d1f\u8d23\u4eba\u903e\u671f\u65f6\u95f4" + format.format(((CertificateStaffDetail)train12OverduelMap.get(cid)).getValidityDate()) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u8bc1\u4e66\u5b58\u5728\u903e\u671f\u98ce\u9669";
                        }
                        if (!train13OverduelMap.isEmpty() && train13OverduelMap.containsKey(cid) && train13OverduelMap.get(cid) != null && ((CertificateStaffDetail)train13OverduelMap.get(cid)).getValidityDate() != null) {
                            descriptionMore = (String)descriptionMore + "(\u7ba1\u7406\u4eba\u5458\u903e\u671f\u65f6\u95f4" + format.format(((CertificateStaffDetail)train13OverduelMap.get(cid)).getValidityDate()) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u8bc1\u4e66\u5b58\u5728\u903e\u671f\u98ce\u9669";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.TRAIN.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                    if (!trainZCompletedList.contains(cid) || CollectionUtils.isEmpty((Collection)trainZCompletedList)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        if (!train12OverduelMap.isEmpty() && train12OverduelMap.containsKey(cid) && train12OverduelMap.get(cid) != null && ((CertificateStaffDetail)train12OverduelMap.get(cid)).getValidityDate() != null) {
                            descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(((CertificateStaffDetail)train12OverduelMap.get(cid)).getValidityDate()) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5b58\u5728\u903e\u671f\u98ce\u9669";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.NOZYFZR.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                    if (!trainMCompletedList.contains(cid) || CollectionUtils.isEmpty((Collection)trainMCompletedList)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        if (!train13OverduelMap.isEmpty() && train13OverduelMap.containsKey(cid) && train13OverduelMap.get(cid) != null && ((CertificateStaffDetail)train13OverduelMap.get(cid)).getValidityDate() != null) {
                            descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(((CertificateStaffDetail)train13OverduelMap.get(cid)).getValidityDate()) + ")";
                            nameOrDescription = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5b58\u5728\u903e\u671f\u98ce\u9669";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.NOGLRY.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case THREE_TIME: {
                Set<Long> threeTimeNoCompletedCidList = ((ReformItemBasicNewMapper)this.dao).getThreeSimultaneousNoCompleted(cidList, effectiveDateStr);
                cidList.forEach(cid -> {
                    if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)threeTimeNoCompletedCidList) && threeTimeNoCompletedCidList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u5b58\u5728\u672a\u5b8c\u6210\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c";
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.THREE_TIME.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case PROTECTION: {
                Set<Long> protectEquipCompletedList = ((ReformItemBasicNewMapper)this.dao).getProtectEquipCompleted(cidList, year);
                protectEquipCompletedList.remove(99657571579393736L);
                cidList.forEach(cid -> {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)protectEquipCompletedList) || !protectEquipCompletedList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1";
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.PROTECTION.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case WARNING_SIGNS: {
                Set<Long> warnSignManageCompletedList = ((ReformItemBasicNewMapper)this.dao).getWarnSignManageCompleted(cidList, effectiveDateStr);
                cidList.forEach(cid -> {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)warnSignManageCompletedList) || !warnSignManageCompletedList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6";
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case ARCHIVES: {
                Set healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(cidList, year).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
                cidList.forEach(cid -> {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)healthManageFilesCompletedList) || !healthManageFilesCompletedList.contains(cid)) {
                        String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5b8c\u5584\u804c\u4e1a\u536b\u751f\u6863\u6848";
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.ARCHIVES.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case DETECTION_ITEM3: {
                Set<Long> check3CompletedList = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedList(cidList, effectiveDateStr, Collections.singletonList(3), "threeYear");
                Set<Long> check3CompletedByReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(23), year, true);
                check3CompletedList.addAll(check3CompletedByReformList);
                Map<Long, CheckPlan> check3OverDuelMap = ((ReformItemBasicNewMapper)this.dao).getCheckOverDueMap(cidList, effectiveDateStr, overDateStr, Collections.singletonList(3), "threeYear");
                Set<Long> check3CompletedListCurr = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedList(cidList, effectiveDateStr, Collections.singletonList(3), "one");
                Set<Long> check3CompletedByReformListCurr = ((ReformItemBasicNewMapper)this.dao).getCheck3ReformCompletedList(cidList, effectiveDateStr);
                check3CompletedListCurr.addAll(check3CompletedByReformListCurr);
                check3CompletedByReformListCurr.clear();
                Set<Long> check2CompletedList = ((ReformItemBasicNewMapper)this.dao).getCheckCompletedList(cidList, effectiveDateStr, Collections.singletonList(2), "one");
                Set<Long> check2CompletedByReformList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(cidList, Collections.singletonList(22), year, true);
                check2CompletedList.addAll(check2CompletedByReformList);
                check2CompletedList.addAll(check3CompletedListCurr);
                Map<Long, CheckPlan> check2OverDuelMap = ((ReformItemBasicNewMapper)this.dao).getCheckOverDueMap(cidList, effectiveDateStr, overDateStr, Collections.singletonList(2), "one");
                cidList.forEach(cid -> {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)check3CompletedList) || !check3CompletedList.contains(cid)) {
                        CheckPlan checkPlan;
                        String name = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u73b0\u72b6\u8bc4\u4ef7";
                        Object description = "\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b\u4e3a\u4e25\u91cd\u7684\u4f01\u4e1a,\u672a\u6309\u8981\u6c423\u5e74\u5f00\u5c55\u4e00\u6b21\u73b0\u72b6\u8bc4\u4ef7";
                        if (!check3OverDuelMap.isEmpty() && check3OverDuelMap.containsKey(cid) && (checkPlan = (CheckPlan)check3OverDuelMap.get(cid)) != null && checkPlan.getCheckDateBegin() != null) {
                            Date date = DateUtils.addYear((Date)DateUtil.getDate((LocalDateTime)checkPlan.getCheckDateBegin()), (int)3);
                            name = year + "\u5e74\u5ea6-\u73b0\u72b6\u8bc4\u4ef7\u5b58\u5728\u903e\u671f\u98ce\u9669";
                            description = (String)description + "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, name, ReformGenerationSourceEnum.DETECTION_ITEM3.getValue(), (String)description, ReformSourceLiteEnum.ZYBWHYSJC.getValue(), dataSource);
                    } else if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)check2CompletedList) || !check2CompletedList.contains(cid)) {
                        CheckPlan checkPlan;
                        String name = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5b9a\u671f\u68c0\u6d4b";
                        Object description = "\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b\u4e3a\u4e25\u91cd\u7684\u4f01\u4e1a,\u672a\u6309\u8981\u6c42\u6bcf\u5e74\u5f00\u5c55\u5b9a\u671f\u68c0\u6d4b";
                        if (!check2OverDuelMap.isEmpty() && check2OverDuelMap.containsKey(cid) && (checkPlan = (CheckPlan)check2OverDuelMap.get(cid)) != null && checkPlan.getCheckDateBegin() != null) {
                            Date date = DateUtils.addYear((Date)DateUtil.getDate((LocalDateTime)checkPlan.getCheckDateBegin()), (int)3);
                            name = year + "\u5e74\u5ea6-\u5b9a\u671f\u68c0\u6d4b\u5b58\u5728\u903e\u671f\u98ce\u9669";
                            description = (String)description + "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                        }
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, findTime, name, ReformGenerationSourceEnum.DETECTION_ITEM2.getValue(), (String)description, ReformSourceLiteEnum.ZYBWHYSJC.getValue(), dataSource);
                    }
                });
                break;
            }
        }
        if (generationSource.intValue() == 23) {
            List<ReformAddParam> addParamList1 = this.filterGenerationSource2324AlreadyExist(addParamList, year);
            return this.generateReform(addParamList1);
        }
        return this.generateReform(addParamList);
    }

    @Transactional
    public void onlyFileAcceptReformAfterTwoMonth(String cids) {
        List<Long> cidListCheck;
        long date3 = new Date().getTime();
        long date1 = DateUtils.parseDate((Object)"2025-12-01 00:00:00").getTime();
        long date2 = DateUtils.parseDate((Object)"2026-01-01 00:00:00").getTime();
        if (date3 < date1 || date3 > date2) {
            return;
        }
        Date findTime = DateUtils.parseDate((Object)"2025-07-01 00:00:11");
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String effectiveDateStr = effectiveDateStr;
        String overDateStr = overDateStr;
        Byte dataSource = ReformDataSourceEnum.KEYFACTORY.getValue();
        ArrayList addParamList = new ArrayList();
        List<String> needAddCidList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)cids)) {
            needAddCidList = Arrays.stream(cids.split(",")).collect(Collectors.toList());
        }
        List<Long> cidListPhy = ((ReformItemBasicNewMapper)this.dao).onlyFileAcceptReformAfterTwoMonthPhy(needAddCidList);
        cidListPhy.remove(99657571579381950L);
        cidListPhy.remove(4927705139843381788L);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cidListPhy)) {
            Map<Long, PhcPhysicalCheckV3221> physicalOverDuelMap = ((ReformItemBasicNewMapper)this.dao).getPhysicalOverDueMap(cidListPhy, effectiveDateStr, overDateStr);
            XxlJobHelper.log((String)("\u83b7\u53d6\u6240\u6709\u4f53\u68c0\u4ec5\u4f5c\u8bc1\u6750\u6599\u5316\u89e3\u7684\u4f01\u4e1aid\uff08\u8d85\u8fc7\u4e24\u4e2a\u6708\u65e0\u6709\u6548\u6570\u636e\uff09" + String.valueOf(cidListPhy)), (Object[])new Object[0]);
            cidListPhy.forEach(cid -> {
                Object descriptionMore = "";
                String nameOrDescription = currYear + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                if (!physicalOverDuelMap.isEmpty() && physicalOverDuelMap.containsKey(cid) && physicalOverDuelMap.get(cid) != null && ((PhcPhysicalCheckV3221)physicalOverDuelMap.get(cid)).getCheckTime() != null) {
                    Date date = DateUtils.addYear((Date)((PhcPhysicalCheckV3221)physicalOverDuelMap.get(cid)).getCheckTime(), (int)1);
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                    nameOrDescription = currYear + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u6216\u5b58\u5728\u4f53\u68c0\u903e\u671f\u98ce\u9669";
                }
                this.makeGenKeyReformAddParamList(addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.TJ.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
            });
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cidListCheck = ((ReformItemBasicNewMapper)this.dao).onlyFileAcceptReformAfterTwoMonthCheck(needAddCidList))) {
            Map<Long, CheckPlan> checkOverDuelMap = ((ReformItemBasicNewMapper)this.dao).getCheckOverDueMap(cidListCheck, effectiveDateStr, overDateStr, null, "threeYear");
            XxlJobHelper.log((String)("\u83b7\u53d6\u6240\u6709\u68c0\u6d4b\u4ec5\u4f5c\u8bc1\u6750\u6599\u5316\u89e3\u7684\u4f01\u4e1aid\uff08\u8d85\u8fc7\u4e24\u4e2a\u6708\u65e0\u6709\u6548\u6570\u636e\uff09" + String.valueOf(cidListCheck)), (Object[])new Object[0]);
            cidListCheck.forEach(cid -> {
                CheckPlan checkPlan;
                Object descriptionMore = "";
                String nameOrDescription = currYear + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                if (!checkOverDuelMap.isEmpty() && checkOverDuelMap.containsKey(cid) && (checkPlan = (CheckPlan)checkOverDuelMap.get(cid)) != null && checkPlan.getCheckDateBegin() != null) {
                    Date date = DateUtils.addYear((Date)DateUtil.getDate((LocalDateTime)checkPlan.getCheckDateBegin()), (int)3);
                    descriptionMore = "(\u903e\u671f\u65f6\u95f4" + format.format(date) + ")";
                    nameOrDescription = currYear + "\u5e74\u5ea6-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u5b58\u5728\u903e\u671f\u98ce\u9669";
                }
                this.makeGenKeyReformAddParamList(addParamList, (Long)cid, findTime, nameOrDescription, ReformGenerationSourceEnum.DETECTION.getValue(), nameOrDescription + (String)descriptionMore, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
            });
        }
        List needAddCidList2 = needAddCidList.stream().map(Long::parseLong).collect(Collectors.toList());
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(needAddCidList2);
        List<ReformAddParam> collect = addParamList.stream().filter(item -> item != null && !pilotAndNewCompanyList.contains(item.getCid())).collect(Collectors.toList());
        this.generateReform(collect);
    }

    public void makeGenKeyReformAddParamList(List<ReformAddParam> addParamList, Long cid, Date findTime, String name, Byte generationSource, String description, Byte reformItemSource, Byte dataSource) {
        if (cid == null) {
            return;
        }
        ReformAddParam addParam = new ReformAddParam();
        addParam.setCid(cid);
        addParam.setFindTime(findTime);
        addParam.setName(name);
        addParam.setReformItemSource(reformItemSource);
        addParam.setGenerationSource(generationSource);
        addParam.setDescription(description);
        addParam.setDataSource(dataSource);
        addParamList.add(addParam);
    }

    public List<ReformAddParam> filterGenerationSource2324AlreadyExist(List<ReformAddParam> addParamList, Integer year) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(addParamList)) {
            return new ArrayList<ReformAddParam>();
        }
        List<Long> xianZhuangCidList = addParamList.stream().filter(item -> item != null && item.getGenerationSource().intValue() == 23).map(ReformAddParam::getCid).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(xianZhuangCidList)) {
            List xianZhuangNotAccList = ((ReformItemBasicNewMapper)this.dao).getNotAcceptanceList(xianZhuangCidList, Collections.singletonList(23), year).stream().filter(item -> item != null && item.getCid() != null).map(ReformItemBasic::getCid).collect(Collectors.toList());
            addParamList = addParamList.stream().filter(item -> !xianZhuangNotAccList.contains(item.getCid())).collect(Collectors.toList());
            xianZhuangNotAccList.clear();
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(addParamList)) {
            return new ArrayList<ReformAddParam>();
        }
        List<Long> dingQiCidList = addParamList.stream().filter(item -> item != null && item.getGenerationSource().intValue() == 22).map(ReformAddParam::getCid).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dingQiCidList)) {
            List dingQiNotAccList = ((ReformItemBasicNewMapper)this.dao).getNotAcceptanceList(dingQiCidList, Collections.singletonList(22), year).stream().filter(item -> item != null && item.getCid() != null).map(ReformItemBasic::getCid).collect(Collectors.toList());
            addParamList = addParamList.stream().filter(item -> !dingQiNotAccList.contains(item.getCid())).collect(Collectors.toList());
            dingQiNotAccList.clear();
        }
        xianZhuangCidList.clear();
        dingQiCidList.clear();
        return addParamList;
    }

    public List<Long> getZjArchiveCountViewByCid(List<Long> cidList, Integer year) {
        ArrayList<Long> cidListTemp = new ArrayList<Long>(cidList);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List needReformCidList = this.itemBasicService.getThreeTimeReformByCid(cidListTemp);
        cidListTemp.removeAll(needReformCidList);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List<Integer> archiveTypeList = Arrays.asList(2, 3, 4);
        List<Long> list234 = ((ReformItemBasicNewMapper)this.dao).get234Completed(cidListTemp, archiveTypeList, year.toString());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list234)) {
            return Collections.emptyList();
        }
        List<Long> list5 = ((ReformItemBasicNewMapper)this.dao).getDoc5Completed(list234);
        Set<Long> physicalReformCompletedList = ((ReformItemBasicNewMapper)this.dao).getReformCompletedList(list234, Collections.singletonList(10), null, null);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(physicalReformCompletedList)) {
            list5.addAll(physicalReformCompletedList);
            list5 = list5.stream().distinct().collect(Collectors.toList());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list5)) {
            return Collections.emptyList();
        }
        return list5;
    }

    @Transactional(readOnly=false)
    public void changeStatusByCidAndGenerationSource(Long cid, Byte generationSource, Byte status, Long loginStaffId, Long businessId) {
        if (cid == null || generationSource == null) {
            return;
        }
        List pilotAndNewCompanyList = this.commandService.getPilotAndNewCompanyList(List.of(cid));
        if (pilotAndNewCompanyList.contains(cid)) {
            this.commandService.changeStatusByCidAndGenerationSource(cid, generationSource, status, loginStaffId, businessId);
            return;
        }
        List<Integer> generationSources = ReformGenerationSourceEnum.TRAIN.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOZYFZR.getValue().equals(generationSource) || ReformGenerationSourceEnum.NOGLRY.getValue().equals(generationSource) ? Arrays.asList(ReformGenerationSourceEnum.TRAIN.getValue().intValue(), ReformGenerationSourceEnum.NOZYFZR.getValue().intValue(), ReformGenerationSourceEnum.NOGLRY.getValue().intValue()) : Collections.singletonList(generationSource.intValue());
        List<ReformItemBasic> notAcceptReformList = ((ReformItemBasicNewMapper)this.dao).getNotAcceptanceList(Collections.singletonList(cid), generationSources, currYear);
        Byte updateStatus = this.changeStatusDivide(notAcceptReformList, generationSource, cid, currYear, loginStaffId);
        if (Objects.equals(updateStatus, (byte)3)) {
            this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE02});
            if (ReformGenerationSourceEnum.DETECTION.getValue().equals(generationSource)) {
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.CHECK, null);
            } else if (ReformGenerationSourceEnum.TRAIN.getValue().equals(generationSource)) {
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.TRAIN, null);
            } else if (ReformGenerationSourceEnum.TJ.getValue().equals(generationSource)) {
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.PHC, null);
            } else if (ReformGenerationSourceEnum.PROTECTION.getValue().equals(generationSource)) {
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.PERSONSHIELD, null);
            } else if (ReformGenerationSourceEnum.WARNING_SIGNS.getValue().equals(generationSource)) {
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.WMBASE, null);
            }
        }
    }

    public Byte changeStatusDivide(List<ReformItemBasic> notAcceptReformList, Byte generationSource, Long cid, Integer year, Long loginStaffId) {
        Byte status = null;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(notAcceptReformList)) {
            return status;
        }
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case TRAIN: 
            case NOZYFZR: {
                status = this.getTrainReformChangeStatus(cid, 12, effectiveDateStr);
                List<ReformItemBasic> collect1819 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOZYFZR.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform(collect1819, null, status, loginStaffId);
                break;
            }
            case NOGLRY: {
                status = this.getTrainReformChangeStatus(cid, 13, effectiveDateStr);
                List<ReformItemBasic> collect1820 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOGLRY.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform(collect1820, null, status, loginStaffId);
                break;
            }
            case THREE_TIME: {
                status = this.getThreeTimeReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                break;
            }
            case PROTECTION: {
                status = this.getProtectReformChangeStatus(cid, year);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                break;
            }
            case WARNING_SIGNS: {
                status = this.getWarnSignReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                break;
            }
            case ARCHIVES: {
                List<Long> zjArchiveCountViewByCid = this.getZjArchiveCountViewByCid(Collections.singletonList(cid), year);
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(zjArchiveCountViewByCid)) break;
                this.makeAndUpdateReform(notAcceptReformList, null, (byte)3, loginStaffId);
                break;
            }
        }
        return status;
    }

    private Byte getThreeTimeReformChangeStatus(Long cid, String effectiveDateStr) {
        List<TsProjectSimple> projectSimpleList = ((ReformItemBasicNewMapper)this.dao).getAllThreeTimeDate(Collections.singletonList(cid), effectiveDateStr);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(projectSimpleList)) {
            return (byte)-1;
        }
        boolean isAUDIT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.AUDIT.getCode()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        boolean isBack = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.BACK.getCode()) || item.getStatus().equals(TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()));
        if (isBack) {
            return ReformStatusEnum.TH.getValue();
        }
        boolean isDRAFT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.DRAFT.getCode()));
        if (isDRAFT) {
            return ReformStatusEnum.CG.getValue();
        }
        return ReformStatusEnum.WC.getValue();
    }

    private Byte getTrainReformChangeStatus(Long cid, Integer type, String effectiveDateStr) {
        List<CertificateStaffDetail> list = ((ReformItemBasicNewMapper)this.dao).getTrainList(Collections.singletonList(cid), type);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> {
            if (item.getStatus() == null || item.getStatus().equals(ApprovalStatusEnum.PASSED.getValue()) || item.getStatus().equals(ApprovalStatusEnum.NONEEDAPPROVAL.getValue())) {
                return item.getValidityDate() != null && item.getValidityDate().getTime() >= DateUtils.parseDate((Object)effectiveDateStr).getTime();
            }
            return false;
        });
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getStatus() != null && item.getStatus().equals(ApprovalStatusEnum.WAITAPPROVAL.getValue()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getProtectReformChangeStatus(Long cid, Integer year) {
        List<ProtectEquipIssueRecord> allProtectEquip = ((ReformItemBasicNewMapper)this.dao).getAllProtectEquip(Collections.singletonList(cid), null);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(allProtectEquip)) {
            return (byte)-1;
        }
        boolean isFinish = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)) && item.getIssuedTime() != null && DateUtils.getYear((Date)item.getIssuedTime()) >= year);
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getWarnSignReformChangeStatus(Long cid, String effectiveDateStr) {
        List<WarnSignManage> list = ((ReformItemBasicNewMapper)this.dao).getAllWarnSign(Collections.singletonList(cid));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)) && item.getChangeTime() != null && DateUtils.addYear((Date)item.getChangeTime(), (int)3).getTime() >= DateUtils.parseDate((Object)effectiveDateStr).getTime());
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    @Transactional
    public void setPauseStatus(List<Long> reformIds) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(reformIds)) {
            ((ReformItemBasicNewMapper)this.dao).setPauseStatus(reformIds, true);
            ((ReformItemBasicNewMapper)this.dao).setPauseStatus(reformIds, false);
        }
    }

    private void setQueryListConditions(RiskResolveResSearch searchVo) {
        if (StringUtils.isNotBlank((CharSequence)searchVo.getRiskTypeStr())) {
            List collect = Arrays.stream(searchVo.getRiskTypeStr().split(",")).map(Integer::valueOf).collect(Collectors.toList());
            searchVo.setRiskTypeStrList(collect);
        }
        this.setIsCurrent(searchVo);
    }

    private void setIsCurrent(RiskResolveResSearch searchVo) {
        if (searchVo.getCompanyLevel() != null) {
            if (searchVo.getCompanyLevel().equals(1)) {
                searchVo.setIsCurrent(Boolean.valueOf(true));
                if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                    searchVo.setCompanyLevel(Integer.valueOf(searchVo.getAreaLevel().intValue()));
                } else {
                    searchVo.setCompanyLevel(Integer.valueOf(0));
                }
            } else if (searchVo.getCompanyLevel().equals(2)) {
                searchVo.setIsCurrent(Boolean.valueOf(false));
                if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                    searchVo.setCompanyLevel(Integer.valueOf(searchVo.getAreaLevel().intValue()));
                } else {
                    searchVo.setCompanyLevel(Integer.valueOf(0));
                }
            }
        } else {
            searchVo.setIsCurrent(null);
        }
    }

    public List<RiskResolveInfoVo> getRiskCountList(SearchParam searchVo) {
        searchVo.setYear(Integer.valueOf(DateUtils.getThisYear()));
        return ((ReformItemBasicNewMapper)this.dao).getNoResolvedNum(searchVo);
    }

    public List<ReformItemBasic> getListByTjBusinessIds(List<String> tjIds) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tjIds)) {
            return Collections.emptyList();
        }
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andNotEqualTo("status", (Object)10).andIn("tjBusinessId", tjIds).andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public List<ReformItemBasic> getPhysicalAbnormalReform(List<Long> cids, Integer year) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((ReformItemBasicNewMapper)this.dao).getPhysicalAbnormalReform(cids, year);
    }

    public List<ReformItemBasic> queryNotAccReform(List<Long> cids, List<Byte> generationSources, Integer year) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((ReformItemBasicNewMapper)this.dao).queryNotAccReform(cids, generationSources, year);
    }

    public Set<Long> getReformOverCheckRiskId(List<Long> cidList, Map<String, Object> paramMap) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptySet();
        }
        return ((ReformItemBasicNewMapper)this.dao).getReformOverCheckRiskId(cidList);
    }

    public Set<Long> getReformOverCheckRiskId2(List<Long> checkPlanIdList, Map<String, Object> paramMap) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(checkPlanIdList)) {
            return Collections.emptySet();
        }
        String factoryName = (String)paramMap.get("factoryName");
        return ((ReformItemBasicNewMapper)this.dao).getReformOverCheckRiskId2(checkPlanIdList, factoryName);
    }

    public ReformAcceptRecordViewVo getReformAcceptanceRecordToHse(Long reformId, Long acceptanceId, Map<String, String> map) {
        List files;
        String fileIds;
        ReformItemAcceptanceRecord acceptance;
        ReformAcceptRecordViewVo vo = new ReformAcceptRecordViewVo();
        ReformItemBasic reform = this.getByIdAndRecordDetail(reformId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (reform == null) {
            throw new ServiceException("\u98ce\u9669\u4e0d\u5b58\u5728");
        }
        vo.setDbReform(reform);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)reform.getAceptanceList())) {
            reform.getAceptanceList().stream().filter(Objects::nonNull).filter(e -> e.getId().equals(acceptanceId)).findFirst().ifPresent(arg_0 -> ((ReformItemBasic)reform).setAcceptance(arg_0));
        }
        if ((acceptance = reform.getAcceptance()) == null) {
            throw new ServiceException("\u9a8c\u6536\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)acceptance.getAcceptanceFiles())) {
            fileIds = acceptance.getAcceptanceFiles();
            files = this.fileService.getListByIds(fileIds);
            acceptance.setAcceptanceFilesList(files);
        }
        if (StringUtils.isNotBlank((CharSequence)acceptance.getReformFinishedFiles())) {
            fileIds = acceptance.getReformFinishedFiles();
            files = this.fileService.getListByIds(fileIds);
            acceptance.setReformFinishedFilesList(files);
        }
        if (StringUtils.isNotBlank((CharSequence)acceptance.getReformProgrammeFiles())) {
            List files2 = this.fileService.getListByIds(acceptance.getReformProgrammeFiles());
            acceptance.setReformSolutionFilesList(files2);
        }
        vo.setId(acceptanceId);
        vo.setReformDirector(acceptance.getReformDirectorName());
        vo.setReformMeasure(StringEscapeUtils.unescapeHtml((String)acceptance.getReformMeasure()));
        vo.setReformItemSourceId(String.valueOf(reform.getReformItemSourceId()));
        if (acceptance.getRequireFinishTime() != null) {
            vo.setRequireFinishTime(acceptance.getRequireFinishTime());
        }
        vo.setReformFinishedFilesList(acceptance.getReformFinishedFilesList());
        vo.setStatus(acceptance.getStatus());
        vo.setActualFinishTime(acceptance.getActualFinishTime());
        vo.setFindTime(reform.getFindTime());
        vo.setDealMeasure(acceptance.getDealMeasure());
        vo.setDealMeasureName(acceptance.getDealMeasureName());
        vo.setThirdOrgId(acceptance.getThirdOrgId());
        vo.setThirdOrgName(acceptance.getThirdOrgName());
        vo.setDealTimeBegin(Objects.nonNull(acceptance.getDealTimeBegin()) ? dateFormat.format(acceptance.getDealTimeBegin()) : "");
        vo.setDealTimeEnd(Objects.nonNull(acceptance.getDealTimeEnd()) ? dateFormat.format(acceptance.getDealTimeEnd()) : "");
        vo.setAcceptanceDirectorName(acceptance.getAcceptanceDirectorName());
        vo.setAcceptanceDate(acceptance.getAcceptanceDate());
        vo.setAcceptanceFileList(acceptance.getAcceptanceFilesList());
        vo.setReformProgrammeFiles(acceptance.getReformProgrammeFiles());
        vo.setReformSolutionFilesList(acceptance.getReformSolutionFilesList());
        vo.setAcceptanceResult(acceptance.getAcceptanceResult());
        vo.setAcceptanceResultExplain(acceptance.getAcceptanceResultExplain());
        vo.setTjReformSolution(acceptance.getTjReformSolution());
        vo.setNextStartDate(acceptance.getNextStartDate());
        if (Objects.equals(reform.getGenerationSource(), ReformGenerationSourceEnum.TJ.getValue()) && reform.getStatus() != null && Arrays.asList((byte)0, (byte)1, (byte)5).contains(reform.getStatus())) {
            vo.setTjReformSolutionMap(this.getTjReformSolutionMap(reform.getCid()));
        }
        if (reform.getGenerationSource().equals(ReformGenerationSourceEnum.JCCB.getValue())) {
            List accOldIdList = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(true)).setAcceptRecordId(acceptance.getId())).stream().filter(Objects::nonNull).map(ReformCheckMeasure::getAcceptRecordId).distinct().collect(Collectors.toList());
            vo.setCheckMeasureIsOld(Boolean.valueOf(accOldIdList.contains(acceptance.getId())));
        }
        return vo;
    }

    public Map<String, String> getTjReformSolutionMap(Long cid) {
        if (cid == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Set fangSheIdList = (Set)this.redisClient.get("HarmFactorServiceImpl", "getFangSheIdList", 43200L, () -> this.harmFactorService.getAllListIncludeInvalid().stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getType()) && d.getType().contains("\u653e\u5c04\u56e0\u7d20")).map(HarmFactor::getId).map(String::valueOf).collect(Collectors.toSet()));
        Set touchTwoYearFactoryIdList = (Set)this.redisClient.get("HarmFactorServiceImpl", "touchTwoYearFactoryIdList", 43200L, () -> ((ReformItemBasicNewMapper)this.dao).geTouchTwoYearFactoryIdList().stream().map(HarmFactor::getId).map(String::valueOf).collect(Collectors.toSet()));
        Set GBZ188IdList = (Set)this.redisClient.get("HarmFactorServiceImpl", "getGBZ188IdList", 43200L, () -> this.harmFactorService.getAllListIncludeInvalid().stream().filter(d -> Objects.equals(1, d.getBelongGbz188())).map(HarmFactor::getId).map(String::valueOf).collect(Collectors.toSet()));
        Set<Long> physicalCompletedList = ((ReformItemBasicNewMapper)this.dao).getPhysicalCompletedList2(Collections.singletonList(cid), DateUtils.formatDateTime((Date)new Date()));
        List lastEv = this.riskExposeEvaluateService.getLastEv(new EvQueryParam().setCid(cid).setCheckTypeList(Arrays.asList(2L, 3L, 4L)).setIsQueryRiskData(Boolean.valueOf(true)));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)lastEv)) {
            map.put("7", "\u8bf7\u53ca\u65f6\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u5e76\u7763\u4fc3\u68c0\u6d4b\u673a\u6784\u4e0a\u4f20\u68c0\u6d4b\u6570\u636e");
            return map;
        }
        if (lastEv.get(0) == null || com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)((RiskExposeEvaluate)lastEv.get(0)).getDataList())) {
            return Collections.emptyMap();
        }
        List evaluateDataList = ((RiskExposeEvaluate)lastEv.get(0)).getDataList();
        boolean factoryZy = evaluateDataList.stream().anyMatch(d -> d != null && StringUtils.isNotBlank((CharSequence)d.getFactorId()) && d.getFactorId().equals("567") && StringUtils.isNotBlank((CharSequence)d.getNoiseLevel()) && d.getNoiseLevel().trim().matches("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?") && Double.parseDouble(d.getNoiseLevel()) > 85.0);
        for (RiskExposeEvaluateData d2 : evaluateDataList) {
            if (d2 == null) continue;
            if (StringUtils.isNotBlank((CharSequence)d2.getFactorName()) && d2.getFactorName().contains("\u5176\u4ed6\u7c89\u5c18")) {
                d2.setFactorId("654");
            }
            if (StringUtils.isBlank((CharSequence)d2.getFactorId())) continue;
            String factorId = d2.getFactorId();
            if (factorId.equals("567")) {
                if (factoryZy) {
                    map.put("7", "\u6700\u8fd1\u4e00\u6b21\u68c0\u6d4b\u62a5\u544a\u4e2d\u5b58\u5728\u5f3a\u5ea6\u8d85\u8fc785dB\uff08A\uff09\u7684\u566a\u58f0");
                    return map;
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(physicalCompletedList)) continue;
                map.put("7", "\u6700\u8fd1\u4e00\u6b21\u5728\u5c97\u4f53\u68c0\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc72\u5e74");
                return map;
            }
            if (fangSheIdList.contains(factorId)) {
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(physicalCompletedList)) continue;
                map.put("7", "\u6700\u8fd1\u4e00\u6b21\u5728\u5c97\u4f53\u68c0\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc72\u5e74");
                return map;
            }
            if (!GBZ188IdList.contains(factorId) || touchTwoYearFactoryIdList.contains(factorId)) continue;
            map.put("7", "\u6700\u8fd1\u4e00\u6b21\u68c0\u6d4b\u62a5\u544a\u4e2d\u5b58\u5728\u4f53\u68c0\u5468\u671f\u4e3a1\u5e74\u5185\uff08\u542b\uff09\u7684\u5371\u5bb3\u56e0\u7d20");
            return map;
        }
        return map;
    }

    @Transactional
    public ReformItemBasic saveGenerationAccToHes(ReformItemBasic reformItem, Long loginStaffId, Map<String, String> map) {
        String reformDirectorName;
        ThirdOrganization thirdOrganization;
        ReformItemBasic basic = this.getByIdAndRecordDetail(reformItem.getId());
        if (basic == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u6574\u6539\u4fe1\u606f\uff0c\u6574\u6539\u5931\u8d25\uff01");
        }
        if (!Objects.equals(basic.getCid(), reformItem.getCid())) {
            throw new ServiceException("\u672c\u6b21\u767b\u5f55\u5df2\u5207\u6362\u8d26\u53f7\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u8bd5\uff01");
        }
        ReformItemAcceptanceRecord acceptance = reformItem.getAcceptance();
        if (acceptance != null && StringUtils.isNotBlank((CharSequence)acceptance.getReformDirectorName()) && (thirdOrganization = this.thirdOrganizationService.getByName(reformDirectorName = acceptance.getReformDirectorName())) != null) {
            throw new ServiceException("\u6574\u6539\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u68c0\u6d4b\u673a\u6784\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        Date findTime = basic.getFindTime();
        if (findTime != null) {
            if (DateUtils.getYear((Date)findTime) == 2023) {
                date = DateUtils.parseDate((Object)"2023-09-30 00:00:00");
                basic.getAcceptance().setRequireFinishTime(date);
            } else {
                date = DateUtils.addDay((Date)findTime, (int)60);
                basic.getAcceptance().setRequireFinishTime(date);
            }
        }
        if (Objects.equals(basic.getGenerationSource(), ReformGenerationSourceEnum.TJ.getValue()) && basic.getAcceptance() != null && basic.getAcceptance().getTjReformSolution() != null && basic.getAcceptance().getTjReformSolution().contains(",")) {
            throw new ServiceException("\u8be5\u9009\u9879\u53ea\u80fd\u5355\u9009");
        }
        reformItem.setGenerationSource(basic.getGenerationSource());
        if (basic.getStatus() == null || !Arrays.asList((byte)0, (byte)1, (byte)5).contains(basic.getStatus())) {
            throw new ServiceException("\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        this.saveOrSubmitReform(reformItem, loginStaffId);
        return reformItem;
    }

    @Transactional
    public void deleteReform(List<Long> cidList, List<Byte> generationSources, List<Long> idList) {
        List list2;
        Example example2;
        List list;
        Example example;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cidList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(generationSources)) {
            example = new Example(ReformItemBasic.class);
            example.createCriteria().andIn("cid", cidList).andIn("generationSource", generationSources);
            list = this.getListByExample(example);
            for (ReformItemBasic basic : list) {
                if (basic == null) continue;
                basic.setIsValid(Boolean.FALSE);
                this.updateByPrimaryKey(basic, 1L);
            }
            example2 = new Example(ReformItemSource.class);
            example2.createCriteria().andIn("cid", cidList).andIn("generationSource", generationSources);
            list2 = this.itemSourceService.getListByExample(example2);
            for (ReformItemSource source : list2) {
                if (source == null) continue;
                source.setIsValid(Boolean.FALSE);
                this.itemSourceService.updateByPrimaryKey((Object)source, Long.valueOf(1L));
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(idList)) {
            example = new Example(ReformItemBasic.class);
            example.createCriteria().andIn("id", idList);
            list = this.getListByExample(example);
            for (ReformItemBasic basic : list) {
                if (basic == null) continue;
                basic.setIsValid(Boolean.FALSE);
                this.updateByPrimaryKey(basic, 1L);
            }
            example2 = new Example(ReformItemSource.class);
            example2.createCriteria().andIn("reformItemId", idList);
            list2 = this.itemSourceService.getListByExample(example2);
            for (ReformItemSource source : list2) {
                if (source == null) continue;
                source.setIsValid(Boolean.FALSE);
                this.itemSourceService.updateByPrimaryKey((Object)source, Long.valueOf(1L));
            }
        }
    }

    @Transactional
    public void pushPhyAndCheckAbnormalReform(Long id) {
        List<ReformAddParam> list = ((ReformItemBasicNewMapper)this.dao).getPhyAndCheckAbnormalReform(id);
        this.generateReform(list);
    }

    public Map<Long, LocalDate> estimateRiskFirstWarningTime(List<Long> cidList, Byte generationSource) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList) || generationSource == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, LocalDate> map = new HashMap<Long, LocalDate>();
        LocalDate beginWarnDay = LocalDate.now();
        LocalDate endWarnDay = beginWarnDay.plusMonths(3L);
        LocalDate lastWarnDate = endWarnDay.getYear() != beginWarnDay.getYear() ? endWarnDay.withMonth(7).withDayOfMonth(1).minusDays(1L) : beginWarnDay.withMonth(11).withDayOfMonth(1).minusDays(1L);
        LocalDate errorDate = LocalDate.parse("2050-01-01");
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case TJ: {
                Map<Long, LocalDate> physicalDateMap = ((ReformItemBasicNewMapper)this.dao).getPhysicalDateMap(cidList).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    LocalDate phyDate = physicalDateMap.get(cid);
                    if (phyDate == null || phyDate.plusYears(1L).isBefore(beginWarnDay)) {
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u4f53\u68c0\u6a21\u5757\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\uff0c\u4f46\u662f\u6ca1\u6709\u63a8\u9001\u98ce\u9669:{}", (Object)cid);
                        map.put(cid, errorDate);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, phyDate.plusYears(1L).plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case GRJL: {
                return map;
            }
            case THREE_TIME: {
                HashMap threeSimultaneousDateMap = new HashMap();
                ((ReformItemBasicNewMapper)this.dao).getThreeSimultaneousDateMap(cidList).stream().filter(item -> item != null && item.getCid() != null).forEach(item -> threeSimultaneousDateMap.put(item.getCid(), item.getTime()));
                for (Long cid : cidList) {
                    if (!threeSimultaneousDateMap.containsKey(cid)) {
                        map.put(cid, null);
                        continue;
                    }
                    if (DateUtil.isAfterOrEqual((LocalDate)beginWarnDay, (LocalDate)lastWarnDate)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u4e09\u540c\u65f6\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff0c\u5982\u679c\u4eca\u5929\u662f\u57287.31\u53f7\u5f53\u5929\u6216\u8005\u4e4b\u540e\uff0c\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u4e09\u540c\u65f6\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    LocalDate threeSimultaneousDate = (LocalDate)threeSimultaneousDateMap.get(cid);
                    if (threeSimultaneousDate == null || DateUtil.isAfterOrEqual((LocalDate)threeSimultaneousDate.plusYears(1L), (LocalDate)lastWarnDate)) {
                        ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, lastWarnDate, beginWarnDay, endWarnDay, map);
                        continue;
                    }
                    LocalDate localDate = threeSimultaneousDate.plusYears(1L);
                    if (localDate.isBefore(beginWarnDay)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u4e09\u540c\u65f6\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff1a\u9884\u6d4b\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u4e09\u540c\u65f6\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, localDate.plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case DETECTION: {
                Map<Long, LocalDate> checkDateMap = ((ReformItemBasicNewMapper)this.dao).getCheckDateMap(cidList).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    LocalDate checkDate = checkDateMap.get(cid);
                    if (checkDate == null || checkDate.plusYears(3L).isBefore(beginWarnDay)) {
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u68c0\u6d4b\u6a21\u5757\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\uff0c\u4f46\u662f\u6ca1\u6709\u63a8\u9001\u98ce\u9669:{}", (Object)cid);
                        map.put(cid, errorDate);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, checkDate.plusYears(3L).plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case PROTECTION: {
                Map<Long, LocalDate> protectionDateMap = ((ReformItemBasicNewMapper)this.dao).getProtectionDateMap(cidList).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                Map<Long, LocalDate> lastYearProtectionDateMap = ((ReformItemBasicNewMapper)this.dao).getLastYearReformDateMap(cidList, ReformGenerationSourceEnum.PROTECTION.getValue(), endWarnDay.getYear() - 1).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    LocalDate protectDate = protectionDateMap.get(cid);
                    if (protectDate != null && protectDate.getYear() >= endWarnDay.getYear()) {
                        map.put(cid, null);
                        continue;
                    }
                    if (DateUtil.isAfterOrEqual((LocalDate)beginWarnDay, (LocalDate)lastWarnDate)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u4e2a\u4eba\u9632\u62a4\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff0c\u5982\u679c\u4eca\u5929\u662f\u57287.31\u53f7\u6216\u8005\u4e4b\u540e\uff0c\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u4e2a\u4eba\u9632\u62a4\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    LocalDate localDate = null;
                    if (protectDate != null) {
                        localDate = protectDate.plusYears(1L);
                    }
                    if (lastYearProtectionDateMap.get(cid) != null) {
                        localDate = lastYearProtectionDateMap.get(cid).plusYears(1L);
                    }
                    if (localDate == null) {
                        ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, lastWarnDate, beginWarnDay, endWarnDay, map);
                        continue;
                    }
                    if (localDate.isBefore(beginWarnDay)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u4e2a\u4eba\u9632\u62a4\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff1a\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u4e2a\u4eba\u9632\u62a4\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, localDate.plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case WARNING_SIGNS: {
                Map<Long, LocalDate> warningSignsDateMap = ((ReformItemBasicNewMapper)this.dao).getWarningSignsDateMap(cidList).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                Map<Long, LocalDate> lastYearWarningDateMap = ((ReformItemBasicNewMapper)this.dao).getLastYearReformDateMap(cidList, ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), endWarnDay.getYear() - 1).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    LocalDate warningSignsDate = warningSignsDateMap.get(cid);
                    if (warningSignsDate != null && DateUtil.isAfterOrEqual((LocalDate)warningSignsDate.plusYears(3L), (LocalDate)warningSignsDate)) {
                        map.put(cid, null);
                        continue;
                    }
                    if (DateUtil.isAfterOrEqual((LocalDate)beginWarnDay, (LocalDate)lastWarnDate)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u8b66\u793a\u6807\u8bc6\u63a8\u9001\u5f02\u5e38\uff0c\u5982\u679c\u4eca\u5929\u662f\u57287.31\u53f7\u6216\u8005\u4e4b\u540e\uff0c\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u8b66\u793a\u6807\u8bc6\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    LocalDate localDate = null;
                    if (warningSignsDate != null) {
                        localDate = warningSignsDate.plusYears(3L);
                    }
                    if (lastYearWarningDateMap.get(cid) != null) {
                        localDate = lastYearWarningDateMap.get(cid).plusYears(1L);
                    }
                    if (localDate == null) {
                        ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, lastWarnDate, beginWarnDay, endWarnDay, map);
                        continue;
                    }
                    if (localDate.isBefore(beginWarnDay)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u8b66\u793a\u6807\u8bc6\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff1a\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u8b66\u793a\u6807\u8bc6\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, localDate.plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case TRAIN: {
                Map<Long, LocalDate> trainDateMap = ((ReformItemBasicNewMapper)this.dao).getTrainDateMap(cidList).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    LocalDate trainDate = trainDateMap.get(cid);
                    if (trainDate == null || trainDate.isBefore(beginWarnDay)) {
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u57f9\u8bad\u6a21\u5757\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\uff0c\u4f46\u662f\u6ca1\u6709\u63a8\u9001\u98ce\u9669:{}", (Object)cid);
                        map.put(cid, errorDate);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, trainDate.plusDays(1L), beginWarnDay, endWarnDay, map);
                }
                return map;
            }
            case ARCHIVES: {
                Set archivesCompletedList = this.getZjArchiveCountViewByCid(cidList, currYear).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
                Map<Long, LocalDate> lastYearArchivesDateMap = ((ReformItemBasicNewMapper)this.dao).getLastYearReformDateMap(cidList, ReformGenerationSourceEnum.ARCHIVES.getValue(), endWarnDay.getYear() - 1).stream().filter(item -> item != null && item.getTime() != null && item.getCid() != null).collect(Collectors.toMap(CidTimeVo::getCid, CidTimeVo::getTime, (a, b) -> a));
                for (Long cid : cidList) {
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(archivesCompletedList) && archivesCompletedList.contains(cid)) {
                        map.put(cid, null);
                        continue;
                    }
                    if (DateUtil.isAfterOrEqual((LocalDate)beginWarnDay, (LocalDate)lastWarnDate)) {
                        map.put(cid, errorDate);
                        this.logger.error("\u83b7\u53d6\u9884\u4f30\u98ce\u9669\u9884\u8b66\u65f6\u95f4\u5f02\u5e38\uff1a\u6863\u6848\u98ce\u9669\u63a8\u9001\u5f02\u5e38\uff1a\u8fd9\u4e2a\u65f6\u5019\u5e94\u8be5\u5df2\u7ecf\u63a8\u9001\u4e86\u6863\u6848\u98ce\u9669\u624d\u5bf9:{}", (Object)cid);
                        continue;
                    }
                    LocalDate localDate = lastYearArchivesDateMap.get(cid);
                    if (localDate == null || localDate.plusYears(1L).isAfter(lastWarnDate)) {
                        ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, lastWarnDate, beginWarnDay, endWarnDay, map);
                        continue;
                    }
                    ReformItemBasicNewServiceImpl.setBackWarnTimeMap(cid, localDate, beginWarnDay, endWarnDay, map);
                }
                break;
            }
        }
        return map;
    }

    private static void setBackWarnTimeMap(Long cid, LocalDate localDate, LocalDate beginWarnDay, LocalDate endWarnDay, Map<Long, LocalDate> map) {
        if (localDate.isAfter(beginWarnDay) && localDate.isBefore(endWarnDay)) {
            map.put(cid, localDate);
        } else {
            map.put(cid, null);
        }
    }

    public List<ReformItemBasic> getReformItemBasicWarnStatusInfoList(ReformSearchVo searchVo) {
        return ((ReformItemBasicNewMapper)this.dao).getReformItemBasicWarnStatusInfoList(searchVo);
    }

    public RiskWarnFormVo getRiskWarnFormVoByAreaId(Long areaId, Integer areaLevel, Integer belongType, Integer isFcyth, Byte systemDeploymentSource) {
        return ((ReformItemBasicNewMapper)this.dao).getRiskWarnFormVoByAreaId(areaId, areaLevel, belongType, isFcyth, systemDeploymentSource);
    }

    public List<ReformItemBasicView> getReformItemBasicCountView(ReformSearchVo searchVo) {
        return ((ReformItemBasicNewMapper)this.dao).getReformItemBasicCountView(searchVo);
    }

    public Map<Long, List<Byte>> getOverFourMonthRisk(String cids) {
        List cidList = StringUtils.parseToLongList((String)cids);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)cidList)) {
            return Collections.emptyMap();
        }
        List<ReformItemBasic> list = ((ReformItemBasicNewMapper)this.dao).getOverFourMonthRisk(cidList);
        return list.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.mapping(ReformItemBasic::getGenerationSource, Collectors.toList())));
    }
}

