/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.SysConvertTool;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTable20240701Service;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTable20241231Service;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTable20250630Service;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTableService;
import cn.smarthse.modules.health.company.service.IOptimizeEnvEconomicAccountTableService;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicNewMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.statistics.CumulativeEconomicAccountData;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicEconomyService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformItemSourceService;
import cn.smarthse.modules.health.supervise.model.keyFactory.EconomicAccountTable;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskNumInfoVo;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskStatisticsVo;
import cn.smarthse.modules.health.vo.riskResolve.RiskCalculator;
import cn.smarthse.modules.health.vo.riskResolve.RiskVisualDto;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ReformItemBasicEconomyServiceImpl
extends BaseServiceImpl<ReformItemBasicNewMapper, ReformItemBasic>
implements IReformItemBasicEconomyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReformItemBasicEconomyServiceImpl.class);
    @Resource
    private ReformItemBasicMapper reformItemBasicMapper;
    @Autowired
    IReformItemAcceptanceRecordService acceptanceRecordService;
    @Autowired
    IReformItemSourceService itemSourceService;
    @Autowired
    IReformItemBasicService itemBasicService;
    @DubboReference
    private ICompanyBusinessTableService companyBusinessTableService;
    @DubboReference
    private ICompanyBusinessTable20250630Service companyBusinessTable20250630Service;
    @DubboReference
    private ICompanyBusinessTable20241231Service companyBusinessTable20241231Service;
    @DubboReference
    private ICompanyBusinessTable20240701Service companyBusinessTable20240701Service;
    @DubboReference
    private IOptimizeEnvEconomicAccountTableService economicAccountTableService;
    @Autowired
    RedisClient redisClient;
    private static final String AREA_RISK_HISTORY_CACHE_KEY = "RiskMitigationController:areaRiskNumCountListData:history";
    private static final String HOME_INDEX_CACHE_KEY = "HomeIndexControllerV3223:getHelpCompanyInfo";
    @Autowired
    private ThreadPoolTaskExecutor poolTaskExecutor;

    public PageInfo<RegionRiskStatisticsVo> regionRiskNumCountListDataOptimize(RiskResolveResSearch searchParam) {
        long l1 = System.currentTimeMillis();
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Integer page = searchParam.getPage();
        Integer rows = searchParam.getLimit();
        if (!Objects.equals(searchParam.getIsFcImportanceCompany(), 1)) {
            searchParam.setIsFcImportanceCompany(null);
        }
        boolean isHistory = year != null;
        RegionRiskStatisticsVo data = new RegionRiskStatisticsVo();
        HashMap<String, List<RegionRiskNumInfoVo>> riskMap = new HashMap<String, List<RegionRiskNumInfoVo>>();
        if (year == null && RiskCalculator.CURRENT_MONTH <= 6) {
            this.statisticalFirstHalfYearData(searchParam, data, riskMap, Boolean.FALSE);
        } else {
            this.statisticalFirstHalfYearData(searchParam, data, riskMap, isHistory);
            this.determineYearParamAndCalcFreePunishAmount(searchParam, data);
        }
        List riskList = (List)riskMap.get("riskList");
        if (riskList == null) {
            riskList = Collections.emptyList();
        }
        Page dataPage = new Page(page.intValue(), rows.intValue());
        int total = riskList.size();
        int start = (page - 1) * rows;
        int end = Math.min(start + rows, total);
        List<RegionRiskNumInfoVo> riskSubList = ReformItemBasicEconomyServiceImpl.deepCopy(new ArrayList(riskList.subList(start, end)));
        riskSubList.forEach(Objects.equals(year, 2024) ? ReformItemBasicEconomyServiceImpl::setPunishAmountByResolveComNumOld : ReformItemBasicEconomyServiceImpl::setPunishAmountByResolveComNumNew);
        data.setRegionRiskNumInfoVoList(riskSubList);
        dataPage.setTotal((long)total);
        dataPage.addAll((Collection)CollUtil.toList((Object[])new RegionRiskStatisticsVo[]{data}));
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l1 + " \u6beb\u79d2\u3002");
        return new PageInfo((List)dataPage);
    }

    public CumulativeEconomicAccountData getCumulativeData(Long regionId) {
        return ((ReformItemBasicNewMapper)this.dao).getCumulativeData();
    }

    private void statisticalFirstHalfYearData(RiskResolveResSearch searchParam, RegionRiskStatisticsVo data, Map<String, List<RegionRiskNumInfoVo>> riskMap, boolean isHistory) {
        List<RegionRiskNumInfoVo> riskList = !isHistory ? this.getRegionRiskInfoAllList(searchParam) : this.getRegionRiskInfoHistoryList(searchParam);
        List<RegionRiskNumInfoVo> delLevel2RiskList = ReformItemBasicEconomyServiceImpl.removeOnlyCityLevelElement(riskList);
        riskMap.put("riskList", riskList);
        long num = delLevel2RiskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
        data.setTotalResolveComNum(Long.valueOf(num));
        data.setTotalFreePunishAmount(!isHistory ? RiskCalculator.calculateEconomicForList(delLevel2RiskList) : ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(num).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        data.setLessFreePunishAmountSum(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(num).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        data.setMostFreePunishAmountSum(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(num).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        BigDecimal totalFreePunishAmount = data.getTotalFreePunishAmount();
        data.setFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)totalFreePunishAmount));
        log.error("\u65e5\u5fd7\u6253\u5370::statisticalFirstHalfYearData::{},{}", (Object)data.getFreePunishAmount(), (Object)System.currentTimeMillis());
    }

    public RiskVisualDto visualEconomicAccountStatementDataFetch(Long regionId, Byte regionLevel, Integer isFcImportanceCompany, Integer belongType, Boolean isCurrent) {
        List<RegionRiskNumInfoVo> riskList;
        RiskResolveResSearch searchParam = new RiskResolveResSearch().setPage(Integer.valueOf(1)).setLimit(Integer.valueOf(999)).setRows(Integer.valueOf(999)).setAreaId(regionId).setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setAreaLevel(regionLevel).setIsFcImportanceCompany(isFcImportanceCompany).setCompanyLevel(belongType).setIsCurrent(isCurrent).setOnlyThisLevel(isCurrent);
        if (RiskCalculator.CURRENT_MONTH <= 6) {
            riskList = this.getRegionRiskInfoAllList(searchParam);
        } else {
            searchParam.setYear(Convert.toInt((Object)(RiskCalculator.CURRENT_YEAR + "01")));
            List<RegionRiskNumInfoVo> preRiskList = this.getRegionRiskInfoAllList(searchParam);
            searchParam.setYear(null);
            List<RegionRiskNumInfoVo> postRiskList = this.getRegionRiskInfoAllList(searchParam);
            riskList = this.mergeRiskList(preRiskList, postRiskList);
        }
        long num = riskList.stream().mapToLong(RegionRiskNumInfoVo::getResolveComNum).sum();
        BigDecimal amount = RiskCalculator.calculateEconomicForList(riskList);
        RiskVisualDto riskVisualDto = new RiskVisualDto();
        riskVisualDto.setNum(Long.valueOf(num));
        riskVisualDto.setAccount(amount);
        return riskVisualDto;
    }

    public List<RegionRiskNumInfoVo> getRegionRiskInfoAllList(RiskResolveResSearch searchParam) {
        List<RegionRiskNumInfoVo> riskList;
        boolean noDataSearch;
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany() == null ? 0 : searchParam.getIsFcImportanceCompany();
        boolean bl = noDataSearch = year != null && year <= 202401 && Objects.equals(isFcImportanceCompany, 1);
        if (noDataSearch) {
            return Collections.emptyList();
        }
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setReformStatus(ReformStatusEnum.WC.getValue()).setSearchType(Integer.valueOf(0)).setIsRegionRiskStatistics(Boolean.TRUE).setEnableRiskDateFilter(Boolean.TRUE);
        if (searchParam.getIsCurrent() == null) {
            searchParam.setIsCurrent(Objects.equals(regionLevel, (byte)3) || Objects.equals(regionLevel, (byte)4) ? Boolean.TRUE : null);
        }
        if (searchParam.getOnlyThisLevel() == null) {
            searchParam.setOnlyThisLevel(Objects.equals(regionLevel, (byte)3) || Objects.equals(regionLevel, (byte)4) ? Boolean.TRUE : null);
        }
        if (searchParam.getCompanyLevel() == null) {
            searchParam.setCompanyLevel(Integer.valueOf(Objects.equals(regionLevel, (byte)1) || Objects.equals(regionLevel, (byte)2) ? Convert.toInt((Object)regionLevel) : 0));
        }
        if (CollUtil.isEmpty(riskList = this.queryReformGenerationDataList(searchParam, year))) {
            return Collections.emptyList();
        }
        for (RegionRiskNumInfoVo r : riskList) {
            ReformItemBasicEconomyServiceImpl.setPunishAmountByResolveComNumNew(r);
        }
        return riskList;
    }

    private List<RegionRiskNumInfoVo> getRegionRiskInfoHistoryList(RiskResolveResSearch searchParam) {
        List<RegionRiskNumInfoVo> riskList;
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Integer page = searchParam.getPage();
        Integer rows = searchParam.getLimit();
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId})).setReformStatus(ReformStatusEnum.WC.getValue()).setSearchType(Integer.valueOf(0)).setIsRegionRiskStatistics(Boolean.TRUE).setEnableRiskDateFilter(Boolean.TRUE).setIsCurrent(Objects.equals(regionLevel, (byte)3) || Objects.equals(regionLevel, (byte)4) ? Boolean.TRUE : null);
        if (year == 2024) {
            if (Objects.equals(isFcImportanceCompany, 1)) {
                RiskResolveResSearch param2402 = new RiskResolveResSearch();
                BeanUtils.copyProperties((Object)searchParam, (Object)param2402);
                param2402.setYear(Integer.valueOf(202402));
                riskList = this.queryReformGenerationHistoryDataList(param2402);
                for (RegionRiskNumInfoVo r : riskList) {
                    ReformItemBasicEconomyServiceImpl.setPunishAmountByResolveComNumNew(r);
                }
            } else {
                RiskResolveResSearch param2401 = new RiskResolveResSearch();
                BeanUtils.copyProperties((Object)searchParam, (Object)param2401);
                param2401.setYear(Integer.valueOf(202401));
                List<RegionRiskNumInfoVo> preRiskList = this.queryReformGenerationHistoryDataList(param2401);
                RiskResolveResSearch param2402 = new RiskResolveResSearch();
                BeanUtils.copyProperties((Object)searchParam, (Object)param2402);
                param2402.setYear(Integer.valueOf(202402));
                List<RegionRiskNumInfoVo> postRiskList = this.queryReformGenerationHistoryDataList(param2402);
                Map<Long, RegionRiskNumInfoVo> preMap = preRiskList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, Function.identity()));
                Map<Long, RegionRiskNumInfoVo> postMap = postRiskList.stream().collect(Collectors.toMap(RegionRiskNumInfoVo::getRegionId, Function.identity()));
                riskList = this.mergeRiskList(preRiskList, postRiskList);
                ReformItemBasicEconomyServiceImpl.processEncapsulateRiskDataMix2024(riskList, preMap, postMap);
            }
        } else {
            RiskResolveResSearch param = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param);
            param.setYear(year);
            riskList = this.queryReformGenerationHistoryDataList(param);
            for (RegionRiskNumInfoVo r : riskList) {
                ReformItemBasicEconomyServiceImpl.setPunishAmountByResolveComNumNew(r);
            }
        }
        if (CollUtil.isEmpty(riskList)) {
            return Collections.emptyList();
        }
        return riskList;
    }

    private List<RegionRiskNumInfoVo> queryReformGenerationDataList(RiskResolveResSearch searchParam, Integer year) {
        searchParam.setYear(year);
        ReformItemBasicEconomyServiceImpl.handleQueryDateRange(searchParam);
        List<RegionRiskNumInfoVo> riskList = Collections.emptyList();
        if (this.calcDateIntersection(searchParam)) {
            if (year == null) {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                newSearchParam.setRows(searchParam.getLimit());
                newSearchParam.setLevel(searchParam.getAreaLevel());
                newSearchParam.setOnlyShowFcCompany(Boolean.valueOf(Objects.equals(searchParam.getIsFcImportanceCompany(), 1)));
                newSearchParam.setBelongType(searchParam.getCompanyLevel());
                newSearchParam.setIsPilotProject(searchParam.getIsPilotProject());
                List tableList = this.companyBusinessTableService.listDataByEconomicAccountTable(newSearchParam);
                riskList = new ArrayList<RegionRiskNumInfoVo>(this.convertTable2Vo(tableList));
            } else {
                CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
                BeanUtils.copyProperties((Object)searchParam, (Object)newSearchParam);
                newSearchParam.setRows(searchParam.getLimit());
                newSearchParam.setLevel(searchParam.getAreaLevel());
                newSearchParam.setOnlyShowFcCompany(Boolean.valueOf(Objects.equals(searchParam.getIsFcImportanceCompany(), 1)));
                newSearchParam.setBelongType(searchParam.getCompanyLevel());
                newSearchParam.setIsPilotProject(searchParam.getIsPilotProject());
                List tableList = this.companyBusinessTable20250630Service.listDataByEconomicAccountTable(newSearchParam);
                riskList = new ArrayList<RegionRiskNumInfoVo>(this.convertTable2Vo(tableList));
            }
        }
        if (CollUtil.isEmpty(riskList)) {
            riskList = this.reformItemBasicMapper.areaRiskNumCountDefaultListData(searchParam);
        }
        return riskList;
    }

    private List<RegionRiskNumInfoVo> queryReformGenerationHistoryDataList(RiskResolveResSearch param) {
        Integer year = param.getYear();
        ReformItemBasicEconomyServiceImpl.handleQueryDateRange(param);
        ArrayList<RegionRiskNumInfoVo> riskList = new ArrayList<RegionRiskNumInfoVo>();
        if (this.calcDateIntersection(param)) {
            List tableList;
            CompanyBusinessTableParam newSearchParam = new CompanyBusinessTableParam();
            BeanUtils.copyProperties((Object)param, (Object)newSearchParam);
            newSearchParam.setRows(param.getLimit());
            newSearchParam.setLevel(param.getAreaLevel());
            newSearchParam.setOnlyShowFcCompany(Boolean.valueOf(Objects.equals(param.getIsFcImportanceCompany(), 1)));
            newSearchParam.setBelongType(param.getCompanyLevel());
            if (year == 202501) {
                tableList = this.companyBusinessTable20250630Service.listDataByEconomicAccountTable(newSearchParam);
                riskList = new ArrayList<RegionRiskNumInfoVo>(this.convertTable2Vo(tableList));
            }
            if (year == 202402) {
                tableList = this.companyBusinessTable20241231Service.listDataByEconomicAccountTable(newSearchParam);
                riskList = new ArrayList<RegionRiskNumInfoVo>(this.convertTable2Vo(tableList));
            }
            if (year == 202401) {
                tableList = this.companyBusinessTable20240701Service.listDataByEconomicAccountTable(newSearchParam);
                riskList = new ArrayList<RegionRiskNumInfoVo>(this.convertTable2Vo(tableList));
            }
        }
        return riskList;
    }

    private static void processEncapsulateRiskDataMix2024(List<RegionRiskNumInfoVo> riskList, Map<Long, RegionRiskNumInfoVo> preNumMap, Map<Long, RegionRiskNumInfoVo> postNumMap) {
        riskList.forEach(r -> {
            RegionRiskNumInfoVo postNum;
            Long resolveComNum = 0L;
            BigDecimal lessFreePunishAmount = BigDecimal.ZERO;
            BigDecimal mostFreePunishAmount = BigDecimal.ZERO;
            BigDecimal freePunishAmount = BigDecimal.ZERO;
            RegionRiskNumInfoVo preNum = (RegionRiskNumInfoVo)preNumMap.get(r.getRegionId());
            if (preNum != null) {
                resolveComNum = preNum.getResolveComNum();
                lessFreePunishAmount = ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP);
                mostFreePunishAmount = ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP);
                freePunishAmount = ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP);
            }
            if ((postNum = (RegionRiskNumInfoVo)postNumMap.get(r.getRegionId())) != null) {
                r.setResolveComNum(postNum.getResolveComNum()).setSingleResolvePxNum(postNum.getSingleResolvePxNum()).setSingleResolveTjNum(postNum.getSingleResolveTjNum()).setMultipleResolve2Num(postNum.getMultipleResolve2Num()).setMultipleResolve3Num(postNum.getMultipleResolve3Num()).setMultipleResolve4Num(postNum.getMultipleResolve4Num()).setMultipleResolve5Num(postNum.getMultipleResolve5Num()).setMultipleResolve6Num(postNum.getMultipleResolve6Num()).setMultipleResolve7Num(postNum.getMultipleResolve7Num()).setMultipleResolve8Num(postNum.getMultipleResolve8Num());
                resolveComNum = resolveComNum + postNum.getResolveComNum();
                freePunishAmount = freePunishAmount.add(RiskCalculator.calculateEconomicForSingle((RegionRiskNumInfoVo)r));
                lessFreePunishAmount = lessFreePunishAmount.add(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(r.getResolveComNum()).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
                mostFreePunishAmount = mostFreePunishAmount.add(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(r.getResolveComNum()).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
            } else {
                r.setResolveComNum(Long.valueOf(0L)).setSingleResolvePxNum(Long.valueOf(0L)).setSingleResolveTjNum(Long.valueOf(0L)).setMultipleResolve2Num(Long.valueOf(0L)).setMultipleResolve3Num(Long.valueOf(0L)).setMultipleResolve4Num(Long.valueOf(0L)).setMultipleResolve5Num(Long.valueOf(0L)).setMultipleResolve6Num(Long.valueOf(0L)).setMultipleResolve7Num(Long.valueOf(0L)).setMultipleResolve8Num(Long.valueOf(0L));
            }
            r.setResolveComNum(resolveComNum);
            r.setLessFreePunishAmount(lessFreePunishAmount);
            r.setMostFreePunishAmount(mostFreePunishAmount);
            r.setFreePunishAmount(freePunishAmount);
        });
    }

    private static void setPunishAmountByResolveComNumOld(RegionRiskNumInfoVo r) {
        Long resolveComNum = Optional.ofNullable(r.getResolveComNum()).orElse(0L);
        r.setResolveComNum(resolveComNum);
        r.setFreePunishAmount(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setLessFreePunishAmount(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setMostFreePunishAmount(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
    }

    private static void setPunishAmountByResolveComNumNew(RegionRiskNumInfoVo r) {
        if (r == null) {
            return;
        }
        BigDecimal freePunishAmount = RiskCalculator.calculateEconomicForSingle((RegionRiskNumInfoVo)r);
        Long resolveComNum = r.getResolveComNum();
        r.setFreePunishAmount(freePunishAmount);
        r.setLessFreePunishAmount(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
        r.setMostFreePunishAmount(ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(resolveComNum).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP));
    }

    public void determineYearParamAndCalcFreePunishAmount(RiskResolveResSearch searchParam, RegionRiskStatisticsVo data) {
        Integer year = searchParam.getYear();
        Long regionId = searchParam.getAreaId();
        Byte regionLevel = searchParam.getAreaLevel();
        Integer isFcImportanceCompany = searchParam.getIsFcImportanceCompany();
        Boolean isExistRadioactivity = searchParam.getIsExistRadioactivity();
        Boolean isCurrent = searchParam.getIsCurrent();
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        searchParam.setRegionIdList((List)CollUtil.toList((Object[])new Long[]{regionId}));
        String helpCacheKey = String.format("%s:%s", HOME_INDEX_CACHE_KEY, this.generateCacheKey(year == null ? RiskCalculator.CURRENT_YEAR : year, regionId, regionLevel, isCurrent, isFcImportanceCompany == null ? 0 : isFcImportanceCompany, isExistRadioactivity, startDate == null ? null : DateUtil.format((Date)startDate, (String)"yyyyMMdd"), endDate == null ? null : DateUtil.format((Date)endDate, (String)"yyyyMMdd")));
        if (this.redisClient.hasKey(helpCacheKey)) {
            // empty if block
        }
        if (year == null) {
            RiskResolveResSearch param1 = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param1);
            param1.setYear(Convert.toInt((Object)(RiskCalculator.CURRENT_YEAR + "01")));
            List<RegionRiskNumInfoVo> preRiskList = this.getRegionRiskInfoAllList(param1);
            Long preNum = preRiskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
            BigDecimal preAmount = RiskCalculator.calculateEconomicForList(preRiskList);
            RiskResolveResSearch param2 = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param2);
            param2.setYear(null);
            List<RegionRiskNumInfoVo> postRiskList = this.getRegionRiskInfoAllList(param2);
            Long postNum = postRiskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
            BigDecimal postAmount = RiskCalculator.calculateEconomicForList(postRiskList);
            long num = preNum + postNum;
            String amount = SysConvertTool.convertUnit((BigDecimal)preAmount.add(postAmount).setScale(2, RoundingMode.HALF_UP));
            data.setCurrYearTotalResolveNum(Long.valueOf(num));
            data.setFreePunishAmount(amount);
        } else if (year == 2024) {
            RiskResolveResSearch param1 = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param1);
            param1.setYear(Integer.valueOf(202401));
            List<RegionRiskNumInfoVo> preRiskList = this.getRegionRiskInfoAllList(param1);
            Long preNum = preRiskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
            BigDecimal preAmount = ReformItemBasicEconomyServiceImpl.toBigDecimalSafe(preNum).multiply(RiskCalculator.MID_FREE_RATE).setScale(2, RoundingMode.HALF_UP);
            RiskResolveResSearch param2 = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param2);
            param2.setYear(Integer.valueOf(202402));
            List<RegionRiskNumInfoVo> postRiskList = this.getRegionRiskInfoAllList(param2);
            Long postNum = postRiskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
            BigDecimal postAmount = RiskCalculator.calculateEconomicForList(postRiskList);
            long num = preNum + postNum;
            String amount = SysConvertTool.convertUnit((BigDecimal)preAmount.add(postAmount).setScale(2, RoundingMode.HALF_UP));
            data.setCurrYearTotalResolveNum(Long.valueOf(num));
            data.setFreePunishAmount(amount);
        } else {
            RiskResolveResSearch param = new RiskResolveResSearch();
            BeanUtils.copyProperties((Object)searchParam, (Object)param);
            param.setYear(year);
            List<RegionRiskNumInfoVo> riskList = this.getRegionRiskInfoAllList(param);
            Long num = riskList.stream().map(RegionRiskNumInfoVo::getResolveComNum).filter(Objects::nonNull).reduce(0L, Long::sum);
            BigDecimal amountB = RiskCalculator.calculateEconomicForList(riskList);
            String amount = SysConvertTool.convertUnit((BigDecimal)amountB.setScale(2, RoundingMode.HALF_UP));
            data.setCurrYearTotalResolveNum(num);
            data.setFreePunishAmount(amount);
        }
        log.error("\u65e5\u5fd7\u6253\u5370::determineYearParamAndCalcFreePunishAmount::{},{}", (Object)data.getFreePunishAmount(), (Object)System.currentTimeMillis());
    }

    private List<RegionRiskNumInfoVo> convertTable2Vo(List<EconomicAccountTable> tableList) {
        if (CollUtil.isEmpty(tableList)) {
            return Collections.emptyList();
        }
        return tableList.stream().map(t -> new RegionRiskNumInfoVo().setRegionId(t.getAreaId()).setRegionLevel(t.getAreaLevel()).setRegionName(t.getAreaName()).setDeclare(t.getDeclare()).setTj(t.getTj()).setDetection(t.getDetection()).setTrain(t.getTrain()).setThreeTime(t.getThreeTime()).setProtection(t.getProtection()).setWarningSigns(t.getWarningSigns()).setArchives(t.getArchives()).setDetectExceedStand(t.getDetectExceedStand()).setTjYszyb(t.getTjYszyb()).setTjZyjjz(t.getTjZyjjz()).setDoseMonitor(t.getDoseMonitor()).setResolveComNum(Convert.toLong((Object)t.getCompanyRiskHasResolved())).setSingleResolvePxNum(Convert.toLong((Object)t.getSingleResolvePx())).setSingleResolveTjNum(Convert.toLong((Object)t.getSingleResolveTj())).setMultipleResolve2Num(Convert.toLong((Object)t.getMultipleResolve2())).setMultipleResolve3Num(Convert.toLong((Object)t.getMultipleResolve3())).setMultipleResolve4Num(Convert.toLong((Object)t.getMultipleResolve4())).setMultipleResolve5Num(Convert.toLong((Object)t.getMultipleResolve5())).setMultipleResolve6Num(Convert.toLong((Object)t.getMultipleResolve6())).setMultipleResolve7Num(Convert.toLong((Object)t.getMultipleResolve7())).setMultipleResolve8Num(Convert.toLong((Object)t.getMultipleResolve8()))).toList();
    }

    private static List<RegionRiskNumInfoVo> removeOnlyCityLevelElement(List<RegionRiskNumInfoVo> riskList) {
        if (riskList == null || CollUtil.isEmpty(riskList)) {
            return Collections.emptyList();
        }
        List<RegionRiskNumInfoVo> filterRiskList = riskList.stream().filter(r -> !r.getRegionName().contains("\u5e02\u672c\u7ea7")).toList();
        return filterRiskList;
    }

    public List<RegionRiskNumInfoVo> mergeRiskList(List<RegionRiskNumInfoVo> riskList01, List<RegionRiskNumInfoVo> riskList02) {
        return Stream.concat(riskList01.stream(), riskList02.stream()).map(RegionRiskNumInfoVo::getRegionId).distinct().map(regionId -> {
            RegionRiskNumInfoVo r1 = riskList01.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r2 = riskList02.stream().filter(r -> Objects.equals(r.getRegionId(), regionId)).findFirst().orElse(null);
            RegionRiskNumInfoVo r3 = new RegionRiskNumInfoVo();
            r3.setRegionId(regionId);
            if (r1 == null) {
                assert (r2 != null);
                BeanUtils.copyProperties((Object)r2, (Object)r3);
            } else if (r2 == null) {
                BeanUtils.copyProperties((Object)r1, (Object)r3);
            } else {
                r3.setRegionName(r1.getRegionName());
                r3.setDeclare(Integer.valueOf(r1.getDeclare() + r2.getDeclare()));
                r3.setTj(Integer.valueOf(r1.getTj() + r2.getTj()));
                r3.setDetection(Integer.valueOf(r1.getDetection() + r2.getDetection()));
                r3.setTrain(Integer.valueOf(r1.getTrain() + r2.getTrain()));
                r3.setThreeTime(Integer.valueOf(r1.getThreeTime() + r2.getThreeTime()));
                r3.setProtection(Integer.valueOf(r1.getProtection() + r2.getProtection()));
                r3.setWarningSigns(Integer.valueOf(r1.getWarningSigns() + r2.getWarningSigns()));
                r3.setArchives(Integer.valueOf(r1.getArchives() + r2.getArchives()));
                int detectExceedStand1 = r1.getDetectExceedStand() == null ? 0 : r1.getDetectExceedStand();
                int tjYszyb1 = r1.getTjYszyb() == null ? 0 : r1.getTjYszyb();
                int tjZyjjz1 = r1.getTjZyjjz() == null ? 0 : r1.getTjZyjjz();
                int doseMonitor1 = r1.getDoseMonitor() == null ? 0 : r1.getDoseMonitor();
                int detectExceedStand2 = r2.getDetectExceedStand() == null ? 0 : r2.getDetectExceedStand();
                int tjYszyb2 = r2.getTjYszyb() == null ? 0 : r2.getTjYszyb();
                int tjZyjjz2 = r2.getTjZyjjz() == null ? 0 : r2.getTjZyjjz();
                int doseMonitor2 = r2.getDoseMonitor() == null ? 0 : r2.getDoseMonitor();
                r3.setDetectExceedStand(Integer.valueOf(detectExceedStand1 + detectExceedStand2));
                r3.setTjYszyb(Integer.valueOf(tjYszyb1 + tjYszyb2));
                r3.setTjZyjjz(Integer.valueOf(tjZyjjz1 + tjZyjjz2));
                r3.setDoseMonitor(Integer.valueOf(doseMonitor1 + doseMonitor2));
                r3.setResolveComNum(Long.valueOf(r1.getResolveComNum() + r2.getResolveComNum()));
                r3.setSingleResolvePxNum(Long.valueOf(r1.getSingleResolvePxNum() + r2.getSingleResolvePxNum()));
                r3.setSingleResolveTjNum(Long.valueOf(r1.getSingleResolveTjNum() + r2.getSingleResolveTjNum()));
                r3.setMultipleResolve2Num(Long.valueOf(r1.getMultipleResolve2Num() + r2.getMultipleResolve2Num()));
                r3.setMultipleResolve3Num(Long.valueOf(r1.getMultipleResolve3Num() + r2.getMultipleResolve3Num()));
                r3.setMultipleResolve4Num(Long.valueOf(r1.getMultipleResolve4Num() + r2.getMultipleResolve4Num()));
                r3.setMultipleResolve5Num(Long.valueOf(r1.getMultipleResolve5Num() + r2.getMultipleResolve5Num()));
                r3.setMultipleResolve6Num(Long.valueOf(r1.getMultipleResolve6Num() + r2.getMultipleResolve6Num()));
                r3.setMultipleResolve7Num(Long.valueOf(r1.getMultipleResolve7Num() + r2.getMultipleResolve7Num()));
                r3.setMultipleResolve8Num(Long.valueOf(r1.getMultipleResolve8Num() + r2.getMultipleResolve8Num()));
            }
            return r3;
        }).toList();
    }

    private boolean calcDateIntersection(RiskResolveResSearch searchParam) {
        Date d1 = searchParam.getStartDate();
        Date d2 = searchParam.getEndDate();
        boolean defaultQuery = d1 == null || d2 == null;
        ReformItemBasicEconomyServiceImpl.handleQueryDateRange(searchParam);
        if (defaultQuery) {
            return Boolean.TRUE;
        }
        Date d3 = searchParam.getStartDate();
        Date d4 = searchParam.getEndDate();
        if (d2.before(d3) || d4.before(d1)) {
            return Boolean.FALSE;
        }
        searchParam.setStartDate(d1.after(d3) ? d1 : d3);
        searchParam.setEndDate(d2.before(d4) ? d2 : d4);
        return Boolean.TRUE;
    }

    public static void handleQueryDateRange(RiskResolveResSearch searchParam) {
        Date startDate = searchParam.getStartDate();
        Date endDate = searchParam.getEndDate();
        if (startDate != null && endDate != null) {
            return;
        }
        Integer year = searchParam.getYear();
        if (year == null) {
            ReformItemBasicEconomyServiceImpl.setDateRange(searchParam, "2025-07-01", "2099-12-31");
            return;
        }
        switch (year) {
            case 202401: {
                ReformItemBasicEconomyServiceImpl.setDateRange(searchParam, "2024-03-01", "2024-07-01");
                break;
            }
            case 202402: {
                ReformItemBasicEconomyServiceImpl.setDateRange(searchParam, "2024-07-01", "2024-12-31");
                break;
            }
            case 202501: {
                ReformItemBasicEconomyServiceImpl.setDateRange(searchParam, "2025-01-01", "2025-06-30");
                break;
            }
            case 202502: {
                ReformItemBasicEconomyServiceImpl.setDateRange(searchParam, "2025-07-01", "2025-12-31");
                break;
            }
        }
    }

    private static void setDateRange(RiskResolveResSearch searchParam, String startDate, String endDate) {
        try {
            searchParam.setStartDate(RiskCalculator.DATE_FORMAT.parse(startDate));
            searchParam.setEndDate(RiskCalculator.DATE_FORMAT.parse(endDate));
        }
        catch (Exception e) {
            throw new RuntimeException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", e);
        }
    }

    public String generateCacheKey(Object ... objs) {
        if (ArrayUtils.isNotEmpty((Object[])objs)) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : objs) {
                if (obj == null) continue;
                sb.append(obj.toString() + ":");
            }
            return sb.toString();
        }
        return "";
    }

    public static <T extends Serializable> List<T> deepCopy(List<T> list) {
        return (List)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)list))));
    }

    private static BigDecimal toBigDecimalSafe(Object value) {
        Convert.toBigDecimal(null);
        return value == null ? BigDecimal.ZERO : Convert.toBigDecimal((Object)value);
    }
}

