/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.common.IQaRecordService;
import cn.smarthse.modules.common.model.QaRecord;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.dao.work.reform.ReformItemAcceptanceRecordMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicCommandMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemSourceMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.ReformItemSource;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckConclusionEnum;
import cn.smarthse.modules.health.enums.reform.ReformAcceptanceRecordStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.pojo.DoseMonitorDataMaperModel;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformItemSourceService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateDataUtil;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.xxl.job.core.context.XxlJobHelper;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ReformItemBasicCommandServiceImpl
extends BaseServiceImpl<ReformItemBasicCommandMapper, ReformItemBasic>
implements IReformItemBasicCommandService {
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private ReformItemSourceMapper itemSourceMapper;
    @Autowired
    private ReformItemAcceptanceRecordMapper acceptanceRecordMapper;
    @Autowired
    IReformItemAcceptanceRecordService acceptanceRecordService;
    @Autowired
    IReformItemSourceService itemSourceService;
    @Autowired
    IReformItemBasicService itemBasicService;
    @DubboReference
    private INewCompanyGuideFinishedReportService companyGuideFinishedReportService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference
    private IQaRecordService qaRecordService;
    @DubboReference
    private IRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    RedisClient redisClient;
    private final String cacheName = "IReformItemBasicNewService";

    private static Integer getEffectiveYear(Integer reformYear) {
        if (reformYear == null) {
            return DateUtils.getThisYear();
        }
        Integer effectiveYear = DateUtils.getThisYear();
        if (!Objects.equals(reformYear, effectiveYear)) {
            effectiveYear = reformYear;
        }
        return effectiveYear;
    }

    private static String getEffectiveDateStr(Integer reformYear) {
        if (reformYear == null) {
            return DateUtils.getThisYear() + "-01-01 00:00:00";
        }
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Object effectiveDateStr = startOfDay.format(formatter);
        if (!Objects.equals(reformYear, DateUtils.getThisYear())) {
            effectiveDateStr = reformYear + "-01-01 00:00:00";
        }
        return effectiveDateStr;
    }

    public List<Long> getPilotAndNewCompanyList(List<Long> cidList) {
        return ((ReformItemBasicCommandMapper)this.dao).getCompanyList(cidList, "\u8bd5\u70b9\u4f01\u4e1a+\u65b0\u5efa\u6765\u6e90\u4f01\u4e1a");
    }

    @Transactional
    public List<Long> changeToPilotCompanyByType(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        List<Long> list = this.getPilotAndNewCompanyList(cidList);
        cidList.removeAll(list);
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        this.companyProvideBySuperviseService.updateCompanyCase(cidList, Integer.valueOf(2));
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andEqualTo("findTimeYear", (Object)2025).andIn("status", List.of(ReformStatusEnum.CG.getValue(), ReformStatusEnum.DZG.getValue())).andIn("generationSource", List.of(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 3, 4, 5, 21, 24)).andIn("cid", cidList);
        example.selectProperties(new String[]{"id"});
        List<Long> basicList = this.getListByExample(example).stream().filter(Objects::nonNull).map(ReformItemBasic::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(basicList)) {
            ((ReformItemBasicCommandMapper)this.dao).backupReformToPilot(basicList, 1);
            ((ReformItemBasicCommandMapper)this.dao).backupReformToPilot(basicList, 2);
            ((ReformItemBasicCommandMapper)this.dao).backupReformToPilot(basicList, 3);
            ((ReformItemBasicCommandMapper)this.dao).backupReformToPilot(basicList, 4);
            Example example2 = new Example(ReformItemBasic.class);
            example2.createCriteria().andIn("id", basicList);
            ((ReformItemBasicCommandMapper)this.dao).deleteByExample(example2);
            ((ReformItemBasicCommandMapper)this.dao).deleteReformCheckMeasure(basicList);
            Example example3 = new Example(ReformItemSource.class);
            example3.createCriteria().andIn("reformItemId", basicList);
            this.itemSourceMapper.deleteByExample(example3);
            Example example4 = new Example(ReformItemAcceptanceRecord.class);
            example4.createCriteria().andIn("reformItemId", basicList);
            this.acceptanceRecordMapper.deleteByExample(example4);
        }
        return cidList;
    }

    public ReformItemBasic getByIdAndRecordDetail(Long id) {
        ReformItemBasic basic = (ReformItemBasic)this.getById(id);
        if (basic == null) {
            return null;
        }
        List recordList = this.acceptanceRecordService.getListByReformItemId(basic.getId());
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return basic;
        }
        basic.setAceptanceList(recordList);
        basic.setAcceptance((ReformItemAcceptanceRecord)recordList.get(recordList.size() - 1));
        return basic;
    }

    public List<ReformItemBasic> getReformItemBasicList(ReformSearchVo searchVo) {
        return ((ReformItemBasicCommandMapper)this.dao).getReformItemBasicList(searchVo);
    }

    public Boolean getHashRisk(Long cid, int year) {
        return ((ReformItemBasicCommandMapper)this.dao).getHashRisk(cid, year);
    }

    @Transactional(readOnly=false)
    public Integer generateReform(List<ReformAddParam> addParamList) {
        if (CollectionUtils.isEmpty(addParamList)) {
            return 0;
        }
        Date currDate = new Date();
        ArrayList<ReformItemBasic> basicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemSource> sourceList = new ArrayList<ReformItemSource>();
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>();
        Map areaDetailMap = ((ReformItemBasicCommandMapper)this.dao).getReformCompanyAreaDetail(addParamList.stream().filter(Objects::nonNull).map(ReformAddParam::getCid).toList()).stream().collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (a, b) -> a));
        for (ReformAddParam addParam : addParamList) {
            long days;
            if (addParam == null) continue;
            ReformItemSource source = new ReformItemSource();
            source.setId(Long.valueOf(this.idworker.nextId()));
            BeanUtils.copyProperties((Object)addParam, (Object)source);
            Long cid = source.getCid();
            if (source.getFindTime() != null) {
                source.setFindTimeYear(Integer.valueOf(DateUtils.getYear((Date)source.getFindTime())));
            } else {
                source.setFindTime(currDate);
                source.setFindTimeYear(Integer.valueOf(DateUtils.getYear((Date)currDate)));
            }
            if ((days = DateUtils.compare_time((Date)currDate, (Date)source.getFindTime())) < 0L) continue;
            if (source.getGenerationSource().intValue() == 13) {
                if (StringUtils.isNotBlank((CharSequence)source.getName())) {
                    source.setName(source.getName().replace("\u201d\u4e09\u540c\u65f6\u201c", "\u201c\u4e09\u540c\u65f6\u201d"));
                }
                if (StringUtils.isNotBlank((CharSequence)source.getDescription())) {
                    source.setDescription(source.getDescription().replace("\u201d\u4e09\u540c\u65f6\u201c", "\u201c\u4e09\u540c\u65f6\u201d"));
                }
            }
            if (Objects.equals(source.getGenerationSource(), ReformGenerationSourceEnum.GRJL.getValue())) {
                if (days < 30L) {
                    source.setLawStatus(Byte.valueOf((byte)2));
                } else {
                    source.setLawStatus(Byte.valueOf((byte)3));
                }
            }
            if (areaDetailMap.containsKey(cid)) {
                ReformItemBasic areaDetail = (ReformItemBasic)areaDetailMap.get(cid);
                source.setAreaId(areaDetail.getAreaId());
                source.setAreaId1(areaDetail.getAreaId1());
                source.setAreaId2(areaDetail.getAreaId2());
                source.setAreaId3(areaDetail.getAreaId3());
                source.setAreaId4(areaDetail.getAreaId4());
            }
            source.setReformItemId(source.getId());
            source.setStatus(ReformStatusEnum.DZG.getValue());
            source.setCreateBy(source.getCreateBy());
            source.setCreateDate(currDate);
            source.setUpdateBy(source.getCreateBy());
            source.setUpdateDate(currDate);
            source.setIsValid(Boolean.valueOf(true));
            sourceList.add(source);
            ReformItemBasic basic = new ReformItemBasic();
            BeanUtils.copyProperties((Object)source, (Object)basic);
            basicList.add(basic);
            ReformItemAcceptanceRecord acc = new ReformItemAcceptanceRecord();
            acc.setId(Long.valueOf(this.idworker.nextId()));
            acc.setReformMeasure(addParam.getReformMeasure());
            acc.setReformItemId(basic.getId());
            acc.setStatus(ReformAcceptanceRecordStatusEnum.CG.getValue());
            acc.setCid(cid);
            acc.setCreateBy(source.getCreateBy());
            acc.setCreateDate(currDate);
            acc.setUpdateBy(source.getCreateBy());
            acc.setUpdateDate(currDate);
            acc.setIsValid(Boolean.valueOf(true));
            accList.add(acc);
        }
        if (CollectionUtils.isEmpty(sourceList) && CollectionUtils.isEmpty(basicList) && CollectionUtils.isEmpty(accList)) {
            return 0;
        }
        List<ReformItemBasic> basicMergeList = basicList.stream().filter(Objects::nonNull).filter(item -> ReformGenerationSourceEnum.getEightGenerationSourceValue().contains(item.getGenerationSource())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(basicMergeList)) {
            Set basicMergeIdList = basicMergeList.parallelStream().map(ReformItemBasic::getId).collect(Collectors.toSet());
            List<ReformItemSource> sourceMergeList = sourceList.parallelStream().filter(item -> basicMergeIdList.contains(item.getId())).collect(Collectors.toList());
            List<ReformItemAcceptanceRecord> accMergeList = accList.parallelStream().filter(item -> basicMergeIdList.contains(item.getReformItemId())).collect(Collectors.toList());
            basicList.removeAll(basicMergeList);
            sourceList.removeAll(sourceMergeList);
            accList.removeAll(accMergeList);
            Map<String, Object> map = this.processMerge(basicMergeList, sourceMergeList, accMergeList);
            basicList.addAll((List)map.get("basicListNew"));
            sourceList.addAll((List)map.get("sourceListNew"));
            accList.addAll((List)map.get("accListNew"));
        }
        if (CollectionUtils.isNotEmpty(basicList)) {
            ListUtils.split(basicList, (int)2000).forEach(reformItemBasicList -> ((ReformItemBasicCommandMapper)this.dao).insertList2((List)reformItemBasicList));
        }
        if (CollectionUtils.isNotEmpty(sourceList)) {
            List split = ListUtils.split(sourceList, (int)2000);
            split.forEach(reformItemSources -> this.itemSourceService.insertList2(reformItemSources));
            for (List reformItemSources2 : split) {
                List<Long> collect = reformItemSources2.parallelStream().map(ReformItemSource::getReformItemId).distinct().collect(Collectors.toList());
                ((ReformItemBasicCommandMapper)this.dao).updateReformItemSourceMulti(collect);
            }
        }
        if (CollectionUtils.isNotEmpty(accList)) {
            ListUtils.split(accList, (int)2000).forEach(acceptanceRecordList -> this.acceptanceRecordService.addRecordList(acceptanceRecordList));
        }
        return sourceList.size();
    }

    @Transactional
    public void generatePilotReform(String cids) {
        this.autoAddReformByCheck(cids);
        this.autoAddReformByPhy(false, cids, null);
        this.autoAddReformByGRJLCL(cids);
        this.autoGenKeyFactorReform(cids);
        this.generateQaRecordByJCCB(StringUtils.parseToLongList((String)cids));
    }

    public Map<String, Object> processMerge(List<ReformItemBasic> basicMergeList, List<ReformItemSource> sourceMergeList, List<ReformItemAcceptanceRecord> accMergeList) {
        Map<Object, Object> cidAndBasicMap = new HashMap();
        List<Object> containKeyFactoryIdList = new ArrayList();
        ReformSearchVo reformSearchVo = new ReformSearchVo().setCidList(basicMergeList.stream().filter(Objects::nonNull).map(ReformItemBasic::getCid).toList()).setGenerationSources(basicMergeList.stream().filter(Objects::nonNull).map(ReformItemBasic::getGenerationSource).distinct().toList()).setYear(Integer.valueOf(DateUtils.getThisYear())).setExcludeSuspendedStatus(Boolean.valueOf(true));
        List<ReformItemBasic> list = this.getReformItemBasicList(reformSearchVo);
        if (CollectionUtils.isNotEmpty(list)) {
            cidAndBasicMap = list.parallelStream().collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.toMap(ReformItemBasic::getGenerationSource, Function.identity(), (a, b) -> a.getCreateDate().getTime() >= b.getCreateDate().getTime() ? a : b)));
            List<Long> lastReformIdList = cidAndBasicMap.values().stream().flatMap(map -> map.values().stream()).map(ReformItemBasic::getId).collect(Collectors.toList());
            containKeyFactoryIdList = ((ReformItemBasicCommandMapper)this.dao).getLastReformHaveKeyFactor(lastReformIdList);
        }
        HashMap finalCidAndBasicMap = cidAndBasicMap;
        ArrayList finalContainKeyFactoryIdList = containKeyFactoryIdList;
        ArrayList basicListNew = new ArrayList();
        ArrayList sourceListNew = new ArrayList();
        ArrayList accListNew = new ArrayList();
        Map<Long, Map<Byte, List<ReformItemSource>>> collect = sourceMergeList.parallelStream().collect(Collectors.groupingBy(ReformItemSource::getCid, Collectors.groupingBy(ReformItemSource::getGenerationSource)));
        collect.forEach((cid, generationReformList) -> generationReformList.forEach((generationSource, reformItemSourceList) -> {
            ReformItemSource oneSource = (ReformItemSource)reformItemSourceList.get(0);
            Integer sourceFrom = oneSource.getReformItemSource().intValue();
            ReformItemBasic lastReformItemBasic = null;
            if (finalCidAndBasicMap.get(cid) != null && ((Map)finalCidAndBasicMap.get(cid)).get(generationSource) != null) {
                lastReformItemBasic = (ReformItemBasic)((Map)finalCidAndBasicMap.get(cid)).get(generationSource);
            }
            if (sourceFrom.equals(8)) {
                if (lastReformItemBasic != null && lastReformItemBasic.getStatus().intValue() != 3 && lastReformItemBasic.getStatus().intValue() != 4) {
                    if (!finalContainKeyFactoryIdList.contains(lastReformItemBasic.getId())) {
                        oneSource.setReformItemId(lastReformItemBasic.getId());
                        oneSource.setStatus(lastReformItemBasic.getStatus());
                        oneSource.setActualFinishTime(lastReformItemBasic.getActualFinishTime());
                        oneSource.setReformDirectorName(lastReformItemBasic.getReformDirectorName());
                        oneSource.setAcceptanceDate(lastReformItemBasic.getAcceptanceDate());
                        oneSource.setAcceptanceDirectorName(lastReformItemBasic.getAcceptanceDirectorName());
                        sourceListNew.add(oneSource);
                    }
                } else {
                    sourceListNew.add(oneSource);
                    ReformItemBasic basic = basicMergeList.stream().filter(item -> item.getId().equals(oneSource.getId())).findFirst().get();
                    basicListNew.add(basic);
                    ReformItemAcceptanceRecord acc = accMergeList.stream().filter(item -> item.getReformItemId().equals(oneSource.getId())).findFirst().get();
                    accListNew.add(acc);
                }
            } else if (lastReformItemBasic != null) {
                for (ReformItemSource item2 : reformItemSourceList) {
                    item2.setReformItemId(lastReformItemBasic.getId());
                    item2.setStatus(lastReformItemBasic.getStatus());
                    item2.setActualFinishTime(lastReformItemBasic.getActualFinishTime());
                    item2.setReformDirectorName(lastReformItemBasic.getReformDirectorName());
                    item2.setAcceptanceDate(lastReformItemBasic.getAcceptanceDate());
                    item2.setAcceptanceDirectorName(lastReformItemBasic.getAcceptanceDirectorName());
                }
                sourceListNew.addAll(reformItemSourceList);
            } else {
                for (ReformItemSource item3 : reformItemSourceList) {
                    item3.setReformItemId(oneSource.getId());
                }
                sourceListNew.addAll(reformItemSourceList);
                ReformItemBasic basic = basicMergeList.stream().filter(item -> item.getId().equals(oneSource.getId())).findFirst().get();
                basicListNew.add(basic);
                ReformItemAcceptanceRecord acc = accMergeList.stream().filter(item -> item.getReformItemId().equals(oneSource.getId())).findFirst().get();
                accListNew.add(acc);
            }
        }));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("basicListNew", basicListNew);
        map2.put("sourceListNew", sourceListNew);
        map2.put("accListNew", accListNew);
        return map2;
    }

    @Transactional
    public void autoAddReformByCheck(String cids) {
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u5230\u4f01\u4e1a\u7aef\u7684\u6574\u6539\u5f00\u59cb", (Object[])new Object[0]);
        List<Long> cidList = this.getPilotAndNewCompanyList(StringUtils.parseToLongList((String)cids));
        if (CollectionUtils.isEmpty(cidList)) {
            XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u5230\u4f01\u4e1a\u7aef\u7684\u6574\u6539\u5f00\u59cb--\u6ca1\u6709", (Object[])new Object[0]);
            return;
        }
        this.generateNotConvertToReformByCheck(cidList);
        this.updateConvertToReformByCheck(cidList);
        List<ReformItemBasic> passHistoryDysJCCBRefromList = ((ReformItemBasicCommandMapper)this.dao).passJCCBRefrom(cidList);
        if (CollectionUtils.isNotEmpty(passHistoryDysJCCBRefromList)) {
            this.makeAndUpdateReform(passHistoryDysJCCBRefromList, null, (byte)3, null);
            XxlJobHelper.log((String)("\u81ea\u52a8\u9a8c\u6536\u8d85\u6807\u98ce\u9669\u6570\u91cf\uff1a" + passHistoryDysJCCBRefromList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(passHistoryDysJCCBRefromList.stream().filter(Objects::nonNull).map(ReformItemBasic::getId).limit(10L).toList())), (Object[])new Object[0]);
        }
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u5230\u4f01\u4e1a\u7aef\u7684\u6574\u6539\u7ed3\u675f", (Object[])new Object[0]);
    }

    private void generateNotConvertToReformByCheck(List<Long> cidList) {
        List<CheckPlan> checkList = ((ReformItemBasicCommandMapper)this.dao).getNotConvertToReformByRiskData(cidList, null);
        XxlJobHelper.log((String)("\u4ece\u672a\u751f\u6210\u8fc7\u68c0\u6d4b\u8d85\u6807\u98ce\u9669\u7684\u6570\u91cf\uff1a" + checkList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(checkList.stream().filter(Objects::nonNull).map(BaseEntity::getId).limit(10L).toList())), (Object[])new Object[0]);
        ArrayList<ReformAddParam> reformAddParamList = new ArrayList<ReformAddParam>();
        ArrayList<Long> reformItemSourceIdList = new ArrayList<Long>();
        for (CheckPlan check : checkList) {
            if (check == null) continue;
            ReformAddParam param = new ReformAddParam();
            param.setCid(check.getCid());
            param.setFinderName(check.getThirdOrgName());
            param.setFindTime(DateUtils.localDateTimeToDate((LocalDateTime)check.getCreateDate()));
            param.setName((String)(StringUtils.isBlank((CharSequence)check.getProjectName()) ? "\u68c0\u6d4b\u7ed3\u679c\u5b58\u5728\u8d85\u6807" : check.getProjectName() + "--\u68c0\u6d4b\u7ed3\u679c\u5b58\u5728\u8d85\u6807"));
            param.setReformItemSource(ReformSourceLiteEnum.ZYBWHYSJC.getValue());
            param.setReformItemSourceId(check.getId());
            param.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
            param.setDescription("\u7528\u4eba\u5355\u4f4d\u672a\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u68c0\u6d4b\u8d85\u6807\u6574\u6539\u5de5\u4f5c");
            reformAddParamList.add(param);
            reformItemSourceIdList.add(check.getId());
        }
        if (CollectionUtils.isEmpty(reformAddParamList)) {
            return;
        }
        this.generateReform(reformAddParamList);
        Map acceptIdMap = ((ReformItemBasicCommandMapper)this.dao).getReformItemBasicIdListBySourceId(reformItemSourceIdList).stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemBasic::getReformItemSourceId, Function.identity(), (ol, ne) -> ol));
        List split = ListUtils.split(checkList, (int)500);
        for (List newCheckList : split) {
            if (CollectionUtils.isEmpty((Collection)newCheckList)) continue;
            List<Long> riskExposeEvaluateIds = newCheckList.stream().filter(Objects::nonNull).map(CheckPlan::getRiskExposeEvaluateId).collect(Collectors.toList());
            Map<Long, List<RiskExposeEvaluateData>> evaluateDataListMap = ((ReformItemBasicCommandMapper)this.dao).getEvaluateDataList(riskExposeEvaluateIds, true).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
            ArrayList<ReformCheckMeasure> addList = new ArrayList<ReformCheckMeasure>();
            for (CheckPlan check : newCheckList) {
                ReformItemBasic basic;
                List<RiskExposeEvaluateData> evaluateDataList;
                if (check == null || CollectionUtils.isEmpty(evaluateDataList = evaluateDataListMap.get(check.getRiskExposeEvaluateId())) || (basic = (ReformItemBasic)acceptIdMap.get(check.getId())) == null) continue;
                for (RiskExposeEvaluateData evaluateData : evaluateDataList) {
                    ReformCheckMeasure measure = new ReformCheckMeasure();
                    measure.setId(Long.valueOf(this.idworker.nextId()));
                    measure.setCid(check.getCid());
                    measure.setCheckId(check.getId());
                    measure.setChangeTime(check.getUpdateDate());
                    measure.setReformId(basic.getId());
                    measure.setAcceptRecordId(basic.getAccLastId());
                    measure.setFactoryName(evaluateData.getFactorName());
                    String pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint();
                    measure.setPointName(pointName);
                    measure.setSituation(Integer.valueOf(0));
                    measure.setCreateDate(new Date());
                    measure.setUpdateDate(new Date());
                    addList.add(measure);
                }
            }
            this.acceptanceRecordService.insertReformCheckMeasureList(addList);
        }
        XxlJobHelper.log((String)("\u4ece\u672a\u751f\u6210\u8fc7\u68c0\u6d4b\u8d85\u6807\u98ce\u9669\u7684\u6570\u91cf(\u5b9e\u9645\u6570\u91cf)\uff1a" + acceptIdMap.size()), (Object[])new Object[0]);
    }

    private void updateConvertToReformByCheck(List<Long> cidList) {
        List<ReformItemBasic> updateCheckWithRiskList = ((ReformItemBasicCommandMapper)this.dao).getUpdateCheckWithRisk(cidList);
        XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\uff08\u6307\u63aa\u65bd\u4fee\u6539\u65f6\u95f4\u5728\u68c0\u6d4b\u65f6\u95f4\u4e4b\u540e\uff09\u7684\u8d85\u6807\u98ce\u9669\u6570\u91cf\uff1a" + updateCheckWithRiskList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(updateCheckWithRiskList.stream().filter(Objects::nonNull).map(ReformItemBasic::getId).limit(10L).toList())), (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(updateCheckWithRiskList)) {
            return;
        }
        ArrayList<Long> riskIdList = new ArrayList<Long>();
        ArrayList accLastIdList = new ArrayList();
        ArrayList areadlyPassCheckList = new ArrayList();
        updateCheckWithRiskList.stream().filter(basic -> basic != null && basic.getRiskExposeEvaluateId() != null && basic.getAccLastId() != null).forEach(basic -> {
            riskIdList.add(basic.getRiskExposeEvaluateId());
            accLastIdList.add(basic.getAccLastId());
            if (Arrays.asList(3, 4).contains(basic.getStatus().intValue())) {
                areadlyPassCheckList.add(basic.getReformItemSourceId());
            }
        });
        Map<Long, List<RiskExposeEvaluateData>> evaluateDataListMap = ((ReformItemBasicCommandMapper)this.dao).getEvaluateDataList(riskIdList, null).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
        Map<Long, List<ReformCheckMeasure>> measureMap = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(false)).setAcceptRecordIds(accLastIdList)).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformCheckMeasure::getAcceptRecordId));
        Map<Long, List<ReformCheckMeasure>> measurePassMap = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setIsOld(Boolean.valueOf(false)).setCheckIds(areadlyPassCheckList)).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformCheckMeasure::getCheckId));
        Date date = new Date();
        ArrayList<Object> addList = new ArrayList<Object>();
        ArrayList<ReformCheckMeasure> updateList = new ArrayList<ReformCheckMeasure>();
        ArrayList<ReformCheckMeasure> updateChangeTimeList = new ArrayList<ReformCheckMeasure>();
        HashSet<ReformAddParam> reformAddParamList = new HashSet<ReformAddParam>();
        ArrayList<ReformCheckMeasure> addNewList = new ArrayList<ReformCheckMeasure>();
        for (ReformItemBasic basic2 : updateCheckWithRiskList) {
            if (basic2 == null) continue;
            List dataList = Optional.ofNullable(evaluateDataListMap.get(basic2.getRiskExposeEvaluateId())).orElse(new ArrayList());
            List checkMeasureList = Optional.ofNullable(measureMap.get(basic2.getAccLastId())).orElse(new ArrayList());
            if (CollectionUtils.isEmpty((Collection)dataList) || CollectionUtils.isEmpty((Collection)checkMeasureList)) continue;
            Map stringRiskMap = dataList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getWorkshop() + "@" + item.getWorkName() + "@" + item.getCheckPoint() + item.getFactorName(), Function.identity(), (a, b) -> b));
            Map stringMeasureMap = checkMeasureList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getPointName() + item.getFactoryName(), Function.identity(), (a, b) -> b));
            Map stringMeasureAllMap = ((List)Optional.ofNullable(measurePassMap.get(basic2.getReformItemSourceId())).orElse(new ArrayList())).stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getPointName() + item.getFactoryName(), Function.identity(), (a, b) -> b));
            if (Arrays.asList(3, 4).contains(basic2.getStatus().intValue())) {
                boolean isHaveNewReform = false;
                for (RiskExposeEvaluateData evaluateData : dataList) {
                    String pointName;
                    String name;
                    ReformCheckMeasure checkMeasure;
                    if (evaluateData == null || evaluateData.getCheckTouchLevel() != 1 || (checkMeasure = (ReformCheckMeasure)stringMeasureAllMap.get(name = (pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint()) + evaluateData.getFactorName())) != null) continue;
                    isHaveNewReform = true;
                    ReformCheckMeasure measure = new ReformCheckMeasure();
                    measure.setId(Long.valueOf(this.idworker.nextId()));
                    measure.setCid(basic2.getCid());
                    measure.setCheckId(basic2.getReformItemSourceId());
                    measure.setChangeTime(DateUtil.getFromDate((Date)basic2.getLastUpdate()));
                    measure.setReformId(null);
                    measure.setAcceptRecordId(null);
                    measure.setFactoryName(evaluateData.getFactorName());
                    measure.setPointName(pointName);
                    measure.setSituation(Integer.valueOf(0));
                    measure.setCreateDate(date);
                    measure.setUpdateDate(date);
                    addNewList.add(measure);
                }
                if (isHaveNewReform) {
                    ReformAddParam param = new ReformAddParam();
                    param.setCid(basic2.getCid());
                    param.setFinderName(basic2.getFinderName());
                    param.setFindTime(basic2.getLastUpdate());
                    param.setName(basic2.getName());
                    param.setReformItemSource(ReformSourceLiteEnum.ZYBWHYSJC.getValue());
                    param.setReformItemSourceId(basic2.getReformItemSourceId());
                    param.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
                    param.setDescription(basic2.getDescription());
                    reformAddParamList.add(param);
                    continue;
                }
                for (ReformCheckMeasure measure : checkMeasureList) {
                    if (measure == null || measure.getChangeTime().equals(DateUtil.getFromDate((Date)basic2.getLastUpdate()))) continue;
                    ReformCheckMeasure updateMeasure = new ReformCheckMeasure();
                    updateMeasure.setId(measure.getId());
                    updateMeasure.setChangeTime(DateUtil.getFromDate((Date)basic2.getLastUpdate()));
                    if (measure.getUpdateDate() != null) {
                        updateMeasure.setUpdateDate(measure.getUpdateDate());
                    } else {
                        updateMeasure.setUpdateDate(date);
                    }
                    updateChangeTimeList.add(updateMeasure);
                }
                continue;
            }
            for (ReformCheckMeasure measure : checkMeasureList) {
                if (measure == null) continue;
                if (!measure.getChangeTime().equals(DateUtil.getFromDate((Date)basic2.getLastUpdate()))) {
                    ReformCheckMeasure updateMeasure = new ReformCheckMeasure();
                    updateMeasure.setId(measure.getId());
                    updateMeasure.setChangeTime(DateUtil.getFromDate((Date)basic2.getLastUpdate()));
                    updateMeasure.setUpdateDate(date);
                    updateChangeTimeList.add(updateMeasure);
                }
                if (Arrays.asList(2, 3).contains(measure.getSituation())) continue;
                String name = measure.getPointName() + measure.getFactoryName();
                RiskExposeEvaluateData evaluateData = (RiskExposeEvaluateData)stringRiskMap.get(name);
                if (evaluateData == null) {
                    measure.setSituation(Integer.valueOf(3));
                    measure.setUpdateDate(date);
                    measure.setUpdateBy(Long.valueOf(1L));
                    updateList.add(measure);
                    continue;
                }
                if (evaluateData.getCheckTouchLevel() == 1) continue;
                measure.setSituation(Integer.valueOf(2));
                measure.setUpdateDate(date);
                measure.setUpdateBy(Long.valueOf(1L));
                updateList.add(measure);
            }
            for (RiskExposeEvaluateData evaluateData : dataList) {
                String pointName;
                String name;
                ReformCheckMeasure checkMeasure;
                if (evaluateData == null || evaluateData.getCheckTouchLevel() != 1 || (checkMeasure = (ReformCheckMeasure)stringMeasureMap.get(name = (pointName = evaluateData.getWorkshop() + "@" + evaluateData.getWorkName() + "@" + evaluateData.getCheckPoint()) + evaluateData.getFactorName())) != null) continue;
                ReformCheckMeasure measure = new ReformCheckMeasure();
                measure.setId(Long.valueOf(this.idworker.nextId()));
                measure.setCid(basic2.getCid());
                measure.setCheckId(basic2.getReformItemSourceId());
                measure.setChangeTime(DateUtil.getFromDate((Date)basic2.getLastUpdate()));
                measure.setReformId(basic2.getId());
                measure.setAcceptRecordId(basic2.getAccLastId());
                measure.setFactoryName(evaluateData.getFactorName());
                measure.setPointName(pointName);
                measure.setSituation(Integer.valueOf(0));
                measure.setCreateDate(date);
                measure.setUpdateDate(date);
                addList.add(measure);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.acceptanceRecordService.updateBatchReformCheckMeasure(updateList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u667a\u80fd\u5904\u7f6e\u5c0f\u9879\u6570\u91cf\uff1a" + updateList.size() + "\u6574\u6539id\u4f8b\u5982\uff1a" + String.valueOf(updateList.stream().filter(item -> item != null && item.getReformId() != null).map(ReformCheckMeasure::getReformId).limit(10L).toList())), (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(updateChangeTimeList)) {
            this.acceptanceRecordService.updateBatchReformCheckMeasure(updateChangeTimeList);
        }
        if (CollectionUtils.isNotEmpty(reformAddParamList)) {
            this.generateReform(new ArrayList<ReformAddParam>(reformAddParamList));
            Map acceptIdMap = ((ReformItemBasicCommandMapper)this.dao).getReformItemBasicIdListBySourceId(reformAddParamList.stream().filter(Objects::nonNull).map(ReformAddParam::getReformItemSourceId).toList()).stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemBasic::getReformItemSourceId, Function.identity(), (ol, ne) -> ol));
            for (ReformCheckMeasure measure : addNewList) {
                if (measure == null) continue;
                ReformItemBasic basic3 = (ReformItemBasic)acceptIdMap.get(measure.getCheckId());
                if (basic3 == null) {
                    XxlJobHelper.log((String)("\u5904\u7406\u9700\u8981\u65b0\u751f\u6210\u4e00\u4efd\u8d85\u6807\u7684\u98ce\u9669\u5f02\u5e38\uff1a\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6574\u6539\u5355" + measure.getId()), (Object[])new Object[0]);
                    throw new RuntimeException("\u5904\u7406\u9700\u8981\u65b0\u751f\u6210\u4e00\u4efd\u8d85\u6807\u7684\u98ce\u9669\u5f02\u5e38\uff1a\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6574\u6539\u5355" + measure.getId());
                }
                measure.setReformId(basic3.getId());
                measure.setAcceptRecordId(basic3.getAccLastId());
            }
            addList.addAll(addNewList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u6709\u5df2\u5ba1\u6838\u989d\u5916\u518d\u751f\u6210\u7684\u6570\u91cf\uff1a" + reformAddParamList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(reformAddParamList.stream().filter(Objects::nonNull).map(ReformAddParam::getReformItemSourceId).limit(10L).toList())), (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            this.acceptanceRecordService.saveBatchReformCheckMeasure(addList);
            XxlJobHelper.log((String)("\u68c0\u6d4b\u6570\u636e\u6709\u66f4\u65b0\u7684\u8d85\u6807\u98ce\u9669,\u5176\u4e2d\u6709\u65b0\u589e\u5c0f\u9879\u7684\u6570\u91cf\uff1a" + addList.size() + "\u68c0\u6d4bid\u4f8b\u5982\uff1a" + String.valueOf(addList.stream().filter(Objects::nonNull).map(ReformCheckMeasure::getCheckId).distinct().limit(10L).toList())), (Object[])new Object[0]);
        }
    }

    @Transactional
    public void autoAddReformByPhy(Boolean isNotPush, String cids, String dateStr) {
        List<Long> cidList = this.getPilotAndNewCompanyList(StringUtils.parseToLongList((String)cids));
        if (CollectionUtils.isEmpty(cidList)) {
            XxlJobHelper.log((String)"\u751f\u6210phy\u6570\u636e\u5f00\u59cb--\u6ca1\u6709", (Object[])new Object[0]);
            return;
        }
        ReformSearchVo reformSearchVo = new ReformSearchVo().setExcludeSuspendedStatus(Boolean.valueOf(true)).setCidList(cidList).setBackStrName("tj_business_id");
        List<String> tjIds = this.getReformItemBasicList(reformSearchVo).stream().filter(item -> item != null && item.getTjBusinessId() != null).map(ReformItemBasic::getTjBusinessId).collect(Collectors.toList());
        List<PhcPhysicalStaffCheckInfo> list = ((ReformItemBasicCommandMapper)this.dao).getListByConclusions(tjIds, cidList, dateStr);
        List ysZybList = list.stream().filter(item -> item != null && item.getCardId() != null).collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getCardId, item -> item, (item1, item2) -> item1.getCreateDate().after(item2.getCreateDate()) ? item1 : item2)).values().stream().collect(Collectors.toList());
        if (!Objects.equals(list.size(), ysZybList.size())) {
            list.removeAll(ysZybList);
            XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u5b58\u5728\u91cd\u590dcardId:" + String.valueOf(list)), (Object[])new Object[0]);
        }
        XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u98ce\u9669\u6570\u91cf\u4e3a\uff1a" + ysZybList.size()), (Object[])new Object[0]);
        List infoCidList = ysZybList.stream().filter(Objects::nonNull).map(PhcPhysicalStaffCheckInfo::getCid).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(infoCidList) && infoCidList.size() < 5000) {
            XxlJobHelper.log((String)("\u751f\u6210phy\u6570\u636e\u5f00\u59cb,\u4f01\u4e1a\u6570\u91cf\u4e3a\uff1a" + String.valueOf(infoCidList)), (Object[])new Object[0]);
        }
        if (isNotPush.booleanValue()) {
            return;
        }
        List orgCodeList = ysZybList.stream().filter(Objects::nonNull).map(PhcPhysicalStaffCheckInfo::getOrgCode).filter(StringUtils::isNumber).distinct().collect(Collectors.toList());
        Map thirdOrganizationMap = this.thirdOrganizationService.getMapByCreditCode(orgCodeList);
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        List addList = ysZybList.stream().filter(Objects::nonNull).map(b -> {
            ReformAddParam addParam = new ReformAddParam();
            addParam.setGenerationSource(PhyPhcCheckConclusionEnum.YSZYB.getCode().toString().equalsIgnoreCase(b.getConclusion()) ? ReformGenerationSourceEnum.YSZYB.getValue() : ReformGenerationSourceEnum.JJZ.getValue());
            addParam.setReformItemSourceId(b.getSourceId());
            addParam.setReformMeasure(null);
            String orgName = b.getOrgCode();
            if (StringUtils.isNumber((String)b.getOrgCode())) {
                ThirdOrganization thirdOrganization = (ThirdOrganization)thirdOrganizationMap.get(b.getOrgCode());
                orgName = thirdOrganization != null ? thirdOrganization.getName() : null;
            }
            addParam.setFinderName(orgName);
            addParam.setName(this.setBusinessName((PhcPhysicalStaffCheckInfo)b, b.getCheckYear(), jobMap, bodyCheckTypeMap));
            addParam.setFindTime(b.getCreateDate());
            addParam.setCid(b.getCid());
            addParam.setReformItemSource(ReformSourceLiteEnum.ZYJKTJ.getValue());
            addParam.setDataSource(Byte.valueOf((byte)1));
            addParam.setTjBusinessId(b.getCardId());
            return addParam;
        }).collect(Collectors.toList());
        ListUtils.split(addList, (int)5000).forEach(this::generateReform);
    }

    @Transactional
    public void autoAddReformByGRJLCL(String cids) {
        List<Long> cidList = this.getPilotAndNewCompanyList(StringUtils.parseToLongList((String)cids));
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        List<Long> doseMonitorIdList = ((ReformItemBasicCommandMapper)this.dao).getBackDoseMonitorAndNoDeleteReform(cidList);
        if (CollectionUtils.isNotEmpty(doseMonitorIdList)) {
            int count = this.backDoseMonitorAndDeleteReform(doseMonitorIdList);
            XxlJobHelper.log((String)("\u56de\u9000\u8d85\u91cf\u9519\u8bef\u6570\u636e\u5f00\u59cb,\u6570\u91cf\u4e3a\uff1a" + count), (Object[])new Object[0]);
        }
        Date date = new Date();
        List<DoseMonitorDataMaperModel> list = ((ReformItemBasicCommandMapper)this.dao).getPersonDoseOverList(cidList, false, 1);
        List addList = list.stream().filter(Objects::nonNull).map(item -> {
            ReformAddParam addParam = new ReformAddParam();
            addParam.setCid(item.getCid());
            addParam.setFinderName(item.getOrgName());
            addParam.setFindTime(item.getCreateDate());
            String personName = DateUtils.getYear((Date)item.getEndDate()) + "\u5e74\u5ea6";
            if (StringUtils.isNotBlank((CharSequence)item.getPost())) {
                personName = personName + "\u2014" + item.getPost();
            }
            if (StringUtils.isNotBlank((CharSequence)item.getPersonName())) {
                personName = personName + "\u2014" + item.getPersonName();
            }
            personName = personName + "\u2014\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u7ed3\u679c\u5f02\u5e38\u2014\u5b58\u5728\u8d85\u5242\u91cf\u6216\u8d85\u5e74\u5ea6\u5242\u91cf";
            addParam.setName(personName);
            addParam.setReformItemSource(Byte.valueOf((byte)10));
            addParam.setReformItemSourceId(item.getDoseMonitorId());
            addParam.setDescription(personName);
            addParam.setCreateBy(Long.valueOf(1L));
            addParam.setDataSource(ReformDataSourceEnum.WDC.getValue());
            addParam.setTjBusinessId(item.getDoseMonitorDataId().toString());
            addParam.setGenerationSource(ReformGenerationSourceEnum.GRJLCB.getValue());
            return addParam;
        }).collect(Collectors.toList());
        ListUtils.split(addList, (int)5000).forEach(this::generateReform);
    }

    @Transactional
    public Integer backDoseMonitorAndDeleteReform(List<Long> doseMonitorIdList) {
        if (CollectionUtils.isEmpty(doseMonitorIdList)) {
            return 0;
        }
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andIn("reformItemSourceId", doseMonitorIdList).andNotIn("status", List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(10))).andEqualTo("isValid", (Object)true);
        example.selectProperties(new String[]{"id"});
        List<Long> idList = this.getListByExample(example).stream().filter(Objects::nonNull).map(ReformItemBasic::getId).collect(Collectors.toList());
        this.deleteReform(null, null, idList);
        return doseMonitorIdList.size();
    }

    private String setBusinessName(PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo, Integer year, Map<String, String> jobMap, Map<String, String> bodyCheckTypeMap) {
        Object businessName = String.valueOf(year);
        String workName = "";
        workName = !"99-9999".equals(phcPhysicalStaffCheckInfo.getJobCode()) ? jobMap.get(phcPhysicalStaffCheckInfo.getJobCode()) : phcPhysicalStaffCheckInfo.getOtherJobName();
        if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop()) && StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop() + "/" + workName;
        } else if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop())) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop();
        } else if (StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + workName;
        }
        String conclusionStr = "";
        if ("3".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u7591\u4f3c\u804c\u4e1a\u75c5";
        } else if ("4".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u804c\u4e1a\u7981\u5fcc\u8bc1";
        }
        businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getName() + "-" + bodyCheckTypeMap.get(phcPhysicalStaffCheckInfo.getBodyCheckType()) + "-" + conclusionStr;
        return businessName;
    }

    @Transactional
    public void autoAcceptance(String cids) {
        StringBuilder info = new StringBuilder();
        List needAcceptCidList = StringUtils.parseToLongList((String)cids, (String)",");
        List<Long> cidList = this.getPilotAndNewCompanyList(needAcceptCidList);
        if (CollectionUtils.isEmpty(cidList)) {
            XxlJobHelper.log((String)"\u65e0\u9700\u8981\u9a8c\u6536\u7684\u9879", (Object[])new Object[0]);
            return;
        }
        ArrayList generationSourceValue = new ArrayList(ReformGenerationSourceEnum.getEightGenerationSourceValue());
        for (Byte generationSource : generationSourceValue) {
            if (Objects.equals(generationSource, ReformGenerationSourceEnum.NOZYFZR.getValue()) || Objects.equals(generationSource, ReformGenerationSourceEnum.NOGLRY.getValue())) continue;
            int num = ListUtils.split(cidList, (int)20000).stream().filter(Objects::nonNull).map(list -> this.acceptDivide((List<Long>)list, generationSource)).mapToInt(accNum -> accNum).sum();
            info.append(",\u9a8c\u6536\u6574\u6539\u9879").append(generationSource).append("\u6570\u91cf:").append(num);
        }
        XxlJobHelper.log((String)info.toString(), (Object[])new Object[0]);
    }

    @Transactional(readOnly=false)
    public Integer acceptDivide(List<Long> cidList, Byte generationSource) {
        ReformSearchVo reformSearchVo;
        List<ReformItemBasic> notAcceptReformList;
        if (CollectionUtils.isEmpty(cidList)) {
            return 0;
        }
        List<Byte> generationSources = List.of(generationSource);
        if (List.of(ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue()).contains(generationSource)) {
            generationSources = List.of(ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue());
        }
        if (CollectionUtils.isEmpty(notAcceptReformList = this.getReformItemBasicList(reformSearchVo = new ReformSearchVo().setCidList(cidList).setGenerationSources(generationSources).setIsCompleted(Boolean.valueOf(false))))) {
            return 0;
        }
        AtomicInteger num = new AtomicInteger();
        notAcceptReformList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getFindTimeYear)).forEach((year, list) -> num.addAndGet(this.acceptGenerationSource(generationSource, (List<ReformItemBasic>)list, (Integer)year)));
        return num.get();
    }

    private Integer acceptGenerationSource(Byte generationSource, List<ReformItemBasic> notAcceptReformList, Integer year) {
        List<Long> notAcceptCidList = notAcceptReformList.stream().filter(Objects::nonNull).map(ReformItemBasic::getCid).distinct().collect(Collectors.toList());
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        Integer effectiveYear = ReformItemBasicCommandServiceImpl.getEffectiveYear(year);
        String effectiveDateStr = ReformItemBasicCommandServiceImpl.getEffectiveDateStr(year);
        HashMap<Long, String> msgType = new HashMap<Long, String>();
        List<Object> needAcceptReformList = new ArrayList<ReformItemBasic>();
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case DECLARE: {
                List<Long> anList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(notAcceptCidList, "\u5b89\u76d1\u7cfb\u7edf\u4f01\u4e1a");
                Map<Long, Date> wandaDeclareMap = ((ReformItemBasicCommandMapper)this.dao).getDeclareMapByCid(notAcceptCidList).stream().filter(Objects::nonNull).collect(Collectors.toMap(WandaDeclare::getCid, WandaDeclare::getDeclareTime, (a, b) -> a));
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (anList.contains(cid)) {
                        String msg = format.format(new Date()) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (wandaDeclareMap.containsKey(cid)) {
                        String msg = format.format((Date)wandaDeclareMap.get(cid)) + "\uff0c\u5b8c\u6210\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case TJ: {
                List unCompletedTjFangShangCidList = (List)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedTjFangShangCidList", 300L, () -> ((ReformItemBasicCommandMapper)this.dao).getUnCompletedFangShangCidList(null, 1, effectiveDateStr), (TypeReference)new TypeReference<List<Long>>(){});
                Map physicalCheckMap = ((ReformItemBasicCommandMapper)this.dao).getPhysicalList(notAcceptCidList, effectiveDateStr, 1).stream().filter(Objects::nonNull).collect(Collectors.toMap(PhcPhysicalCheckV3221::getCid, Function.identity(), (a, b) -> a));
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (!physicalCheckMap.containsKey(cid) || unCompletedTjFangShangCidList.contains(cid)) {
                        return false;
                    }
                    String msg = format.format(((PhcPhysicalCheckV3221)physicalCheckMap.get(cid)).getCheckTime()) + "\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case DETECTION: {
                List unCompletedJcFangShangCidList = (List)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedJcFangShangCidList", 300L, () -> ((ReformItemBasicCommandMapper)this.dao).getUnCompletedFangShangCidList(null, 2, effectiveDateStr), (TypeReference)new TypeReference<List<Long>>(){});
                List<CheckPlan> checkList = ((ReformItemBasicCommandMapper)this.dao).getCheckList(notAcceptCidList, effectiveDateStr, 1, null, "\u4e25\u91cd");
                List<CheckPlan> checkList2 = ((ReformItemBasicCommandMapper)this.dao).getCheckList(notAcceptCidList, effectiveDateStr, 3, null, "\u4e00\u822c");
                checkList.addAll(checkList2);
                Map checkPlanMap = checkList.stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlan::getCid, Function.identity(), (a, b) -> a));
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    if (item == null) {
                        return false;
                    }
                    Long cid = item.getCid();
                    if (!checkPlanMap.containsKey(cid) || unCompletedJcFangShangCidList.contains(cid)) {
                        return false;
                    }
                    LocalDateTime checkDateBegin = ((CheckPlan)checkPlanMap.get(cid)).getCheckDateBegin();
                    String msg = checkDateBegin.getYear() + "\u5e74" + checkDateBegin.getMonthValue() + "\u6708" + checkDateBegin.getDayOfMonth() + "\u65e5\uff0c\u5f00\u5c55\u4e86\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case GRJL: {
                List<Long> personDoseUnCompletedList = this.getPersonDoseUnCompletedList(notAcceptCidList);
                personDoseUnCompletedList.removeAll(this.getFileCompleteReformCidList(notAcceptCidList, generationSource, effectiveYear));
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (personDoseUnCompletedList.contains(cid)) {
                        return false;
                    }
                    String msg = "\u81ea\u52a8\u9a8c\u6536";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case TRAIN: 
            case NOZYFZR: 
            case NOGLRY: {
                Map trainZCompletedMap = ((ReformItemBasicCommandMapper)this.dao).getTrainList(notAcceptCidList, effectiveDateStr, 12, true).stream().filter(Objects::nonNull).collect(Collectors.toMap(CertificateStaffDetail::getCid, Function.identity(), (a, b) -> a));
                Map trainMCompletedMap = ((ReformItemBasicCommandMapper)this.dao).getTrainList(notAcceptCidList, effectiveDateStr, 13, true).stream().filter(Objects::nonNull).collect(Collectors.toMap(CertificateStaffDetail::getCid, Function.identity(), (a, b) -> a));
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    CertificateStaffDetail zTrain = (CertificateStaffDetail)trainZCompletedMap.get(cid);
                    CertificateStaffDetail mTrain = (CertificateStaffDetail)trainMCompletedMap.get(cid);
                    if (ReformGenerationSourceEnum.TRAIN.getValue().equals(item.getGenerationSource()) && (zTrain != null || mTrain != null)) {
                        Object msg = "";
                        if (zTrain != null) {
                            msg = format.format(zTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad,";
                        }
                        if (mTrain != null) {
                            msg = (String)msg + format.format(mTrain.getCertCreateDate()) + ",\u5df2\u5f00\u5c55\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        }
                        msgType.put(cid, (String)msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOZYFZR.getValue().equals(item.getGenerationSource()) && zTrain != null) {
                        String msg = format.format(zTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    if (ReformGenerationSourceEnum.NOGLRY.getValue().equals(item.getGenerationSource()) && mTrain != null) {
                        String msg = format.format(mTrain.getCertCreateDate()) + "\uff0c\u5f00\u5c55\u4e86\u7ba1\u7406\u4eba\u5458\u57f9\u8bad";
                        msgType.put(cid, msg);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                break;
            }
            case THREE_TIME: {
                Set threeTimeNoCompletedSet = ((ReformItemBasicCommandMapper)this.dao).getThreeSimultaneousList(notAcceptCidList, null, false).stream().filter(Objects::nonNull).map(TsProjectSimple::getCid).collect(Collectors.toSet());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (threeTimeNoCompletedSet.contains(cid)) {
                        return false;
                    }
                    String msg = "\u81ea\u52a8\u9a8c\u6536";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case PROTECTION: {
                List protectEquipCompletedList = ((ReformItemBasicCommandMapper)this.dao).getProtectEquipList(notAcceptCidList, effectiveYear, true).stream().filter(Objects::nonNull).map(ProtectEquipIssueRecord::getCid).distinct().collect(Collectors.toList());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (!protectEquipCompletedList.contains(cid)) {
                        return false;
                    }
                    String msg = "\u81ea\u52a8\u9a8c\u6536";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case WARNING_SIGNS: {
                List warnSignManageCompleted = ((ReformItemBasicCommandMapper)this.dao).getWarnSignList(notAcceptCidList, effectiveDateStr, true).stream().filter(Objects::nonNull).map(WarnSignManage::getCid).distinct().collect(Collectors.toList());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (!warnSignManageCompleted.contains(cid)) {
                        return false;
                    }
                    String msg = "\u81ea\u52a8\u9a8c\u6536";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
            case ARCHIVES: {
                List healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(notAcceptCidList, year).parallelStream().filter(Objects::nonNull).collect(Collectors.toList());
                needAcceptReformList = notAcceptReformList.stream().filter(item -> {
                    Long cid = item.getCid();
                    if (!healthManageFilesCompletedList.contains(cid)) {
                        return false;
                    }
                    String msg = "\u81ea\u52a8\u9a8c\u6536";
                    msgType.put(cid, msg);
                    return true;
                }).collect(Collectors.toList());
                break;
            }
        }
        this.makeAndUpdateReform(needAcceptReformList, msgType, (byte)3, null);
        return needAcceptReformList.size();
    }

    public List<ReformItemBasic> makeAndUpdateReform(List<ReformItemBasic> needAcceptReformList, Map<Long, String> msgType, Byte status, Long loginStaffId) {
        Date date = new Date();
        if (status == -1) {
            return null;
        }
        if (CollectionUtils.isEmpty(needAcceptReformList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(needAcceptReformList = needAcceptReformList.stream().filter(item -> item != null && !item.getStatus().equals(status)).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        List collect1 = needAcceptReformList.stream().filter(Objects::nonNull).map(ReformItemBasic::getId).collect(Collectors.toList());
        List sourceList = this.itemSourceService.getSourceListByBasicId(collect1);
        List accListByReformItemIds = this.acceptanceRecordService.getListByReformItemIds(new HashSet(collect1));
        Map collect = accListByReformItemIds.stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemAcceptanceRecord::getReformItemId, Function.identity(), (a, b) -> a.getCreateDate().getTime() >= b.getCreateDate().getTime() ? a : b));
        ArrayList<ReformItemAcceptanceRecord> accList = new ArrayList<ReformItemAcceptanceRecord>(collect.values());
        needAcceptReformList.forEach(item -> {
            if (item == null) {
                return;
            }
            ReformItemAcceptanceRecord record = (ReformItemAcceptanceRecord)collect.get(item.getId());
            item.setStatus(status);
            item.setUpdateDate(date);
            if (loginStaffId != null) {
                item.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 0 || status.intValue() == 1 || status.intValue() == 5) {
                item.setActualFinishTime(null);
                item.setAcceptanceDate(null);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 2) {
                item.setActualFinishTime(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDate(null);
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                item.setActualFinishTime(date);
                item.setAcceptanceDate(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                    item.setAcceptanceDirectorName(record.getAcceptanceDirectorName());
                }
            }
        });
        sourceList.forEach(item -> {
            if (item == null) {
                return;
            }
            ReformItemAcceptanceRecord record = (ReformItemAcceptanceRecord)collect.get(item.getReformItemId());
            item.setStatus(status);
            item.setUpdateDate(date);
            if (loginStaffId != null) {
                item.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 0 || status.intValue() == 1 || status.intValue() == 5) {
                item.setActualFinishTime(null);
                item.setAcceptanceDate(null);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 2) {
                item.setActualFinishTime(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                }
                item.setAcceptanceDate(null);
                item.setAcceptanceDirectorName(null);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                item.setActualFinishTime(date);
                item.setAcceptanceDate(date);
                if (record != null) {
                    item.setReformDirectorName(record.getReformDirectorName());
                    item.setAcceptanceDirectorName(record.getAcceptanceDirectorName());
                }
            }
        });
        accList.forEach(acceptance -> {
            if (acceptance == null) {
                return;
            }
            acceptance.setUpdateDate(date);
            if (loginStaffId != null) {
                acceptance.setUpdateBy(loginStaffId);
            }
            if (status.intValue() == 3 || status.intValue() == 4) {
                acceptance.setAcceptanceDirectorName("\u81ea\u52a8\u9a8c\u6536");
                acceptance.setActualFinishTime(date);
                acceptance.setAcceptanceDate(date);
                acceptance.setAcceptanceResult(Byte.valueOf((byte)1));
                acceptance.setAcceptanceResultExplain("\u5df2\u9a8c\u6536");
                acceptance.setStatus(Byte.valueOf((byte)3));
                if (CollectionUtils.isNotEmpty((Map)msgType)) {
                    acceptance.setReformMeasure((String)(acceptance.getReformMeasure() != null ? acceptance.getReformMeasure() + "\n" : "") + (String)msgType.get(acceptance.getCid()));
                } else {
                    acceptance.setReformMeasure((String)(acceptance.getReformMeasure() != null ? acceptance.getReformMeasure() + "\n" : ""));
                }
            }
            if (status.intValue() == 2) {
                acceptance.setActualFinishTime(date);
                acceptance.setAcceptanceDirectorName(null);
                acceptance.setAcceptanceDate(null);
                acceptance.setStatus(Byte.valueOf((byte)1));
            }
            if (status.intValue() == 5) {
                acceptance.setActualFinishTime(null);
                acceptance.setAcceptanceDirectorName(null);
                acceptance.setAcceptanceDate(null);
                acceptance.setStatus(Byte.valueOf((byte)0));
            }
        });
        try {
            if (CollectionUtils.isNotEmpty(needAcceptReformList)) {
                this.batchUpdateOrInsert(needAcceptReformList, ReformItemBasicMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
                this.itemSourceService.batchUpdateOrInsert(sourceList, ReformItemSourceMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            if (CollectionUtils.isNotEmpty(accList)) {
                this.acceptanceRecordService.batchUpdateOrInsert(accList, ReformItemAcceptanceRecordMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            return needAcceptReformList;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u81ea\u52a8\u9a8c\u6536\u6574\u6539\u5931\u8d25\uff1a\u4f01\u4e1aID\u4e3a\uff1a" + needAcceptReformList.toString());
            return needAcceptReformList;
        }
    }

    public List<Long> getZjArchiveCountViewByCid(List<Long> cidList, Integer year) {
        ArrayList<Long> cidListTemp = new ArrayList<Long>(cidList);
        if (CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List needReformCidList = this.itemBasicService.getThreeTimeReformByCid(cidListTemp);
        cidListTemp.removeAll(needReformCidList);
        if (CollectionUtils.isEmpty(cidListTemp)) {
            return Collections.emptyList();
        }
        List<Integer> archiveTypeList = Arrays.asList(2, 3, 4);
        List<Long> list234 = ((ReformItemBasicCommandMapper)this.dao).get234Completed(cidListTemp, archiveTypeList, year.toString());
        if (CollectionUtils.isEmpty(list234)) {
            return Collections.emptyList();
        }
        List<Long> list5 = ((ReformItemBasicCommandMapper)this.dao).getDoc5Completed(list234);
        ReformSearchVo reformSearchVo = new ReformSearchVo().setCidList(list234).setGenerationSource(Byte.valueOf((byte)10)).setIsCompleted(Boolean.valueOf(true));
        List physicalReformCompletedList = this.getReformItemBasicList(reformSearchVo).stream().filter(Objects::nonNull).map(ReformItemBasic::getCid).distinct().collect(Collectors.toList());
        list5.addAll(physicalReformCompletedList);
        return list5.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Transactional
    public void autoGenKeyFactorReform(String cids) {
        this.genKeyFactorReformNewCompany(cids);
        this.autoGenKeyFactorReformDetail(cids);
    }

    public void autoGenKeyFactorReformDetail(String cids) {
        XxlJobHelper.log((String)"\u751f\u6210\u6574\u6539\u5f00\u59cb", (Object[])new Object[0]);
        List needAddCidList = StringUtils.parseToLongList((String)cids, (String)",");
        StringBuilder info = new StringBuilder();
        List<Long> cidList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(needAddCidList, "\u8bd5\u70b9\u4f01\u4e1a+\u5168\u90e8\u5206\u7c7b\u7684\u65b0\u5efa\u4f01\u4e1a");
        if (CollectionUtils.isEmpty(cidList)) {
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u751f\u6210\u6574\u6539\u7684\u4f01\u4e1a", (Object[])new Object[0]);
            return;
        }
        for (Byte generationSource : ReformGenerationSourceEnum.getEightGenerationSourceValue()) {
            if (Objects.equals(generationSource, ReformGenerationSourceEnum.NOZYFZR.getValue()) || Objects.equals(generationSource, ReformGenerationSourceEnum.NOGLRY.getValue())) continue;
            int num = ListUtils.split(cidList, (int)10000).stream().filter(Objects::nonNull).map(list -> this.divideBatchGenKeyReform((List<Long>)list, generationSource, DateUtils.getThisYear(), ReformDataSourceEnum.KEYFACTORY.getValue())).mapToInt(accNum -> accNum).sum();
            info.append(",\u751f\u6210\u6574\u6539\u9879").append(generationSource).append("\u6570\u91cf:").append(num);
        }
        XxlJobHelper.log((String)"\u751f\u6210\u6574\u6539\u7ed3\u675f{}", (Object[])new Object[]{info});
        ((ReformItemBasicCommandMapper)this.dao).updateGRJLWarnStatus(cidList, "reform_item_basic");
        ((ReformItemBasicCommandMapper)this.dao).updateGRJLWarnStatus(cidList, "reform_item_source");
    }

    @Transactional
    public Integer divideBatchGenKeyReform(List<Long> cidList, Byte generationSource, Integer year, Byte dataSource) {
        if (CollectionUtils.isEmpty(cidList) || generationSource == null || year == null) {
            return 0;
        }
        Integer effectiveYear = ReformItemBasicCommandServiceImpl.getEffectiveYear(year);
        String effectiveDateStr = ReformItemBasicCommandServiceImpl.getEffectiveDateStr(effectiveYear);
        Date effectiveDate = DateUtils.parseDate((Object)effectiveDateStr);
        ArrayList<ReformAddParam> addParamList = new ArrayList<ReformAddParam>();
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case DECLARE: {
                List<Long> declareNoCompletedList = ((ReformItemBasicCommandMapper)this.dao).getDeclareNoCompletedList(cidList);
                declareNoCompletedList.removeAll(this.getFileCompleteReformCidList(cidList, generationSource, effectiveYear));
                cidList.forEach(cid -> {
                    if (!declareNoCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5";
                    Date firstPushTime = this.getFindTimeByBusTime(effectiveDate, null, null, null);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.DECLARE.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case TJ: {
                List<PhcPhysicalCheckV3221> physicalList = ((ReformItemBasicCommandMapper)this.dao).getPhysicalList(cidList, null, null);
                List physicalCompletedList = physicalList.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)DateUtils.addYear((Date)item.getCheckTime(), (int)1), (Date)effectiveDate) > 0L).map(PhcPhysicalCheckV3221::getCid).distinct().collect(Collectors.toList());
                List unCompletedFangShangCidList1 = (List)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList1", 300L, () -> ((ReformItemBasicCommandMapper)this.dao).getUnCompletedFangShangCidList(null, 1, effectiveDateStr), (TypeReference)new TypeReference<List<Long>>(){});
                physicalCompletedList.removeAll(unCompletedFangShangCidList1);
                physicalCompletedList.addAll(this.getFileCompleteReformCidList(cidList, generationSource, effectiveYear));
                Map<Long, Date> busTimeMap = physicalList.stream().filter(Objects::nonNull).collect(Collectors.toMap(PhcPhysicalCheckV3221::getCid, PhcPhysicalCheckV3221::getCheckTime, (a, b) -> a));
                cidList.forEach(cid -> {
                    if (physicalCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
                    Date firstPushTime = this.getFindTimeByBusTime((Date)busTimeMap.get(cid), null, 1, false);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.TJ.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case DETECTION: {
                List<CheckPlan> checkList1 = ((ReformItemBasicCommandMapper)this.dao).getCheckList(cidList, null, null, null, "\u4e25\u91cd");
                List<CheckPlan> checkList2 = ((ReformItemBasicCommandMapper)this.dao).getCheckList(cidList, null, null, null, "\u4e00\u822c");
                List checkCompleteList1 = checkList1.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)DateUtils.addYear((Date)DateUtils.localDateTimeToDate((LocalDateTime)item.getCheckDateBegin()), (int)1), (Date)effectiveDate) > 0L).map(CheckPlan::getCid).distinct().collect(Collectors.toList());
                List checkCompleteList2 = checkList2.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)DateUtils.addYear((Date)DateUtils.localDateTimeToDate((LocalDateTime)item.getCheckDateBegin()), (int)3), (Date)effectiveDate) > 0L).map(CheckPlan::getCid).distinct().collect(Collectors.toList());
                ArrayList<Object> checkCompletedList = new ArrayList<Object>();
                checkCompletedList.addAll(checkCompleteList1);
                checkCompletedList.addAll(checkCompleteList2);
                List unCompletedFangShangCidList2 = (List)this.redisClient.get("IReformItemBasicNewService", "getUnCompletedFangShangCidList2", 300L, () -> ((ReformItemBasicCommandMapper)this.dao).getUnCompletedFangShangCidList(null, 2, effectiveDateStr), (TypeReference)new TypeReference<List<Long>>(){});
                checkCompletedList.removeAll(unCompletedFangShangCidList2);
                checkCompletedList.addAll(this.getFileCompleteReformCidList(cidList, generationSource, effectiveYear));
                Map<Long, Date> busTimeMap1 = checkList1.stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlan::getCid, checkPlan -> DateUtils.localDateTimeToDate((LocalDateTime)checkPlan.getCheckDateBegin()), (a, b) -> a));
                Map<Long, Date> busTimeMap2 = checkList2.stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlan::getCid, checkPlan -> DateUtils.localDateTimeToDate((LocalDateTime)checkPlan.getCheckDateBegin()), (a, b) -> a));
                cidList.forEach(cid -> {
                    if (checkCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7";
                    Date firstPushTime = busTimeMap1.get(cid) != null ? this.getFindTimeByBusTime((Date)busTimeMap1.get(cid), null, 1, false) : this.getFindTimeByBusTime((Date)busTimeMap2.get(cid), null, 3, false);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.DETECTION.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case GRJL: {
                List<Long> personDoseUnCompletedList = this.getPersonDoseUnCompletedList(cidList);
                personDoseUnCompletedList.removeAll(this.getFileCompleteReformCidList(cidList, generationSource, effectiveYear));
                Map<Long, List<ReformItemBasic>> alreadyRiskList = this.getReformItemBasicList(new ReformSearchVo().setCidList(cidList).setGenerationSource(ReformGenerationSourceEnum.GRJL.getValue()).setYear(effectiveYear).setBackStrName("cidAndYear")).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getCid));
                cidList.forEach(cid -> {
                    if (!personDoseUnCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u6309\u8981\u6c42\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u98ce\u9669";
                    if (alreadyRiskList.containsKey(cid)) {
                        int num = ((List)alreadyRiskList.get(cid)).size() + 1;
                        nameOrDescription = nameOrDescription + "-" + num;
                    } else {
                        nameOrDescription = nameOrDescription + "-1";
                    }
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, DateUtils.parseDate((Object)(effectiveYear + "-09-01 00:00:00")), nameOrDescription, ReformGenerationSourceEnum.GRJL.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case TRAIN: 
            case NOZYFZR: 
            case NOGLRY: {
                List<CertificateStaffDetail> trainZList = ((ReformItemBasicCommandMapper)this.dao).getTrainList(cidList, null, 12, true);
                List<CertificateStaffDetail> trainMList = ((ReformItemBasicCommandMapper)this.dao).getTrainList(cidList, null, 13, true);
                List trainZCompletedList = trainZList.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)item.getValidityDate(), (Date)effectiveDate) > 0L).map(CertificateStaffDetail::getCid).distinct().collect(Collectors.toList());
                List trainMCompletedList = trainMList.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)item.getValidityDate(), (Date)effectiveDate) > 0L).map(CertificateStaffDetail::getCid).distinct().collect(Collectors.toList());
                Map<Long, Date> busTimeMap1 = trainZList.stream().filter(Objects::nonNull).collect(Collectors.toMap(CertificateStaffDetail::getCid, CertificateStaffDetail::getValidityDate, (a, b) -> a));
                Map<Long, Date> busTimeMap2 = trainMList.stream().filter(Objects::nonNull).collect(Collectors.toMap(CertificateStaffDetail::getCid, CertificateStaffDetail::getValidityDate, (a, b) -> a));
                cidList.forEach(cid -> {
                    Date firstPushTime;
                    String nameOrDescription;
                    if (CollectionUtils.isEmpty((Collection)trainZCompletedList) && CollectionUtils.isEmpty((Collection)trainMCompletedList) || !trainZCompletedList.contains(cid) && !trainMCompletedList.contains(cid)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        firstPushTime = this.getFindTimeByBusTime(DateUtils.chooseLastDate((Date)((Date)busTimeMap1.get(cid)), (Date)((Date)busTimeMap2.get(cid))), null, null, false);
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.TRAIN.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                    if (!trainZCompletedList.contains(cid) || CollectionUtils.isEmpty((Collection)trainZCompletedList)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        firstPushTime = this.getFindTimeByBusTime((Date)busTimeMap1.get(cid), null, null, false);
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.NOZYFZR.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                    if (!trainMCompletedList.contains(cid) || CollectionUtils.isEmpty((Collection)trainMCompletedList)) {
                        nameOrDescription = year + "\u5e74\u5ea6-\u7ba1\u7406\u4eba\u5458\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad";
                        firstPushTime = this.getFindTimeByBusTime((Date)busTimeMap2.get(cid), null, null, false);
                        this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.NOGLRY.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                    }
                });
                break;
            }
            case THREE_TIME: {
                List threeTimeNoCompletedCidList = ((ReformItemBasicCommandMapper)this.dao).getThreeSimultaneousList(cidList, null, false).stream().filter(Objects::nonNull).map(TsProjectSimple::getCid).collect(Collectors.toList());
                List<Long> lastTimeCidList = cidList.stream().filter(threeTimeNoCompletedCidList::contains).collect(Collectors.toList());
                Map<Long, Date> lastYearReformMap = this.getLastYearReformMap(lastTimeCidList, ReformGenerationSourceEnum.THREE_TIME.getValue(), year);
                cidList.forEach(cid -> {
                    if (!threeTimeNoCompletedCidList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u5b58\u5728\u672a\u5b8c\u6210\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c";
                    Date firstPushTime = this.getFindTimeByBusTime(null, DateUtils.chooseLastDate((Date)((Date)lastYearReformMap.get(cid)), (Date)new Date()), null, true);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, DateUtils.chooseLastDate((Date)firstPushTime, (Date)effectiveDate), nameOrDescription, ReformGenerationSourceEnum.THREE_TIME.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case PROTECTION: {
                List<ProtectEquipIssueRecord> protectEquipList = ((ReformItemBasicCommandMapper)this.dao).getProtectEquipList(cidList, null, true);
                List protectEquipCompletedList = protectEquipList.stream().filter(Objects::nonNull).filter(item -> DateUtils.getYear((Date)item.getIssuedTime()) == year).map(ProtectEquipIssueRecord::getCid).distinct().collect(Collectors.toList());
                Map<Long, Date> busTimeMap = protectEquipList.stream().filter(Objects::nonNull).collect(Collectors.toMap(ProtectEquipIssueRecord::getCid, ProtectEquipIssueRecord::getIssuedTime, (a, b) -> a));
                cidList.forEach(cid -> {
                    if (protectEquipCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1";
                    Date firstPushTime = this.getFindTimeByBusTime((Date)busTimeMap.get(cid), null, 1, true);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.PROTECTION.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case WARNING_SIGNS: {
                List<WarnSignManage> warnSignList = ((ReformItemBasicCommandMapper)this.dao).getWarnSignList(cidList, null, true);
                List warnSignManageCompletedList = warnSignList.stream().filter(Objects::nonNull).filter(item -> DateUtils.compare_time((Date)DateUtils.addYear((Date)item.getChangeTime(), (int)3), (Date)effectiveDate) > 0L).map(WarnSignManage::getCid).distinct().collect(Collectors.toList());
                Map<Long, Date> busTimeMap = warnSignList.stream().filter(Objects::nonNull).collect(Collectors.toMap(WarnSignManage::getCid, WarnSignManage::getChangeTime, (a, b) -> a));
                cidList.forEach(cid -> {
                    if (warnSignManageCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6";
                    Date firstPushTime = this.getFindTimeByBusTime((Date)busTimeMap.get(cid), null, 3, true);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
            case ARCHIVES: {
                Set healthManageFilesCompletedList = this.getZjArchiveCountViewByCid(cidList, year).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                List<Long> lastTimeCidList = cidList.stream().filter(cid -> !healthManageFilesCompletedList.contains(cid)).collect(Collectors.toList());
                Map<Long, Date> lastYearReformMap = this.getLastYearReformMap(lastTimeCidList, ReformGenerationSourceEnum.ARCHIVES.getValue(), year);
                cidList.forEach(cid -> {
                    if (healthManageFilesCompletedList.contains(cid)) {
                        return;
                    }
                    String nameOrDescription = year + "\u5e74\u5ea6-\u672a\u5b8c\u5584\u804c\u4e1a\u536b\u751f\u6863\u6848";
                    Date firstPushTime = this.getFindTimeByBusTime(null, (Date)lastYearReformMap.get(cid), null, true);
                    this.makeGenKeyReformAddParamList((List<ReformAddParam>)addParamList, (Long)cid, firstPushTime, nameOrDescription, ReformGenerationSourceEnum.ARCHIVES.getValue(), nameOrDescription, ReformSourceLiteEnum.KEY_FACTOR_PORTRAIT.getValue(), dataSource);
                });
                break;
            }
        }
        return this.generateReform(addParamList);
    }

    private List<Long> getFileCompleteReformCidList(List<Long> cidList, Byte generationSource, Integer effectiveYear) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<Long>();
        }
        return this.getReformItemBasicList(new ReformSearchVo().setCidList(cidList).setGenerationSource(generationSource).setYear(effectiveYear).setIsFileComplete(Boolean.valueOf(true))).stream().filter(item -> item != null && item.getActualFinishTime() != null && DateUtils.compare_time((Date)DateUtils.addMonth((Date)item.getActualFinishTime(), (int)2), (Date)new Date()) <= 0L).map(ReformItemBasic::getCid).distinct().collect(Collectors.toList());
    }

    private Map<Long, Date> getLastYearReformMap(List<Long> cidList, Byte generationSource, Integer year) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new HashMap<Long, Date>();
        }
        ReformSearchVo lastYearReformSearchVo = new ReformSearchVo().setCidList(cidList).setYear(Integer.valueOf(year - 1)).setGenerationSource(generationSource).setIsCompleted(Boolean.valueOf(true)).setBackStrName("cidAndMinAcceptanceDate");
        return this.getReformItemBasicList(lastYearReformSearchVo).stream().filter(item -> item != null && item.getAcceptanceDate() != null).collect(Collectors.toMap(ReformItemBasic::getCid, ReformItemBasic::getAcceptanceDate, (a, b) -> a));
    }

    @Transactional
    public void genKeyFactorReformNewCompany(String cids) {
        XxlJobHelper.log((String)"\u5f00\u59cb\u751f\u6210--\u65b0\u5efa\u4f01\u4e1a\u5173\u952e\u56e0\u7d20\u753b\u50cf\u6574\u6539", (Object[])new Object[0]);
        List needAddList = StringUtils.parseToLongList((String)cids);
        this.suspendAndRePush(needAddList);
        List<Long> cidList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(needAddList, "\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u9636\u6bb5\u7684\u4f01\u4e1a");
        if (CollectionUtils.isEmpty(cidList)) {
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u751f\u6210\u7684\u65b0\u5efa\u4f01\u4e1a\u5173\u952e\u56e0\u7d20\u753b\u50cf\u6574\u6539", (Object[])new Object[0]);
            return;
        }
        this.updateRisk34DataSource(cidList);
        List.of(ReformGenerationSourceEnum.DETECTION.getValue(), ReformGenerationSourceEnum.PROTECTION.getValue(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.GRJL.getValue()).forEach(generationSource -> this.divideBatchGenKeyReform(cidList, (Byte)generationSource, DateUtils.getThisYear(), ReformDataSourceEnum.XJQY.getValue()));
    }

    private void updateRisk34DataSource(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        ListUtils.split(cidList, (int)2000).forEach(list -> {
            Example example = new Example(ReformItemBasic.class);
            example.createCriteria().andIn("cid", (Iterable)cidList).andIn("generationSource", List.of(ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.GRJLCB.getValue())).andCondition("(data_source !=5 OR data_source IS NULL)").andEqualTo("isValid", (Object)true);
            ReformItemBasic basic = new ReformItemBasic();
            basic.setBatchNum(null);
            basic.setIsShowInReformModular(null);
            basic.setDataSource(ReformDataSourceEnum.XJQY.getValue());
            basic.setCreateBy(Long.valueOf(2L));
            int i = ((ReformItemBasicCommandMapper)this.dao).updateByExampleSelective(basic, example);
            if (i == 0) {
                return;
            }
            Example example2 = new Example(ReformItemSource.class);
            example2.createCriteria().andIn("cid", (Iterable)cidList).andIn("generationSource", List.of(ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.GRJLCB.getValue())).andCondition("(data_source !=5 OR data_source IS NULL)").andEqualTo("isValid", (Object)true);
            ReformItemSource source = new ReformItemSource();
            source.setBatchNum(null);
            source.setIsShowInReformModular(null);
            source.setDataSource(ReformDataSourceEnum.XJQY.getValue());
            source.setCreateBy(Long.valueOf(2L));
            this.itemSourceMapper.updateByExampleSelective(source, example2);
            this.logger.error("\u5982\u679c\u6709\u68c0\u6d4b\u548c\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38\u7684\uff0c\u53bb\u4fee\u6539\u8fd9\u4e9b\u98ce\u9669\u7684\u6765\u6e90\u4e3a\u65b0\u5efa\u4f01\u4e1a\u98ce\u9669\u6765\u6e90\uff1a\u4fee\u6539\u98ce\u9669\u6570" + i);
        });
    }

    private void suspendAndRePush(List<Long> needAddList) {
        List<ReformItemBasic> pauseStatusList = ((ReformItemBasicCommandMapper)this.dao).getNewToNormalAndNotPauseStatus(needAddList);
        if (CollectionUtils.isEmpty(pauseStatusList)) {
            return;
        }
        ArrayList<Long> pauseStatusIdList = new ArrayList<Long>();
        ArrayList<ReformAddParam> addParamList = new ArrayList<ReformAddParam>();
        for (ReformItemBasic basic : pauseStatusList) {
            pauseStatusIdList.add(basic.getId());
            ReformAddParam addParam = new ReformAddParam();
            addParam.setCid(basic.getCid());
            addParam.setFinderName(basic.getFinderName());
            addParam.setFindTime(basic.getFindTime());
            addParam.setName(basic.getName());
            addParam.setReformItemSource(basic.getReformItemSource());
            addParam.setReformItemSourceId(basic.getReformItemSourceId());
            addParam.setDescription(basic.getDescription());
            addParam.setCreateBy(basic.getCreateBy());
            addParam.setDataSource(ReformDataSourceEnum.WDC.getValue());
            addParam.setTjBusinessId(basic.getTjBusinessId());
            if (basic.getGenerationSource().equals((byte)3)) {
                addParam.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
            }
            if (basic.getGenerationSource().equals((byte)4)) {
                addParam.setGenerationSource(ReformGenerationSourceEnum.JJZ.getValue());
            }
            if (basic.getGenerationSource().equals((byte)24)) {
                addParam.setGenerationSource(ReformGenerationSourceEnum.GRJLCB.getValue());
            }
            if (addParam.getGenerationSource() == null) continue;
            addParamList.add(addParam);
        }
        this.setPauseStatus(pauseStatusIdList);
        this.generateReform(addParamList);
    }

    private List<Long> getPersonDoseUnCompletedList(List<Long> cidList) {
        List<Long> personDoseUnCompletedList = ((ReformItemBasicCommandMapper)this.dao).getPersonDoseUnCompletedList(cidList, false, 1);
        List<Long> fangSheCidList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(null, "\u653e\u5c04\u4f01\u4e1a");
        if (CollectionUtils.isNotEmpty(fangSheCidList)) {
            List<Long> excitFangSheCidList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(fangSheCidList, "\u5b58\u5728\u653e\u5c04\u4eba\u5458\u7684\u4f01\u4e1a");
            fangSheCidList.removeAll(excitFangSheCidList);
            personDoseUnCompletedList.addAll(fangSheCidList);
        }
        return personDoseUnCompletedList;
    }

    public void makeGenKeyReformAddParamList(List<ReformAddParam> addParamList, Long cid, Date findTime, String name, Byte generationSource, String description, Byte reformItemSource, Byte dataSource) {
        if (cid == null) {
            return;
        }
        ReformAddParam addParam = new ReformAddParam();
        addParam.setCid(cid);
        addParam.setFindTime(findTime);
        addParam.setName(name);
        addParam.setReformItemSource(reformItemSource);
        addParam.setGenerationSource(generationSource);
        addParam.setDescription(description);
        addParam.setDataSource(dataSource);
        addParamList.add(addParam);
    }

    public Date getFindTimeByBusTime(Date businessTime, Date lastRiskResolveTime, Integer addYear, Boolean isLatest) {
        int thisYear = DateUtils.getThisYear();
        Date ownLatestDate = DateUtils.localDateTimeToDate((LocalDateTime)LocalDateTime.of(thisYear, 7, 1, 0, 0, 0));
        Date businessTimeTemp = businessTime;
        Date lastRiskResolveTimeTemp = lastRiskResolveTime;
        if (addYear != null && businessTimeTemp != null) {
            businessTimeTemp = DateUtils.addYear((Date)businessTimeTemp, (int)addYear);
        }
        if (lastRiskResolveTimeTemp != null) {
            lastRiskResolveTimeTemp = DateUtils.addYear((Date)lastRiskResolveTimeTemp, (int)1);
        }
        if (businessTimeTemp == null && lastRiskResolveTimeTemp == null) {
            return ownLatestDate;
        }
        if (businessTimeTemp != null && DateUtils.getYear((Date)businessTimeTemp) < thisYear) {
            return ownLatestDate;
        }
        if (lastRiskResolveTimeTemp != null && DateUtils.getYear((Date)lastRiskResolveTimeTemp) < thisYear) {
            return ownLatestDate;
        }
        Date latestDate = null;
        if (businessTimeTemp != null && lastRiskResolveTimeTemp == null) {
            latestDate = businessTimeTemp;
        }
        if (lastRiskResolveTimeTemp != null && businessTimeTemp == null) {
            latestDate = lastRiskResolveTimeTemp;
        }
        if (Objects.equals(true, isLatest)) {
            latestDate = DateUtils.getYear((Date)latestDate) == thisYear ? (DateUtils.compare_time((Date)ownLatestDate, (Date)latestDate) > 0L ? latestDate : ownLatestDate) : (DateUtils.compare_time((Date)DateUtils.addYear((Date)ownLatestDate, (int)1), (Date)latestDate) > 0L ? latestDate : ownLatestDate);
        }
        return latestDate;
    }

    @Transactional
    public Integer setPauseStatus(List<Long> reformIds) {
        if (CollectionUtils.isEmpty(reformIds)) {
            return 0;
        }
        Date date = new Date();
        Example example = new Example(ReformItemBasic.class);
        example.createCriteria().andIn("id", reformIds).andNotEqualTo("status", (Object)10);
        ReformItemBasic basic = new ReformItemBasic();
        basic.setStatus(Byte.valueOf((byte)10));
        basic.setUpdateDate(date);
        int i = ((ReformItemBasicCommandMapper)this.dao).updateByExampleSelective(basic, example);
        if (i == 0) {
            return 0;
        }
        Example example2 = new Example(ReformItemSource.class);
        example2.createCriteria().andIn("reformItemId", reformIds).andNotEqualTo("status", (Object)10);
        ReformItemSource source = new ReformItemSource();
        source.setStatus(Byte.valueOf((byte)10));
        source.setUpdateDate(date);
        this.itemSourceMapper.updateByExampleSelective(source, example2);
        return i;
    }

    @Transactional(readOnly=false)
    public void changeStatusByCidAndGenerationSource(Long cid, Byte generationSource, Byte status, Long loginStaffId, Long businessId) {
        if (cid == null || generationSource == null) {
            return;
        }
        List<Byte> generationSources = List.of(generationSource);
        if (List.of(ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue()).contains(generationSource)) {
            generationSources = List.of(ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue());
        }
        ReformSearchVo searchVo = new ReformSearchVo().setCid(cid).setGenerationSources(generationSources).setIsCompleted(Boolean.valueOf(false));
        this.getReformItemBasicList(searchVo).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getFindTimeYear)).forEach((year, reformNotAccList) -> this.changeStatusDivide((List<ReformItemBasic>)reformNotAccList, generationSource, cid, (Integer)year, loginStaffId));
    }

    public Byte changeStatusDivide(List<ReformItemBasic> notAcceptReformList, Byte generationSource, Long cid, Integer year, Long loginStaffId) {
        if (CollectionUtils.isEmpty(notAcceptReformList)) {
            return null;
        }
        Byte status = null;
        Integer effectiveYear = ReformItemBasicCommandServiceImpl.getEffectiveYear(year);
        String effectiveDateStr = ReformItemBasicCommandServiceImpl.getEffectiveDateStr(year);
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case NOZYFZR: {
                status = this.getTrainReformChangeStatus(cid, 12, effectiveDateStr);
                List<ReformItemBasic> collect1819 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOZYFZR.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform(collect1819, null, status, loginStaffId);
                if (!Objects.equals(status, (byte)3)) break;
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.TRAIN, null);
                break;
            }
            case NOGLRY: {
                status = this.getTrainReformChangeStatus(cid, 13, effectiveDateStr);
                List<ReformItemBasic> collect1820 = notAcceptReformList.stream().filter(item -> item.getGenerationSource().equals(ReformGenerationSourceEnum.NOGLRY.getValue()) || item.getGenerationSource().equals(ReformGenerationSourceEnum.TRAIN.getValue())).collect(Collectors.toList());
                this.makeAndUpdateReform(collect1820, null, status, loginStaffId);
                if (!Objects.equals(status, (byte)3)) break;
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.TRAIN, null);
                break;
            }
            case THREE_TIME: {
                status = this.getThreeTimeReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                break;
            }
            case PROTECTION: {
                status = this.getProtectReformChangeStatus(cid, year);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                if (!Objects.equals(status, (byte)3)) break;
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.PERSONSHIELD, null);
                break;
            }
            case WARNING_SIGNS: {
                status = this.getWarnSignReformChangeStatus(cid, effectiveDateStr);
                this.makeAndUpdateReform(notAcceptReformList, null, status, loginStaffId);
                if (!Objects.equals(status, (byte)3)) break;
                this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.WMBASE, null);
                break;
            }
            case ARCHIVES: {
                List<Long> zjArchiveCountViewByCid = this.getZjArchiveCountViewByCid(Collections.singletonList(cid), year);
                if (!CollectionUtils.isNotEmpty(zjArchiveCountViewByCid)) break;
                this.makeAndUpdateReform(notAcceptReformList, null, (byte)3, loginStaffId);
                break;
            }
        }
        return status;
    }

    private Byte getThreeTimeReformChangeStatus(Long cid, String effectiveDateStr) {
        List<TsProjectSimple> projectSimpleList = ((ReformItemBasicCommandMapper)this.dao).getThreeSimultaneousList(List.of(cid), null, null);
        if (CollectionUtils.isEmpty(projectSimpleList)) {
            return (byte)-1;
        }
        boolean isAUDIT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.AUDIT.getCode()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        boolean isBack = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.BACK.getCode()) || item.getStatus().equals(TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()));
        if (isBack) {
            return ReformStatusEnum.TH.getValue();
        }
        boolean isDRAFT = projectSimpleList.parallelStream().anyMatch(item -> item.getStatus().equals(TsProjectSimpleStatusEnum.DRAFT.getCode()));
        if (isDRAFT) {
            return ReformStatusEnum.CG.getValue();
        }
        return ReformStatusEnum.WC.getValue();
    }

    private Byte getTrainReformChangeStatus(Long cid, Integer type, String effectiveDateStr) {
        List<CertificateStaffDetail> list = ((ReformItemBasicCommandMapper)this.dao).getTrainList(List.of(cid), null, type, null);
        if (CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> {
            if (item.getStatus() == null || item.getStatus().equals(ApprovalStatusEnum.PASSED.getValue()) || item.getStatus().equals(ApprovalStatusEnum.NONEEDAPPROVAL.getValue())) {
                return item.getValidityDate() != null && item.getValidityDate().getTime() > DateUtils.parseDate((Object)effectiveDateStr).getTime();
            }
            return false;
        });
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getStatus() != null && item.getStatus().equals(ApprovalStatusEnum.WAITAPPROVAL.getValue()));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getProtectReformChangeStatus(Long cid, Integer year) {
        List<ProtectEquipIssueRecord> allProtectEquip = ((ReformItemBasicCommandMapper)this.dao).getProtectEquipList(List.of(cid), null, null);
        if (CollectionUtils.isEmpty(allProtectEquip)) {
            return (byte)-1;
        }
        boolean isFinish = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)) && item.getIssuedTime() != null && DateUtils.getYear((Date)item.getIssuedTime()) >= year);
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = allProtectEquip.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    private Byte getWarnSignReformChangeStatus(Long cid, String effectiveDateStr) {
        List<WarnSignManage> list = ((ReformItemBasicCommandMapper)this.dao).getWarnSignList(List.of(cid), null, null);
        if (CollectionUtils.isEmpty(list)) {
            return (byte)-1;
        }
        boolean isFinish = list.parallelStream().anyMatch(item -> item.getReportState() != null && (item.getReportState().equals(4) || item.getReportState().equals(5)) && item.getChangeTime() != null && DateUtils.addYear((Date)item.getChangeTime(), (int)3).getTime() > DateUtils.parseDate((Object)effectiveDateStr).getTime());
        if (isFinish) {
            return ReformStatusEnum.WC.getValue();
        }
        boolean isAUDIT = list.parallelStream().anyMatch(item -> item.getReportState() != null && item.getReportState().equals(2));
        if (isAUDIT) {
            return ReformStatusEnum.DYS.getValue();
        }
        return ReformStatusEnum.CG.getValue();
    }

    @Transactional
    public void deleteReform(List<Long> cidList, List<Byte> generationSources, List<Long> idList) {
        List list2;
        Example example2;
        List list;
        Example example;
        if (CollectionUtils.isNotEmpty(cidList) && CollectionUtils.isNotEmpty(generationSources)) {
            example = new Example(ReformItemBasic.class);
            example.createCriteria().andIn("cid", cidList).andIn("generationSource", generationSources);
            list = this.getListByExample(example);
            for (ReformItemBasic basic : list) {
                if (basic == null) continue;
                basic.setIsValid(Boolean.FALSE);
                this.updateByPrimaryKey(basic, 1L);
            }
            example2 = new Example(ReformItemSource.class);
            example2.createCriteria().andIn("cid", cidList).andIn("generationSource", generationSources);
            list2 = this.itemSourceService.getListByExample(example2);
            for (ReformItemSource source : list2) {
                if (source == null) continue;
                source.setIsValid(Boolean.FALSE);
                this.itemSourceService.updateByPrimaryKey((Object)source, Long.valueOf(1L));
            }
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            example = new Example(ReformItemBasic.class);
            example.createCriteria().andIn("id", idList);
            list = this.getListByExample(example);
            for (ReformItemBasic basic : list) {
                if (basic == null) continue;
                basic.setIsValid(Boolean.FALSE);
                this.updateByPrimaryKey(basic, 1L);
            }
            example2 = new Example(ReformItemSource.class);
            example2.createCriteria().andIn("reformItemId", idList);
            list2 = this.itemSourceService.getListByExample(example2);
            for (ReformItemSource source : list2) {
                if (source == null) continue;
                source.setIsValid(Boolean.FALSE);
                this.itemSourceService.updateByPrimaryKey((Object)source, Long.valueOf(1L));
            }
        }
    }

    public List<Long> getCompanyList(List<Long> cidList, String type) {
        return ((ReformItemBasicCommandMapper)this.dao).getCompanyList(cidList, type);
    }

    @Transactional
    public void generateQaRecordByJCCB(List<Long> cidList) {
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u53ea\u80fd\u95ee\u7b54\u5f00\u59cb", (Object[])new Object[0]);
        List<Long> companyList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(cidList, "\u8d8a\u57ce\u533a\u5c0f\u5fae\u4f01\u4e1a");
        if (CollectionUtils.isEmpty(companyList)) {
            return;
        }
        List<ReformItemBasic> unGeneratedCidList = ((ReformItemBasicCommandMapper)this.dao).getUnExistQaRecordList(companyList, null);
        ArrayList checkIdList = new ArrayList();
        HashMap checkIdAndCidMap = new HashMap();
        unGeneratedCidList.forEach(basic -> {
            checkIdList.add(basic.getReformItemSourceId());
            checkIdAndCidMap.put(basic.getReformItemSourceId(), basic.getCid());
        });
        Map dataListByCheckIdList = this.riskExposeEvaluateDataService.getEvaluateDataListByCheckIdList(checkIdList, Boolean.valueOf(true));
        Map checkPlanMap = this.checkPlanService.getMapByIds(checkIdList);
        HashMap checkIdAndRemarks = new HashMap();
        HashMap<Long, String> checkIdAndMessage = new HashMap<Long, String>();
        dataListByCheckIdList.forEach((checkId, evaluateDataList) -> {
            if (CollectionUtils.isNotEmpty((Collection)evaluateDataList)) {
                String message = RiskExposeEvaluateDataUtil.convertToString((List)evaluateDataList);
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    checkIdAndMessage.put((Long)checkId, message);
                }
                CheckPlan checkPlan = (CheckPlan)checkPlanMap.get(checkId);
                String dataTime = "";
                if (checkPlan != null && checkPlan.getCheckDateBegin() != null) {
                    dataTime = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5").format(checkPlan.getCheckDateBegin());
                }
                String type = "";
                if (checkPlan != null && checkPlan.getCheckType() != null) {
                    if (checkPlan.getCheckType().equals(1L)) {
                        type = "\u65e5\u5e38\u76d1\u6d4b";
                    }
                    if (checkPlan.getCheckType().equals(2L)) {
                        type = "\u5b9a\u671f\u68c0\u6d4b";
                    }
                    if (checkPlan.getCheckType().equals(3L)) {
                        type = "\u73b0\u72b6\u8bc4\u4ef7";
                    }
                    if (checkPlan.getCheckType().equals(4L)) {
                        type = "\u63a7\u8bc4\u6548\u679c\u8bc4\u4ef7";
                    }
                    if (checkPlan.getCheckType().equals(5L)) {
                        type = "\u5176\u4ed6\u68c0\u6d4b\u7c7b\u578b";
                    }
                }
                String collect = evaluateDataList.stream().map(RiskExposeEvaluateData::getFactorName).distinct().collect(Collectors.joining(","));
                checkIdAndRemarks.put(checkId, dataTime + type + "\u7ed3\u679c\u5b58\u5728\u3010" + collect + "\u3011\u8d85\u6807");
            }
        });
        ArrayList qaRecordList = new ArrayList();
        LocalDateTime now = LocalDateTime.now();
        checkIdAndMessage.forEach((checkId, message) -> {
            if (StringUtils.isBlank((CharSequence)message) || !checkIdAndCidMap.containsKey(checkId)) {
                return;
            }
            Long cid = (Long)checkIdAndCidMap.get(checkId);
            QaRecord qaRecord = new QaRecord();
            qaRecord.setCid(cid);
            qaRecord.setBusinessId(checkId.toString());
            qaRecord.setType(RiskTypeEnum.JJCB.getCode());
            qaRecord.setQuestionContent(message);
            qaRecord.setRemarks((String)checkIdAndRemarks.get(checkId));
            qaRecord.setAnswerContent(null);
            qaRecord.setCreateTime(now);
            qaRecord.setCreateTime(now);
            qaRecord.setIsValid(Boolean.valueOf(true));
            qaRecordList.add(qaRecord);
        });
        this.qaRecordService.insertList(qaRecordList);
        XxlJobHelper.log((String)"\u6dfb\u52a0\u8d85\u6807\u70b9\u53ea\u80fd\u95ee\u7b54\u7ed3\u675f\uff0c\u6570\u91cf{}", (Object[])new Object[]{qaRecordList.size()});
    }

    public Map<Long, LocalDate> estimateRiskFirstWarningTime(List<Long> cidList, Byte generationSource) {
        if (CollectionUtils.isEmpty(cidList) || generationSource == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, LocalDate> map = new HashMap<Long, LocalDate>();
        Date beginDate = new Date();
        Integer effectiveYear = ReformItemBasicCommandServiceImpl.getEffectiveYear(null);
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)generationSource))) {
            case TJ: {
                Map<Long, Date> phyMap = ((ReformItemBasicCommandMapper)this.dao).getPhysicalList(cidList, null, null).stream().filter(Objects::nonNull).peek(item -> item.setCheckTime(DateUtils.addYear((Date)item.getCheckTime(), (int)1))).collect(Collectors.toMap(PhcPhysicalCheckV3221::getCid, PhcPhysicalCheckV3221::getCheckTime));
                this.getEstimateMap(cidList, generationSource, phyMap, beginDate, map);
                return map;
            }
            case DETECTION: {
                Map<Long, Date> checkMap1 = ((ReformItemBasicCommandMapper)this.dao).getCheckList(cidList, null, null, null, "\u4e25\u91cd").stream().filter(Objects::nonNull).peek(item -> item.setCheckDateBegin(item.getCheckDateBegin().plusYears(1L))).collect(Collectors.toMap(CheckPlan::getCid, item -> DateUtils.localDateTimeToDate((LocalDateTime)item.getCheckDateBegin())));
                Map<Long, Date> checkMap2 = ((ReformItemBasicCommandMapper)this.dao).getCheckList(cidList, null, null, null, "\u4e00\u822c").stream().filter(Objects::nonNull).peek(item -> item.setCheckDateBegin(item.getCheckDateBegin().plusYears(3L))).collect(Collectors.toMap(CheckPlan::getCid, item -> DateUtils.localDateTimeToDate((LocalDateTime)item.getCheckDateBegin())));
                checkMap1.putAll(checkMap2);
                this.getEstimateMap(cidList, generationSource, checkMap1, beginDate, map);
                return map;
            }
            case TRAIN: {
                Map<Long, Date> trainMap1 = ((ReformItemBasicCommandMapper)this.dao).getTrainList(cidList, null, null, true).stream().filter(Objects::nonNull).collect(Collectors.toMap(CertificateStaffDetail::getCid, CertificateStaffDetail::getValidityDate));
                this.getEstimateMap(cidList, generationSource, trainMap1, beginDate, map);
                return map;
            }
            case PROTECTION: {
                Map<Long, Date> protectionMap = ((ReformItemBasicCommandMapper)this.dao).getProtectEquipList(cidList, null, true).stream().filter(Objects::nonNull).peek(item -> item.setIssuedTime(this.getFindTimeByBusTime(item.getIssuedTime(), null, 1, true))).collect(Collectors.toMap(ProtectEquipIssueRecord::getCid, ProtectEquipIssueRecord::getIssuedTime));
                this.getEstimateMap(cidList, generationSource, protectionMap, beginDate, map);
                return map;
            }
            case WARNING_SIGNS: {
                Map<Long, Date> warnSignMap = ((ReformItemBasicCommandMapper)this.dao).getWarnSignList(cidList, null, true).stream().filter(Objects::nonNull).peek(item -> item.setChangeTime(this.getFindTimeByBusTime(item.getChangeTime(), null, 3, true))).collect(Collectors.toMap(WarnSignManage::getCid, WarnSignManage::getChangeTime));
                this.getEstimateMap(cidList, generationSource, warnSignMap, beginDate, map);
                return map;
            }
            case THREE_TIME: {
                Map<Long, Date> lastYearReformMap1 = this.getLastYearReformMap(cidList, ReformGenerationSourceEnum.THREE_TIME.getValue(), effectiveYear);
                HashMap<Long, Date> busDateMap1 = new HashMap<Long, Date>();
                lastYearReformMap1.forEach((cid, lastWarnDate) -> busDateMap1.put((Long)cid, this.getFindTimeByBusTime(null, DateUtils.chooseLastDate((Date)lastWarnDate, (Date)beginDate), null, true)));
                this.getEstimateMap(cidList, generationSource, busDateMap1, beginDate, map);
                return map;
            }
            case ARCHIVES: {
                Map<Long, Date> lastYearReformMap2 = this.getLastYearReformMap(cidList, ReformGenerationSourceEnum.ARCHIVES.getValue(), effectiveYear);
                HashMap<Long, Date> busDateMap2 = new HashMap<Long, Date>();
                lastYearReformMap2.forEach((cid, lastWarnDate) -> busDateMap2.put((Long)cid, this.getFindTimeByBusTime(null, (Date)lastWarnDate, null, true)));
                this.getEstimateMap(cidList, generationSource, busDateMap2, beginDate, map);
            }
        }
        return map;
    }

    private void getEstimateMap(List<Long> cidList, Byte generationSource, Map<Long, Date> busDateMap, Date beginDate, Map<Long, LocalDate> map) {
        Integer effectiveYear = ReformItemBasicCommandServiceImpl.getEffectiveYear(null);
        Date endDate = DateUtils.addMonth((Date)beginDate, (int)3);
        Map<Object, Object> reformMap = new HashMap();
        if (List.of(ReformGenerationSourceEnum.TJ.getValue(), ReformGenerationSourceEnum.DETECTION.getValue()).contains(generationSource)) {
            reformMap = this.getReformItemBasicList(new ReformSearchVo().setCidList(cidList).setGenerationSource(generationSource).setYear(effectiveYear).setIsFileComplete(Boolean.valueOf(true)).setBackStrName("cidAndMaxActualFinishTime")).stream().filter(item -> item != null && item.getActualFinishTime() != null).collect(Collectors.toMap(ReformItemBasic::getCid, item -> DateUtils.addMonth((Date)item.getActualFinishTime(), (int)2), (a, b) -> a));
        }
        for (Long cid : cidList) {
            Date date = DateUtils.chooseLastDate((Date)busDateMap.get(cid), (Date)((Date)reformMap.get(cid)));
            if (date == null || date.before(beginDate)) {
                map.put(cid, DateUtil.getFromDate2((Date)beginDate));
                continue;
            }
            if (DateUtils.compare_time((Date)date, (Date)beginDate) < 0L || DateUtils.compare_time((Date)date, (Date)endDate) > 0L) continue;
            map.put(cid, DateUtil.getFromDate2((Date)date));
        }
    }

    @Transactional
    public void generatePhcFangSheTime(String cids) {
        List<Long> companyList = ((ReformItemBasicCommandMapper)this.dao).getCompanyList(StringUtils.parseToLongList((String)cids), "\u653e\u5c04\u4f01\u4e1a");
        if (CollectionUtils.isEmpty(companyList)) {
            return;
        }
        String checkTime = LocalDateTime.now().minusYears(3L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ((ReformItemBasicCommandMapper)this.dao).deletePhcFangSheTime(companyList);
        List split = ListUtils.split(companyList, (int)50);
        for (int i = 0; i < split.size(); ++i) {
            List list = (List)split.get(i);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            ((ReformItemBasicCommandMapper)this.dao).insertPhcFangSheTime(list, checkTime);
            XxlJobHelper.log((String)"\u603b\u5171\u6279\u6b21\u6709{},\u7b2c{}\u6b21\u6267\u884c", (Object[])new Object[]{split.size(), i + 1});
            this.logger.error("\u603b\u5171\u6279\u6b21\u6709{},\u7b2c{}\u6b21\u6267\u884c", (Object)split.size(), (Object)(i + 1));
        }
    }
}

