/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.reform.ReformItemAcceptanceRecordMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.DustListModel;
import cn.smarthse.services.hfi.api.model.result.ListParamModel;
import cn.smarthse.services.hfi.api.service.ICheckResultPageService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ReformItemAcceptanceRecordServiceImpl
extends BaseServiceImpl<ReformItemAcceptanceRecordMapper, ReformItemAcceptanceRecord>
implements IReformItemAcceptanceRecordService {
    @Autowired
    ReformItemAcceptanceRecordMapper reformItemAcceptanceRecordMapper;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private IStaffInfoService staffService;
    @DubboReference(check=false)
    private ICheckResultPageService checkResultPageService;
    @Autowired
    RedisClient redisClient;
    private static final List<String> specialDustName = Arrays.asList("\u7164\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u547c\u5c18)", "\u77f3\u58a8\u7c89\u5c18(\u547c\u5c18)", "\u6ed1\u77f3\u7c89\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u547c\u5c18)", "\u6c34\u6ce5\u7c89\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u547c\u5c18)", "\u4e91\u6bcd\u7c89\u5c18(\u547c\u5c18)", "\u767d\u4e91\u77f3\u7c89\u5c18(\u547c\u5c18)", "\u5927\u7406\u77f3\u7c89\u5c18(\u78b3\u9178\u9499)(\u547c\u5c18)", "\u77f3\u818f\u7c89\u5c18(\u786b\u9178\u9499)(\u547c\u5c18)", "\u77f3\u7070\u77f3\u7c89\u5c18(\u547c\u5c18)", "\u78b3\u5316\u7845\u7c89\u5c18(\u547c\u5c18)", "\u8424\u77f3\u6df7\u5408\u6027\u7c89\u5c18(\u547c\u5c18)", "\u73cd\u73e0\u5ca9\u7c89\u5c18(\u547c\u5c18)", "\u51dd\u805aSiO\u2082\u7c89\u5c18(\u547c\u5c18)", "\u77fd\u5c18(10%\u2264\u6e38\u79bbSiO\u2082\u542b\u91cf\u226450%)(\u547c\u5c18)", "\u77fd\u5c18(50%<\u6e38\u79bbSiO\u2082\u542b\u91cf\u226480%)(\u547c\u5c18)", "\u77fd\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf>80%)(\u547c\u5c18)", "\u7164\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u603b\u5c18)", "\u77f3\u58a8\u7c89\u5c18(\u603b\u5c18)", "\u6ed1\u77f3\u7c89\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u603b\u5c18)", "\u6c34\u6ce5\u7c89\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf<10%)(\u603b\u5c18)", "\u4e91\u6bcd\u7c89\u5c18(\u603b\u5c18)", "\u767d\u4e91\u77f3\u7c89\u5c18(\u603b\u5c18)", "\u5927\u7406\u77f3\u7c89\u5c18(\u78b3\u9178\u9499)(\u603b\u5c18)", "\u77f3\u818f\u7c89\u5c18(\u786b\u9178\u9499)(\u603b\u5c18)", "\u77f3\u7070\u77f3\u7c89\u5c18(\u603b\u5c18)", "\u78b3\u5316\u7845\u7c89\u5c18(\u603b\u5c18)", "\u8424\u77f3\u6df7\u5408\u6027\u7c89\u5c18(\u603b\u5c18)", "\u73cd\u73e0\u5ca9\u7c89\u5c18(\u603b\u5c18)", "\u51dd\u805aSiO\u2082\u7c89\u5c18(\u603b\u5c18)", "\u77fd\u5c18(10%\u2264\u6e38\u79bbSiO\u2082\u542b\u91cf\u226450%)(\u603b\u5c18)", "\u77fd\u5c18(50%<\u6e38\u79bbSiO\u2082\u542b\u91cf\u226480%)(\u603b\u5c18)", "\u77fd\u5c18(\u6e38\u79bbSiO\u2082\u542b\u91cf>80%)(\u603b\u5c18)");

    public List<ReformItemAcceptanceRecord> getListByReformItemId(Long reformItemId) {
        if (reformItemId == null) {
            return Collections.emptyList();
        }
        Example example = new Example(ReformItemAcceptanceRecord.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("reformItemId", (Object)reformItemId);
        example.setOrderByClause("create_date asc");
        return ((ReformItemAcceptanceRecordMapper)this.dao).selectByExample(example);
    }

    private void setRedundancyInfo(ReformItemAcceptanceRecord entity) {
        if (entity.getAcceptanceDirector() != null) {
            entity.setAcceptanceDirectorName(this.staffService.getStaffNameByStaffId(entity.getAcceptanceDirector()));
        }
        if (entity.getAcceptanceCollaborator() != null) {
            entity.setAcceptanceCollaboratorName(this.staffService.getStaffNamesByStaffIds(entity.getAcceptanceCollaborator()));
        } else {
            entity.setAcceptanceCollaborator(",");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getReformCollaborator())) {
            entity.setReformCollaboratorName(this.staffService.getStaffNamesByStaffIds(entity.getReformCollaborator()));
        } else {
            entity.setReformCollaborator(",");
        }
        if (entity.getReformDirector() != null) {
            entity.setReformDirectorName(this.staffService.getStaffNameByStaffId(entity.getReformDirector()));
        }
        if (StringUtils.isEmpty((CharSequence)entity.getReformSolution())) {
            entity.setReformSolution(",");
        }
    }

    public ReformItemAcceptanceRecord saveAcceptanceInfo(ReformItemAcceptanceRecord entity, Long loginStaffId, Long cid) {
        if (entity == null || loginStaffId == null || cid == null) {
            return null;
        }
        if (entity.getReformDirector() != null && entity.getReformDirectorName() == null) {
            entity.setReformDirectorName(this.staffService.getStaffNameByStaffId(entity.getReformDirector()));
        }
        if (entity.getAcceptanceDirector() != null && entity.getAcceptanceDirectorName() == null) {
            entity.setAcceptanceDirectorName(this.staffService.getStaffNameByStaffId(entity.getAcceptanceDirector()));
        }
        if (entity.getId() == null) {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"add");
            }
            super.add(entity, loginStaffId, cid);
        } else {
            if (StatusEnum.isNeedValidate((Byte)entity.getStatus())) {
                ValidateUtil.valid((Object)entity, (String)"edit");
            }
            super.update(entity, loginStaffId);
        }
        return entity;
    }

    public List<ReformItemAcceptanceRecord> getListByCid(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        ReformItemAcceptanceRecord record = new ReformItemAcceptanceRecord();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        return ((ReformItemAcceptanceRecordMapper)this.dao).select(record);
    }

    public void deleteByReformId(Long reformItemId) {
        if (reformItemId != null) {
            ReformItemAcceptanceRecord record = new ReformItemAcceptanceRecord();
            record.setReformItemId(reformItemId);
            this.delete(record);
        }
    }

    @Transactional(readOnly=false)
    public Integer addRecordList(List<ReformItemAcceptanceRecord> records) {
        return ((ReformItemAcceptanceRecordMapper)this.dao).insertList2(records);
    }

    public List<ReformItemAcceptanceRecord> getListByReformItemIds(Set<Long> idSet) {
        return ((ReformItemAcceptanceRecordMapper)this.dao).getListByReformItemIds(idSet);
    }

    @Transactional
    public ReformCheckMeasure updateReformCheckMeasureByDetail(ReformCheckMeasure checkMeasure) {
        if (Objects.equals(checkMeasure.getCid(), 99657571579441900L) || Objects.equals(checkMeasure.getCid(), 4927705139842884127L) || Objects.equals(checkMeasure.getCid(), 99657571579870439L)) {
            if (checkMeasure.getId() == null) {
                checkMeasure.setId(Long.valueOf(this.idworker.nextId()));
                ((ReformItemAcceptanceRecordMapper)this.dao).insertReformCheckMeasureList(List.of(checkMeasure));
            } else {
                ((ReformItemAcceptanceRecordMapper)this.dao).updateReformCheckMeasure(List.of(checkMeasure));
            }
            return checkMeasure;
        }
        if (checkMeasure == null || checkMeasure.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        if (StringUtils.isNotBlank((CharSequence)checkMeasure.getFileIds()) && checkMeasure.getFileIds().contains(",")) {
            throw new ServiceException("\u4f5c\u8bc1\u6750\u6599\u53ea\u5141\u8bb8\u5355\u6587\u4ef6\u4e0a\u4f20");
        }
        List<ReformCheckMeasure> measureList = this.getReformCheckMeasureList(new ReformCheckMeasure().setId(checkMeasure.getId()));
        if (CollectionUtils.isEmpty(measureList) || measureList.get(0) == null || Arrays.asList(2, 3).contains(measureList.get(0).getSituation())) {
            throw new ServiceException("\u6570\u636e\u5f02\u5e38");
        }
        if (checkMeasure.getType() != null && StringUtils.isNotBlank((CharSequence)checkMeasure.getContent()) && StringUtils.isNotBlank((CharSequence)checkMeasure.getFileIds())) {
            checkMeasure.setSituation(Integer.valueOf(1));
        } else {
            checkMeasure.setSituation(Integer.valueOf(0));
        }
        ReformCheckMeasure dbMeasure = measureList.get(0);
        ReformCheckMeasure search = new ReformCheckMeasure();
        search.setAcceptRecordId(dbMeasure.getAcceptRecordId());
        search.setReformId(dbMeasure.getReformId());
        search.setCheckId(dbMeasure.getCheckId());
        Long checkId = null;
        if (specialDustName.contains(dbMeasure.getFactoryName())) {
            checkId = ((ReformItemAcceptanceRecordMapper)this.dao).getIsHaveSpecialDust(search);
        }
        if (checkId == null) {
            Integer i = ((ReformItemAcceptanceRecordMapper)this.dao).updateReformCheckMeasure(Collections.singletonList(checkMeasure));
            return checkMeasure;
        }
        if (dbMeasure.getFactoryName().contains("(\u547c\u5c18)")) {
            search.setFactoryName(dbMeasure.getFactoryName().replaceAll("\\(\u547c\u5c18\\)", "(\u603b\u5c18)"));
        } else {
            search.setFactoryName(dbMeasure.getFactoryName().replaceAll("\\(\u603b\u5c18\\)", "(\u547c\u5c18)"));
        }
        search.setPointName(dbMeasure.getPointName());
        List<ReformCheckMeasure> otherList = this.getReformCheckMeasureList(search);
        ArrayList<ReformCheckMeasure> updateList = new ArrayList<ReformCheckMeasure>();
        if (CollectionUtils.isNotEmpty(otherList) && otherList.size() == 1) {
            Long id = otherList.get(0).getId();
            ReformCheckMeasure measureNew = new ReformCheckMeasure();
            measureNew.setId(id);
            measureNew.setCid(checkMeasure.getCid());
            measureNew.setType(checkMeasure.getType());
            measureNew.setContent(checkMeasure.getContent());
            measureNew.setFileIds(checkMeasure.getFileIds());
            measureNew.setSituation(checkMeasure.getSituation());
            measureNew.setUpdateBy(checkMeasure.getUpdateBy());
            measureNew.setUpdateDate(checkMeasure.getUpdateDate());
            measureNew.setChangeTime(checkMeasure.getChangeTime());
            updateList.add(measureNew);
        }
        updateList.add(checkMeasure);
        Integer i = ((ReformItemAcceptanceRecordMapper)this.dao).updateReformCheckMeasure(updateList);
        return checkMeasure;
    }

    @Transactional
    public Integer updateBatchReformCheckMeasure(List<ReformCheckMeasure> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return 0;
        }
        return ((ReformItemAcceptanceRecordMapper)this.dao).updateReformCheckMeasure(updateList);
    }

    @Transactional
    public Integer saveBatchReformCheckMeasure(List<ReformCheckMeasure> addList) {
        if (CollectionUtils.isEmpty(addList)) {
            return 0;
        }
        return ((ReformItemAcceptanceRecordMapper)this.dao).insertReformCheckMeasureList(addList);
    }

    public Integer insertReformCheckMeasureList(List<ReformCheckMeasure> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        return ((ReformItemAcceptanceRecordMapper)this.dao).insertReformCheckMeasureList(list);
    }

    public List<ReformCheckMeasure> getReformCheckMeasureList(ReformCheckMeasure checkMeasure) {
        if (checkMeasure == null) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)checkMeasure.getFactoryName())) {
            checkMeasure.setFactoryName(StringEscapeUtils.unescapeHtml4((String)checkMeasure.getFactoryName()));
        }
        List<ReformCheckMeasure> list = ((ReformItemAcceptanceRecordMapper)this.dao).getReformCheckMeasureListByAcceptId(checkMeasure);
        this.setCheckMeasureList(checkMeasure, list);
        return list;
    }

    public PageInfo<ReformCheckMeasure> getPageReformCheckMeasureList(JqGridParam jqGridParam, ReformCheckMeasure checkMeasure) {
        Long checkId = ((ReformItemAcceptanceRecordMapper)this.dao).getIsHaveSpecialDust(checkMeasure);
        if (checkId != null) {
            List<Object> allList = this.getReformCheckMeasureSpecialList(checkMeasure, checkId);
            if (StringUtils.isNotBlank((CharSequence)checkMeasure.getFactoryName())) {
                checkMeasure.setFactoryName(StringEscapeUtils.unescapeHtml4((String)checkMeasure.getFactoryName()));
                allList = allList.stream().filter(item -> item != null && StringUtils.isNotBlank((CharSequence)item.getFactoryName()) && item.getFactoryName().contains(checkMeasure.getFactoryName())).collect(Collectors.toList());
            }
            if (checkMeasure.getSituation() != null && checkMeasure.getSituation() != 4) {
                allList = allList.stream().filter(item -> item != null && item.getSituation().equals(checkMeasure.getSituation())).collect(Collectors.toList());
            }
            if (checkMeasure.getSituation() != null && checkMeasure.getSituation() == 4) {
                allList = allList.stream().filter(item -> item != null && Arrays.asList(2, 3).contains(checkMeasure.getSituation())).collect(Collectors.toList());
            }
            this.setCheckMeasureList(checkMeasure, allList);
            return PageUtil.getPageInfo(allList, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ReformCheckMeasure> list = this.getReformCheckMeasureList(checkMeasure);
        return new PageInfo(list);
    }

    private List<ReformCheckMeasure> getReformCheckMeasureSpecialList(ReformCheckMeasure checkMeasure, Long checkId) {
        ReformCheckMeasure search = new ReformCheckMeasure();
        search.setReformId(checkMeasure.getReformId());
        search.setCheckId(checkId);
        search.setAcceptRecordId(checkMeasure.getAcceptRecordId());
        List<ReformCheckMeasure> allList = ((ReformItemAcceptanceRecordMapper)this.dao).getReformCheckMeasureListByAcceptId(search);
        if (CollectionUtils.isEmpty(allList)) {
            return allList;
        }
        List<DustListModel> dustListModels = this.getDustListModelsByCache(allList);
        List list = allList.stream().filter(item -> item != null && StringUtils.isNotBlank((CharSequence)item.getFactoryName()) && specialDustName.contains(item.getFactoryName())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, List<ReformCheckMeasure>> collect = list.stream().collect(Collectors.groupingBy(item -> item.getPointName() + item.getFactoryName().replaceAll("\\(\u547c\u5c18\\)", "").replaceAll("\\(\u603b\u5c18\\)", "")));
            for (Map.Entry<String, List<ReformCheckMeasure>> entry : collect.entrySet()) {
                List<ReformCheckMeasure> value = entry.getValue();
                if (value.size() != 2) continue;
                String total = dustListModels.stream().filter(item -> item != null && (item.getWorkshopName() + "@" + item.getWorkName() + "@" + item.getCheckObject() + item.getCheckProject()).equals(entry.getKey()) && Objects.equals("\u4e0d\u7b26\u5408", item.getTotalResult())).map(BaseResultListMode::getCheckProject).findFirst().orElse("");
                String respirable = dustListModels.stream().filter(item -> item != null && (item.getWorkshopName() + "@" + item.getWorkName() + "@" + item.getCheckObject() + item.getCheckProject()).equals(entry.getKey()) && Objects.equals("\u4e0d\u7b26\u5408", item.getRespResult())).map(BaseResultListMode::getCheckProject).findFirst().orElse("");
                if (StringUtils.isBlank((CharSequence)total) && StringUtils.isBlank((CharSequence)respirable)) continue;
                allList.removeAll(value);
                ReformCheckMeasure measureNew = value.get(0);
                Object str = "";
                if (StringUtils.isNotBlank((CharSequence)total)) {
                    str = total + "(\u603b\u5c18)";
                }
                if (StringUtils.isNotBlank((CharSequence)respirable)) {
                    str = StringUtils.isBlank((CharSequence)str) ? respirable + "(\u547c\u5c18)" : (String)str + "/" + respirable + "(\u547c\u5c18)";
                }
                if (StringUtils.isNotBlank((CharSequence)str)) {
                    measureNew.setFactoryName((String)str);
                }
                allList.add(measureNew);
            }
        }
        return allList;
    }

    private List<DustListModel> getDustListModelsByCache(List<ReformCheckMeasure> allList) {
        Long checkId = allList.get(0).getCheckId();
        return (List)this.redisClient.get("IReformItemAcceptanceRecordService", "getDustListModelsByCache:" + checkId, 3600L, () -> {
            ListParamModel dust = new ListParamModel();
            dust.setCheckId(checkId);
            dust.setItemId(Long.valueOf(2L));
            dust.setJudgeResult("3");
            dust.setIsValid(Boolean.valueOf(true));
            JqGridParam dustParam = new JqGridParam();
            dustParam.setPage(1);
            dustParam.setRows(Integer.MAX_VALUE);
            return this.checkResultPageService.dustPage(dustParam, dust).getList();
        });
    }

    private void setCheckMeasureList(ReformCheckMeasure checkMeasure, List<ReformCheckMeasure> list) {
        Map<Object, Object> fileModelMap = new HashMap();
        if (checkMeasure.getIsBackFileModel().booleanValue()) {
            String collect = list.stream().filter(Objects::nonNull).map(ReformCheckMeasure::getFileIds).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
            fileModelMap = this.fileService.getListByIds(collect).stream().filter(Objects::nonNull).collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (o1, o2) -> o1));
        }
        for (ReformCheckMeasure measure : list) {
            String[] split;
            if (measure == null) continue;
            if (StringUtils.isNotBlank((CharSequence)measure.getFileIds()) && checkMeasure.getIsBackFileModel().booleanValue()) {
                Long fileId = Long.valueOf(measure.getFileIds());
                SysFileModel sysFileModel = (SysFileModel)fileModelMap.get(fileId);
                measure.setFileModel(sysFileModel);
            }
            if (!StringUtils.isNotBlank((CharSequence)measure.getPointName()) || measure.getCheckId() == null || (split = measure.getPointName().split("@")).length == 0) continue;
            measure.setPointNameStr(split[split.length - 1]);
        }
    }

    @Transactional
    public Integer deleteReformCheckMeasure(Long checkMeasureId) {
        return ((ReformItemAcceptanceRecordMapper)this.dao).deleteReformCheckMeasure(checkMeasureId);
    }

    public List<String> getCheckMeasureFactorNameList(Long acceptanceId) {
        if (acceptanceId == null) {
            return Collections.emptyList();
        }
        ReformCheckMeasure checkMeasure = new ReformCheckMeasure().setIsOld(Boolean.valueOf(false)).setAcceptRecordId(acceptanceId);
        Long checkId = ((ReformItemAcceptanceRecordMapper)this.dao).getIsHaveSpecialDust(checkMeasure);
        List<ReformCheckMeasure> list = checkId != null ? this.getReformCheckMeasureSpecialList(checkMeasure, checkId) : this.getReformCheckMeasureList(checkMeasure);
        return list.stream().filter(item -> item != null && com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)item.getFactoryName())).map(ReformCheckMeasure::getFactoryName).distinct().collect(Collectors.toList());
    }
}

