/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanyRiskProspectSearchModel;
import cn.smarthse.modules.health.dao.work.reform.CompanyRiskProspectMapper;
import cn.smarthse.modules.health.entity.work.reform.CompanyRiskProspect;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskProspectVo;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyTipsVo;
import cn.smarthse.modules.health.enums.reform.CompanyRiskProspectEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskProspectService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=false)
public class CompanyRiskProspectServiceImpl
extends BaseServiceImpl<CompanyRiskProspectMapper, CompanyRiskProspect>
implements ICompanyRiskProspectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyRiskProspectServiceImpl.class);
    @Resource
    private CompanyRiskProspectMapper companyRiskProspectMapper;
    @Autowired
    private IReformItemBasicNewService reformItemBasicNewService;
    @Autowired
    private IReformItemBasicCommandService reformItemBasicCommandService;
    @Autowired
    private ICompanyService companyService;
    private static final int BATCH_SIZE = 2500;
    private static final int COMPANY_BATCH_SIZE = 2500;

    public String getTipsTime(Long cid, Byte riskType) {
        LocalDateTime tipsTime = ((CompanyRiskProspectMapper)this.dao).getTipsTime(cid, riskType);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (tipsTime == null) {
            return null;
        }
        return tipsTime.format(formatter);
    }

    public int updateOrInsertBatch(List<CompanyRiskProspect> companyRiskProspects) {
        return this.companyRiskProspectMapper.updateOrInsertBatch(companyRiskProspects);
    }

    public Integer getCountSoonWarning(CompanyBusinessTableParam searchParam) {
        if (StringUtils.isNotBlank((CharSequence)searchParam.getScales())) {
            searchParam.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchParam.getScales(), (String)","));
        }
        searchParam.setIsHeader(Boolean.valueOf(true));
        if (Objects.equals(true, searchParam.getIsCityLevelStreet())) {
            searchParam.setBelongType(Integer.valueOf(2));
            searchParam.setOnlyThisLevel(Boolean.valueOf(true));
        }
        return ((CompanyRiskProspectMapper)this.dao).getCountSoonWarning(searchParam);
    }

    public List<CompanyTipsVo> getCompanyTips(Long companyId, Integer deTime) throws RuntimeException {
        List newCreateCids = this.companyService.getNewCreateCids();
        if (!newCreateCids.contains(companyId)) {
            return null;
        }
        CompanyRiskProspect companyRiskProspect = new CompanyRiskProspect();
        ReformSearchVo reformSearchVo = new ReformSearchVo();
        reformSearchVo.setYear(Integer.valueOf(DateUtils.getYear((Date)new Date())));
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.TJ.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setPhysicalExaminationStatus, CompanyRiskProspect::setPhysicalExaminationFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.DETECTION.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setCheckStatus, CompanyRiskProspect::setCheckFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.TRAIN.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setTrainingStatus, CompanyRiskProspect::setTrainingFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.THREE_TIME.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setThreeSimultaneousStatus, CompanyRiskProspect::setThreeSimultaneousFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.PROTECTION.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setProtectEquipStatus, CompanyRiskProspect::setProtectEquipFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.WARNING_SIGNS.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setWarnSignStatus, CompanyRiskProspect::setWarnSignFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.ARCHIVES.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setHealthManageFilesStatus, CompanyRiskProspect::setHealthManageFilesFirstWaringTime);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.GRJL.getValue());
        this.getCompanyRiskProspectToSource(companyId, companyRiskProspect, reformSearchVo, CompanyRiskProspect::setPersonDoseStatus, CompanyRiskProspect::setPersonDoseFirstWaringTime);
        return CompanyRiskProspectServiceImpl.isTips(companyRiskProspect, deTime);
    }

    private void getCompanyRiskProspectToSource(Long companyId, CompanyRiskProspect companyRiskProspect, ReformSearchVo reformSearchVo, BiConsumer<CompanyRiskProspect, Byte> setStatusFunc, BiConsumer<CompanyRiskProspect, LocalDateTime> setTimeFunc) {
        List<Long> cids = Collections.singletonList(companyId);
        reformSearchVo.setCidList(cids);
        List reformItemBasicWarnStatusInfoList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        LocalDate warningTime = (LocalDate)this.reformItemBasicCommandService.estimateRiskFirstWarningTime(cids, reformSearchVo.getGenerationSource()).get(companyId);
        if (reformItemBasicWarnStatusInfoList.isEmpty()) {
            if (warningTime == null) {
                setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.NORISK.getValue());
            } else {
                if (CompanyRiskProspectServiceImpl.warningTimeToStatus(warningTime.atStartOfDay())) {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
                } else {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.NORISK.getValue());
                }
                setTimeFunc.accept(companyRiskProspect, warningTime.atStartOfDay());
            }
        }
        for (ReformItemBasic reformItemBasic : reformItemBasicWarnStatusInfoList) {
            Byte status = reformItemBasic.getStatus();
            Byte lawStatus = reformItemBasic.getLawStatus();
            if (status != null && (status == 3 || status == 4)) {
                if (warningTime == null) {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.RESOLVED.getValue());
                    continue;
                }
                if (CompanyRiskProspectServiceImpl.warningTimeToStatus(warningTime.atStartOfDay())) {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
                } else {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.RESOLVED.getValue());
                }
                setTimeFunc.accept(companyRiskProspect, warningTime.atStartOfDay());
                continue;
            }
            if (lawStatus == null) continue;
            switch (lawStatus) {
                case 1: {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.FIRSTPUSH.getValue());
                    break;
                }
                case 2: {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.YELLOWWARN.getValue());
                    break;
                }
                case 3: {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.REDWARN.getValue());
                    break;
                }
                case 4: {
                    setStatusFunc.accept(companyRiskProspect, CompanyRiskProspectEnum.STARTPUNISH.getValue());
                }
            }
        }
    }

    public PageInfo<CompanyRiskProspectVo> getPageCompanyRiskProspect(JqGridParam param, CompanyRiskProspectSearchModel searchModel) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyRiskProspect> list = ((CompanyRiskProspectMapper)this.dao).getCompanyRiskCompletionBySearchModel(searchModel);
        PageInfo pageInfo = new PageInfo(list);
        List<CompanyRiskProspectVo> voList = this.convertToVoList(list);
        PageInfo voPageInfo = new PageInfo(voList);
        voPageInfo.setTotal(pageInfo.getTotal());
        voPageInfo.setPages(pageInfo.getPages());
        voPageInfo.setPageNum(pageInfo.getPageNum());
        voPageInfo.setPageSize(pageInfo.getPageSize());
        voPageInfo.setSize(pageInfo.getSize());
        voPageInfo.setStartRow(pageInfo.getStartRow());
        voPageInfo.setEndRow(pageInfo.getEndRow());
        voPageInfo.setPrePage(pageInfo.getPrePage());
        voPageInfo.setNextPage(pageInfo.getNextPage());
        voPageInfo.setIsFirstPage(pageInfo.isIsFirstPage());
        voPageInfo.setIsLastPage(pageInfo.isIsLastPage());
        voPageInfo.setHasPreviousPage(pageInfo.isHasPreviousPage());
        voPageInfo.setHasNextPage(pageInfo.isHasNextPage());
        return voPageInfo;
    }

    private List<CompanyRiskProspectVo> convertToVoList(List<CompanyRiskProspect> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(this::convertToVo).collect(Collectors.toList());
    }

    private CompanyRiskProspectVo convertToVo(CompanyRiskProspect entity) {
        CompanyRiskProspectVo vo = new CompanyRiskProspectVo();
        BeanUtils.copyBeanProp((Object)vo, (Object)entity);
        CompanyRiskProspectServiceImpl.setAllStatus(vo, entity);
        return vo;
    }

    private static void setAllStatus(CompanyRiskProspectVo companyRiskProspectVo, CompanyRiskProspect companyRiskProspect) {
        companyRiskProspectVo.setDeclareStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.DECLARE.getValue(), companyRiskProspect.getDeclareStatus()));
        companyRiskProspectVo.setCheckStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.DETECTION.getValue(), companyRiskProspect.getCheckStatus()));
        companyRiskProspectVo.setTrainingStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.TRAIN.getValue(), companyRiskProspect.getTrainingStatus()));
        companyRiskProspectVo.setPhysicalExaminationStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.TJ.getValue(), companyRiskProspect.getPhysicalExaminationStatus()));
        companyRiskProspectVo.setThreeSimultaneousStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.THREE_TIME.getValue(), companyRiskProspect.getThreeSimultaneousStatus()));
        companyRiskProspectVo.setProtectEquipStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.PROTECTION.getValue(), companyRiskProspect.getProtectEquipStatus()));
        companyRiskProspectVo.setWarnSignStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), companyRiskProspect.getWarnSignStatus()));
        companyRiskProspectVo.setHealthManageFilesStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.ARCHIVES.getValue(), companyRiskProspect.getHealthManageFilesStatus()));
        companyRiskProspectVo.setJjcbStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.JCCB.getValue(), companyRiskProspect.getJjcbStatus()));
        companyRiskProspectVo.setJjzStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.JJZ.getValue(), companyRiskProspect.getJjzStatus()));
        companyRiskProspectVo.setYszybStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.YSZYB.getValue(), companyRiskProspect.getYszybStatus()));
        companyRiskProspectVo.setPersonDoseStatus(CompanyRiskProspectServiceImpl.revertStatus(ReformGenerationSourceEnum.GRJL.getValue(), companyRiskProspect.getPersonDoseStatus()));
        companyRiskProspectVo.setThreeSimultaneousAllStatusList(CompanyRiskProspectServiceImpl.revertStatusList(companyRiskProspect.getThreeSimultaneousAllStatus()));
        companyRiskProspectVo.setJjcbAllStatusList(CompanyRiskProspectServiceImpl.revertStatusList(companyRiskProspect.getJjcbAllStatus()));
        companyRiskProspectVo.setJjzAllStatusList(CompanyRiskProspectServiceImpl.revertStatusList(companyRiskProspect.getJjzAllStatus()));
        companyRiskProspectVo.setYszybAllStatusList(CompanyRiskProspectServiceImpl.revertStatusList(companyRiskProspect.getYszybAllStatus()));
        companyRiskProspectVo.setPersonDoseAllStatusList(CompanyRiskProspectServiceImpl.revertStatusList(companyRiskProspect.getPersonDoseAllStatus()));
    }

    private static String revertStatus(Byte riskType, Byte status) {
        if (status == null) {
            if (Objects.equals(riskType, ReformGenerationSourceEnum.DECLARE.getValue())) {
                return "\u6682\u65e0\u7533\u62a5\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.DETECTION.getValue())) {
                return "\u6682\u65e0\u68c0\u6d4b\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.TRAIN.getValue())) {
                return "\u6682\u65e0\u57f9\u8bad\u6570\u636e\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.TJ.getValue())) {
                return "\u6682\u65e0\u4f53\u68c0\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.THREE_TIME.getValue())) {
                return "\u6682\u65e0\u4e09\u540c\u65f6\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.PROTECTION.getValue())) {
                return "\u6682\u65e0\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.WARNING_SIGNS.getValue())) {
                return "\u6682\u65e0\u8b66\u793a\u6807\u8bc6\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.ARCHIVES.getValue())) {
                return "\u6682\u65e0\u804c\u4e1a\u536b\u751f\u6863\u6848\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.JCCB.getValue())) {
                return "\u6682\u65e0\u68c0\u6d4b\u8d85\u6807\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.JJZ.getValue())) {
                return "\u6682\u65e0\u7981\u5fcc\u75c7\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.YSZYB.getValue())) {
                return "\u6682\u65e0\u7591\u4f3c\u804c\u4e1a\u75c5\u6570\u636e";
            }
            if (Objects.equals(riskType, ReformGenerationSourceEnum.GRJL.getValue())) {
                return "\u6682\u65e0\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u6570\u636e";
            }
            return null;
        }
        return CompanyRiskProspectEnum.getNameByValue((Byte)status);
    }

    private static List<String> revertStatusList(String allStatus) {
        String[] split;
        if (allStatus == null || allStatus.isEmpty()) {
            return null;
        }
        ArrayList<String> statusList = new ArrayList<String>();
        for (String status : split = allStatus.split(",")) {
            statusList.add(CompanyRiskProspectEnum.getNameByValue((Byte)Byte.valueOf(status)));
        }
        return statusList;
    }

    private static void processTime(LocalDateTime time, Byte riskType, List<CompanyTipsVo> companyTipsVos, LocalDateTime now, Integer deTime) {
        LocalDateTime oneMonthAgo;
        if (time != null && CompanyRiskProspectServiceImpl.isAfterOrEqual(now, oneMonthAgo = time.minusMonths(deTime.intValue())) && now.isBefore(time)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDate = time.format(formatter);
            CompanyTipsVo companyTipsVo = new CompanyTipsVo();
            companyTipsVo.setDate(formattedDate);
            switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType((Byte)riskType))) {
                case TJ: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.TJ.getValue());
                    break;
                }
                case DETECTION: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.DETECTION.getValue());
                    break;
                }
                case TRAIN: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.TRAIN.getValue());
                    break;
                }
                case PROTECTION: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.PROTECTION.getValue());
                    break;
                }
                case THREE_TIME: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u5b58\u5728\u672a\u5b8c\u6210\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.THREE_TIME.getValue());
                    break;
                }
                case ARCHIVES: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u5b8c\u5584\u804c\u4e1a\u536b\u751f\u6863\u6848");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.ARCHIVES.getValue());
                    break;
                }
                case GRJL: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u5b8c\u6210\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.GRJL.getValue());
                    break;
                }
                case WARNING_SIGNS: {
                    companyTipsVo.setName(DateUtils.getYear((Date)new Date()) + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6");
                    companyTipsVo.setRiskType(ReformGenerationSourceEnum.WARNING_SIGNS.getValue());
                }
            }
            companyTipsVos.add(companyTipsVo);
        }
    }

    private static List<CompanyTipsVo> isTips(CompanyRiskProspect companyRiskProspect, Integer deTime) {
        ArrayList<CompanyTipsVo> companyTipsVos = new ArrayList<CompanyTipsVo>();
        LocalDateTime now = LocalDateTime.now();
        if (companyRiskProspect != null && companyRiskProspect.getPhysicalExaminationFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getPhysicalExaminationFirstWaringTime(), ReformGenerationSourceEnum.TJ.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getCheckFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getCheckFirstWaringTime(), ReformGenerationSourceEnum.DETECTION.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getTrainingFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getTrainingFirstWaringTime(), ReformGenerationSourceEnum.TRAIN.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getProtectEquipFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getProtectEquipFirstWaringTime(), ReformGenerationSourceEnum.PROTECTION.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getThreeSimultaneousFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getThreeSimultaneousFirstWaringTime(), ReformGenerationSourceEnum.THREE_TIME.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getHealthManageFilesFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getHealthManageFilesFirstWaringTime(), ReformGenerationSourceEnum.ARCHIVES.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getPersonDoseFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getPersonDoseFirstWaringTime(), ReformGenerationSourceEnum.GRJL.getValue(), companyTipsVos, now, deTime);
        }
        if (companyRiskProspect != null && companyRiskProspect.getWarnSignFirstWaringTime() != null) {
            CompanyRiskProspectServiceImpl.processTime(companyRiskProspect.getWarnSignFirstWaringTime(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), companyTipsVos, now, deTime);
        }
        return companyTipsVos;
    }

    public static boolean isAfterOrEqual(LocalDateTime t1, LocalDateTime t2) {
        return t1.isAfter(t2) || t1.isEqual(t2);
    }

    public void generateLastReport(Long companyId) throws RuntimeException {
        List cids = new ArrayList<Long>();
        if (companyId != null) {
            cids.add(companyId);
        } else {
            cids = this.companyService.getCids();
        }
        LinkedHashSet uniqueCids = new LinkedHashSet(cids);
        cids = new ArrayList(uniqueCids);
        ReformSearchVo reformSearchVo = new ReformSearchVo();
        reformSearchVo.setYear(Integer.valueOf(DateUtils.getYear((Date)new Date())));
        for (int i = 0; i < cids.size(); i += 2500) {
            int end = Math.min(i + 2500, cids.size());
            List<Long> batchCids = cids.subList(i, end);
            log.info("\u5f00\u59cb\u5904\u7406\u4f01\u4e1a\u6279\u6b21 {}/{}, \u4f01\u4e1a\u6570\u91cf: {}", new Object[]{i / 2500 + 1, (cids.size() + 2500 - 1) / 2500, batchCids.size()});
            this.processCompanyBatch(batchCids, reformSearchVo);
        }
        ((CompanyRiskProspectMapper)this.dao).updateIsError();
    }

    private void processCompanyBatch(List<Long> batchCids, ReformSearchVo reformSearchVo) {
        HashMap<Long, CompanyRiskProspect> companyMap = new HashMap<Long, CompanyRiskProspect>();
        for (Long cid : batchCids) {
            CompanyRiskProspect company = new CompanyRiskProspect();
            company.setId(cid);
            company.setError(Byte.valueOf((byte)0));
            companyMap.put(cid, company);
        }
        reformSearchVo.setCidList(batchCids);
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.DECLARE.getValue());
        List dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setOneStatusForBatch(companyMap, dataList, CompanyRiskProspect::setDeclareStatus);
        log.info("\u7533\u62a5\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setAllStatusForBatch(companyMap, dataList, CompanyRiskProspect::setJjcbStatus, CompanyRiskProspect::setJjcbAllStatus);
        log.info("\u68c0\u6d4b\u8d85\u6807\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.JJZ.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setAllStatusForBatch(companyMap, dataList, CompanyRiskProspect::setJjzStatus, CompanyRiskProspect::setJjzAllStatus);
        log.info("\u7981\u5fcc\u75c7\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.YSZYB.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setAllStatusForBatch(companyMap, dataList, CompanyRiskProspect::setYszybStatus, CompanyRiskProspect::setYszybAllStatus);
        log.info("\u7591\u4f3c\u804c\u4e1a\u75c5\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.TJ.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.TJ.getValue(), CompanyRiskProspect::setPhysicalExaminationStatus, CompanyRiskProspect::setPhysicalExaminationFirstWaringTime);
        log.info("\u4f53\u68c0\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.DETECTION.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.DETECTION.getValue(), CompanyRiskProspect::setCheckStatus, CompanyRiskProspect::setCheckFirstWaringTime);
        log.info("\u68c0\u6d4b\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.THREE_TIME.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setMultiStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.THREE_TIME.getValue(), CompanyRiskProspect::setThreeSimultaneousStatus, CompanyRiskProspect::setThreeSimultaneousAllStatus, CompanyRiskProspect::setThreeSimultaneousFirstWaringTime);
        log.info("\u4e09\u540c\u65f6\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.TRAIN.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.TRAIN.getValue(), CompanyRiskProspect::setTrainingStatus, CompanyRiskProspect::setTrainingFirstWaringTime);
        log.info("\u57f9\u8bad\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.PROTECTION.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.PROTECTION.getValue(), CompanyRiskProspect::setProtectEquipStatus, CompanyRiskProspect::setProtectEquipFirstWaringTime);
        log.info("\u4e2a\u4eba\u9632\u62a4\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.WARNING_SIGNS.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), CompanyRiskProspect::setWarnSignStatus, CompanyRiskProspect::setWarnSignFirstWaringTime);
        log.info("\u8b66\u793a\u6807\u8bc6\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.ARCHIVES.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setRiskStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.ARCHIVES.getValue(), CompanyRiskProspect::setHealthManageFilesStatus, CompanyRiskProspect::setHealthManageFilesFirstWaringTime);
        log.info("\u6863\u6848\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        reformSearchVo.setGenerationSource(ReformGenerationSourceEnum.GRJL.getValue());
        dataList = this.reformItemBasicNewService.getReformItemBasicWarnStatusInfoList(reformSearchVo);
        this.setMultiStatusAndTimeForBatch(companyMap, dataList, ReformGenerationSourceEnum.GRJL.getValue(), CompanyRiskProspect::setPersonDoseStatus, CompanyRiskProspect::setPersonDoseAllStatus, CompanyRiskProspect::setPersonDoseFirstWaringTime);
        log.info("\u4e2a\u4eba\u5242\u91cf\u5904\u7406\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}", (Object)batchCids.size());
        ArrayList<CompanyRiskProspect> batchData = new ArrayList<CompanyRiskProspect>(companyMap.values());
        int insertCount = this.batchUpdateOrInsert(batchData);
        log.info("\u4f01\u4e1a\u6279\u6b21\u4fdd\u5b58\u5b8c\u6210, \u4f01\u4e1a\u6570\u91cf: {}, \u66f4\u65b0\u6570: {}", (Object)batchCids.size(), (Object)insertCount);
    }

    private void setOneStatusForBatch(Map<Long, CompanyRiskProspect> companyMap, List<ReformItemBasic> dataList, BiConsumer<CompanyRiskProspect, Byte> setStatusFunc) {
        Map<Long, ReformItemBasic> dataMap = dataList.stream().collect(Collectors.toMap(ReformItemBasic::getCid, item -> item, (a, b) -> a));
        for (CompanyRiskProspect company : companyMap.values()) {
            ReformItemBasic item2 = dataMap.get(company.getId());
            Byte statusValue = item2 != null ? this.calcRiskStatus(item2.getStatus(), item2.getLawStatus()).byteValue() : CompanyRiskProspectEnum.NORISK.getValue();
            setStatusFunc.accept(company, statusValue);
        }
    }

    private void setAllStatusForBatch(Map<Long, CompanyRiskProspect> companyMap, List<ReformItemBasic> dataList, BiConsumer<CompanyRiskProspect, Byte> setStatusFunc, BiConsumer<CompanyRiskProspect, String> setAllStatusFunc) {
        Map<Long, List<ReformItemBasic>> cidMap = dataList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (CompanyRiskProspect company : companyMap.values()) {
            List<ReformItemBasic> itemList = cidMap.get(company.getId());
            if (itemList != null && !itemList.isEmpty()) {
                List riskStatusList = itemList.stream().map(item -> this.calcRiskStatus(item.getStatus(), item.getLawStatus())).filter(Objects::nonNull).collect(Collectors.toList());
                String allStatus = riskStatusList.stream().distinct().filter(s -> !s.equals(CompanyRiskProspectEnum.NORISK.getValue()) && !s.equals(CompanyRiskProspectEnum.RESOLVED.getValue())).map(String::valueOf).collect(Collectors.joining(","));
                Byte maxStatus = riskStatusList.stream().max(Byte::compare).orElse(CompanyRiskProspectEnum.NORISK.getValue());
                setStatusFunc.accept(company, maxStatus);
                setAllStatusFunc.accept(company, allStatus);
                continue;
            }
            setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
            setAllStatusFunc.accept(company, "");
        }
    }

    private void setRiskStatusAndTimeForBatch(Map<Long, CompanyRiskProspect> companyMap, List<ReformItemBasic> dataList, Byte generationSource, BiConsumer<CompanyRiskProspect, Byte> setStatusFunc, BiConsumer<CompanyRiskProspect, LocalDateTime> setTimeFunc) {
        Map warningTimeMap = this.reformItemBasicCommandService.estimateRiskFirstWarningTime(new ArrayList<Long>(companyMap.keySet()), generationSource);
        Map<Long, ReformItemBasic> dataMap = dataList.stream().collect(Collectors.toMap(ReformItemBasic::getCid, item -> item, (a, b) -> {
            Byte sa = this.calcRiskStatus(a.getStatus(), a.getLawStatus());
            Byte sb = this.calcRiskStatus(b.getStatus(), b.getLawStatus());
            return sb > sa ? b : a;
        }));
        for (CompanyRiskProspect company : companyMap.values()) {
            LocalDateTime now;
            ReformItemBasic item2 = dataMap.get(company.getId());
            if (item2 != null) {
                Byte status = item2.getStatus();
                Byte lawStatus = item2.getLawStatus();
                if (status != null && (status == 3 || status == 4)) {
                    LocalDate warningDate = (LocalDate)warningTimeMap.get(company.getId());
                    if (warningDate == null) {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.RESOLVED.getValue());
                        continue;
                    }
                    setTimeFunc.accept(company, warningDate.atStartOfDay());
                    if (CompanyRiskProspectServiceImpl.warningTimeToStatus(warningDate.atStartOfDay())) {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
                        continue;
                    }
                    setStatusFunc.accept(company, CompanyRiskProspectEnum.RESOLVED.getValue());
                    continue;
                }
                if (lawStatus == null) continue;
                switch (lawStatus) {
                    case 1: {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.FIRSTPUSH.getValue());
                        break;
                    }
                    case 2: {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.YELLOWWARN.getValue());
                        break;
                    }
                    case 3: {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.REDWARN.getValue());
                        break;
                    }
                    case 4: {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.STARTPUNISH.getValue());
                    }
                }
                continue;
            }
            if (warningTimeMap.get(company.getId()) == null) {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
                continue;
            }
            LocalDateTime warning = ((LocalDate)warningTimeMap.get(company.getId())).atStartOfDay();
            if (warning.equals(now = LocalDate.now().atStartOfDay())) {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
            }
            if (CompanyRiskProspectServiceImpl.warningTimeToStatus(warning)) {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
            } else {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
            }
            setTimeFunc.accept(company, warning);
        }
    }

    private void setMultiStatusAndTimeForBatch(Map<Long, CompanyRiskProspect> companyMap, List<ReformItemBasic> dataList, Byte generationSource, BiConsumer<CompanyRiskProspect, Byte> setStatusFunc, BiConsumer<CompanyRiskProspect, String> setAllStatusFunc, BiConsumer<CompanyRiskProspect, LocalDateTime> setTimeFunc) {
        Map warningTimeMap = this.reformItemBasicCommandService.estimateRiskFirstWarningTime(new ArrayList<Long>(companyMap.keySet()), generationSource);
        Map<Long, List<ReformItemBasic>> cidMap = dataList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (CompanyRiskProspect company : companyMap.values()) {
            List<ReformItemBasic> itemList = cidMap.get(company.getId());
            if (itemList != null && !itemList.isEmpty()) {
                List riskStatusList = itemList.stream().map(item -> this.calcRiskStatus(item.getStatus(), item.getLawStatus())).filter(Objects::nonNull).collect(Collectors.toList());
                String allStatus = riskStatusList.stream().distinct().map(String::valueOf).collect(Collectors.joining(","));
                Byte maxStatus = riskStatusList.stream().max(Byte::compare).orElse(CompanyRiskProspectEnum.NORISK.getValue());
                setAllStatusFunc.accept(company, allStatus);
                setStatusFunc.accept(company, maxStatus);
                if (!maxStatus.equals(CompanyRiskProspectEnum.RESOLVED.getValue())) continue;
                LocalDate warningDate = (LocalDate)warningTimeMap.get(company.getId());
                if (warningDate != null) {
                    if (CompanyRiskProspectServiceImpl.warningTimeToStatus(warningDate.atStartOfDay())) {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
                    } else {
                        setStatusFunc.accept(company, CompanyRiskProspectEnum.RESOLVED.getValue());
                    }
                    setTimeFunc.accept(company, warningDate.atStartOfDay());
                    continue;
                }
                setStatusFunc.accept(company, CompanyRiskProspectEnum.RESOLVED.getValue());
                continue;
            }
            if (warningTimeMap.get(company.getId()) == null) {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
                continue;
            }
            if (CompanyRiskProspectServiceImpl.warningTimeToStatus(((LocalDate)warningTimeMap.get(company.getId())).atStartOfDay())) {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.SOONFIRSTPUSH.getValue());
            } else {
                setStatusFunc.accept(company, CompanyRiskProspectEnum.NORISK.getValue());
            }
            setAllStatusFunc.accept(company, "");
            setTimeFunc.accept(company, ((LocalDate)warningTimeMap.get(company.getId())).atStartOfDay());
        }
    }

    private Byte calcRiskStatus(Byte status, Byte lawStatus) {
        if (status != null && (status == 3 || status == 4)) {
            return CompanyRiskProspectEnum.RESOLVED.getValue();
        }
        if (lawStatus != null) {
            switch (lawStatus) {
                case 1: {
                    return CompanyRiskProspectEnum.FIRSTPUSH.getValue();
                }
                case 2: {
                    return CompanyRiskProspectEnum.YELLOWWARN.getValue();
                }
                case 3: {
                    return CompanyRiskProspectEnum.REDWARN.getValue();
                }
                case 4: {
                    return CompanyRiskProspectEnum.STARTPUNISH.getValue();
                }
            }
        }
        return CompanyRiskProspectEnum.NORISK.getValue();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int batchUpdateOrInsert(List<CompanyRiskProspect> companyRiskProspects) {
        int total = 0;
        for (int i = 0; i < companyRiskProspects.size(); i += 2500) {
            int end = Math.min(i + 2500, companyRiskProspects.size());
            List<CompanyRiskProspect> subList = companyRiskProspects.subList(i, end);
            total += this.updateOrInsertBatch(subList);
        }
        return total;
    }

    private static boolean warningTimeToStatus(LocalDateTime warning) {
        LocalDateTime oneMonthAgo = warning.minusMonths(1L);
        LocalDateTime now = LocalDateTime.now();
        return CompanyRiskProspectServiceImpl.isAfterOrEqual(now, oneMonthAgo) && now.isBefore(warning);
    }
}

