/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.work.reform.CompanyRiskCompletionMapper;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ComRiskCompletionStatisticsVo;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyCheckRiskCompletion;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskCompletion;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.work.impl.reform.ReformItemBasicServiceImpl;
import cn.smarthse.modules.health.service.work.reform.IComRiskCompleteWsService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryScoreInfo;
import cn.smarthse.modules.health.supervise.service.reform.IDyAreaRiskCompletionService;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.util.common.ListUtils;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=false)
public class CompanyRiskCompletionServiceImpl
extends BaseServiceImpl<CompanyRiskCompletionMapper, CompanyRiskCompletion>
implements ICompanyRiskCompletionService {
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private IReformItemBasicService itemBasicService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IDyAreaRiskCompletionService dyAreaRiskCompletionService;
    @DubboReference
    private IBusinessDataUpdateRefreshService refreshService;
    @Autowired
    private IComRiskCompleteWsService riskCompleteWsService;

    @Transactional
    public void generateCompanyRiskCompletion(List<Long> idList, Boolean flag) {
        int num = 0;
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        Example example = new Example(CompanyRiskCompletion.class);
        if (CollectionUtils.isNotEmpty(idList)) {
            example.createCriteria().andIn("id", idList);
        }
        int i = ((CompanyRiskCompletionMapper)this.dao).deleteByExample(example);
        this.logger.info("\u751f\u6210\u98ce\u9669\u5b8c\u6210\u60c5\u51b5--\u5220\u9664\u6570\u636e{}\u6761", (Object)i);
        List<CompanyRiskCompletion> allList = ((CompanyRiskCompletionMapper)this.dao).getAllCompanyRiskCompletionByIds(idList);
        List split = ListUtils.split(allList, (int)1000);
        for (List keyFactoryCompletionList : split) {
            if (CollectionUtils.isEmpty((Collection)keyFactoryCompletionList)) continue;
            this.setCompanyRiskCompletionList(keyFactoryCompletionList);
            RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
            ((CompanyRiskCompletionMapper)this.dao).insertList2(keyFactoryCompletionList);
            this.logger.info("\u3010\u751f\u6210\u98ce\u9669\u5b8c\u6210\u60c5\u51b5---\u8fdb\u884c\u4e2d\u3011" + ++num);
        }
        this.logger.info("\u751f\u6210\u98ce\u9669\u5b8c\u6210\u60c5\u51b5--\u5b8c\u6210");
        this.riskCompleteWsService.generateComRiskCompleteWs(idList);
        this.logger.info("\u751f\u6210\u4ec5\u4e0a\u4f20\u4f50\u8bc1\u6750\u6599\u5316\u89e3\u98ce\u9669\u4f01\u4e1a\u6e05\u5355--\u5f00\u59cb");
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        Integer q = ((CompanyRiskCompletionMapper)this.dao).deleteCompanyCheckRiskCompletion(idList, "company_check_risk_completion");
        Integer q2 = ((CompanyRiskCompletionMapper)this.dao).deleteCompanyCheckRiskCompletion(idList, "company_phy_risk_completion");
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        Integer p = ((CompanyRiskCompletionMapper)this.dao).generateCompanyCheckRiskCompletion(idList, "company_check_risk_completion");
        Integer p2 = ((CompanyRiskCompletionMapper)this.dao).generateCompanyCheckRiskCompletion(idList, "company_phy_risk_completion");
        this.logger.info("\u751f\u6210\u4ec5\u4e0a\u4f20\u4f50\u8bc1\u6750\u6599\u5316\u89e3\u98ce\u9669\u4f01\u4e1a\u6e05\u5355--\u7ed3\u675f,\u5220\u9664{}\u6761\uff0c\u751f\u6210{}\u6761", (Object)q, (Object)p);
        this.logger.info("\u751f\u6210\u4e1c\u9633\u533a\u57df\u98ce\u9669\u5316\u89e3\u60c5\u51b5\u548c\u5de1\u67e5\u60c5\u51b5\u62a5\u8868--\u5f00\u59cb");
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        this.dyAreaRiskCompletionService.generateDyAreaRiskCompletion(idList);
        this.logger.info("\u751f\u6210\u4e1c\u9633\u533a\u57df\u98ce\u9669\u5316\u89e3\u60c5\u51b5\u548c\u5de1\u67e5\u60c5\u51b5\u62a5\u8868--\u7ed3\u675f");
    }

    private void setCompanyRiskCompletionList(List<CompanyRiskCompletion> keyFactoryCompletionList) {
        Date date = new Date();
        List<Long> cidList = keyFactoryCompletionList.parallelStream().map(CompanyRiskCompletion::getId).collect(Collectors.toList());
        Map<Long, Integer> declareCountMap = ((CompanyRiskCompletionMapper)this.dao).getDeclareNumMap(cidList).stream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, CompanyRiskCompletion::getDeclareCount, (v1, v2) -> v1));
        Map<Long, Integer> physicalCurCountMap = ((CompanyRiskCompletionMapper)this.dao).getPhysicalCurNumMap(cidList).stream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, CompanyRiskCompletion::getPhysicalCurCount, (v1, v2) -> v1));
        Map<Long, Integer> checkCurCountMap = ((CompanyRiskCompletionMapper)this.dao).getCheckCurNumMap(cidList).stream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, CompanyRiskCompletion::getCheckCurCount, (v1, v2) -> v1));
        Map threeTimeMap = ((CompanyRiskCompletionMapper)this.dao).getThreeTimeNum(cidList).parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, Function.identity(), (v1, v2) -> v2));
        Map archive234Map = ((CompanyRiskCompletionMapper)this.dao).get234Completed(cidList, Arrays.asList(2, 3, 4), "2025").parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, Function.identity(), (v1, v2) -> v2));
        Set archive1 = this.itemBasicService.getThreeTimeReformByCid(cidList).parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
        List<Long> phyComplete = ((CompanyRiskCompletionMapper)this.dao).getPhyCompleteByCid(cidList);
        List<Long> reformPhyComplete = ((CompanyRiskCompletionMapper)this.dao).getRiskCompletedList(cidList, null, Collections.singletonList(ReformGenerationSourceEnum.TJ.getValue()));
        phyComplete.addAll(reformPhyComplete);
        Set archive56 = phyComplete.parallelStream().filter(Objects::nonNull).collect(Collectors.toSet());
        phyComplete.clear();
        reformPhyComplete.clear();
        for (CompanyRiskCompletion item : keyFactoryCompletionList) {
            Long cid = item.getId();
            item.setCreateDate(date);
            item.setIsValid(Boolean.valueOf(true));
            int noCompletedNum = 0;
            if (!item.getDeclare().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getCheck().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getPhysicalExamination().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getTraining().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getProtectEquip().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getWarnSignManage().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getHealthManageFiles().booleanValue()) {
                ++noCompletedNum;
            }
            if (!item.getThreeSimultaneous().booleanValue()) {
                ++noCompletedNum;
            }
            item.setNoCompletedNum(Integer.valueOf(noCompletedNum));
            int noCompletedNum10 = 0;
            if (!item.getDeclare().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getCheck().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getPhysicalExamination().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getTraining().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getProtectEquip().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getWarnSignManage().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getHealthManageFiles().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getThreeSimultaneous().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getJccb().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getJjz().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getYszyb().booleanValue()) {
                ++noCompletedNum10;
            }
            if (!item.getPersonDose().booleanValue()) {
                ++noCompletedNum10;
            }
            item.setNoCompletedNum10(Integer.valueOf(noCompletedNum10));
            int noCompletedNum12 = 0;
            if (!item.getDeclare().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getCheck().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getPhysicalExamination().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getTraining().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getProtectEquip().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getWarnSignManage().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getHealthManageFiles().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getThreeSimultaneous().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getJccb().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getJjz().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getYszyb().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getPersonDose().booleanValue()) {
                ++noCompletedNum12;
            }
            if (!item.getPersonDoseCb().booleanValue()) {
                ++noCompletedNum12;
            }
            item.setNoCompletedNum12(Integer.valueOf(noCompletedNum12));
            int egitRiskNum = item.getDeclareNum() + item.getPhysicalExaminationNum() + item.getCheckNum() + item.getTrainingNum() + item.getThreeSimultaneousNum() + item.getWarnSignManageNum() + item.getProtectEquipNum() + item.getHealthManageFilesNum();
            item.setPickupCount(Integer.valueOf(egitRiskNum > 0 ? 1 : 0));
            item.setDeclareCount(Integer.valueOf(declareCountMap.get(item.getId()) == null ? 0 : declareCountMap.get(item.getId())));
            item.setPhysicalCurCount(Integer.valueOf(physicalCurCountMap.get(item.getId()) == null ? 0 : physicalCurCountMap.get(item.getId())));
            item.setCheckCurCount(Integer.valueOf(checkCurCountMap.get(item.getId()) == null ? 0 : checkCurCountMap.get(item.getId())));
            if (CollectionUtils.isNotEmpty(threeTimeMap) && threeTimeMap.get(cid) != null) {
                CompanyRiskCompletion threeNum = (CompanyRiskCompletion)threeTimeMap.get(cid);
                if (item.getThreeSimultaneous().booleanValue()) {
                    item.setThreeAllComplete(threeNum.getThreeComplete());
                    item.setThreeComplete(threeNum.getThreeComplete());
                } else {
                    item.setThreeAllComplete(threeNum.getThreeAllComplete());
                    item.setThreeComplete(threeNum.getThreeComplete());
                }
            } else {
                item.setThreeAllComplete(Integer.valueOf(0));
                item.setThreeComplete(Integer.valueOf(0));
            }
            int archiveComplete = 1;
            if (CollectionUtils.isNotEmpty(archive234Map) && archive234Map.get(cid) != null) {
                CompanyRiskCompletion archive234 = (CompanyRiskCompletion)archive234Map.get(cid);
                if (archive234.getArchive2() > 0) {
                    ++archiveComplete;
                }
                if (archive234.getArchive3() > 0) {
                    ++archiveComplete;
                }
                if (archive234.getArchive4() > 0) {
                    ++archiveComplete;
                }
            }
            if (CollectionUtils.isNotEmpty(archive56) && archive56.contains(cid)) {
                ++archiveComplete;
                ++archiveComplete;
            }
            if (CollectionUtils.isNotEmpty(archive1) && archive1.contains(cid)) {
                --archiveComplete;
            }
            item.setHealthComplete(Integer.valueOf(archiveComplete));
        }
    }

    public List<RiskTypeVo> selectRiskTypeListData(List<Long> cidList, boolean isBack) {
        List<CompanyRiskCompletion> riskCompletions;
        ArrayList<RiskTypeVo> list = new ArrayList<RiskTypeVo>();
        if (isBack) {
            riskCompletions = ((CompanyRiskCompletionMapper)this.dao).getCompanyRiskCompletion20250110(cidList);
            if (CollectionUtils.isEmpty(riskCompletions)) {
                Example example = new Example(CompanyRiskCompletion.class);
                if (CollectionUtils.isNotEmpty(cidList)) {
                    example.createCriteria().andIn("id", cidList);
                }
                riskCompletions = ((CompanyRiskCompletionMapper)this.dao).selectByExample(example);
            }
        } else {
            riskCompletions = ((CompanyRiskCompletionMapper)this.dao).getAllCompanyRiskCompletionByIds(cidList);
            if (CollectionUtils.isNotEmpty(riskCompletions)) {
                this.setCompanyRiskCompletionList(riskCompletions);
            }
        }
        Map companyRiskCompletionMap = riskCompletions.stream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyRiskCompletion::getId, Function.identity(), (o1, o2) -> o1));
        int total = 0;
        int unComplete = 0;
        for (Long cid : cidList) {
            CompanyRiskCompletion item = (CompanyRiskCompletion)companyRiskCompletionMap.get(cid);
            ArrayList<RiskTypeVo> riskList = new ArrayList<RiskTypeVo>(ReformItemBasicServiceImpl.DEFAULT_RISK_TYPE_STATE_LIST);
            for (RiskTypeVo risk1 : riskList) {
                String riskTypeCode;
                RiskTypeVo risk = new RiskTypeVo();
                BeanUtils.copyProperties((Object)risk1, (Object)risk);
                risk.setCid(cid);
                if (item == null) {
                    list.add(risk);
                    continue;
                }
                switch (riskTypeCode = risk.getRiskTypeCode()) {
                    case "declare_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.DECLARE);
                        risk.setRiskTypeStatus(item.getDeclare() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getDeclare().booleanValue() || item.getDeclareNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        if (item.getDeclareCount() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u7533\u62a5\u6570\u636e");
                        break;
                    }
                    case "detection_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.DETECTION);
                        risk.setRiskTypeStatus(item.getCheck() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getCheck().booleanValue() || item.getCheckNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "physicalExamination_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.TJ);
                        risk.setRiskTypeStatus(item.getPhysicalExamination() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getPhysicalExamination().booleanValue() || item.getPhysicalExaminationNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "training_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.TRAIN);
                        risk.setRiskTypeStatus(item.getTraining() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getTraining().booleanValue() || item.getTrainingNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "threeTime_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.THREE_TIME);
                        risk.setRiskTypeStatus(item.getThreeSimultaneous() != false ? "\u5df2\u5316\u89e3[" + item.getThreeComplete() + "/" + item.getThreeAllComplete() + "]" : "\u672a\u5316\u89e3[" + item.getThreeComplete() + "/" + item.getThreeAllComplete() + "]");
                        if (!item.getThreeSimultaneous().booleanValue() || item.getThreeSimultaneousNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "protective_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.PROTECTION);
                        risk.setRiskTypeStatus(item.getProtectEquip() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getProtectEquip().booleanValue() || item.getProtectEquipNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "warningMark_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.WARNING_SIGNS);
                        risk.setRiskTypeStatus(item.getWarnSignManage() != false ? "\u5df2\u5316\u89e3" : "\u672a\u5316\u89e3");
                        if (!item.getWarnSignManage().booleanValue() || item.getWarnSignManageNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "healthArchive_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.ARCHIVES);
                        risk.setRiskTypeStatus(item.getHealthManageFiles() != false ? "\u5df2\u5316\u89e3[" + item.getHealthComplete() + "/6]" : "\u672a\u5316\u89e3[" + item.getHealthComplete() + "/6]");
                        if (!item.getHealthManageFiles().booleanValue() || item.getHealthManageFilesNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "grjl_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.GRJL);
                        total = item.getPersonDoseNum() == null ? 0 : item.getPersonDoseNum();
                        unComplete = item.getPersonDoseNoNum() == null ? 0 : item.getPersonDoseNoNum();
                        risk.setRiskTypeStatus(item.getPersonDose() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
                        if (!item.getPersonDose().booleanValue() || item.getPersonDoseNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "suspected_occ_disease": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.YSZYB);
                        total = item.getYszybNum() == null ? 0 : item.getYszybNum();
                        unComplete = item.getYszybNoNum() == null ? 0 : item.getYszybNoNum();
                        risk.setRiskTypeStatus(item.getYszyb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
                        if (!item.getYszyb().booleanValue() || item.getYszybNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "occ_contraindications": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.JJZ);
                        total = item.getJjzNum() == null ? 0 : item.getJjzNum();
                        unComplete = item.getJjzNoNum() == null ? 0 : item.getJjzNoNum();
                        risk.setRiskTypeStatus(item.getJjz() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
                        if (!item.getJjz().booleanValue() || item.getJjzNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "jccb_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.JCCB);
                        total = item.getJccbNum() == null ? 0 : item.getJccbNum();
                        unComplete = item.getJccbNoNum() == null ? 0 : item.getJccbNoNum();
                        risk.setRiskTypeStatus(item.getJccb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
                        if (!item.getJccb().booleanValue() || item.getJccbNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                    case "jccbzg_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.JCCBZG);
                        risk.setRiskTypeStatus("\u6682\u65e0\u5f53\u5e74\u76d1\u6d4b\u6570\u636e");
                        break;
                    }
                    case "grjlcb_riskType": {
                        risk.setGenerationSource(ReformGenerationSourceEnum.GRJLCB);
                        total = item.getPersonDoseCbNum() == null ? 0 : item.getPersonDoseCbNum();
                        unComplete = item.getPersonDoseCbNoNum() == null ? 0 : item.getPersonDoseCbNoNum();
                        risk.setRiskTypeStatus(item.getPersonDoseCb() != false ? "\u5df2\u5316\u89e3[" + (total - unComplete) + "/" + total + "]" : "\u672a\u5316\u89e3[" + (total - unComplete) + "/" + total + "]");
                        if (!item.getPersonDoseCb().booleanValue() || item.getPersonDoseCbNum() != 0) break;
                        risk.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
                        break;
                    }
                }
                list.add(risk);
            }
        }
        return list;
    }

    @Transactional
    public Integer insertCompanyRiskCompletion(List<CompanyRiskCompletion> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        this.logger.info("\u63d2\u5165\u98ce\u9669\u5b8c\u6210\u60c5\u51b5{}\u6761", (Object)list.size());
        return ((CompanyRiskCompletionMapper)this.dao).insertList2(list);
    }

    public void updateCompanyRiskCompletion(List<Long> cidList, Boolean refresh) {
        if (refresh.booleanValue() && CollectionUtils.isNotEmpty(cidList)) {
            this.generateCompanyRiskCompletion(cidList, true);
            return;
        }
        Date dataBaseMaxTime = ((CompanyRiskCompletionMapper)this.dao).getCompanyRiskCompletionMaxTime(null, null);
        if (dataBaseMaxTime == null) {
            return;
        }
        String strMaxTime = DateUtils.format((Date)dataBaseMaxTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<Long> updateList = ((CompanyRiskCompletionMapper)this.dao).getNeedUpdateCompanyRiskCompletion(cidList, strMaxTime);
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.generateCompanyRiskCompletion(updateList, true);
        }
    }

    public List<CompanyRiskCompletion> getCompanyRiskCompletionBySearchModel(CompanyRiskCompletion searchModel) {
        this.setCompanyRiskCompletionSearchModel(searchModel);
        return ((CompanyRiskCompletionMapper)this.dao).getCompanyRiskCompletionBySearchModel(searchModel);
    }

    public Integer getCompanyRiskCompletionBySearchModelCount(CompanyRiskCompletion searchModel) {
        this.setCompanyRiskCompletionSearchModel(searchModel);
        return ((CompanyRiskCompletionMapper)this.dao).getCompanyRiskCompletionBySearchModelCount(searchModel);
    }

    private void setCompanyRiskCompletionSearchModel(CompanyRiskCompletion searchModel) {
        if (searchModel.getIsPatrol() != null) {
            List<Long> patrolList = ((CompanyRiskCompletionMapper)this.dao).getPatrolList(searchModel);
            if (CollectionUtils.isEmpty(patrolList)) {
                patrolList.add(-1L);
            }
            searchModel.setPatrolList(patrolList);
        }
        if (StringUtils.isNotBlank((CharSequence)searchModel.getScales())) {
            searchModel.setScaleList(cn.smarthse.common.util.StringUtils.parseToIntegerList((String)searchModel.getScales(), (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)searchModel.getType()) && searchModel.getCompleted() != null) {
            Set collect = Arrays.stream(searchModel.getType().split(",")).collect(Collectors.toSet());
            if (collect.contains("0")) {
                searchModel.setDeclare(searchModel.getCompleted());
            }
            if (collect.contains("1")) {
                searchModel.setPhysicalExamination(searchModel.getCompleted());
            }
            if (collect.contains("2")) {
                searchModel.setCheck(searchModel.getCompleted());
            }
            if (collect.contains("3")) {
                searchModel.setTraining(searchModel.getCompleted());
            }
            if (collect.contains("4")) {
                searchModel.setThreeSimultaneous(searchModel.getCompleted());
            }
            if (collect.contains("5")) {
                searchModel.setProtectEquip(searchModel.getCompleted());
            }
            if (collect.contains("6")) {
                searchModel.setWarnSignManage(searchModel.getCompleted());
            }
            if (collect.contains("7")) {
                searchModel.setHealthManageFiles(searchModel.getCompleted());
            }
            if (collect.contains("8")) {
                searchModel.setJccb(searchModel.getCompleted());
            }
            if (collect.contains("9")) {
                searchModel.setJjz(searchModel.getCompleted());
            }
            if (collect.contains("10")) {
                searchModel.setYszyb(searchModel.getCompleted());
            }
            if (collect.contains("11")) {
                searchModel.setJccbzg(searchModel.getCompleted());
            }
            if (collect.contains("12")) {
                searchModel.setPersonDose(searchModel.getCompleted());
            }
            if (collect.contains("13")) {
                searchModel.setPersonDoseCb(searchModel.getCompleted());
            }
        }
    }

    public List<Long> getUnresolvedAssessCompanyIds(List<Long> cidList) {
        return ((CompanyRiskCompletionMapper)this.dao).getUnresolvedAssessCompanyIds(cidList);
    }

    public List<Long> getUnresolvedAssessCompanyIdsV2(List<Long> cidList, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        return ((CompanyRiskCompletionMapper)this.dao).getUnresolvedAssessCompanyIdsV2(cidList, startDate, endDate);
    }

    public Date getCompanyRiskCompletionMaxTime(Byte areaLevle, Long areaId) {
        return ((CompanyRiskCompletionMapper)this.dao).getCompanyRiskCompletionMaxTime(areaLevle, areaId);
    }

    public PageInfo<CompanyRiskCompletion> getPageCompanyRiskCompletionBySearchModel(JqGridParam jqGridParam, CompanyRiskCompletion searchParam) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<CompanyRiskCompletion> list = this.getCompanyRiskCompletionBySearchModel(searchParam);
        return new PageInfo(list);
    }

    public CompanyCheckRiskCompletion checkRiskCompletedHeadData(RiskResolveResSearch searchParam) {
        List<CompanyCheckRiskCompletion> list;
        if (searchParam.getAreaLevel().intValue() >= 3) {
            searchParam.setIsCurrent(Boolean.valueOf(true));
        }
        if (CollectionUtils.isNotEmpty(list = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedHeadData(searchParam)) && list.get(0).getProvinceId() != null) {
            CompanyCheckRiskCompletion data = list.get(0);
            if (searchParam.getAreaLevel().intValue() == 1) {
                data.setCurrentHeadAreaName(data.getProvinceName());
                data.setCurrentHeadAreaId(data.getProvinceId());
            } else if (searchParam.getAreaLevel().intValue() == 2) {
                if (searchParam.getIsCurrent() != null && searchParam.getIsCurrent().booleanValue()) {
                    data.setCurrentHeadAreaName(data.getCityName() + "\u672c\u7ea7");
                    data.setCurrentHeadAreaId(data.getCityId());
                    data.setOnlyThisLevelArea(Boolean.valueOf(true));
                    data.setOnlyThisLevelAreaId(data.getCityId());
                } else {
                    data.setCurrentHeadAreaName(data.getCityName());
                    data.setCurrentHeadAreaId(data.getCityId());
                }
            } else if (searchParam.getAreaLevel().intValue() == 3) {
                data.setCurrentHeadAreaName(data.getAreaName());
                data.setCurrentHeadAreaId(data.getAreaId());
            } else if (searchParam.getAreaLevel().intValue() == 4) {
                data.setCurrentHeadAreaName(data.getStreetName());
                data.setCurrentHeadAreaId(data.getStreetId());
            }
            String rate = data.getNoCheckRiskCompletedRate();
            if (StringUtils.isNotBlank((CharSequence)rate)) {
                double value = Double.parseDouble(rate);
                if (value > 15.0) {
                    data.setPercentage(Integer.valueOf(1));
                }
                data.setNoCheckRiskCompletedRate(rate + "%");
            }
            return data;
        }
        AreaModel model = this.sysAreaProvideService.getAreaById(searchParam.getAreaId());
        CompanyCheckRiskCompletion temp = new CompanyCheckRiskCompletion().setProvinceId(model.getProvinceId()).setProvinceName(model.getProvinceName()).setCityId(model.getCityId()).setCityName(model.getCityName()).setAreaId(model.getAreaId()).setAreaName(model.getAreaName()).setStreetId(model.getStreetId()).setStreetName(model.getStreetName()).setKeyFactoryNum(Integer.valueOf(0)).setCheckRiskCompletedNum(Integer.valueOf(0)).setNoCheckRiskCompletedNum(Integer.valueOf(0)).setNoCheckRiskCompletedRate("0.00%").setCurrentHeadAreaName(model.getName()).setCurrentHeadAreaId(model.getId());
        return temp;
    }

    public List<CompanyCheckRiskCompletion> checkRiskCompletedListData(RiskResolveResSearch searchParam) {
        List<Object> list;
        if (searchParam.getAreaLevel().intValue() > 3) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)searchParam.getKeyWord())) {
            searchParam.setIsCurrent(Boolean.valueOf(true));
            searchParam.setCompanyLevel(Integer.valueOf(0));
            list = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedHeadData(searchParam);
            this.setSupplementAreaInfo(searchParam.getAreaId(), 6, list, searchParam);
        } else if (searchParam.getIsCity().booleanValue() || searchParam.getIsCounty().booleanValue()) {
            list = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedListAllData(searchParam);
            if (searchParam.getIsCity().booleanValue()) {
                this.setSupplementAreaInfo(searchParam.getAreaId(), searchParam.getAreaLevel().intValue(), list, searchParam);
            }
            if (searchParam.getIsCounty().booleanValue()) {
                this.setSupplementAreaInfo(searchParam.getAreaId(), 5, list, searchParam);
            }
        } else if (searchParam.getAreaLevel().intValue() == 2 && searchParam.getIsCurrent() != null && searchParam.getIsCurrent().booleanValue()) {
            list = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedListSearchData(searchParam);
        } else {
            list = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedListSearchData(searchParam);
            this.setSupplementAreaInfo(searchParam.getAreaId(), searchParam.getAreaLevel().intValue(), list, searchParam);
            if (CollectionUtils.isNotEmpty(list) && list.get(0).getProvinceId() != null && searchParam.getAreaLevel().intValue() == 2) {
                Boolean isCurrent = searchParam.getIsCurrent();
                searchParam.setIsCurrent(Boolean.valueOf(true));
                List<CompanyCheckRiskCompletion> supplementList = ((CompanyRiskCompletionMapper)this.dao).checkRiskCompletedHeadData(searchParam);
                if (CollectionUtils.isNotEmpty(supplementList) && supplementList.get(0).getProvinceId() != null) {
                    CompanyCheckRiskCompletion temp = supplementList.get(0);
                    temp.setAreaName(temp.getCityName() + "\u672c\u7ea7");
                    temp.setOnlyThisLevelArea(Boolean.valueOf(true));
                    temp.setOnlyThisLevelAreaId(temp.getCityId());
                    list.add(temp);
                    list = list.parallelStream().sorted((v1, v2) -> {
                        Double num1 = Double.parseDouble(v1.getNoCheckRiskCompletedRate());
                        Double num2 = Double.parseDouble(v2.getNoCheckRiskCompletedRate());
                        return num2.compareTo(num1);
                    }).collect(Collectors.toList());
                }
                searchParam.setIsCurrent(isCurrent);
            }
        }
        int i = 1;
        for (CompanyCheckRiskCompletion item : list) {
            if (item == null) continue;
            if (StringUtils.isNotBlank((CharSequence)searchParam.getKeyWord())) {
                if (searchParam.getAreaLevel().intValue() == 1) {
                    item.setCurrentHeadAreaName(item.getProvinceName());
                } else if (searchParam.getAreaLevel().intValue() == 2) {
                    item.setCurrentHeadAreaName(item.getCityName());
                } else if (searchParam.getAreaLevel().intValue() == 3) {
                    item.setCurrentHeadAreaName(item.getAreaName());
                }
                item.setCurrentListAreaName(item.getAreaName());
                item.setCurrentListAreaId(item.getAreaId());
            } else if (searchParam.getIsCity().booleanValue()) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getCityName());
                item.setCurrentListAreaId(item.getCityId());
            } else if (searchParam.getIsCounty().booleanValue()) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getAreaName());
                item.setCurrentListAreaId(item.getAreaId());
            } else if (searchParam.getAreaLevel().intValue() == 1) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getCityName());
                item.setCurrentListAreaId(item.getCityId());
            } else if (searchParam.getAreaLevel().intValue() == 2) {
                item.setCurrentHeadAreaName(item.getCityName());
                item.setCurrentHeadAreaId(item.getCityId());
                if (searchParam.getIsCurrent() != null && searchParam.getIsCurrent().booleanValue()) {
                    item.setOnlyThisLevelArea(Boolean.valueOf(true));
                    item.setCurrentListAreaName(item.getStreetName());
                    item.setCurrentListAreaId(item.getStreetId());
                    item.setOnlyThisLevelAreaId(item.getStreetId());
                } else {
                    item.setCurrentListAreaName(item.getAreaName());
                    item.setCurrentListAreaId(item.getAreaId());
                }
            } else if (searchParam.getAreaLevel().intValue() == 3) {
                item.setCurrentHeadAreaName(item.getAreaName());
                item.setCurrentHeadAreaId(item.getAreaId());
                item.setCurrentListAreaName(item.getStreetName());
                item.setCurrentListAreaId(item.getStreetId());
            }
            String rate = item.getNoCheckRiskCompletedRate();
            if (StringUtils.isNotBlank((CharSequence)rate)) {
                double value = Double.parseDouble(rate);
                if (value > 15.0) {
                    item.setPercentage(Integer.valueOf(1));
                }
                item.setNoCheckRiskCompletedRate(rate + "%");
            }
            item.setIdx(i++);
        }
        return list;
    }

    private void setSupplementAreaInfo(Long parentId, Integer areaLevel, List<CompanyCheckRiskCompletion> list, RiskResolveResSearch searchParam) {
        List<Object> areaInfo = new ArrayList();
        Set<Object> collect = new HashSet();
        if (areaLevel == 1) {
            areaInfo = (List)this.redisClient.get("areaInfo", "city" + parentId, 14400L, () -> this.sysAreaProvideService.getCityList(parentId));
            collect = list.stream().filter(Objects::nonNull).map(CompanyCheckRiskCompletion::getCityId).collect(Collectors.toSet());
        } else if (areaLevel == 2) {
            areaInfo = (List)this.redisClient.get("areaInfo", "area" + parentId, 14400L, () -> this.sysAreaProvideService.getAreaList(parentId));
            collect = list.stream().filter(Objects::nonNull).map(CompanyCheckRiskCompletion::getAreaId).collect(Collectors.toSet());
        } else if (areaLevel == 3) {
            areaInfo = (List)this.redisClient.get("areaInfo", "street" + parentId, 14400L, () -> this.sysAreaProvideService.getStreetList(parentId));
            collect = list.stream().filter(Objects::nonNull).map(CompanyCheckRiskCompletion::getStreetId).collect(Collectors.toSet());
        } else if (areaLevel == 5) {
            areaInfo = (List)this.redisClient.get("areaInfo", "areaAll", 14400L, () -> this.sysAreaProvideService.getListByLevel(parentId, Byte.valueOf((byte)3), Byte.valueOf((byte)1)));
            collect = list.stream().filter(Objects::nonNull).map(CompanyCheckRiskCompletion::getAreaId).collect(Collectors.toSet());
        } else if (areaLevel == 6) {
            areaInfo = (List)this.redisClient.get("areaInfo", "areaAll", 14400L, () -> this.sysAreaProvideService.getListByLevel(parentId, Byte.valueOf((byte)3), Byte.valueOf((byte)1)));
            collect = list.stream().filter(Objects::nonNull).map(CompanyCheckRiskCompletion::getAreaId).collect(Collectors.toSet());
            areaInfo = areaInfo.stream().filter(item -> {
                if (item == null) {
                    return false;
                }
                if (item.getAreaName().contains(searchParam.getKeyWord())) {
                    if (searchParam.getAreaLevel().intValue() == 1 && searchParam.getAreaId().equals(item.getProvinceId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 2 && searchParam.getAreaId().equals(item.getCityId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 3 && searchParam.getAreaId().equals(item.getAreaId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 4 && searchParam.getAreaId().equals(item.getStreetId())) {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (areaInfo.size() == collect.size()) {
            return;
        }
        for (AreaModel model : areaInfo) {
            if (model == null) continue;
            Long area = null;
            if (areaLevel == 1) {
                area = model.getCityId();
            } else if (areaLevel == 2 || areaLevel == 5 || areaLevel == 6) {
                area = model.getAreaId();
            } else if (areaLevel == 3) {
                area = model.getStreetId();
            }
            if (collect.contains(area)) continue;
            CompanyCheckRiskCompletion temp = new CompanyCheckRiskCompletion().setProvinceId(model.getProvinceId()).setProvinceName(model.getProvinceName()).setCityId(model.getCityId()).setCityName(model.getCityName()).setAreaId(model.getAreaId()).setAreaName(model.getAreaName()).setStreetId(model.getStreetId()).setStreetName(model.getStreetName()).setKeyFactoryNum(Integer.valueOf(0)).setCheckRiskCompletedNum(Integer.valueOf(0)).setNoCheckRiskCompletedNum(Integer.valueOf(0)).setNoCheckRiskCompletedRate("0.00");
            list.add(temp);
        }
    }

    public PageInfo<CompanyCheckRiskCompletion> checkRiskCompletedListPageData(JqGridParam jqGridParam, RiskResolveResSearch searchParam) {
        List<CompanyCheckRiskCompletion> list = this.checkRiskCompletedListData(searchParam);
        return PageUtil.getPageInfo(list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
    }

    public KeyFactoryScoreInfo countCompanyRiskCompletionNumByType(CompanyRiskCompletion searchModel) {
        KeyFactoryScoreInfo keyFactoryScoreInfo = new KeyFactoryScoreInfo();
        int completeNum = ((CompanyRiskCompletionMapper)this.dao).countCompanyRiskCompletionNumByType(searchModel, 1);
        int unCompleteNum = ((CompanyRiskCompletionMapper)this.dao).countCompanyRiskCompletionNumByType(searchModel, 0);
        keyFactoryScoreInfo.setFinishDefuseCompanyNum(Integer.valueOf(unCompleteNum));
        keyFactoryScoreInfo.setFinishDefuseCompanyRate(String.valueOf(NumberUtil.rateDouble((int)(unCompleteNum * 100), (int)(completeNum + unCompleteNum), (int)2)));
        keyFactoryScoreInfo.setFinishKeyFactoryCompanyNum(Integer.valueOf(completeNum));
        keyFactoryScoreInfo.setFinishKeyFactoryCompanyRate(String.valueOf(NumberUtil.rateDouble((int)(completeNum * 100), (int)(completeNum + unCompleteNum), (int)2)));
        return keyFactoryScoreInfo;
    }

    public ComRiskCompletionStatisticsVo getComRiskCompletionStatisticsVo(CompanyRiskCompletion searchModel) {
        ComRiskCompletionStatisticsVo vo = ((CompanyRiskCompletionMapper)this.dao).getComRiskCompletionStatisticsVo(searchModel);
        if (vo == null) {
            return null;
        }
        vo.setDeclareRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getDeclareCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setPhysicalRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getPhysicalCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setCheckRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getCheckCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setTrainingRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getTrainingCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setThreeRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getThreeCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setWarnRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getWarnCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setProtectRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getProtectCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setHealthRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getHealthCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        return vo;
    }
}

