/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.reform.ComRiskCompleteWsMapper;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.ComRiskCompleteWsParam;
import cn.smarthse.modules.health.entity.work.reform.vo.ComRiskCompleteWsAll;
import cn.smarthse.modules.health.entity.work.reform.vo.ComRiskCompleteWsVo;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskCompletion;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskWarnStatus;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.reform.IComRiskCompleteWsService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class ComRiskCompleteWsServiceImpl
extends BaseServiceImpl<ComRiskCompleteWsMapper, CompanyRiskCompletion>
implements IComRiskCompleteWsService {
    @Transactional
    public void generateComRiskCompleteWs(List<Long> cidList) {
        ((ComRiskCompleteWsMapper)this.dao).deleteComRiskCompleteWs(cidList);
        List<CompanyRiskWarnStatus> tabooList = ((ComRiskCompleteWsMapper)this.dao).getDetailCompanyRiskWarnStatusList(cidList);
        List<Long> filterIdList = tabooList.stream().filter(Objects::nonNull).map(CompanyRiskWarnStatus::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tabooList)) {
            Map jccbCollect = ((ComRiskCompleteWsMapper)this.dao).getReformWarnList(ReformGenerationSourceEnum.JCCB.getValue(), filterIdList).stream().filter(item -> item != null && item.getLawStatus() != null).collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.mapping(Function.identity(), Collectors.toList())));
            Map jjzCollect = ((ComRiskCompleteWsMapper)this.dao).getReformWarnList(ReformGenerationSourceEnum.JJZ.getValue(), filterIdList).stream().filter(item -> item != null && item.getLawStatus() != null).collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.mapping(Function.identity(), Collectors.toList())));
            Map yszybCollect = ((ComRiskCompleteWsMapper)this.dao).getReformWarnList(ReformGenerationSourceEnum.YSZYB.getValue(), filterIdList).stream().filter(item -> item != null && item.getLawStatus() != null).collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.mapping(Function.identity(), Collectors.toList())));
            Map grjlcbCollect = ((ComRiskCompleteWsMapper)this.dao).getReformWarnList(ReformGenerationSourceEnum.GRJLCB.getValue(), filterIdList).stream().filter(item -> item != null && item.getLawStatus() != null).collect(Collectors.groupingBy(ReformItemBasic::getCid, Collectors.mapping(Function.identity(), Collectors.toList())));
            for (CompanyRiskWarnStatus riskWarnStatus : tabooList) {
                Long cid = riskWarnStatus.getId();
                String jccbWsAllStr = ((List)Optional.ofNullable(jccbCollect.get(cid)).orElse(new ArrayList())).stream().limit(10L).map(item -> item.getLawStatus() + item.getName()).collect(Collectors.joining("\u2051"));
                riskWarnStatus.setJccbWsAll(jccbWsAllStr);
                String jjzWsAllStr = ((List)Optional.ofNullable(jjzCollect.get(cid)).orElse(new ArrayList())).stream().limit(10L).map(item -> item.getLawStatus() + item.getName()).collect(Collectors.joining("\u2051"));
                riskWarnStatus.setJjzWsAll(jjzWsAllStr);
                String yszybWsAllStr = ((List)Optional.ofNullable(yszybCollect.get(cid)).orElse(new ArrayList())).stream().limit(10L).map(item -> item.getLawStatus() + item.getName()).collect(Collectors.joining("\u2051"));
                riskWarnStatus.setYszybWsAll(yszybWsAllStr);
                String grjlcbWsAllStr = ((List)Optional.ofNullable(grjlcbCollect.get(cid)).orElse(new ArrayList())).stream().limit(10L).map(item -> item.getLawStatus() + item.getName()).collect(Collectors.joining("\u2051"));
                riskWarnStatus.setPersonDoseCbWsAll(grjlcbWsAllStr);
            }
            ((ComRiskCompleteWsMapper)this.dao).insertComRiskCompleteWs(tabooList);
        }
        ((ComRiskCompleteWsMapper)this.dao).generateComRiskCompleteWs(cidList, filterIdList);
    }

    public PageInfo<ComRiskCompleteWsVo> getPageComRiskCompleteWsVoBySearchModel(JqGridParam jqGridParam, ComRiskCompleteWsParam searchModel) {
        this.setComRiskCompleteWsParam(searchModel);
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<ComRiskCompleteWsAll> list = ((ComRiskCompleteWsMapper)this.dao).getComRiskCompleteWsVoBySearchModel(searchModel);
        PageInfo pageInfo = new PageInfo(list);
        PageInfo pageInfoVo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoVo);
        pageInfoVo.setList(ComRiskCompleteWsVo.convertComRiskCompleteWsVoList(list, (Boolean)searchModel.getIsExport()));
        return pageInfoVo;
    }

    public List<ComRiskCompleteWsVo> getComRiskCompleteWsVoBySearchModel(ComRiskCompleteWsParam searchModel) {
        this.setComRiskCompleteWsParam(searchModel);
        List<ComRiskCompleteWsAll> list = ((ComRiskCompleteWsMapper)this.dao).getComRiskCompleteWsVoBySearchModel(searchModel);
        return ComRiskCompleteWsVo.convertComRiskCompleteWsVoList(list, (Boolean)searchModel.getIsExport());
    }

    public Integer getComRiskCompleteWsVoBySearchModelCount(ComRiskCompleteWsParam searchModel) {
        this.setComRiskCompleteWsParam(searchModel);
        return ((ComRiskCompleteWsMapper)this.dao).getComRiskCompleteWsVoBySearchModelCount(searchModel);
    }

    public ComRiskCompleteWsVo getComRiskCompleteWsNum(SearchParam searchVo) {
        return ((ComRiskCompleteWsMapper)this.dao).getComRiskCompleteWsNum(searchVo);
    }

    private void setComRiskCompleteWsParam(ComRiskCompleteWsParam searchModel) {
        if (searchModel.getIsPatrol() != null) {
            List<Long> patrolList = ((ComRiskCompleteWsMapper)this.dao).getPatrolList(searchModel);
            if (CollectionUtils.isEmpty(patrolList)) {
                patrolList.add(-1L);
            }
            searchModel.setPatrolList(patrolList);
        }
        if (StringUtils.isNotBlank((CharSequence)searchModel.getScales())) {
            searchModel.setScaleList(StringUtils.parseToIntegerList((String)searchModel.getScales(), (String)","));
        }
        ComRiskCompleteWsParam.setGenerationSource((ComRiskCompleteWsParam)searchModel);
    }
}

