/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearExpendServiceImpl;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearExpendService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.service.work.planyear.ISendPlanYearMessageTipService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

@Lazy(value=false)
@DubboService
@Transactional(readOnly=true)
public class SendPlanYearMessageTipServiceImpl
implements ISendPlanYearMessageTipService {
    private static Logger logger = LoggerFactory.getLogger(PlanYearExpendServiceImpl.class);
    @Autowired
    private IPlanYearDetailService planYearDetailService;
    @Autowired
    IPlanYearService planYearService;
    @Autowired
    IMessageService messageService;
    @Autowired
    private IPlanYearExpendService planYearExpendService;

    @Scheduled(cron="0 0 0 * * ?")
    @Transactional(readOnly=false)
    public void sendMessage() {
        logger.info("\u6d88\u606f\u53d1\u9001---\u300b" + String.valueOf(new Date()));
        List list = this.planYearDetailService.getWillExpirePlanList();
        if (list != null && list.size() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (PlanYearDetail detail : list) {
                Message mes = new Message();
                mes.setBussinesId(detail.getId());
                mes.setBussinesType(MessageBusinessTypeEnum.remind.getValue());
                mes.setTypeName(MessageBusinessTypeEnum.remind.getName());
                mes.setBussinesName(detail.getPlanWorkName());
                mes.setBussinesFromType(MessageBusinessFromEnum.workPlan.getValue());
                mes.setBussinesFrom(MessageBusinessFromEnum.workPlan.getName());
                mes.setSendTime(new Date());
                String content = detail.getPlanWorkName() + "\u5373\u5c06\u5f00\u59cb\uff0c\u539f\u5b9a\u8ba1\u5212\u5b9e\u65bd\u65e5\u671f\u4e3a" + dateFormat.format(detail.getPlanImplDate()) + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                mes.setBussinessContent(content);
                ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
                PlanYearDetail pyd = this.planYearDetailService.getPlanYearDetailById(detail.getId());
                if (pyd.getDecomposeStatus() == 1 && pyd.getManagerId() != null) {
                    MessageReceiver receiver = new MessageReceiver();
                    receiver.setReveiver(detail.getManagerId());
                    receivers.add(receiver);
                } else if (pyd.getExecutorList() != null && pyd.getExecutorList().size() > 0) {
                    for (Long eId : pyd.getExecutorList()) {
                        MessageReceiver receiver = new MessageReceiver();
                        receiver.setReveiver(eId);
                        receivers.add(receiver);
                    }
                }
                mes.setReceivers(receivers);
                this.messageService.pushMessage(mes, detail.getCreateBy(), detail.getCid());
            }
        }
    }
}

