/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.planyear.PreventionExpendMapper;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.entity.work.planyear.PreventionExpend;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanExpendStaticVo;
import cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearUploadFileServiceImpl;
import cn.smarthse.modules.health.service.work.planyear.IPreventionExpendService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PreventionExpendServiceImpl
extends BaseServiceImpl<PreventionExpendMapper, PreventionExpend>
implements IPreventionExpendService {
    @Autowired
    PreventionExpendMapper preventionExpendMapper;
    @Autowired
    PlanYearUploadFileServiceImpl planYearUploadFileServiceImpl;

    public PageInfo<PreventionExpend> getListPageByParam(JqGridParam gparam, PreventionExpend param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "prevention_expend");
        if (param.getCid() == null) {
            return new PageInfo();
        }
        Example example = new Example(PreventionExpend.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)param.getCid()).andEqualTo("expendType", (Object)param.getExpendType()).andEqualTo("isFinish", (Object)param.getIsFinish()).andEqualTo("manageDept", (Object)param.getManageDept()).andEqualTo("isValid", (Object)Global.TRUE);
        if (param.getManagerName() != null) {
            c.andLike("managerName", "%" + param.getManagerName() + "%");
        }
        example.setOrderByClause("update_date desc");
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public PreventionExpend addWithFile(PreventionExpend info, Long cid, Long staffid, Long[] fileIds) {
        info = this.add(info, staffid, cid);
        if (fileIds != null) {
            for (int i = 0; i < fileIds.length; ++i) {
                PlanYearUploadFile planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(info.getId());
                planYearUploadFile.setFileId(fileIds[i]);
                planYearUploadFile.setFileType(Byte.valueOf((byte)5));
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        return info;
    }

    @Transactional(readOnly=false)
    public PreventionExpend updateWithFile(PreventionExpend info, Long cid, Long staffid, Long[] fileIds) {
        this.update(info, staffid);
        List<PlanYearUploadFile> list = this.planYearUploadFileServiceImpl.getByPlanYearId(info.getId(), (byte)5);
        for (PlanYearUploadFile planYearUploadFile : list) {
            this.planYearUploadFileServiceImpl.delete(planYearUploadFile, staffid);
        }
        if (fileIds != null) {
            for (int i = 0; i < fileIds.length; ++i) {
                PlanYearUploadFile planYearUploadFile;
                planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(info.getId());
                planYearUploadFile.setFileId(fileIds[i]);
                planYearUploadFile.setFileType(Byte.valueOf((byte)5));
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        return info;
    }

    public PageInfo<PreventionExpend> getListPage(JqGridParam gparam, PreventionExpend param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (param.getCid() == null) {
            return new PageInfo();
        }
        DataScopeHelper.startDataScope("yearPlan", "prevention_expend");
        List<PreventionExpend> list = ((PreventionExpendMapper)this.dao).getListByParam(param);
        return new PageInfo(list);
    }

    public Map<PlanYearExpendTypeEnum, PlanExpendStaticVo> getPlanExpendStaticVoByOrgAndYear(Long orgId, Integer year) {
        HashMap<PlanYearExpendTypeEnum, PlanExpendStaticVo> staticMap = new HashMap<PlanYearExpendTypeEnum, PlanExpendStaticVo>();
        for (PlanYearExpendTypeEnum c : PlanYearExpendTypeEnum.values()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("year", year);
            params.put("orgId", orgId);
            params.put("type", c.getValue());
            PlanExpendStaticVo staticvo = ((PreventionExpendMapper)this.dao).getStaticVoByOrg(params);
            if (staticvo == null) {
                staticvo = new PlanExpendStaticVo();
            }
            staticvo.setTypeName(c.getName());
            if (staticvo.getType() == null) {
                staticvo.setType(Byte.valueOf(c.getValue().byteValue()));
            }
            if (staticvo.getActualMoney() == null) {
                staticvo.setActualMoney(new BigDecimal(0));
            }
            if (staticvo.getBudgetMoney() == null) {
                staticvo.setBudgetMoney(new BigDecimal(0));
            }
            staticMap.put(c, staticvo);
        }
        return staticMap;
    }
}

