/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearUploadFileMapper;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearUploadFileService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PlanYearUploadFileServiceImpl
extends BaseServiceImpl<PlanYearUploadFileMapper, PlanYearUploadFile>
implements IPlanYearUploadFileService {
    @Autowired
    PlanYearUploadFileMapper planYearUploadFileMapper;

    public List<PlanYearUploadFile> getByPlanYearId(Long id, Byte type) {
        Example example = new Example(PlanYearUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)id).andEqualTo("fileType", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<PlanYearUploadFile> list = this.getListByExample(example);
        return list;
    }

    @Transactional(readOnly=true)
    public void updatePlanYearUploadFilesByPlanId(Long planId, Long[] attachmentArr, Byte type, Long cid, Long loginStaffId) {
        if (planId == null) {
            return;
        }
        Example example = new Example(PlanYearUploadFile.class);
        example.createCriteria().andEqualTo("planYearId", (Object)planId).andEqualTo("fileType", (Object)type);
        PlanYearUploadFile file = new PlanYearUploadFile();
        file.setPlanYearId(planId);
        ((PlanYearUploadFileMapper)this.dao).deleteByExample(example);
        if (attachmentArr != null && attachmentArr.length > 0) {
            for (Long fileId : attachmentArr) {
                PlanYearUploadFile pfile = new PlanYearUploadFile();
                pfile.setPlanYearId(planId);
                pfile.setFileType(type);
                pfile.setFileId(fileId);
                this.add(pfile, loginStaffId, cid);
            }
        }
    }
}

