/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearMapper;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkExecutorOrgRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearDetailServiceImpl;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearExpendServiceImpl;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearUploadFileServiceImpl;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkExecutorOrgRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.vo.work.yearplan.PlanYearWorkItemVO;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PlanYearServiceImpl
extends BaseServiceImpl<PlanYearMapper, PlanYear>
implements IPlanYearService {
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    PlanYearUploadFileServiceImpl planYearUploadFileServiceImpl;
    @Autowired
    PlanYearDetailServiceImpl planYearDetailServiceImpl;
    @Autowired
    PlanYearExpendServiceImpl planYearExpendServiceImpl;
    @Autowired
    IPlanWorkExecutorOrgRecordService planWorkExecutorOrgRecordService;
    @Autowired
    PlanYearMapper planYearMapper;
    @Autowired
    IStaffInfoService staffInfoService;

    public PageInfo<PlanYear> getPlanYearListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null || gparam.getStage() == null) {
            return new PageInfo();
        }
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("stage", (Object)gparam.getStage()).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("workPlanType", (Object)1);
        example.setOrderByClause("id desc");
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List list = this.getListByExample(example);
        for (PlanYear py : list) {
            PlanYear db = this.getPlanYearById(py.getId());
            py.setUpdateTimeStr(db.getUpdateTimeStr());
            py.setCreatorName(db.getCreatorName());
            py.setUpdaterName(db.getUpdaterName());
            py.setCreateTimeStr(db.getCreateTimeStr());
            py.setPlanCompleteTimeStr(db.getPlanCompleteTimeStr());
            py.setSummaryCompleteTimeStr(db.getSummaryCompleteTimeStr());
        }
        return new PageInfo(list);
    }

    public PageInfo<PlanYear> getPlanCompleteListByCid(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null) {
            return new PageInfo(new ArrayList());
        }
        ArrayList<Integer> i = new ArrayList<Integer>();
        i.add(2);
        i.add(3);
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andIn("stage", i).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id desc");
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<PlanYear> getSummaryCompleteListByCid(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null) {
            return new PageInfo(new ArrayList());
        }
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("stage", (Object)3).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id desc");
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public String addPlanYear(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, String details, String expends) {
        planYear = this.add(planYear, staffid, cid);
        if (fileId2 != null) {
            for (int i = 0; i < fileId2.length; ++i) {
                PlanYearUploadFile planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(planYear.getId());
                planYearUploadFile.setFileId(fileId2[i]);
                planYearUploadFile.setFileType(Byte.valueOf((byte)1));
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        if (details != null && !details.trim().isEmpty()) {
            details = StringEscapeUtils.unescapeHtml((String)details);
            List detailsList = JSONObject.parseArray((String)details, PlanYearDetail.class);
            for (PlanYearDetail planYearDetail : detailsList) {
                planYearDetail.setPlanYearId(planYear.getId());
                this.planYearDetailServiceImpl.update(planYearDetail, staffid);
            }
        }
        if (expends != null && !expends.trim().isEmpty()) {
            expends = StringEscapeUtils.unescapeHtml((String)expends);
            List expendsList = JSONObject.parseArray((String)expends, PlanYearExpend.class);
            for (PlanYearExpend planYearExpend : expendsList) {
                planYearExpend.setPlanYearId(planYear.getId());
                this.planYearExpendServiceImpl.update(planYearExpend, staffid);
            }
        }
        return planYear.getId().toString();
    }

    @Transactional(readOnly=false)
    public String updatePlanYear(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType) {
        this.update(planYear, staffid);
        List<PlanYearUploadFile> list = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), fileType);
        for (PlanYearUploadFile planYearUploadFile : list) {
            this.planYearUploadFileServiceImpl.delete(planYearUploadFile, staffid);
        }
        if (fileId2 != null) {
            for (int i = 0; i < fileId2.length; ++i) {
                PlanYearUploadFile planYearUploadFile;
                planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(planYear.getId());
                planYearUploadFile.setFileId(fileId2[i]);
                planYearUploadFile.setFileType(fileType);
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        if (planYear.getDetailId_status() != null && planYear.getDetailId_status().length > 0) {
            for (String str : planYear.getDetailId_status()) {
                PlanYearDetail detail = new PlanYearDetail();
                detail.setId(Long.valueOf(str.split(":")[0]));
                detail.setImplResult(Byte.valueOf(str.split(":")[1]));
                this.planYearDetailServiceImpl.update(detail, staffid);
            }
        }
        return planYear.getId().toString();
    }

    @Transactional(readOnly=false)
    public PlanYear addPlanDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2) {
        PlanYearDetail detail = planYear.getDetail();
        planYear = this.add(planYear, staffid, cid);
        if (fileId2 != null) {
            for (int i = 0; i < fileId2.length; ++i) {
                PlanYearUploadFile planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(planYear.getId());
                planYearUploadFile.setFileId(fileId2[i]);
                planYearUploadFile.setFileType(Byte.valueOf((byte)1));
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        detail.setPlanYearId(planYear.getId());
        this.planYearDetailServiceImpl.addPlanWorkDetailSubmit(detail, staffid, cid);
        planYear.setDetail(detail);
        return planYear;
    }

    @Transactional(readOnly=false)
    public PlanYear updatePlanDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType) {
        PlanYearDetail detail = planYear.getDetail();
        this.update(planYear, staffid);
        List<PlanYearUploadFile> list = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), fileType);
        for (PlanYearUploadFile planYearUploadFile : list) {
            this.planYearUploadFileServiceImpl.delete(planYearUploadFile, staffid);
        }
        if (fileId2 != null) {
            for (int i = 0; i < fileId2.length; ++i) {
                PlanYearUploadFile planYearUploadFile;
                planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(planYear.getId());
                planYearUploadFile.setFileId(fileId2[i]);
                planYearUploadFile.setFileType(fileType);
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        detail.setPlanYearId(planYear.getId());
        detail.setCid(cid);
        this.planYearDetailServiceImpl.updatePlanWorkDetailSubmit(detail, staffid);
        planYear.setDetail(detail);
        return planYear;
    }

    @Transactional(readOnly=false)
    public PlanYear updateSummDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType) {
        PlanYearDetail detail = planYear.getDetail();
        this.update(planYear, staffid);
        List<PlanYearUploadFile> list = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), fileType);
        for (PlanYearUploadFile planYearUploadFile : list) {
            this.planYearUploadFileServiceImpl.delete(planYearUploadFile, staffid);
        }
        if (fileId2 != null) {
            for (int i = 0; i < fileId2.length; ++i) {
                PlanYearUploadFile planYearUploadFile;
                planYearUploadFile = new PlanYearUploadFile();
                planYearUploadFile.setPlanYearId(planYear.getId());
                planYearUploadFile.setFileId(fileId2[i]);
                planYearUploadFile.setFileType(fileType);
                this.planYearUploadFileServiceImpl.add(planYearUploadFile, staffid, cid);
            }
        }
        detail.setPlanYearId(planYear.getId());
        detail.setCid(cid);
        this.planYearDetailServiceImpl.update(detail, staffid);
        planYear.setDetail(detail);
        return planYear;
    }

    public PlanYearWorkItemVO getWorkByCid(Long cid, Long loginStaffId) {
        PlanYearWorkItemVO workItem = new PlanYearWorkItemVO();
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        DataScope dataScope = DataScopeHelper.getDataScope();
        workItem.setYearPlanCount1(Integer.valueOf(this.getPlanYearCountByCidAndTypeAndStage(cid, (byte)1, (byte)1)));
        DataScopeHelper.setDataScope(dataScope);
        workItem.setYearPlanCount2(Integer.valueOf(this.getPlanYearCountByCidAndTypeAndStage(cid, (byte)1, (byte)2)));
        DataScopeHelper.setDataScope(dataScope);
        workItem.setDailyPlanCount1(Integer.valueOf(this.getPlanYearCountByCidAndTypeAndStage(cid, (byte)2, (byte)1)));
        DataScopeHelper.setDataScope(dataScope);
        workItem.setDailyPlanCount2(Integer.valueOf(this.getPlanYearCountByCidAndTypeAndStage(cid, (byte)2, (byte)2)));
        DataScopeHelper.setDataScope(dataScope);
        workItem.setTotalPlanCount(Integer.valueOf(this.getPlanYearCountByCid(cid)));
        dataScope.setMainTableName("decompose_plan_v");
        DataScopeHelper.setDataScope(dataScope);
        workItem.setDecomposePlanCount1(Integer.valueOf(this.planYearDetailServiceImpl.getNeedDecomposePlanCountByStageAndCid((byte)1, cid)));
        DataScopeHelper.setDataScope(dataScope);
        dataScope.setMainTableName("decompose_plan_v");
        workItem.setDecomposePlanCount2(Integer.valueOf(this.planYearDetailServiceImpl.getNeedDecomposePlanCountByStageAndCid((byte)2, cid)));
        dataScope.setMainTableName("plan_year");
        DataScopeHelper.setDataScope(dataScope);
        workItem.setDecomposeExpendCount(Integer.valueOf(this.planYearExpendServiceImpl.getNeedDecomposePlanExpendCountByStageAndCid((byte)1, cid)));
        Boolean isIgnoreOneYear = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.yearPlan_oneYear, cid, 1);
        if (!isIgnoreOneYear.booleanValue()) {
            Integer oneYearCompletedCount = this.planYearDetailServiceImpl.getYearCountOverOneYearCompletedPlanByCid(cid);
            if (oneYearCompletedCount != null && oneYearCompletedCount >= 1) {
                workItem.setExceed(Global.TRUE.booleanValue());
            } else {
                workItem.setExceed(Global.FALSE.booleanValue());
            }
        } else {
            workItem.setExceed(Global.FALSE.booleanValue());
        }
        List completedWork = this.sysCoreWorkModuleCorrelationService.getCompletedWorkListToRemind(cid, loginStaffId);
        workItem.setCompletedWork(completedWork);
        return workItem;
    }

    public int countPlanYearCountByCidAndStage(Long cid, Byte stage) {
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)stage).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getCountByExample(example);
    }

    public List<PlanYear> exportPlanCompleteList(Long cid) {
        ArrayList<Integer> i = new ArrayList<Integer>();
        i.add(2);
        i.add(3);
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andIn("stage", i).andEqualTo("isValid", (Object)Global.TRUE);
        List<PlanYear> list = this.getListByExample(example);
        return list;
    }

    public List<PlanYear> exportSummaryCompleteList(Long cid) {
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)3).andEqualTo("isValid", (Object)Global.TRUE);
        List<PlanYear> list = this.getListByExample(example);
        return list;
    }

    public Boolean planYearNullifyById(Long id) {
        if (id != null) {
            PlanYear planYear = new PlanYear();
            planYear.setId(id);
            this.update(planYear);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public PlanYear addIsNotValidPlanYear(Long cid, Long loginStaffId, Long orgId) {
        PlanYear py = new PlanYear();
        py.setIsValid(Global.FALSE);
        py.setCid(cid);
        py.setCreateBy(loginStaffId);
        py.setCreateDate(new Date());
        py.setUpdateBy(loginStaffId);
        py.setUpdateDate(new Date());
        py.setStage(Byte.valueOf((byte)1));
        py.setId(Long.valueOf(this.idworker.nextId()));
        ((PlanYearMapper)this.dao).insertSelective(py);
        return py;
    }

    @Transactional(readOnly=false)
    public Integer updatePlanYearSubmitById(PlanYear year, Long cid, Long loginStaffId) {
        int row = 0;
        if (year != null && year.getId() != null) {
            this.update(year, loginStaffId);
            row = 1;
            if (year.getPlanAttachmentArr() != null && year.getPlanAttachmentArr().length > 0) {
                this.planYearUploadFileServiceImpl.updatePlanYearUploadFilesByPlanId(year.getId(), year.getPlanAttachmentArr(), (byte)1, cid, loginStaffId);
            }
            if (year.getSummaryAttachmentArr() != null && year.getSummaryAttachmentArr().length > 0) {
                this.planYearUploadFileServiceImpl.updatePlanYearUploadFilesByPlanId(year.getId(), year.getSummaryAttachmentArr(), (byte)2, cid, loginStaffId);
            }
        }
        return row;
    }

    @Transactional(readOnly=false)
    public void createDecomposePlanYearByParentIdAndType(Long planPid, Long detOrExPid, Byte source, Byte type, Long cid, Long loginStaffId) {
        List executors = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(planPid, detOrExPid, type);
        this.planYearDetailServiceImpl.deleteChildrenByDetailPid(detOrExPid, loginStaffId);
        for (PlanWorkExecutorOrgRecord pwe : executors) {
            PlanYear decomposePlanYear = new PlanYear();
            decomposePlanYear.setParentPlanId(planPid);
            decomposePlanYear.setWorkPlanType(Byte.valueOf((byte)3));
            decomposePlanYear.setStage(Byte.valueOf((byte)1));
            decomposePlanYear.setWorkPlanSource(source);
            decomposePlanYear.setOrgId("" + pwe.getOrgId());
            decomposePlanYear.setCreateBy(pwe.getExecutor());
            decomposePlanYear.setCid(cid);
            decomposePlanYear.setIsValid(Boolean.valueOf(true));
            decomposePlanYear.setUpdateBy(pwe.getExecutor());
            decomposePlanYear.setCreateDate(new Date());
            decomposePlanYear.setUpdateDate(new Date());
            this.add(decomposePlanYear);
            if (type == null) continue;
            if (type == 1) {
                PlanYearDetail detail = new PlanYearDetail();
                detail.setDecomposeStatus(Byte.valueOf((byte)1));
                detail.setDetailPid(detOrExPid);
                detail.setPlanYearId(decomposePlanYear.getId());
                detail.setManagerId(pwe.getExecutor());
                detail.setOrgId(pwe.getOrgId());
                detail.setCreateBy(pwe.getExecutor());
                detail.setCid(cid);
                detail.setIsValid(Boolean.valueOf(true));
                detail.setUpdateBy(pwe.getExecutor());
                detail.setCreateDate(new Date());
                detail.setUpdateDate(new Date());
                this.planYearDetailServiceImpl.add(detail);
            }
            if (type != 2) continue;
            PlanYearExpend expend = new PlanYearExpend();
            expend.setDecomposeStatus(Byte.valueOf((byte)1));
            expend.setExpendPid(detOrExPid);
            expend.setPlanYearId(decomposePlanYear.getId());
            expend.setManagerId(pwe.getExecutor());
            expend.setOrgId(pwe.getOrgId());
            expend.setCreateBy(pwe.getExecutor());
            expend.setCid(cid);
            expend.setIsValid(Boolean.valueOf(true));
            expend.setUpdateBy(pwe.getExecutor());
            expend.setCreateDate(new Date());
            expend.setUpdateDate(new Date());
            this.planYearExpendServiceImpl.add(expend);
        }
    }

    @Transactional(readOnly=false)
    public PlanYear getDecomposePlanYearByParentIdAndType(Long parentId, Byte source) {
        Example example = new Example(PlanYear.class);
        example.createCriteria().andEqualTo("parentPlanId", (Object)parentId).andEqualTo("workPlanSource", (Object)source).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return (PlanYear)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void deleteEveryYearPlanSubmitById(Long id, Long loginStaffId) {
        if (id == null) {
            return;
        }
        PlanYear py = new PlanYear();
        py.setId(id);
        this.delete(py, loginStaffId);
        this.planYearDetailServiceImpl.deletePlanDetailSubmitByPlanId(id, loginStaffId);
        this.planYearExpendServiceImpl.deletePlanExpendSubmitByPlanId(id, loginStaffId);
    }

    public PlanYear getPlanYearById(Long id) {
        PlanYear year = (PlanYear)this.getById(id);
        if (year != null) {
            List<PlanYearUploadFile> summaryfiles;
            List<PlanYearUploadFile> planfiles;
            year.setCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(year.getCreateBy()));
            year.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(year.getUpdateBy()));
            if (year.getCreateDate() != null) {
                year.setCreateTimeStr(year.getCreateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (year.getUpdateDate() != null) {
                year.setUpdateTimeStr(year.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (year.getPlanCompleteTime() != null) {
                year.setPlanCompleteTimeStr(year.getPlanCompleteTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (year.getSummaryCompleteTime() != null) {
                year.setSummaryCompleteTimeStr(year.getSummaryCompleteTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (year.getWorkPlanSource() != null) {
                if (year.getWorkPlanSource() == 1) {
                    year.setWorkPlanSourceName("\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212");
                } else if (year.getWorkPlanSource() == 2) {
                    year.setWorkPlanSourceName("\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212");
                } else if (year.getWorkPlanSource() == 3) {
                    year.setWorkPlanSourceName("\u5f85\u5206\u89e3\u8ba1\u5212");
                }
            } else if (year.getWorkPlanType() == 1) {
                year.setWorkPlanSourceName("\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212");
            } else if (year.getWorkPlanType() == 2) {
                year.setWorkPlanSourceName("\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212");
            }
            if (year.getWorkPlanType() != null) {
                if (year.getWorkPlanType() == 1) {
                    year.setWorkPlanTypeName("\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212");
                } else if (year.getWorkPlanType() == 2) {
                    year.setWorkPlanTypeName("\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212");
                } else if (year.getWorkPlanType() == 3) {
                    year.setWorkPlanTypeName("\u5f85\u5206\u89e3\u8ba1\u5212");
                }
            }
            if ((planfiles = this.planYearUploadFileServiceImpl.getByPlanYearId(id, (byte)1)) != null && planfiles.size() > 0) {
                Long[] planAttachmentArr = new Long[planfiles.size()];
                Object planAttachmentStr = "";
                for (int i = 0; i < planfiles.size(); ++i) {
                    Long fileId = planfiles.get(i).getFileId();
                    if (fileId == null) continue;
                    planAttachmentArr[i] = fileId;
                    planAttachmentStr = (String)planAttachmentStr + fileId + ",";
                }
                year.setPlanAttachmentArr(planAttachmentArr);
                year.setPlanAttachmentStr((String)planAttachmentStr);
            }
            if ((summaryfiles = this.planYearUploadFileServiceImpl.getByPlanYearId(id, (byte)2)) != null && summaryfiles.size() > 0) {
                Long[] summaryAttachmentArr = new Long[summaryfiles.size()];
                Object summaryAttachmentStr = "";
                for (int i = 0; i < summaryfiles.size(); ++i) {
                    Long fileId = summaryfiles.get(i).getFileId();
                    if (fileId == null) continue;
                    summaryAttachmentArr[i] = fileId;
                    summaryAttachmentStr = (String)summaryAttachmentStr + fileId + ",";
                }
                year.setSummaryAttachmentArr(summaryAttachmentArr);
                year.setSummaryAttachmentStr((String)summaryAttachmentStr);
            }
        }
        return year;
    }

    private int getPlanYearCountByCidAndTypeAndStage(Long cid, Byte type, Byte stage) {
        if (cid == null || type == null || stage == null) {
            return 0;
        }
        Example e1 = new Example(PlanYear.class);
        e1.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("stage", (Object)stage).andEqualTo("workPlanType", (Object)type);
        return ((PlanYearMapper)this.dao).selectCountByExample(e1);
    }

    private int getPlanYearCountByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        Example e1 = new Example(PlanYear.class);
        e1.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return ((PlanYearMapper)this.dao).selectCountByExample(e1);
    }

    public PageInfo<PlanYear> getPlanYearPlanCompletedListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null) {
            return new PageInfo();
        }
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        ArrayList<Byte> stages = new ArrayList<Byte>();
        stages.add((byte)2);
        stages.add((byte)3);
        c.andEqualTo("cid", (Object)gparam.getCid()).andIn("stage", stages).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("workPlanType", (Object)1);
        example.setOrderByClause("id desc");
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List list = this.getListByExample(example);
        for (PlanYear py : list) {
            PlanYear db = this.getPlanYearById(py.getId());
            py.setUpdateTimeStr(db.getUpdateTimeStr());
            py.setCreatorName(db.getCreatorName());
            py.setUpdaterName(db.getUpdaterName());
            py.setCreateTimeStr(db.getCreateTimeStr());
            py.setPlanCompleteTimeStr(db.getPlanCompleteTimeStr());
            py.setSummaryCompleteTimeStr(db.getSummaryCompleteTimeStr());
        }
        return new PageInfo(list);
    }
}

