/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearExpendMapper;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkExecutorOrgRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanExpendStaticVo;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;
import cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkExecutorOrgRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkTransferRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearExpendService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.service.work.planyear.IPreventionExpendService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PlanYearExpendServiceImpl
extends BaseServiceImpl<PlanYearExpendMapper, PlanYearExpend>
implements IPlanYearExpendService {
    @Autowired
    IPlanYearService planYearServiceImpl;
    @Autowired
    IStaffInfoService staffInfoServiceImpl;
    @Autowired
    PlanYearExpendMapper planYearExpendMapper;
    @Autowired
    PlanYearMapper planYearMapper;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    IPlanWorkExecutorOrgRecordService planWorkExecutorOrgRecordService;
    @Autowired
    IPlanWorkTransferRecordService planWorkTransferRecordService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IPlanYearService planYearService;
    @Autowired
    IPreventionExpendService preventionExpendService;

    public List<PlanYearExpend> getPlanYearExpendListByGridParam(JqGridParam gparam) {
        if (gparam.getId() == null) {
            return new ArrayList<PlanYearExpend>();
        }
        Example example = new Example(PlanYearExpend.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)gparam.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        ArrayList<PlanYearExpend> finalList = new ArrayList<PlanYearExpend>();
        List list = this.getListByExample(example);
        for (PlanYearExpend pye : list) {
            PlanYearExpend pe = this.getPlanWorkExpendById(pye.getId());
            finalList.add(pe);
        }
        return finalList;
    }

    public List<PlanYearExpend> getPlanYearExpendListByCidAndYear(Long cid, Integer year) {
        ArrayList<PlanYearExpend> list = new ArrayList<PlanYearExpend>();
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        if (year < 2014) {
            c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)3).andEqualTo("isValid", (Object)Global.TRUE).andLessThan("scheduleYear", (Object)year).andEqualTo("workPlanType", (Object)1);
        } else {
            c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)3).andEqualTo("scheduleYear", (Object)year).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("workPlanType", (Object)1);
        }
        example.setOrderByClause("id asc");
        List planYearList = this.planYearMapper.selectByExample(example);
        for (PlanYear planYear : planYearList) {
            example = new Example(PlanYearExpend.class);
            c = example.createCriteria();
            c.andEqualTo("planYearId", (Object)planYear.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List planYearExpendList = this.getListByExample(example);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getImplManagerId() != null) {
                    planYearExpend.setStaffName(this.staffInfoServiceImpl.getFullStaffRealNameAndOrgName(planYearExpend.getImplManagerId()));
                } else {
                    planYearExpend.setStaffName("-");
                }
                planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
                list.add(planYearExpend);
            }
        }
        return list;
    }

    public List<PlanYear> getPlanYearListForDoc2ByCidAndYear(Long cid, Integer year) {
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        if (year < 2014) {
            c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)3).andEqualTo("isValid", (Object)Global.TRUE).andLessThan("scheduleYear", (Object)year).andEqualTo("workPlanType", (Object)1);
        } else {
            c.andEqualTo("cid", (Object)cid).andEqualTo("stage", (Object)3).andEqualTo("scheduleYear", (Object)year).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("workPlanType", (Object)1);
        }
        example.setOrderByClause("id asc");
        List planYearList = this.planYearMapper.selectByExample(example);
        for (PlanYear planYear : planYearList) {
            example = new Example(PlanYearExpend.class);
            c = example.createCriteria();
            c.andEqualTo("planYearId", (Object)planYear.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List planYearExpendList = this.getListByExample(example);
            PlanYearExpend totalExpand = new PlanYearExpend();
            totalExpand.setActualMoney(new BigDecimal(0L));
            totalExpand.setBudgetMoney(new BigDecimal(0L));
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getImplManagerId() != null) {
                    planYearExpend.setStaffName(this.staffInfoServiceImpl.getHistroyRealNameByIdAndYear(planYearExpend.getImplManagerId(), DateUtils.getYearLastDay((int)year)));
                } else {
                    planYearExpend.setStaffName("-");
                }
                planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
                totalExpand.setActualMoney(totalExpand.getActualMoney().add(planYearExpend.getActualMoney() == null ? new BigDecimal(0L) : planYearExpend.getActualMoney()));
                totalExpand.setBudgetMoney(totalExpand.getBudgetMoney().add(planYearExpend.getBudgetMoney() == null ? new BigDecimal(0L) : planYearExpend.getBudgetMoney()));
            }
            planYear.setTotalExpand(totalExpand);
            planYear.setPlanYearExpendList(planYearExpendList);
        }
        return planYearList;
    }

    @Transactional(readOnly=false)
    public void addPlanYearExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId, Long cid) {
        if (planYearExpend.getPlanYearId() != null) {
            if (planYearExpend.getDecomposeStatus() == 1) {
                StaffBasicWork sbw;
                if (planYearExpend.getManagerId() != null && (sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(planYearExpend.getManagerId())) != null && sbw.getOrgId() != null) {
                    planYearExpend.setOrgId(sbw.getOrgId());
                }
                this.add(planYearExpend, loginStaffId, cid);
            } else {
                this.add(planYearExpend, loginStaffId, cid);
                if (planYearExpend.getExecutorList() != null && planYearExpend.getExecutorList().size() > 0) {
                    for (Long staffId : planYearExpend.getExecutorList()) {
                        PlanWorkExecutorOrgRecord per = new PlanWorkExecutorOrgRecord();
                        per.setExecutor(staffId);
                        per.setPlanId(planYearExpend.getPlanYearId());
                        per.setType(Byte.valueOf((byte)2));
                        per.setPlanDetailOrExpendId(planYearExpend.getId());
                        StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
                        if (sbw != null && sbw.getOrgId() != null) {
                            per.setOrgId(sbw.getOrgId());
                        }
                        this.planWorkExecutorOrgRecordService.add((Object)per, loginStaffId, cid);
                    }
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void updatePlanYearExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId) {
        if (planYearExpend.getId() == null || planYearExpend.getPlanYearId() == null) {
            return;
        }
        if (planYearExpend.getDataStatus() != null && planYearExpend.getDataStatus() == 3) {
            this.update(planYearExpend, loginStaffId);
            return;
        }
        if (planYearExpend.getDataStatus() != null && planYearExpend.getDataStatus() != 1) {
            PlanYear planYear = new PlanYear();
            planYear.setId(planYearExpend.getPlanYearId());
            planYear.setChangeStatus(Byte.valueOf((byte)2));
            this.planYearService.update((Object)planYear, loginStaffId);
        }
        PlanYearExpend fromDB = (PlanYearExpend)this.getById(planYearExpend.getId());
        if (planYearExpend.getDecomposeStatus() == 1 && planYearExpend.getExecutorList() != null && planYearExpend.getExecutorList().size() > 0) {
            StaffBasicWork sbw;
            Long executorStaffId = (Long)planYearExpend.getExecutorList().get(0);
            if (planYearExpend.getManagerId() != null && !planYearExpend.getManagerId().equals(fromDB.getManagerId()) && (sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(executorStaffId)) != null && sbw.getOrgId() != null) {
                planYearExpend.setOrgId(sbw.getOrgId());
            }
            planYearExpend.setManagerId(executorStaffId);
            this.update(planYearExpend, loginStaffId);
        } else {
            this.update(planYearExpend, loginStaffId);
            this.planWorkExecutorOrgRecordService.deleteByPlanIdAndPlanDetailOrExpendIdAndType(planYearExpend.getPlanYearId(), planYearExpend.getId(), Byte.valueOf((byte)2), loginStaffId);
            if (planYearExpend.getExecutorList() != null && planYearExpend.getExecutorList().size() > 0) {
                for (Long staffId : planYearExpend.getExecutorList()) {
                    PlanWorkExecutorOrgRecord per = new PlanWorkExecutorOrgRecord();
                    per.setExecutor(staffId);
                    per.setPlanId(planYearExpend.getPlanYearId());
                    per.setType(Byte.valueOf((byte)2));
                    per.setPlanDetailOrExpendId(planYearExpend.getId());
                    StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
                    if (sbw != null && sbw.getOrgId() != null) {
                        per.setOrgId(sbw.getOrgId());
                    }
                    this.planWorkExecutorOrgRecordService.add((Object)per, loginStaffId, planYearExpend.getCid());
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void deletePlanYearExpendSubmit(Long id, Long planId, byte type, Long loginStaffId, Byte dataStatus) {
        PlanYearExpend planYearExpend = new PlanYearExpend();
        planYearExpend.setId(id);
        planYearExpend.setIsValid(Boolean.valueOf(false));
        PlanYearExpend db = (PlanYearExpend)this.getById(id);
        if (dataStatus != null && db.getDataStatus() != null && db.getDataStatus() != 2) {
            planYearExpend.setDataStatus(dataStatus);
        }
        this.update(planYearExpend, loginStaffId);
        if (db.getDecomposeStatus() != null && db.getDecomposeStatus() == 2) {
            this.deleteChildrenByExpendPid(id, loginStaffId);
        }
        this.planWorkExecutorOrgRecordService.deleteByPlanIdAndPlanDetailOrExpendIdAndType(planId, id, Byte.valueOf(type), loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteChildrenByExpendPid(Long id, Long loginStaffId) {
        if (id == null) {
            return;
        }
        Example e = new Example(PlanYearExpend.class);
        e.createCriteria().andEqualTo("expendPid", (Object)id);
        PlanYearExpend pyd = new PlanYearExpend();
        pyd.setIsValid(Boolean.valueOf(false));
        pyd.setUpdateBy(loginStaffId);
        pyd.setUpdateDate(new Date());
        ((PlanYearExpendMapper)this.dao).updateByExampleSelective(pyd, e);
    }

    public PlanYearExpend getPlanWorkExpendById(Long id) {
        if (id == null) {
            return null;
        }
        PlanYearExpend planYearExpend = (PlanYearExpend)this.getById(id);
        if (planYearExpend != null) {
            planYearExpend.setManagerName("");
            planYearExpend.setImplManagerName("");
            if (planYearExpend.getDecomposeStatus() == 2) {
                planYearExpend.setExecutorList(new ArrayList());
                List list = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(planYearExpend.getPlanYearId(), planYearExpend.getId(), Byte.valueOf((byte)2));
                planYearExpend.setDecomposeStatusName("\u9700\u5206\u89e3");
                for (PlanWorkExecutorOrgRecord per : list) {
                    planYearExpend.getExecutorList().add(per.getExecutor());
                    planYearExpend.setManagerName(planYearExpend.getManagerName() + this.staffInfoService.getFullStaffRealNameAndOrgName(per.getExecutor()) + ",");
                }
            } else if (planYearExpend.getDecomposeStatus() == 1) {
                planYearExpend.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(planYearExpend.getManagerId()));
                planYearExpend.setDecomposeStatusName("\u65e0\u9700\u5206\u89e3");
            }
            if (planYearExpend.getImplManagerId() != null) {
                planYearExpend.setImplManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(planYearExpend.getImplManagerId()));
            }
            planYearExpend.setCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(planYearExpend.getCreateBy()));
            planYearExpend.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(planYearExpend.getUpdateBy()));
            if (planYearExpend.getCreateDate() != null) {
                planYearExpend.setCreateTimeStr(planYearExpend.getCreateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (planYearExpend.getUpdateDate() != null) {
                planYearExpend.setUpdateTimeStr(planYearExpend.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (planYearExpend.getExpendType() != null) {
                planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
            }
        }
        return planYearExpend;
    }

    public List<PlanYearExpend> getNeedDecomposeListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearExpend.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("decomposeStatus", (Object)2);
        return ((PlanYearExpendMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void updatePlanYearExpendSummarySubmit(PlanYearExpend planYearExpend, Long loginStaffId) {
        if (planYearExpend.getId() == null || planYearExpend.getPlanYearId() == null) {
            return;
        }
        this.update(planYearExpend, loginStaffId);
    }

    public PageInfo<PlanYearExpend> needDecomposePlanExpendParentListDataPage(JqGridParam gparam, SearchParamVo search) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List<PlanYearExpend> list = this.needDecomposePlanExpendParentListData(search);
        for (PlanYearExpend pye : list) {
            if (pye.getPlanYearId() != null) {
                pye.setSelfPlan(this.planYearService.getPlanYearById(pye.getPlanYearId()));
            }
            if (pye.getExpendPid() != null) {
                PlanYearExpend pep = this.getPlanWorkExpendById(pye.getExpendPid());
                pye.setParentPlanExpend(pep);
                if (pep != null && pep.getPlanYearId() != null) {
                    pep.setSelfPlan(this.planYearService.getPlanYearById(pep.getPlanYearId()));
                }
            }
            PlanYearExpend e = this.getPlanWorkExpendById(pye.getId());
            pye.setTypeName(e.getTypeName());
            pye.setManagerName(e.getManagerName());
            pye.setUpdaterName(e.getUpdaterName());
            pye.setUpdateTimeStr(e.getUpdateTimeStr());
        }
        return new PageInfo(list);
    }

    public List<PlanYearExpend> needDecomposePlanExpendParentListData(SearchParamVo search) {
        search.setKeywordStaffEncrypt(search.getKeywordStaff());
        return ((PlanYearExpendMapper)this.dao).needDecomposePlanExpendParentListData(search);
    }

    public List<PlanYearExpend> getChildrenPlanYearExpendByPid(Long pid) {
        ArrayList<PlanYearExpend> finalList = new ArrayList<PlanYearExpend>();
        Example example = new Example(PlanYearExpend.class);
        example.createCriteria().andEqualTo("expendPid", (Object)pid).andEqualTo("isValid", (Object)true).andEqualTo("decomposeStatus", (Object)1);
        List list = ((PlanYearExpendMapper)this.dao).selectByExample(example);
        for (PlanYearExpend pye : list) {
            PlanYearExpend pe = this.getPlanWorkExpendById(pye.getId());
            pe.setSelfPlan(this.planYearService.getPlanYearById(pye.getPlanYearId()));
            pe.setParentPlanExpend(this.getPlanWorkExpendById(pid));
            finalList.add(pe);
        }
        return finalList;
    }

    public PlanYearExpend getNeedDecomposePlanExpendById(Long id) {
        if (id == null) {
            return null;
        }
        PlanYearExpend pye = this.getPlanWorkExpendById(id);
        if (pye.getPlanYearId() != null) {
            pye.setSelfPlan(this.planYearService.getPlanYearById(pye.getPlanYearId()));
        }
        if (pye.getExpendPid() != null) {
            PlanYearExpend pp = this.getPlanWorkExpendById(pye.getExpendPid());
            pye.setParentPlanExpend(pp);
            if (pp != null && pp.getPlanYearId() != null) {
                pp.setSelfPlan(this.planYearService.getPlanYearById(pp.getPlanYearId()));
            }
        }
        return pye;
    }

    @Transactional(readOnly=false)
    public void editNeedDecomposePlanExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId) {
        if (planYearExpend.getId() == null) {
            return;
        }
        this.update(planYearExpend, loginStaffId);
        if (planYearExpend.getSelfPlan() != null && planYearExpend.getSelfPlan().getId() != null) {
            if (planYearExpend.getSelfPlan().getStage() != null && planYearExpend.getSelfPlan().getStage() == 2) {
                planYearExpend.getSelfPlan().setPlanCompleteTime(new Date());
            }
            this.planYearService.update((Object)planYearExpend.getSelfPlan(), loginStaffId);
        }
    }

    public int getNeedDecomposePlanExpendCountByStageAndCid(Byte stage, Long cid) {
        if (stage == null || cid == null) {
            return 0;
        }
        return ((PlanYearExpendMapper)this.dao).getNeedDecomposePlanExpendCountByStageAndCid(stage, cid);
    }

    public PageInfo<PlanYearExpend> getChildrenxpendListDataGridParam(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PlanYearExpend> list = this.getChildrenPlanYearExpendByPid(param.getId());
        return new PageInfo(list);
    }

    public List<PlanExpendStaticVo> getStaticPlanExpend(SearchParamVo search) {
        ArrayList<PlanExpendStaticVo> list = new ArrayList<PlanExpendStaticVo>();
        Map map = new HashMap();
        if (search.getOrgId() != null) {
            map = this.preventionExpendService.getPlanExpendStaticVoByOrgAndYear(search.getOrgId(), search.getYear());
        }
        for (PlanYearExpendTypeEnum c : PlanYearExpendTypeEnum.values()) {
            PlanExpendStaticVo vo = new PlanExpendStaticVo();
            vo.setType(Byte.valueOf(c.getValue().byteValue()));
            vo.setTypeName(c.getName());
            if (search.getOrgId() != null) {
                vo.setBudgetMoney(new BigDecimal(this.getBudgetMoneySumByTypeAndCidAndYearAndOrgId(c.getValue().byteValue(), search.getCid(), search.getYear(), search.getOrgId())));
                PlanExpendStaticVo aVo = (PlanExpendStaticVo)map.get(c);
                if (aVo != null) {
                    vo.setActualMoney(aVo.getActualMoney());
                }
            } else {
                vo.setBudgetMoney(new BigDecimal(this.getBudgetMoneySumByTypeAndCidAndYear(c.getValue().byteValue(), search.getCid(), search.getYear())));
                vo.setActualMoney(new BigDecimal(this.getActualMoneySumByTypeAndCidAndYear(c.getValue().byteValue(), search.getCid(), search.getYear())));
            }
            list.add(vo);
        }
        return list;
    }

    private Integer getBudgetMoneySumByTypeAndCidAndYear(Byte type, Long cid, Integer year) {
        Integer count = ((PlanYearExpendMapper)this.dao).getBudgetMoneySumByTypeAndCidAndYear(type, cid, year);
        return count == null ? 0 : count;
    }

    private Integer getBudgetMoneySumByTypeAndCidAndYearAndOrgId(Byte type, Long cid, Integer year, Long orgId) {
        Integer count = ((PlanYearExpendMapper)this.dao).getBudgetMoneySumByTypeAndCidAndYearAndOrgId(type, cid, year, orgId);
        return count == null ? 0 : count;
    }

    private Integer getActualMoneySumByTypeAndCidAndYear(Byte type, Long cid, Integer year) {
        Integer count = ((PlanYearExpendMapper)this.dao).getActualMoneySumByTypeAndCidAndYear(type, cid, year);
        return count == null ? 0 : count;
    }

    public PageInfo<PlanExpendStaticVo> statisticPlanExpendListData(JqGridParam param, SearchParamVo vo) {
        param.setPage(1);
        param.setRows(12);
        vo.setCid(param.getCid());
        List<PlanExpendStaticVo> list = this.getStaticPlanExpend(vo);
        BigDecimal asum = new BigDecimal(0);
        for (PlanExpendStaticVo pVo : list) {
            if (pVo.getActualMoney() == null) {
                pVo.setActualMoney(new BigDecimal(0));
            }
            asum = asum.add(pVo.getActualMoney());
        }
        for (PlanExpendStaticVo pVo : list) {
            if (!BigDecimal.ZERO.equals(asum) && !BigDecimal.ZERO.equals(pVo.getActualMoney())) {
                pVo.setActualMoneyPercent(pVo.getActualMoney().multiply(new BigDecimal(100)).divide(asum, 2, 4).doubleValue() + "%");
                continue;
            }
            pVo.setActualMoneyPercent("0.00%");
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deletePlanExpendSubmitByPlanId(Long planId, Long loginStaffId) {
        if (planId != null) {
            PlanYearExpend expend = new PlanYearExpend();
            expend.setIsValid(Boolean.valueOf(false));
            expend.setUpdateBy(loginStaffId);
            expend.setUpdateDate(new Date());
            Example example = new Example(PlanYearExpend.class);
            example.createCriteria().andEqualTo("planYearId", (Object)planId);
            List expends = this.getListByExample(example);
            ((PlanYearExpendMapper)this.dao).updateByExampleSelective(expend, example);
            for (PlanYearExpend expend1 : expends) {
                if (expend1.getIsValid() == null || !expend1.getIsValid().booleanValue() || expend1.getDecomposeStatus() == null || expend1.getDecomposeStatus() != 2) continue;
                this.deleteChildrenByExpendPid(expend1.getId(), loginStaffId);
            }
        }
    }

    public List<PlanYearExpend> getChangeNeedDecomposeListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearExpend.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("decomposeStatus", (Object)2).andEqualTo("dataStatus", (Object)2);
        return ((PlanYearExpendMapper)this.dao).selectByExample(example);
    }

    public List<PlanYearExpend> getPlanYearExpendChangeListByGridParam(JqGridParam gparam) {
        if (gparam.getId() == null) {
            return new ArrayList<PlanYearExpend>();
        }
        Example example = new Example(PlanYearExpend.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)gparam.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        ArrayList<Byte> sts = new ArrayList<Byte>();
        sts.add((byte)2);
        sts.add((byte)3);
        sts.add((byte)4);
        example.or().andEqualTo("planYearId", (Object)gparam.getId()).andIn("dataStatus", sts);
        example.setOrderByClause("id asc");
        ArrayList<PlanYearExpend> finalList = new ArrayList<PlanYearExpend>();
        List list = this.getListByExample(example);
        for (PlanYearExpend pye : list) {
            PlanYearExpend pe = this.getPlanWorkExpendById(pye.getId());
            finalList.add(pe);
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public void deleteDecomposePlanByDetailId(Long id, Long planId, Long loginStaffId) {
        if (id == null || planId == null) {
            return;
        }
        PlanYearExpend pye = new PlanYearExpend();
        pye.setId(id);
        this.delete(pye, loginStaffId);
        PlanYear planYear = new PlanYear();
        planYear.setId(planId);
        this.planYearService.delete((Object)planYear, loginStaffId);
    }
}

