/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.framework.service.datascope.DataScopeUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearDetailMapper;
import cn.smarthse.modules.health.dao.work.planyear.PlanYearMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkExecutorOrgRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkTransferRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.evaluate.EvaluateHseTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailTypeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTypeEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.impl.planyear.PlanYearUploadFileServiceImpl;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkExecutorOrgRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkTransferRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearModularsService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.vo.work.yearplan.NeedDecomposeWorkPlan;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PlanYearDetailServiceImpl
extends BaseServiceImpl<PlanYearDetailMapper, PlanYearDetail>
implements IPlanYearDetailService {
    @Autowired
    IPlanYearModularsService planYearModularsService;
    @Autowired
    IStaffInfoService staffInfoServiceImpl;
    @Autowired
    PlanYearMapper planYearMapper;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    IPlanWorkExecutorOrgRecordService planWorkExecutorOrgRecordService;
    @Autowired
    IPlanWorkTransferRecordService planWorkTransferRecordService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IPlanYearService planYearService;
    @Autowired
    PlanYearUploadFileServiceImpl planYearUploadFileServiceImpl;
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;

    public List<PlanYearDetail> getPlanYearDetailListByGridParam(JqGridParam gparam) {
        if (gparam.getId() == null) {
            return new ArrayList<PlanYearDetail>();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)gparam.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        ArrayList<PlanYearDetail> finalList = new ArrayList<PlanYearDetail>();
        for (PlanYearDetail d : list) {
            finalList.add(this.getPlanYearDetailById(d.getId()));
        }
        return finalList;
    }

    @Override
    @Transactional(readOnly=false)
    public void update(PlanYearDetail detail) {
        detail.setUpdateDate(new Date());
        ((PlanYearDetailMapper)this.dao).updateByPrimaryKey(detail);
        this.delFromMemoryCache(detail.getId());
    }

    public List<PlanYearDetail> getListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE);
        return ((PlanYearDetailMapper)this.dao).selectByExample(example);
    }

    public List<PlanYearDetail> getList(Long cid, Long businessModularId, Long businessId) {
        Example example = new Example(PlanYearDetail.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("bussnissModularId", (Object)businessModularId).andEqualTo("bussnissId", (Object)businessId);
        return ((PlanYearDetailMapper)this.dao).selectByExample(example);
    }

    public List<PlanYearDetail> getPlanYearDetailListByCidAndYear(Long cid, Integer year) {
        ArrayList<PlanYearDetail> list = new ArrayList<PlanYearDetail>();
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        ArrayList<Integer> stageList = new ArrayList<Integer>();
        stageList.add(2);
        stageList.add(3);
        if (year < 2014) {
            c.andEqualTo("cid", (Object)cid).andIn("stage", stageList).andEqualTo("isValid", (Object)Global.TRUE).andLessThan("scheduleYear", (Object)year);
        } else {
            c.andEqualTo("cid", (Object)cid).andIn("stage", stageList).andEqualTo("scheduleYear", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        }
        example.setOrderByClause("id asc");
        List planYearList = this.planYearMapper.selectByExample(example);
        for (PlanYear planYear : planYearList) {
            example = new Example(PlanYearDetail.class);
            c = example.createCriteria();
            c.andEqualTo("planYearId", (Object)planYear.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List planYearDetailList = this.getListByExample(example);
            for (PlanYearDetail planYearDetail : planYearDetailList) {
                if (planYearDetail.getManagerId() != null) {
                    planYearDetail.setManagerName(this.staffInfoServiceImpl.getHistroyRealNameByIdAndYear(planYearDetail.getManagerId(), DateUtils.getYearLastDay((int)year)));
                }
                if (planYearDetail.getImplManagerId() != null) {
                    planYearDetail.setImplManagerName(this.staffInfoServiceImpl.getHistroyRealNameByIdAndYear(planYearDetail.getImplManagerId(), DateUtils.getYearLastDay((int)year)));
                }
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setImplState(PlanYearDetailImplState.get((Byte)planYearDetail.getImplResult()));
                if (planYearDetail.getImplState() != null && planYearDetail.getImplState().equals((Object)PlanYearDetailImplState.deleted)) {
                    planYearDetail.setImplStateName("\u672a\u5b9e\u65bd");
                } else {
                    planYearDetail.setImplStateName(planYearDetail.getImplState().getName());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)planYearDetail.getImplWorkName())) {
                    planYearDetail.setImplWorkName(planYearDetail.getPlanWorkName());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)planYearDetail.getImplManagerName())) {
                    planYearDetail.setImplManagerName(planYearDetail.getManagerName());
                }
                list.add(planYearDetail);
            }
        }
        return list;
    }

    public List<PlanYearDetail> getPlanYearDetailListByCidAndYearAndBussnissModularId(Long cid, Integer year, Long bussnissModularId) {
        ArrayList<PlanYearDetail> list = new ArrayList<PlanYearDetail>();
        Example example = new Example(PlanYear.class);
        Example.Criteria c = example.createCriteria();
        if (year < 2014) {
            c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andLessThan("scheduleYear", (Object)year);
        } else {
            c.andEqualTo("cid", (Object)cid).andEqualTo("scheduleYear", (Object)year).andEqualTo("isValid", (Object)Global.TRUE);
        }
        example.setOrderByClause("id asc");
        List planYearList = this.planYearMapper.selectByExample(example);
        for (PlanYear planYear : planYearList) {
            example = new Example(PlanYearDetail.class);
            c = example.createCriteria();
            c.andEqualTo("planYearId", (Object)planYear.getId()).andEqualTo("bussnissModularId", (Object)bussnissModularId).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List planYearDetailList = this.getListByExample(example);
            for (PlanYearDetail planYearDetail : planYearDetailList) {
                if (planYearDetail.getManagerId() != null) {
                    planYearDetail.setManagerName(this.staffInfoServiceImpl.getHistroyRealNameByIdAndYear(planYearDetail.getManagerId(), DateUtils.getYearLastDay((int)year)));
                }
                if (planYearDetail.getImplManagerId() != null) {
                    planYearDetail.setImplManagerName(this.staffInfoServiceImpl.getHistroyRealNameByIdAndYear(planYearDetail.getImplManagerId(), DateUtils.getYearLastDay((int)year)));
                }
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setImplState(PlanYearDetailImplState.get((Byte)planYearDetail.getImplResult()));
                planYearDetail.setImplStateName(planYearDetail.getImplState().getName());
                list.add(planYearDetail);
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public PlanYearDetail addPlanWorkDetailSubmit(PlanYearDetail planYearDetail, Long loginStaffId, Long cid) {
        if (planYearDetail.getPlanYearId() != null) {
            if (planYearDetail.getDecomposeStatus() == 1) {
                Long executorStaffId = planYearDetail.getManagerId();
                if (executorStaffId != null) {
                    StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(executorStaffId);
                    if (sbw != null && sbw.getOrgId() != null) {
                        planYearDetail.setOrgId(sbw.getOrgId());
                    }
                    planYearDetail.setManagerId(executorStaffId);
                }
                planYearDetail = this.add(planYearDetail, loginStaffId, cid);
            } else if ((planYearDetail = this.add(planYearDetail, loginStaffId, cid)).getExecutorList() != null && planYearDetail.getExecutorList().size() > 0) {
                for (Long staffId : planYearDetail.getExecutorList()) {
                    if (staffId == null || staffId == 0L) continue;
                    PlanWorkExecutorOrgRecord per = new PlanWorkExecutorOrgRecord();
                    per.setExecutor(staffId);
                    per.setPlanId(planYearDetail.getPlanYearId());
                    per.setType(Byte.valueOf((byte)1));
                    per.setPlanDetailOrExpendId(planYearDetail.getId());
                    StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
                    if (sbw != null && sbw.getOrgId() != null) {
                        per.setOrgId(sbw.getOrgId());
                    }
                    this.planWorkExecutorOrgRecordService.add((Object)per, loginStaffId, cid);
                }
            }
        }
        return planYearDetail;
    }

    @Transactional(readOnly=false)
    public PlanYearDetail updatePlanWorkDetailSubmit(PlanYearDetail planYearDetail, Long loginStaffId) {
        if (planYearDetail.getId() == null || planYearDetail.getPlanYearId() == null) {
            return null;
        }
        if (planYearDetail.getDataStatus() != null && planYearDetail.getDataStatus() != 1) {
            PlanYear planYear = new PlanYear();
            planYear.setId(planYearDetail.getPlanYearId());
            planYear.setChangeStatus(Byte.valueOf((byte)2));
            this.planYearService.update((Object)planYear, loginStaffId);
        }
        if (planYearDetail.getDataStatus() != null && planYearDetail.getDataStatus() == 3) {
            this.update(planYearDetail, loginStaffId);
            return planYearDetail;
        }
        PlanYearDetail fromDB = (PlanYearDetail)this.getById(planYearDetail.getId());
        if (planYearDetail.getDecomposeStatus() == 1) {
            StaffBasicWork sbw;
            if (planYearDetail.getManagerId() != null && !planYearDetail.getManagerId().equals(fromDB.getManagerId()) && (sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(planYearDetail.getManagerId())) != null && sbw.getOrgId() != null) {
                planYearDetail.setOrgId(sbw.getOrgId());
            }
            this.update(planYearDetail, loginStaffId);
        } else {
            this.update(planYearDetail, loginStaffId);
            this.planWorkExecutorOrgRecordService.deleteByPlanIdAndPlanDetailOrExpendIdAndType(planYearDetail.getPlanYearId(), planYearDetail.getId(), Byte.valueOf((byte)1), loginStaffId);
            if (planYearDetail.getExecutorList() != null && planYearDetail.getExecutorList().size() > 0) {
                for (Long staffId : planYearDetail.getExecutorList()) {
                    if (staffId == null || staffId == 0L) continue;
                    List excutors = this.planWorkExecutorOrgRecordService.getNoValidListByPlanIdAndPlanDetailOrExpendIdAndTypeAndExecutor(planYearDetail.getPlanYearId(), planYearDetail.getId(), Byte.valueOf((byte)1), staffId);
                    PlanWorkExecutorOrgRecord per = new PlanWorkExecutorOrgRecord();
                    if (excutors.size() > 0) {
                        per.setIsValid(Boolean.valueOf(true));
                        per.setId(((PlanWorkExecutorOrgRecord)excutors.get(0)).getId());
                        this.planWorkExecutorOrgRecordService.update((Object)per);
                        continue;
                    }
                    per.setExecutor(staffId);
                    per.setPlanId(planYearDetail.getPlanYearId());
                    per.setType(Byte.valueOf((byte)1));
                    per.setPlanDetailOrExpendId(planYearDetail.getId());
                    StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
                    if (sbw != null && sbw.getOrgId() != null) {
                        per.setOrgId(sbw.getOrgId());
                    }
                    this.planWorkExecutorOrgRecordService.add((Object)per, loginStaffId, planYearDetail.getCid());
                }
            }
        }
        return planYearDetail;
    }

    @Transactional(readOnly=false)
    public void deletePlanWorkDetailSubmit(Long id, Long planId, Byte type, Long loginStaffId, Byte dataStatus) {
        PlanYearDetail planYearDetail = new PlanYearDetail();
        planYearDetail.setId(id);
        planYearDetail.setIsValid(Boolean.valueOf(false));
        PlanYearDetail db = (PlanYearDetail)this.getById(id);
        if (dataStatus != null && db.getDataStatus() != null && db.getDataStatus() != 2) {
            planYearDetail.setDataStatus(dataStatus);
        }
        this.update(planYearDetail, loginStaffId);
        if (db.getDecomposeStatus() != null && db.getDecomposeStatus() == 2) {
            this.deleteChildrenByDetailPid(id, loginStaffId);
        }
        this.planWorkExecutorOrgRecordService.deleteByPlanIdAndPlanDetailOrExpendIdAndType(planId, id, type, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteChildrenByDetailPid(Long id, Long staffId) {
        if (id == null) {
            return;
        }
        Example e = new Example(PlanYearDetail.class);
        e.createCriteria().andEqualTo("detailPid", (Object)id);
        List list = this.getListByExample(e);
        PlanYearDetail pyd = new PlanYearDetail();
        pyd.setIsValid(Boolean.valueOf(false));
        pyd.setUpdateBy(staffId);
        pyd.setUpdateDate(new Date());
        ((PlanYearDetailMapper)this.dao).updateByExampleSelective(pyd, e);
        for (PlanYearDetail detail : list) {
            if (detail.getIsValid() == null || !detail.getIsValid().booleanValue() || detail.getBussnissId() == null || detail.getImplResult().byteValue() != PlanYearDetailImplState.implemented.getValue()) continue;
            this.sysCoreWorkModuleCorrelationService.ignore(null, CoreWorkEnum.AllWork, CoreWorkEnum.yearPlan, detail.getBussnissId(), detail.getCid(), staffId, null);
        }
    }

    @Transactional(readOnly=false)
    public PlanYearDetail getPlanYearDetailById(Long id) {
        if (id == null) {
            return null;
        }
        PlanYearDetail detail = (PlanYearDetail)this.getById(id);
        if (detail != null) {
            detail.setManagerName("");
            detail.setImplManagerName("");
            detail.setPlanManagerName("");
            if (detail.getDecomposeStatus() == null) {
                detail.setDecomposeStatusName("\u6570\u636e\u9519\u8bef");
            } else if (detail.getDecomposeStatus() == 2) {
                detail.setExecutorList(new ArrayList());
                List list = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(detail.getPlanYearId(), detail.getId(), Byte.valueOf((byte)1));
                detail.setDecomposeStatusName("\u9700\u5206\u89e3");
                for (PlanWorkExecutorOrgRecord per : list) {
                    detail.getExecutorList().add(per.getExecutor());
                    detail.setManagerName(detail.getManagerName() + this.staffInfoService.getFullStaffRealNameAndOrgName(per.getExecutor()) + ",");
                }
            } else if (detail.getDecomposeStatus() == 1) {
                PlanWorkTransferRecord record = this.planWorkTransferRecordService.getLastExcutorByPlanId(detail.getPlanYearId());
                if (record == null) {
                    detail.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getManagerId()));
                } else if (record.getAcceptStaff() != null) {
                    detail.setManagerId(record.getAcceptStaff());
                    detail.setOrgId(record.getOrgId());
                    detail.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getManagerId()));
                }
                detail.setDecomposeStatusName("\u65e0\u9700\u5206\u89e3");
            }
            if (detail.getImplManagerId() != null) {
                detail.setImplManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getImplManagerId()));
            }
            if (detail.getPlanManagerId() != null) {
                detail.setPlanManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getPlanManagerId()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detail.getAttachment())) {
                detail.setAttachment(detail.getAttachment().replace("null,", "").replace(",null", ""));
                String[] strs = detail.getAttachment().split(",");
                ArrayList<Long> attas = new ArrayList<Long>();
                for (String str : strs) {
                    if (!StringUtils.isNumber((String)str)) continue;
                    attas.add(Long.valueOf(str));
                }
                detail.setAttachmentArr((Long[])attas.stream().toArray(Long[]::new));
            }
            detail.setCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getCreateBy()));
            detail.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getUpdateBy()));
            if (detail.getBussnissModularId() != null) {
                detail.setWorkTypeName(this.getWorkTypeName(detail.getBussnissModularId().intValue(), detail.getWorkSubtype()));
            }
            if (detail.getImplResult() != null) {
                detail.setImplState(PlanYearDetailImplState.get((Byte)detail.getImplResult()));
                detail.setImplStateName(detail.getImplResult() == 0 ? "\u672a\u5b9e\u65bd" : detail.getImplState().getName());
            }
            detail.setPlanImplDateStr("");
            if (detail.getPlanImplDate() != null) {
                detail.setPlanImplDateStr(detail.getPlanImplDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getPlanImplDateEnd() != null) {
                detail.setPlanImplDateStr(detail.getPlanImplDateStr() + "\u81f3" + detail.getPlanImplDateEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            detail.setImplDateStr("");
            if (detail.getImplStartDate() != null) {
                detail.setImplDateStr(detail.getImplStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getImplEndDate() != null) {
                detail.setImplDateStr(detail.getImplDateStr() + "\u81f3" + detail.getImplEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getCreateDate() != null) {
                detail.setCreateTimeStr(detail.getCreateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getUpdateDate() != null) {
                detail.setUpdateTimeStr(detail.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        return detail;
    }

    public List<PlanYearDetail> getNoDecomposeListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("decomposeStatus", (Object)1);
        List list = ((PlanYearDetailMapper)this.dao).selectByExample(example);
        for (PlanYearDetail detail : list) {
            StaffBasicWork sbw;
            if (detail.getDetailPid() == null || detail.getPlanManagerId() == null || (sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(detail.getPlanManagerId())) == null || sbw.getOrgId() == null) continue;
            detail.setPlanManagerOrgId(sbw.getOrgId());
        }
        return list;
    }

    public PageInfo<PlanYearDetail> getDailyPlanListByParam(JqGridParam gparam, SearchParamVo vo) {
        if (vo.getCid() == null) {
            return new PageInfo(new ArrayList());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List<PlanYearDetail> list = ((PlanYearDetailMapper)this.dao).selectByParam(vo);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (PlanYearDetail detail : list) {
            PlanYear db = (PlanYear)this.planYearService.getById(detail.getPlanYearId());
            detail.setSelfPlan(db);
            if (detail.getPlanImplDate() != null) {
                Object planDate = dateFormat.format(detail.getPlanImplDate());
                if (detail.getPlanImplDateEnd() != null) {
                    planDate = (String)planDate + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                }
                detail.setPlanImplDateStr((String)planDate);
            }
            if (detail.getImplStartDate() != null) {
                Object implDate = dateFormat.format(detail.getImplStartDate());
                if (detail.getImplEndDate() != null) {
                    implDate = (String)implDate + "\u81f3" + dateFormat.format(detail.getImplEndDate());
                }
                detail.setImplDateStr((String)implDate);
            }
            if (detail.getBussnissModularId() != null) {
                String typeName = this.getWorkTypeName(detail.getBussnissModularId().intValue(), detail.getWorkSubtype());
                detail.setWorkSubtype(typeName);
            }
            detail.setCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getCreateBy()));
            detail.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getUpdateBy()));
        }
        return new PageInfo(list);
    }

    public PageInfo<PlanYearDetail> getDailySummaryListByParam(JqGridParam gparam, SearchParamVo vo) {
        if (vo.getCid() == null) {
            return new PageInfo(new ArrayList());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List<PlanYearDetail> list = ((PlanYearDetailMapper)this.dao).selectByParam(vo);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (PlanYearDetail detail : list) {
            if (detail.getPlanImplDate() != null) {
                Object planDate = dateFormat.format(detail.getPlanImplDate());
                if (detail.getPlanImplDateEnd() != null) {
                    planDate = (String)planDate + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                }
                detail.setPlanImplDateStr((String)planDate);
            }
            if (detail.getImplStartDate() != null) {
                Object implDate = dateFormat.format(detail.getImplStartDate());
                if (detail.getImplEndDate() != null) {
                    implDate = (String)implDate + "\u81f3" + dateFormat.format(detail.getImplEndDate());
                }
                detail.setImplDateStr((String)implDate);
            }
            if (detail.getBussnissModularId() != null) {
                String typeName = this.getWorkTypeName(detail.getBussnissModularId().intValue(), detail.getWorkSubtype());
                detail.setWorkSubtype(typeName);
            }
            detail.setCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getCreateBy()));
            detail.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getUpdateBy()));
            if (detail.getDecomposeStatus() == 2) {
                int total = this.getChildPlanNumByPid(detail.getId());
                int summ = this.getChildPlanSummNumByPid(detail.getId());
                String childSummInfo = summ + "/" + total;
                detail.setChildSummInfo(childSummInfo);
                continue;
            }
            detail.setChildSummInfo("-");
        }
        return new PageInfo(list);
    }

    private String getWorkTypeName(int type, String subType) {
        Object typeName = PlanYearDetailTypeEnum.getName((Integer)type);
        if (subType != null && !subType.equals("")) {
            int st = Integer.parseInt(subType);
            switch (type) {
                case 1: {
                    typeName = (String)typeName + "-" + CheckTypeEnum.getName((String)subType);
                    break;
                }
                case 2: {
                    typeName = (String)typeName + "-" + HcCheckTypeEnum.getThisEnumByValue((Long)Long.parseLong(subType)).getName();
                    break;
                }
                case 3: {
                    typeName = (String)typeName + "-" + TrainPlanTypeEnum.getName((Byte)((byte)st));
                    break;
                }
                case 9: {
                    typeName = (String)typeName + "-" + EvaluateHseTypeEnum.getEvaluateTypeName((Byte)((byte)st));
                    break;
                }
                case 6: {
                    typeName = (String)typeName + "-" + InspectionTypeEnum.getNameByValue((Byte)((byte)st));
                    break;
                }
                case 7: {
                    if (1 == st) {
                        typeName = (String)typeName + "-\u5355\u9879\u6f14\u7ec3";
                        break;
                    }
                    typeName = (String)typeName + "-\u7efc\u5408\u6f14\u7ec3";
                    break;
                }
            }
        }
        return typeName;
    }

    public PageInfo<PlanYearDetail> needDecomposePlanWorkParentListDataPage(JqGridParam gparam, SearchParamVo search) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "decompose_plan_v");
        List<PlanYearDetail> list = this.needDecomposePlanWorkParentListData(search);
        for (PlanYearDetail detail : list) {
            if (detail.getPlanYearId() != null) {
                detail.setSelfPlan(this.planYearService.getPlanYearById(detail.getPlanYearId()));
            }
            if (detail.getDetailPid() != null) {
                detail.setParentPlanDetail(this.getPlanYearDetailById(detail.getDetailPid()));
            }
            PlanYearDetail d = this.getPlanYearDetailById(detail.getId());
            detail.setWorkTypeName(d.getWorkTypeName());
            detail.setPlanWorkName(d.getPlanWorkName());
            detail.setPlanImplDateStr(d.getPlanImplDateStr());
            detail.setImplDateStr(d.getImplDateStr());
            detail.setManagerId(d.getManagerId());
            detail.setManagerName(d.getManagerName());
            detail.setImplStateName(d.getImplStateName());
            detail.setUpdaterName(d.getUpdaterName());
            detail.setUpdateTimeStr(d.getUpdateTimeStr());
            if (detail.getCreateBy() != null && detail.getCreateBy().equals(search.getLoginStaffId())) {
                detail.setIsPersonEdit(Boolean.valueOf(true));
                continue;
            }
            if (DataScopeUtils.isPersonDataScope("yearPlan", "" + search.getLoginStaffId())) {
                if (("" + search.getLoginStaffId()).equals("" + detail.getManagerId())) {
                    detail.setIsPersonEdit(Boolean.valueOf(true));
                    continue;
                }
                detail.setIsPersonEdit(Boolean.valueOf(false));
                continue;
            }
            detail.setIsPersonEdit(Boolean.valueOf(true));
        }
        return new PageInfo(list);
    }

    public List<PlanYearDetail> needDecomposePlanWorkParentListData(SearchParamVo search) {
        search.setKeywordStaffEncrypt(search.getKeywordStaff());
        return ((PlanYearDetailMapper)this.dao).needDecomposePlanWorkParentListData(search);
    }

    public List<PlanYearDetail> getChildrenPlanYearDetailsByPid(Long pid) {
        ArrayList<PlanYearDetail> finalList = new ArrayList<PlanYearDetail>();
        if (pid != null) {
            Example example = new Example(PlanYearDetail.class);
            example.createCriteria().andEqualTo("detailPid", (Object)pid).andEqualTo("isValid", (Object)true).andEqualTo("decomposeStatus", (Object)1);
            List list = ((PlanYearDetailMapper)this.dao).selectByExample(example);
            PlanYearDetail parentPlanDetali = this.getPlanYearDetailById(pid);
            for (PlanYearDetail pd : list) {
                PlanYearDetail pyd = this.getPlanYearDetailById(pd.getId());
                pyd.setSelfPlan(this.planYearService.getPlanYearById(pyd.getPlanYearId()));
                pyd.setParentPlanDetail(parentPlanDetali);
                finalList.add(pyd);
            }
        }
        return finalList;
    }

    public PageInfo<PlanYearDetail> getChildrenPlanYearDetailsByPid(JqGridParam gparam, Long pid) {
        if (pid == null) {
            return new PageInfo(new ArrayList());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        Example example = new Example(PlanYearDetail.class);
        example.createCriteria().andEqualTo("detailPid", (Object)pid).andEqualTo("isValid", (Object)true).andEqualTo("decomposeStatus", (Object)1);
        List list = ((PlanYearDetailMapper)this.dao).selectByExample(example);
        PlanYearDetail parentPlanDetali = this.getPlanYearDetailById(pid);
        ArrayList<PlanYearDetail> finalList = new ArrayList<PlanYearDetail>();
        for (PlanYearDetail pd : list) {
            PlanYearDetail pyd = this.getPlanYearDetailById(pd.getId());
            pyd.setSelfPlan(this.planYearService.getPlanYearById(pyd.getPlanYearId()));
            pyd.setParentPlanDetail(parentPlanDetali);
            finalList.add(pyd);
        }
        PageInfo page = new PageInfo(list);
        page.setList(finalList);
        return page;
    }

    public List<PlanYearDetail> getNeedDecomposeListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("decomposeStatus", (Object)2);
        return ((PlanYearDetailMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void editPlanWorkDetailSummarySubmit(PlanYearDetail planYearDetail, Long loginStaffId) {
        if (planYearDetail != null && planYearDetail.getId() != null) {
            if (planYearDetail.getAttachmentArr() != null && planYearDetail.getAttachmentArr().length > 0) {
                planYearDetail.setAttachment("");
                for (Long l : planYearDetail.getAttachmentArr()) {
                    planYearDetail.setAttachment(planYearDetail.getAttachment() + l + ",");
                }
            }
            this.update(planYearDetail, loginStaffId);
        }
    }

    public PlanYearDetail getNeedDecomposePlanWorkById(Long id) {
        if (id == null) {
            return null;
        }
        PlanYearDetail pyd = this.getPlanYearDetailById(id);
        if (pyd.getPlanYearId() != null) {
            pyd.setSelfPlan(this.planYearService.getPlanYearById(pyd.getPlanYearId()));
        }
        if (pyd.getDetailPid() != null) {
            PlanYearDetail ppd = this.getPlanYearDetailById(pyd.getDetailPid());
            pyd.setParentPlanDetail(ppd);
            if (ppd.getPlanYearId() != null) {
                ppd.setSelfPlan(this.planYearService.getPlanYearById(ppd.getPlanYearId()));
            }
        }
        return pyd;
    }

    @Transactional(readOnly=false)
    public void editNeedDecomposePlanWorkSubmit(PlanYearDetail planYearDetail, Long loginStaffId) {
        if (planYearDetail.getId() == null) {
            return;
        }
        this.update(planYearDetail, loginStaffId);
        if (planYearDetail.getSelfPlan() == null || planYearDetail.getSelfPlan().getId() == null) {
            return;
        }
        this.planYearService.update((Object)planYearDetail.getSelfPlan(), loginStaffId);
        if (planYearDetail.getSelfPlan().getPlanAttachmentArr() != null && planYearDetail.getSelfPlan().getPlanAttachmentArr().length > 0) {
            this.planYearUploadFileServiceImpl.updatePlanYearUploadFilesByPlanId(planYearDetail.getSelfPlan().getId(), planYearDetail.getSelfPlan().getPlanAttachmentArr(), (byte)1, planYearDetail.getCid(), loginStaffId);
        }
        if (planYearDetail.getSelfPlan().getSummaryAttachmentArr() != null && planYearDetail.getSelfPlan().getSummaryAttachmentArr().length > 0) {
            this.planYearUploadFileServiceImpl.updatePlanYearUploadFilesByPlanId(planYearDetail.getSelfPlan().getId(), planYearDetail.getSelfPlan().getSummaryAttachmentArr(), (byte)2, planYearDetail.getCid(), loginStaffId);
        }
    }

    public int getNeedDecomposePlanCountByStageAndCid(Byte stage, Long cid) {
        if (stage == null || cid == 0L) {
            return 0;
        }
        return ((PlanYearDetailMapper)this.dao).getNeedDecomposePlanCountByStageAndCid(stage, cid);
    }

    public int getPlanCountByCid(Long cid) {
        return ((PlanYearDetailMapper)this.dao).getAllPlanDetailCountByCid(cid);
    }

    public int getPlanCompletedStageCountByCid(Long cid) {
        return ((PlanYearDetailMapper)this.dao).getPlanCompletedStageCountByCid(cid);
    }

    public int getPlanSummaryCompletedStageCountByCid(Long cid) {
        return ((PlanYearDetailMapper)this.dao).getPlanSummaryCompletedStageCountByCid(cid);
    }

    @Transactional(readOnly=false)
    public void deletePlanDetailSubmitByPlanId(Long planId, Long loginStaffId) {
        PlanYearDetail pyd = new PlanYearDetail();
        pyd.setIsValid(Boolean.valueOf(false));
        pyd.setUpdateBy(loginStaffId);
        pyd.setUpdateDate(new Date());
        Example example = new Example(PlanYearDetail.class);
        example.createCriteria().andEqualTo("planYearId", (Object)planId);
        List details = this.getListByExample(example);
        ((PlanYearDetailMapper)this.dao).updateByExampleSelective(pyd, example);
        for (PlanYearDetail detail : details) {
            if (detail.getIsValid() != null && detail.getIsValid().booleanValue() && detail.getDecomposeStatus() != null && detail.getDecomposeStatus() == 2) {
                this.deleteChildrenByDetailPid(detail.getId(), loginStaffId);
            }
            if (detail.getIsValid() == null || !detail.getIsValid().booleanValue() || detail.getBussnissId() == null || detail.getImplResult().byteValue() != PlanYearDetailImplState.implemented.getValue()) continue;
            this.sysCoreWorkModuleCorrelationService.ignore(null, CoreWorkEnum.AllWork, CoreWorkEnum.yearPlan, detail.getBussnissId(), detail.getCid(), loginStaffId, null);
        }
    }

    public PageInfo<PlanYearDetail> statisticPlanDetailListData(JqGridParam param, SearchParamVo vo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("yearPlan", "plan_year");
        List<PlanYearDetail> list = this.getAllPlanDetailListDataBySearch(vo);
        ArrayList<PlanYearDetail> finalList = new ArrayList<PlanYearDetail>();
        for (PlanYearDetail pyd : list) {
            PlanYearDetail pydb = this.getPlanYearDetailById(pyd.getId());
            if (pydb != null && pydb.getPlanYearId() != null) {
                pydb.setSelfPlan(this.planYearService.getPlanYearById(pydb.getPlanYearId()));
                if (pydb.getDetailPid() != null) {
                    pydb.setParentPlanDetail(this.getPlanYearDetailById(pydb.getDetailPid()));
                }
            }
            finalList.add(pydb);
        }
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setList(finalList);
        return pageInfo;
    }

    public List<PlanYearDetail> getAllPlanDetailListDataBySearch(SearchParamVo vo) {
        vo.setKeywordStaffEncrypt(vo.getKeywordStaff());
        List<PlanYearDetail> list = ((PlanYearDetailMapper)this.dao).getAllPlanDetailListDataBySearch(vo);
        return list;
    }

    public List<PlanYearDetail> getWillExpirePlanList() {
        List<PlanYearDetail> list = ((PlanYearDetailMapper)this.dao).getWillExpirePlanList();
        return list;
    }

    public List<PlanYearDetail> getChangeNeedDecomposeListByPlanYearId(Long planYearId) {
        if (planYearId == null || planYearId == 0L) {
            return Collections.emptyList();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("planYearId", (Object)planYearId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("decomposeStatus", (Object)2).andEqualTo("dataStatus", (Object)2);
        return ((PlanYearDetailMapper)this.dao).selectByExample(example);
    }

    public List<PlanYearDetail> getPlanYearDetailListChangeByGridParam(JqGridParam gparam) {
        if (gparam.getId() == null) {
            return new ArrayList<PlanYearDetail>();
        }
        Example example = new Example(PlanYearDetail.class);
        Example.Criteria c = example.createCriteria();
        ArrayList<Byte> sts = new ArrayList<Byte>();
        sts.add((byte)2);
        sts.add((byte)3);
        sts.add((byte)4);
        c.andEqualTo("planYearId", (Object)gparam.getId()).andIn("dataStatus", sts);
        example.or().andEqualTo("planYearId", (Object)gparam.getId()).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        ArrayList<PlanYearDetail> finalList = new ArrayList<PlanYearDetail>();
        for (PlanYearDetail d : list) {
            finalList.add(this.getPlanYearDetailById(d.getId()));
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public void deleteDecomposePlanByDetailId(Long id, Long planId, Long loginStaffId) {
        if (id != null && planId != null) {
            PlanYearDetail detail = new PlanYearDetail();
            detail.setId(id);
            this.delete(detail, loginStaffId);
            PlanYear planyear = new PlanYear();
            planyear.setId(planId);
            this.planYearService.delete((Object)planyear, loginStaffId);
        }
    }

    public Integer getYearCountOverOneYearCompletedPlanByCid(Long cid) {
        Integer count = ((PlanYearDetailMapper)this.dao).getYearCountOverOneYearCompletedPlanByCid(cid);
        return count == null ? 0 : count;
    }

    public Integer getChildPlanNumByPid(Long detailPid) {
        Integer count = ((PlanYearDetailMapper)this.dao).getChildPlanNumByPid(detailPid);
        return count == null ? 0 : count;
    }

    public Integer getChildPlanSummNumByPid(Long detailPid) {
        Integer count = ((PlanYearDetailMapper)this.dao).getChildPlanSummNumByPid(detailPid);
        return count == null ? 0 : count;
    }

    public PageInfo<NeedDecomposeWorkPlan> needDecomposePlanWorkParentListDataV2102Page(JqGridParam gparam, SearchParamVo search) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("yearPlan", "decompose_plan_v");
        search.setKeywordStaffEncrypt(search.getKeywordStaff());
        List<NeedDecomposeWorkPlan> list = ((PlanYearDetailMapper)this.dao).needDecomposePlanWorkParentListDataV2120(search);
        for (NeedDecomposeWorkPlan detail : list) {
            detail.setParentWorkTypeName(this.getWorkTypeName(detail.getParentBussnissModularId().intValue(), detail.getParentWorkSubtype()));
            detail.setParentPlanImplDateStr("");
            if (detail.getParentPlanImplDate() != null) {
                detail.setParentPlanImplDateStr(detail.getParentPlanImplDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getParentPlanImplDateEnd() != null) {
                detail.setParentPlanImplDateStr(detail.getParentPlanImplDateStr() + "\u81f3" + detail.getParentPlanImplDateEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            detail.setParentCreatorName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getParentCreateBy()));
            PlanWorkTransferRecord pRecord = this.planWorkTransferRecordService.getLastExcutorByPlanId(detail.getPlanYearId());
            if (pRecord != null && pRecord.getAcceptStaff() != null) {
                detail.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(pRecord.getAcceptStaff()));
            } else {
                detail.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getManagerId()));
            }
            if (detail.getWorkPlanSource() != null) {
                if (detail.getWorkPlanSource() == 1) {
                    detail.setWorkPlanSourceName("\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212");
                } else if (detail.getWorkPlanSource() == 2) {
                    detail.setWorkPlanSourceName("\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212");
                }
            }
            detail.setUpdaterName(this.staffInfoService.getFullStaffRealNameAndOrgName(detail.getUpdateBy()));
            if (detail.getUpdateDate() != null) {
                detail.setUpdateTimeStr(detail.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (detail.getCreateBy() != null && detail.getCreateBy().equals(search.getLoginStaffId())) {
                detail.setIsPersonEdit(Boolean.valueOf(true));
                continue;
            }
            if (DataScopeUtils.isPersonDataScope("yearPlan", "" + search.getLoginStaffId())) {
                if (("" + search.getLoginStaffId()).equals("" + detail.getManagerId())) {
                    detail.setIsPersonEdit(Boolean.valueOf(true));
                    continue;
                }
                detail.setIsPersonEdit(Boolean.valueOf(false));
                continue;
            }
            detail.setIsPersonEdit(Boolean.valueOf(true));
        }
        return new PageInfo(list);
    }
}

