/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.planyear;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.planyear.PlanWorkTransferRecordMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkTransferRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkTransferRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PlanWorkTransferRecordServiceImpl
extends BaseServiceImpl<PlanWorkTransferRecordMapper, PlanWorkTransferRecord>
implements IPlanWorkTransferRecordService {
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    IPlanYearDetailService planYearDetailService;
    @Autowired
    IPlanYearService planYearService;

    public PlanWorkTransferRecord getLastExcutorByPlanId(Long planId) {
        Example e = new Example(PlanWorkTransferRecord.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("planId", (Object)planId);
        e.setOrderByClause("transfer_time desc");
        List list = ((PlanWorkTransferRecordMapper)this.dao).selectByExample(e);
        if (list != null && list.size() > 0) {
            return (PlanWorkTransferRecord)list.get(0);
        }
        return null;
    }

    public List<PlanWorkTransferRecord> getListByPlanId(Long planId) {
        Example e = new Example(PlanWorkTransferRecord.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("planId", (Object)planId);
        return ((PlanWorkTransferRecordMapper)this.dao).selectByExample(e);
    }

    public PlanWorkTransferRecord getPlanWorkTransferRecordById(Long id) {
        PlanWorkTransferRecord record = (PlanWorkTransferRecord)this.getById(id);
        if (record != null) {
            if (record.getTransferStaff() != null) {
                record.setTransferStaffName(this.staffInfoService.getFullStaffRealNameAndOrgName(record.getTransferStaff()));
            }
            if (record.getAcceptStaff() != null) {
                record.setAcceptStaffName(this.staffInfoService.getFullStaffRealNameAndOrgName(record.getAcceptStaff()));
            }
            if (record.getTransferTime() != null) {
                record.setTransferTimeStr(record.getTransferTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
            }
        }
        return record;
    }

    public PageInfo<PlanWorkTransferRecord> getPlanWorkTransferRecordListDataPage(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PlanWorkTransferRecord> list = this.getListByPlanId(param.getId());
        for (PlanWorkTransferRecord record : list) {
            PlanWorkTransferRecord db = this.getPlanWorkTransferRecordById(record.getId());
            record.setAcceptStaffName(db.getAcceptStaffName());
            record.setTransferStaffName(db.getTransferStaffName());
            record.setTransferTimeStr(db.getTransferTimeStr());
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public PlanWorkTransferRecord addPlanWorkTransferRecord(PlanWorkTransferRecord record, Long staffId, Long cid, Long detailId) {
        if (record.getTransferStaff() != null && record.getAcceptStaff() != null && !record.getTransferStaff().equals(record.getAcceptStaff())) {
            record.setTransferTime(new Date());
            StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(record.getAcceptStaff());
            if (sbw != null && sbw.getOrgId() != null) {
                record.setOrgId(sbw.getOrgId());
            }
            if (detailId != null) {
                PlanYearDetail detail = new PlanYearDetail();
                detail.setId(detailId);
                detail.setCreateBy(record.getAcceptStaff());
                detail.setCreateDate(new Date());
                this.planYearDetailService.update((Object)detail, staffId);
            }
            if (record.getPlanId() != null) {
                PlanYear planyear = new PlanYear();
                planyear.setId(record.getPlanId());
                planyear.setCreateBy(record.getAcceptStaff());
                planyear.setCreateDate(new Date());
                planyear.setOrgId("" + record.getOrgId());
                this.planYearService.update((Object)planyear, staffId);
            }
            this.add(record, staffId, cid);
        }
        return record;
    }
}

