/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.operate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.operate.WorkOperateLogMapper;
import cn.smarthse.modules.health.entity.work.operate.WorkOperateLog;
import cn.smarthse.modules.health.service.work.operate.ICompanyWorkOperateLogService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyWorkOperateLogServiceImpl
extends BaseServiceImpl<WorkOperateLogMapper, WorkOperateLog>
implements ICompanyWorkOperateLogService {
    @Autowired
    protected IdWorker idworker;

    public PageInfo<WorkOperateLog> getPage(JqGridParam gparam, Long workId) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (workId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<WorkOperateLog> list = this.getList(workId);
        return new PageInfo(list);
    }

    private List<WorkOperateLog> getList(Long workId) {
        Example example = new Example(WorkOperateLog.class);
        example.createCriteria().andEqualTo("workId", (Object)workId).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("create_date desc");
        return ((WorkOperateLogMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void back(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, reason, operaterId, operaterName, WorkOperateLogStatusEnum.back.getVal(), companyName);
    }

    private void addLog(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, Byte status, String companyName) {
        Date now = new Date();
        WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, status, reason, now, operaterName, operaterId, now, operaterId, companyName);
        ((WorkOperateLogMapper)this.dao).insertSelective(log);
    }

    @Transactional(readOnly=false)
    public void report(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.report.getVal(), companyName);
    }

    public Boolean isBack(Long workId, Byte workModule) {
        WorkOperateLog log = ((WorkOperateLogMapper)this.dao).lastWorkOperateBackLog(workId, workModule);
        if (log != null) {
            return true;
        }
        return false;
    }
}

