/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.judge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.judge.OccuptionalJudgeMapper;
import cn.smarthse.modules.health.entity.work.judge.OccuptionalJudge;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.judge.IOccuptionalJudgeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OccuptionalJudgeServiceImpl
extends BaseServiceImpl<OccuptionalJudgeMapper, OccuptionalJudge>
implements IOccuptionalJudgeService {
    @Autowired
    OccuptionalJudgeMapper occuptionalJudgeMapper;
    @Autowired
    private IStaffInfoService staffInfoServcie;

    public boolean hasJudgeCompany(Long cid) {
        if (cid == null) {
            return false;
        }
        OccuptionalJudge record = new OccuptionalJudge();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        int num = ((OccuptionalJudgeMapper)this.dao).selectCount(record);
        return num > 0;
    }

    public OccuptionalJudge lastJudgeStaff(Long staffId) {
        if (staffId == null) {
            return null;
        }
        Example example = new Example(OccuptionalJudge.class);
        example.createCriteria().andEqualTo("judgeStaff", (Object)staffId).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("judge_date desc");
        List list = ((OccuptionalJudgeMapper)this.dao).selectByExample(example);
        return list == null || list.isEmpty() ? null : (OccuptionalJudge)list.get(0);
    }

    @Transactional
    public OccuptionalJudge save(OccuptionalJudge entity, Long loginStaffId, Long cid) {
        if (entity == null) {
            return null;
        }
        entity.setJudgeDate(new Date());
        if (loginStaffId != null) {
            entity.setJudgeStaff(loginStaffId);
            entity.setJudgeStaffName(this.staffInfoServcie.getStaffNameByStaffId(loginStaffId));
        }
        if (entity.getId() == null) {
            super.add(entity, loginStaffId, cid);
        } else {
            super.update(entity, loginStaffId);
        }
        return entity;
    }

    public PageInfo<OccuptionalJudge> judgeFinishedPageInfo(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OccuptionalJudge> list = this.getJudgeList(param.getCid(), StatusEnum.finished);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    private List<OccuptionalJudge> getJudgeList(Long cid, StatusEnum status) {
        if (cid == null) {
            return Collections.emptyList();
        }
        Example example = new Example(OccuptionalJudge.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andEqualTo("cid", (Object)cid);
        if (status != null) {
            criteria.andEqualTo("status", (Object)status.getValue());
        }
        example.setOrderByClause("update_date desc");
        return ((OccuptionalJudgeMapper)this.dao).selectByExample(example);
    }

    public boolean hasFinishedJudge(Long staffId) {
        OccuptionalJudge entity = new OccuptionalJudge();
        entity.setJudgeStaff(staffId);
        entity.setIsValid(Boolean.valueOf(true));
        entity.setStatus(StatusEnum.finished.getValue());
        return ((OccuptionalJudgeMapper)this.dao).selectCount(entity) > 0;
    }
}

