/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.judge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.ms.IMsPohopService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.harmFactorDeclare.IHarmFactorDeclareService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.ContractInformNoRegister;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.PostHarmFactorInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.ThirdTimeInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.judge.WarningSignsSummary;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class JudgeEhsClassificationServiceImpl
implements IJudgeEhsClassificationService {
    @Autowired
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @Autowired
    IPhcPhysicalCheckService phcPhysicalCheckService;
    @Autowired
    IDeviceListViewService deviceListViewService;
    @Autowired
    IShieldPurchaseService shieldPurchaseService;
    @Autowired
    IShieldSendService shieldSendService;
    @Autowired
    IMsInfoService msInfoService;
    @Autowired
    IMsPohopService msPohopService;
    @Autowired
    IWmBaseService wmBaseService;
    @Autowired
    IHarmFactorDeclareService harmFactorDeclareService;
    @Autowired
    ICertificateStaffService certificateStaffService;
    @Autowired
    IHcCheckPlanService hcCheckPlanService;
    @Autowired
    IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @Autowired
    IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    INoInformStaffService noInformStaffService;
    @Autowired
    ICompanyOrganizationService companyOrganizationService;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IContractInformService contractInformService;
    @Autowired
    private ICompanyFunctionalOrganizationService funOrganService;
    @Autowired
    private ICompanyFunctionalOrganizationMemberService memberService;
    @Autowired
    private ISceneInspectionService inspectionService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private ICheckOverPointService checkOverPointService;

    public int getMsInfoCountHasFile(Long cid) {
        int num = this.msInfoService.getMsInfoCountHasFile(cid);
        return num;
    }

    public int getMsPohopCount(Long cid) {
        List msPopList = this.msPohopService.getMsPohopList(cid);
        if (msPopList != null) {
            return msPopList.size();
        }
        return 0;
    }

    public SysFileModel getEstablishFile(Long cid) {
        CompanyFunctionalOrganization funOrg = this.funOrganService.getFunOrgEHS(cid);
        return funOrg != null && funOrg.getEstablishFileList() != null && funOrg.getEstablishFileList().size() > 0 ? (SysFileModel)funOrg.getEstablishFileList().get(0) : null;
    }

    public FunOrganManagerInfo getFunOrganMangerInfo(Long cid) {
        FunOrganManagerInfo vo = new FunOrganManagerInfo();
        CompanyFunctionalOrganization funOrg = this.funOrganService.getFunOrgEHS(cid);
        if (funOrg == null) {
            return vo;
        }
        boolean hasEmployFiles = false;
        List memberList = this.memberService.getMemberListByFunOrgId(funOrg.getId());
        for (CompanyFunctionalOrganizationMember m : memberList) {
            if (FunOrgMemberTypeEnum.special.getCode().equals(m.getMemberType())) {
                vo.setSpecialNum(vo.getSpecialNum() + 1);
            } else if (FunOrgMemberTypeEnum.sideline.getCode().equals(m.getMemberType())) {
                vo.setSidelineNum(vo.getSidelineNum() + 1);
            }
            if (hasEmployFiles || !StringUtils.hasFileId((String)m.getEmployFile())) continue;
            hasEmployFiles = true;
        }
        vo.setHasEmployFile(hasEmployFiles);
        return vo;
    }

    public boolean isFinishedHarmFactorRegularCheck(Long cid, int year) {
        CheckPlan checkPlan = this.checkPlanService.getLatestByEndDateMin(cid, DateUtil.getLocalDateTime((int)(year + 1), (int)1, (int)1, (int)0, (int)0, (int)0));
        return checkPlan != null && checkPlan.getCheckDateBegin().getYear() == year;
    }

    public HcCheckPlan getLastHarmFactorRegularCheck(Long cid, int year) {
        CheckPlan checkPlan = this.checkPlanService.getLatestByEndDateMin(cid, DateUtil.getLocalDateTime((int)(year + 1), (int)1, (int)1, (int)0, (int)0, (int)0));
        if (checkPlan != null && checkPlan.getCheckDateBegin().getYear() == year) {
            HcCheckPlan hc = new HcCheckPlan();
            hc.setId(checkPlan.getId());
            return hc;
        }
        return null;
    }

    public LastHarmFactorTestInfo getLastEvalForHarmFactor(Long cid) {
        return this.hcCheckPlanService.getLastEvalForHarmFactor(cid);
    }

    public LastHarmFactorTestInfo getLastHarmFactorInfo(Long cid) {
        CheckPlan hc = this.checkPlanService.getLatestByEndDateMin(cid, LocalDateTime.now());
        if (hc != null) {
            LastHarmFactorTestInfo last = new LastHarmFactorTestInfo();
            last.setHarmFactorId(hc.getId());
            last.setLastDate(DateUtil.getDate((LocalDateTime)hc.getCheckDateBegin()));
            CheckOverPoint overPoint = (CheckOverPoint)this.checkOverPointService.getById((Serializable)hc.getId());
            if (overPoint != null) {
                last.setInconformityNum(overPoint.getOverPoint().intValue());
            }
            return last;
        }
        return null;
    }

    public int getHarmFactorInformNum(Long cid) {
        return this.hcCheckPlanService.getHarmFactorInformNum(cid);
    }

    public WarningSignsSummary getWarningSingsInfo(Long cid) {
        WarningSignsSummary warnSum = this.wmBaseService.getWarningSignsSummary(cid);
        return warnSum;
    }

    public HarmFactorDeclareInform getHarmFactorDeclareInform(Long cid) {
        HarmFactorDeclareInform info = this.harmFactorDeclareService.getHarmFactorDeclareInform(cid);
        return info;
    }

    public List<ThirdTimeInfo> getThirdTimeInfo(Long cid) {
        return null;
    }

    public ContractInformInfo getContractInformInfo(Long cid) {
        ContractInform inform = new ContractInform();
        inform.setCid(cid);
        inform.setInformState(Long.valueOf(1L));
        Integer count = this.contractInformService.getcontractInformedCountByParam(inform);
        List list = this.noInformStaffService.getContractInformNoRegisterList(cid);
        for (NoInformStaff noInformStaff : list) {
            long staffId = noInformStaff.getStaffId();
            StaffInfo staffInfo = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(Long.valueOf(staffId));
            if (staffInfo == null || staffInfo.getStaffWorkRole() == null || staffInfo.getStaffWorkRole().getWorkRoleId() == null) continue;
            noInformStaff.setWorkName(staffInfo.getStaffWorkRole().getCurrentWorkName());
            noInformStaff.setOrgName(staffInfo.getStaffWorkRole().getWorkRoleInfo().getOrgName());
            List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, staffInfo.getStaffWorkRole().getWorkRoleId());
            HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
            if (harmFactorList != null && harmFactorList.size() > 0) {
                for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                    map.put((CallSite)((Object)("" + v.getHarmId())), v);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (HarmfactorWorkSourceInfoVo vo : map.values()) {
                sb.append(vo.getHarmName());
                sb.append("|");
            }
            if (sb.toString().length() <= 1) continue;
            noInformStaff.setHarmNames(sb.toString().substring(0, sb.length() - 1));
        }
        ContractInformInfo info = new ContractInformInfo();
        info.setInformNum(count.intValue());
        info.setNotRegisterNum(list.size());
        info.setNoInformStaffList(list);
        return info;
    }

    public List<ContractInformNoRegister> getContractInformNoRegisterList(Long cid) {
        ArrayList<ContractInformNoRegister> finalList = new ArrayList<ContractInformNoRegister>();
        List list = this.noInformStaffService.getContractInformNoRegisterList(cid);
        for (NoInformStaff no : list) {
            CompanyOrganization corg;
            ContractInformNoRegister ci = new ContractInformNoRegister();
            if (no.getOrgId() != null && (corg = (CompanyOrganization)this.companyOrganizationService.getById(no.getOrgId())) != null) {
                ci.setDepartment(corg.getOrganizationName());
            }
            if (no.getGender() != null) {
                if (no.getGender() == 1) {
                    ci.setGender("\u7537");
                }
                if (no.getGender() == 0) {
                    ci.setGender("\u5973");
                }
            }
            ci.setStaffId(no.getStaffId());
            ci.setWorkNo(no.getWorkNo());
            ci.setName(no.getRealName());
            if (no.getWorkInfoId() != null) {
                WorkRoleInfo work = (WorkRoleInfo)this.workRoleInfoService.getById(no.getWorkInfoId());
                if (work != null) {
                    if (work.getOrgName() == null) {
                        ci.setPostWork(work.getWorkName() + "/");
                    } else {
                        ci.setPostWork(work.getWorkName() + "/" + work.getOrgName());
                    }
                }
                List harms = this.harmfactorWorkService.getHarmfactorListByWork(cid, no.getWorkInfoId());
                Object harmNames = "";
                if (harms != null && harms.size() > 0) {
                    for (int i = 0; i < harms.size(); ++i) {
                        harmNames = (String)harmNames + ((HarmfactorWorkSourceInfoVo)harms.get(i)).getHarmName();
                        if (i == harms.size() - 1) continue;
                        harmNames = (String)harmNames + ",";
                    }
                }
                ci.setHarmFactorsPostWork(((String)harmNames).replaceAll(",null", ""));
            }
            finalList.add(ci);
        }
        return finalList;
    }

    public int getDeviceOccupationalDiseaseNum(Long cid) {
        Long typePid = 1L;
        return this.deviceListViewService.getDeviceNumByTypePid(cid, typePid);
    }

    public List<ShieldPurchase> getShieldPurchaseList(Long cid) {
        ShieldPurchase data = new ShieldPurchase();
        data.setCid(cid);
        data.setStatus(Byte.valueOf((byte)1));
        return this.shieldPurchaseService.listDetails(data);
    }

    public ShieldSendInfo getShieldSendInfo(Long cid) {
        return this.shieldSendService.getShieldSendInfo(cid);
    }

    public TrainCertificateInfo getTrainCertificateInfo(Long cid) {
        TrainCertificateInfo info = new TrainCertificateInfo();
        List list = this.certificateStaffService.getCertficateListByCid(cid);
        if (list != null && list.size() > 0) {
            for (CertificateStaff staff : list) {
                if (staff.getNameId() == 12L) {
                    if (staff.getStaffs() != null) {
                        info.setManagerTrainCertificateNum(staff.getStaffs().size());
                        info.setManagerTrainCertificateNumValid((int)staff.getStaffs().stream().filter(s -> s.getValidityDate() == null || new Date().getTime() - s.getValidityDate().getTime() < 0L).count());
                    } else {
                        info.setManagerTrainCertificateNum(0);
                        info.setManagerTrainCertificateNumValid(0);
                    }
                }
                if (staff.getNameId() != 13L) continue;
                if (staff.getStaffs() != null) {
                    info.setEhsManagerTrainCertificateNum(staff.getStaffs().size());
                    info.setEhsManagerTrainCertificateNumValid((int)staff.getStaffs().stream().filter(s -> s.getValidityDate() == null || new Date().getTime() - s.getValidityDate().getTime() < 0L).count());
                    continue;
                }
                info.setEhsManagerTrainCertificateNum(0);
                info.setEhsManagerTrainCertificateNumValid(0);
            }
        }
        return info;
    }

    public PhcCheckInfo getPhcCheckInfo(Long cid) {
        return this.phcPhysicalCheckService.getPhcCheckInfo(cid);
    }

    public int getPhcCheckNumJobing(Long cid) {
        return this.phcPhysicalCheckService.getPhcCheckNumJobing(cid);
    }

    public Date getLastPhcCheckDateJobing(Long cid) {
        return this.phcPhysicalCheckService.getLastPhcCheckDateJobing(cid);
    }

    public int getOccupationalDiseasesNum(Long cid) {
        return this.phcOccupationalDiseaserService.getOccupationalDiseasesNum(cid);
    }

    public int getNewOccupationalDiseasesNum(Long cid) {
        Date now = new Date();
        Date endDate = this.getDiseaserEndTime(now);
        Date startDate = this.getgetDiseaserBeginTime(now);
        PhcOccupationalDiseaserParam param = new PhcOccupationalDiseaserParam();
        param.setCid(cid);
        param.setBeginTime(startDate);
        param.setEndTime(endDate);
        return this.phcOccupationalDiseaserService.getNewOccupationalDiseasesNum(param);
    }

    private Date getgetDiseaserBeginTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(1, -3);
        return calendar.getTime();
    }

    private Date getDiseaserEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public int getSuperSceneInspectionNum(Long cid) {
        return this.inspectionService.getSuperSceneInspectionNum(cid, null);
    }

    public int getSuperSceneInspectionNumYear(Long cid) {
        return this.inspectionService.getSuperSceneInspectionNum(cid, Integer.valueOf(Calendar.getInstance().get(1)));
    }

    public PageInfo<PostHarmFactorInfo> getPostHarmFactorInfoPage(JqGridParam param, Long cid) {
        param.setCid(cid);
        PageInfo pageHarmWork = this.harmfactorWorkService.getHarmfactorListGroupByWork(param);
        PageInfo pagePhfInfo = new PageInfo();
        ArrayList<PostHarmFactorInfo> phfInfoList = pagePhfInfo.getList();
        if (phfInfoList == null) {
            phfInfoList = new ArrayList<PostHarmFactorInfo>();
        }
        if (pageHarmWork != null && pageHarmWork.getList() != null && !pageHarmWork.getList().isEmpty()) {
            try {
                BeanUtils.copyProperties((Object)pagePhfInfo, (Object)pageHarmWork);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            for (HarmfactorWorkSourceVo vo : pageHarmWork.getList()) {
                PostHarmFactorInfo phfInfo = new PostHarmFactorInfo();
                phfInfo.setPostId(vo.getWorkId());
                phfInfo.setPostName(vo.getWorkName());
                phfInfo.setHarmFactors(vo.getHarmName());
                ArrayList<Long> workIdList = new ArrayList<Long>();
                workIdList.add(vo.getWorkId());
                Integer staffNum = this.staffWorkRoleService.getCurrentOnWorkStaffCountByWordIds(workIdList, cid);
                phfInfo.setStaffNum(staffNum.intValue());
                phfInfoList.add(phfInfo);
            }
            pagePhfInfo.setList(phfInfoList);
        }
        return pagePhfInfo;
    }

    public int getPostHarmFactorStaffNum(Long cid) {
        List list = this.harmfactorWorkService.getHarmfactorWorkListByCid(cid.longValue());
        ArrayList<Long> workIds = new ArrayList<Long>();
        for (HarmfactorWork h : list) {
            workIds.add(h.getWorkId());
        }
        if (workIds.size() == 0) {
            return 0;
        }
        return this.staffWorkRoleService.getCurrentOnWorkStaffCountByWordIds(workIds, cid);
    }

    public List<String> getHighHarmFactorFromMaterial(Long cid, Integer type) {
        return null;
    }

    public List<String> getHighHarmFactorFromProduct(Long cid, Integer type) {
        return null;
    }

    public List<String> getHighHarmFactorFromWorkPost(Long cid, Integer type) {
        return this.harmfactorWorkService.getOccRiskFactorsNameList(cid, type, "work");
    }

    public List<String> getHighHarmFactorFromWorkPlace(Long cid, Integer type) {
        return this.harmfactorWorkService.getOccRiskFactorsNameList(cid, type, "area");
    }

    public List<String> getHighHarmFactorFromHarmFactorCheck(Long cid, Integer type) {
        return this.hcCheckPlanService.getHighHarmFactorFromHarmFactorCheck(type, cid);
    }
}

