/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.informmanager;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.informmanager.ContractInformTemplateMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInformTemplate;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformTemplateService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ContractInformTemplateServiceImpl
extends BaseServiceImpl<ContractInformTemplateMapper, ContractInformTemplate>
implements IContractInformTemplateService {
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    ContractInformTemplateMapper contractInformTemplateMapper;

    public ContractInformTemplate getContractInformTemplateByWorkId(Long informWorkId, Long cid) {
        Example e = new Example(ContractInformTemplate.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("informWorkId", (Object)informWorkId);
        List list = this.contractInformTemplateMapper.selectByExample(e);
        if (list != null && list.size() > 0) {
            return (ContractInformTemplate)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public ContractInformTemplate addNoValidContractInformTemplate(Long loginStaffId, Long cid, Long org) {
        ContractInformTemplate template = new ContractInformTemplate();
        template.setId(Long.valueOf(this.idworker.nextId()));
        template.setIsValid(Global.FALSE);
        template.setCid(cid);
        template.setCreateBy(loginStaffId);
        template.setCreateDate(new Date());
        template.setOrgId(org);
        this.contractInformTemplateMapper.insert(template);
        return template;
    }

    @Transactional(readOnly=false)
    public Boolean addContractInformTemplateSubmit(ContractInformTemplate template, Long loginStaffId) {
        ContractInformTemplate temp = this.getContractInformTemplateByWorkId(template.getInformWorkId(), template.getCid());
        if (temp != null) {
            return Global.TRUE;
        }
        this.update(template, loginStaffId);
        return Global.FALSE;
    }

    public PageInfo<ContractInformTemplate> getcontractInformTemplateListByJParam(JqGridParam jparam, ContractInformTemplate template) throws Exception {
        if (StringUtils.isEmpty((CharSequence)template.getSearchKey())) {
            template.setSearchKey(null);
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<ContractInformTemplate> list = this.contractInformTemplateMapper.getContractInformTemplateListBySearch(template);
        for (ContractInformTemplate t : list) {
            t.setWorkName(this.workRoleInfoService.getWorkNameIncludeOrgName(t.getInformWorkId()));
            ArrayList factorList = null;
            if (t.getInformWorkId() != null) {
                factorList = this.harmfactorWorkService.getHarmfactorListByWork(t.getCid(), t.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (factorList != null && factorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : factorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                factorList = new ArrayList();
                factorList.addAll(map.values());
            }
            Object factorStrs = "";
            if (factorList != null && factorList.size() > 0) {
                for (int i = 0; i < factorList.size(); ++i) {
                    if (factorList.get(i) == null) continue;
                    factorStrs = (String)factorStrs + ((HarmfactorWorkSourceInfoVo)factorList.get(i)).getHarmName();
                    if (i == factorList.size() - 1) continue;
                    factorStrs = (String)factorStrs + ",";
                }
            }
            t.setHarmFactorNames((String)factorStrs);
            if (t.getUpdateBy() == null) continue;
            t.setUpDatorName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(t.getUpdateBy()));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long loginStaffId, Long cid) {
        String[] idsStr;
        for (String id : idsStr = ids.split(",")) {
            ContractInformTemplate t = new ContractInformTemplate();
            t.setId(Long.valueOf(id));
            this.delete(t, loginStaffId);
        }
    }

    public List<ContractInformTemplate> getcontractInformTemplateListBySearch(ContractInformTemplate template) throws Exception {
        List<ContractInformTemplate> list = this.contractInformTemplateMapper.getContractInformTemplateListBySearch(template);
        for (ContractInformTemplate t : list) {
            StaffInfo updator;
            WorkRoleInfo w = (WorkRoleInfo)this.workRoleInfoService.getById(t.getInformWorkId());
            if (w != null) {
                t.setWorkName(w.getWorkName());
            }
            List factorList = null;
            if (t.getInformWorkId() != null) {
                factorList = this.harmfactorWorkService.getHarmfactorListByWork(t.getCid(), t.getInformWorkId());
            }
            Object factorStrs = "";
            if (factorList != null && factorList.size() > 0) {
                for (int i = 0; i < factorList.size(); ++i) {
                    factorStrs = (String)factorStrs + ((HarmfactorWorkSourceInfoVo)factorList.get(i)).getHarmName();
                    if (i == factorList.size() - 1) continue;
                    factorStrs = (String)factorStrs + ",";
                }
            }
            t.setHarmFactorNames((String)factorStrs);
            if (t.getUpdateBy() == null || (updator = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(t.getUpdateBy())) == null) continue;
            t.setUpDatorName(updator.getStaffBasicInfo().getRealName());
        }
        return list;
    }

    public List<ContractInformTemplate> getcontractInformTemplateListBySearchAndIds(String tempIds, ContractInformTemplate search) {
        List<ContractInformTemplate> list = this.contractInformTemplateMapper.getContractInformTemplateListBySearchAndIds(tempIds, search);
        for (ContractInformTemplate t : list) {
            StaffInfo updator;
            WorkRoleInfo w = (WorkRoleInfo)this.workRoleInfoService.getById(t.getInformWorkId());
            if (w != null) {
                t.setWorkName(w.getWorkName());
            }
            List factorList = null;
            if (t.getInformWorkId() != null) {
                factorList = this.harmfactorWorkService.getHarmfactorListByWork(t.getCid(), t.getInformWorkId());
            }
            Object factorStrs = "";
            if (factorList != null && factorList.size() > 0) {
                for (int i = 0; i < factorList.size(); ++i) {
                    factorStrs = (String)factorStrs + ((HarmfactorWorkSourceInfoVo)factorList.get(i)).getHarmName();
                    if (i == factorList.size() - 1) continue;
                    factorStrs = (String)factorStrs + ",";
                }
            }
            t.setHarmFactorNames((String)factorStrs);
            if (t.getUpdateBy() == null || (updator = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(t.getUpdateBy())) == null) continue;
            t.setUpDatorName(updator.getStaffBasicInfo().getRealName());
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteContractInformTemplateById(Long id, Long loginStaffId, Long cid) {
        ContractInformTemplate template = new ContractInformTemplate();
        template.setId(id);
        this.delete(template, loginStaffId);
    }
}

