/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.informmanager;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.informmanager.ContractInformMapper;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInformTemplate;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.entity.work.informmanager.OccupationalDiseaseContraindication;
import cn.smarthse.modules.health.entity.work.informmanager.vo.ContractInformDocVo;
import cn.smarthse.modules.health.model.HContractInfoModel;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.company.role.ICompanyRoleRelationService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformTemplateService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import cn.smarthse.modules.health.service.work.informmanager.IOccupationalDiseaseContraindicationService;
import cn.smarthse.modules.health.vo.summary.InformManagerSummaryVo;
import cn.smarthse.modules.health.vo.work.informManager.InformManagerFirstPageVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ContractInformServiceImpl
extends BaseServiceImpl<ContractInformMapper, ContractInform>
implements IContractInformService {
    @Autowired
    private ICompanyRoleRelationService companyRoleRelationService;
    @Autowired
    IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @Autowired
    IHcCheckPlanService hcCheckPlanService;
    @Autowired
    ContractInformMapper contractInformMapper;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    ICompanyOrganizationService companyOrganizationService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IContractInformTemplateService contractInformTemplateService;
    @Autowired
    IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    IOccupationalDiseaseContraindicationService occupationalDiseaseContraindicationService;
    @Autowired
    IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    INoInformStaffService noInformStaffService;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @DubboReference
    ISysFileProvideService sysFileService;

    @Transactional(readOnly=false)
    public ContractInform addContractInformSubmit(ContractInform contractInform, Long loginStaffId, Long cid) {
        ContractInformTemplate contractInformTemplate = this.contractInformTemplateService.getContractInformTemplateByWorkId(contractInform.getInformWorkId(), cid);
        if (contractInformTemplate != null) {
            contractInform.setInformTempId(contractInformTemplate.getId());
            contractInform = this.add(contractInform, loginStaffId, cid);
            if (contractInform.getStaffId() != null) {
                contractInform.setStaffInfo(this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            }
            if (contractInform.getInformWorkId() != null) {
                contractInform.setHarmfactorWorks(null);
            }
            return contractInform;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public List<OccupationalDiseaseContraindication> getOccupationalDiseaseContraindicationListFromBaseData(Long templateId, Long workId, Long cid, Long loginStaffId) {
        List list = this.occupationalDiseaseContraindicationService.getBaseListByWorkId(workId, cid);
        boolean isPro = this.companyRoleRelationService.hasProfessionalRole(cid);
        for (OccupationalDiseaseContraindication o : list) {
            Example e = new Example(OccupationalDiseaseContraindication.class);
            e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("harmId", (Object)o.getHarmId()).andEqualTo("templateId", (Object)templateId).andEqualTo("workId", (Object)workId);
            OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(o.getHarmId());
            o.setHarmName(orf == null ? "" : orf.getNameCh());
            List listFromSelf = this.occupationalDiseaseContraindicationService.getListByExample(e);
            if (listFromSelf != null && listFromSelf.size() > 0) {
                for (OccupationalDiseaseContraindication os : listFromSelf) {
                    if (Global.FALSE.equals(os.getIsValid())) {
                        os.setIsValid(Global.TRUE);
                        this.occupationalDiseaseContraindicationService.update((Object)os, loginStaffId);
                    }
                    o.setId(os.getId());
                    o.setContraindication(os.getContraindication());
                    o.setPrecautions(os.getPrecautions());
                    o.setRemark(os.getRemark());
                    o.setDisease(os.getDisease());
                }
                continue;
            }
            o.setTemplateId(templateId);
            if (!isPro) {
                o.setContraindication(null);
                o.setDisease(null);
                o.setPrecautions(null);
            }
            this.logger.info("\u5408\u540c\u544a\u77e5\u6a21\u677f\u83b7\u53d6\u6570\u636ejson\uff084\uff09==" + o.getDisease());
            this.occupationalDiseaseContraindicationService.add((Object)o, loginStaffId, cid);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void editOccupationalDiseaseContraindicationSubmit(OccupationalDiseaseContraindication o, Long loginStaffId) {
        this.occupationalDiseaseContraindicationService.update((Object)o, loginStaffId);
    }

    public OccupationalDiseaseContraindication getOccupationalDiseaseContraindication(Long id) {
        OccupationalDiseaseContraindication o;
        OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById((o = (OccupationalDiseaseContraindication)this.occupationalDiseaseContraindicationService.getById(id)).getHarmId());
        o.setHarmName(orf == null ? "" : orf.getNameCh());
        return o;
    }

    public PageInfo<ContractInform> getcontractInformListByJParam(JqGridParam jparam, ContractInform inform) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("informingmanagement", "contract_inform");
        inform.setSearchKeyEncrypt(inform.getSearchKey());
        List<ContractInform> list = this.contractInformMapper.getContractInformListBySearch(inform);
        for (ContractInform ci : list) {
            if (ci.getInformWorkId() != null) {
                ci.setWorkName(this.workRoleInfoService.getWorkNameIncludeOrgName(ci.getInformWorkId()));
            }
            ci.setRealName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(ci.getStaffId()));
        }
        return new PageInfo(list);
    }

    public Integer getcontractInformedCountByParam(ContractInform inform) {
        inform.setSearchKeyEncrypt(inform.getSearchKey());
        List<ContractInform> list = this.contractInformMapper.getContractInformListBySearch(inform);
        return list.size();
    }

    public ContractInform getContractInformById(Long id) {
        ContractInform contractInform = (ContractInform)this.getById(id);
        if (contractInform != null) {
            // empty if block
        }
        return contractInform;
    }

    public PageInfo<NoInformStaff> getNoInformStaffLisByJParam(JqGridParam jparam, NoInformStaff noInformStaff) throws Exception {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        if (noInformStaff.getOrgIds() != null && noInformStaff.getOrgIds().size() > 0) {
            noInformStaff.setOrgIdsStr(Arrays.toString(noInformStaff.getOrgIds().toArray()).replace("[", "").replace("]", "").replace(" ", ""));
        }
        List list = this.noInformStaffService.getNoInformStaffLisBySearchV24(noInformStaff);
        for (NoInformStaff n : list) {
            n.setRealName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(n.getStaffId()));
            n.setOrgName(this.companyOrganizationService.getOrgNameById(n.getOrgId()));
            n.setWorkName(this.workRoleInfoService.getWorkNameIncludeOrgName(n.getWorkInfoId()));
            List harms = this.harmfactorWorkService.getHarmfactorListByWork(noInformStaff.getCid(), n.getWorkInfoId());
            Object harmNames = "";
            if (harms != null && harms.size() > 0) {
                for (int i = 0; i < harms.size(); ++i) {
                    harmNames = (String)harmNames + ((HarmfactorWorkSourceInfoVo)harms.get(i)).getHarmName();
                    if (i == harms.size() - 1) continue;
                    harmNames = (String)harmNames + ",";
                }
            }
            n.setHarmNames((String)harmNames);
        }
        return new PageInfo(list);
    }

    public InformManagerFirstPageVo getInformManagerFirstPageVoData(Long cid) {
        InformManagerFirstPageVo vo = new InformManagerFirstPageVo();
        ContractInform ci = new ContractInform();
        ci.setCid(cid);
        ci.setInformState(Long.valueOf(0L));
        ci.setSearchKeyEncrypt(ci.getSearchKey());
        DataScopeHelper.startDataScope("informingmanagement", "contract_inform");
        vo.setUnderwayInformCount(Integer.valueOf(this.contractInformMapper.getContractInformListBySearch(ci).size()));
        NoInformStaff noStaff = new NoInformStaff();
        noStaff.setCid(cid);
        vo.setUnderwayInformPersonCount(Integer.valueOf(this.noInformStaffService.getNoInformStaffLisBySearchV24(noStaff).size()));
        return vo;
    }

    public InformManagerSummaryVo getSummaryData(Long cid, String year) {
        InformManagerSummaryVo vo = new InformManagerSummaryVo();
        vo.setInformedHealthCount(this.phcPhysicalCheckCountService.checkConfiredTimes(cid, year));
        vo.setInformedHcCheckCount(this.hcCheckPlanService.getInformedHcCheckCountByCidAndYear(cid, year));
        vo.setInformedContract(this.contractInformMapper.getInformedContractCount(cid, year));
        vo.setOccDiagnosisCount(this.phcPhysicalCheckCountService.getConfirmedCountByYear(cid, year));
        return vo;
    }

    public List<ContractInformDocVo> getContractInformDocVoByCidAndYear(String year, Long cid) {
        ContractInform inform = new ContractInform();
        inform.setCid(cid);
        inform.setInformState(Long.valueOf(1L));
        inform.setSearchKeyEncrypt(inform.getSearchKey());
        List<ContractInform> listFromData = this.contractInformMapper.getContractInformListBySearch(inform);
        ArrayList<ContractInformDocVo> list = new ArrayList<ContractInformDocVo>();
        for (ContractInform ci : listFromData) {
            SysFileModel sysFile;
            if (!year.equals("" + DateUtils.getYear((Date)ci.getInformDate()))) continue;
            ContractInformDocVo vo = new ContractInformDocVo();
            vo.setRealName(this.staffInfoService.getHistroyRealNameByIdAndYear(ci.getStaffId(), DateUtils.getYearLastDay((int)Integer.valueOf(year))));
            StaffBasicWork basicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(ci.getStaffId());
            vo.setWorkName(this.workRoleInfoService.getHistoryWorkNameIncludeOrgNameByWorkIdAndYear(ci.getInformWorkId(), DateUtils.getYearLastDay((int)Integer.valueOf(year))));
            if (basicWork != null) {
                vo.setWorkNo(basicWork.getWorkNo());
            }
            vo.setReaSonName(ci.getInformReasonStr());
            if (ci.getPaperFileId() != null && (sysFile = this.sysFileService.getFileById(ci.getPaperFileId())) != null) {
                vo.setFileUrl(sysFile.getOssUrl());
                vo.setAttachment(sysFile);
                vo.setInformFileName(sysFile.getFileName());
            }
            vo.setInformDate(ci.getInformDate());
            list.add(vo);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public ContractInform informContractInformFromWorkChange(ContractInform inform, Long loginStaffId, Long cid) {
        ContractInformTemplate contractInformTemplate = this.contractInformTemplateService.getContractInformTemplateByWorkId(inform.getInformWorkId(), cid);
        if (contractInformTemplate != null) {
            inform.setInformTempId(contractInformTemplate.getId());
            inform = this.add(inform, loginStaffId, cid);
            if (inform.getStaffId() != null) {
                inform.setStaffInfo(this.staffInfoService.getStaffInfoWithStaffBasicWorkById(inform.getStaffId()));
            }
            if (inform.getInformWorkId() != null) {
                inform.setHarmfactorWorks(null);
            }
            return inform;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public ContractInform updateContractInformSubmit(ContractInform contractInform, Long loginStaffId) {
        this.update(contractInform, loginStaffId);
        return contractInform;
    }

    public Long getContractInformLastNewIdByStaffIdAndWorkId(Long staffId, Long workId, Long cid, Date beginTime, Date endTime) {
        if (endTime == null) {
            endTime = new Date();
        }
        Long id = this.contractInformMapper.getContractInformLastNewIdByStaffIdAndWorkId(staffId, workId, cid, beginTime, endTime);
        return id;
    }

    @Transactional(readOnly=false)
    public ContractInform addNewContractInformSubmit(ContractInform contractInform, Long loginStaffId, Long cid) {
        contractInform = contractInform.getId() == null ? this.add(contractInform, loginStaffId, cid) : this.updateContractInformSubmit(contractInform, loginStaffId);
        return contractInform;
    }

    public List<HContractInfoModel> getContractInformByStaffIdsAndWorkIdsAndCid(String staffIds, String workIds, Long cid) {
        return this.contractInformMapper.getContractInformByStaffIdsAndWorkIdsAndCid(staffIds, workIds, cid);
    }

    public List<ContractInform> getcontractInformListByParam(ContractInform inform) {
        inform.setSearchKeyEncrypt(inform.getSearchKey());
        List<ContractInform> list = this.contractInformMapper.getContractInformListBySearch(inform);
        for (ContractInform ci : list) {
            if (ci.getInformWorkId() != null) {
                ci.setWorkName(this.workRoleInfoService.getWorkNameIncludeOrgName(ci.getInformWorkId()));
            }
            ci.setRealName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(ci.getStaffId()));
        }
        return list;
    }
}

