/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.hccheckplan;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.hccheckplan.HcCheckResultReportMapper;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultReport;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckType;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckAttachment;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultReportService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HcCheckResultReportServiceImpl
extends BaseServiceImpl<HcCheckResultReportMapper, HcCheckResultReport>
implements IHcCheckResultReportService {
    @Autowired
    private IHcCheckTypeService hcCheckTypeService;
    @DubboReference
    ISysFileProvideService sysFileService;
    @Autowired
    HcCheckResultReportMapper hcCheckResultReportMapper;
    @Autowired
    IHcCheckPlanService hcCheckPlanService;
    @Autowired
    IStaffInfoService staffInfoService;

    public PageInfo<HcCheckResultReport> getHcCheckResultReportListBySearchParam(JqGridParam jparam, HcCheckResultReport report) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<HcCheckResultReport> list = this.hcCheckResultReportMapper.getHcCheckResultReportListBySearchParam(report);
        for (HcCheckResultReport hr : list) {
            if (hr.getHcId() != null) {
                HcCheckPlan hp = this.hcCheckPlanService.getHcCHeckPlanById(hr.getHcId());
                if (hp != null) {
                    hr.setCheckDate(hp.getCheckTime());
                    hr.setCheckTypeName(hp.getCheckTypeName());
                }
                hr.setHcCheckPlan(hp);
            }
            if (hr.getUpdateBy() == null) continue;
            hr.setUpdator(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(hr.getUpdateBy()));
        }
        return new PageInfo(list);
    }

    public Integer getHcCheckResultReportingCountList(Long cid) {
        HcCheckResultReport report = new HcCheckResultReport();
        report.setCid(cid);
        report.setIsValid(Global.TRUE);
        report.setStatus(Byte.valueOf((byte)0));
        List<HcCheckResultReport> list = this.hcCheckResultReportMapper.getHcCheckResultReportListBySearchParam(report);
        return list.size();
    }

    @Transactional(readOnly=false)
    public HcCheckResultReport addHcCheckResultReportSubmit(HcCheckResultReport report, Long loginStaffId, Long cid) {
        HcCheckPlan old = (HcCheckPlan)this.hcCheckPlanService.getById(report.getHcId());
        if (old != null && old.getIsResultReport() != null && Global.FALSE.booleanValue() == old.getIsResultReport().booleanValue()) {
            this.add(report, loginStaffId, cid);
            HcCheckPlan hc = new HcCheckPlan();
            hc.setIsResultReport(Global.TRUE);
            hc.setId(report.getHcId());
            this.hcCheckPlanService.update((Object)hc);
        }
        return report;
    }

    @Transactional(readOnly=false)
    public HcCheckResultReport updateHcCheckResultReportSubmit(HcCheckResultReport report, Long loginStaffId) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setIsResultReport(Global.TRUE);
        hc.setId(report.getHcId());
        this.hcCheckPlanService.update((Object)hc);
        this.update(report, loginStaffId);
        return report;
    }

    @Transactional(readOnly=false)
    public HcCheckResultReport updateAdminHcCheckResultReportSubmit(HcCheckResultReport report, Long loginStaffId) {
        HcCheckResultReport oldReport = (HcCheckResultReport)this.getById(report.getId());
        if (!report.getHcId().equals(oldReport.getHcId())) {
            oldReport.setId(null);
            oldReport.setStatus(Byte.valueOf((byte)0));
            this.add(oldReport);
        }
        HcCheckPlan hc = new HcCheckPlan();
        hc.setIsResultReport(Global.TRUE);
        hc.setId(report.getHcId());
        this.hcCheckPlanService.update((Object)hc);
        this.update(report, loginStaffId);
        return report;
    }

    @Transactional(readOnly=false)
    public void deleteHcCheckResultReportById(Long id, Long loginStaffId) {
        HcCheckResultReport report = (HcCheckResultReport)this.getById(id);
        if (report != null) {
            this.delete(report, loginStaffId);
            HcCheckPlan hc = (HcCheckPlan)this.hcCheckPlanService.getById(report.getHcId());
            if (hc != null) {
                hc.setIsResultReport(Global.FALSE);
                this.hcCheckPlanService.update((Object)hc);
            }
        }
    }

    @Transactional(readOnly=false)
    public void deleteAdminHcCheckResultReportSubmit(Long id, Long loginStaffId) {
        HcCheckResultReport report = new HcCheckResultReport();
        report.setId(id);
        report.setStatus(Byte.valueOf((byte)0));
        this.update(report);
    }

    public HcCheckResultReport getHcCheckResultReportById(Long id) {
        HcCheckResultReport hr = (HcCheckResultReport)this.getById(id);
        if (hr != null) {
            if (hr.getHcId() != null) {
                HcCheckPlan hp = this.hcCheckPlanService.getHcCHeckPlanById(hr.getHcId());
                hr.setHcCheckPlan(hp);
            }
            if (hr.getUpdateBy() != null) {
                hr.setUpdator(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(hr.getUpdateBy()));
            }
        }
        return hr;
    }

    public Integer getNoReportHcCheckPlansCount(Long cid) {
        Integer count = this.hcCheckResultReportMapper.getNoReportHcCheckPlansCount(cid);
        return count;
    }

    public List<HcCheckResultReport> getHcCheckResultReportsBycid(Long cid, int year) {
        HcCheckResultReport report = new HcCheckResultReport();
        report.setCid(cid);
        report.setStatus(Byte.valueOf((byte)1));
        List<HcCheckResultReport> list = this.hcCheckResultReportMapper.getHcCheckResultReportListBySearchParam(report);
        ArrayList<HcCheckResultReport> newList = new ArrayList<HcCheckResultReport>();
        for (HcCheckResultReport hr : list) {
            String checkTime = "";
            if (hr.getHcId() != null) {
                HcCheckType type;
                HcCheckPlan hp = (HcCheckPlan)this.hcCheckPlanService.getById(hr.getHcId());
                if (hp == null || hp.getCheckTimeBegin() == null || DateUtils.getYear((Date)hp.getCheckTimeBegin()) != year) continue;
                if (hp.getCheckTimeBegin() != null) {
                    checkTime = DateUtils.formatDate((Date)hp.getCheckTimeBegin());
                }
                hr.setCheckDate(checkTime + "\u81f3");
                if (hp.getCheckTimeEnd() != null) {
                    hr.setCheckDate(hr.getCheckDate() + DateUtils.formatDate((Date)hp.getCheckTimeEnd()));
                }
                if (hp.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(hp.getCheckType())) != null) {
                    hr.setCheckTypeName(type.getCheckTypeName());
                }
                hr.setHcCheckPlan(hp);
            }
            if (hr.getUpdateBy() != null) {
                hr.setUpdator(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(hr.getUpdateBy()));
            }
            if (StringUtils.isNotEmpty((String)hr.getReportFileIds())) {
                String[] fileIds;
                ArrayList<HcCheckAttachment> attachments = new ArrayList<HcCheckAttachment>();
                for (String fileId : fileIds = hr.getReportFileIds().split(",")) {
                    HcCheckAttachment attachment = new HcCheckAttachment();
                    attachment.setFileId(Long.valueOf(fileId));
                    SysFileModel sysFile = this.sysFileService.getFileById(Long.valueOf(fileId));
                    if (sysFile != null) {
                        attachment.setAttachmentName(sysFile.getFileName());
                        attachment.setOssUrl(sysFile.getOssUrl());
                        attachment.setSysFile(sysFile);
                    }
                    attachments.add(attachment);
                }
                hr.setAttachments(attachments);
            }
            newList.add(hr);
        }
        return newList;
    }

    public List<HcCheckResultReport> exportHcCheckPlanReportResultStatData(HcCheckResultReport report) {
        List<HcCheckResultReport> list = this.hcCheckResultReportMapper.getHcCheckResultReportListBySearchParam(report);
        for (int i = 0; i < list.size(); ++i) {
            HcCheckPlan hp;
            HcCheckResultReport hr = list.get(i);
            hr.setId(Long.valueOf((long)i + 1L));
            if (hr.getHcId() != null && (hp = this.hcCheckPlanService.getHcCHeckPlanById(hr.getHcId())) != null) {
                hr.setCheckDate(hp.getCheckTime());
                hr.setCheckTypeName(hp.getCheckTypeName());
                hr.setCheckOrgName(hp.getCheckWorkName());
            }
            if (hr.getReportDate() == null) continue;
            hr.setUpdator(DateUtils.format((Date)hr.getReportDate(), (String)"yyyy-MM-dd"));
        }
        return list;
    }

    public PageInfo<HcCheckResultReport> getHcCheckResultReportListIncludeNulltiyBySearchParam(JqGridParam jparam, HcCheckResultReport report) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_result_report");
        List<HcCheckResultReport> list = this.hcCheckResultReportMapper.getHcCheckResultReportListIncludeNulltiyBySearchParam(report);
        for (HcCheckResultReport hr : list) {
            if (hr.getHcId() != null) {
                HcCheckPlan hp = this.hcCheckPlanService.getHcCHeckPlanById(hr.getHcId());
                if (hp != null) {
                    hr.setCheckDate(hp.getCheckTime());
                    hr.setCheckTypeName(hp.getCheckTypeName());
                }
                hr.setHcCheckPlan(hp);
            }
            if (hr.getUpdateBy() == null) continue;
            hr.setUpdator(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(hr.getUpdateBy()));
        }
        return new PageInfo(list);
    }
}

