/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.hccheckplan;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.hccheckplan.HcCheckResultCollectMapper;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultCollect;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HcCheckResultCollectServiceImpl
extends BaseServiceImpl<HcCheckResultCollectMapper, HcCheckResultCollect>
implements IHcCheckResultCollectService {
    @Autowired
    HcCheckResultCollectMapper hcCheckResultCollectMapper;

    public List<HcCheckResultCollect> getHcCheckResultCollectListByhcId(Long hcId, Long cid) {
        Example e = new Example(HcCheckResultCollect.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        e.orderBy("collectType");
        List list = this.hcCheckResultCollectMapper.selectByExample(e);
        HashMap<CallSite, HcCheckResultCollect> map = new HashMap<CallSite, HcCheckResultCollect>();
        String[] collectTypeStrs = new String[]{"1", "2", "4", "12", "10", "11", "9", "5", "7", "6", "8", "13", "3", "14", "15", "17", "16"};
        for (HcCheckResultCollect h : list) {
            map.put((CallSite)((Object)("" + h.getCollectType())), h);
        }
        ArrayList<HcCheckResultCollect> newList = new ArrayList<HcCheckResultCollect>();
        for (String s : collectTypeStrs) {
            HcCheckResultCollect h = (HcCheckResultCollect)map.get(s);
            if (h == null) continue;
            newList.add(h);
        }
        return newList;
    }

    @Transactional(readOnly=false)
    public void addHcCheckResultCollectSubmit(Long hcId, String[] collectTypes, Long cid, Long loginStaffId) {
        Example e = new Example(HcCheckResultCollect.class);
        HcCheckResultCollect hrc = new HcCheckResultCollect();
        hrc.setIsValid(Global.FALSE);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        this.hcCheckResultCollectMapper.updateByExampleSelective(hrc, e);
        e = new Example(HcCheckResultCollect.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        List list = this.hcCheckResultCollectMapper.selectByExample(e);
        HashMap<CallSite, HcCheckResultCollect> map = new HashMap<CallSite, HcCheckResultCollect>();
        if (list != null && list.size() > 0) {
            for (HcCheckResultCollect h : list) {
                map.put((CallSite)((Object)("" + h.getCollectType())), h);
            }
        }
        for (String s : collectTypes) {
            if (map.get(s) != null) {
                ((HcCheckResultCollect)map.get(s)).setIsValid(Global.TRUE);
                this.update((HcCheckResultCollect)map.get(s), loginStaffId);
                continue;
            }
            HcCheckResultCollect h = new HcCheckResultCollect();
            h.setIsValid(Global.TRUE);
            h.setCollectType(Byte.valueOf(s));
            h.setCid(cid);
            h.setHcId(hcId);
            this.add(h, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public HcCheckResultCollect getHcCheckResultCollectByhcIdAndCollectType(Long hcId, Byte collectType, Long cid, Long loginStaffId) {
        Example e = new Example(HcCheckResultCollect.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId).andEqualTo("collectType", (Object)collectType);
        List list = this.hcCheckResultCollectMapper.selectByExample(e);
        if (list != null && list.size() > 0) {
            if (!((HcCheckResultCollect)list.get(0)).getIsValid().booleanValue()) {
                ((HcCheckResultCollect)list.get(0)).setIsValid(Global.TRUE);
                this.updateByPrimaryKey((HcCheckResultCollect)list.get(0), loginStaffId);
            }
            return (HcCheckResultCollect)list.get(0);
        }
        HcCheckResultCollect h = new HcCheckResultCollect();
        h.setIsValid(Global.TRUE);
        h.setCollectType(collectType);
        h.setCid(cid);
        h.setHcId(hcId);
        this.add(h, loginStaffId, cid);
        return h;
    }

    public List<Long> getAllHcCheckPlanIdsByCollectTypes(String collectTypes, Long cid) {
        return this.hcCheckResultCollectMapper.getAllHcCheckPlanIdsByCollectTypes(collectTypes, cid);
    }
}

