/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.hccheckplan;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.hccheckplan.HcCheckPlanMapper;
import cn.smarthse.modules.health.dao.work.hccheckplan.HcCheckResultCollectDataMapper;
import cn.smarthse.modules.health.dao.work.hccheckplan.HcCheckTypeMapper;
import cn.smarthse.modules.health.dao.work.hccheckplan.SelectNoAccordCheckDataMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyBaseInfo;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorHccheckplanunderway;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlanQueryParam;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultDataPublicVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultReport;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckThirdOrg;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckType;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectBiologicalFactorV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectChemicalV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectDustV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectEhighFrequencyV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHandTransmittedVibrationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHighTemperatureV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectIonizingradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectLaserRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectMicrowaveradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectNoiseV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectPowerFrequencyElectricFieldV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUhfRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUltravioletlightV;
import cn.smarthse.modules.health.entity.work.hccheckplan.SelectNoAccordCheckData;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HarmCheckRateVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckAttachment;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckBiologicalConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckBiologicalConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckChemicalConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckChemicalConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectMicrowaveradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectPowerfrequencyConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectUltravioletlightConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckDustConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckDustConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckEvaluateOrCheckFileVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckEvaluateReportVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHandtransmittedConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHarmConcentrationForWorkEveryYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHighFrequencyConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHightemperatureConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckIonizingradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckLaserradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckNoiseConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckPointMapVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckUltrahighfrequencyradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcResultCertificateVo;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasicHarmFactor;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckPlanStatusEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckServiceTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcQuarterEnum;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.impl.company.CompanyBaseInfoServiceImpl;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultReportService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckTypeService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.summary.HcCheckPlanSummaryVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountDailyPageParamVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountDailyPageVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountInfoVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountMonthVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanFirstPageVo;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HcCheckPlanServiceImpl
extends BaseServiceImpl<HcCheckPlanMapper, HcCheckPlan>
implements IHcCheckPlanService {
    @Autowired
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @Autowired
    private IHcCheckTypeService hcCheckTypeService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @Autowired
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    HcCheckTypeMapper hcCheckTypeMapper;
    @Autowired
    HcCheckPlanMapper hcCheckPlanMapper;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private SelectNoAccordCheckDataMapper selectNoAccordCheckDataMapper;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private HcCheckResultCollectDataMapper hcCheckResultCollectDataMapper;
    @Autowired
    private IHcCheckResultReportService hcCheckResultReportService;
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IHarmfactorAreaSourceService harmfactorAreaService;
    @Autowired
    private IBusinessNoService businessNoService;
    @Autowired
    private CompanyBaseInfoServiceImpl companyBaseInfoServiceImpl;
    @Autowired
    private IHcCheckThirdOrgService hcCheckThirdOrgService;
    @DubboReference
    private ICheckPlanService checkPlanService;

    @Transactional(readOnly=false)
    public HcCheckPlan addHcCheckPlanSubmit(HcCheckPlan hc, Long loginStaffId, Long cid, Long orgId) {
        int i;
        Long[] reformIds;
        String[] reformIdStrs;
        if (hc.getId() == null) {
            return null;
        }
        HcCheckPlan fromData = (HcCheckPlan)this.getById(hc.getId());
        if (hc.getCheckPointMapFileIds() == null && (fromData.getCheckDataSource() == 1 || fromData.getCheckDataSource() == 4)) {
            hc.setCheckPointMapFileIds("");
        }
        if (hc.getCheckResultCertificateFileIds() == null) {
            hc.setCheckResultCertificateFileIds("");
        }
        if (hc.getId() != null) {
            if (!(hc.getStatus() != 2 || hc.getIsResultReport() != null && hc.getIsResultReport().booleanValue())) {
                hc.setIsResultReport(Global.TRUE);
                report = new HcCheckResultReport();
                report.setHcId(hc.getId());
                report.setStatus(Byte.valueOf((byte)0));
                report.setOrgId(orgId);
                this.hcCheckResultReportService.add((Object)report, loginStaffId, cid);
            }
            this.update(hc, loginStaffId);
        } else {
            hc.setIsResultReport(Global.FALSE);
            if (hc.getStatus() == 2 && !hc.getIsResultReport().booleanValue()) {
                hc.setIsResultReport(Global.TRUE);
                report = new HcCheckResultReport();
                report.setHcId(hc.getId());
                report.setStatus(Byte.valueOf((byte)0));
                report.setOrgId(orgId);
                this.hcCheckResultReportService.add((Object)report, loginStaffId, cid);
            }
            this.add(hc, loginStaffId, cid);
        }
        if (hc.getCheckPlanType() != null && hc.getCheckPlanType().intValue() == 3 && StringUtils.isNotEmpty((String)hc.getReformItemIds())) {
            reformIdStrs = hc.getReformItemIds().split(",");
            reformIds = new Long[reformIdStrs.length];
            for (i = 0; i < reformIdStrs.length; ++i) {
                reformIds[i] = Long.valueOf(reformIdStrs[i]);
                this.reformItemBasicService.reformItemRetest(reformIds[i], loginStaffId);
            }
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.CHECKING.getCode() && hc.getFromBusinessType() != null) {
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.accidentManement.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorTest, CoreWorkEnum.accidentManement, hc.getId(), loginStaffId, cid, null);
            }
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.evaluate.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorTest, CoreWorkEnum.evaluate, hc.getId(), loginStaffId, cid, new Long[]{hc.getFromBusinessId()});
            }
            if (hc.getCheckPlanType() != null && hc.getCheckPlanType().intValue() == 3 && StringUtils.isNotEmpty((String)hc.getReformItemIds())) {
                reformIdStrs = hc.getReformItemIds().split(",");
                reformIds = new Long[reformIdStrs.length];
                for (i = 0; i < reformIdStrs.length; ++i) {
                    reformIds[i] = Long.valueOf(reformIdStrs[i]);
                }
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorTest, CoreWorkEnum.reformManagement, hc.getId(), loginStaffId, cid, reformIds);
            }
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.threeSimultaneityManagement.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorTest, CoreWorkEnum.threeSimultaneityManagement, hc.getId(), loginStaffId, cid, new Long[]{hc.getFromBusinessId()});
            }
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.CHECKED.getCode() && hc.getFromBusinessType() != null) {
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.accidentManement.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorTest, CoreWorkEnum.accidentManement, hc.getId(), loginStaffId, cid, null);
            }
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.evaluate.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorTest, CoreWorkEnum.evaluate, hc.getId(), loginStaffId, cid, new Long[]{hc.getFromBusinessId()});
            }
            if (hc.getCheckPlanType() != null && hc.getCheckPlanType().intValue() == 3 && StringUtils.isNotEmpty((String)hc.getReformItemIds())) {
                reformIdStrs = hc.getReformItemIds().split(",");
                reformIds = new Long[reformIdStrs.length];
                for (i = 0; i < reformIdStrs.length; ++i) {
                    reformIds[i] = Long.valueOf(reformIdStrs[i]);
                }
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorTest, CoreWorkEnum.reformManagement, hc.getId(), loginStaffId, cid, reformIds);
            }
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.threeSimultaneityManagement.getValue().byteValue()) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorTest, CoreWorkEnum.threeSimultaneityManagement, hc.getId(), loginStaffId, cid, new Long[]{hc.getFromBusinessId()});
            }
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.NULLIFY.getCode() && hc.getFromBusinessType() != null) {
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.accidentManement.getValue().byteValue()) {
                // empty if block
            }
            if (hc.getCheckPlanType() != null && hc.getCheckPlanType().intValue() == 3 && StringUtils.isNotEmpty((String)hc.getReformItemIds())) {
                reformIdStrs = hc.getReformItemIds().split(",");
                reformIds = new Long[reformIdStrs.length];
                for (i = 0; i < reformIdStrs.length; ++i) {
                    reformIds[i] = Long.valueOf(reformIdStrs[i]);
                }
            }
            if (hc.getFromBusinessType().byteValue() == CoreWorkEnum.threeSimultaneityManagement.getValue().byteValue()) {
                // empty if block
            }
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.CHECKED.getCode()) {
            this.sysCoreWorkModuleCorrelationService.addHarmFactorManagerTodolistInfo(CoreWorkEnum.harmfactorTest, hc.getId(), hc.getCheckWorkName(), loginStaffId, cid);
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.CHECKED.getCode() && fromData.getCheckDataSource() != null && (fromData.getCheckDataSource() == 2 || fromData.getCheckDataSource() == 3)) {
            this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorTest, CoreWorkEnum.harmfactorTest, null, loginStaffId, cid, new Long[]{hc.getId()});
        }
        if (hc.getStatus() == HcCheckPlanStatusEnum.CHECKED.getCode()) {
            this.logger.error("\u534e\u4e1ccid==" + cid + "\u534e\u4e1chcId==" + hc.getId() + "loginStaffId==" + loginStaffId);
            this.sysCoreWorkModuleCorrelationService.businessCompletePlan(CoreWorkEnum.harmfactorTest, hc.getId(), loginStaffId, cid, hc.getCheckWorkName());
        }
        return hc;
    }

    @Transactional(readOnly=false)
    public HcCheckPlan editHcCheckPlanSubmitAdmin(HcCheckPlan hc, Long loginStaffId, Long cid) {
        if (hc.getCheckPointMapFileIds() == null) {
            hc.setCheckPointMapFileIds("");
        }
        if (hc.getCheckResultCertificateFileIds() == null) {
            hc.setCheckResultCertificateFileIds("");
        }
        if (hc.getCheckReportName() == null) {
            hc.setCheckReportName("");
        }
        if (hc.getCheckEvaluateReportName() == null) {
            hc.setCheckEvaluateReportName("");
        }
        if (hc.getEvaluateOrCheckFile() == null) {
            hc.setEvaluateOrCheckFile("");
        }
        this.update(hc, loginStaffId);
        return hc;
    }

    @Transactional(readOnly=false)
    public HcCheckPlan addIsNotValidHcCheckPlan(Long cid, Long loginStaffId, Long orgId) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setIsValid(Global.FALSE);
        hc.setCid(cid);
        hc.setCreateBy(loginStaffId);
        hc.setCreateDate(new Date());
        hc.setIsResultReport(Global.FALSE);
        hc.setId(Long.valueOf(this.idworker.nextId()));
        hc.setCheckDataSource(Byte.valueOf((byte)1));
        hc.setOrgId(orgId);
        this.hcCheckPlanMapper.insert(hc);
        return hc;
    }

    public PageInfo<HcCheckPlan> getHcCheckPlanCompletedByTimeRange(JqGridParam jparam, Date startTime, Date endTime, Long cid) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStartTime(startTime);
        hc.setEndTime(endTime);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List postDatas = jparam.getPostDatas();
        String harmNameOrSamplePoint = null;
        if (postDatas != null && !postDatas.isEmpty()) {
            for (ParamSeachFieldVO postData : postDatas) {
                if ("searchKey".equals(postData.getSearchField())) {
                    hc.setSearchKey(postData.getSearchValue());
                }
                if ("startTime".equals(postData.getSearchField())) {
                    hc.setStartTime(DateUtils.StringToDate((String)postData.getSearchValue()));
                }
                if ("endTime".equals(postData.getSearchField())) {
                    hc.setEndTime(DateUtils.StringToDate((String)postData.getSearchValue()));
                }
                if (!"harmNameOrSamplePoint".equals(postData.getSearchField())) continue;
                harmNameOrSamplePoint = postData.getSearchValue();
            }
        }
        return this.getHcCheckPlanListForHarmManageBySearchParam(jparam, hc, harmNameOrSamplePoint);
    }

    private PageInfo<HcCheckPlan> getHcCheckPlanListForHarmManageBySearchParam(JqGridParam jparam, HcCheckPlan hc, String harmNameOrSamplePoint) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListForHarmManageBySearchParam(hc, harmNameOrSamplePoint);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
        }
        return new PageInfo(list);
    }

    public PageInfo<HcCheckPlan> getHcCheckPlanListBySearchParam(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public ReformItemBasicHarmFactor saveReformItemBasicFromHarmFactor(ReformItemBasicHarmFactor entity, Long cid, Long loginStaffId, String batch) {
        ReformItemBasicHarmFactor rtf = this.reformItemBasicService.saveReformItemBasicFromHarmFactor(entity, cid, loginStaffId);
        Example e = new Example(SelectNoAccordCheckData.class);
        e.createCriteria().andEqualTo("batch", (Object)batch);
        SelectNoAccordCheckData data = new SelectNoAccordCheckData();
        data.setReformItemId(rtf.getId());
        this.selectNoAccordCheckDataMapper.updateByExampleSelective(data, e);
        return rtf;
    }

    @Transactional(readOnly=false)
    public void editHcCheckPlanCheckingSubmit(HcCheckPlan hc, Long loginStaffId) {
        this.update(hc, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void stopHcCheckPlanCheckingByIds(Long[] ids, Long loginStaffId, Long cid) {
        Example e = new Example(HcCheckPlan.class);
        e.createCriteria().andIn("id", Arrays.asList(ids));
        HcCheckPlan hc = new HcCheckPlan();
        hc.setIsValid(Global.FALSE);
        this.hcCheckPlanMapper.updateByExampleSelective(hc, e);
        for (Long id : ids) {
            HcCheckPlan h = (HcCheckPlan)this.getById(id);
            this.sysCoreWorkModuleCorrelationService.businessDelete(CoreWorkEnum.harmfactorTest, h.getId(), h.getCreateBy(), h.getCid());
            if (h.getCheckPlanType() == null || h.getCheckPlanType().intValue() != 3 || !StringUtils.isNotEmpty((String)h.getReformItemIds())) continue;
            String[] reformIdStrs = h.getReformItemIds().split(",");
            Long[] reformIds = new Long[reformIdStrs.length];
            for (int i = 0; i < reformIdStrs.length; ++i) {
                reformIds[i] = Long.valueOf(reformIdStrs[i]);
                this.reformItemBasicService.reformItemRetestRecovery(reformIds[i], loginStaffId);
            }
        }
    }

    public HcCheckPlan getHcCHeckPlanById(Long hcId) {
        HcCheckPlan h = (HcCheckPlan)this.getById(hcId);
        if (h != null) {
            HcCheckType type;
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            h.setCheckPointCount(this.hcCheckResultCollectDataMapper.getAllCountResultDataByHcId(h.getCid(), h.getId()));
            h.setNoGoodCheckPointCount(this.hcCheckResultCollectDataMapper.getAllNoGoodCountResultDataByHcId(h.getCid(), h.getId()));
            if (h.getCheckPointCount() != 0) {
                h.setRate(new BigDecimal(((float)h.getCheckPointCount().intValue() - (float)h.getNoGoodCheckPointCount().intValue()) / (float)h.getCheckPointCount().intValue() * 100.0f).setScale(2, 4).doubleValue() + "%");
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckDataSource() != null && (h.getCheckDataSource() == 3 || h.getCheckDataSource() == 2) && h.getThirdPartyOrCheckOrgId() != null) {
                HcCheckThirdOrg org = this.hcCheckThirdOrgService.getThisByOrgId(h.getThirdPartyOrCheckOrgId());
                if (org != null) {
                    h.setThirdOrgName(org.getThirdOrgName());
                }
            } else if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() != null) {
                h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
            }
            if (StringUtils.isNotEmpty((String)h.getCheckPids())) {
                String[] pids = h.getCheckPids().split(",");
                Object checkPNos = "";
                for (int i = 0; i < pids.length; ++i) {
                    HcCheckPlan hc = (HcCheckPlan)this.getById(Long.valueOf(pids[i]));
                    if (hc == null) continue;
                    checkPNos = (String)checkPNos + hc.getCheckWorkNo();
                    if (i == pids.length - 1) continue;
                    checkPNos = (String)checkPNos + ",";
                }
                h.setCheckPNos((String)checkPNos);
            }
        }
        return h;
    }

    public Integer getHcCheckPlanCompletedCountByYear(String thisYear, Long cid) {
        Integer count = this.hcCheckPlanMapper.getHcCheckPlanCompletedCountByYear(thisYear, cid);
        return count;
    }

    @Transactional
    public HcCheckPlanFirstPageVo getHcCheckPlanFirstPageVo(Long cid) {
        HcCheckPlanFirstPageVo vo = new HcCheckPlanFirstPageVo();
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKING.getCode());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        DataScope dataScope = DataScopeHelper.getDataScope();
        List<HcCheckPlan> list1 = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        DataScopeHelper.setDataScope(dataScope);
        List<HcCheckPlan> list2 = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        if (list1.size() > 0 || list2.size() > 0) {
            vo.setIsNeedAddCheck(Boolean.valueOf(false));
        } else {
            vo.setIsNeedAddCheck(Boolean.valueOf(true));
        }
        hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKING.getCode());
        hc.setCheckPlanType(Byte.valueOf((byte)0));
        DataScopeHelper.setDataScope(dataScope);
        List<HcCheckPlan> list3 = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        vo.setUnderwayCount(Integer.valueOf(list3.size()));
        Integer noAccordCount = this.hcCheckResultCollectDataMapper.getHcCheckCollectNotAccordDatasNotSelected(cid, null, false).size();
        Integer fromReformCount = this.reformItemBasicService.getReformCountHarmFactorDraff(cid);
        if (noAccordCount > 0 || fromReformCount > 0) {
            vo.setIsHasNoAccordItem(Boolean.valueOf(true));
        } else {
            vo.setIsHasNoAccordItem(Boolean.valueOf(false));
        }
        Integer reformCount = this.reformItemBasicService.getReformItemFinishedForHarmFactor(cid);
        DataScopeHelper.setDataScope(dataScope);
        Integer againCount = this.hcCheckPlanMapper.getCheckPlanAgainCHeckingCountByCid(cid);
        vo.setReformedCount(Integer.valueOf(reformCount + againCount));
        dataScope.setMainTableName("hc_check_result_report");
        DataScopeHelper.setDataScope(dataScope);
        Integer noReportCount = this.hcCheckResultReportService.getNoReportHcCheckPlansCount(cid);
        DataScopeHelper.setDataScope(dataScope);
        Integer reportingCount = this.hcCheckResultReportService.getHcCheckResultReportingCountList(cid);
        if (noReportCount > 0 || reportingCount > 0) {
            vo.setIsHasNeedReport(Boolean.valueOf(true));
        } else {
            vo.setIsHasNeedReport(Boolean.valueOf(false));
        }
        Boolean isIgnoreOneYear = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.harmfactorTest_oneYearCheck, cid, 1);
        if (!isIgnoreOneYear.booleanValue()) {
            Integer OneYearToCheckCount = this.hcCheckPlanMapper.getHcCheckPlanLessOneYearToCheckCount(cid, Calendar.getInstance().get(1));
            Integer checkTypeOfRegularCount = this.hcCheckPlanMapper.getHcCheckPlanCheckTypeOfRegularCount(cid, Calendar.getInstance().get(1));
            if (OneYearToCheckCount != null && OneYearToCheckCount >= 1 && checkTypeOfRegularCount > 0) {
                vo.setIsHasOneYearToCheck(Boolean.valueOf(true));
            } else {
                vo.setIsHasOneYearToCheck(Boolean.valueOf(false));
            }
        } else {
            vo.setIsHasOneYearToCheck(Boolean.valueOf(false));
        }
        Boolean isIgnoreThreeYear = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.harmfactorTest_threeYearCheck, cid, 3);
        if (!isIgnoreThreeYear.booleanValue()) {
            Integer checkTypeOfPresentCount = this.hcCheckPlanMapper.getHcCheckPlanCheckTypeOfPresentCount(cid, Calendar.getInstance().get(1));
            Integer threeYearToCheckCount = this.hcCheckPlanMapper.getCheckPlanLessThreeYearToCHeckCount(cid, Calendar.getInstance().get(1));
            if (threeYearToCheckCount != null && threeYearToCheckCount >= 3 && checkTypeOfPresentCount > 0) {
                vo.setIsHasThreeYearsToCheck(Boolean.valueOf(true));
            } else {
                vo.setIsHasThreeYearsToCheck(Boolean.valueOf(false));
            }
        } else {
            vo.setIsHasThreeYearsToCheck(Boolean.valueOf(false));
        }
        List sysList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.accidentManement, CoreWorkEnum.harmfactorTest, cid);
        vo.setAccidentCount(Integer.valueOf(sysList.size()));
        vo.setThirdTimeList(this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.harmfactorTest, cid));
        List evalSList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.evaluate, CoreWorkEnum.harmfactorTest, cid);
        ArrayList<SysCoreWorkModuleCorrelation> nowStatusList = new ArrayList<SysCoreWorkModuleCorrelation>();
        ArrayList<SysCoreWorkModuleCorrelation> controlEvaluationList = new ArrayList<SysCoreWorkModuleCorrelation>();
        for (SysCoreWorkModuleCorrelation remind : evalSList) {
            if (remind.getStageSource() == null) continue;
            if (remind.getStageSource() == 1) {
                nowStatusList.add(remind);
            }
            if (remind.getStageSource() != 3) continue;
            controlEvaluationList.add(remind);
        }
        vo.setNowStatusList(nowStatusList);
        vo.setControlEvaluationList(controlEvaluationList);
        vo.setAppearHcCheckList(this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.harmfactorTest, CoreWorkEnum.harmfactorTest, cid));
        List healthCheckCorrelationList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.harmfactorTest, CoreWorkEnum.harmfactor, cid);
        vo.setHealthCheckCorrelationList(healthCheckCorrelationList);
        vo.setUnderwayUnionHcTotal(Integer.valueOf(this.harmfactorWorkService.harmfactorHccheckplanunderwayCount(cid)));
        return vo;
    }

    public PageInfo<HcCheckPlan> getHcCheckPlanStatQueryVodata(JqGridParam jparam, HcCheckPlanQueryParam param) {
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanStatQueryVodata(param);
        ArrayList<Object> partHcIdStrs = new ArrayList<Object>();
        ArrayList<Object> rightHcIdStrs = new ArrayList<Object>();
        ArrayList<Object> allHcIdStrs = new ArrayList<Object>();
        HashMap<CallSite, HcCheckPlan> map = new HashMap<CallSite, HcCheckPlan>();
        for (HcCheckPlan h : list) {
            HcCheckType type;
            h.setCheckPointCount(this.hcCheckResultCollectDataMapper.getAllCountResultDataByHcId(h.getCid(), h.getId()));
            h.setNoGoodCheckPointCount(this.hcCheckResultCollectDataMapper.getAllNoGoodCountResultDataByHcId(h.getCid(), h.getId()));
            if (h.getCheckPointCount() != 0) {
                h.setRate(new BigDecimal(((float)h.getCheckPointCount().intValue() - (float)h.getNoGoodCheckPointCount().intValue()) / (float)h.getCheckPointCount().intValue() * 100.0f).setScale(2, 4).doubleValue() + "%");
                if (((float)h.getCheckPointCount().intValue() - (float)h.getNoGoodCheckPointCount().intValue()) / (float)h.getCheckPointCount().intValue() < 1.0f) {
                    partHcIdStrs.add("" + h.getId());
                }
                if (((float)h.getCheckPointCount().intValue() - (float)h.getNoGoodCheckPointCount().intValue()) / (float)h.getCheckPointCount().intValue() == 1.0f) {
                    rightHcIdStrs.add("" + h.getId());
                }
            } else {
                partHcIdStrs.add("" + h.getId());
            }
            allHcIdStrs.add("" + h.getId());
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() != null) {
                h.setManagerName(this.staffInfoService.getStaffNameByStaffId(h.getManager()));
            }
            if (StringUtils.isNotEmpty((String)h.getCheckPids())) {
                String[] pids = h.getCheckPids().split(",");
                Object checkPNos = "";
                for (int i = 0; i < pids.length; ++i) {
                    HcCheckPlan hc = (HcCheckPlan)this.getById(Long.valueOf(pids[i]));
                    if (hc == null) continue;
                    checkPNos = (String)checkPNos + hc.getCheckWorkNo();
                    if (i == pids.length - 1) continue;
                    checkPNos = (String)checkPNos + ",";
                }
                h.setCheckPNos((String)checkPNos);
            }
            map.put((CallSite)((Object)("" + h.getId())), h);
        }
        Example e = new Example(HcCheckPlan.class);
        if (param.getCheckResultType() == null) {
            param.setCheckResultType(Integer.valueOf(1));
        }
        if (param.getCheckResultType() == 1) {
            if (allHcIdStrs.size() == 0) {
                allHcIdStrs.add("-1");
            }
            e.createCriteria().andIn("id", allHcIdStrs);
        } else if (param.getCheckResultType() == 2) {
            if (partHcIdStrs.size() == 0) {
                partHcIdStrs.add("-1");
            }
            e.createCriteria().andIn("id", partHcIdStrs);
        } else if (param.getCheckResultType() == 3) {
            if (rightHcIdStrs.size() == 0) {
                rightHcIdStrs.add("-1");
            }
            e.createCriteria().andIn("id", rightHcIdStrs);
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List finalList = this.hcCheckPlanMapper.selectByExample(e);
        for (HcCheckPlan h : finalList) {
            HcCheckPlan hp = (HcCheckPlan)map.get("" + h.getId());
            h.setCheckTime(hp.getCheckTime());
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String str = "<a href='../work/hccheckplan/HcCheckPlan/editOrShowHcCheckPlanCheckingById?hcId=" + hp.getId() + "&pageEditable=false'  target='_blank'>" + hp.getCheckWorkNo() + "</a>";
            h.setCheckWorkNo(str);
            h.setRate(hp.getRate());
            h.setCheckPointCount(hp.getCheckPointCount());
            h.setCheckPNos(hp.getCheckPNos());
            h.setCheckTypeName(hp.getCheckTypeName());
            if (hp.getRate() != null && hp.getRate().equals("100.0%")) continue;
            String viewButt = "<a class='ui-pg-div' href='../statistical/viewHcCHeckPlan?checkPlanId=" + h.getId() + "'   data-rel='tooltip' data-original-title='\u67e5\u770b' target='_blank'><i class='ui-icon icon-ui-icon icon-zoom-in green'></i></a>";
            h.setShowViewButt(viewButt);
        }
        return new PageInfo(finalList);
    }

    public List<HcCheckType> getHcCheckTypeListByCid(Long cid) {
        return this.hcCheckTypeMapper.getHcCheckTypeListByCid(cid);
    }

    public HcCheckPlanSummaryVo getSummaryData(Long cid, String year) {
        HcCheckPlanSummaryVo vo = new HcCheckPlanSummaryVo();
        vo.setDailyCompletedCheckCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.DAILY.getValue(), HcCheckPlanStatusEnum.CHECKED.getCode()));
        vo.setDailyCheckingCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.DAILY.getValue(), HcCheckPlanStatusEnum.CHECKING.getCode()));
        vo.setDailyCompletedReformCount(this.hcCheckPlanMapper.getHcCheckPlanReformCompletedByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.DAILY.getValue(), StatusEnum.finished.getValue()));
        vo.setRegularCompletedCheckCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.REGULAR.getValue(), HcCheckPlanStatusEnum.CHECKED.getCode()));
        vo.setRegularCheckingCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.REGULAR.getValue(), HcCheckPlanStatusEnum.CHECKING.getCode()));
        vo.setRegularRefomCount(this.hcCheckPlanMapper.getHcCheckPlanReformCompletedByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.REGULAR.getValue(), StatusEnum.finished.getValue()));
        vo.setPresentCompletedCheckCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.PRESENT.getValue(), HcCheckPlanStatusEnum.CHECKED.getCode()));
        vo.setPresentCheckingCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.PRESENT.getValue(), HcCheckPlanStatusEnum.CHECKING.getCode()));
        vo.setPresentReformCount(this.hcCheckPlanMapper.getHcCheckPlanReformCompletedByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.REGULAR.getValue(), StatusEnum.finished.getValue()));
        vo.setControlassessmentCompletedCheckCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.CONTROLASSESSMENT.getValue(), HcCheckPlanStatusEnum.CHECKED.getCode()));
        vo.setControlassessmentCheckingCount(this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.CONTROLASSESSMENT.getValue(), HcCheckPlanStatusEnum.CHECKING.getCode()));
        vo.setControlassessmentReformCount(this.hcCheckPlanMapper.getHcCheckPlanReformCompletedByTypeAndCidAndYear(cid, year, HcCheckTypeEnum.CONTROLASSESSMENT.getValue(), StatusEnum.finished.getValue()));
        vo.setCompeletedAgainCheckCount(this.hcCheckPlanMapper.getCompeletedAgainCheckCountByCidAndByYear(cid, year));
        vo.setCompeletedAgainCheckReformCount(this.hcCheckPlanMapper.getCompeletedAgainCheckReformCountByYearAndCid(cid, year, StatusEnum.finished.getValue()));
        return vo;
    }

    public Integer getInformedHcCheckCountByCidAndYear(Long cid, String year) {
        return this.hcCheckPlanMapper.getInformedHcCheckCountByCidAndYear(cid, year);
    }

    public PageInfo<HarmCheckRateVo> getHarmCheckRateVosByHcId(JqGridParam jparam, Long cid, Long hcId) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<HarmCheckRateVo> list = this.hcCheckResultCollectDataMapper.getHarmCheckRateVosByHcId(cid, hcId);
        for (HarmCheckRateVo vo : list) {
            Integer collectType = null;
            OccupationalRiskFactors o = null;
            if (vo.getCollectType() == ResultCollectTypeEnum.BIOLOGICAL.getCode() || vo.getCollectType() == ResultCollectTypeEnum.DUST.getCode() || vo.getCollectType() == ResultCollectTypeEnum.CHEMICAL.getCode()) {
                o = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(vo.getHarmId());
                collectType = this.getResultCollectTypeEnumByHarmId(o);
            } else {
                String paramCode = ResultCollectTypeEnum.getThisEnumByCode((Integer)vo.getCollectType()).getParamCode();
                if (paramCode != null) {
                    o = this.occupationalRiskFactorsService.getOneOccupationalRiskFactorsByParamCode(paramCode);
                    collectType = vo.getCollectType();
                }
            }
            if (o != null) {
                vo.setHarmName(o.getNameCh());
            }
            if (collectType != null) {
                List<HcCheckResultDataPublicVo> vs = this.hcCheckResultCollectDataMapper.getHcCheckCollectDatasByHcIdAndHarmIdAndResult(cid, hcId, o.getId(), collectType, null);
                vo.setCheckPointCount(Integer.valueOf(vs.size()));
                vo.setNoGoodCheckPointCount(Integer.valueOf(this.hcCheckResultCollectDataMapper.getHcCheckCollectDatasByHcIdAndHarmIdAndResult(cid, hcId, o.getId(), collectType, 1L).size()));
                vo.setGoodCheckPointCount(Integer.valueOf(vo.getCheckPointCount() - vo.getNoGoodCheckPointCount()));
            }
            if (vo.getCheckPointCount() == null || vo.getCheckPointCount() == 0) continue;
            vo.setRate(new BigDecimal(((float)vo.getCheckPointCount().intValue() - (float)vo.getNoGoodCheckPointCount().intValue()) / (float)vo.getCheckPointCount().intValue() * 100.0f).setScale(2, 4).doubleValue() + "%");
        }
        return new PageInfo(list);
    }

    private Integer getResultCollectTypeEnumByHarmId(OccupationalRiskFactors o) {
        if (o != null && StringUtils.isNotEmpty((String)o.getParamcode())) {
            if (o.getParamcode().contains("HX")) {
                return ResultCollectTypeEnum.CHEMICAL.getCode();
            }
            if (o.getParamcode().contains("FC")) {
                return ResultCollectTypeEnum.DUST.getCode();
            }
            if (o.getParamcode().contains("SW")) {
                return ResultCollectTypeEnum.BIOLOGICAL.getCode();
            }
            return ResultCollectTypeEnum.getCodeByParamCode((String)o.getParamcode());
        }
        return null;
    }

    public List<HcCheckPointMapVo> getHcCheckPointMapVosByCid(Long cid, int year) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        ArrayList<HcCheckPointMapVo> vos = new ArrayList<HcCheckPointMapVo>();
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckTimeBegin() == null || DateUtils.getYear((Date)h.getCheckTimeBegin()) != year || StringUtils.isEmpty((CharSequence)h.getCheckPointMapFileIds())) continue;
            HcCheckPointMapVo vo = new HcCheckPointMapVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            vo.setCheckTypeName(h.getCheckTypeName());
            String checkTime = "";
            if (h.getCheckTimeBegin() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
            }
            h.setCheckTime(checkTime + "\u81f3");
            if (h.getCheckTimeEnd() != null) {
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            vo.setCheckTime(h.getCheckTime());
            if (StringUtils.isNotEmpty((String)h.getCheckPointMapFileIds())) {
                String[] fileIds;
                ArrayList<HcCheckAttachment> attachments = new ArrayList<HcCheckAttachment>();
                for (String fileId : fileIds = h.getCheckPointMapFileIds().split(",")) {
                    if (!StringUtils.isNumber((String)fileId)) continue;
                    HcCheckAttachment attachment = new HcCheckAttachment();
                    attachment.setFileId(Long.valueOf(fileId));
                    SysFileModel sysFile = this.sysFileService.getFileById(Long.valueOf(fileId));
                    if (sysFile == null) continue;
                    attachment.setAttachmentName(sysFile.getFileName());
                    attachment.setOssUrl(sysFile.getOssUrl());
                    attachment.setSysFile(sysFile);
                    attachments.add(attachment);
                }
                vo.setAttachments(attachments);
            }
            if (vo.getAttachments() == null || vo.getAttachments().isEmpty()) continue;
            vos.add(vo);
        }
        return vos;
    }

    public List<HcCheckEvaluateOrCheckFileVo> getHcCheckEvaluateOrCheckFileVos(Long cid, int year) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        ArrayList<HcCheckEvaluateOrCheckFileVo> voList = new ArrayList<HcCheckEvaluateOrCheckFileVo>();
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckTimeBegin() == null || DateUtils.getYear((Date)h.getCheckTimeBegin()) != year || h.getCheckPlanType() == null || h.getCheckPlanType() == 3) continue;
            HcCheckEvaluateOrCheckFileVo vo = new HcCheckEvaluateOrCheckFileVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            vo.setCheckTypeName(h.getCheckTypeName());
            String checkTime = "";
            if (h.getCheckTimeBegin() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
            }
            h.setCheckTime(checkTime + "\u81f3");
            if (h.getCheckTimeEnd() != null) {
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            vo.setCheckTime(h.getCheckTime());
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getHistoryOrgNameByOrgIdAndYear(h.getThirdPartyOrCheckOrgId(), DateUtils.getYearLastDay((int)year)));
            }
            vo.setCheckOrgName(h.getCheckOrgName());
            if (h.getRelatedJobEvaluationId() == null || h.getCheckType() == null || h.getCheckType() != HcCheckTypeEnum.PRESENT.getValue() && h.getCheckType() != HcCheckTypeEnum.CONTROLASSESSMENT.getValue()) {
                vo.setEvaluateOrCheckLocation(h.getEvaluateOrCheckLocation());
                if (StringUtils.isNotEmpty((String)h.getEvaluateOrCheckFile())) {
                    String[] strs = h.getEvaluateOrCheckFile().split(",");
                    Object fileNameStr = "";
                    for (String str : strs) {
                        SysFileModel sysFile;
                        if (!StringUtils.isNumber((String)str) || (sysFile = this.sysFileService.getFileById(Long.valueOf(str))) == null) continue;
                        fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                    }
                    vo.setEvaluateOrCheckFile((String)fileNameStr);
                }
            }
            voList.add(vo);
        }
        return voList;
    }

    public List<HcCheckEvaluateReportVo> getHcCheckEvaluateReportVos(Long cid, int year) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        ArrayList<HcCheckEvaluateReportVo> voList = new ArrayList<HcCheckEvaluateReportVo>();
        for (HcCheckPlan h : list) {
            SysFileModel sysFile;
            Object fileNameStr;
            String[] strs;
            HcCheckType type;
            if (h.getCheckTimeBegin() == null || DateUtils.getYear((Date)h.getCheckTimeBegin()) != year) continue;
            HcCheckEvaluateReportVo vo = new HcCheckEvaluateReportVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            vo.setCheckTypeName(h.getCheckTypeName());
            String checkTime = "";
            if (h.getCheckTimeBegin() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
            }
            h.setCheckTime(checkTime + "\u81f3");
            if (h.getCheckTimeEnd() != null) {
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            vo.setCheckTime(h.getCheckTime());
            if (h.getRelatedJobEvaluationId() == null || h.getCheckType() == null || h.getCheckType() != HcCheckTypeEnum.PRESENT.getValue() && h.getCheckType() != HcCheckTypeEnum.CONTROLASSESSMENT.getValue()) {
                vo.setCheckEvaluateReportLocation(h.getCheckEvaluateReportLocation());
                if (StringUtils.isNotEmpty((String)h.getCheckEvaluateReportName())) {
                    strs = h.getCheckEvaluateReportName().split(",");
                    fileNameStr = "";
                    for (String str : strs) {
                        if (!StringUtils.isNumber((String)str) || (sysFile = this.sysFileService.getFileById(Long.valueOf(str))) == null) continue;
                        fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                    }
                    vo.setCheckEvaluateReportName((String)fileNameStr);
                }
            }
            vo.setCheckReportLocation(h.getCheckReportLocation());
            if (StringUtils.isNotEmpty((String)h.getCheckReportName())) {
                strs = h.getCheckReportName().split(",");
                fileNameStr = "";
                for (String str : strs) {
                    if (!StringUtils.isNumber((String)str) || (sysFile = this.sysFileService.getFileById(Long.valueOf(str))) == null) continue;
                    fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                }
                vo.setCheckReportName((String)fileNameStr);
            }
            voList.add(vo);
        }
        return voList;
    }

    public List<Long> getHccheckplanDataByCidAndYearAndQuarter(Long cid, String year, HcQuarterEnum quarter) {
        ArrayList<Long> hcIds = new ArrayList<Long>();
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStartTime(DateUtils.parseDate((Object)(year + "-" + quarter.getStartTime())));
        hc.setEndTime(DateUtils.parseDate((Object)(year + "-" + quarter.getEndTime())));
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHccheckplanDataByCidAndYearAndQuarter(hc);
        for (HcCheckPlan h : list) {
            if (!HcCheckTypeEnum.DAILY.getValue().equals(h.getCheckType())) continue;
            hcIds.add(h.getId());
        }
        return hcIds;
    }

    public List<HcResultCertificateVo> getHcResultCertificateVosByYear(Long cid, String year) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        hc.setCheckTime(year);
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcResultCertificateVosByYear(hc);
        ArrayList<HcResultCertificateVo> vos = new ArrayList<HcResultCertificateVo>();
        for (HcCheckPlan h : list) {
            HcCheckType type;
            HcResultCertificateVo vo = new HcResultCertificateVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            vo.setCheckTypeName(h.getCheckTypeName());
            String checkTime = "";
            if (h.getCheckTimeBegin() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
            }
            h.setCheckTime(checkTime + "\u81f3");
            if (h.getCheckTimeEnd() != null) {
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            vo.setCheckTime(h.getCheckTime());
            if (StringUtils.isNotEmpty((String)h.getCheckResultCertificateFileIds())) {
                String[] fileIds;
                ArrayList<HcCheckAttachment> attachments = new ArrayList<HcCheckAttachment>();
                for (String fileId : fileIds = h.getCheckResultCertificateFileIds().split(",")) {
                    HcCheckAttachment attachment = new HcCheckAttachment();
                    if (!StringUtils.isNotEmpty((String)fileId) || !StringUtils.isNumber((String)fileId)) continue;
                    attachment.setFileId(Long.valueOf(fileId));
                    SysFileModel sysFile = this.sysFileService.getFileById(Long.valueOf(fileId));
                    if (sysFile == null) continue;
                    attachment.setSysFile(sysFile);
                    attachment.setAttachmentName(sysFile.getFileName());
                    attachment.setOssUrl(sysFile.getOssUrl());
                    attachments.add(attachment);
                }
                vo.setAttachments(attachments);
            }
            vos.add(vo);
        }
        return vos;
    }

    public List<HcResultCertificateVo> getHcResultCertificateVosByYearNew(Long cid, String year) {
        LocalDateTime start = cn.smarthse.util.common.date.DateUtils.parseDateTime((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
        LocalDateTime end = cn.smarthse.util.common.date.DateUtils.parseDateTime((String)(year + "-12-31 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
        List list = this.checkPlanService.getByStartDateAndEndDateRange(cid, start, end);
        LinkedList<HcResultCertificateVo> rList = new LinkedList<HcResultCertificateVo>();
        StringBuilder fileIds = new StringBuilder();
        HashMap<String, HcResultCertificateVo> fidToObjMap = new HashMap<String, HcResultCertificateVo>();
        for (CheckPlan checkPlan : list) {
            String[] splits;
            HcResultCertificateVo vo = new HcResultCertificateVo();
            vo.setCheckTime(cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)checkPlan.getCheckDateBegin()));
            Long checkType = checkPlan.getCheckType();
            if (checkType == null) {
                checkType = -1L;
            }
            vo.setCheckTypeName(this.getCheckPlanTypeName(checkType.intValue()));
            vo.setCheckWorkName(checkPlan.getCheckWorkName());
            vo.setAttachments(new LinkedList());
            rList.add(vo);
            String fs = checkPlan.getCheckResultCertificateFileIds();
            if (fs == null || fs.isEmpty() || fs.equals(",")) continue;
            fileIds.append(fs);
            if (!fs.endsWith(",")) {
                fileIds.append(",");
            }
            for (String fd : splits = fs.split(",")) {
                fidToObjMap.put(fd, vo);
            }
        }
        if (fileIds.length() == 0) {
            return rList;
        }
        List files = this.sysFileService.getListByIds(fileIds.substring(0, fileIds.length() - 1));
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (SysFileModel file : files) {
                HcResultCertificateVo vo = (HcResultCertificateVo)fidToObjMap.get("" + file.getId());
                if (vo == null) continue;
                HcCheckAttachment attachment = new HcCheckAttachment();
                attachment.setSysFile(file);
                attachment.setAttachmentName(file.getFileName());
                attachment.setOssUrl(file.getOssUrl());
                vo.getAttachments().add(attachment);
            }
        }
        return rList;
    }

    private String getCheckPlanTypeName(int checkTypeId) {
        switch (checkTypeId) {
            case 1: {
                return "\u65e5\u5e38\u76d1\u6d4b";
            }
            case 2: {
                return "\u5b9a\u671f\u68c0\u6d4b";
            }
            case 3: {
                return "\u73b0\u72b6\u8bc4\u4ef7\u6d89\u53ca\u7684\u68c0\u6d4b";
            }
            case 4: {
                return "\u63a7\u8bc4\u6d89\u53ca\u7684\u68c0\u6d4b";
            }
            case 5: {
                return "\u6574\u6539\u540e\u68c0\u6d4b";
            }
        }
        return "";
    }

    public List<Long> getTpCompanyIdsFromHcCheck(Long cid, int year) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (HcCheckPlan h : list) {
            if (h.getCheckTimeBegin() == null || DateUtils.getYear((Date)h.getCheckTimeBegin()) != year || h.getThirdPartyOrCheckOrgId() == null || h.getCheckServiceType() == null || h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue() || ids.indexOf(h.getThirdPartyOrCheckOrgId()) >= 0) continue;
            ids.add(h.getThirdPartyOrCheckOrgId());
        }
        return ids;
    }

    public List<HcCheckPlan> getHcCheckPlansByReformIdList(List<Long> reformIdList) {
        Example e = new Example(SelectNoAccordCheckData.class);
        e.createCriteria().andIn("reformItemId", reformIdList);
        List list = this.selectNoAccordCheckDataMapper.selectByExample(e);
        ArrayList<HcCheckPlan> phcs = new ArrayList<HcCheckPlan>();
        for (SelectNoAccordCheckData s : list) {
            phcs.add(this.getHcCHeckPlanById(s.getHcId()));
        }
        return phcs;
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        HcCheckPlan hcCheckPlan = new HcCheckPlan();
        hcCheckPlan.setCid(detail.getCid());
        hcCheckPlan.setStatus(HcCheckPlanStatusEnum.CHECKING.getCode());
        hcCheckPlan.setIsValid(Global.TRUE);
        hcCheckPlan.setCheckWorkName(detail.getBusinessName());
        hcCheckPlan.setCheckPlanType(Byte.valueOf((byte)0));
        hcCheckPlan.setCheckTimeBegin(detail.getBusinessPlantime());
        hcCheckPlan.setCheckTimeEnd(detail.getBusinessPlantime());
        if (StringUtils.isNotEmpty((String)detail.getWorkSubtype())) {
            hcCheckPlan.setCheckType(Long.valueOf(detail.getWorkSubtype().trim()));
        }
        hcCheckPlan.setOrgId(detail.getOrgId());
        hcCheckPlan.setCheckWorkNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.HCCHECKPLAN.getCode()));
        hcCheckPlan.setCreateBy(detail.getCreatorBy());
        hcCheckPlan.setManager(detail.getManagerId());
        this.add(hcCheckPlan);
        this.sysCoreWorkModuleCorrelationService.businessStartPlan(CoreWorkEnum.harmfactorTest, hcCheckPlan.getId(), detail.getTipCreateBy(), detail.getCid(), detail.getBusinessName(), detail.getDetailId());
        return hcCheckPlan.getId();
    }

    public String getBatchByReformId(Long reformId) {
        Example e = new Example(SelectNoAccordCheckData.class);
        e.createCriteria().andEqualTo("reformItemId", (Object)reformId);
        List list = this.selectNoAccordCheckDataMapper.selectByExample(e);
        if (list != null && list.size() > 0) {
            return ((SelectNoAccordCheckData)list.get(0)).getBatch();
        }
        return "";
    }

    @Transactional(readOnly=false)
    public void recoveryNoAccordsByReformId(Long reformId) {
        if (reformId != null) {
            Example e = new Example(SelectNoAccordCheckData.class);
            e.createCriteria().andEqualTo("reformItemId", (Object)reformId);
            this.selectNoAccordCheckDataMapper.deleteByExample(e);
        }
    }

    public List<HcCheckHarmConcentrationForWorkEveryYear> getHcCheckHarmConcentrationForWorkEveryYears(Long cid, Long workId, Integer startYear, Integer endYear) {
        List harmlist = this.harmfactorWorkService.getHarmfactorListByWork(cid, workId);
        ArrayList<ResultCollectTypeEnum> collectTypes = new ArrayList<ResultCollectTypeEnum>();
        Object harmIds = "";
        for (HarmfactorWorkSourceInfoVo vo : harmlist) {
            harmIds = (String)harmIds + vo.getHarmId() + ",";
            OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(vo.getHarmId());
            Integer collectType = null;
            if (orf == null || !StringUtils.isNotEmpty((String)orf.getParamcode())) continue;
            if (orf.getParamcode().contains(ResultCollectTypeEnum.CHEMICAL.getParamCode())) {
                collectTypes.add(ResultCollectTypeEnum.CHEMICAL);
                continue;
            }
            if (orf.getParamcode().contains(ResultCollectTypeEnum.BIOLOGICAL.getParamCode())) {
                collectTypes.add(ResultCollectTypeEnum.BIOLOGICAL);
                continue;
            }
            if (orf.getParamcode().contains(ResultCollectTypeEnum.DUST.getParamCode())) {
                collectTypes.add(ResultCollectTypeEnum.DUST);
                continue;
            }
            collectType = ResultCollectTypeEnum.getCodeByParamCode((String)orf.getParamcode());
            if (collectType == null) continue;
            collectTypes.add(ResultCollectTypeEnum.getThisEnumByCode((Integer)collectType));
        }
        harmIds = (String)harmIds + "-999";
        ArrayList<HcCheckHarmConcentrationForWorkEveryYear> list = new ArrayList<HcCheckHarmConcentrationForWorkEveryYear>();
        Integer i = startYear;
        while (i <= endYear) {
            HcCheckHarmConcentrationForWorkEveryYear year = new HcCheckHarmConcentrationForWorkEveryYear();
            if (collectTypes.contains(ResultCollectTypeEnum.CHEMICAL)) {
                year.setChemicals(this.getHcCheckChemicalConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.CHEMICAL.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.BIOLOGICAL)) {
                year.setBiologicals(this.getHcCheckBiologicalConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.BIOLOGICAL.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.DUST)) {
                year.setDusts(this.getHcCheckDustConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.BIOLOGICAL.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.NOISE)) {
                year.setNoise(this.getHcCheckNoiseConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.NOISE.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.HIGHFREQUENCY)) {
                year.setHighFrequency(this.getHcCheckHighFrequencyConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.HIGHFREQUENCY.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.IONIZINGRADIATION)) {
                year.setIonizingradiation(this.getHcCheckIonizingradiationConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.IONIZINGRADIATION.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.ULTRAHIGHFREQUENCYRADIATION)) {
                year.setUltrahighfrequencyradiation(this.getHcCheckUltrahighfrequencyradiationConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.ULTRAHIGHFREQUENCYRADIATION.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.HANDTRANSMITTED)) {
                year.setHandtransmitted(this.getHcCheckHandtransmittedConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.HANDTRANSMITTED.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.MICROWAVERADIATION)) {
                year.setMicrowaveradiation(this.getHcCheckMicrowaveradiationConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.MICROWAVERADIATION.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.ULTRAVIOLETLIGHT)) {
                year.setUltravioletlight(this.getHcCheckUltravioletlightConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.ULTRAVIOLETLIGHT.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.POWERFREQUENCY)) {
                year.setPowerfrequency(this.getHcCheckPowerfrequencyConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.POWERFREQUENCY.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.HIGHTEMPERATURE)) {
                year.setHightemperature(this.getHcCheckHightemperatureConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.HIGHTEMPERATURE.getCode(), (String)harmIds, i));
            }
            if (collectTypes.contains(ResultCollectTypeEnum.LASERRADIATION)) {
                year.setLaserradiation(this.getHcCheckLaserradiationConcentrationVosByYearAndHarmIds(cid, ResultCollectTypeEnum.LASERRADIATION.getCode(), (String)harmIds, i));
            }
            list.add(year);
            Integer n = i;
            i = i + 1;
        }
        return list;
    }

    public HcCheckConcentrationStat getHcCheckConcentrationStat(List<HcCheckHarmConcentrationForWorkEveryYear> list) {
        HashMap chemicalsMap = new HashMap();
        HashMap biologicalsMap = new HashMap();
        HashMap dustsMap = new HashMap();
        ArrayList chemicals = new ArrayList();
        ArrayList biologicals = new ArrayList();
        ArrayList dusts = new ArrayList();
        ArrayList<HcCheckNoiseConcentrationVo> noise = new ArrayList<HcCheckNoiseConcentrationVo>();
        ArrayList<HcCheckHighFrequencyConcentrationVo> highFrequency = new ArrayList<HcCheckHighFrequencyConcentrationVo>();
        ArrayList<HcCheckIonizingradiationConcentrationVo> ionizingradiation = new ArrayList<HcCheckIonizingradiationConcentrationVo>();
        ArrayList<HcCheckUltrahighfrequencyradiationConcentrationVo> ultrahighfrequencyradiation = new ArrayList<HcCheckUltrahighfrequencyradiationConcentrationVo>();
        ArrayList<HcCheckHandtransmittedConcentrationVo> handtransmitted = new ArrayList<HcCheckHandtransmittedConcentrationVo>();
        ArrayList<HcCheckCollectMicrowaveradiationConcentrationVo> microwaveradiation = new ArrayList<HcCheckCollectMicrowaveradiationConcentrationVo>();
        ArrayList<HcCheckCollectUltravioletlightConcentrationVo> ultravioletlight = new ArrayList<HcCheckCollectUltravioletlightConcentrationVo>();
        ArrayList<HcCheckCollectPowerfrequencyConcentrationVo> powerfrequency = new ArrayList<HcCheckCollectPowerfrequencyConcentrationVo>();
        ArrayList<HcCheckHightemperatureConcentrationVo> hightemperature = new ArrayList<HcCheckHightemperatureConcentrationVo>();
        ArrayList<HcCheckLaserradiationConcentrationVo> laserradiation = new ArrayList<HcCheckLaserradiationConcentrationVo>();
        HcCheckConcentrationStat stat = new HcCheckConcentrationStat();
        stat.setChemicals(chemicals);
        stat.setBiologicals(biologicals);
        stat.setDusts(dusts);
        stat.setHighFrequency(highFrequency);
        stat.setIonizingradiation(ionizingradiation);
        stat.setUltrahighfrequencyradiation(ultrahighfrequencyradiation);
        stat.setHandtransmitted(handtransmitted);
        stat.setMicrowaveradiation(microwaveradiation);
        stat.setUltravioletlight(ultravioletlight);
        stat.setPowerfrequency(powerfrequency);
        stat.setHightemperature(hightemperature);
        stat.setLaserradiation(laserradiation);
        for (HcCheckHarmConcentrationForWorkEveryYear year : list) {
            List l;
            if (year.getChemicals() != null) {
                l = year.getChemicals();
                for (HcCheckChemicalConcentrationVo v : l) {
                    if (chemicalsMap.get(v.getHarmName()) == null) {
                        chemicalsMap.put(v.getHarmName(), new ArrayList());
                    }
                    ((ArrayList)chemicalsMap.get(v.getHarmName())).add(v);
                }
            }
            if (year.getBiologicals() != null) {
                l = year.getBiologicals();
                for (HcCheckChemicalConcentrationVo v : l) {
                    if (biologicalsMap.get(v.getHarmName()) == null) {
                        biologicalsMap.put(v.getHarmName(), new ArrayList());
                    }
                    ((ArrayList)biologicalsMap.get(v.getHarmName())).add(v);
                }
            }
            if (year.getDusts() != null) {
                l = year.getDusts();
                for (HcCheckChemicalConcentrationVo v : l) {
                    if (dustsMap.get(v.getHarmName()) == null) {
                        dustsMap.put(v.getHarmName(), new ArrayList());
                    }
                    ((ArrayList)dustsMap.get(v.getHarmName())).add(v);
                }
            }
            if (year.getNoise() != null) {
                noise.add(year.getNoise());
            }
            if (year.getHighFrequency() != null) {
                highFrequency.add(year.getHighFrequency());
            }
            if (year.getIonizingradiation() != null) {
                ionizingradiation.add(year.getIonizingradiation());
            }
            if (year.getUltrahighfrequencyradiation() != null) {
                ultrahighfrequencyradiation.add(year.getUltrahighfrequencyradiation());
            }
            if (year.getHandtransmitted() != null) {
                handtransmitted.add(year.getHandtransmitted());
            }
            if (year.getMicrowaveradiation() != null) {
                microwaveradiation.add(year.getMicrowaveradiation());
            }
            if (year.getUltravioletlight() != null) {
                ultravioletlight.add(year.getUltravioletlight());
            }
            if (year.getPowerfrequency() != null) {
                powerfrequency.add(year.getPowerfrequency());
            }
            if (year.getHightemperature() != null) {
                hightemperature.add(year.getHightemperature());
            }
            if (year.getLaserradiation() == null) continue;
            laserradiation.add(year.getLaserradiation());
        }
        for (String harmName : chemicalsMap.keySet()) {
            HcCheckChemicalConcentrationStat cstat = new HcCheckChemicalConcentrationStat();
            cstat.setHarmName(harmName);
            cstat.setList((List)chemicalsMap.get(harmName));
            stat.getChemicals().add(cstat);
        }
        for (String harmName : biologicalsMap.keySet()) {
            HcCheckBiologicalConcentrationStat bstat = new HcCheckBiologicalConcentrationStat();
            bstat.setHarmName(harmName);
            bstat.setList((List)biologicalsMap.get(harmName));
            stat.getBiologicals().add(bstat);
        }
        for (String harmName : dustsMap.keySet()) {
            HcCheckDustConcentrationStat dstat = new HcCheckDustConcentrationStat();
            dstat.setHarmName(harmName);
            dstat.setList((List)dustsMap.get(harmName));
            stat.getDusts().add(dstat);
        }
        return stat;
    }

    private HcCheckLaserradiationConcentrationVo getHcCheckLaserradiationConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectLaserRadiationVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckLaserradiationConcentrationVo vo = new HcCheckLaserradiationConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u6fc0\u5149\u8f90\u5c04");
        double irradianceTotal = 0.0;
        double exposureTotal = 0.0;
        ArrayList<Double> irradianceList = new ArrayList<Double>();
        ArrayList<Double> exposureList = new ArrayList<Double>();
        for (HcCollectLaserRadiationV v : list) {
            if (StringUtils.isNumber((String)v.getIrradiance())) {
                irradianceList.add(Double.valueOf(v.getIrradiance()));
                irradianceTotal += Double.valueOf(v.getIrradiance()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getExposure())) continue;
            exposureList.add(Double.valueOf(v.getExposure()));
            exposureTotal += Double.valueOf(v.getExposure()).doubleValue();
        }
        if (irradianceList.size() > 0) {
            vo.setIrradianceMax(((Double)Collections.max(irradianceList)).doubleValue());
            vo.setIrradianceMin(((Double)Collections.min(irradianceList)).doubleValue());
            vo.setIrradianceAvg(irradianceTotal / (double)irradianceList.size());
        }
        if (exposureList.size() > 0) {
            vo.setExposureMax(((Double)Collections.max(exposureList)).doubleValue());
            vo.setExposureMin(((Double)Collections.min(exposureList)).doubleValue());
            vo.setExposureAvg(exposureTotal / (double)exposureList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckHightemperatureConcentrationVo getHcCheckHightemperatureConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectHighTemperatureVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckHightemperatureConcentrationVo vo = new HcCheckHightemperatureConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u9ad8\u6e29");
        double checkresultTotal = 0.0;
        ArrayList<Double> checkresultList = new ArrayList<Double>();
        for (HcCollectHighTemperatureV v : list) {
            if (!StringUtils.isNumber((String)v.getCheckResult())) continue;
            checkresultList.add(Double.valueOf(v.getCheckResult()));
            checkresultTotal += Double.valueOf(v.getCheckResult()).doubleValue();
        }
        if (checkresultList.size() > 0) {
            vo.setCheckresultMax(((Double)Collections.max(checkresultList)).doubleValue());
            vo.setCheckresultMin(((Double)Collections.min(checkresultList)).doubleValue());
            vo.setCheckresultAvg(checkresultTotal / (double)checkresultList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckCollectPowerfrequencyConcentrationVo getHcCheckPowerfrequencyConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectPowerFrequencyElectricFieldVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckCollectPowerfrequencyConcentrationVo vo = new HcCheckCollectPowerfrequencyConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u5de5\u9891\u7535\u573a");
        double powerTotal = 0.0;
        ArrayList<Double> powerList = new ArrayList<Double>();
        for (HcCollectPowerFrequencyElectricFieldV v : list) {
            if (!StringUtils.isNumber((String)v.getPower())) continue;
            powerList.add(Double.valueOf(v.getPower()));
            powerTotal += Double.valueOf(v.getPower()).doubleValue();
        }
        if (powerList.size() > 0) {
            vo.setPowerMax(((Double)Collections.max(powerList)).doubleValue());
            vo.setPowerMin(((Double)Collections.min(powerList)).doubleValue());
            vo.setPowerMax(powerTotal / (double)powerList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckCollectUltravioletlightConcentrationVo getHcCheckUltravioletlightConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectUltravioletlightVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckCollectUltravioletlightConcentrationVo vo = new HcCheckCollectUltravioletlightConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u7d2b\u5916\u8f90\u5c04");
        double irradianceTotal = 0.0;
        double exposureTotal = 0.0;
        ArrayList<Double> irradianceList = new ArrayList<Double>();
        ArrayList<Double> exposureList = new ArrayList<Double>();
        for (HcCollectUltravioletlightV v : list) {
            if (StringUtils.isNumber((String)v.getIrradiance())) {
                irradianceList.add(Double.valueOf(v.getIrradiance()));
                irradianceTotal += Double.valueOf(v.getIrradiance()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getExposure())) continue;
            exposureList.add(Double.valueOf(v.getExposure()));
            exposureTotal += Double.valueOf(v.getExposure()).doubleValue();
        }
        if (irradianceList.size() > 0) {
            vo.setIrradianceMax(((Double)Collections.max(irradianceList)).doubleValue());
            vo.setIrradianceMin(((Double)Collections.min(irradianceList)).doubleValue());
            vo.setIrradianceAvg(irradianceTotal / (double)irradianceList.size());
        }
        if (exposureList.size() > 0) {
            vo.setExposureMax(((Double)Collections.max(exposureList)).doubleValue());
            vo.setExposureMin(((Double)Collections.min(exposureList)).doubleValue());
            vo.setExposureAvg(exposureTotal / (double)exposureList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckCollectMicrowaveradiationConcentrationVo getHcCheckMicrowaveradiationConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectMicrowaveradiationVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckCollectMicrowaveradiationConcentrationVo vo = new HcCheckCollectMicrowaveradiationConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u5fae\u6ce2\u8f90\u5c04");
        double amountTotal = 0.0;
        double avgDensityTotal = 0.0;
        double powerDensityTotal = 0.0;
        ArrayList<Double> amountList = new ArrayList<Double>();
        ArrayList<Double> avgDensityList = new ArrayList<Double>();
        ArrayList<Double> powerDensityList = new ArrayList<Double>();
        for (HcCollectMicrowaveradiationV v : list) {
            if (StringUtils.isNumber((String)v.getAmount())) {
                amountList.add(Double.valueOf(v.getAmount()));
                amountTotal += Double.valueOf(v.getAmount()).doubleValue();
            }
            if (StringUtils.isNumber((String)v.getAvgDensity())) {
                avgDensityList.add(Double.valueOf(v.getAvgDensity()));
                avgDensityTotal += Double.valueOf(v.getAvgDensity()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getPowerDensity())) continue;
            powerDensityList.add(Double.valueOf(v.getPowerDensity()));
            powerDensityTotal += Double.valueOf(v.getPowerDensity()).doubleValue();
        }
        if (amountList.size() > 0) {
            vo.setAmountMax(((Double)Collections.max(amountList)).doubleValue());
            vo.setAmountMin(((Double)Collections.min(amountList)).doubleValue());
            vo.setAmountAvg(amountTotal / (double)amountList.size());
        }
        if (avgDensityList.size() > 0) {
            vo.setAvgdensityMax(((Double)Collections.max(avgDensityList)).doubleValue());
            vo.setAvgdensityMin(((Double)Collections.min(avgDensityList)).doubleValue());
            vo.setAvgdensityAvg(avgDensityTotal / (double)avgDensityList.size());
        }
        if (powerDensityList.size() > 0) {
            vo.setPowerdensityMax(((Double)Collections.max(powerDensityList)).doubleValue());
            vo.setPowerdensityMin(((Double)Collections.min(powerDensityList)).doubleValue());
            vo.setPowerdensityAvg(powerDensityTotal / (double)powerDensityList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckHandtransmittedConcentrationVo getHcCheckHandtransmittedConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectHandTransmittedVibrationVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckHandtransmittedConcentrationVo vo = new HcCheckHandtransmittedConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u624b\u4f20\u632f\u52a8");
        double speedTotal = 0.0;
        ArrayList<Double> speedList = new ArrayList<Double>();
        for (HcCollectHandTransmittedVibrationV v : list) {
            if (!StringUtils.isNumber((String)v.getSpeed())) continue;
            speedList.add(Double.valueOf(v.getSpeed()));
            speedTotal += Double.valueOf(v.getSpeed()).doubleValue();
        }
        if (speedList.size() > 0) {
            vo.setSpeedMax(((Double)Collections.max(speedList)).doubleValue());
            vo.setSpeedMin(((Double)Collections.min(speedList)).doubleValue());
            vo.setSpeedAvg(speedTotal / (double)speedList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckUltrahighfrequencyradiationConcentrationVo getHcCheckUltrahighfrequencyradiationConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectUhfRadiationVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckUltrahighfrequencyradiationConcentrationVo vo = new HcCheckUltrahighfrequencyradiationConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u8d85\u9ad8\u9891\u8f90\u5c04");
        double powerTotal = 0.0;
        double electricTotal = 0.0;
        ArrayList<Double> powerList = new ArrayList<Double>();
        ArrayList<Double> electricList = new ArrayList<Double>();
        for (HcCollectUhfRadiationV v : list) {
            if (StringUtils.isNumber((String)v.getPower())) {
                powerList.add(Double.valueOf(v.getPower()));
                powerTotal += Double.valueOf(v.getPower()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getElectric())) continue;
            electricList.add(Double.valueOf(v.getElectric()));
            electricTotal += Double.valueOf(v.getElectric()).doubleValue();
        }
        if (powerList.size() > 0) {
            vo.setPowerMax(((Double)Collections.max(powerList)).doubleValue());
            vo.setPowerMin(((Double)Collections.min(powerList)).doubleValue());
            vo.setPowerAvg(powerTotal / (double)powerList.size());
        }
        if (electricList.size() > 0) {
            vo.setElectricMax(((Double)Collections.max(electricList)).doubleValue());
            vo.setElectricMin(((Double)Collections.min(electricList)).doubleValue());
            vo.setElectricAvg(electricTotal / (double)electricList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckIonizingradiationConcentrationVo getHcCheckIonizingradiationConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectIonizingradiationVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckIonizingradiationConcentrationVo vo = new HcCheckIonizingradiationConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u7535\u79bb\u8f90\u5c04");
        double checkresultTotal = 0.0;
        ArrayList<Double> checkresultList = new ArrayList<Double>();
        for (HcCollectIonizingradiationV v : list) {
            if (StringUtils.isNumber((String)v.getCheckresult1())) {
                checkresultList.add(Double.valueOf(v.getCheckresult1()));
                checkresultTotal += Double.valueOf(v.getCheckresult1()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getCheckresult2())) continue;
            checkresultList.add(Double.valueOf(v.getCheckresult2()));
            checkresultTotal += Double.valueOf(v.getCheckresult2()).doubleValue();
        }
        if (checkresultList.size() > 0) {
            vo.setCheckresultMax(((Double)Collections.max(checkresultList)).doubleValue());
            vo.setCheckresultMin(((Double)Collections.min(checkresultList)).doubleValue());
            vo.setCheckresultAvg(checkresultTotal / (double)(checkresultList.size() * 2));
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckHighFrequencyConcentrationVo getHcCheckHighFrequencyConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectEhighFrequencyVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckHighFrequencyConcentrationVo vo = new HcCheckHighFrequencyConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u9ad8\u9891\u7535\u78c1\u573a");
        double estrongTotal = 0.0;
        double mstrongTotal = 0.0;
        ArrayList<Double> estrongList = new ArrayList<Double>();
        ArrayList<Double> mstrongList = new ArrayList<Double>();
        for (HcCollectEhighFrequencyV v : list) {
            if (StringUtils.isNumber((String)v.getEstrong())) {
                estrongList.add(Double.valueOf(v.getEstrong()));
                estrongTotal += Double.valueOf(v.getEstrong()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getMstrong())) continue;
            mstrongList.add(Double.valueOf(v.getMstrong()));
            mstrongTotal += Double.valueOf(v.getMstrong()).doubleValue();
        }
        if (estrongList.size() > 0) {
            vo.setEstrongMax(((Double)Collections.max(estrongList)).doubleValue());
            vo.setEstrongMin(((Double)Collections.min(estrongList)).doubleValue());
            vo.setEstrongAvg(estrongTotal / (double)estrongList.size());
        }
        if (mstrongList.size() > 0) {
            vo.setMstrongMax(((Double)Collections.max(mstrongList)).doubleValue());
            vo.setMstrongMin(((Double)Collections.min(mstrongList)).doubleValue());
            vo.setMstrongAvg(mstrongTotal / (double)mstrongList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private HcCheckNoiseConcentrationVo getHcCheckNoiseConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectNoiseVByYearAndHarmIds(cid, collectType, harmIds, year);
        HcCheckNoiseConcentrationVo vo = new HcCheckNoiseConcentrationVo();
        vo.setCollectType(collectType);
        vo.setHarmName("\u566a\u58f0");
        double equallevelTotal = 0.0;
        double maxnoiseTotal = 0.0;
        ArrayList<Double> equallevelList = new ArrayList<Double>();
        ArrayList<Double> maxnoiseList = new ArrayList<Double>();
        for (HcCollectNoiseV v : list) {
            if (StringUtils.isNumber((String)v.getEqualLevel())) {
                equallevelList.add(Double.valueOf(v.getEqualLevel()));
                equallevelTotal += Double.valueOf(v.getEqualLevel()).doubleValue();
            }
            if (!StringUtils.isNumber((String)v.getMaxNoise())) continue;
            maxnoiseList.add(Double.valueOf(v.getMaxNoise()));
            maxnoiseTotal += Double.valueOf(v.getMaxNoise()).doubleValue();
        }
        if (equallevelList.size() > 0) {
            vo.setEquallevelMax(((Double)Collections.max(equallevelList)).doubleValue());
            vo.setEquallevelMin(((Double)Collections.min(equallevelList)).doubleValue());
            vo.setEquallevelAvg(equallevelTotal / (double)equallevelList.size());
        }
        if (maxnoiseList.size() > 0) {
            vo.setMaxnoiseMax(((Double)Collections.max(maxnoiseList)).doubleValue());
            vo.setMaxnoiseMin(((Double)Collections.min(maxnoiseList)).doubleValue());
            vo.setMaxnoiseAvg(maxnoiseTotal / (double)maxnoiseList.size());
        }
        vo.setYear(year);
        return vo;
    }

    private List<HcCheckDustConcentrationVo> getHcCheckDustConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectHcCollectDustVByYearAndHarmIds(cid, collectType, harmIds, year);
        ArrayList<HcCheckDustConcentrationVo> finalList = new ArrayList<HcCheckDustConcentrationVo>();
        HashMap map = new HashMap();
        for (HcCollectDustV v : list) {
            if (map.get(v.getCheckProj()) == null) {
                map.put(v.getCheckProj(), new ArrayList());
            }
            ((ArrayList)map.get(v.getCheckProj())).add(v);
        }
        for (String harmId : map.keySet()) {
            List vs = (List)map.get(harmId);
            HcCheckDustConcentrationVo vo = new HcCheckDustConcentrationVo();
            vo.setHarmId(Long.valueOf(harmId));
            OccupationalRiskFactors o = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(vo.getHarmId());
            if (o != null) {
                vo.setHarmName(o.getNameCh());
            }
            vo.setCollectType(collectType);
            double ctwa1Total = 0.0;
            double time1Total = 0.0;
            double peakcontactconcentration1Total = 0.0;
            double ctwa2Total = 0.0;
            double time2Total = 0.0;
            double peakcontactconcentration2Total = 0.0;
            ArrayList<Double> ctwa1List = new ArrayList<Double>();
            ArrayList<Double> time1List = new ArrayList<Double>();
            ArrayList<Double> peakcontactconcentration1List = new ArrayList<Double>();
            ArrayList<Double> ctwa2List = new ArrayList<Double>();
            ArrayList<Double> time2List = new ArrayList<Double>();
            ArrayList<Double> peakcontactconcentration2List = new ArrayList<Double>();
            for (int i = 0; i < vs.size(); ++i) {
                if (StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getCtwa1())) {
                    double ctwa1 = Double.valueOf(((HcCollectDustV)vs.get(i)).getCtwa1());
                    ctwa1List.add(ctwa1);
                    ctwa1Total += ctwa1;
                }
                if (StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getTimes1())) {
                    double time1 = Double.valueOf(((HcCollectDustV)vs.get(i)).getTimes1());
                    time1List.add(time1);
                    time1Total += time1;
                }
                if (StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getPeakcontactconcentration1())) {
                    double peakcontactconcentration1 = Double.valueOf(((HcCollectDustV)vs.get(i)).getPeakcontactconcentration1());
                    peakcontactconcentration1List.add(peakcontactconcentration1);
                    peakcontactconcentration1Total += peakcontactconcentration1;
                }
                if (StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getCtwa2())) {
                    double ctwa2 = Double.valueOf(((HcCollectDustV)vs.get(i)).getCtwa2());
                    ctwa2List.add(ctwa2);
                    ctwa2Total += ctwa2;
                }
                if (StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getTimes2())) {
                    double time2 = Double.valueOf(((HcCollectDustV)vs.get(i)).getTimes2());
                    time2List.add(time2);
                    time2Total += time2;
                }
                if (!StringUtils.isNumber((String)((HcCollectDustV)vs.get(i)).getPeakcontactconcentration2())) continue;
                double peakcontactconcentration2 = Double.valueOf(((HcCollectDustV)vs.get(i)).getPeakcontactconcentration2());
                peakcontactconcentration2List.add(peakcontactconcentration2);
                peakcontactconcentration2Total += peakcontactconcentration2;
            }
            if (ctwa1List.size() > 0) {
                vo.setCtwa1Max(((Double)Collections.max(ctwa1List)).doubleValue());
                vo.setCtwa1Min(((Double)Collections.min(ctwa1List)).doubleValue());
                vo.setCtwa1Avg(ctwa1Total / (double)ctwa1List.size());
            }
            if (time1List.size() > 0) {
                vo.setTimes1Max(((Double)Collections.max(time1List)).doubleValue());
                vo.setTimes1Min(((Double)Collections.min(time1List)).doubleValue());
                vo.setTimes1Avg(time1Total / (double)time1List.size());
            }
            if (peakcontactconcentration1List.size() > 0) {
                vo.setPeakcontactconcentration1Max(((Double)Collections.max(peakcontactconcentration1List)).doubleValue());
                vo.setPeakcontactconcentration1Min(((Double)Collections.min(peakcontactconcentration1List)).doubleValue());
                vo.setPeakcontactconcentration1Avg(peakcontactconcentration1Total / (double)peakcontactconcentration1List.size());
            }
            if (ctwa2List.size() > 0) {
                vo.setCtwa2Max(((Double)Collections.max(ctwa2List)).doubleValue());
                vo.setCtwa2Min(((Double)Collections.min(ctwa2List)).doubleValue());
                vo.setCtwa2Avg(ctwa2Total / (double)ctwa2List.size());
            }
            if (time2List.size() > 0) {
                vo.setTimes2Max(((Double)Collections.max(time2List)).doubleValue());
                vo.setTimes2Min(((Double)Collections.min(time2List)).doubleValue());
                vo.setTimes2Avg(time2Total / (double)time2List.size());
            }
            if (peakcontactconcentration2List.size() > 0) {
                vo.setPeakcontactconcentration2Max(((Double)Collections.max(peakcontactconcentration2List)).doubleValue());
                vo.setPeakcontactconcentration2Min(((Double)Collections.min(peakcontactconcentration2List)).doubleValue());
                vo.setPeakcontactconcentration2Avg(peakcontactconcentration2Total / (double)peakcontactconcentration2List.size());
            }
            vo.setYear(year);
            finalList.add(vo);
        }
        return finalList;
    }

    private List<HcCheckChemicalConcentrationVo> getHcCheckChemicalConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectChemicalVByYearAndHarmIds(cid, collectType, harmIds, year);
        ArrayList<HcCheckChemicalConcentrationVo> finalList = new ArrayList<HcCheckChemicalConcentrationVo>();
        HashMap map = new HashMap();
        for (HcCollectChemicalV v : list) {
            if (map.get(v.getCheckProj()) == null) {
                map.put(v.getCheckProj(), new ArrayList());
            }
            ((ArrayList)map.get(v.getCheckProj())).add(v);
        }
        for (String harmId : map.keySet()) {
            List vs = (List)map.get(harmId);
            HcCheckChemicalConcentrationVo vo = new HcCheckChemicalConcentrationVo();
            vo.setHarmId(Long.valueOf(harmId));
            OccupationalRiskFactors o = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(vo.getHarmId());
            if (o != null) {
                vo.setHarmName(o.getNameCh());
            }
            vo.setCollectType(collectType);
            double cmacTotal = 0.0;
            double ctwaTotal = 0.0;
            double cstelTotal = 0.0;
            double timesTotal = 0.0;
            double peakcontactconcentrationTotal = 0.0;
            ArrayList<Double> cmacList = new ArrayList<Double>();
            ArrayList<Double> ctwaList = new ArrayList<Double>();
            ArrayList<Double> cstelList = new ArrayList<Double>();
            ArrayList<Double> timesList = new ArrayList<Double>();
            ArrayList<Double> peakcontactconcentrationList = new ArrayList<Double>();
            for (int i = 0; i < vs.size(); ++i) {
                if (StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getCmac())) {
                    double cmac1 = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getCmac());
                    cmacList.add(cmac1);
                    cmacTotal += cmac1;
                }
                if (StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getCtwa())) {
                    double ctwa1 = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getCtwa());
                    ctwaList.add(ctwa1);
                    ctwaTotal += ctwa1;
                }
                if (StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getCstel2())) {
                    double cstel2 = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getCstel2());
                    cstelList.add(cstel2);
                    cstelTotal += cstel2;
                }
                if (StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getCstel3())) {
                    double cstel3 = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getCstel3());
                    cstelList.add(cstel3);
                    cstelTotal += cstel3;
                }
                if (StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getTimes())) {
                    double times = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getTimes());
                    timesList.add(times);
                    timesTotal += times;
                }
                if (!StringUtils.isNumber((String)((HcCollectChemicalV)vs.get(i)).getPeakcontactconcentration())) continue;
                double peakcontactconcentration = Double.valueOf(((HcCollectChemicalV)vs.get(i)).getPeakcontactconcentration());
                peakcontactconcentrationList.add(peakcontactconcentration);
                peakcontactconcentrationTotal += peakcontactconcentration;
            }
            if (cmacList.size() > 0) {
                vo.setCmacMax(((Double)Collections.max(cmacList)).doubleValue());
                vo.setCmacMin(((Double)Collections.min(cmacList)).doubleValue());
                vo.setCmacAvg(cmacTotal / (double)cmacList.size());
            }
            if (ctwaList.size() > 0) {
                vo.setCtwaMax(((Double)Collections.max(ctwaList)).doubleValue());
                vo.setCtwaMin(((Double)Collections.min(ctwaList)).doubleValue());
                vo.setCtwaAvg(ctwaTotal / (double)ctwaList.size());
            }
            if (cstelList.size() > 0) {
                vo.setCstelMax(((Double)Collections.max(cstelList)).doubleValue());
                vo.setCstelMin(((Double)Collections.min(cstelList)).doubleValue());
                vo.setCstelAvg(cstelTotal / (double)(cstelList.size() * 2));
            }
            if (timesList.size() > 0) {
                vo.setTimesMax(((Double)Collections.max(timesList)).doubleValue());
                vo.setTimesMin(((Double)Collections.min(timesList)).doubleValue());
                vo.setTimesAvg(timesTotal / (double)timesList.size());
            }
            if (peakcontactconcentrationList.size() > 0) {
                vo.setPeakcontactconcentrationMax(((Double)Collections.max(peakcontactconcentrationList)).doubleValue());
                vo.setPeakcontactconcentrationMin(((Double)Collections.max(peakcontactconcentrationList)).doubleValue());
                vo.setPeakcontactconcentrationAvg(peakcontactconcentrationTotal / (double)peakcontactconcentrationList.size());
            }
            vo.setYear(year);
            finalList.add(vo);
        }
        return finalList;
    }

    private List<HcCheckBiologicalConcentrationVo> getHcCheckBiologicalConcentrationVosByYearAndHarmIds(Long cid, Integer collectType, String harmIds, Integer year) {
        List list = this.hcCheckResultCollectDataService.getHcCollectBiologicalFactorVByYearAndHarmIds(cid, collectType, harmIds, year);
        ArrayList<HcCheckBiologicalConcentrationVo> finalList = new ArrayList<HcCheckBiologicalConcentrationVo>();
        HashMap map = new HashMap();
        for (HcCollectBiologicalFactorV v : list) {
            if (map.get(v.getCheckProj()) == null) {
                map.put(v.getCheckProj(), new ArrayList());
            }
            ((ArrayList)map.get(v.getCheckProj())).add(v);
        }
        for (String harmId : map.keySet()) {
            List vs = (List)map.get(harmId);
            HcCheckBiologicalConcentrationVo vo = new HcCheckBiologicalConcentrationVo();
            vo.setHarmId(Long.valueOf(harmId));
            OccupationalRiskFactors o = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(vo.getHarmId());
            if (o != null) {
                vo.setHarmName(o.getNameCh());
            }
            vo.setCollectType(collectType);
            double cmacTotal = 0.0;
            double ctwaTotal = 0.0;
            double cstelTotal = 0.0;
            double timesTotal = 0.0;
            ArrayList<Double> cmacList = new ArrayList<Double>();
            ArrayList<Double> ctwaList = new ArrayList<Double>();
            ArrayList<Double> cstelList = new ArrayList<Double>();
            ArrayList<Double> timesList = new ArrayList<Double>();
            for (int i = 0; i < vs.size(); ++i) {
                if (StringUtils.isNumber((String)((HcCollectBiologicalFactorV)vs.get(i)).getCmac1())) {
                    double cmac1 = Double.valueOf(((HcCollectBiologicalFactorV)vs.get(i)).getCmac1());
                    if (!StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCmac2())[0].equals("0")) {
                        cmac1 *= Double.valueOf(StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCmac2())[0]).doubleValue();
                    }
                    cmacList.add(cmac1);
                    cmacTotal += cmac1;
                }
                if (StringUtils.isNumber((String)((HcCollectBiologicalFactorV)vs.get(i)).getCtwa1())) {
                    double ctwa1 = Double.valueOf(((HcCollectBiologicalFactorV)vs.get(i)).getCtwa1());
                    if (!StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCtwa2())[0].equals("0")) {
                        ctwa1 *= Double.valueOf(StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCtwa2())[0]).doubleValue();
                    }
                    ctwaList.add(ctwa1);
                    ctwaTotal += ctwa1;
                }
                if (StringUtils.isNumber((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel2())) {
                    double cstel2 = Double.valueOf(((HcCollectBiologicalFactorV)vs.get(i)).getCstel2());
                    if (!StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel2())[0].equals("0")) {
                        cstel2 *= Double.valueOf(StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel4())[0]).doubleValue();
                    }
                    cstelList.add(cstel2);
                    cstelTotal += cstel2;
                }
                if (StringUtils.isNumber((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel3())) {
                    double cstel3 = Double.valueOf(((HcCollectBiologicalFactorV)vs.get(i)).getCstel3());
                    if (!StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel3())[0].equals("0")) {
                        cstel3 *= Double.valueOf(StringUtils.getNumAndChinese((String)((HcCollectBiologicalFactorV)vs.get(i)).getCstel4())[0]).doubleValue();
                    }
                    cstelList.add(cstel3);
                    cstelTotal += cstel3;
                }
                if (!StringUtils.isNumber((String)((HcCollectBiologicalFactorV)vs.get(i)).getTimes())) continue;
                double times = Double.valueOf(((HcCollectBiologicalFactorV)vs.get(i)).getTimes());
                timesList.add(times);
                timesTotal += times;
            }
            if (cmacList.size() > 0) {
                vo.setCmacMax(((Double)Collections.max(cmacList)).doubleValue());
                vo.setCmacMin(((Double)Collections.min(cmacList)).doubleValue());
                vo.setCmacAvg(cmacTotal / (double)cmacList.size());
            }
            if (ctwaList.size() > 0) {
                vo.setCtwaMax(((Double)Collections.max(ctwaList)).doubleValue());
                vo.setCtwaMin(((Double)Collections.min(ctwaList)).doubleValue());
                vo.setCtwaAvg(ctwaTotal / (double)ctwaList.size());
            }
            if (cstelList.size() > 0) {
                vo.setCstelMax(((Double)Collections.max(cstelList)).doubleValue());
                vo.setCstelMin(((Double)Collections.min(cstelList)).doubleValue());
                vo.setCstelAvg(cstelTotal / (double)(cstelList.size() * 2));
            }
            if (timesList.size() > 0) {
                vo.setTimesMax(((Double)Collections.max(timesList)).doubleValue());
                vo.setTimesMin(((Double)Collections.min(timesList)).doubleValue());
                vo.setTimesAvg(timesTotal / (double)timesList.size());
            }
            vo.setYear(year);
            finalList.add(vo);
        }
        return finalList;
    }

    public List<HcCheckPlan> getHcCheckPlanListBySearchParam(HcCheckPlan hc) {
        return this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
    }

    public List<HcCheckPlan> exportHcCheckPlanCompeledData(HcCheckPlan hc, boolean isThirdOrganization) {
        List<Object> list = new ArrayList();
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        list = isThirdOrganization ? this.hcCheckPlanMapper.getThirdHcCheckPlanListInCludeNullifyBySearchParam(hc) : this.hcCheckPlanMapper.getHcCheckPlanListInCludeNullifyBySearchParam(hc);
        for (int i = 0; i < list.size(); ++i) {
            HcCheckType type;
            HcCheckPlan h = (HcCheckPlan)list.get(i);
            h.setId(Long.valueOf((long)i + 1L));
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() != null) {
                h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
            }
            if (h.getUpdateDate() == null) continue;
            h.setCheckOrgName(DateUtils.format((Date)h.getUpdateDate(), (String)"yyyy-MM-dd"));
        }
        return list;
    }

    public List<HcCheckPlan> exportgetHcCheckPlanResultInform(HcCheckPlan hc) {
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.getHcCheckPlanListBySearchParam(hc);
        for (int i = 0; i < list.size(); ++i) {
            HcCheckType type;
            HcCheckPlan h = list.get(i);
            h.setId(Long.valueOf((long)i + 1L));
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() != null) {
                h.setManagerName(this.staffInfoService.getStaffNameByStaffId(h.getManager()));
            }
            if (h.getUpdateDate() != null) {
                h.setCheckOrgName(DateUtils.format((Date)h.getUpdateDate(), (String)"yyyy-MM-dd"));
            }
            if (!StringUtils.isNotEmpty((String)h.getCheckResultCertificateFileIds())) continue;
            String[] fileStrs = h.getCheckResultCertificateFileIds().split(",");
            Object name = "";
            for (String id : fileStrs) {
                SysFileModel sysFile;
                if (!StringUtils.isNotEmpty((String)id) || id.contains("null") || (sysFile = this.sysFileService.getFileById(Long.valueOf(id))) == null) continue;
                name = (String)name + sysFile.getFileName() + ",";
            }
            if (!StringUtils.isNotEmpty((String)name)) continue;
            h.setCheckResultCertificateFileNames(((String)name).substring(0, ((String)name).lastIndexOf(",")));
        }
        return list;
    }

    public List<HarmfactorWorkSource> getHarmfactorWorkByWorkIdAndHarmName(Long workId, String harmName) {
        return this.hcCheckPlanMapper.getHarmfactorWorkByWorkIdAndHarmName(workId, harmName);
    }

    public Integer getCompeletedHcCheckCount(Long cid) {
        Example e = new Example(HcCheckPlan.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)2);
        return this.hcCheckPlanMapper.selectCountByExample(e);
    }

    public List<HcCheckPlan> getListByIdsAndDesc(List<Long> hcIds, Date workRoleStartDate, Date workRoleendDate) {
        Example e = new Example(HcCheckPlan.class);
        if (workRoleStartDate != null) {
            String start = DateUtils.format((Date)workRoleStartDate, (String)"yyyy-MM-dd") + " 00:00:00";
            workRoleStartDate = DateUtils.parseDate((Object)start);
        }
        if (workRoleendDate != null) {
            String end = DateUtils.format((Date)workRoleendDate, (String)"yyyy-MM-dd") + " 23:59:59";
            workRoleendDate = DateUtils.parseDate((Object)end);
        }
        e.createCriteria().andIn("id", hcIds).andGreaterThanOrEqualTo("checkTimeBegin", (Object)workRoleStartDate).andLessThanOrEqualTo("checkTimeBegin", (Object)workRoleendDate);
        e.orderBy("checkTimeBegin").desc();
        return this.hcCheckPlanMapper.selectByExample(e);
    }

    @Transactional(readOnly=false)
    public Boolean hcCheckPlanNullifyByHcId(Long hcId, Long loginStaffId) {
        if (hcId != null) {
            HcCheckPlan hc = new HcCheckPlan();
            hc.setId(hcId);
            hc.setStatus(HcCheckPlanStatusEnum.NULLIFY.getCode());
            this.update(hc);
            this.sysCoreWorkModuleCorrelationService.soureBusinessDelete(hcId, loginStaffId);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public Boolean hcCheckPlanResultNullifyById(Long resutlId, Long staffId) {
        if (resutlId != null) {
            HcCheckResultReport hc = new HcCheckResultReport();
            hc.setId(resutlId);
            hc.setStatus(Byte.valueOf("2"));
            this.hcCheckResultReportService.update((Object)hc, staffId);
            return true;
        }
        return false;
    }

    public PageInfo<HcCheckPlan> getHcCheckPlanListInCludeNullifyBySearchParam(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListInCludeNullifyBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(h.getManager()));
        }
        return new PageInfo(list);
    }

    public boolean isFinishedHarmFactorRegularCheck(Long cid, int year) {
        Integer count = this.hcCheckPlanMapper.getHcCheckPlanCountByTypeAndCidAndYear(cid, "" + year, HcCheckTypeEnum.REGULAR.getValue(), HcCheckPlanStatusEnum.CHECKED.getCode());
        return count == null ? false : count > 0;
    }

    public HcCheckPlan getLastHarmFactorRegularCheck(Long cid, int year) {
        Example example = new Example(HcCheckPlan.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andEqualTo("cid", (Object)cid);
        criteria.andEqualTo("checkType", (Object)HcCheckTypeEnum.REGULAR.getValue());
        criteria.andEqualTo("status", (Object)HcCheckPlanStatusEnum.CHECKED.getCode());
        example.setOrderByClause("check_time_begin desc");
        List list = super.getListByExample(example);
        return list == null || list.isEmpty() ? null : (HcCheckPlan)list.get(0);
    }

    public LastHarmFactorTestInfo getLastEvalForHarmFactor(Long cid) {
        HcCheckPlan hc = this.hcCheckPlanMapper.getLastEvalForHarmFactor(cid);
        LastHarmFactorTestInfo data = new LastHarmFactorTestInfo();
        if (hc == null) {
            return null;
        }
        data.setHarmFactorId(hc.getId());
        data.setLastDate(hc.getCheckTimeBegin());
        return data;
    }

    public HcCheckPlan getLastHarmFactorInfo(Long cid) {
        return this.hcCheckPlanMapper.getLastHarmFactorInfo(cid);
    }

    public int getHarmFactorInformNum(Long cid) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(Byte.valueOf((byte)2));
        hc.setIsInformed(Boolean.valueOf(true));
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckPlanListBySearchParam(hc);
        return list.size();
    }

    public List<String> getHighHarmFactorFromHarmFactorCheck(Integer type, Long cid) {
        return this.hcCheckPlanMapper.getHighHarmFactorFromHarmFactorCheck(cid, type);
    }

    @Transactional(readOnly=false)
    public void deleteReformForHcCheckPlanByReformId(Long reformId, Long userStaffId) {
        this.reformItemBasicService.deleteByIdAndBusinessType(reformId, userStaffId, BusinessTypeEnum.hccheckplan);
        this.recoveryNoAccordsByReformId(reformId);
    }

    public List<Long> getHcCheckPlanCompletedListByCheckTimeRange(Long cid, Date checkBigenTime, Date checkEndTime) {
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        hc.setStartTime(checkBigenTime);
        hc.setEndTime(checkEndTime);
        ArrayList<Long> ids = new ArrayList<Long>();
        List<HcCheckPlan> list = this.getHcCheckPlanListBySearchParam(hc);
        for (HcCheckPlan h : list) {
            ids.add(h.getId());
        }
        return ids;
    }

    public Integer getCheckPlanNowStatusCount(Long cid, Long evaId) {
        return this.hcCheckPlanMapper.getCheckPlanNowStatusCount(cid, evaId);
    }

    public Integer getCheckPlanControlEvaluationCount(Long cid, Long evaId) {
        return this.hcCheckPlanMapper.getCheckPlanControlEvaluationCount(cid, evaId);
    }

    @Transactional(readOnly=false)
    public HcCheckPlan updateHcCheckThirdOrgPlanSumbit(HcCheckPlan hcCheckThirdOrgPlan, Long loginBy) {
        if (hcCheckThirdOrgPlan.getId() != null) {
            this.update(hcCheckThirdOrgPlan, loginBy);
            HcCheckPlan hc = (HcCheckPlan)this.getById(hcCheckThirdOrgPlan.getId());
            if (hcCheckThirdOrgPlan.getProjAppearStatus() != null && hcCheckThirdOrgPlan.getProjAppearStatus() == 2) {
                this.sysCoreWorkModuleCorrelationService.appearHcCheckThirdPlan(CoreWorkEnum.harmfactorTest, hcCheckThirdOrgPlan.getId(), hcCheckThirdOrgPlan.getCheckWorkName(), loginBy, hc.getCid());
            }
            if (hc.getCid() != null) {
                CompanyBaseInfoModel data = this.companyProvideByHSEService.getCompanyById(hc.getCid());
                CompanyBaseInfo companyH = (CompanyBaseInfo)this.companyBaseInfoServiceImpl.getById(hc.getCid());
                if (companyH != null && data != null && data.getAreaId() != null && !data.getAreaId().equals(companyH.getAreaId())) {
                    CompanyBaseInfo companyBaseInfo = new CompanyBaseInfo();
                    companyBaseInfo.setId(data.getId());
                    companyBaseInfo.setName(data.getName());
                    companyBaseInfo.setAreaId(data.getAreaId());
                    this.companyBaseInfoServiceImpl.update(companyBaseInfo);
                }
            }
        }
        return hcCheckThirdOrgPlan;
    }

    public PageInfo<HcCheckPlan> getThirdHcCheckPlanListBySearchParam(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getThirdHcCheckPlanListBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
        }
        return new PageInfo(list);
    }

    public PageInfo<HcCheckPlan> getThirdHcCheckPlanListInCludeNullifyBySearchParam(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getThirdHcCheckPlanListInCludeNullifyBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                h.setCheckOrgName(this.companyOrganizationService.getOrgNameById(h.getThirdPartyOrCheckOrgId()));
            }
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdPartyOrCheckOrgId() != null) {
                // empty if block
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getFullStaffRealNameAndOrgName(h.getManager()));
        }
        return new PageInfo(list);
    }

    public HcCheckPlanFirstPageVo getThirdOrgHcCheckPlanFirstPageVo(Long cid) {
        HcCheckPlanFirstPageVo vo = new HcCheckPlanFirstPageVo();
        HcCheckPlan hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKING.getCode());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        DataScope dataScope = DataScopeHelper.getDataScope();
        List<HcCheckPlan> list1 = this.hcCheckPlanMapper.getThirdHcCheckPlanListBySearchParam(hc);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        DataScopeHelper.setDataScope(dataScope);
        List<HcCheckPlan> list2 = this.hcCheckPlanMapper.getThirdHcCheckPlanListBySearchParam(hc);
        if (list1.size() > 0 || list2.size() > 0) {
            vo.setIsNeedAddCheck(Boolean.valueOf(false));
        } else {
            vo.setIsNeedAddCheck(Boolean.valueOf(true));
        }
        hc = new HcCheckPlan();
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKING.getCode());
        hc.setCheckPlanType(Byte.valueOf((byte)0));
        DataScopeHelper.setDataScope(dataScope);
        List<HcCheckPlan> list3 = this.hcCheckPlanMapper.getThirdHcCheckPlanListBySearchParam(hc);
        vo.setUnderwayCount(Integer.valueOf(list3.size()));
        Integer noAccordCount = this.hcCheckResultCollectDataMapper.getHcCheckCollectNotAccordDatasNotSelected(cid, null, false).size();
        Integer fromReformCount = this.reformItemBasicService.getReformCountHarmFactorDraff(cid);
        if (noAccordCount > 0 || fromReformCount > 0) {
            vo.setIsHasNoAccordItem(Boolean.valueOf(true));
        } else {
            vo.setIsHasNoAccordItem(Boolean.valueOf(false));
        }
        Integer reformCount = this.reformItemBasicService.getReformItemFinishedForHarmFactor(cid);
        DataScopeHelper.setDataScope(dataScope);
        Integer againCount = this.hcCheckPlanMapper.getCheckPlanAgainCHeckingCountByCid(cid);
        vo.setReformedCount(Integer.valueOf(reformCount + againCount));
        dataScope.setMainTableName("hc_check_result_report");
        DataScopeHelper.setDataScope(dataScope);
        Integer noReportCount = this.hcCheckResultReportService.getNoReportHcCheckPlansCount(cid);
        DataScopeHelper.setDataScope(dataScope);
        Integer reportingCount = this.hcCheckResultReportService.getHcCheckResultReportingCountList(cid);
        if (noReportCount > 0 || reportingCount > 0) {
            vo.setIsHasNeedReport(Boolean.valueOf(true));
        } else {
            vo.setIsHasNeedReport(Boolean.valueOf(false));
        }
        Boolean isIgnoreOneYear = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.harmfactorTest_oneYearCheck, cid, 1);
        if (!isIgnoreOneYear.booleanValue()) {
            Integer OneYearToCheckCount = this.hcCheckPlanMapper.getHcCheckPlanLessOneYearToCheckCount(cid, Calendar.getInstance().get(1));
            Integer checkTypeOfRegularCount = this.hcCheckPlanMapper.getHcCheckPlanCheckTypeOfRegularCount(cid, Calendar.getInstance().get(1));
            if (OneYearToCheckCount != null && OneYearToCheckCount >= 1 && checkTypeOfRegularCount > 0) {
                vo.setIsHasOneYearToCheck(Boolean.valueOf(true));
            } else {
                vo.setIsHasOneYearToCheck(Boolean.valueOf(false));
            }
        } else {
            vo.setIsHasOneYearToCheck(Boolean.valueOf(false));
        }
        Boolean isIgnoreThreeYear = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.harmfactorTest_threeYearCheck, cid, 3);
        if (!isIgnoreThreeYear.booleanValue()) {
            Integer checkTypeOfPresentCount = this.hcCheckPlanMapper.getHcCheckPlanCheckTypeOfPresentCount(cid, Calendar.getInstance().get(1));
            Integer threeYearToCheckCount = this.hcCheckPlanMapper.getCheckPlanLessThreeYearToCHeckCount(cid, Calendar.getInstance().get(1));
            if (threeYearToCheckCount != null && threeYearToCheckCount >= 3 && checkTypeOfPresentCount > 0) {
                vo.setIsHasThreeYearsToCheck(Boolean.valueOf(true));
            } else {
                vo.setIsHasThreeYearsToCheck(Boolean.valueOf(false));
            }
        } else {
            vo.setIsHasThreeYearsToCheck(Boolean.valueOf(false));
        }
        List sysList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.accidentManement, CoreWorkEnum.harmfactorTest, cid);
        vo.setAccidentCount(Integer.valueOf(sysList.size()));
        vo.setThirdTimeList(this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.harmfactorTest, cid));
        List evalSList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.evaluate, CoreWorkEnum.harmfactorTest, cid);
        ArrayList<SysCoreWorkModuleCorrelation> nowStatusList = new ArrayList<SysCoreWorkModuleCorrelation>();
        ArrayList<SysCoreWorkModuleCorrelation> controlEvaluationList = new ArrayList<SysCoreWorkModuleCorrelation>();
        for (SysCoreWorkModuleCorrelation remind : evalSList) {
            if (remind.getStageSource() == null) continue;
            if (remind.getStageSource() == 1) {
                nowStatusList.add(remind);
            }
            if (remind.getStageSource() != 3) continue;
            controlEvaluationList.add(remind);
        }
        vo.setNowStatusList(nowStatusList);
        vo.setControlEvaluationList(controlEvaluationList);
        vo.setAppearHcCheckList(this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.harmfactorTest, CoreWorkEnum.harmfactorTest, cid));
        List healthCheckCorrelationList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.harmfactorTest, CoreWorkEnum.harmfactor, cid);
        vo.setHealthCheckCorrelationList(healthCheckCorrelationList);
        vo.setUnderwayUnionHcTotal(Integer.valueOf(this.harmfactorWorkService.harmfactorHccheckplanunderwayCount(cid)));
        return vo;
    }

    public HcCheckPlanCountVo getHcCheckPlanCompletedCountByYearAndType(Integer year, Long cid, Long checkType) {
        HcCheckPlanCountVo vo = new HcCheckPlanCountVo();
        Integer checkTimes = ((HcCheckPlanMapper)this.dao).getHcCheckPlanCompletedCountByYearAndType(year, cid, checkType);
        if (checkTimes == null || checkTimes == 0) {
            return vo;
        }
        vo.setCheckTimes(checkTimes);
        List<HcCheckPlanCountInfoVo> infos = ((HcCheckPlanMapper)this.dao).getHcCheckPlanCompletedCountInfoByYearAndType(year, cid, checkType);
        if (infos == null || infos.isEmpty()) {
            return vo;
        }
        int resultCount = infos.size();
        int failedCount = 0;
        for (HcCheckPlanCountInfoVo i : infos) {
            if (!"1".equals(i.getDataValue())) continue;
            ++failedCount;
        }
        String rate = NumberUtil.rateProcessing1((int)failedCount, (int)resultCount);
        vo.setOverRate(rate);
        return vo;
    }

    public PageInfo<HcCheckPlanCountDailyPageVo> getHcCheckPlanCountDailyPage(JqGridParam jgGridParam, HcCheckPlanCountDailyPageParamVo paramVo) {
        PageHelper.startPage((int)jgGridParam.getPage(), (int)jgGridParam.getRows());
        List<HcCheckPlanCountDailyPageVo> list = this.hcCheckPlanMapper.getHcCheckPlanCountDailyList(paramVo);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        List<HcCheckPlanCountInfoVo> infos = ((HcCheckPlanMapper)this.dao).getHcCheckPlanCompletedCountInfoByYearAndType(paramVo.getYear(), paramVo.getCid(), 1L);
        if (infos == null || infos.isEmpty()) {
            return new PageInfo(list);
        }
        for (HcCheckPlanCountDailyPageVo h : list) {
            this.setMonthCount(h, infos);
        }
        return new PageInfo(list);
    }

    private void setMonthCount(HcCheckPlanCountDailyPageVo h, List<HcCheckPlanCountInfoVo> infos) {
        Integer month;
        if (h == null) {
            return;
        }
        Long orgId = h.getCheckOrgId();
        HashMap<Integer, Map<Long, HcCheckPlanCountMonthVo>> monthVoMap = new HashMap<Integer, Map<Long, HcCheckPlanCountMonthVo>>();
        for (HcCheckPlanCountInfoVo hcCheckPlanCountInfoVo : infos) {
            if (!orgId.equals(hcCheckPlanCountInfoVo.getCheckOrgId())) continue;
            month = hcCheckPlanCountInfoVo.getCheckMonth();
            Long hcId = hcCheckPlanCountInfoVo.getHcId();
            if (month == null) continue;
            Map hcVoMap = monthVoMap.get(month) == null ? new HashMap() : (Map)monthVoMap.get(month);
            HcCheckPlanCountMonthVo vo = (HcCheckPlanCountMonthVo)hcVoMap.get(hcId);
            if (vo == null) {
                vo = new HcCheckPlanCountMonthVo();
                vo.setHcId(hcId);
            }
            vo.setTotal(vo.getTotal() + 1);
            if ("1".equals(hcCheckPlanCountInfoVo.getDataValue())) {
                vo.setFailed(vo.getFailed() + 1);
            }
            hcVoMap.put(hcId, vo);
            monthVoMap.put(month, hcVoMap);
        }
        for (Map.Entry entry : monthVoMap.entrySet()) {
            month = (Integer)entry.getKey();
            Map hcVoMap = (Map)entry.getValue();
            for (Map.Entry hcMap : hcVoMap.entrySet()) {
                HcCheckPlanCountMonthVo vo = (HcCheckPlanCountMonthVo)hcMap.getValue();
                Double rate = NumberUtil.rateDouble((int)(vo.getFailed() * 100), (int)vo.getTotal(), (int)1);
                vo.setRate(rate.doubleValue());
                if (month == 1) {
                    h.getMonth1().add(vo);
                    continue;
                }
                if (month == 2) {
                    h.getMonth2().add(vo);
                    continue;
                }
                if (month == 3) {
                    h.getMonth3().add(vo);
                    continue;
                }
                if (month == 4) {
                    h.getMonth4().add(vo);
                    continue;
                }
                if (month == 5) {
                    h.getMonth5().add(vo);
                    continue;
                }
                if (month == 6) {
                    h.getMonth6().add(vo);
                    continue;
                }
                if (month == 7) {
                    h.getMonth7().add(vo);
                    continue;
                }
                if (month == 8) {
                    h.getMonth8().add(vo);
                    continue;
                }
                if (month == 9) {
                    h.getMonth9().add(vo);
                    continue;
                }
                if (month == 10) {
                    h.getMonth10().add(vo);
                    continue;
                }
                if (month == 11) {
                    h.getMonth11().add(vo);
                    continue;
                }
                if (month != 12) continue;
                h.getMonth12().add(vo);
            }
        }
    }

    public PageInfo<HcCheckPlan> getHcCheckNeedRelationDataPage(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getHcCheckNeedRelationDataBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
        }
        return new PageInfo(list);
    }

    public PageInfo<HcCheckPlan> getThirdHcCheckNeedRelationDataPage(JqGridParam jparam, HcCheckPlan hc) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getThirdHcCheckNeedRelationDataBySearchParam(hc);
        for (HcCheckPlan h : list) {
            HcCheckType type;
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() == null) continue;
            h.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(h.getManager()));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public HarmfactorHccheckplanunderway createHarmfactorHccheckplanunderway(Long hcId, Long loginStaffId) {
        if (hcId == null) {
            return null;
        }
        HcCheckPlan hc = (HcCheckPlan)this.getById(hcId);
        if (hc != null) {
            HcCheckType type;
            HarmfactorHccheckplanunderway underway = new HarmfactorHccheckplanunderway();
            underway.setHazardEndDate(hc.getCheckTimeEnd());
            underway.setHazardStartDate(hc.getCheckTimeBegin());
            underway.setHccplanId(hc.getId());
            underway.setHccplanName(hc.getCheckWorkName());
            underway.setCid(hc.getCid());
            underway.setCreateBy(loginStaffId);
            underway.setUpdateBy(loginStaffId);
            underway.setCreateDate(new Date());
            underway.setUpdateDate(new Date());
            if (hc.getCheckPlanType() != null && hc.getCheckPlanType().intValue() == 3) {
                underway.setHazardType("\u6574\u6539\u540e\u68c0\u6d4b");
            } else if (hc.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(hc.getCheckType())) != null) {
                underway.setHazardType(type.getCheckTypeName());
            }
            this.harmfactorWorkService.insertHarmfactorWorkHccheckplan(underway);
            this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactor, CoreWorkEnum.harmfactorTest, underway.getId(), loginStaffId, underway.getId(), new Long[]{underway.getHccplanId()});
            return underway;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void deleteHarmHccheckplanRelationById(Long hccheckUnderwayId, Long staffId) {
        this.harmfactorWorkService.deleteHarmHccheckplanRelationById(hccheckUnderwayId, staffId);
    }

    @Transactional(readOnly=false)
    public void editHarmHccheckplanRelationSubmit(Long hccheckUnderwayId, Long hcplanId, String workrowDataJson, String areaRowDataJson, boolean isAdminModel, boolean isFinish, Long staffId, Long cid) throws Exception {
        workrowDataJson = StringEscapeUtils.unescapeHtml((String)workrowDataJson);
        List wharmSourceHccplanList = JSONArray.parseArray((String)workrowDataJson, HarmfactorWorkSource.class);
        this.harmfactorWorkService.saveHarmLinkHccheckplan(wharmSourceHccplanList, isFinish, hcplanId, Boolean.valueOf(isAdminModel), cid, staffId);
        areaRowDataJson = StringEscapeUtils.unescapeHtml((String)areaRowDataJson);
        List aharmSourceHccplanList = JSONArray.parseArray((String)areaRowDataJson, HarmfactorWorkAreaSourceVo.class);
        this.harmfactorAreaService.saveAreaHarmRelation(aharmSourceHccplanList, isFinish, hcplanId, Boolean.valueOf(isAdminModel), cid, staffId);
    }

    public List<HarmfactorWorkSource> getHarmfactorWorkHisByWorkIdAndHarmName(Long workRoleId, String occName) {
        return this.hcCheckPlanMapper.getHarmfactorWorkHisByWorkIdAndHarmName(workRoleId, occName);
    }

    public List<HcCheckPlan> exportgetThirdHcCheckPlanResultInform(HcCheckPlan hc) {
        DataScopeHelper.startDataScope("hccheckplan", "hc_check_plan");
        List<HcCheckPlan> list = this.hcCheckPlanMapper.getThirdHcCheckPlanListBySearchParam(hc);
        for (int i = 0; i < list.size(); ++i) {
            HcCheckType type;
            HcCheckPlan h = list.get(i);
            h.setId(Long.valueOf((long)i + 1L));
            if (h.getCheckPlanType() != null && h.getCheckPlanType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            if (h.getCheckType() != null && (type = (HcCheckType)this.hcCheckTypeService.getById(h.getCheckType())) != null) {
                h.setCheckTypeName(type.getCheckTypeName());
            }
            String checkTime = "";
            if (h.getCheckTimeBegin() != null && h.getCheckTimeEnd() != null) {
                checkTime = DateUtils.formatDate((Date)h.getCheckTimeBegin());
                h.setCheckTime(checkTime + "\u81f3");
                h.setCheckTime(h.getCheckTime() + DateUtils.formatDate((Date)h.getCheckTimeEnd()));
            }
            if (h.getManager() != null) {
                h.setManagerName(this.staffInfoService.getStaffNameByStaffId(h.getManager()));
            }
            if (h.getUpdateDate() != null) {
                h.setCheckOrgName(DateUtils.format((Date)h.getUpdateDate(), (String)"yyyy-MM-dd"));
            }
            if (!StringUtils.isNotEmpty((String)h.getCheckResultCertificateFileIds())) continue;
            String[] fileStrs = h.getCheckResultCertificateFileIds().split(",");
            Object name = "";
            for (String id : fileStrs) {
                SysFileModel sysFile;
                if (!StringUtils.isNotEmpty((String)id) || id.contains("null") || (sysFile = this.sysFileService.getFileById(Long.valueOf(id))) == null) continue;
                name = (String)name + sysFile.getFileName() + ",";
            }
            if (!StringUtils.isNotEmpty((String)name)) continue;
            h.setCheckResultCertificateFileNames(((String)name).substring(0, ((String)name).lastIndexOf(",")));
        }
        return list;
    }
}

