/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.harmfactor;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorAreaSourceMapper;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorWorkHccheckplanMapper;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorWorkMapper;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorWorkSourceMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkAreaInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorHccheckplanunderway;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkDiseaseVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkRecommendVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceVo;
import cn.smarthse.modules.health.enums.check.RecommendCheckEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkSourceService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.service.work.impl.harmfactor.CustomCellWriteHandler;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.NoModleDataListener;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.WorkHarmDataListener;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.WorkHarmDataLiteListener;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.WorkHarmNameData;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.WorkHarmNameLiteData;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.WorkHarmNameSourceData;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.DeclareHarmWorkNewVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmRiskDataVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmSourceJsonVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmfactorItemVO;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.pojo.vo.HarmFactorCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.SelectPointVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.validation.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HarmfactorWorkServiceImpl
extends BaseServiceImpl<HarmfactorWorkMapper, HarmfactorWork>
implements IHarmfactorWorkService {
    @Autowired
    HarmfactorWorkMapper harmfactorWorkMapper;
    @Autowired
    HarmfactorWorkSourceMapper harmfactorWorkSourceMapper;
    @Autowired
    HarmfactorAreaSourceMapper harmfactorAreaSourceMapper;
    @Autowired
    HarmfactorWorkHccheckplanMapper harmfactorWorkHccheckplanMapper;
    @Autowired
    IOccupationalRiskFactorsService occRiskFactorsService;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @DubboReference
    private ICheckResultService checkResultService;
    @Autowired
    IHarmfactorWorkSourceService harmfactorWorkSourceService;
    @Autowired
    IHarmfactorAreaSourceService harmfactorAreaSourceService;
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    private static final String HARMSOURCE_SPLIT = ",";
    private static final String HARMNAME_SPLIT = ",";
    private static final String ONEHARMSOURCE_SPLIT = "!#!";
    private static final String MOREHARMSOURCE_SPLIT = "~@~";
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private ICompanyAreaService companyAreaService;
    @Autowired
    private Validator validator;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;

    @Transactional
    public HarmfactorWork saveOrUpdateHarmfactorWork(HarmfactorWork harmfactorWork, Long loginStaffId, Long cid) throws Exception {
        if (harmfactorWork == null) {
            throw new Exception("harmfactorWork \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (harmfactorWork.getWorkId() == null) {
            throw new Exception("workId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HarmfactorWork oldEntity = null;
        Example harmfactorExample = new Example(HarmfactorWork.class);
        Example.Criteria c = harmfactorExample.createCriteria().andEqualTo("workId", (Object)harmfactorWork.getWorkId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        harmfactorWork.setCid(cid);
        harmfactorWork.setUpdateBy(loginStaffId);
        harmfactorWork.setUpdateDate(new Date());
        if (harmfactorWork.getId() != null) {
            Integer count = this.countSourceNumByWork(cid, harmfactorWork.getWorkId(), harmfactorWork.getId());
            if (count > 0) {
                throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u8be5\u5c97\u4f4d/\u5de5\u79cd\uff0c\u4e0d\u53ef\u53d8\u66f4");
            }
            this.update(harmfactorWork, loginStaffId);
            oldEntity = (HarmfactorWork)this.getById(harmfactorWork.getId());
        } else {
            List harmfactorWorkList = this.getListByExample(harmfactorExample);
            if (harmfactorWorkList != null && harmfactorWorkList.size() > 0) {
                return (HarmfactorWork)harmfactorWorkList.get(0);
            }
            harmfactorWork.setCreateBy(loginStaffId);
            harmfactorWork.setCreateDate(new Date());
            this.add(harmfactorWork, loginStaffId, cid);
        }
        return harmfactorWork;
    }

    @Transactional
    public void delHarmfactorWork(HarmfactorWork harmfactorWork, Long loginStaffId) throws Exception {
        if (harmfactorWork == null) {
            throw new Exception("harmfactorWork \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (harmfactorWork.getId() == null) {
            throw new Exception("Id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.delete(harmfactorWork, loginStaffId);
        harmfactorWork = (HarmfactorWork)this.getById(harmfactorWork.getId());
    }

    @Transactional
    public void delHarmfactorWorkSourceInfo(HarmfactorWorkSource harmfactorWorkSource, Long cid, Long loginStaffId) throws Exception {
        if (harmfactorWorkSource == null) {
            throw new Exception("harmfactorWorkSource \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (harmfactorWorkSource.getWorkHarmfactorId() == null) {
            throw new Exception("WorkHarmfactorId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (harmfactorWorkSource.getHarmId() == null) {
            throw new Exception("HarmId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example e = new Example(HarmfactorWorkSource.class);
        e.createCriteria().andEqualTo("workHarmfactorId", (Object)harmfactorWorkSource.getWorkHarmfactorId()).andEqualTo("harmId", (Object)harmfactorWorkSource.getHarmId()).andEqualTo("isValid", (Object)true);
        HarmfactorWorkSource result = new HarmfactorWorkSource();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateBy(loginStaffId);
        result.setUpdateDate(new Date());
        this.harmfactorWorkSourceMapper.updateByExampleSelective(result, e);
    }

    public PageInfo<HarmfactorWorkSourceVo> pageHarmfactorWork(JqGridParam gparam, Boolean filterCurrYear) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        String searchKw = "";
        List postDatas = gparam.getPostDatas();
        if (postDatas != null && postDatas.size() > 0) {
            for (ParamSeachFieldVO sf : postDatas) {
                if (!"searchKw".equals(sf.getSearchField())) continue;
                searchKw = sf.getSearchValue();
                break;
            }
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("company.harmfactor", "harmfactor_work");
        DataScope dataScope = DataScopeHelper.getDataScope();
        List<HarmfactorWorkSourceVo> harmfactorAreaList = null;
        harmfactorAreaList = this.isActualize() ? this.harmfactorWorkMapper.getActualizeHarmfactorWorkList(gparam.getCid(), filterCurrYear, searchKw) : this.harmfactorWorkMapper.getHarmfactorWorkList(gparam.getCid(), searchKw);
        if (harmfactorAreaList != null && !harmfactorAreaList.isEmpty()) {
            HashSet allIdList = new HashSet();
            for (HarmfactorWorkSourceVo harmfactorWorkSourceVo : harmfactorAreaList) {
                List idList = StringUtils.parseToLongList((String)harmfactorWorkSourceVo.getCheckPlanIds());
                if (!CollectionUtils.isNotEmpty((Collection)idList)) continue;
                allIdList.addAll(idList);
            }
            List checkPlanList = this.checkPlanService.getByIds(allIdList);
            HashMap<Long, CheckPlan> checkPlanMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)checkPlanList)) {
                checkPlanMap = checkPlanList.stream().collect(Collectors.toMap(BaseEntity::getId, m -> m, (oldValue, newValue) -> newValue));
            }
            for (HarmfactorWorkSourceVo hwsv : harmfactorAreaList) {
                DataScopeHelper.setDataScope(dataScope);
                List<HarmfactorWorkSourceVo> hasHisList = this.harmfactorWorkMapper.getHisDataByWork(gparam.getCid(), hwsv.getWorkId());
                if (hasHisList != null && !hasHisList.isEmpty()) {
                    hwsv.setHasHisRec(true);
                }
                this.spliceLink(hwsv, checkPlanMap);
            }
        }
        PageInfo page = new PageInfo(harmfactorAreaList);
        return page;
    }

    private void spliceLink(HarmfactorWorkSourceVo hwsv, Map<Long, CheckPlan> checkPlanMap) {
        String hazardSource = hwsv.getHazardSource();
        if (StringUtils.isNotEmpty((String)hazardSource)) {
            StringBuffer link = new StringBuffer("");
            StringBuffer no = new StringBuffer("");
            StringBuffer harmsource = new StringBuffer("");
            HashSet<Long> checkIdSet = new HashSet<Long>();
            Object[] checkPlanIdSourceArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)hazardSource, (String)"~#~");
            if (ArrayUtils.isNotEmpty((Object[])checkPlanIdSourceArr)) {
                for (Object checkPlanIdSource : checkPlanIdSourceArr) {
                    Object[] idSourceArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)checkPlanIdSource, (String)MOREHARMSOURCE_SPLIT);
                    if (!ArrayUtils.isNotEmpty((Object[])idSourceArr)) continue;
                    String checkPlanIdStr = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)0, (String)"");
                    String source = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)1, (String)"");
                    if (StringUtils.isNotBlank((CharSequence)checkPlanIdStr) && StringUtils.isNumber((String)checkPlanIdStr)) {
                        Long checkPlanId = Long.parseLong(checkPlanIdStr);
                        if (checkIdSet.contains(checkPlanId)) continue;
                        checkIdSet.add(checkPlanId);
                        if (!checkPlanMap.containsKey(checkPlanId)) continue;
                        if (StringUtils.isNotBlank((CharSequence)link.toString())) {
                            link.append(",");
                        }
                        if (StringUtils.isNotBlank((CharSequence)no.toString())) {
                            no.append(",");
                        }
                        if (StringUtils.isNotBlank((CharSequence)harmsource.toString())) {
                            harmsource.append(",");
                        }
                        CheckPlan plan = checkPlanMap.get(checkPlanId);
                        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(plan.getCheckDateBegin());
                        String workName = plan.getCheckWorkName() + "(" + date + ")";
                        link.append("<a href=\"javascript:viewHccSource('" + workName + "','" + hwsv.getWorkHarmfactorId() + "','" + checkPlanId + "','" + hwsv.getHarmId() + "');\" ' class='ui-pg-div' data-rel='tooltip' data-original-title='\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f'>" + workName + "</a>");
                        no.append(plan.getCheckWorkNo());
                        harmsource.append(workName);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)link.toString())) {
                        link.append(",");
                    }
                    if (StringUtils.isNotBlank((CharSequence)harmsource.toString())) {
                        harmsource.append(",");
                    }
                    link.append(source);
                    harmsource.append(source);
                }
            }
            hwsv.setCheckWorkName(link.toString());
            hwsv.setCheckWorkNo(no.toString());
            hwsv.setCheckWorkName2(harmsource.toString());
        }
    }

    public PageInfo<HarmfactorWorkSourceInfoVo> pageHarmfactorWorkSourceInfoList(JqGridParam gparam, Long workHarmfactorId, Long harmId) {
        List<HarmfactorWorkSourceInfoVo> hwsInfoList = this.harmfactorWorkMapper.getHarmfactorWorkSourceInfoList(gparam.getCid(), workHarmfactorId, harmId);
        if (hwsInfoList != null && !hwsInfoList.isEmpty()) {
            for (HarmfactorWorkSourceInfoVo hws : hwsInfoList) {
                String[] checkPlanIdArr;
                hws.setId(RandomGenerator.getRandomNum((int)9));
                String checkPlanIds = hws.getCheckPlanIds();
                if (!StringUtils.isNotBlank((CharSequence)checkPlanIds) || (checkPlanIdArr = StringUtils.splitByWholeSeparator((String)checkPlanIds, (String)",")) == null || checkPlanIdArr.length <= 0) continue;
                StringBuffer sb = new StringBuffer("");
                for (String checkPlanId : checkPlanIdArr) {
                    CheckPlan hcCheckPlan;
                    if (!StringUtils.isNumeric((CharSequence)checkPlanId) || (hcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)Long.valueOf(Long.parseLong(checkPlanId)))) == null) continue;
                    String dateStr = DateUtils.formatDate((Date)DateUtil.getDate((LocalDateTime)hcCheckPlan.getCheckDateBegin()));
                    String checkWorkName = hcCheckPlan.getCheckWorkName() + "(" + dateStr + ")";
                    sb.append("<a id=\"" + hws.getHarmId() + "\" href=\"javascript:viewHccSource('").append(checkWorkName).append("','").append(workHarmfactorId).append("','").append(checkPlanId).append("','").append(hws.getHarmId()).append("');\"  class=\"ui-pg-div\" data-rel=\"tooltip\" data-original-title=\"\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\">" + checkWorkName + "</a>");
                }
                hws.setHccplanLinkStr(sb.toString());
                String hazardSource3 = hws.getHazardSource3();
                hazardSource3 = hazardSource3.replaceAll(",{2,}", ",");
                hazardSource3 = hazardSource3.replaceAll("^,", "");
                hazardSource3 = hazardSource3.replaceAll(",$", "");
                Object tempStr = "";
                if (StringUtils.isNotBlank((CharSequence)sb.toString()) && StringUtils.isNotBlank((CharSequence)hazardSource3)) {
                    tempStr = sb.toString() + "," + hazardSource3;
                } else if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    tempStr = sb.toString();
                } else if (StringUtils.isNotBlank((CharSequence)hazardSource3)) {
                    tempStr = hazardSource3;
                }
                hws.setHazardSource3((String)tempStr);
            }
        }
        PageInfo page = new PageInfo(hwsInfoList);
        return page;
    }

    public PageInfo<HarmfactorWorkSourceInfoVo> pageActualizeHarmfactorWorkSourceInfoList(JqGridParam gparam, Long workHarmfactorId, Long harmId) {
        List<HarmfactorWorkSourceInfoVo> hwsInfoList = this.harmfactorWorkMapper.getActualizeHarmfactorWorkSourceInfoList(gparam.getCid(), workHarmfactorId, harmId);
        if (hwsInfoList != null && !hwsInfoList.isEmpty()) {
            HashSet allIdList = new HashSet();
            for (HarmfactorWorkSourceInfoVo harmfactorWorkSourceInfoVo : hwsInfoList) {
                String checkPlanIds = harmfactorWorkSourceInfoVo.getCheckPlanIds();
                List idList = StringUtils.parseToLongList((String)checkPlanIds);
                if (!CollectionUtils.isNotEmpty((Collection)idList)) continue;
                allIdList.addAll(idList);
            }
            List checkPlans = this.checkPlanService.getByIds(allIdList);
            HashMap<Long, CheckPlan> checkPlansMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)checkPlans)) {
                checkPlansMap = checkPlans.stream().collect(Collectors.toMap(BaseEntity::getId, v -> v, (v1, v2) -> v1));
            }
            for (HarmfactorWorkSourceInfoVo hws : hwsInfoList) {
                hws.setId(RandomGenerator.getRandomNum((int)9));
                this.spliceWorkHarmEditLink(hws, checkPlansMap);
            }
        }
        PageInfo page = new PageInfo(hwsInfoList);
        return page;
    }

    private void spliceWorkHarmEditLink(HarmfactorWorkSourceInfoVo hwsv, Map<Long, CheckPlan> checkPlanMap) {
        String hazardSource = hwsv.getHazardSource();
        if (StringUtils.isNotEmpty((String)hazardSource)) {
            StringBuffer link = new StringBuffer("");
            StringBuffer no = new StringBuffer("");
            Long harmId = hwsv.getHarmId();
            String harmName = hwsv.getHarmName();
            HashSet<CallSite> metaData = new HashSet<CallSite>();
            Object[] checkPlanIdSourceArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)hazardSource, (String)"~#~");
            if (ArrayUtils.isNotEmpty((Object[])checkPlanIdSourceArr)) {
                for (Object checkPlanIdSource : checkPlanIdSourceArr) {
                    Object[] idSourceArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)checkPlanIdSource, (String)MOREHARMSOURCE_SPLIT);
                    if (!ArrayUtils.isNotEmpty((Object[])idSourceArr)) continue;
                    String checkPlanIdStr = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)0);
                    String source = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)1);
                    String checkDate = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)2);
                    String sourceType = StringUtils.getArrValueByIndex((String[])idSourceArr, (int)3);
                    if (StringUtils.isNotBlank((CharSequence)checkPlanIdStr) && StringUtils.isNumber((String)checkPlanIdStr)) {
                        Long checkPlanId = Long.parseLong(checkPlanIdStr);
                        if (!checkPlanMap.containsKey(checkPlanId)) continue;
                        CheckPlan plan = checkPlanMap.get(checkPlanId);
                        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(plan.getCheckDateBegin());
                        String workName = plan.getCheckWorkName() + "(" + date + ")";
                        metaData.add((CallSite)((Object)((String)checkPlanIdSource + MOREHARMSOURCE_SPLIT + workName)));
                        continue;
                    }
                    metaData.add((CallSite)((Object)((String)checkPlanIdSource + MOREHARMSOURCE_SPLIT)));
                }
            }
            hwsv.setHazardSource(StringUtils.join(metaData, (String)"~#~"));
        }
    }

    public List<HarmRiskDataVo> listHarmRiskData(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        DataScopeHelper.startDataScope("company.harmfactor", "harmfactor_work");
        List<HarmRiskDataVo> harmRiskDataVoList = this.harmfactorWorkMapper.listHarmRiskData(cid);
        if (CollectionUtils.isNotEmpty(harmRiskDataVoList)) {
            HashMap<Long, String> areaMap = new HashMap<Long, String>();
            for (HarmRiskDataVo harmRiskDataVo : harmRiskDataVoList) {
                this.handleAreaName(areaMap, harmRiskDataVo);
                Integer workerNumByWorkId = this.staffWorkRoleService.getWorkerNumByWorkId(harmRiskDataVo.getWorkId(), cid);
                harmRiskDataVo.setRiskMaybeInfo((String)(workerNumByWorkId == null ? "0" : "" + workerNumByWorkId));
                this.handleHarmDesc(cid, harmRiskDataVo);
            }
        }
        return harmRiskDataVoList;
    }

    private void handleAreaName(Map<Long, String> areaMap, HarmRiskDataVo harmRiskDataVo) {
        if (areaMap.containsKey(harmRiskDataVo.getWorkId())) {
            harmRiskDataVo.setAreaName(areaMap.get(harmRiskDataVo.getWorkId()));
        } else {
            List workAreaInfoList = this.workRoleInfoService.getWorkAreaInfosByWorkId(harmRiskDataVo.getWorkId());
            if (CollectionUtils.isNotEmpty((Collection)workAreaInfoList)) {
                StringBuffer sbArea = new StringBuffer();
                for (WorkAreaInfo workAreaInfo : workAreaInfoList) {
                    String areaFullName = this.companyAreaService.getAreaFullName(workAreaInfo.getCompanyAreaId());
                    sbArea.append(areaFullName).append("\n\r");
                }
                areaMap.put(harmRiskDataVo.getWorkId(), sbArea.toString());
                harmRiskDataVo.setAreaName(sbArea.toString());
            }
        }
    }

    private void handleHarmDesc(Long cid, HarmRiskDataVo harmRiskDataVo) {
        CheckResult checkResult;
        Object desc = "";
        desc = harmRiskDataVo.getContactType() != null && harmRiskDataVo.getContactType() == 1 ? "\u5b9a\u70b9\u63a5\u89e6" : "\u5de1\u68c0\u63a5\u89e6";
        if (harmRiskDataVo.getHarmId().equals(568L) && (checkResult = this.checkResultService.getLatest(harmRiskDataVo.getCheckPlanId(), Long.valueOf(34L))) != null) {
            String checkValue = checkResult.getCheckValue();
            desc = (String)desc + "," + checkValue;
        }
        if (harmRiskDataVo.getCheckPlanId() != null) {
            ArrayList<Long> checkPlanIdList = new ArrayList<Long>();
            checkPlanIdList.add(harmRiskDataVo.getCheckPlanId());
            List factorCheckResultVoList = this.checkResultService.queryHarmFactorLatestCheckResult(cid, harmRiskDataVo.getHarmId(), checkPlanIdList);
            if (CollectionUtils.isNotEmpty((Collection)factorCheckResultVoList)) {
                StringBuffer sb = new StringBuffer();
                for (HarmFactorCheckResultVo harmFactorCheckResultVo : factorCheckResultVoList) {
                    sb.append(harmFactorCheckResultVo.getCheckValue());
                }
                desc = (String)desc + "," + sb.toString();
            }
        }
        harmRiskDataVo.setHarmDesc((String)desc);
        if (StringUtils.isNotEmpty((String)harmRiskDataVo.getHarmCategory())) {
            Object harmCategory = harmRiskDataVo.getHarmCategory();
            harmCategory = ((String)harmCategory).replace("\u56e0\u7d20", "") + "\u5371\u5bb3";
            harmRiskDataVo.setHarmCategory((String)harmCategory);
        }
    }

    private void settingDefault(HarmRiskDataVo harmRiskDataVo) {
        if (harmRiskDataVo == null) {
            return;
        }
        harmRiskDataVo.setAftermath("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setReveal("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setPossibility("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setRiskValue("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setRiskValue("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setRiskLevel("\u65e0\u5185\u5bb9");
        harmRiskDataVo.setProposedControlMeasures("\u65e0\u5185\u5bb9");
    }

    @Transactional
    public void updateHarmfactorWorkSourceInfo(HarmfactorWorkSource wsource, String[] delSource, Long oldHarmId) throws Exception {
        String[] hSources;
        if (wsource == null) {
            return;
        }
        String hSource = wsource.getHazardSource();
        if (delSource != null && delSource.length > 0) {
            for (String dsource : delSource) {
                HarmfactorWorkSource eparam = new HarmfactorWorkSource();
                eparam.setCid(wsource.getCid());
                eparam.setWorkHarmfactorId(wsource.getWorkHarmfactorId());
                eparam.setHarmId(wsource.getHarmId());
                eparam.setHazardSource(dsource);
                eparam.setIsValid(Boolean.valueOf(true));
                Example e = new Example(HarmfactorWorkSource.class);
                e.createCriteria().andEqualTo((Object)eparam);
                HarmfactorWorkSource eresult = new HarmfactorWorkSource();
                eresult.setIsValid(Boolean.valueOf(false));
                eresult.setUpdateDate(new Date());
                this.harmfactorWorkSourceMapper.updateByExampleSelective(eresult, e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)hSource) && (hSources = StringUtils.split((String)hSource, (String)",")) != null && hSources.length > 0) {
            for (String source : hSources) {
                HarmfactorWorkSource qparam = new HarmfactorWorkSource();
                if (oldHarmId != null) {
                    qparam.setHarmId(oldHarmId);
                } else {
                    qparam.setHarmId(wsource.getHarmId());
                }
                qparam.setIsValid(Boolean.valueOf(true));
                qparam.setWorkHarmfactorId(wsource.getWorkHarmfactorId());
                qparam.setHazardSource(source);
                Example e = new Example(HarmfactorWorkSource.class);
                e.createCriteria().andEqualTo((Object)qparam);
                HarmfactorWorkSource eresult = new HarmfactorWorkSource();
                BeanUtils.copyProperties((Object)eresult, (Object)wsource);
                eresult.setHazardSource(source);
                eresult.setUpdateDate(new Date());
                int count = this.harmfactorWorkSourceMapper.updateByExampleSelective(eresult, e);
                if (count != 0) continue;
                eresult.setIsValid(Boolean.valueOf(true));
                eresult.setCreateBy(wsource.getUpdateBy());
                eresult.setCreateDate(new Date());
                eresult.setId(Long.valueOf(this.idworker.nextId()));
                this.harmfactorWorkSourceMapper.insert(eresult);
            }
        }
    }

    @Transactional
    public void updateHarmfactorWorkSourceInfo(List<HarmfactorWorkSource> hwsList) {
        if (hwsList != null && hwsList.size() > 0) {
            for (HarmfactorWorkSource hws : hwsList) {
                String[] hnameIds;
                String hnameId;
                if (hws == null || !StringUtils.isNotBlank((CharSequence)(hnameId = hws.getHarmNameId())) || (hnameIds = StringUtils.split((String)hnameId, (String)",")) == null || hnameIds.length <= 0) continue;
                for (String harm : hnameIds) {
                    String[] hnameIdsv;
                    HarmfactorWorkSource eparam = new HarmfactorWorkSource();
                    if (StringUtils.isNotBlank((CharSequence)harm) && (hnameIdsv = StringUtils.split((String)harm, (String)":")).length > 1) {
                        eparam.setHarmId(Long.valueOf(Long.parseLong(hnameIdsv[1])));
                    }
                    eparam.setCid(hws.getCid());
                    eparam.setWorkHarmfactorId(hws.getWorkHarmfactorId());
                    eparam.setCheckPlanId(hws.getCheckPlanId());
                    eparam.setHazardSource(hws.getHazardSource());
                    eparam.setIsValid(Boolean.valueOf(true));
                    Example e = new Example(HarmfactorWorkSource.class);
                    e.createCriteria().andEqualTo((Object)eparam);
                    int count = this.harmfactorWorkSourceMapper.selectCountByExample(e);
                    if (count != 0) continue;
                    eparam.setCreateBy(hws.getUpdateBy());
                    eparam.setUpdateBy(hws.getUpdateBy());
                    eparam.setCreateDate(new Date());
                    eparam.setUpdateDate(new Date());
                    eparam.setId(Long.valueOf(this.idworker.nextId()));
                    this.harmfactorWorkSourceMapper.insert(eparam);
                }
            }
        }
    }

    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWork(Long cid, Long workId) {
        if (cid == null) {
            throw new HealthException("cid \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (workId == null) {
            throw new HealthException("workId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isActualize()) {
            return this.harmfactorWorkMapper.getHarmfactorListByWork(cid, workId, null);
        }
        WorkRoleInfo workRoleInfo = (WorkRoleInfo)this.workRoleInfoService.getById(workId);
        Object factorIds = workRoleInfo.getHarmFanctorIds();
        if (factorIds == null || ((String)factorIds).isEmpty()) {
            return new LinkedList<HarmfactorWorkSourceInfoVo>();
        }
        if (((String)factorIds).endsWith(",")) {
            factorIds = (String)factorIds + "000";
        }
        return this.harmfactorWorkMapper.getHarmfactorList((String)factorIds);
    }

    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWorkAndTime(Long cid, Long workId, Date endTime) {
        if (cid == null) {
            throw new HealthException("cid \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (workId == null) {
            throw new HealthException("workId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.harmfactorWorkMapper.getHarmfactorListByWorkAndTime(cid, workId, endTime, null);
    }

    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWork(Long cid, Long workId, String type) {
        if (cid == null) {
            throw new HealthException("cid \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (workId == null) {
            throw new HealthException("workId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.harmfactorWorkMapper.getHarmfactorListByWork(cid, workId, type);
    }

    public String getHarmNamesByWork(Long cid, Long workId, String splitor) {
        if (cid == null || workId == null) {
            return "";
        }
        String harmNames = "";
        List<HarmfactorWorkSourceInfoVo> harms = this.harmfactorWorkMapper.getHarmfactorListByWork(cid, workId, null);
        if (harms == null || harms.size() == 0) {
            return harmNames;
        }
        ArrayList<String> harmArray = new ArrayList<String>();
        for (HarmfactorWorkSourceInfoVo harm : harms) {
            String harmCh = harm.getHarmName();
            if (StringUtils.isEmpty((CharSequence)harmCh) || harmArray.contains(harmCh)) continue;
            harmNames = StringUtils.isEmpty((CharSequence)harmNames) ? harmCh : harmNames + splitor + harmCh;
            harmArray.add(harmCh);
        }
        return harmNames;
    }

    public Set<Long> getHarmIdsByWorkId(Long cid, Long workId) {
        if (workId == null) {
            return Collections.emptySet();
        }
        List<Long> hxFcHarmIdByWork = this.harmfactorWorkMapper.getHxFcHarmIdByWork(workId);
        return new HashSet<Long>(hxFcHarmIdByWork);
    }

    public Set<Long> getHarmIdByGBZ() {
        List<Long> harmIdByGBZ = this.harmfactorWorkMapper.getHarmIdByGBZ();
        return new HashSet<Long>(harmIdByGBZ);
    }

    public int checkHarmfactorWorkSourceInfo(HarmfactorWorkSource wsource) {
        Example e = new Example(HarmfactorWorkSource.class);
        e.createCriteria().andEqualTo("workHarmfactorId", (Object)wsource.getWorkHarmfactorId()).andEqualTo("harmId", (Object)wsource.getHarmId()).andEqualTo("hazardSource", (Object)wsource.getHazardSource()).andEqualTo("isValid", (Object)true);
        int count = this.harmfactorWorkSourceMapper.selectCountByExample(e);
        return count;
    }

    public Integer countHarmfactorByCid(Long cid) {
        return this.harmfactorWorkMapper.countHarmfactorByCid(cid);
    }

    public Integer countHarmNumByCid(Long cid) {
        return this.harmfactorWorkMapper.countHarmNumByCid(cid);
    }

    public Integer countHarmfactorByCidAndWork(Long cid, Long WorkId) {
        return this.harmfactorWorkMapper.countHarmfactorByCidAndWork(cid, WorkId);
    }

    public List<HarmfactorWorkDiseaseVo> getHarmfactorAndDieaseListByWork(Long cid, Long workId) {
        if (cid == null || workId == null) {
            return null;
        }
        return this.harmfactorWorkMapper.getHarmfactorAndDieaseListByWork(cid, workId);
    }

    @Deprecated
    public List<HarmfactorWork> getArchiveHarmfactor(Long cid) {
        return this.getArchiveHarmfactor(null, cid);
    }

    public List<HarmfactorWork> getArchiveHarmfactor(JqGridParam gparam, Long cid) {
        List<HarmfactorWork> harmfactorWorkList;
        if (cid == null) {
            return null;
        }
        if (gparam != null) {
            PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        }
        if ((harmfactorWorkList = this.harmfactorWorkMapper.getHarmfactorWorkList2(cid)) != null && harmfactorWorkList.size() > 0) {
            for (HarmfactorWork hw : harmfactorWorkList) {
                Example e2 = new Example(HarmfactorWorkSource.class);
                e2.createCriteria().andEqualTo("workHarmfactorId", (Object)hw.getId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
                List harmfactorWorkSourceList = this.harmfactorWorkSourceMapper.selectByExample(e2);
                if (harmfactorWorkSourceList != null && harmfactorWorkSourceList.size() > 0) {
                    for (HarmfactorWorkSource hws : harmfactorWorkSourceList) {
                        if (hws == null || hws.getHarmId() == null) continue;
                        hws.setHarm((OccupationalRiskFactors)this.occRiskFactorsService.getById(hws.getHarmId()));
                    }
                }
                hw.setHarmfactorWorkSourceList(harmfactorWorkSourceList);
                WorkRoleInfo w = (WorkRoleInfo)this.workRoleInfoService.getById(hw.getWorkId());
                hw.setWork(w);
            }
        }
        return harmfactorWorkList;
    }

    @Transactional(readOnly=false)
    public HarmfactorWork saveHarmfactorWork(HarmfactorWork harmfactorWork, boolean triggerChange, Long loginStaffId, Long cid) throws Exception {
        HarmfactorWork result = this.saveOrUpdateHarmfactorWork(harmfactorWork, loginStaffId, cid);
        if (triggerChange) {
            // empty if block
        }
        return result;
    }

    public String getSourceByWorkIdAndHarmId(Long cid, Long workId, Long harmId) {
        return this.harmfactorWorkMapper.getSourceByWorkIdAndHarmId(cid, workId, harmId);
    }

    public Integer getOccupationalStaffNumByCid(long cid) {
        Integer num = this.harmfactorWorkMapper.getOccupationalStaffNumByCid(cid);
        return num;
    }

    public List<HarmfactorWork> getHarmfactorWorkListByCid(long cid) {
        return this.harmfactorWorkMapper.getHarmfactorWorkList2(cid);
    }

    public PageInfo<HarmfactorWork> getHarmFactorWithWork(JqGridParam param) {
        if (param.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HarmfactorWork> harmfactorWorkList = this.harmfactorWorkMapper.getHarmfactorWorkList2(param.getCid());
        if (harmfactorWorkList != null && harmfactorWorkList.size() > 0) {
            for (HarmfactorWork hfw : harmfactorWorkList) {
                StringBuffer harmFactorNames = new StringBuffer("");
                StringBuffer source = new StringBuffer("");
                Example e2 = new Example(HarmfactorWorkSource.class);
                e2.createCriteria().andEqualTo("workHarmfactorId", (Object)hfw.getId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)param.getCid());
                List harmfactorWorkSourceList = this.harmfactorWorkSourceMapper.selectByExample(e2);
                if (harmfactorWorkSourceList != null && harmfactorWorkSourceList.size() > 0) {
                    for (HarmfactorWorkSource h : harmfactorWorkSourceList) {
                        if (h != null && h.getHarmId() != null) {
                            h.setHarm((OccupationalRiskFactors)this.occRiskFactorsService.getById(h.getHarmId()));
                        }
                        if (h.getHarm() != null && StringUtils.isNotEmpty((String)h.getHarm().getNameCh()) && harmFactorNames.indexOf(h.getHarm().getNameCh() + "\uff1b") < 0) {
                            harmFactorNames.append(h.getHarm().getNameCh());
                            harmFactorNames.append("\uff1b");
                        }
                        if (!StringUtils.isNotEmpty((String)h.getHazardSource()) || source.indexOf(h.getHazardSource() + "\uff1b") >= 0) continue;
                        source.append(h.getHazardSource());
                        source.append("\uff1b");
                    }
                }
                if (harmFactorNames.length() > 0) {
                    harmFactorNames.deleteCharAt(harmFactorNames.lastIndexOf("\uff1b"));
                }
                if (source.length() > 0) {
                    source.deleteCharAt(source.lastIndexOf("\uff1b"));
                }
                hfw.setHarmFactorNames(harmFactorNames.toString());
                hfw.setHarmFactorSource(source.toString());
                WorkRoleInfo w = (WorkRoleInfo)this.workRoleInfoService.getById(hfw.getWorkId());
                hfw.setWorkName(w.getWorkName());
                if (w.getOrgName() != null) {
                    hfw.setWorkName(w.getWorkName() + "/" + w.getOrgName());
                }
                hfw.setWorkRoleUserCount(this.staffInfoService.getStaffCountByWork(hfw.getWorkId(), param.getCid()));
            }
        }
        PageInfo pageInfo = new PageInfo(harmfactorWorkList);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public HarmfactorWork saveHarmfactorWorkSource(List<HarmfactorWorkSource> hwList, List<HarmfactorWorkSource> areaDelMetaDataList, Long workId, Byte contactType, Long workHarmfactorId, Boolean isClone, Long orgId, Long loginStaffId, Long cid) throws Exception {
        List<Long> delIdInfo;
        HarmfactorWork hw = (HarmfactorWork)this.getById(workHarmfactorId);
        if (hw == null) {
            hw = new HarmfactorWork();
        }
        hw.setContactType(contactType);
        hw.setWorkId(workId);
        if (isClone != null && isClone.booleanValue()) {
            hw.setId(null);
        }
        if (hw.getId() == null) {
            hw.setOrgId(orgId);
        }
        hw = this.saveOrUpdateHarmfactorWork(hw, loginStaffId, cid);
        workHarmfactorId = hw.getId();
        this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorManagePost, CoreWorkEnum.companyWorkType, workHarmfactorId, loginStaffId, cid, new Long[]{workId});
        Example e2 = new Example(HarmfactorWorkSource.class);
        e2.createCriteria().andEqualTo("workHarmfactorId", (Object)workHarmfactorId).andEqualTo("isHis", (Object)false).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List oldhwsList = this.harmfactorWorkSourceMapper.selectByExample(e2);
        if (this.triggerWorkHarmFactorChange(hwList, oldhwsList)) {
            // empty if block
        }
        Map<String, Set<HarmfactorWorkSource>> data = this.parseData(hwList, oldhwsList, isClone);
        Set<HarmfactorWorkSource> updHws = data.get("updHws");
        Set<HarmfactorWorkSource> delHws = data.get("delHws");
        Set<HarmfactorWorkSource> addHws = data.get("addHws");
        if (CollectionUtils.isNotEmpty(areaDelMetaDataList) && CollectionUtils.isNotEmpty(delIdInfo = this.harmfactorAreaSourceMapper.getDelIdInfo(areaDelMetaDataList, loginStaffId))) {
            Example e = new Example(HarmfactorAreaSource.class);
            e.createCriteria().andIn("id", delIdInfo);
            HarmfactorAreaSource areaSource = new HarmfactorAreaSource();
            areaSource.setIsValid(Boolean.valueOf(false));
            areaSource.setUpdateBy(loginStaffId);
            areaSource.setUpdateDate(new Date());
            this.harmfactorAreaSourceMapper.updateByExampleSelective(areaSource, e);
        }
        if (delHws != null && !delHws.isEmpty()) {
            for (HarmfactorWorkSource hws : delHws) {
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                hws.setIsValid(Boolean.valueOf(false));
                if (hws.getIsFinish() != null && hws.getIsFinish().booleanValue() && hws.getCheckPlanId() != null) {
                    hws.setIsHis(Boolean.valueOf(true));
                }
                int areaSource = this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(hws);
            }
        }
        if (updHws != null && !updHws.isEmpty()) {
            for (HarmfactorWorkSource hws : updHws) {
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                int upd = this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(hws);
                if (upd != 0) continue;
                addHws.add(hws);
            }
        }
        if (addHws != null && !addHws.isEmpty()) {
            for (HarmfactorWorkSource hws : addHws) {
                CheckPlan hcp;
                if (hws.getCheckPlanId() != null && (hcp = (CheckPlan)this.checkPlanService.getById((Serializable)hws.getCheckPlanId())) != null) {
                    hws.setCheckDate(DateUtil.getDate((LocalDateTime)hcp.getCheckDateBegin()));
                }
                hws.setId(Long.valueOf(this.idworker.nextId()));
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                hws.setIsValid(Boolean.valueOf(true));
                hws.setCreateBy(loginStaffId);
                hws.setCreateDate(new Date());
                hws.setCid(cid);
                hws.setWorkHarmfactorId(workHarmfactorId);
                this.harmfactorWorkSourceMapper.insertSelective(hws);
            }
        }
        return hw;
    }

    @Transactional(readOnly=false)
    public HarmfactorWork liteSaveHarmfactorWorkSource(List<HarmfactorWorkSource> hwList, Long workId, Long workHarmfactorId, Boolean isClone, Long orgId, Long loginStaffId, Long cid) throws Exception {
        HarmfactorWork hw = (HarmfactorWork)this.getById(workHarmfactorId);
        if (hw == null) {
            hw = new HarmfactorWork();
        }
        hw.setWorkId(workId);
        if (isClone != null && isClone.booleanValue()) {
            hw.setId(null);
        }
        if (hw.getId() == null) {
            hw.setOrgId(orgId);
        }
        hw = this.saveOrUpdateHarmfactorWork(hw, loginStaffId, cid);
        workHarmfactorId = hw.getId();
        this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorManagePost, CoreWorkEnum.companyWorkType, workHarmfactorId, loginStaffId, cid, new Long[]{workId});
        Example e2 = new Example(HarmfactorWorkSource.class);
        e2.createCriteria().andEqualTo("workHarmfactorId", (Object)workHarmfactorId).andEqualTo("isHis", (Object)false).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List oldhwsList = this.harmfactorWorkSourceMapper.selectByExample(e2);
        if (this.triggerWorkHarmFactorChange(hwList, oldhwsList)) {
            // empty if block
        }
        Map<String, Set<HarmfactorWorkSource>> data = this.parseData(hwList, oldhwsList, isClone);
        Set<HarmfactorWorkSource> updHws = data.get("updHws");
        Set<HarmfactorWorkSource> delHws = data.get("delHws");
        Set<HarmfactorWorkSource> addHws = data.get("addHws");
        if (delHws != null && !delHws.isEmpty()) {
            for (HarmfactorWorkSource hws : delHws) {
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                hws.setIsValid(Boolean.valueOf(false));
                if (hws.getIsFinish() != null && hws.getIsFinish().booleanValue() && hws.getCheckPlanId() != null) {
                    hws.setIsHis(Boolean.valueOf(true));
                }
                int n = this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(hws);
            }
        }
        if (updHws != null && !updHws.isEmpty()) {
            for (HarmfactorWorkSource hws : updHws) {
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                int upd = this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(hws);
                if (upd != 0) continue;
                addHws.add(hws);
            }
        }
        if (addHws != null && !addHws.isEmpty()) {
            for (HarmfactorWorkSource hws : addHws) {
                CheckPlan hcp;
                if (hws.getCheckPlanId() != null && (hcp = (CheckPlan)this.checkPlanService.getById((Serializable)hws.getCheckPlanId())) != null) {
                    hws.setCheckDate(DateUtil.getDate((LocalDateTime)hcp.getCheckDateBegin()));
                }
                hws.setId(Long.valueOf(this.idworker.nextId()));
                hws.setUpdateBy(loginStaffId);
                hws.setUpdateDate(new Date());
                hws.setIsValid(Boolean.valueOf(true));
                hws.setCreateBy(loginStaffId);
                hws.setCreateDate(new Date());
                hws.setCid(cid);
                hws.setWorkHarmfactorId(workHarmfactorId);
                this.harmfactorWorkSourceMapper.insertSelective(hws);
            }
        }
        return hw;
    }

    public Map<String, Set<HarmfactorWorkSource>> parseData(List<HarmfactorWorkSource> newhwsList, List<HarmfactorWorkSource> oldhwsList, Boolean isClone) {
        String key;
        HashMap<String, Set<HarmfactorWorkSource>> data = new HashMap<String, Set<HarmfactorWorkSource>>();
        HashSet<HarmfactorWorkSource> delHws = new HashSet<HarmfactorWorkSource>();
        HashSet<HarmfactorWorkSource> addHws = new HashSet<HarmfactorWorkSource>();
        HashSet<HarmfactorWorkSource> updHws = new HashSet<HarmfactorWorkSource>();
        if (isClone != null && isClone.booleanValue()) {
            addHws.addAll(newhwsList);
            data.put("addHws", addHws);
            return data;
        }
        HashMap<CallSite, HarmfactorWorkSource> harmIdData = new HashMap<CallSite, HarmfactorWorkSource>();
        if (newhwsList != null && !newhwsList.isEmpty()) {
            for (HarmfactorWorkSource hws : newhwsList) {
                harmIdData.put((CallSite)((Object)(hws.getHarmId() + "_" + hws.getHazardSource())), hws);
            }
        }
        HashMap<CallSite, HarmfactorWorkSource> oldHarmIdData = new HashMap<CallSite, HarmfactorWorkSource>();
        if (oldhwsList != null && !oldhwsList.isEmpty()) {
            for (HarmfactorWorkSource oldhws : oldhwsList) {
                oldHarmIdData.put((CallSite)((Object)(oldhws.getHarmId() + "_" + oldhws.getHazardSource())), oldhws);
            }
        }
        for (HarmfactorWorkSource hws : newhwsList) {
            key = hws.getHarmId() + "_" + hws.getHazardSource();
            if (oldHarmIdData.containsKey(key)) {
                updHws.add((HarmfactorWorkSource)oldHarmIdData.get(key));
                continue;
            }
            addHws.add(hws);
        }
        for (HarmfactorWorkSource oldhws : oldhwsList) {
            key = oldhws.getHarmId() + "_" + oldhws.getHazardSource();
            if (harmIdData.containsKey(key)) continue;
            delHws.add(oldhws);
        }
        data.put("updHws", updHws);
        data.put("delHws", delHws);
        data.put("addHws", addHws);
        return data;
    }

    public Map<String, Set<HarmfactorWorkSource>> liteParseData(List<HarmfactorWorkSource> newhwsList, List<HarmfactorWorkSource> oldhwsList, Boolean isClone) {
        String key;
        HashMap<String, Set<HarmfactorWorkSource>> data = new HashMap<String, Set<HarmfactorWorkSource>>();
        HashSet<HarmfactorWorkSource> delHws = new HashSet<HarmfactorWorkSource>();
        HashSet<HarmfactorWorkSource> addHws = new HashSet<HarmfactorWorkSource>();
        HashSet<HarmfactorWorkSource> updHws = new HashSet<HarmfactorWorkSource>();
        if (isClone != null && isClone.booleanValue()) {
            addHws.addAll(newhwsList);
            data.put("addHws", addHws);
            return data;
        }
        HashMap<CallSite, HarmfactorWorkSource> harmIdData = new HashMap<CallSite, HarmfactorWorkSource>();
        if (newhwsList != null && !newhwsList.isEmpty()) {
            for (HarmfactorWorkSource hws : newhwsList) {
                harmIdData.put((CallSite)((Object)(hws.getHarmId() + "_" + hws.getHazardSource())), hws);
            }
        }
        HashMap<CallSite, HarmfactorWorkSource> oldHarmIdData = new HashMap<CallSite, HarmfactorWorkSource>();
        if (oldhwsList != null && !oldhwsList.isEmpty()) {
            for (HarmfactorWorkSource oldhws : oldhwsList) {
                oldHarmIdData.put((CallSite)((Object)(oldhws.getHarmId() + "_" + oldhws.getHazardSource())), oldhws);
            }
        }
        for (HarmfactorWorkSource hws : newhwsList) {
            key = hws.getHarmId() + "_" + hws.getHazardSource();
            if (oldHarmIdData.containsKey(key)) {
                updHws.add((HarmfactorWorkSource)oldHarmIdData.get(key));
                continue;
            }
            addHws.add(hws);
        }
        for (HarmfactorWorkSource oldhws : oldhwsList) {
            key = oldhws.getHarmId() + "_" + oldhws.getHazardSource();
            if (harmIdData.containsKey(key)) continue;
            delHws.add(oldhws);
        }
        data.put("updHws", updHws);
        data.put("delHws", delHws);
        data.put("addHws", addHws);
        return data;
    }

    public boolean triggerWorkHarmFactorChange(List<HarmfactorWorkSource> haList, List<HarmfactorWorkSource> oldhaList) {
        if (oldhaList.size() == 0 && haList.size() == 0) {
            return false;
        }
        if (haList.size() != oldhaList.size()) {
            return true;
        }
        HashSet<Long> hsSet = new HashSet<Long>();
        for (HarmfactorWorkSource ha : haList) {
            hsSet.add(ha.getHarmId());
        }
        for (HarmfactorWorkSource ha : oldhaList) {
            if (hsSet.contains(ha.getHarmId())) continue;
            return true;
        }
        return false;
    }

    public List<Long> listWorkIdByCid(Long cid) {
        return this.harmfactorWorkMapper.listWorkIdByCid(cid);
    }

    public Integer countSourceNumByWork(Long cid, Long workId, Long wid) {
        return this.harmfactorWorkMapper.countSourceNumByWork(cid, workId, wid);
    }

    public List<HarmfactorWorkSource> getHarmfactorWsInfoByCheckplanIdHarmId(Long cid, Long harmId, Long checkPlanId) {
        return this.harmfactorWorkMapper.getHarmfactorWsInfoByCheckplanIdHarmId(cid, harmId, checkPlanId);
    }

    public HarmfactorItemVO collectWorkCompHarmfactor(Long cid) {
        HarmfactorItemVO itemVo = new HarmfactorItemVO();
        return itemVo;
    }

    public PageInfo<HarmfactorHccheckplanunderway> pageHarmfactorHccheckplanUnderway(JqGridParam gparam, Boolean isFinish) {
        HarmfactorHccheckplanunderway qParam = new HarmfactorHccheckplanunderway();
        qParam.setCid(gparam.getCid());
        List postDatas = gparam.getPostDatas();
        if (postDatas != null && !postDatas.isEmpty()) {
            for (ParamSeachFieldVO postData : postDatas) {
                if ("searchKey".equals(postData.getSearchField())) {
                    qParam.setHccplanName(postData.getSearchValue());
                }
                if ("startTime".equals(postData.getSearchField())) {
                    qParam.setHazardStartDate(DateUtils.StringToDate((String)postData.getSearchValue()));
                }
                if (!"endTime".equals(postData.getSearchField())) continue;
                qParam.setHazardEndDate(DateUtils.StringToDate((String)postData.getSearchValue()));
            }
        }
        qParam.setIsFinish(isFinish);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("company.harmfactor", "hc_check_plan");
        List<HarmfactorHccheckplanunderway> hHccheckplanunderwayList = this.harmfactorWorkHccheckplanMapper.listHarmfactorHccheckplanUnderway(qParam);
        PageInfo page = new PageInfo(hHccheckplanunderwayList);
        return page;
    }

    @Deprecated
    public int countHccplanUnderWay(Long cid, Boolean isFinish) {
        Example e = new Example(HarmfactorHccheckplanunderway.class);
        Example.Criteria c = e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (isFinish != null) {
            c.andEqualTo("isFinish", (Object)isFinish);
        }
        return this.harmfactorWorkHccheckplanMapper.selectCountByExample(e);
    }

    public int insertHarmfactorWorkHccheckplan(HarmfactorHccheckplanunderway underway) {
        underway.setId(Long.valueOf(this.idworker.nextId()));
        return this.harmfactorWorkHccheckplanMapper.insertSelective(underway);
    }

    public List<HarmfactorWorkSourceVo> getHarmLinkHccheckplan(Long cid, Long hcplanId, Boolean isFinish, String kw, boolean isAdminModel) {
        List wriList = this.workRoleInfoService.getWorkRoleOrganByCidAndSearch(cid, kw);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.get((Number)hcplanId);
        String checkStartTime = "";
        if (checkPlan != null) {
            checkStartTime = cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)checkPlan.getCheckDateBegin(), (String)"yyyy-MM-dd");
        }
        ArrayList<HarmfactorWorkSourceVo> harmfactorWorkSourceList = new ArrayList<HarmfactorWorkSourceVo>();
        if (wriList != null && !wriList.isEmpty()) {
            List<HarmfactorWorkSourceVo> oldHwsList = this.harmfactorWorkMapper.getSourceAndHarmname(cid, hcplanId, isFinish);
            for (WorkRoleInfo wri : wriList) {
                HarmfactorWorkSourceVo hs = new HarmfactorWorkSourceVo();
                hs.setWorkId(wri.getId());
                hs.setWorkName(wri.getWorkName());
                hs.setId(wri.getId());
                boolean adminAdd = false;
                HashSet<String> harmNameSet = new HashSet<String>();
                if (oldHwsList != null && !oldHwsList.isEmpty()) {
                    HashMap<String, Set<String>> sourceHarmIdNameVoMap = new HashMap<String, Set<String>>();
                    for (HarmfactorWorkSourceVo oldHws : oldHwsList) {
                        if (oldHws == null || !wri.getId().equals(oldHws.getWorkId())) continue;
                        harmNameSet.add(oldHws.getHarmName());
                        this.parseWorkSourceHarmIdName(sourceHarmIdNameVoMap, oldHws.getSourceHarmIdNameStr());
                        if (isFinish == null || !isFinish.booleanValue()) continue;
                        hs.setHarmName(StringUtils.join(harmNameSet, (String)","));
                        harmfactorWorkSourceList.add(hs);
                        adminAdd = true;
                        break;
                    }
                    HashMap result = new HashMap();
                    if (MapUtils.isNotEmpty(sourceHarmIdNameVoMap)) {
                        Set keyset = sourceHarmIdNameVoMap.keySet();
                        for (String source : keyset) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("workId", "" + wri.getId());
                            map.put("reportName", source);
                            map.put("checkStartTime", checkStartTime);
                            map.put("harmFactorNamesAndIds", StringUtils.join((Iterable)((Iterable)sourceHarmIdNameVoMap.get(source)), (String)"~&~"));
                            result.put(source, map);
                        }
                        hs.setDatajson(JSON.toJSONString(result));
                    }
                }
                if (isFinish == null || !isFinish.booleanValue()) {
                    hs.setHarmName(StringUtils.join(harmNameSet, (String)","));
                    harmfactorWorkSourceList.add(hs);
                    continue;
                }
                if (!isAdminModel || adminAdd) continue;
                hs.setHarmName(StringUtils.join(harmNameSet, (String)","));
                harmfactorWorkSourceList.add(hs);
            }
        }
        return harmfactorWorkSourceList;
    }

    private void parseWorkSourceHarmIdName(Map<String, Set<String>> sourceHarmIdNameVoMap, String harmNameIdStr) {
        if (StringUtils.isBlank((CharSequence)harmNameIdStr)) {
            return;
        }
        Object[] harmNameIdStrArr = StringUtils.splitByWholeSeparator((String)harmNameIdStr, (String)MOREHARMSOURCE_SPLIT);
        if (ArrayUtils.isNotEmpty((Object[])harmNameIdStrArr)) {
            for (Object harmNameIdStrTemp : harmNameIdStrArr) {
                String[] oneHarmNameIdArr = StringUtils.splitByWholeSeparator((String)harmNameIdStrTemp, (String)ONEHARMSOURCE_SPLIT);
                if (oneHarmNameIdArr == null || oneHarmNameIdArr.length <= 2 || !StringUtils.isLong((String)oneHarmNameIdArr[1])) continue;
                String harmId = oneHarmNameIdArr[1];
                String harmName = oneHarmNameIdArr[2];
                String source = oneHarmNameIdArr[0];
                String value = harmName + ":" + harmId;
                sourceHarmIdNameVoMap.computeIfAbsent(source, v -> new HashSet()).add(value);
            }
        }
    }

    public void handleHarmSourceJsonData(List<HarmSourceJsonVo> hsJsonList, Long harmid, String source, String sourceSeparator) {
        if (hsJsonList == null) {
            hsJsonList = new ArrayList<HarmSourceJsonVo>();
        }
        if (hsJsonList.isEmpty()) {
            HarmSourceJsonVo vo = new HarmSourceJsonVo();
            vo.setHarmid(harmid);
            vo.setSource(source);
            hsJsonList.add(vo);
        } else {
            boolean hasHarmid = false;
            for (HarmSourceJsonVo hsJson : hsJsonList) {
                if (!harmid.equals(hsJson.getHarmid())) continue;
                if (!StringUtils.validContains((String)hsJson.getSource(), (String)source, (String)sourceSeparator).booleanValue()) {
                    if (StringUtils.isEmpty((CharSequence)hsJson.getSource())) {
                        hsJson.setSource(source);
                    } else {
                        hsJson.setSource(hsJson.getSource() + sourceSeparator + source);
                    }
                }
                hasHarmid = true;
            }
            if (!hasHarmid) {
                HarmSourceJsonVo vo = new HarmSourceJsonVo();
                vo.setHarmid(harmid);
                vo.setSource(source);
                hsJsonList.add(vo);
            }
        }
    }

    @Transactional(readOnly=false)
    public void saveHarmLinkHccheckplan(List<HarmfactorWorkSource> wharmSourceHccplanList, boolean isFinish, Long checkPlanId, Boolean isAdminModel, Long cid, Long loginStaffId) throws Exception {
        List<HarmfactorWorkSourceVo> backHarmfactorHisData;
        Example e;
        CheckPlan newhcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkPlanId);
        HashSet<Long> processHwSet = new HashSet<Long>();
        if (wharmSourceHccplanList != null && !wharmSourceHccplanList.isEmpty()) {
            for (HarmfactorWorkSource hws : wharmSourceHccplanList) {
                String[] harmNameIdArr;
                String harmNameId;
                if (hws.getIsValid() != null && !hws.getIsValid().booleanValue()) {
                    Example e2 = new Example(HarmfactorWork.class);
                    e2.createCriteria().andEqualTo("workId", (Object)hws.getWorkId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
                    HarmfactorWork harmfactorWork = (HarmfactorWork)this.getOneByExample(e2);
                    if (harmfactorWork != null) {
                        Example esource = new Example(HarmfactorWorkSource.class);
                        Example.Criteria criteriaEsource = esource.createCriteria().andEqualTo("workHarmfactorId", (Object)harmfactorWork.getId()).andEqualTo("checkPlanId", (Object)checkPlanId).andEqualTo("isFinish", (Object)isAdminModel).andEqualTo("cid", (Object)cid);
                        if (!isAdminModel.booleanValue()) {
                            criteriaEsource.andEqualTo("isHis", (Object)false);
                        }
                        this.harmfactorWorkSourceMapper.deleteByExample(esource);
                        processHwSet.add(harmfactorWork.getId());
                    }
                }
                if (!StringUtils.isNotEmpty((String)(harmNameId = hws.getHarmNameId())) || (harmNameIdArr = StringUtils.split((String)harmNameId, (String)MOREHARMSOURCE_SPLIT)) == null || harmNameIdArr.length <= 0) continue;
                e = new Example(HarmfactorWork.class);
                e.createCriteria().andEqualTo("workId", (Object)hws.getWorkId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
                HarmfactorWork harmfactorWork = (HarmfactorWork)this.getOneByExample(e);
                if (harmfactorWork == null) {
                    harmfactorWork = new HarmfactorWork();
                    harmfactorWork.setWorkId(hws.getWorkId());
                    harmfactorWork = this.saveOrUpdateHarmfactorWork(harmfactorWork, loginStaffId, cid);
                }
                List<HarmfactorWorkSource> newHwsList = this.parseharmNameIdArr2List(harmNameIdArr, newhcCheckPlan, harmfactorWork.getId(), isFinish, cid, loginStaffId);
                Example esource = new Example(HarmfactorWorkSource.class);
                Example.Criteria criteriaEsource = esource.createCriteria().andEqualTo("workHarmfactorId", (Object)harmfactorWork.getId()).andEqualTo("checkPlanId", (Object)checkPlanId).andEqualTo("isFinish", (Object)isAdminModel).andEqualTo("cid", (Object)cid);
                if (!isAdminModel.booleanValue()) {
                    criteriaEsource.andEqualTo("isHis", (Object)false);
                }
                this.harmfactorWorkSourceMapper.deleteByExample(esource);
                processHwSet.add(harmfactorWork.getId());
                if (isFinish) {
                    Set<HarmfactorWorkSource> newHwsList2 = this.handlerHwHistoryData2(newHwsList, newhcCheckPlan, harmfactorWork.getId(), cid, loginStaffId);
                    ArrayList<HarmfactorWorkSource> addHarmfactorWorkSourceSet = new ArrayList<HarmfactorWorkSource>();
                    if (newHwsList2 == null || newHwsList2.isEmpty()) continue;
                    for (HarmfactorWorkSource newHs : newHwsList2) {
                        if (newHs.getId() == null) {
                            newHs.setId(Long.valueOf(this.idworker.nextId()));
                            addHarmfactorWorkSourceSet.add(newHs);
                            continue;
                        }
                        this.harmfactorWorkSourceService.saveOrUpdateHarmfactorWorkSource(newHs, loginStaffId, cid);
                    }
                    this.batchInsertHarmWorkSource(addHarmfactorWorkSourceSet);
                    continue;
                }
                this.batchInsertHarmWorkSource(newHwsList);
            }
        }
        if (isFinish) {
            Example esource = new Example(HarmfactorWorkSource.class);
            Example.Criteria c = esource.createCriteria();
            if (!processHwSet.isEmpty()) {
                c.andNotIn("workHarmfactorId", processHwSet);
            }
            c.andEqualTo("checkPlanId", (Object)checkPlanId).andEqualTo("isHis", (Object)false).andEqualTo("isFinish", (Object)false).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
            List noProcessHws = this.harmfactorWorkSourceMapper.selectByExample(esource);
            this.parseNoProcessHwsData(noProcessHws, newhcCheckPlan, cid);
        }
        if (isAdminModel != null && isAdminModel.booleanValue() && CommonUtil.listIsNotEmpty(backHarmfactorHisData = this.harmfactorWorkMapper.getBackHarmfactorHisData(cid))) {
            for (HarmfactorWorkSourceVo backHarmfactorHisDatum : backHarmfactorHisData) {
                HarmfactorWorkSource result = new HarmfactorWorkSource();
                result.setIsHis(Boolean.valueOf(false));
                e = new Example(HarmfactorWorkSource.class);
                e.createCriteria().andEqualTo("workHarmfactorId", (Object)backHarmfactorHisDatum.getWorkHarmfactorId()).andEqualTo("checkDate", (Object)backHarmfactorHisDatum.getCheckDate());
                this.harmfactorWorkSourceMapper.updateByExampleSelective(result, e);
            }
        }
        this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactor, CoreWorkEnum.harmfactorTest, checkPlanId, loginStaffId, cid, new Long[]{checkPlanId});
    }

    private void parseNoProcessHwsData(List<HarmfactorWorkSource> noProcessHws, CheckPlan newhcCheckPlan, Long cid) {
        if (noProcessHws != null && !noProcessHws.isEmpty()) {
            for (HarmfactorWorkSource newHws : noProcessHws) {
                Example checkESource = new Example(HarmfactorWorkSource.class);
                checkESource.createCriteria().andEqualTo("workHarmfactorId", (Object)newHws.getWorkHarmfactorId()).andNotEqualTo("checkPlanId", (Object)newhcCheckPlan.getId()).andEqualTo("harmId", (Object)newHws.getHarmId()).andEqualTo("isHis", (Object)false).andEqualTo("isFinish", (Object)true).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
                List oldHwsList = this.harmfactorWorkSourceMapper.selectByExample(checkESource);
                if (oldHwsList != null && !oldHwsList.isEmpty()) {
                    for (HarmfactorWorkSource oldhws : oldHwsList) {
                        Date oldHcDate = oldhws.getCheckDate();
                        if (oldHcDate == null) {
                            CheckPlan oldHcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)oldhws.getCheckPlanId());
                            if (oldHcCheckPlan == null || oldHcCheckPlan.getCheckDateBegin() == null) {
                                throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
                            }
                            oldHcDate = DateUtil.getDate((LocalDateTime)oldHcCheckPlan.getCheckDateBegin());
                        }
                        if (DateUtil.getDate((LocalDateTime)newhcCheckPlan.getCheckDateBegin()).getTime() > oldHcDate.getTime()) {
                            HarmfactorWorkSource his = new HarmfactorWorkSource();
                            his.setIsHis(Boolean.valueOf(true));
                            his.setId(oldhws.getId());
                            this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(his);
                            HarmfactorWorkSource isFinHws = new HarmfactorWorkSource();
                            isFinHws.setIsFinish(Boolean.valueOf(true));
                            isFinHws.setId(newHws.getId());
                            this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(isFinHws);
                            continue;
                        }
                        HarmfactorWorkSource isFinHws = new HarmfactorWorkSource();
                        isFinHws.setIsFinish(Boolean.valueOf(true));
                        isFinHws.setIsHis(Boolean.valueOf(true));
                        isFinHws.setId(newHws.getId());
                        this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(isFinHws);
                    }
                    continue;
                }
                HarmfactorWorkSource isFinHws = new HarmfactorWorkSource();
                isFinHws.setIsFinish(Boolean.valueOf(true));
                isFinHws.setId(newHws.getId());
                this.harmfactorWorkSourceMapper.updateByPrimaryKeySelective(isFinHws);
            }
        }
    }

    private List<HarmfactorWorkSource> parseharmNameIdArr2List(String[] harmNameIdArr, CheckPlan newhcCheckPlan, Long workHarmfactorId, Boolean isFinish, Long cid, Long loginStaffId) {
        ArrayList<HarmfactorWorkSource> newHwsList = new ArrayList<HarmfactorWorkSource>();
        for (String onehsorce : harmNameIdArr) {
            Long harmId = null;
            String source = "";
            String[] oneHarmNameIdArr = StringUtils.splitByWholeSeparator((String)onehsorce, (String)ONEHARMSOURCE_SPLIT);
            if (oneHarmNameIdArr != null && oneHarmNameIdArr.length > 1 && StringUtils.isLong((String)oneHarmNameIdArr[0])) {
                harmId = StringUtils.toLong((Object)oneHarmNameIdArr[0]);
                source = oneHarmNameIdArr[1];
            }
            if (harmId == null || !StringUtils.isNotEmpty((String)source)) continue;
            HarmfactorWorkSource newHs = new HarmfactorWorkSource();
            newHs.setCid(cid);
            newHs.setHarmId(harmId);
            newHs.setCheckPlanId(newhcCheckPlan.getId());
            newHs.setCheckDate(DateUtil.getDate((LocalDateTime)newhcCheckPlan.getCheckDateBegin()));
            newHs.setWorkHarmfactorId(workHarmfactorId);
            newHs.setIsFinish(isFinish);
            newHs.setIsValid(Boolean.valueOf(true));
            newHs.setHazardSource(source);
            newHs.setIsHis(Boolean.valueOf(false));
            newHs.setCreateBy(loginStaffId);
            newHs.setCreateDate(new Date());
            newHs.setUpdateBy(loginStaffId);
            newHs.setUpdateDate(new Date());
            newHwsList.add(newHs);
        }
        return newHwsList;
    }

    public Set<HarmfactorWorkSource> handlerHwHistoryData2(List<HarmfactorWorkSource> newHwsList, CheckPlan newhcCheckPlan, Long workHarmfactorId, Long cid, Long loginStaffId) {
        if (newhcCheckPlan == null || newhcCheckPlan.getCheckDateBegin() == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (newHwsList == null || newHwsList.isEmpty()) {
            return null;
        }
        HashSet<HarmfactorWorkSource> resultHwsList = new HashSet<HarmfactorWorkSource>();
        Example checkESource = new Example(HarmfactorWorkSource.class);
        checkESource.createCriteria().andEqualTo("workHarmfactorId", (Object)workHarmfactorId).andIsNotNull("checkPlanId").andEqualTo("isHis", (Object)false).andEqualTo("isFinish", (Object)true).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List oldHwsList = this.harmfactorWorkSourceMapper.selectByExample(checkESource);
        if (oldHwsList == null || oldHwsList.isEmpty()) {
            return new HashSet<HarmfactorWorkSource>(newHwsList);
        }
        for (HarmfactorWorkSource newHws : newHwsList) {
            if (oldHwsList != null && !oldHwsList.isEmpty()) {
                boolean newHwsnotcompare = false;
                for (HarmfactorWorkSource oldhws : oldHwsList) {
                    if (!oldhws.getHarmId().equals(newHws.getHarmId())) continue;
                    newHwsnotcompare = true;
                    Date oldHcDate = oldhws.getCheckDate();
                    if (oldHcDate == null) {
                        CheckPlan oldHcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)oldhws.getCheckPlanId());
                        if (oldHcCheckPlan == null || oldHcCheckPlan.getCheckDateBegin() == null) {
                            throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
                        }
                        oldHcDate = DateUtil.getDate((LocalDateTime)oldHcCheckPlan.getCheckDateBegin());
                    }
                    if (DateUtil.getDate((LocalDateTime)newhcCheckPlan.getCheckDateBegin()).getTime() > oldHcDate.getTime()) {
                        oldhws.setIsHis(Boolean.valueOf(true));
                        resultHwsList.add(oldhws);
                    } else {
                        newHws.setIsHis(Boolean.valueOf(true));
                    }
                    resultHwsList.add(newHws);
                }
                if (newHwsnotcompare) continue;
                resultHwsList.add(newHws);
                continue;
            }
            resultHwsList.add(newHws);
        }
        return resultHwsList;
    }

    public boolean isExistsInHarmfactorWorkSourceList(HarmfactorWorkSource oldhws, List<HarmfactorWorkSource> newHwsList) {
        if (newHwsList != null && !newHwsList.isEmpty()) {
            for (HarmfactorWorkSource newHws : newHwsList) {
                if (!newHws.getHarmId().equals(oldhws.getHarmId())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<HarmfactorWorkSource> handlerHwHistoryData(List<HarmfactorWorkSource> newHwsList, Long checkPlanId, Long workHarmfactorId, Long cid, Long loginStaffId) {
        CheckPlan newhcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkPlanId);
        if (newhcCheckPlan == null || newhcCheckPlan.getCheckDateBegin() == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (newHwsList == null || newHwsList.isEmpty()) {
            return null;
        }
        HashSet<HarmfactorWorkSource> resultHwsList = new HashSet<HarmfactorWorkSource>();
        Example checkESource = new Example(HarmfactorWorkSource.class);
        checkESource.createCriteria().andEqualTo("workHarmfactorId", (Object)workHarmfactorId).andIsNotNull("checkPlanId").andEqualTo("isHis", (Object)false).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List oldHwsList = this.harmfactorWorkSourceMapper.selectByExample(checkESource);
        if (oldHwsList != null && !oldHwsList.isEmpty()) {
            Iterator olditerator = oldHwsList.iterator();
            while (olditerator.hasNext()) {
                HarmfactorWorkSource oldHws = (HarmfactorWorkSource)olditerator.next();
                CheckPlan oldHcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)oldHws.getCheckPlanId());
                if (oldHcCheckPlan == null || oldHcCheckPlan.getCheckDateBegin() == null) {
                    throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
                }
                Iterator<HarmfactorWorkSource> newiterator = newHwsList.iterator();
                while (newiterator.hasNext()) {
                    HarmfactorWorkSource newHws = newiterator.next();
                    if (oldHws.getHarmId().equals(newHws.getHarmId())) {
                        if (newhcCheckPlan.getCheckDateBegin().compareTo(oldHcCheckPlan.getCheckDateBegin()) > 0) {
                            oldHws.setIsHis(Boolean.valueOf(true));
                            oldHws.setIsValid(Boolean.valueOf(true));
                            oldHws.setUpdateBy(loginStaffId);
                            oldHws.setUpdateDate(new Date());
                            resultHwsList.add(oldHws);
                            resultHwsList.add(newHws);
                            newiterator.remove();
                            olditerator.remove();
                            continue;
                        }
                        newHws.setIsHis(Boolean.valueOf(true));
                        resultHwsList.add(newHws);
                        continue;
                    }
                    if (newhcCheckPlan.getCheckDateBegin().compareTo(oldHcCheckPlan.getCheckDateBegin()) <= 0) continue;
                    oldHws.setIsHis(Boolean.valueOf(true));
                    oldHws.setIsValid(Boolean.valueOf(true));
                    oldHws.setUpdateBy(loginStaffId);
                    oldHws.setUpdateDate(new Date());
                    resultHwsList.add(oldHws);
                    resultHwsList.add(newHws);
                    newiterator.remove();
                    olditerator.remove();
                }
            }
        }
        return resultHwsList;
    }

    public List<HarmfactorWorkSource> getAlikeHarmIdInList(List<HarmfactorWorkSource> hwsList, Long harmId) {
        if (harmId == null) {
            return null;
        }
        if (hwsList != null && !hwsList.isEmpty()) {
            ArrayList<HarmfactorWorkSource> resultHwsList = new ArrayList<HarmfactorWorkSource>();
            for (HarmfactorWorkSource hws : hwsList) {
                if (!harmId.equals(hws.getHarmId())) continue;
                resultHwsList.add(hws);
            }
            return resultHwsList;
        }
        return null;
    }

    public HarmfactorHccheckplanunderway getHarmfactorHccheckplanunderwayById(Long hhccplanId) {
        return (HarmfactorHccheckplanunderway)this.harmfactorWorkHccheckplanMapper.selectByPrimaryKey(hhccplanId);
    }

    public PageInfo<HarmfactorWorkSourceVo> getHisDataByWork(JqGridParam jparam, Long workId, Long cid) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<HarmfactorWorkSourceVo> hwsVoList = this.harmfactorWorkMapper.getHisDataByWork(cid, workId);
        PageInfo page = new PageInfo(hwsVoList);
        return page;
    }

    @Transactional
    public void cloneHarmfactorWork(Long clonedWorkHarmfactorId, Long newWorkId, Long loginStaffId, Long cid) throws Exception {
        HarmfactorWork hw = new HarmfactorWork();
        hw.setWorkId(newWorkId);
        hw = this.saveOrUpdateHarmfactorWork(hw, loginStaffId, cid);
        List<HarmfactorWorkSource> hwsList = this.harmfactorWorkMapper.listCloneHarmfactorWorkSource(cid, clonedWorkHarmfactorId);
        if (hwsList != null && !hwsList.isEmpty()) {
            for (HarmfactorWorkSource hws : hwsList) {
                hws.setId(null);
                hws.setWorkHarmfactorId(hw.getId());
                hws.setCheckDate(null);
                hws.setCheckPlanId(null);
                this.harmfactorWorkSourceService.saveOrUpdateHarmfactorWorkSource(hws, loginStaffId, cid);
            }
        }
    }

    public List<String> getOccRiskFactorsNameList(Long cid, Integer type, String function) {
        List<OccupationalRiskFactors> occfactorList = this.harmfactorWorkMapper.getOccRiskFactorsList(cid, type, function);
        ArrayList<String> occFactorList = new ArrayList<String>();
        if (occfactorList != null && !occfactorList.isEmpty()) {
            for (OccupationalRiskFactors occfactor : occfactorList) {
                occFactorList.add(occfactor.getNameCh());
            }
        }
        return occFactorList;
    }

    public PageInfo<HarmfactorWorkSourceVo> getHarmfactorListGroupByWork(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HarmfactorWorkSourceVo> list = this.harmfactorWorkMapper.getHarmfactorListGroupByWork(param.getCid());
        if (list != null && !list.isEmpty()) {
            for (HarmfactorWorkSourceVo vo : list) {
                String workName = this.workRoleInfoService.getWorkNameIncludeOrgName(vo.getWorkId());
                vo.setWorkName(workName);
            }
        }
        PageInfo page = new PageInfo(list);
        return page;
    }

    public String getHarmNamesByWorks(Long cid, List<Long> allWorkIds, String splitor) {
        if (cid == null || allWorkIds == null || allWorkIds.isEmpty()) {
            return "";
        }
        String harmNames = "";
        List<HarmfactorWorkSourceInfoVo> harms = this.harmfactorWorkMapper.getHarmfactorListByWorks(cid, allWorkIds, null);
        if (harms == null || harms.size() == 0) {
            return harmNames;
        }
        ArrayList<String> harmArray = new ArrayList<String>();
        for (HarmfactorWorkSourceInfoVo harm : harms) {
            String harmCh = harm.getHarmName();
            if (StringUtils.isEmpty((CharSequence)harmCh) || harmArray.contains(harmCh)) continue;
            harmNames = StringUtils.isEmpty((CharSequence)harmNames) ? harmCh : harmNames + splitor + harmCh;
            harmArray.add(harmCh);
        }
        return harmNames;
    }

    public List<HarmfactorWorkSourceVo> ImportHarmsource(List<String> ossFileList, Long cid, Long hcplanId) throws IOException, Exception {
        if (CollectionUtils.isEmpty(ossFileList)) {
            return null;
        }
        InputStream ossInputStream = ExcelUtil.getInstance().getOssInputStream(ossFileList.get(0));
        ExcelReaderBuilder excelReaderBuilder = (ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)ossInputStream).autoCloseStream(Boolean.valueOf(true)).headRowNumber(Integer.valueOf(1))).autoTrim(Boolean.valueOf(true));
        NoModleDataListener workHarmDataListener = new NoModleDataListener();
        ((ExcelReaderSheetBuilder)excelReaderBuilder.sheet().registerReadListener((ReadListener)workHarmDataListener)).doRead();
        List<Map<Integer, String>> dataList = workHarmDataListener.getList();
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(Integer.MAX_VALUE);
        PageInfo hcchInfoPage = this.checkResultService.querySelectPointVosGroupByCheckPoint(jqGridParam, hcplanId, null);
        List SelectPointVoList = hcchInfoPage.getList();
        Map<Object, Object> selectPointVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)SelectPointVoList)) {
            selectPointVoMap = SelectPointVoList.stream().collect(Collectors.toMap(SelectPointVo::getReportName, v -> v, (v1, v2) -> v1));
        }
        ArrayList<HarmfactorWorkSourceVo> resultList = new ArrayList<HarmfactorWorkSourceVo>();
        HashMap<String, HarmfactorWorkSourceVo> excelData = new HashMap<String, HarmfactorWorkSourceVo>();
        if (CollectionUtils.isNotEmpty(dataList)) {
            int i;
            Map<Integer, String> header = dataList.get(0);
            HashMap<Integer, String> headerIndex = new HashMap<Integer, String>();
            int headerSize = header.size();
            for (i = 2; i < headerSize; ++i) {
                String sourceStr = header.get(i);
                headerIndex.put(i, sourceStr);
                if (excelData.containsKey(sourceStr)) continue;
                HarmfactorWorkSourceVo workSourceVo = new HarmfactorWorkSourceVo();
                workSourceVo.setWorkName(sourceStr);
                excelData.put(sourceStr, workSourceVo);
            }
            for (i = 1; i < dataList.size(); ++i) {
                Map<Integer, String> rowData = dataList.get(i);
                String workIdStr = rowData.get(0);
                String workNameStr = rowData.get(1);
                Long workId = null;
                if (!StringUtils.isNotBlank((CharSequence)workIdStr) || !StringUtils.isNumber((String)workIdStr)) continue;
                workId = Long.parseLong(workIdStr);
                HarmfactorWorkSourceVo result = new HarmfactorWorkSourceVo();
                result.setWorkId(workId);
                result.setId(workId);
                result.setWorkName(workNameStr);
                HashMap<String, Map> datajson = new HashMap<String, Map>();
                HashSet<String> harmNameSet = new HashSet<String>();
                boolean addFlag = false;
                for (int j = 2; j < headerSize; ++j) {
                    String cellStr;
                    if (!rowData.containsKey(j) || !StringUtils.isNotBlank((CharSequence)(cellStr = rowData.get(j))) || !"1.0".equals(cellStr)) continue;
                    addFlag = true;
                    String source = (String)headerIndex.get(j);
                    if (!selectPointVoMap.containsKey(source)) continue;
                    SelectPointVo selectPointVo = (SelectPointVo)selectPointVoMap.get(source);
                    harmNameSet.add(selectPointVo.getHarmFactorNames());
                    Map workSelectPointObjMap = datajson.computeIfAbsent(source, v -> new HashMap());
                    workSelectPointObjMap.put("reportName", source);
                    String dateStr = DateUtils.formatDate((Date)DateUtil.getDate((LocalDateTime)selectPointVo.getCheckDateBegin()));
                    workSelectPointObjMap.put("checkStartTime", dateStr);
                    workSelectPointObjMap.put("harmFactorNamesAndIds", selectPointVo.getHarmFactorNamesAndIds());
                }
                if (!addFlag) continue;
                result.setHarmName(StringUtils.join(harmNameSet, (String)","));
                result.setDatajson(JSON.toJSONString(datajson));
                resultList.add(result);
            }
        }
        return resultList;
    }

    private List<Long> queryFactorIdByCheckPoint(List<SelectPointVo> list, String checkPointName) {
        LinkedList<Long> factorIds = new LinkedList<Long>();
        for (SelectPointVo pointVo : list) {
            if (!pointVo.getPointName().equals(checkPointName)) continue;
            String factorId = pointVo.getFactorId();
            factorIds.addAll(HarmfactorWorkServiceImpl.parseStrIds(factorId));
        }
        return factorIds;
    }

    private static List<Long> parseStrIds(String ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (String s : ids.split(",")) {
            list.add(Long.parseLong(s));
        }
        return list;
    }

    private boolean validCellIsBlank(Cell cell) {
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return true;
        }
        cell.setCellType(CellType.STRING);
        return StringUtils.isBlank((CharSequence)cell.getStringCellValue().trim());
    }

    public String getRecommedCheck(Long cid, Long workId, String recommedType, String splitor, String excludes) {
        String result = "";
        if (cid == null || workId == null || StringUtils.isBlank((CharSequence)recommedType)) {
            return result;
        }
        List<HarmfactorWorkRecommendVo> list = ((HarmfactorWorkMapper)this.dao).getRecommedCheck(cid, workId, recommedType);
        result = this.getRecommedCheck(list, splitor, excludes);
        return result;
    }

    public List<String> getRecommedCheckList(Long cid, Long workId, String recommedType) {
        List<String> result = new ArrayList<String>();
        if (cid == null || workId == null || StringUtils.isBlank((CharSequence)recommedType)) {
            return result;
        }
        List<HarmfactorWorkRecommendVo> list = ((HarmfactorWorkMapper)this.dao).getRecommedCheck(cid, workId, recommedType);
        result = this.getRecommedCheckList(list);
        return result;
    }

    public List<String> getRecommedCheckList(List<HarmfactorWorkRecommendVo> list) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> result83 = new ArrayList<String>();
        if (list == null || list.size() == 0) {
            return result;
        }
        for (HarmfactorWorkRecommendVo l : list) {
            String idOccupationalHealth = l.getIdOccupationalHealth();
            String recommedCheckContent = l.getRecommedCheckContent();
            if ("83".equals(idOccupationalHealth)) {
                result83.add(recommedCheckContent);
                continue;
            }
            if (result.contains(recommedCheckContent)) continue;
            result.add(recommedCheckContent);
        }
        if (result.isEmpty()) {
            return result83;
        }
        return result;
    }

    public int batchInsertHarmWorkSource(List<HarmfactorWorkSource> list) throws Exception {
        if (CommonUtil.listIsNotEmpty(list)) {
            for (HarmfactorWorkSource harmfactorWorkSource : list) {
                if (harmfactorWorkSource.getId() != null) continue;
                harmfactorWorkSource.setId(Long.valueOf(this.idworker.nextId()));
            }
        }
        int count = 0;
        while (list.size() > 0) {
            if (list.size() <= 100) {
                count += this.harmfactorWorkMapper.batchInsertHarmWorkSource(list);
                break;
            }
            List<HarmfactorWorkSource> tempHwsList = list.subList(0, 100);
            count += this.harmfactorWorkMapper.batchInsertHarmWorkSource(tempHwsList);
            list.removeAll(tempHwsList);
        }
        return count;
    }

    public List<HarmfactorWorkSource> getHarmfactorWorkSourceListByWorkHarmHccId(HarmfactorWorkSource param) {
        return this.harmfactorWorkMapper.getHarmfactorWorkSourceListByWorkHarmHccId(param);
    }

    public PageInfo<HarmWorkStaffInfoVo> listHarmfactorStaffInfo(JqGridParam gparam, boolean isPage) {
        List harmWorkStaffInfosList;
        HarmWorkStaffInfoQuery query = new HarmWorkStaffInfoQuery();
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                Object values;
                if ("searchKey".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotBlank((CharSequence)sField.getSearchValue())) continue;
                    query.setSearchKey(sField.getSearchValue());
                    continue;
                }
                if ("gender".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotBlank((CharSequence)sField.getSearchValue())) continue;
                    query.setGender(Byte.valueOf(Byte.parseByte(sField.getSearchValue())));
                    continue;
                }
                if ("workId".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotBlank((CharSequence)sField.getSearchValue())) continue;
                    query.setWorkId(Long.valueOf(Long.parseLong(sField.getSearchValue())));
                    continue;
                }
                if ("orgIds".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotBlank((CharSequence)sField.getSearchValue())) continue;
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(Long.parseLong(sField.getSearchValue()));
                    query.setOrgIds(orgIds);
                    continue;
                }
                if (!"swrStatus".equals(sField.getSearchField()) || (values = sField.getSearchValue()) == null || ((String)values).isEmpty()) continue;
                List status = Arrays.stream(((String)values).split(",")).map(Integer::parseInt).collect(Collectors.toList());
                query.setSwrStatus(status);
            }
        }
        DataScopeHelper.startDataScope("company.harmfactor", "hc_check_plan");
        List<HarmfactorWork> harmfactorWorkList = this.getHarmfactorWorkListByCid(gparam.getCid());
        ArrayList<Long> hasHarmfactorWorkIds = new ArrayList<Long>();
        if (CommonUtil.listIsNotEmpty(harmfactorWorkList)) {
            for (HarmfactorWork harmfactorWork : harmfactorWorkList) {
                hasHarmfactorWorkIds.add(harmfactorWork.getWorkId());
            }
        }
        if (CommonUtil.listIsEmpty(hasHarmfactorWorkIds)) {
            return new PageInfo();
        }
        query.setCid(gparam.getCid());
        query.setWorkIds(hasHarmfactorWorkIds);
        ArrayList<Integer> workPropertyList = new ArrayList<Integer>(4);
        workPropertyList.add(1);
        workPropertyList.add(2);
        query.setWorkPropertyList(workPropertyList);
        query.setSwrStatus(null);
        ArrayList<Integer> swrHasNullStatuList = new ArrayList<Integer>(4);
        swrHasNullStatuList.add(1);
        query.setSwrHasNullStatuList(swrHasNullStatuList);
        if (isPage) {
            PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        }
        if (CommonUtil.listIsNotEmpty((List)(harmWorkStaffInfosList = this.staffInfoService.getHarmWorkStaffInfosBySearch(query)))) {
            for (HarmWorkStaffInfoVo harmWorkStaffInfoVo : harmWorkStaffInfosList) {
                String harmNames = this.getHarmNamesByWork(gparam.getCid(), harmWorkStaffInfoVo.getWorkId(), ",");
                harmWorkStaffInfoVo.setHarms(harmNames);
                HealthCheckStaffInfoVo recommedCheckInfo = this.getRecommedCheckInfo(gparam.getCid(), harmWorkStaffInfoVo.getWorkId(), RecommendCheckEnum.onMust.getCode(), RecommendCheckEnum.onChoose.getCode(), ",");
                if (recommedCheckInfo == null) continue;
                harmWorkStaffInfoVo.setMustChecks(recommedCheckInfo.getMustChecks());
                harmWorkStaffInfoVo.setChooseChecks(recommedCheckInfo.getChooseChecks());
            }
            PageInfo page = new PageInfo(harmWorkStaffInfosList);
            return page;
        }
        return new PageInfo();
    }

    public List<HarmfactorWork> getArchiveHarmfactor(Long cid, Date date) {
        List<HarmfactorWork> listData = this.getArchiveHarmfactor(cid, null, false, date);
        ArrayList<HarmfactorWork> resultData = new ArrayList<HarmfactorWork>();
        if (CommonUtil.listIsNotEmpty(listData)) {
            for (HarmfactorWork data : listData) {
                if (data == null || !CommonUtil.listIsNotEmpty((List)data.getHarmfactorWorkSourceList())) continue;
                resultData.add(data);
            }
        }
        return resultData;
    }

    public List<HarmfactorWork> getActualizeArchiveHarmfactor(Long cid, Date date) {
        List<HarmfactorWork> listData = this.getActualizeArchiveHarmfactor(cid, null, false, date);
        ArrayList<HarmfactorWork> resultData = new ArrayList<HarmfactorWork>();
        if (CommonUtil.listIsNotEmpty(listData)) {
            for (HarmfactorWork data : listData) {
                if (data == null || !CommonUtil.listIsNotEmpty((List)data.getHarmfactorWorkSourceList())) continue;
                resultData.add(data);
            }
        }
        return resultData;
    }

    public List<HarmfactorWorkSource> getArchiveHarmfactorByWork(Long cid, Long workId, Date date) {
        List<HarmfactorWork> harmfactorWorks = this.getArchiveHarmfactor(cid, workId, false, date);
        if (CommonUtil.listIsNotEmpty(harmfactorWorks)) {
            return harmfactorWorks.get(0).getHarmfactorWorkSourceList();
        }
        return null;
    }

    public List<HarmfactorWorkSource> getActualizeArchiveHarmfactorByWork(Long cid, Long workId, Date date) {
        List<HarmfactorWork> harmfactorWorks = this.getActualizeArchiveHarmfactor(cid, workId, false, date);
        if (CommonUtil.listIsNotEmpty(harmfactorWorks)) {
            return harmfactorWorks.get(0).getHarmfactorWorkSourceList();
        }
        return null;
    }

    private List<HarmfactorWork> getArchiveHarmfactor(Long cid, Long workId, boolean ignoreHcPlanIdIsNull, Date date) {
        ArrayList<BasicEntityContentSearch> harmfactorWorkSearch = null;
        if (workId != null) {
            harmfactorWorkSearch = new ArrayList<BasicEntityContentSearch>();
            BasicEntityContentSearch workHarmfactorIdSearch = new BasicEntityContentSearch();
            workHarmfactorIdSearch.setKey("workId");
            workHarmfactorIdSearch.setValue((Object)workId);
            harmfactorWorkSearch.add(workHarmfactorIdSearch);
        }
        return null;
    }

    private List<HarmfactorWork> getActualizeArchiveHarmfactor(Long cid, Long workId, boolean ignoreHcPlanIdIsNull, Date date) {
        ArrayList<BasicEntityContentSearch> harmfactorWorkSearch = null;
        if (workId != null) {
            harmfactorWorkSearch = new ArrayList<BasicEntityContentSearch>();
            BasicEntityContentSearch workHarmfactorIdSearch = new BasicEntityContentSearch();
            workHarmfactorIdSearch.setKey("workId");
            workHarmfactorIdSearch.setValue((Object)workId);
            harmfactorWorkSearch.add(workHarmfactorIdSearch);
        }
        return null;
    }

    private List<WorkAreaInfo> getHisDataWorkAreaInfo(Long cid, Date date, Long workId) {
        ArrayList<BasicEntityContentSearch> workHarmfactorSourceSearchList = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch workHarmfactorIdSearch = new BasicEntityContentSearch();
        workHarmfactorIdSearch.setKey("workInfoId");
        workHarmfactorIdSearch.setValue((Object)workId);
        workHarmfactorSourceSearchList.add(workHarmfactorIdSearch);
        return null;
    }

    public int harmfactorHccheckplanunderwayCount(Long cid) {
        HarmfactorItemVO itemVo = new HarmfactorItemVO();
        HarmfactorHccheckplanunderway qParam = new HarmfactorHccheckplanunderway();
        qParam.setCid(cid);
        qParam.setIsFinish(Boolean.valueOf(false));
        DataScopeHelper.startDataScope("company.harmfactor", "hc_check_plan");
        DataScope dataScope = DataScopeHelper.getDataScope();
        List<HarmfactorHccheckplanunderway> hHccheckplanunderwayList = this.harmfactorWorkHccheckplanMapper.listHarmfactorHccheckplanUnderway(qParam);
        if (hHccheckplanunderwayList != null) {
            return hHccheckplanunderwayList.size();
        }
        return 0;
    }

    private Long getHarmfactorWorkId(Long workId, Byte ontactType, Long loginStaffId, Long orgId, Long cid) {
        if (workId == null || cid == null) {
            return null;
        }
        Example harmfactorExample = new Example(HarmfactorWork.class);
        Example.Criteria c = harmfactorExample.createCriteria().andEqualTo("workId", (Object)workId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List harmfactorWorkList = this.getListByExample(harmfactorExample);
        if (harmfactorWorkList != null && harmfactorWorkList.size() > 0) {
            HarmfactorWork harmfactorWork = (HarmfactorWork)harmfactorWorkList.get(0);
            if (harmfactorWork != null && harmfactorWork.getContactType() == null) {
                harmfactorWork.setContactType(ontactType);
                harmfactorWork.setOrgId(orgId);
                this.updateByPrimaryKey(harmfactorWork, loginStaffId);
            }
            return harmfactorWork.getId();
        }
        HarmfactorWork harmfactorWork = new HarmfactorWork();
        harmfactorWork.setCid(cid);
        harmfactorWork.setUpdateBy(loginStaffId);
        harmfactorWork.setUpdateDate(new Date());
        harmfactorWork.setCreateBy(loginStaffId);
        harmfactorWork.setCreateDate(new Date());
        harmfactorWork.setOrgId(orgId);
        harmfactorWork.setWorkId(workId);
        harmfactorWork.setContactType(ontactType);
        harmfactorWork = this.add(harmfactorWork, loginStaffId, cid);
        return harmfactorWork.getId();
    }

    @Transactional(readOnly=false)
    public Map<String, Object> importWorkHarm(String ossfileUrl, Long loginStaffId, Long organizadId, Long cid) throws Exception {
        InputStream ossInputStream = ExcelUtil.getInstance().getOssInputStream(ossfileUrl);
        ExcelReaderBuilder excelReaderBuilder = (ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)ossInputStream).head(WorkHarmNameData.class)).ignoreEmptyRow(Boolean.valueOf(true)).autoCloseStream(Boolean.valueOf(true)).headRowNumber(Integer.valueOf(2))).autoTrim(Boolean.valueOf(true));
        WorkHarmDataListener workHarmDataListener = new WorkHarmDataListener(this.validator);
        ((ExcelReaderSheetBuilder)excelReaderBuilder.sheet().registerReadListener((ReadListener)workHarmDataListener)).doRead();
        List<WorkHarmNameData> workHarmNameDataList = workHarmDataListener.getList();
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        errMap.put("noData", "0");
        if (CollectionUtils.isNotEmpty(workHarmNameDataList)) {
            for (int i = 0; i < workHarmNameDataList.size(); ++i) {
                String[] excelWorkNameArr;
                WorkHarmNameData data2 = workHarmNameDataList.get(i);
                String excelWorkName = data2.getWorkName();
                if (StringUtils.isNotBlank((CharSequence)excelWorkName) && (excelWorkNameArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)excelWorkName, (String)"/")).length > 1) {
                    String workName = excelWorkNameArr[0];
                    String orgName = excelWorkNameArr[1];
                    WorkRoleInfo workRoleInfo = this.workRoleInfoService.getWorkRoleInfoByNameAndOrgName2(workName, orgName, cid);
                    if (workRoleInfo != null) {
                        data2.setWorkId(workRoleInfo.getId());
                    } else {
                        data2.settingErrorInfo("\u627e\u4e0d\u5230\u5c97\u4f4d/\u5de5\u79cd");
                        continue;
                    }
                }
                if ("\u5b9a\u70b9".equals(data2.getContactTypeName())) {
                    data2.setContactType((byte)1);
                } else {
                    data2.setContactType((byte)2);
                }
                if (!StringUtils.isNotBlank((CharSequence)data2.getHarmName())) continue;
                Long harmId = this.occRiskFactorsService.parseHarmName(data2.getHarmName(), cid);
                if (harmId == null) {
                    data2.settingErrorInfo("\u627e\u4e0d\u5230\u8be5\u5371\u5bb3\u56e0\u7d20");
                    continue;
                }
                data2.setHarmId(harmId);
            }
            for (WorkHarmNameData workHarmNameData : workHarmNameDataList) {
                if (!StringUtils.isBlank((CharSequence)workHarmNameData.getErrInfo())) continue;
                Long workId = workHarmNameData.getWorkId();
                try {
                    Map sourceResultMap;
                    Long harmfactorWorkId = this.getHarmfactorWorkId(workId, workHarmNameData.getContactType(), loginStaffId, organizadId, cid);
                    if (harmfactorWorkId == null || !MapUtils.getBoolean((Map)(sourceResultMap = this.harmfactorWorkSourceService.addHarmfactorWorkSource(harmfactorWorkId, workHarmNameData.getHarmId(), workHarmNameData.getHarmSource(), loginStaffId, cid)), (Object)"add").booleanValue()) continue;
                    workHarmNameData.setIsImported(true);
                }
                catch (Exception e) {
                    workHarmNameData.settingErrorInfo(e.getMessage());
                }
            }
            List errDataListResult = workHarmNameDataList.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getErrInfo())).collect(Collectors.toList());
            List dataListResult = workHarmNameDataList.stream().filter(data -> data.getIsImported()).collect(Collectors.toList());
            errMap.put("dataListResult", dataListResult);
            errMap.put("errDataListResult", errDataListResult);
        } else {
            errMap.put("noData", "1");
        }
        return errMap;
    }

    @Transactional(readOnly=false)
    public Map<String, Object> importWorkHarmLite(String ossfileUrl, Long loginStaffId, Long organizadId, Long cid) throws Exception {
        InputStream ossInputStream = ExcelUtil.getInstance().getOssInputStream(ossfileUrl);
        ExcelReaderBuilder excelReaderBuilder = (ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)ossInputStream).head(WorkHarmNameLiteData.class)).ignoreEmptyRow(Boolean.valueOf(true)).autoCloseStream(Boolean.valueOf(true)).headRowNumber(Integer.valueOf(2))).autoTrim(Boolean.valueOf(true));
        WorkHarmDataLiteListener workHarmDataListener = new WorkHarmDataLiteListener(this.validator);
        ((ExcelReaderSheetBuilder)excelReaderBuilder.sheet().registerReadListener((ReadListener)workHarmDataListener)).doRead();
        List<WorkHarmNameLiteData> workHarmNameDataList = workHarmDataListener.getList();
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        errMap.put("noData", "0");
        if (CollectionUtils.isNotEmpty(workHarmNameDataList)) {
            for (int i = 0; i < workHarmNameDataList.size(); ++i) {
                WorkHarmNameLiteData data2 = workHarmNameDataList.get(i);
                if (StringUtils.isNotBlank((CharSequence)data2.getWorkName())) {
                    String workName = data2.getWorkName();
                    String[] workArr = StringUtils.splitByWholeSeparator((String)workName, (String)"/");
                    if (workArr != null && workArr.length == 2) {
                        Long orgId = this.parseOrgName(workArr[1], cid);
                        Long workId = null;
                        if (orgId != null) {
                            List workInfoListWorkNameAndOrgId = this.workRoleInfoService.getWorkInfoListWorkNameAndOrgId(workArr[0], orgId, cid);
                            if (CollectionUtils.isNotEmpty((Collection)workInfoListWorkNameAndOrgId)) {
                                workId = ((WorkRoleInfo)workInfoListWorkNameAndOrgId.get(0)).getId();
                                data2.setWorkId(workId);
                            } else {
                                data2.settingErrorInfo("\u627e\u4e0d\u5230\u5c97\u4f4d/\u5de5\u79cd");
                            }
                        } else {
                            data2.settingErrorInfo("\u627e\u4e0d\u5230\u6240\u5c5e\u90e8\u95e8");
                        }
                    } else {
                        data2.settingErrorInfo("\u5c97\u4f4d/\u5de5\u79cd\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)data2.getHarmName())) continue;
                Long harmId = this.occRiskFactorsService.parseHarmName(data2.getHarmName(), cid);
                if (harmId == null) {
                    data2.settingErrorInfo("\u627e\u4e0d\u5230\u8be5\u5371\u5bb3\u56e0\u7d20");
                    continue;
                }
                data2.setHarmId(harmId);
            }
            for (WorkHarmNameLiteData workHarmNameData : workHarmNameDataList) {
                if (!StringUtils.isBlank((CharSequence)workHarmNameData.getErrInfo())) continue;
                Long workId = workHarmNameData.getWorkId();
                try {
                    Map sourceResultMap;
                    Long harmfactorWorkId = this.getHarmfactorWorkId(workId, (byte)1, loginStaffId, organizadId, cid);
                    if (harmfactorWorkId == null || !MapUtils.getBoolean((Map)(sourceResultMap = this.harmfactorWorkSourceService.addHarmfactorWorkSource(harmfactorWorkId, workHarmNameData.getHarmId(), "", loginStaffId, cid)), (Object)"add").booleanValue()) continue;
                    workHarmNameData.setIsImported(true);
                }
                catch (Exception e) {
                    workHarmNameData.settingErrorInfo(e.getMessage());
                }
            }
            List errDataListResult = workHarmNameDataList.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getErrInfo())).collect(Collectors.toList());
            List dataListResult = workHarmNameDataList.stream().filter(data -> data.getIsImported()).collect(Collectors.toList());
            errMap.put("dataListResult", dataListResult);
            errMap.put("errDataListResult", errDataListResult);
        } else {
            errMap.put("noData", "1");
        }
        return errMap;
    }

    public Long parseOrgName(String orgName, Long cid) {
        if (StringUtils.isBlank((CharSequence)orgName)) {
            return null;
        }
        Object[] orgNameArr = StringUtils.splitByWholeSeparator((String)(orgName = StringUtils.toDBC((String)orgName)), (String)"-");
        if (ArrayUtils.isNotEmpty((Object[])orgNameArr)) {
            int length = orgNameArr.length;
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            for (int i = 0; i < length; ++i) {
                Object corgName = orgNameArr[i];
                CompanyOrganization org = this.companyOrganizationService.getCompanyOrganizationByNameAndTreePath((String)corgName, StringUtils.join(orgIdList, (String)","), cid);
                if (org != null) {
                    orgIdList.add(org.getId());
                    if (i != length - 1) continue;
                    return org.getId();
                }
                return null;
            }
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void deleteHarmHccheckplanRelationById(Long hccheckUnderwayId, Long staffId) {
        if (hccheckUnderwayId == null || staffId == null) {
            return;
        }
        HarmfactorHccheckplanunderway harmfactorHccheckplanunderway = new HarmfactorHccheckplanunderway();
        harmfactorHccheckplanunderway.setId(hccheckUnderwayId);
        harmfactorHccheckplanunderway.setIsValid(Boolean.valueOf(false));
        harmfactorHccheckplanunderway.setUpdateBy(staffId);
        harmfactorHccheckplanunderway.setUpdateDate(new Date());
        HarmfactorHccheckplanunderway harmfactorHccheckplanunderway1 = (HarmfactorHccheckplanunderway)this.harmfactorWorkHccheckplanMapper.selectByPrimaryKey(hccheckUnderwayId);
        if (harmfactorHccheckplanunderway1 != null && harmfactorHccheckplanunderway1.getHccplanId() != null) {
            Example deleteSource = new Example(HarmfactorAreaSource.class);
            deleteSource.createCriteria().andEqualTo("checkPlanId", (Object)harmfactorHccheckplanunderway1.getHccplanId()).andEqualTo("isValid", (Object)true);
            HarmfactorAreaSource updateResult = new HarmfactorAreaSource();
            updateResult.setIsValid(Boolean.valueOf(false));
            updateResult.setUpdateBy(staffId);
            updateResult.setUpdateDate(new Date());
            this.harmfactorAreaSourceMapper.updateByExampleSelective(updateResult, deleteSource);
        }
        this.harmfactorWorkHccheckplanMapper.updateByPrimaryKeySelective(harmfactorHccheckplanunderway);
    }

    @Transactional(readOnly=false)
    public void updateHarmHccheckplanRelation(HarmfactorHccheckplanunderway underway) {
        if (underway == null || underway.getId() == null) {
            return;
        }
        this.harmfactorWorkHccheckplanMapper.updateByPrimaryKeySelective(underway);
    }

    public HealthCheckStaffInfoVo getRecommendChecks(String[] harmIds, String[] specialWorkIds, String mustCheckFlag, String chooseCheckFlag, String splitor) {
        List<String> mustChecks = this.getRecommendList(harmIds, specialWorkIds, mustCheckFlag);
        List<String> chooseChecks = this.getRecommendList(harmIds, specialWorkIds, chooseCheckFlag);
        return this.getRecommendChecks(mustChecks, chooseChecks, splitor);
    }

    private List<String> getRecommendList(String[] harmIds, String[] specialWorkIds, String checkFlag) {
        List<HarmfactorWorkRecommendVo> vos = this.getRecommendVos(harmIds, specialWorkIds, checkFlag);
        return this.getRecommedCheckList(vos);
    }

    public HealthCheckStaffInfoVo getRecommedCheckInfo(Long cid, Long workId, String must, String choose, String splitor) {
        if (cid == null || workId == null) {
            return null;
        }
        List<String> mustChecks = this.getRecommedCheckList(cid, workId, must);
        List<String> chooseChecks = this.getRecommedCheckList(cid, workId, choose);
        return this.getRecommendChecks(mustChecks, chooseChecks, splitor);
    }

    public List<HarmfactorWorkAreaSourceVo> workAreaDetailList(JqGridParam jparam, Long cid, Long hcId, Boolean isFinish, Boolean isAdminModel) {
        PageInfo hcchInfoPage = this.checkResultService.querySelectPointVosGroupByCheckPoint(jparam, hcId, null);
        if (hcchInfoPage != null && CollectionUtils.isNotEmpty((Collection)hcchInfoPage.getList())) {
            ArrayList<HarmfactorWorkAreaSourceVo> result = new ArrayList<HarmfactorWorkAreaSourceVo>();
            List hcchInfoPageList = hcchInfoPage.getList();
            List exportCompanyArea = this.companyAreaService.getExportCompanyArea(cid.longValue());
            Map<Object, Object> companyAreaMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)exportCompanyArea)) {
                companyAreaMap = exportCompanyArea.stream().collect(Collectors.toMap(CompanyArea::getId, m -> m, (oldValue, newValue) -> newValue));
            }
            List dbharmfactorAreaSourceList = this.harmfactorAreaSourceService.listHarmfactorAreaSourceByHcId(hcId, isFinish);
            for (SelectPointVo pointVo : hcchInfoPageList) {
                HarmfactorWorkAreaSourceVo areaSourceVo = new HarmfactorWorkAreaSourceVo();
                areaSourceVo.setReportName(pointVo.getPointName());
                areaSourceVo.setHarmFactorNamesAndIds(pointVo.getHarmFactorNamesAndIds());
                areaSourceVo.setHarmFactorNames(pointVo.getFactorName());
                if (CollectionUtils.isNotEmpty((Collection)dbharmfactorAreaSourceList)) {
                    for (HarmfactorWorkAreaSourceVo harmfactorAreaSource : dbharmfactorAreaSourceList) {
                        Object[] areaIdArr;
                        if (!StringUtils.isNotBlank((CharSequence)harmfactorAreaSource.getReportName()) || !harmfactorAreaSource.getReportName().equals(pointVo.getPointName())) continue;
                        areaSourceVo.setAreaIds(harmfactorAreaSource.getAreaIds());
                        StringBuffer areaNames = new StringBuffer("");
                        ArrayList areaMapList = new ArrayList();
                        String areaIds = harmfactorAreaSource.getAreaIds();
                        if (StringUtils.isNotEmpty((String)areaIds) && ArrayUtils.isNotEmpty((Object[])(areaIdArr = StringUtils.splitByWholeSeparator((String)areaIds, (String)",")))) {
                            for (Object areaIdStr : areaIdArr) {
                                if (!companyAreaMap.containsKey(Long.parseLong((String)areaIdStr))) continue;
                                CompanyArea companyArea = (CompanyArea)companyAreaMap.get(Long.parseLong((String)areaIdStr));
                                HashMap<String, CallSite> areaMap = new HashMap<String, CallSite>();
                                areaNames.append(companyArea.getTreePathName());
                                areaNames.append(",");
                                areaMap.put("id", (CallSite)((Object)("" + companyArea.getId())));
                                areaMap.put("name", (CallSite)((Object)companyArea.getTreePathName()));
                                areaMapList.add(areaMap);
                            }
                        }
                        if (StringUtils.isNotEmpty((String)areaNames.toString())) {
                            areaNames.deleteCharAt(areaNames.length() - 1);
                        }
                        areaSourceVo.setAreaNames(areaNames.toString());
                        areaSourceVo.setChooseAreaInfo(JSON.toJSONString(areaMapList));
                    }
                }
                if (isFinish != null && isFinish.booleanValue()) {
                    if (StringUtils.isNotBlank((CharSequence)areaSourceVo.getAreaIds())) {
                        result.add(areaSourceVo);
                        continue;
                    }
                    if (isAdminModel == null || !isAdminModel.booleanValue()) continue;
                    result.add(areaSourceVo);
                    continue;
                }
                result.add(areaSourceVo);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public String exportImportTemp(Long hcplanId, Long cid) {
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(Integer.MAX_VALUE);
        PageInfo hcchInfo = this.checkResultService.querySelectPointVosGroupByCheckPoint(jqGridParam, hcplanId, null);
        List hccList = hcchInfo.getList();
        List workRoleInfoList = this.workRoleInfoService.getWorkRoleOrgNameByCid(cid);
        File file = File.createTempFile("harmdata", "harmtemp");
        if (CollectionUtils.isNotEmpty((Collection)workRoleInfoList)) {
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)new FileOutputStream(file)).excelType(ExcelTypeEnum.XLS).build();
            ArrayList<WorkHarmNameSourceData> harmNameSourceDataList = new ArrayList<WorkHarmNameSourceData>();
            for (SelectPointVo hcCheckCollectHarmFactorVo : hccList) {
                WorkHarmNameSourceData data = new WorkHarmNameSourceData();
                data.setSource(hcCheckCollectHarmFactorVo.getReportName());
                data.setHarmName(hcCheckCollectHarmFactorVo.getHarmFactorNames());
                harmNameSourceDataList.add(data);
            }
            for (int i = 0; i < workRoleInfoList.size(); ++i) {
                WorkRoleInfo wri = (WorkRoleInfo)workRoleInfoList.get(i);
                ArrayList headList = new ArrayList();
                ArrayList<Object> headTitle0 = new ArrayList<Object>();
                ArrayList<Object> headTitle1 = new ArrayList<Object>();
                ArrayList<Object> headTitle2 = new ArrayList<Object>();
                String title = wri.getOrgName() + "(" + wri.getId() + ")";
                headTitle0.add(title);
                headTitle0.add("\u91c7\u6837\u70b9/\u5bf9\u8c61");
                headTitle1.add(title);
                headTitle1.add("\u5b58\u5728\u7684\u5371\u5bb3\u56e0\u7d20");
                headTitle2.add(title);
                headTitle2.add("\u662f\u5219\u586b\u5199\u201c1\u201d\uff0c\u5426\u5219\u65e0\u9700\u586b\u5199\uff0c\u5bfc\u5165\u65f6\u4f1a\u81ea\u52a8\u5c06\u586b\u5199\u201c1\u201d\u7684\u6570\u636e\u5f55\u5165\u7cfb\u7edf\u4e2d");
                headList.add(headTitle0);
                headList.add(headTitle1);
                headList.add(headTitle2);
                String sheetName = wri.getOrgName();
                sheetName = sheetName.replaceAll("[:\\\\/?*\\[\\]]", "");
                sheetName = sheetName.replaceAll("\\s*", "");
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)i, (String)sheetName).registerWriteHandler((WriteHandler)new CustomCellWriteHandler())).build();
                writeSheet.setHead(headList);
                excelWriter.write(harmNameSourceDataList, writeSheet);
            }
            excelWriter.finish();
            return file.getAbsolutePath();
        }
        return null;
    }

    private HealthCheckStaffInfoVo getRecommendChecks(List<String> mustChecks, List<String> chooseChecks, String splitor) {
        if (StringUtils.isEmpty((CharSequence)splitor)) {
            splitor = "\uff0c";
        }
        HealthCheckStaffInfoVo result = new HealthCheckStaffInfoVo();
        if (mustChecks != null && chooseChecks != null) {
            this.removeRecommendChecks(mustChecks, chooseChecks);
        }
        result.setChooseChecks(StringUtils.join(chooseChecks, (String)splitor));
        result.setMustChecks(StringUtils.join(mustChecks, (String)splitor));
        return result;
    }

    private void removeRecommendChecks(List<String> mustChecks, List<String> chooseChecks) {
        chooseChecks.removeAll(mustChecks);
        if (mustChecks.contains("\u540e\u524d\u4f4dX\u5c04\u7ebf\u9ad8\u4edf\u4f0f\u80f8\u7247\u6216\u6570\u5b57\u5316\u6444\u5f71\u80f8\u7247\uff08DR\u80f8\u7247\uff09")) {
            mustChecks.remove("\u80f8\u90e8X\u5c04\u7ebf\u6444\u7247");
            chooseChecks.remove("\u80f8\u90e8X\u5c04\u7ebf\u6444\u7247");
        }
        if (chooseChecks.contains("\u540e\u524d\u4f4dX\u5c04\u7ebf\u9ad8\u4edf\u4f0f\u80f8\u7247\u6216\u6570\u5b57\u5316\u6444\u5f71\u80f8\u7247\uff08DR\u80f8\u7247\uff09")) {
            chooseChecks.remove("\u80f8\u90e8X\u5c04\u7ebf\u6444\u7247");
        }
    }

    private List<HarmfactorWorkRecommendVo> getRecommendVos(String[] harmIds, String[] specialWorks, String recommendType) {
        List<String> specialWorkList;
        List<HarmfactorWorkRecommendVo> specialWork;
        List<String> harmList;
        List<HarmfactorWorkRecommendVo> harms;
        ArrayList<HarmfactorWorkRecommendVo> results = new ArrayList<HarmfactorWorkRecommendVo>();
        if (harmIds != null && harmIds.length > 0 && (harms = ((HarmfactorWorkMapper)this.dao).getRecommedCheckByHarmsAndSpecialWorks(harmList = Arrays.asList(harmIds), null, recommendType)) != null && !harms.isEmpty()) {
            results.addAll(harms);
        }
        if (specialWorks != null && specialWorks.length > 0 && (specialWork = ((HarmfactorWorkMapper)this.dao).getRecommedCheckByHarmsAndSpecialWorks(null, specialWorkList = Arrays.asList(specialWorks), recommendType)) != null && !specialWork.isEmpty()) {
            results.addAll(specialWork);
        }
        return results;
    }

    public DeclareHarmWorkNewVo collectDeclareHarmWorkNum(Long cid) {
        if (cid == null) {
            return new DeclareHarmWorkNewVo();
        }
        List<Map<String, Object>> mapList = this.harmfactorWorkMapper.collectHarmWorkNum(cid);
        if (CollectionUtils.isNotEmpty(mapList)) {
            DeclareHarmWorkNewVo harmvo = new DeclareHarmWorkNewVo();
            for (Map<String, Object> stringObjectMap : mapList) {
                this.settingHasHarm(harmvo, stringObjectMap);
                this.settingTotal(harmvo, stringObjectMap);
                this.settingStaffNum(harmvo, stringObjectMap);
            }
            return harmvo;
        }
        return new DeclareHarmWorkNewVo();
    }

    private void settingHasHarm(DeclareHarmWorkNewVo harmvo, Map<String, Object> stringObjectMap) {
        if ("\u5316\u5b66\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasChemistry(true);
        }
        if ("\u653e\u5c04\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasRadial(true);
        }
        if ("\u7269\u7406\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasPhysics(true);
        }
        if ("\u751f\u7269\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasBiology(true);
        }
        if ("\u7c89\u5c18".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasDust(true);
        }
        if ("\u5176\u4ed6\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
            harmvo.setHasOther(true);
        }
    }

    private void settingTotal(DeclareHarmWorkNewVo harmvo, Map<String, Object> stringObjectMap) {
        Object[] staffIdArr;
        String staffIds = MapUtils.getString(stringObjectMap, (Object)"staffIds", (String)"");
        if (StringUtils.isNotEmpty((String)staffIds) && ArrayUtils.isNotEmpty((Object[])(staffIdArr = StringUtils.splitByWholeSeparator((String)staffIds, (String)",")))) {
            List collect = Arrays.stream(staffIdArr).filter(m -> NumberUtils.isNumber((String)m)).map(m -> Long.parseLong(m)).distinct().collect(Collectors.toList());
            if ("\u5316\u5b66\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getChemistryTotalSet().addAll(collect);
            }
            if ("\u653e\u5c04\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getRadialTotalSet().addAll(collect);
            }
            if ("\u7269\u7406\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getPhysicsTotalSet().addAll(collect);
            }
            if ("\u751f\u7269\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getBiologyTotalSet().addAll(collect);
            }
            if ("\u7c89\u5c18".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getDustTotalSet().addAll(collect);
            }
            if ("\u5176\u4ed6\u56e0\u7d20".equals(MapUtils.getString(stringObjectMap, (Object)"harmType", (String)""))) {
                harmvo.getOtherTotalSet().addAll(collect);
            }
        }
    }

    private void settingStaffNum(DeclareHarmWorkNewVo harmvo, Map<String, Object> stringObjectMap) {
        Object[] staffIdArr;
        String staffIds = MapUtils.getString(stringObjectMap, (Object)"staffIds", (String)"");
        if (StringUtils.isNotEmpty((String)staffIds) && ArrayUtils.isNotEmpty((Object[])(staffIdArr = StringUtils.splitByWholeSeparator((String)staffIds, (String)",")))) {
            List collect = Arrays.stream(staffIdArr).filter(m -> NumberUtils.isNumber((String)m)).map(m -> Long.parseLong(m)).distinct().collect(Collectors.toList());
            if ("\u82ef".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getBenNumSet().addAll(collect);
            }
            if ("\u94c5".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getPbNumSet().addAll(collect);
            }
            if ("\u566a\u58f0".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getNoiseNumSet().addAll(collect);
            }
            if ("\u7164\u5c18".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getCoalDustNumSet().addAll(collect);
            }
            if ("\u77fd\u5c18".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getSillicaDustNumSet().addAll(collect);
            }
            if ("\u77f3\u68c9\u5c18".equals(MapUtils.getString(stringObjectMap, (Object)"importantType", (String)""))) {
                harmvo.getAsbestosNumSet().addAll(collect);
            }
        }
    }
}

