/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.harmfactor;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorAreaSourceMapper;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkSourceService;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.NoModleDataListener;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorVo;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.util.common.date.DateUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="harmfactorAreaSourceService")
@DubboService
@Transactional(readOnly=true)
public class HarmfactorAreaSourceServiceImpl
extends BaseServiceImpl<HarmfactorAreaSourceMapper, HarmfactorAreaSource>
implements IHarmfactorAreaSourceService {
    @Resource
    private HarmfactorAreaSourceMapper harmfactorAreaSourceMapper;
    @Autowired
    IOccupationalRiskFactorsService occRiskFactorsService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    IHarmfactorWorkSourceService harmfactorWorkSourceService;
    @Autowired
    ICompanyAreaService companyAreaService;
    @Autowired
    IHarmfactorAreaService harmfactorAreaService;
    @Autowired
    ISysCoreWorkModuleCorrelationService coreWorkService;

    @Transactional(readOnly=false)
    public HarmfactorAreaSource saveOrUpdateHarmfactorAreaSource(HarmfactorAreaSource harmfactorAreaSource, Long loginStaffId, Long cid) throws HealthException {
        if (harmfactorAreaSource == null) {
            throw new HealthException("harmfactorAreaSource \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (harmfactorAreaSource.getId() != null) {
            this.update(harmfactorAreaSource, loginStaffId);
            harmfactorAreaSource = (HarmfactorAreaSource)this.getById(harmfactorAreaSource.getId());
        } else {
            if (harmfactorAreaSource.getAreaId() == null || harmfactorAreaSource.getCheckPlanId() == null || harmfactorAreaSource.getHarmId() == null || StringUtils.isBlank((CharSequence)harmfactorAreaSource.getHazardSource())) {
                throw new HealthException("\u7f3a\u5c11\u53c2\u6570");
            }
            Example e = new Example(HarmfactorAreaSource.class);
            e.createCriteria().andEqualTo("areaId", (Object)harmfactorAreaSource.getAreaId()).andEqualTo("checkPlanId", (Object)harmfactorAreaSource.getCheckPlanId()).andEqualTo("harmId", (Object)harmfactorAreaSource.getHarmId()).andEqualTo("hazardSource", (Object)harmfactorAreaSource.getHazardSource()).andEqualTo("isValid", (Object)true);
            int count = this.harmfactorAreaSourceMapper.selectCountByExample(e);
            if (count == 0) {
                this.add(harmfactorAreaSource, loginStaffId, cid);
            }
        }
        return harmfactorAreaSource;
    }

    @Transactional(readOnly=false)
    public void saveAreaHarmRelation(List<HarmfactorWorkAreaSourceVo> aharmSourceHccplanList, boolean isFinish, Long checkPlanId, Boolean isAdminModel, Long cid, Long loginStaffId) throws Exception {
        Example esource = new Example(HarmfactorAreaSource.class);
        Example.Criteria criteriaEsource = esource.createCriteria().andEqualTo("checkPlanId", (Object)checkPlanId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("isHis", (Object)false);
        this.harmfactorAreaSourceMapper.deleteByExample(esource);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkPlanId);
        if (checkPlan == null || checkPlan.getCheckDateBegin() == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u68c0\u6d4b\u62a5\u544a\u6570\u636e\u6216\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
        }
        Date checkDate = DateUtils.getDate((LocalDateTime)checkPlan.getCheckDateBegin());
        List<HarmfactorAreaSource> harmfactorAreaSourceList = this.parseHarmFactorNamesAndIdArr(aharmSourceHccplanList, checkPlanId, checkDate, isFinish);
        if (CollectionUtils.isEmpty(harmfactorAreaSourceList)) {
            return;
        }
        Set<HarmfactorAreaSource> harmfactorAreaSourceSet = null;
        harmfactorAreaSourceSet = isFinish ? this.handlerHarmAreaHistoryData(harmfactorAreaSourceList, checkPlan, cid, loginStaffId) : new HashSet<HarmfactorAreaSource>(harmfactorAreaSourceList);
        if (CollectionUtils.isNotEmpty(harmfactorAreaSourceSet)) {
            if (isFinish) {
                HashMap<Long, Set> areaMap = new HashMap<Long, Set>();
                for (HarmfactorAreaSource harmfactorAreaSource : harmfactorAreaSourceSet) {
                    if (areaMap.containsKey(harmfactorAreaSource.getAreaId())) {
                        ((Set)areaMap.get(harmfactorAreaSource.getAreaId())).add(harmfactorAreaSource);
                        continue;
                    }
                    HashSet<HarmfactorAreaSource> voset = new HashSet<HarmfactorAreaSource>();
                    voset.add(harmfactorAreaSource);
                    areaMap.put(harmfactorAreaSource.getAreaId(), voset);
                }
                areaMap.forEach((areaId, value) -> {
                    try {
                        List harmfactorAreaVos = this.harmfactorAreaService.listHarmfactorArea(cid, areaId, Boolean.valueOf(false));
                        boolean trigger = this.triggerAreaHarmFactorChange((Set<HarmfactorAreaSource>)value, harmfactorAreaVos);
                        if (trigger) {
                            this.coreWorkService.areaHarmFactorChange(areaId, loginStaffId, cid);
                        }
                    }
                    catch (BusinessException e) {
                        this.logger.error(e.getMessage());
                    }
                });
            }
            for (HarmfactorAreaSource harmfactorAreaSource : harmfactorAreaSourceSet) {
                this.saveOrUpdateHarmfactorAreaSource(harmfactorAreaSource, loginStaffId, cid);
            }
        }
    }

    private boolean triggerAreaHarmFactorChange(Set<HarmfactorAreaSource> haList, List<HarmfactorAreaVo> oldhaList) {
        if (oldhaList.size() == 0 && haList.size() == 0) {
            return false;
        }
        if (haList.size() != oldhaList.size()) {
            return true;
        }
        HashSet<Long> hsSet = new HashSet<Long>();
        for (HarmfactorAreaSource harmfactorAreaSource : haList) {
            hsSet.add(harmfactorAreaSource.getHarmId());
        }
        for (HarmfactorArea harmfactorArea : oldhaList) {
            if (hsSet.contains(harmfactorArea.getHarmId())) continue;
            return true;
        }
        return false;
    }

    private List<HarmfactorAreaSource> parseHarmFactorNamesAndIdArr(List<HarmfactorWorkAreaSourceVo> aharmSourceHccplanList, Long hcId, Date checkDate, Boolean isFinish) {
        if (CollectionUtils.isNotEmpty(aharmSourceHccplanList)) {
            ArrayList<HarmfactorAreaSource> resultList = new ArrayList<HarmfactorAreaSource>();
            for (HarmfactorWorkAreaSourceVo areaSourceVo : aharmSourceHccplanList) {
                String reportName = areaSourceVo.getReportName();
                String harmFactorNamesAndIds = areaSourceVo.getHarmFactorNamesAndIds();
                String areaIds = areaSourceVo.getAreaIds();
                if (!StringUtils.isNotBlank((CharSequence)harmFactorNamesAndIds) || !StringUtils.isNotBlank((CharSequence)areaIds)) continue;
                Object[] harmFactorNamesAndIdArr = StringUtils.splitByWholeSeparator((String)harmFactorNamesAndIds, (String)"~&~");
                Object[] areaIdArr = StringUtils.splitByWholeSeparator((String)areaIds, (String)",");
                if (!ArrayUtils.isNotEmpty((Object[])harmFactorNamesAndIdArr) || !ArrayUtils.isNotEmpty((Object[])areaIdArr)) continue;
                for (Object harmFactorNamesAndId : harmFactorNamesAndIdArr) {
                    String[] harmNameId = StringUtils.splitByWholeSeparator((String)harmFactorNamesAndId, (String)":");
                    if (harmNameId.length < 2 || !NumberUtil.isNumber((String)harmNameId[1])) continue;
                    for (Object areaIdstr : areaIdArr) {
                        if (!NumberUtil.isNumber((String)areaIdstr)) continue;
                        Long areaId = Long.parseLong((String)areaIdstr);
                        Long harmId = Long.parseLong(harmNameId[1]);
                        HarmfactorAreaSource hareasource = new HarmfactorAreaSource();
                        hareasource.setAreaId(areaId);
                        hareasource.setHarmId(harmId);
                        hareasource.setCheckPlanId(hcId);
                        hareasource.setHazardSource(reportName);
                        hareasource.setIsFinish(isFinish);
                        hareasource.setCheckDate(checkDate);
                        resultList.add(hareasource);
                    }
                }
            }
            return resultList;
        }
        return null;
    }

    private Set<HarmfactorAreaSource> handlerHarmAreaHistoryData(List<HarmfactorAreaSource> newHasList, CheckPlan checkPlan, Long cid, Long loginStaffId) {
        Example esource = new Example(HarmfactorAreaSource.class);
        Example.Criteria criteriaEsource = esource.createCriteria().andIsNotNull("checkPlanId").andNotEqualTo("checkPlanId", (Object)checkPlan.getId()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("isFinish", (Object)true);
        List dbharmfactorAreaSourceList = this.harmfactorAreaSourceMapper.selectByExample(esource);
        if (CollectionUtils.isNotEmpty((Collection)dbharmfactorAreaSourceList)) {
            HashMap mapData = new HashMap();
            for (HarmfactorAreaSource harmfactorAreaSource : dbharmfactorAreaSourceList) {
                Set<HarmfactorAreaSource> set;
                if (mapData.containsKey(harmfactorAreaSource.getAreaId())) {
                    set = (Set)mapData.get(harmfactorAreaSource.getAreaId());
                    set.add(harmfactorAreaSource);
                    continue;
                }
                set = new HashSet<HarmfactorAreaSource>();
                set.add(harmfactorAreaSource);
                mapData.put(harmfactorAreaSource.getAreaId(), set);
            }
            HashSet<HarmfactorAreaSource> result = new HashSet<HarmfactorAreaSource>();
            for (HarmfactorAreaSource harmfactorAreaSource : newHasList) {
                Long sourceAreaId = harmfactorAreaSource.getAreaId();
                if (mapData.containsKey(sourceAreaId)) {
                    boolean hasData = false;
                    Set dbharmfactorAreaSources = (Set)mapData.get(sourceAreaId);
                    for (HarmfactorAreaSource dbareaSource : dbharmfactorAreaSources) {
                        Long harmId = dbareaSource.getHarmId();
                        String hazardSource = dbareaSource.getHazardSource();
                        Date checkDate = dbareaSource.getCheckDate();
                        if (harmId == null || hazardSource == null || checkDate == null || !harmId.equals(harmfactorAreaSource.getHarmId()) || !hazardSource.equals(harmfactorAreaSource.getHazardSource())) continue;
                        hasData = true;
                        if (DateUtils.getDate((LocalDateTime)checkPlan.getCheckDateBegin()).getTime() > checkDate.getTime()) {
                            dbareaSource.setIsHis(Boolean.valueOf(true));
                            result.add(dbareaSource);
                            result.add(harmfactorAreaSource);
                            continue;
                        }
                        harmfactorAreaSource.setIsHis(Boolean.valueOf(true));
                        result.add(harmfactorAreaSource);
                    }
                    if (hasData) continue;
                    result.add(harmfactorAreaSource);
                    continue;
                }
                result.add(harmfactorAreaSource);
            }
            return result;
        }
        return new HashSet<HarmfactorAreaSource>(newHasList);
    }

    public List<HarmfactorWorkAreaSourceVo> listHarmfactorAreaSourceByHcId(Long hcId, Boolean isFinish) {
        if (hcId == null) {
            return Collections.emptyList();
        }
        return this.harmfactorAreaSourceMapper.listHarmfactorAreaSourceByHcId(hcId, isFinish);
    }

    public Map<String, HarmfactorWorkAreaSourceVo> importAreaHarmRelation(String ossfileUrl, Long loginStaffId, Long orgId, Long cid) throws Exception {
        InputStream ossInputStream = ExcelUtil.getInstance().getOssInputStream(ossfileUrl);
        ExcelReaderBuilder excelReaderBuilder = (ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)ossInputStream).ignoreEmptyRow(Boolean.valueOf(true)).autoCloseStream(Boolean.valueOf(true)).headRowNumber(Integer.valueOf(1))).autoTrim(Boolean.valueOf(true));
        NoModleDataListener workHarmDataListener = new NoModleDataListener();
        ((ExcelReaderSheetBuilder)excelReaderBuilder.sheet().registerReadListener((ReadListener)workHarmDataListener)).doRead();
        List<Map<Integer, String>> dataListenerList = workHarmDataListener.getList();
        HashMap<String, HarmfactorWorkAreaSourceVo> excelData = new HashMap<String, HarmfactorWorkAreaSourceVo>();
        if (CollectionUtils.isNotEmpty(dataListenerList)) {
            int i;
            Map<Integer, String> header = dataListenerList.get(0);
            HashMap<Integer, String> headerIndex = new HashMap<Integer, String>();
            int headerSize = header.size();
            for (i = 1; i < headerSize; ++i) {
                String sourceStr = header.get(i);
                headerIndex.put(i, sourceStr);
                if (excelData.containsKey(sourceStr)) continue;
                HarmfactorWorkAreaSourceVo areaSourceVo = new HarmfactorWorkAreaSourceVo();
                areaSourceVo.setReportName(sourceStr);
                excelData.put(sourceStr, areaSourceVo);
            }
            for (i = 1; i < dataListenerList.size(); ++i) {
                Long aLong;
                Map<Integer, String> rowData = dataListenerList.get(i);
                String areastr = rowData.get(0);
                if (StringUtils.isNotBlank((CharSequence)areastr)) {
                    areastr = StringUtils.toDBC((String)areastr);
                }
                if ((aLong = this.companyAreaService.parseAreaName(areastr, ">", cid)) == null) continue;
                for (int j = 1; j < headerSize; ++j) {
                    String cellStr;
                    if (!rowData.containsKey(j) || !StringUtils.isNotBlank((CharSequence)(cellStr = rowData.get(j))) || !"1.0".equals(cellStr)) continue;
                    HarmfactorWorkAreaSourceVo areaSourceVo = (HarmfactorWorkAreaSourceVo)excelData.get(headerIndex.get(j));
                    areaSourceVo.addAreaIdNameMap("" + aLong, areastr);
                }
            }
            excelData.forEach((k, v) -> v.setChooseAreaInfo(JSON.toJSONString((Object)v.getAreaIdNameMapSet())));
            return excelData;
        }
        return null;
    }

    public List<AreaHarmFactorVo> getHarmFactorAndCheckId(List<Long> areaIds, Long cid) {
        if (areaIds == null || areaIds.isEmpty()) {
            return new ArrayList<AreaHarmFactorVo>();
        }
        return this.harmfactorAreaSourceMapper.getHarmFactorAndCheckId(areaIds, cid);
    }

    public List<HarmfactorAreaSource> getHarmSourceByHcId(Long hcId, Long harmId) {
        if (hcId == null || harmId == null) {
            return null;
        }
        return this.harmfactorAreaSourceMapper.getHarmSourceByHcId(hcId, harmId);
    }

    public List<HarmfactorAreaSource> getByHarmFactorIds(List<Long> harmFactorIds) {
        if (harmFactorIds == null || harmFactorIds.isEmpty()) {
            return new ArrayList<HarmfactorAreaSource>();
        }
        Example example = new Example(HarmfactorAreaSource.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        criteria.andIn("harmId", harmFactorIds);
        return this.harmfactorAreaSourceMapper.selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void delHarmfactorAreaSourceByCheckPlanId(Long checkPlanId, Long loginStaffId) {
        if (checkPlanId == null) {
            return;
        }
        Example example = new Example(HarmfactorAreaSource.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkPlanId", (Object)checkPlanId);
        HarmfactorAreaSource result = new HarmfactorAreaSource();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateDate(new Date());
        result.setUpdateBy(loginStaffId);
        this.harmfactorAreaSourceMapper.updateByExampleSelective(result, example);
    }

    public List<HarmfactorAreaSource> getActualizeArchiveHarmfactorAreaSource(Long cid, Long areaId, Date date) {
        ArrayList<BasicEntityContentSearch> areaHarmfactorSourceSearchList = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch workHarmfactorIdSearch = new BasicEntityContentSearch();
        workHarmfactorIdSearch.setKey("areaId");
        workHarmfactorIdSearch.setValue((Object)areaId);
        areaHarmfactorSourceSearchList.add(workHarmfactorIdSearch);
        HashedMap harmMap = new HashedMap();
        return null;
    }
}

