/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.harmfactor;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.health.dao.base.occriskfactor.OccupationalRiskFactorsMapper;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorAreaMapper;
import cn.smarthse.modules.health.dao.work.harmfactor.HarmfactorAreaSourceMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaSourceHisVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaVo;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.AreaHarmDataListener;
import cn.smarthse.modules.health.service.work.impl.harmfactor.excel.AreaHarmNameData;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorCheckVo;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.validation.Validator;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HarmfactorAreaServiceImpl
extends BaseServiceImpl<HarmfactorAreaMapper, HarmfactorArea>
implements IHarmfactorAreaService {
    @Autowired
    HarmfactorAreaMapper harmfactorAreaMapper;
    @Autowired
    OccupationalRiskFactorsMapper occRiskFactorsMapper;
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    private ICompanyAreaService companyAreaService;
    @Autowired
    IOccupationalRiskFactorsService occRiskFactorsService;
    @Autowired
    private Validator validator;
    @Autowired
    HarmfactorAreaSourceMapper harmfactorAreaSourceMapper;
    @Autowired
    IHarmfactorAreaSourceService harmfactorAreaSourceService;
    @Autowired
    IHcCheckPlanService hcCheckPlanService;
    @DubboReference
    ICheckPlanService checkPlanService;

    @Transactional
    public HarmfactorArea saveOrUpdateHarmfactorArea(HarmfactorArea harmfactorArea, Long loginStaffId, Long cid) throws Exception {
        if (harmfactorArea == null) {
            throw new Exception("harmfactorArea \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HarmfactorArea oldEntity = null;
        if (harmfactorArea.getId() != null) {
            this.update(harmfactorArea, loginStaffId);
            oldEntity = (HarmfactorArea)this.getById(harmfactorArea.getId());
        } else {
            Example e = new Example(HarmfactorArea.class);
            e.createCriteria().andEqualTo("harmId", (Object)harmfactorArea.getHarmId()).andEqualTo("areaId", (Object)harmfactorArea.getAreaId()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            int count = this.getCountByExample(e);
            if (count > 0) {
                OccupationalRiskFactors occrf = (OccupationalRiskFactors)this.occRiskFactorsMapper.selectByPrimaryKey(harmfactorArea.getHarmId());
                throw new BusinessException("\u9009\u5b9a\u5de5\u4f5c\u573a\u6240\u4e2d\u5371\u5bb3\u56e0\u7d20(" + occrf.getNameCh() + ")\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            this.add(harmfactorArea, loginStaffId, cid);
        }
        return harmfactorArea;
    }

    public PageInfo<HarmfactorAreaVo> pageHarmfactorArea(JqGridParam gparam, Long areaId) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        String searchKw = "";
        List postDatas = gparam.getPostDatas();
        if (postDatas != null && postDatas.size() > 0) {
            for (ParamSeachFieldVO sf : postDatas) {
                if (!"searchKw".equals(sf.getSearchField())) continue;
                searchKw = sf.getSearchValue();
                break;
            }
        }
        if (areaId == null) {
            PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        }
        DataScopeHelper.startDataScope("company.harmfactor", "harmfactor_area");
        List<HarmfactorAreaVo> harmfactorAreaList = this.harmfactorAreaMapper.getHarmfactorAreaList(gparam.getCid(), areaId, searchKw, null);
        this.parseCheckPlanInfo(harmfactorAreaList);
        PageInfo page = new PageInfo(harmfactorAreaList);
        return page;
    }

    public void parseCheckPlanInfo(List<HarmfactorAreaVo> harmfactorAreaList) {
        if (CollectionUtils.isNotEmpty(harmfactorAreaList)) {
            HashSet<Long> checkIdSet = new HashSet<Long>();
            for (HarmfactorAreaVo harmfactorAreaVo : harmfactorAreaList) {
                Object[] checkPlanIdArr1;
                checkIdSet.clear();
                if (StringUtils.isNotBlank((CharSequence)harmfactorAreaVo.getCheckplanids()) && ArrayUtils.isNotEmpty((Object[])(checkPlanIdArr1 = StringUtils.splitByWholeSeparator((String)harmfactorAreaVo.getCheckplanids(), (String)"#")))) {
                    for (Object planids : checkPlanIdArr1) {
                        Object[] checkPlanIdArr2 = StringUtils.splitByWholeSeparator((String)planids, (String)",");
                        if (!ArrayUtils.isNotEmpty((Object[])checkPlanIdArr2)) continue;
                        for (Object checkId : checkPlanIdArr2) {
                            checkIdSet.add(Long.parseLong((String)checkId));
                        }
                    }
                }
                StringBuffer sb = new StringBuffer();
                List checkPlans = this.checkPlanService.getByIds(checkIdSet);
                if (!CollectionUtils.isNotEmpty((Collection)checkPlans)) continue;
                for (CheckPlan checkPlan : checkPlans) {
                    if (sb.length() > 0) {
                        sb.append("$###");
                    }
                    sb.append(checkPlan.getCheckWorkName() + "(" + DateUtil.formatDate((LocalDateTime)checkPlan.getCheckDateBegin(), (String)"yyyy-MM-dd") + ")$~~~" + checkPlan.getId());
                }
                harmfactorAreaVo.setHarmSource(sb.toString());
            }
        }
    }

    public List<HarmfactorAreaVo> listHarmfactorArea(Long cid, Long areaId, Boolean filterHcIdIsNULL) throws BusinessException {
        if (cid == null || areaId == null) {
            throw new BusinessException("\u53c2\u6570\u4f20\u5165\u5f02\u5e38\uff01");
        }
        return this.harmfactorAreaMapper.getHarmfactorAreaList(cid, areaId, null, filterHcIdIsNULL);
    }

    @Transactional(readOnly=false)
    public void delHarmfactorArea(Long areaId, Long loginStaffId, Long cid) throws Exception {
        if (areaId == null) {
            return;
        }
        Example e = new Example(HarmfactorArea.class);
        e.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        HarmfactorArea result = new HarmfactorArea();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateBy(loginStaffId);
        result.setUpdateDate(new Date());
        this.harmfactorAreaMapper.updateByExampleSelective(result, e);
        Example areaSourceE = new Example(HarmfactorAreaSource.class);
        areaSourceE.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("isValid", (Object)true).andEqualTo("isFinish", (Object)true);
        HarmfactorAreaSource sourceResult = new HarmfactorAreaSource();
        sourceResult.setIsValid(Boolean.valueOf(false));
        sourceResult.setUpdateBy(loginStaffId);
        sourceResult.setUpdateDate(new Date());
        this.harmfactorAreaSourceMapper.updateByExampleSelective(sourceResult, areaSourceE);
    }

    @Transactional
    public void changeHarmfactorArea(List<HarmfactorArea> haList, Long areaId, Long oldAreaId, Long loginStaffId, Long cid) throws Exception {
        List<HarmfactorAreaVo> oldHaList;
        if (areaId == null) {
            throw new HealthException("\u5de5\u4f5c\u573a\u6240ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!areaId.equals(oldAreaId)) {
            Example hase = new Example(HarmfactorArea.class);
            hase.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            int oldAreaTotal = this.harmfactorAreaMapper.selectCountByExample(hase);
            if (oldAreaTotal > 0) {
                throw new HealthException("\u5df2\u7ecf\u5b58\u5728\u8be5\u5de5\u4f5c\u573a\u6240");
            }
        }
        if (this.triggerAreaHarmFactorChange(haList, oldHaList = this.listHarmfactorArea(cid, areaId, null))) {
            // empty if block
        }
        for (HarmfactorArea ha : haList) {
            ha.setAreaId(areaId);
            if (ha.getId() != null) {
                this.update(ha, loginStaffId);
            } else {
                Example edb = new Example(HarmfactorArea.class);
                edb.createCriteria().andEqualTo("harmId", (Object)ha.getHarmId()).andEqualTo("areaId", (Object)ha.getAreaId()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
                List harmfactorAreaList = this.getListByExample(edb);
                if (CollectionUtils.isNotEmpty(harmfactorAreaList)) {
                    HarmfactorArea harmfactorArea = (HarmfactorArea)harmfactorAreaList.get(0);
                    harmfactorArea.setCheckCycle(ha.getCheckCycle());
                    harmfactorArea.setRemark(ha.getRemark());
                    this.update(harmfactorArea, loginStaffId);
                    ha = harmfactorArea;
                } else {
                    this.add(ha, loginStaffId, cid);
                }
            }
            this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorManageArea, CoreWorkEnum.companyArea, ha.getId(), loginStaffId, cid, new Long[]{areaId});
        }
    }

    public boolean triggerAreaHarmFactorChange(List<HarmfactorArea> haList, List<HarmfactorAreaVo> oldhaList) {
        if (oldhaList.size() == 0 && haList.size() == 0) {
            return false;
        }
        if (haList.size() != oldhaList.size()) {
            return true;
        }
        HashSet<Long> hsSet = new HashSet<Long>();
        for (HarmfactorArea harmfactorArea : haList) {
            hsSet.add(harmfactorArea.getHarmId());
        }
        for (HarmfactorArea harmfactorArea : oldhaList) {
            if (hsSet.contains(harmfactorArea.getHarmId())) continue;
            return true;
        }
        return false;
    }

    public List<HarmfactorArea> getcheckCycleList(Long cid, Long harmId) {
        Example e = new Example(HarmfactorArea.class);
        e.createCriteria().andEqualTo("harmId", (Object)harmId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        return this.harmfactorAreaMapper.selectByExample(e);
    }

    public List<HarmfactorArea> getArchiveHarmfactorAreaList(Long cid, Long harmId, Date date) {
        BasicEntityContentSearch harmIdBcs = new BasicEntityContentSearch();
        harmIdBcs.setKey("harmId");
        harmIdBcs.setValue((Object)harmId);
        ArrayList<BasicEntityContentSearch> harmfactorAreaSearch = new ArrayList<BasicEntityContentSearch>();
        harmfactorAreaSearch.add(harmIdBcs);
        return null;
    }

    @Transactional
    public void saveCloneHarmfactorArea(Long clonedAreaId, Long newAreaId, Long orgId, Long loginStaffId, Long cid) throws Exception {
        Example e = new Example(HarmfactorArea.class);
        e.createCriteria().andEqualTo("areaId", (Object)clonedAreaId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List haList = this.harmfactorAreaMapper.selectByExample(e);
        if (haList != null && !haList.isEmpty()) {
            for (HarmfactorArea harmfactorArea : haList) {
                harmfactorArea.setId(null);
                harmfactorArea.setOrgId(orgId);
                harmfactorArea.setIsValid(Boolean.valueOf(true));
                harmfactorArea.setCreateBy(loginStaffId);
                harmfactorArea.setUpdateBy(loginStaffId);
                harmfactorArea.setUpdateDate(new Date());
                harmfactorArea.setCreateDate(new Date());
                harmfactorArea.setAreaId(newAreaId);
                this.saveOrUpdateHarmfactorArea(harmfactorArea, loginStaffId, cid);
            }
        }
        Example sourcee = new Example(HarmfactorAreaSource.class);
        sourcee.createCriteria().andEqualTo("areaId", (Object)clonedAreaId).andEqualTo("isValid", (Object)true).andEqualTo("isHis", (Object)false).andEqualTo("isFinish", (Object)true);
        List sourceList = this.harmfactorAreaSourceMapper.selectByExample(sourcee);
        if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
            for (HarmfactorAreaSource harmfactorAreaSource : sourceList) {
                harmfactorAreaSource.setId(null);
                harmfactorAreaSource.setUpdateDate(new Date());
                harmfactorAreaSource.setUpdateBy(loginStaffId);
                harmfactorAreaSource.setCreateBy(loginStaffId);
                harmfactorAreaSource.setCreateDate(new Date());
                harmfactorAreaSource.setAreaId(newAreaId);
                this.harmfactorAreaSourceService.saveOrUpdateHarmfactorAreaSource(harmfactorAreaSource, loginStaffId, cid);
            }
        }
    }

    public List<HarmfactorArea> listHarmFactorArea(Long cid, List<Long> areaIds) {
        if (areaIds == null || areaIds.isEmpty()) {
            return new ArrayList<HarmfactorArea>();
        }
        Example e = new Example(HarmfactorArea.class);
        e.createCriteria().andIn("areaId", areaIds).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List haList = this.harmfactorAreaMapper.selectByExample(e);
        return haList;
    }

    public List<AreaHarmFactorCheckVo> listHarmFactorArea2(Long cid, List<Long> areaIds, String harmTypes) {
        if (areaIds == null || areaIds.isEmpty()) {
            return new ArrayList<AreaHarmFactorCheckVo>();
        }
        ArrayList<String> typeList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)harmTypes)) {
            typeList = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
        }
        return this.harmfactorAreaMapper.listHarmFactorArea2(cid, areaIds, typeList);
    }

    public PageInfo<AreaHarmFactorCheckVo> listHarmFactorArea2Page(Long cid, List<Long> areaIds, int pageNum, int pageSize) {
        if (areaIds == null || areaIds.isEmpty()) {
            return new PageInfo(new ArrayList());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<AreaHarmFactorCheckVo> list = this.harmfactorAreaMapper.listHarmFactorArea2(cid, areaIds, null);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Map<String, Object> importAreaHarm(String ossfileUrl, Long loginStaffId, Long orgId, Long cid) throws Exception {
        InputStream ossInputStream = ExcelUtil.getInstance().getOssInputStream(ossfileUrl);
        ExcelReaderBuilder excelReaderBuilder = (ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)ossInputStream).head(AreaHarmNameData.class)).ignoreEmptyRow(Boolean.valueOf(true)).autoCloseStream(Boolean.valueOf(true)).headRowNumber(Integer.valueOf(2))).autoTrim(Boolean.valueOf(true));
        AreaHarmDataListener areaHarmDataListener = new AreaHarmDataListener(this.validator);
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        errMap.put("noData", "0");
        try {
            ((ExcelReaderSheetBuilder)excelReaderBuilder.sheet().registerReadListener((ReadListener)areaHarmDataListener)).doRead();
        }
        catch (Exception e) {
            errMap.put("errorInfo", "\u5bfc\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u5bfc\u5165");
            return errMap;
        }
        List<AreaHarmNameData> areaHarmNameDataList = areaHarmDataListener.getList();
        if (CollectionUtils.isNotEmpty(areaHarmNameDataList)) {
            for (int i = 0; i < areaHarmNameDataList.size(); ++i) {
                AreaHarmNameData data2 = areaHarmNameDataList.get(i);
                if (StringUtils.isNotBlank((CharSequence)data2.getAreaName())) {
                    Long areaId2 = this.companyAreaService.parseAreaName(data2.getAreaName(), "-", cid);
                    if (areaId2 != null) {
                        data2.setAreaId(areaId2);
                    } else {
                        data2.settingErrorInfo("\u627e\u4e0d\u5230\u5de5\u4f5c\u573a\u6240");
                        continue;
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)data2.getHarmName())) continue;
                Long harmId = this.occRiskFactorsService.parseHarmName(data2.getHarmName(), cid);
                if (harmId == null) {
                    data2.settingErrorInfo("\u627e\u4e0d\u5230\u8be5\u5371\u5bb3\u56e0\u7d20");
                    continue;
                }
                data2.setHarmId(harmId);
            }
            HashMap areaHarmListMap = new HashMap();
            for (AreaHarmNameData areaHarmNameData : areaHarmNameDataList) {
                if (!StringUtils.isBlank((CharSequence)areaHarmNameData.getErrInfo())) continue;
                Long areaId3 = areaHarmNameData.getAreaId();
                Example e = new Example(HarmfactorArea.class);
                e.createCriteria().andEqualTo("harmId", (Object)areaHarmNameData.getHarmId()).andEqualTo("areaId", (Object)areaId3).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
                int count = this.getCountByExample(e);
                if (count == 0) {
                    areaHarmNameData.setIsImported(true);
                    HarmfactorArea ha = new HarmfactorArea();
                    ha.setAreaId(areaId3);
                    ha.setHarmId(areaHarmNameData.getHarmId());
                    ha.setCheckCycle(areaHarmNameData.getCheckCycle());
                    if (areaHarmListMap.containsKey(areaId3)) {
                        List harmfactorAreas = (List)areaHarmListMap.get(areaId3);
                        harmfactorAreas.add(ha);
                        continue;
                    }
                    ArrayList<HarmfactorArea> haList = new ArrayList<HarmfactorArea>();
                    haList.add(ha);
                    areaHarmListMap.put(areaId3, haList);
                    continue;
                }
                areaHarmNameData.settingErrorInfo("\u5df2\u5b58\u5728\u8be5\u533a\u57df\u5371\u5bb3\u56e0\u7d20");
            }
            areaHarmListMap.keySet().stream().forEach(areaId -> {
                List harmfactorAreaList = (List)areaHarmListMap.get(areaId);
                try {
                    this.changeHarmfactorArea(harmfactorAreaList, (Long)areaId, (Long)areaId, loginStaffId, cid);
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u5165\u9519\u8bef\uff1a" + e.getMessage());
                }
            });
            List errDataListResult = areaHarmNameDataList.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getErrInfo())).collect(Collectors.toList());
            List dataListResult = areaHarmNameDataList.stream().filter(data -> data.getIsImported()).collect(Collectors.toList());
            errMap.put("dataListResult", dataListResult);
            errMap.put("errDataListResult", errDataListResult);
        } else {
            errMap.put("noData", "1");
        }
        return errMap;
    }

    public List<HarmfactorAreaVo> listDistinctFactorAreas(Long cid, String keyword, String harmTypes) {
        if (cid == null) {
            return Collections.emptyList();
        }
        List companyAreaList = this.companyAreaService.getListByCid(cid);
        if (CollectionUtils.isNotEmpty((Collection)companyAreaList)) {
            List<HarmfactorAreaVo> harmfactorAreaVoList;
            Map<Long, CompanyArea> treePathNameMap = companyAreaList.parallelStream().collect(Collectors.toMap(CompanyArea::getId, v -> v, (k1, k2) -> k2));
            List<String> harmTypesList = null;
            if (StringUtils.isNotBlank((CharSequence)harmTypes)) {
                harmTypesList = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
            }
            if (CollectionUtils.isNotEmpty(harmfactorAreaVoList = this.harmfactorAreaMapper.listDistinctFactorAreas(cid, keyword, harmTypesList))) {
                for (HarmfactorAreaVo harmfactorAreaVo : harmfactorAreaVoList) {
                    if (!treePathNameMap.containsKey(harmfactorAreaVo.getAreaId())) continue;
                    harmfactorAreaVo.setAreaName(treePathNameMap.get(harmfactorAreaVo.getAreaId()).getTreePathName() + treePathNameMap.get(harmfactorAreaVo.getAreaId()).getAreaName());
                }
            }
            return harmfactorAreaVoList;
        }
        return Collections.emptyList();
    }

    public PageInfo<HarmfactorAreaSourceHisVo> pageAreaHisData(JqGridParam jparam, Long cid, Long areaId) {
        if (areaId == null) {
            return null;
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<HarmfactorAreaSourceHisVo> harmfactorAreaSourceHisVos = this.harmfactorAreaMapper.listAreaHisData(cid, areaId);
        PageInfo page = new PageInfo(harmfactorAreaSourceHisVos);
        return page;
    }
}

