/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.harmFactorDeclare;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.harmFactorDeclare.HarmFactorDeclareMapper;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclare;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclareVO;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.harmFactorDeclare.IHarmFactorDeclareService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.HarmFactorDeclareSummaryVo;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.CompanyDecBaseInfoVo;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.HarmFactorDecWorkItemVo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HarmFactorDeclareServiceImpl
extends BaseServiceImpl<HarmFactorDeclareMapper, HarmFactorDeclare>
implements IHarmFactorDeclareService {
    @Autowired
    HarmFactorDeclareMapper harmFactorDeclareMapper;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    ICertificateStaffDetailService certificateStaffDetailService;
    @Autowired
    private IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IStaffInfoService staffInfoService;

    public PageInfo<HarmFactorDeclare> getHarmFactorDeclareList(JqGridParam param, HarmFactorDeclareVO info) {
        if (param == null) {
            return new PageInfo();
        }
        if (info.getCid() == null || info.getCid() == 0L) {
            return new PageInfo();
        }
        info.setIsValid(Boolean.valueOf(true));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("harmFactorDeclare", "company_harm_factor_declare");
        List<HarmFactorDeclare> list = this.harmFactorDeclareMapper.getListDetail(info);
        return new PageInfo(list);
    }

    public Integer numOfUnFinished(Long cid) {
        int num = 0;
        if (cid == null) {
            return num;
        }
        HarmFactorDeclareVO info = new HarmFactorDeclareVO();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        info.setStatus(Byte.valueOf((byte)1));
        List<HarmFactorDeclare> list = this.harmFactorDeclareMapper.getListDetail(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    public Integer numByCid(Long cid) {
        int num = 0;
        if (cid == null) {
            return num;
        }
        HarmFactorDeclareVO info = new HarmFactorDeclareVO();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        List<HarmFactorDeclare> list = this.harmFactorDeclareMapper.getListDetail(info);
        if (list != null) {
            num = list.size();
        }
        return num;
    }

    @Transactional
    public HarmFactorDecWorkItemVo getDeclareTodoIndo(Long cid) {
        Integer tipNum = 0;
        HarmFactorDecWorkItemVo vo = new HarmFactorDecWorkItemVo();
        DataScopeHelper.startDataScope("harmFactorDeclare", "company_harm_factor_declare");
        DataScope dataScope = DataScopeHelper.getDataScope();
        int numBycid = this.numByCid(cid);
        if (numBycid == 0) {
            vo.setIsAdd(Boolean.valueOf(true));
        }
        vo.setIsDeclareRefrenceData(Boolean.valueOf(true));
        DataScopeHelper.setDataScope(dataScope);
        int numOfUnfinish = this.numOfUnFinished(cid);
        vo.setUnFinishedNum(Integer.valueOf(numOfUnfinish));
        List list = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.harmfactorDeclare, cid);
        if (list != null && list.size() > 0) {
            tipNum = tipNum + list.size();
        }
        vo.setThirdTimeList(list);
        vo.setTipNum(tipNum);
        return vo;
    }

    @Transactional(readOnly=false)
    public HarmFactorDeclare addWithCoreWork(HarmFactorDeclare data, Long staffid, Long cid) {
        if ((data = this.add(data, staffid, cid)).getFromType() != null && data.getFromType() == CoreWorkEnum.threeSimultaneityManagement.getValue()) {
            this.sysCoreWorkModuleCorrelationService.businessStart(CoreWorkEnum.harmfactorDeclare, CoreWorkEnum.threeSimultaneityManagement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            if (data.getStatus() == 2) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorDeclare, CoreWorkEnum.threeSimultaneityManagement, data.getId(), staffid, cid, new Long[]{data.getFromId()});
            }
        }
        return data;
    }

    @Transactional(readOnly=false)
    public HarmFactorDeclare updateWithCoreWork(HarmFactorDeclare info, Long staffid) {
        if (info.getFromType() != null) {
            if (info.getStatus() == 2) {
                this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.harmfactorDeclare, CoreWorkEnum.threeSimultaneityManagement, info.getId(), staffid, info.getCid(), new Long[]{info.getFromId()});
            }
            if (info.getIsValid() != null && !info.getIsValid().booleanValue()) {
                this.sysCoreWorkModuleCorrelationService.businessDelete(CoreWorkEnum.harmfactorDeclare, info.getId(), staffid, info.getCid());
            }
        }
        this.update(info, staffid);
        return info;
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        HarmFactorDeclareSummaryVo vo = new HarmFactorDeclareSummaryVo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("isFinished", 1);
        List<HarmFactorDeclare> unFinishedlist = this.harmFactorDeclareMapper.getListByYear(params);
        if (unFinishedlist != null) {
            vo.setUnFinishedNum(Integer.valueOf(unFinishedlist.size()));
        }
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        params1.put("year", year);
        params1.put("cid", cid);
        params1.put("isFinished", 2);
        List<HarmFactorDeclare> finishedlist = this.harmFactorDeclareMapper.getListByYear(params1);
        if (finishedlist != null) {
            vo.setFinishedNum(Integer.valueOf(finishedlist.size()));
        }
        return vo;
    }

    public List<HarmFactorDeclare> getHarmFactorDeclareByYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("isFinished", 2);
        List<HarmFactorDeclare> finishedlist = this.harmFactorDeclareMapper.getListByYear(params);
        return finishedlist;
    }

    public List<HarmFactorDeclare> getListByInfo(HarmFactorDeclareVO info) {
        if (info == null) {
            return null;
        }
        DataScopeHelper.startDataScope("harmFactorDeclare", "company_harm_factor_declare");
        List<HarmFactorDeclare> list = this.harmFactorDeclareMapper.getListDetail(info);
        if (list != null && list.size() > 0) {
            int serialNum = 1;
            for (HarmFactorDeclare harmde : list) {
                harmde.setSerialNum(Integer.valueOf(serialNum));
                ++serialNum;
            }
        }
        return list;
    }

    public HarmFactorDeclareInform getHarmFactorDeclareInform(Long cid) {
        HarmFactorDeclareInform inform = new HarmFactorDeclareInform();
        HarmFactorDeclareVO info = new HarmFactorDeclareVO();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        Byte filished = 2;
        info.setStatus(filished);
        List<HarmFactorDeclare> list = this.harmFactorDeclareMapper.getListDetail(info);
        if (list != null && list.size() > 0) {
            inform.setCount(list.size());
            HarmFactorDeclare de = list.get(0);
            inform.setLastDeclareDate(de.getDeclareDate());
            inform.setLastDeclareId(de.getId());
        }
        return inform;
    }

    public CompanyDecBaseInfoVo getCompanyDecBaseInfo(Long cid) {
        CompanyDecBaseInfoVo vo = new CompanyDecBaseInfoVo();
        vo.setTotalStaffNum(this.staffInfoService.getStaffCountByCid(cid, null));
        vo.setThirdStaffNum(this.staffInfoService.getStaffCountByCid(cid, Boolean.valueOf(true)));
        PhcYearCheckInfo info = new PhcYearCheckInfo();
        info.setCid(cid);
        Integer diseasesNum = this.phcOccupationalDiseaserService.countYearDiseasers(info);
        Integer occupationalStaffNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid.longValue());
        vo.setOccupationalStaffNum(occupationalStaffNum);
        vo.setDiseasesNum(diseasesNum);
        Integer year = Calendar.getInstance().get(1);
        vo.setMainManagTrain(this.certificateStaffDetailService.haveManagerCertificate(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.MAIN.getCode()));
        vo.setHseManagTrain(this.certificateStaffDetailService.haveManagerCertificate(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.OccHeaMan.getCode()));
        return vo;
    }
}

