/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.eme.EmeRescueTeamMapper;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueTeam;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueTeamService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeRescueTeamServiceImpl
extends BaseServiceImpl<EmeRescueTeamMapper, EmeRescueTeam>
implements IEmeRescueTeamService {
    @Autowired
    EmeRescueTeamMapper emeRescueTeamMapper;

    public List<EmeRescueTeam> getEmeRescueTeamListByAsc(Long cid) {
        if (cid == null) {
            return new ArrayList<EmeRescueTeam>();
        }
        Example example = new Example(EmeRescueTeam.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<EmeRescueTeam> list = this.getListByExample(example);
        return list;
    }

    public List<EmeRescueTeam> getEmeRescueTeamListByDesc(Long cid) {
        if (cid == null) {
            return new ArrayList<EmeRescueTeam>();
        }
        Example example = new Example(EmeRescueTeam.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id desc");
        List<EmeRescueTeam> list = this.getListByExample(example);
        return list;
    }

    public boolean getExistsByAsc(Long cid) {
        if (cid == null) {
            return true;
        }
        boolean IsEmeRescueTeam = this.emeRescueTeamMapper.selectExists(cid);
        return IsEmeRescueTeam;
    }

    public List<EmeRescueTeam> getMobileList(Long cid, String keyword) {
        if (cid == null) {
            return new ArrayList<EmeRescueTeam>();
        }
        Example example = new Example(EmeRescueTeam.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            c.andLike("teamName", keyword);
        }
        example.setOrderByClause("id asc");
        List<EmeRescueTeam> list = this.getListByExample(example);
        return list;
    }
}

