/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.eme.EmeRescueTeamRersonMapper;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueTeamRerson;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueTeamRersonService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeRescueTeamRersonServiceImpl
extends BaseServiceImpl<EmeRescueTeamRersonMapper, EmeRescueTeamRerson>
implements IEmeRescueTeamRersonService {
    @Autowired
    EmeRescueTeamRersonMapper emeRescueTeamRersonMapper;
    @Autowired
    IStaffInfoService staffInfoServiceImpl;

    public PageInfo<EmeRescueTeamRerson> getEmeRescueTeamRersonListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getKeyId() == null) {
            return new PageInfo();
        }
        Example example = new Example(EmeRescueTeamRerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("teamId", (Object)gparam.getKeyId()).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (EmeRescueTeamRerson l : list) {
            if (l.getStaffId() == null) continue;
            l.setPersonName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(l.getStaffId()));
        }
        return new PageInfo(list);
    }

    public List<EmeRescueTeamRerson> getEmeRescueTeamRersonList(Long teamId) {
        if (teamId == null) {
            return new ArrayList<EmeRescueTeamRerson>();
        }
        Example example = new Example(EmeRescueTeamRerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("teamId", (Object)teamId).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("person_duty asc");
        List<EmeRescueTeamRerson> list = this.getListByExample(example);
        return list;
    }

    public List<EmeRescueTeamRerson> getMobileList(Long teamId, String keyword) {
        if (teamId == null) {
            return new ArrayList<EmeRescueTeamRerson>();
        }
        Example example = new Example(EmeRescueTeamRerson.class);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            Example.Criteria criteria1 = example.createCriteria();
            criteria1.andEqualTo("teamId", (Object)teamId).andEqualTo("isValid", (Object)Global.TRUE);
            criteria1.andLike("personName", "%" + keyword + "%");
            Example.Criteria criteria2 = example.createCriteria();
            criteria2.andEqualTo("teamId", (Object)teamId).andEqualTo("isValid", (Object)Global.TRUE);
            criteria2.andLike("personDuty", "%" + keyword + "%");
            example.or(criteria2);
        } else {
            Example.Criteria c = example.createCriteria();
            c.andEqualTo("teamId", (Object)teamId).andEqualTo("isValid", (Object)Global.TRUE);
        }
        example.setOrderByClause("person_duty asc");
        List<EmeRescueTeamRerson> list = this.getListByExample(example);
        return list;
    }

    public List<EmeRescueTeamRerson> getMobileList(Long cid, Long teamId, String keyword) {
        List<EmeRescueTeamRerson> list = ((EmeRescueTeamRersonMapper)this.dao).getMobileList(cid, teamId, keyword);
        return list;
    }

    public boolean hasMemeber(EmeRescueTeamRerson rerson) {
        if (rerson.getStaffId() == null) {
            return false;
        }
        Example example = new Example(EmeRescueTeamRerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("staffId", (Object)rerson.getStaffId());
        c.andEqualTo("teamId", (Object)rerson.getTeamId());
        if (rerson.getId() != null) {
            c.andNotEqualTo("id", (Object)rerson.getId());
        }
        c.andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        return list != null && list.size() > 0;
    }

    @Transactional(readOnly=false)
    public void updateInfoByPrimaryKey(EmeRescueTeamRerson emeRescueTeamRerson, Long staffid) {
        emeRescueTeamRerson.setUpdateBy(staffid);
        emeRescueTeamRerson.setUpdateDate(new Date());
        ((EmeRescueTeamRersonMapper)this.dao).updateInfoByPrimaryKey(emeRescueTeamRerson);
    }

    public List<EmeRescueTeamRerson> getEmeRescueTeamRersonLeaderList(Long teamId) {
        if (teamId == null) {
            return new ArrayList<EmeRescueTeamRerson>();
        }
        String[] s = new String[]{"1", "2"};
        List<String> personDutys = Arrays.asList(s);
        Example example = new Example(EmeRescueTeamRerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("teamId", (Object)teamId).andEqualTo("isValid", (Object)Global.TRUE).andIn("personDuty", personDutys);
        example.setOrderByClause("person_duty asc");
        List<EmeRescueTeamRerson> list = this.getListByExample(example);
        for (EmeRescueTeamRerson l : list) {
            if (l.getStaffId() == null) continue;
            l.setPersonName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(l.getStaffId()));
        }
        return list;
    }
}

