/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.work.eme.EmeRescueDeptPersonMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueDeptPerson;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueDeptPersonService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeRescueDeptPersonServiceImpl
extends BaseServiceImpl<EmeRescueDeptPersonMapper, EmeRescueDeptPerson>
implements IEmeRescueDeptPersonService {
    @Autowired
    EmeRescueDeptPersonMapper emeRescueDeptPersonMapper;
    @Autowired
    StaffBasicInfoMapper StaffBasicInfoMapper;
    @Autowired
    IStaffInfoService staffInfoServiceImpl;
    @Autowired
    ICompanyOrganizationService ICompanyOrganizationService;

    public PageInfo<EmeRescueDeptPerson> getEmeRescueDeptPersonContactListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null || gparam.getKeyId() == null) {
            return new PageInfo();
        }
        Example example = new Example(EmeRescueDeptPerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("deptId", (Object)gparam.getKeyId()).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        for (EmeRescueDeptPerson emeRescueDeptPerson : list) {
            this.setProperty(emeRescueDeptPerson);
            if (emeRescueDeptPerson.getOrgChargeStaffId() != null) {
                emeRescueDeptPerson.setRealName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(emeRescueDeptPerson.getOrgChargeStaffId()));
            }
            if (emeRescueDeptPerson.getOrgId() == null) continue;
            emeRescueDeptPerson.setFullName(this.ICompanyOrganizationService.getOrgNameById(emeRescueDeptPerson.getOrgId()));
        }
        return new PageInfo(list);
    }

    public List<EmeRescueDeptPerson> getEmeRescueDeptPersonContactList(Long cid, Long deptId) {
        if (cid == null || deptId == null) {
            return new ArrayList<EmeRescueDeptPerson>();
        }
        Example example = new Example(EmeRescueDeptPerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("deptId", (Object)deptId).andEqualTo("isValid", (Object)Global.TRUE);
        List<EmeRescueDeptPerson> list = this.getListByExample(example);
        for (EmeRescueDeptPerson emeRescueDeptPerson : list) {
            this.setProperty(emeRescueDeptPerson);
        }
        return list;
    }

    public boolean isEmeRescueDeptPerson(EmeRescueDeptPerson person) {
        int isSize;
        if (person == null || person.getCid() == null || person.getOrgId() == null) {
            return false;
        }
        Example example = new Example(EmeRescueDeptPerson.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)person.getCid()).andEqualTo("orgId", (Object)person.getOrgId()).andEqualTo("isValid", (Object)Global.TRUE);
        if (person.getId() != null) {
            c.andNotEqualTo("id", (Object)person.getId());
        }
        return (isSize = this.getCountByExample(example)) > 0;
    }

    public EmeRescueDeptPerson setProperty(EmeRescueDeptPerson emeRescueDeptPerson) {
        if (emeRescueDeptPerson.getOrgId() != null) {
            Long orgId = emeRescueDeptPerson.getOrgId();
            CompanyOrganization companyOrganization = (CompanyOrganization)this.ICompanyOrganizationService.getById(orgId);
            emeRescueDeptPerson.setFullName(companyOrganization.getOrganizationName());
        }
        if (emeRescueDeptPerson.getOrgChargeStaffId() != null) {
            Long orgChargeStaffID = emeRescueDeptPerson.getOrgChargeStaffId();
            StaffInfo staffInfo = this.staffInfoServiceImpl.getStaffInfoWithStaffBasicWorkById(orgChargeStaffID);
            if (staffInfo.getStaffBasicInfo() != null) {
                emeRescueDeptPerson.setUserbasicid(staffInfo.getStaffBasicInfo().getId());
                emeRescueDeptPerson.setRealName(staffInfo.getStaffBasicInfo().getRealName());
                emeRescueDeptPerson.setPhone(staffInfo.getStaffBasicInfo().getMobile());
            }
            if (staffInfo.getStaffBasicWork() != null) {
                emeRescueDeptPerson.setJobTitle(staffInfo.getStaffBasicWork().getJobTitle());
            }
        }
        return emeRescueDeptPerson;
    }

    @Transactional(readOnly=false)
    public void updatePersonByPrimaryKey(EmeRescueDeptPerson emeRescueDeptPerson, Long staffid) {
        emeRescueDeptPerson.setUpdateBy(staffid);
        emeRescueDeptPerson.setUpdateDate(new Date());
        ((EmeRescueDeptPersonMapper)this.dao).updatePersonByPrimaryKey(emeRescueDeptPerson);
    }

    public List<EmeRescueDeptPerson> getMobileEmeRescueDeptPersonContactList(Long cid, String keyword) {
        if (cid == null) {
            return null;
        }
        List<EmeRescueDeptPerson> list = ((EmeRescueDeptPersonMapper)this.dao).getMobileEmeRescueDeptPersonContactList(cid, keyword, SpringEncryptUtils.encrypt((String)keyword));
        if (list == null || list.size() == 0) {
            return list;
        }
        for (EmeRescueDeptPerson emeRescueDeptPerson : list) {
            this.setProperty(emeRescueDeptPerson);
        }
        return list;
    }
}

