/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.eme.EmeReportContactMapper;
import cn.smarthse.modules.health.entity.work.eme.EmeReportContact;
import cn.smarthse.modules.health.service.work.eme.IEmeReportContactService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeReportContactServiceImpl
extends BaseServiceImpl<EmeReportContactMapper, EmeReportContact>
implements IEmeReportContactService {
    @Autowired
    EmeReportContactMapper emeReportContactMapper;

    public PageInfo<EmeReportContact> getEmeReportContactListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (gparam.getCid() == null) {
            return new PageInfo();
        }
        Example example = new Example(EmeReportContact.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("isValid", (Object)Global.TRUE);
        return new PageInfo(this.getListByExample(example));
    }

    public List<EmeReportContact> getEmeReportContactList(Long cid) {
        if (cid == null) {
            return new ArrayList<EmeReportContact>();
        }
        Example example = new Example(EmeReportContact.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        List<EmeReportContact> list = this.getListByExample(example);
        return list;
    }

    public List<EmeReportContact> getMobileList(Long cid, String keyword) {
        if (cid == null) {
            return new ArrayList<EmeReportContact>();
        }
        Example example = new Example(EmeReportContact.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            c.andCondition(String.format(" (person_name like '%%%s%%' or person_company like '%%%s%%')", keyword, keyword));
        }
        List<EmeReportContact> list = this.getListByExample(example);
        return list;
    }
}

