/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.work.eme.EmeDrillMapper;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.eme.EmeDrill;
import cn.smarthse.modules.health.entity.work.eme.EmeDrillFiles;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.eme.IEmeDrillService;
import cn.smarthse.modules.health.service.work.impl.eme.EmeDrillFilesServiceImpl;
import cn.smarthse.modules.health.vo.work.eme.EmeTipVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeDrillServiceImpl
extends BaseServiceImpl<EmeDrillMapper, EmeDrill>
implements IEmeDrillService {
    @Autowired
    EmeDrillFilesServiceImpl filesService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;
    @Autowired
    IStaffInfoService staffInfoService;

    public List<EmeDrill> listDetails(EmeDrill data) {
        DataScopeHelper.startDataScope("emergency", "eme_drill");
        List<EmeDrill> list = ((EmeDrillMapper)this.dao).listDetails(data);
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (EmeDrill l : list) {
            l.setManagerName(SpringEncryptUtils.decrypt((String)l.getManagerName()));
            if (l.getManager() == null) continue;
            l.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getManager()));
        }
        return list;
    }

    private List<EmeDrill> list(EmeDrill data) {
        List<EmeDrill> emeDrills = ((EmeDrillMapper)this.dao).listDetails(data);
        if (CollectionUtil.isNotEmpty(emeDrills)) {
            emeDrills.forEach(e -> e.setManagerName(SpringEncryptUtils.decrypt((String)e.getManagerName())));
        }
        return emeDrills;
    }

    public PageInfo<EmeDrill> listDetails(int pageIndex, EmeDrill data) {
        PageHelper.startPage((int)pageIndex, (int)10);
        List<EmeDrill> list = this.listDetails(data);
        return new PageInfo(list);
    }

    public EmeDrill getDetailById(Long id) {
        EmeDrill drill = ((EmeDrillMapper)this.dao).getDetailById(id);
        if (ObjectUtil.isNotNull((Object)drill)) {
            drill.setManagerName(SpringEncryptUtils.decrypt((String)drill.getManagerName()));
        }
        this.setFiles(drill);
        return drill;
    }

    private void setFiles(EmeDrill drill) {
        if (drill == null || drill.getId() == null) {
            return;
        }
        List<EmeDrillFiles> allFiles = this.filesService.getFilesByPid(drill.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (EmeDrillFiles file : allFiles) {
            switch (file.getFileType()) {
                case 1: {
                    drill.getSchemes().add(file);
                    break;
                }
                case 2: {
                    drill.getRecords().add(file);
                    break;
                }
                case 3: {
                    drill.getSumarries().add(file);
                    break;
                }
                case 4: {
                    drill.getOthers().add(file);
                    break;
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public EmeDrill insertOrUpdate(EmeDrill data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setCid(cid);
        data.setUpdateBy(staffId);
        data.setUpdateDate(new Date());
        if (data.getId() == null) {
            data.setCreateBy(staffId);
            data.setCreateDate(new Date());
            data.setIsValid(Boolean.valueOf(true));
            this.add(data, staffId, cid);
        } else {
            ((EmeDrillMapper)this.dao).updateById(data);
        }
        this.filesService.updateFilesByParent(data);
        return data;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long updateBy) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(EmeDrill.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        EmeDrill drill = new EmeDrill();
        drill.setIsValid(Boolean.valueOf(false));
        drill.setUpdateDate(new Date());
        drill.setUpdateBy(updateBy);
        ((EmeDrillMapper)this.dao).updateByExampleSelective(drill, example);
    }

    public PageInfo<EmeDrill> getDrillList(JqGridParam gparam, EmeDrill param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    private int listCount(Long cid, Byte status) {
        EmeDrill param = new EmeDrill();
        param.setCid(cid);
        param.setStatus(status);
        List<EmeDrill> drills = this.list(param);
        return drills == null ? 0 : drills.size();
    }

    public EmeTipVO getTips(Long cid) {
        EmeTipVO vo = new EmeTipVO();
        int total = 0;
        DataScopeHelper.startDataScope("emergency", "eme_drill");
        DataScope dataScope = DataScopeHelper.getDataScope();
        int unfinishCount = this.listCount(cid, (byte)0);
        vo.setUnfinish(Integer.valueOf(unfinishCount));
        DataScopeHelper.setDataScope(dataScope);
        int finishCount = this.listCount(cid, (byte)1);
        vo.setFinish(Integer.valueOf(finishCount));
        boolean isIgnored = this.sysService.hasIgnoreData(TodlistInfoTypeEnum.emeManagement_oneYear, cid, 1);
        if (isIgnored) {
            vo.setTotal(Integer.valueOf(total));
            return vo;
        }
        EmeDrill drill = new EmeDrill();
        drill.setCid(cid);
        Date lastDate = ((EmeDrillMapper)this.dao).getLastDrillDate(drill);
        Date distanceDate = DateUtils.getDistanceDate((Date)lastDate, (int)1, (int)1);
        Date tipDate = DateUtils.getDistanceDate((Date)distanceDate, (int)5, (int)-1);
        if (tipDate != null && tipDate.getTime() <= new Date().getTime()) {
            ++total;
            vo.setNeedDrilled(Boolean.valueOf(true));
        }
        vo.setTotal(Integer.valueOf(total));
        return vo;
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        if (detail == null) {
            return null;
        }
        EmeDrill data = new EmeDrill();
        data.setType(StringUtils.isEmpty((CharSequence)detail.getWorkSubtype()) ? null : Byte.valueOf(Byte.parseByte(detail.getWorkSubtype())));
        data.setName(detail.getBusinessName());
        data.setNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.EMEDRILL.getCode()));
        data.setStartTime(detail.getBusinessPlantime());
        data.setManager(detail.getManagerId());
        data.setStatus(Byte.valueOf((byte)0));
        data.setIsValid(Boolean.valueOf(true));
        this.add(data, detail.getCreatorBy(), detail.getCid());
        return data.getId();
    }

    @Transactional(readOnly=false)
    public void cancelByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(EmeDrill.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        EmeDrill data = new EmeDrill();
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        data.setStatus(Byte.valueOf((byte)2));
        ((EmeDrillMapper)this.dao).updateByExampleSelective(data, example);
    }
}

