/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.eme;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.eme.EmeDrillFilesMapper;
import cn.smarthse.modules.health.entity.work.eme.EmeDrill;
import cn.smarthse.modules.health.entity.work.eme.EmeDrillFiles;
import cn.smarthse.modules.health.service.work.eme.IEmeDrillFilesService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class EmeDrillFilesServiceImpl
extends BaseServiceImpl<EmeDrillFilesMapper, EmeDrillFiles>
implements IEmeDrillFilesService {
    @Autowired
    EmeDrillFilesMapper emeDrillFilesMapper;

    @Transactional(readOnly=true)
    public void updateFilesByParent(EmeDrill drill) {
        if (drill == null) {
            return;
        }
        this.deleteFilesByPid(drill.getId());
        this.addFilesByType(drill.getSchemes(), drill, (byte)1);
        this.addFilesByType(drill.getRecords(), drill, (byte)2);
        this.addFilesByType(drill.getSumarries(), drill, (byte)3);
        this.addFilesByType(drill.getOthers(), drill, (byte)4);
    }

    private void deleteFilesByPid(Long drillId) {
        if (drillId == null) {
            return;
        }
        Example example = new Example(EmeDrillFiles.class);
        example.createCriteria().andEqualTo("drillId", (Object)drillId);
        ((EmeDrillFilesMapper)this.dao).deleteByExample(example);
    }

    private void addFilesByType(List<EmeDrillFiles> files, EmeDrill drill, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (EmeDrillFiles file : files) {
            if (file.getFileId() == null) continue;
            this.setParentInfos(drill, file);
            file.setFileType(fileType);
            file.setId(Long.valueOf(this.idworker.nextId()));
            this.emeDrillFilesMapper.insert(file);
        }
    }

    private void setParentInfos(EmeDrill drill, EmeDrillFiles file) {
        file.setDrillId(drill.getId());
        file.setCid(drill.getCid());
        file.setCreateBy(drill.getUpdateBy());
        file.setCreateDate(drill.getUpdateDate());
        file.setUpdateBy(drill.getUpdateBy());
        file.setUpdateDate(drill.getUpdateDate());
    }

    public List<EmeDrillFiles> getFilesByPid(Long drillId) {
        if (drillId == null) {
            return null;
        }
        Example example = new Example(EmeDrillFiles.class);
        example.createCriteria().andEqualTo("drillId", (Object)drillId);
        return ((EmeDrillFilesMapper)this.dao).selectByExample(example);
    }
}

